/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import com.sendbird.call.CallRequest;
import com.sendbird.call.shadow.com.google.gson.JsonObject;

class ConnectionLostRequest
extends CallRequest {
    private static final String COMMAND = "CALL";
    private static final String TYPE = "connection_lost";
    private String mCallId;
    private Reason mReason;

    ConnectionLostRequest(String callId, Reason reason) {
        super(COMMAND, TYPE);
        this.mCallId = callId;
        this.mReason = reason;
    }

    @Override
    boolean isAckRequired() {
        return true;
    }

    @Override
    JsonObject getDataObject() {
        JsonObject dataObj = new JsonObject();
        dataObj.addProperty("call_id", this.mCallId);
        dataObj.addProperty("reason", this.mReason.toString().toLowerCase());
        return dataObj;
    }

    static enum Reason {
        PEER_STREAM_LOST;

    }
}

