/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.BaseMessage;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.util.List;

public final class AdminMessage
extends BaseMessage {
    private String mMessage = "";
    private boolean mIsSilent = false;

    static JsonElement build(long msgId, String channelUrl, String channelType, String message, String data, String customType, long createdAt, long updatedAt, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, String mentionedUsers, String metaArray, boolean isGlobalBlocked) {
        JsonObject obj = new JsonObject();
        obj.addProperty("msg_id", msgId);
        obj.addProperty("channel_url", channelUrl);
        obj.addProperty("channel_type", channelType);
        obj.addProperty("ts", createdAt);
        obj.addProperty("updated_at", updatedAt);
        obj.addProperty("message", message);
        if (data != null) {
            obj.addProperty("data", data);
        }
        if (customType != null) {
            obj.addProperty("custom_type", customType);
        }
        if (mentionType == BaseMessageParams.MentionType.USERS) {
            obj.addProperty("mention_type", "users");
        } else if (mentionType == BaseMessageParams.MentionType.CHANNEL) {
            obj.addProperty("mention_type", "channel");
        }
        if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
            JsonArray array = new JsonArray();
            for (String mentionedUserId : mentionedUserIds) {
                if (mentionedUserId == null || mentionedUserId.length() <= 0) continue;
                array.add(mentionedUserId);
            }
            obj.add("mentioned_user_ids", array);
        }
        if (mentionedUsers != null) {
            obj.add("mentioned_users", new JsonParser().parse(mentionedUsers));
        }
        if (metaArray != null) {
            obj.add("metaarray", new JsonParser().parse(metaArray));
        }
        obj.addProperty("is_global_block", isGlobalBlocked);
        return obj;
    }

    AdminMessage(JsonElement el) {
        super(el);
        JsonObject obj = el.getAsJsonObject();
        this.mMessage = obj.get("message").getAsString();
        this.mData = obj.has("data") ? obj.get("data").getAsString() : "";
        this.mCustomType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : "";
        this.mIsSilent = obj.has("silent") && obj.get("silent").getAsBoolean();
    }

    @Override
    JsonElement toJson() {
        JsonObject obj = super.toJson().getAsJsonObject();
        obj.addProperty("type", "ADMM");
        obj.addProperty("message", this.mMessage);
        obj.addProperty("data", this.mData);
        obj.addProperty("custom_type", this.mCustomType);
        return obj;
    }

    public String getMessage() {
        return this.mMessage;
    }

    boolean isSilent() {
        return this.mIsSilent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AdminMessage other = (AdminMessage)o;
        return this.isEquals(other);
    }

    private boolean isEquals(AdminMessage message) {
        if (!super.isEquals(message)) {
            return false;
        }
        if (!this.getMessage().equals(message.getMessage())) {
            return false;
        }
        return this.isSilent() == message.isSilent();
    }
}

