/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.Hashtable;
import java.util.Map;

class ChannelEvent {
    public static final int CATEGORY_NONE = 0;
    public static final int CATEGORY_CHANNEL_ENTER = 10102;
    public static final int CATEGORY_CHANNEL_EXIT = 10103;
    public static final int CATEGORY_USER_CHANNEL_MUTE = 10201;
    public static final int CATEGORY_USER_CHANNEL_UNMUTE = 10200;
    public static final int CATEGORY_USER_CHANNEL_BAN = 10601;
    public static final int CATEGORY_USER_CHANNEL_UNBAN = 10600;
    public static final int CATEGORY_CHANNEL_FREEZE = 10701;
    public static final int CATEGORY_CHANNEL_UNFREEZE = 10700;
    @Deprecated
    public static final int CATEGORY_PROFANITY_MESSAGE_BLOCK = 10800;
    public static final int CATEGORY_TYPING_START = 10900;
    public static final int CATEGORY_TYPING_END = 10901;
    public static final int CATEGORY_CHANNEL_JOIN = 10000;
    public static final int CATEGORY_CHANNEL_LEAVE = 10001;
    public static final int CATEGORY_CHANNEL_INVITE = 10020;
    public static final int CATEGORY_CHANNEL_DECLINE_INVITE = 10022;
    public static final int CATEGORY_CHANNEL_PROP_CHANGED = 11000;
    public static final int CATEGORY_CHANNEL_DELETED = 12000;
    public static final int CATEGORY_CHANNEL_META_DATA_CHANGED = 11100;
    public static final int CATEGORY_CHANNEL_META_COUNTERS_CHANGED = 11200;
    public static final int CATEGORY_CHANNEL_HIDDEN = 13000;
    public static final int CATEGORY_CHANNEL_UNHIDDEN = 13001;
    protected JsonObject obj;
    private int category;
    private Hashtable<String, JsonElement> data;
    private String channelUrl;
    private String channelType;
    private long ts;

    public ChannelEvent(JsonElement el) {
        JsonObject dataObj;
        this.obj = el.getAsJsonObject();
        this.category = this.obj.has("cat") ? this.obj.get("cat").getAsInt() : 0;
        this.data = new Hashtable();
        JsonObject jsonObject = dataObj = this.obj.has("data") ? this.obj.get("data").getAsJsonObject() : null;
        if (dataObj != null) {
            for (Map.Entry<String, JsonElement> entry : dataObj.entrySet()) {
                this.data.put(entry.getKey(), entry.getValue());
            }
        }
        this.channelUrl = this.obj.has("channel_url") ? this.obj.get("channel_url").getAsString() : "";
        this.channelType = this.obj.has("channel_type") ? this.obj.get("channel_type").getAsString() : "group";
        this.ts = this.obj.has("ts") ? this.obj.get("ts").getAsLong() : 0L;
    }

    public JsonElement getData() {
        return this.obj.has("data") ? this.obj.get("data").getAsJsonObject() : null;
    }

    public String getDataAsString(String key) {
        try {
            return this.data.get(key).getAsString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getDataAsInt(String key) {
        try {
            return this.data.get(key).getAsInt();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public long getDataAsLong(String key) {
        try {
            return this.data.get(key).getAsLong();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public boolean getDataAsBoolean(String key) {
        try {
            return this.data.get(key).getAsBoolean();
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getCategory() {
        return this.category;
    }

    public String getChannelUrl() {
        return this.channelUrl;
    }

    long getTs() {
        return this.ts;
    }

    public boolean isGroupChannel() {
        return this.channelType.equals("group");
    }

    public boolean isOpenChannel() {
        return this.channelType.equals("open");
    }
}

