/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.BaseMessage;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.Sender;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class UserMessage
extends BaseMessage {
    private String mMessage = "";
    Sender mSender;
    private String mReqId = "";
    private HashMap<String, String> mTranslations;

    static JsonElement build(String requestId, long msgId, Sender sender, String channelUrl, String channelType, String message, String data, String customType, String translations, long createdAt, long updatedAt, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, String mentionedUsers, String metaArray, boolean isGlobalBlocked) {
        JsonObject obj = new JsonObject();
        obj.addProperty("req_id", requestId);
        obj.addProperty("msg_id", msgId);
        obj.addProperty("channel_url", channelUrl);
        obj.addProperty("channel_type", channelType);
        obj.addProperty("ts", createdAt);
        obj.addProperty("updated_at", updatedAt);
        obj.addProperty("message", message);
        if (data != null) {
            obj.addProperty("data", data);
        }
        if (customType != null) {
            obj.addProperty("custom_type", customType);
        }
        if (translations != null) {
            obj.add("translations", new JsonParser().parse(translations));
        }
        if (sender != null) {
            JsonObject userObj = sender.toJson().getAsJsonObject();
            obj.add("user", userObj);
        }
        if (mentionType == BaseMessageParams.MentionType.USERS) {
            obj.addProperty("mention_type", "users");
        } else if (mentionType == BaseMessageParams.MentionType.CHANNEL) {
            obj.addProperty("mention_type", "channel");
        }
        if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
            JsonArray array = new JsonArray();
            for (String mentionedUserId : mentionedUserIds) {
                if (mentionedUserId == null || mentionedUserId.length() <= 0) continue;
                array.add(mentionedUserId);
            }
            obj.add("mentioned_user_ids", array);
        }
        if (mentionedUsers != null) {
            obj.add("mentioned_users", new JsonParser().parse(mentionedUsers));
        }
        if (metaArray != null) {
            obj.add("metaarray", new JsonParser().parse(metaArray));
        }
        obj.addProperty("is_global_block", isGlobalBlocked);
        return obj;
    }

    UserMessage(JsonElement el) {
        super(el);
        JsonObject obj = el.getAsJsonObject();
        this.mMessage = obj.get("message").getAsString();
        this.mData = obj.has("data") ? obj.get("data").getAsString() : "";
        this.mSender = new Sender(obj.get("user"));
        this.mReqId = obj.has("req_id") ? obj.get("req_id").getAsString() : "";
        this.mCustomType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : "";
        this.mTranslations = new HashMap();
        if (obj.has("translations")) {
            JsonObject transObj = obj.get("translations").getAsJsonObject();
            for (Map.Entry<String, JsonElement> entry : transObj.entrySet()) {
                this.mTranslations.put(entry.getKey(), entry.getValue().getAsString());
            }
        }
    }

    @Override
    JsonElement toJson() {
        JsonObject obj = super.toJson().getAsJsonObject();
        obj.addProperty("type", "MESG");
        obj.addProperty("req_id", this.mReqId);
        obj.addProperty("message", this.mMessage);
        obj.addProperty("data", this.mData);
        obj.addProperty("custom_type", this.mCustomType);
        obj.add("user", this.mSender.toJson());
        JsonObject transObj = new JsonObject();
        for (Map.Entry<String, String> entry : this.mTranslations.entrySet()) {
            transObj.addProperty(entry.getKey(), entry.getValue());
        }
        obj.add("translations", transObj);
        return obj;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public Sender getSender() {
        if (SendBird.Options.useMemberAsMessageSender && GroupChannel.sCachedChannels.containsKey(this.mChannelUrl)) {
            GroupChannel channel = GroupChannel.sCachedChannels.get(this.mChannelUrl);
            User member = channel.mMemberMap.get(this.mSender.getUserId());
            if (member != null) {
                this.mSender.updatePropertiesByUser(member);
            }
        }
        return this.mSender;
    }

    public String getRequestId() {
        return this.mReqId;
    }

    public Map<String, String> getTranslations() {
        return this.mTranslations;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserMessage other = (UserMessage)o;
        return this.isEquals(other);
    }

    private boolean isEquals(UserMessage message) {
        if (!super.isEquals(message)) {
            return false;
        }
        if (!this.getMessage().equals(message.getMessage())) {
            return false;
        }
        if (!this.getSender().equals(message.getSender())) {
            return false;
        }
        if (this.getMessageId() == 0L && message.getMessageId() == 0L && !this.getRequestId().equals(message.getRequestId())) {
            return false;
        }
        return this.getTranslations().equals(message.getTranslations());
    }
}

