/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.util.Base64;
import com.sendbird.android.AdminMessage;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.FileMessage;
import com.sendbird.android.Logger;
import com.sendbird.android.SendBird;
import com.sendbird.android.Sender;
import com.sendbird.android.User;
import com.sendbird.android.UserMessage;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseMessage {
    protected long mMessageId;
    protected String mChannelUrl;
    protected String mChannelType;
    protected String mData = "";
    protected String mCustomType = "";
    protected long mCreatedAt;
    protected long mUpdatedAt;
    protected BaseMessageParams.MentionType mMentionType = BaseMessageParams.MentionType.USERS;
    protected List<User> mMentionedUsers;
    protected Map<String, List<String>> mMetaArray;
    protected boolean mIsGlobalBlocked;

    protected static BaseMessage build(JsonElement el, String channelUrl, String channelType) {
        try {
            String type;
            JsonObject obj = el.getAsJsonObject();
            switch (type = obj.get("type").getAsString()) {
                case "MESG": {
                    String mentionTypeString;
                    String reqId = obj.has("req_id") ? obj.get("req_id").getAsString() : "";
                    Sender sender = new Sender(obj.get("user"));
                    long msgId = obj.get("message_id").getAsLong();
                    String message = obj.get("message").getAsString();
                    String data = obj.get("data").getAsString();
                    long createdAt = obj.get("created_at").getAsLong();
                    long updatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
                    String customType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : null;
                    String translations = obj.has("translations") ? obj.get("translations").toString() : null;
                    BaseMessageParams.MentionType mentionType = BaseMessageParams.MentionType.USERS;
                    if (obj.has("mention_type") && (mentionTypeString = obj.get("mention_type").getAsString()) != null) {
                        if (mentionTypeString.equals("users")) {
                            mentionType = BaseMessageParams.MentionType.USERS;
                        } else if (mentionTypeString.equals("channel")) {
                            mentionType = BaseMessageParams.MentionType.CHANNEL;
                        }
                    }
                    String mentionedUsers = obj.has("mentioned_users") ? obj.get("mentioned_users").toString() : null;
                    String metaArray = obj.has("metaarray") ? obj.get("metaarray").toString() : null;
                    boolean isGlobalBlocked = obj.has("is_global_block") && obj.get("is_global_block").getAsBoolean();
                    return new UserMessage(UserMessage.build(reqId, msgId, sender, channelUrl, channelType, message, data, customType, translations, createdAt, updatedAt, mentionType, null, mentionedUsers, metaArray, isGlobalBlocked));
                }
                case "FILE": {
                    String mentionTypeString;
                    String reqId = obj.has("req_id") ? obj.get("req_id").getAsString() : "";
                    Sender sender = new Sender(obj.get("user"));
                    long msgId = obj.get("message_id").getAsLong();
                    JsonObject file = obj.get("file").getAsJsonObject();
                    String url = file.get("url").getAsString();
                    String name = file.get("name").getAsString();
                    String fileType = file.get("type").getAsString();
                    int size = file.get("size").getAsInt();
                    String data = file.get("data").getAsString();
                    long createdAt = obj.get("created_at").getAsLong();
                    long updatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
                    String customType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : null;
                    String thumbnails = obj.has("thumbnails") ? obj.get("thumbnails").toString() : null;
                    boolean requireAuth = obj.has("require_auth") && obj.get("require_auth").getAsBoolean();
                    BaseMessageParams.MentionType mentionType = BaseMessageParams.MentionType.USERS;
                    if (obj.has("mention_type") && (mentionTypeString = obj.get("mention_type").getAsString()) != null) {
                        if (mentionTypeString.equals("users")) {
                            mentionType = BaseMessageParams.MentionType.USERS;
                        } else if (mentionTypeString.equals("channel")) {
                            mentionType = BaseMessageParams.MentionType.CHANNEL;
                        }
                    }
                    String mentionedUsers = obj.has("mentioned_users") ? obj.get("mentioned_users").toString() : null;
                    String metaArray = obj.has("metaarray") ? obj.get("metaarray").toString() : null;
                    boolean isGlobalBlocked = obj.has("is_global_block") && obj.get("is_global_block").getAsBoolean();
                    return new FileMessage(FileMessage.build(reqId, msgId, sender, channelUrl, channelType, url, name, fileType, size, data, customType, thumbnails, requireAuth, createdAt, updatedAt, mentionType, null, mentionedUsers, metaArray, isGlobalBlocked));
                }
                case "BRDM": 
                case "ADMM": {
                    String mentionTypeString;
                    long msgId = obj.get("message_id").getAsLong();
                    String message = obj.get("message").getAsString();
                    String data = obj.get("data").getAsString();
                    long createdAt = obj.get("created_at").getAsLong();
                    long updatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
                    String customType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : null;
                    BaseMessageParams.MentionType mentionType = BaseMessageParams.MentionType.USERS;
                    if (obj.has("mention_type") && (mentionTypeString = obj.get("mention_type").getAsString()) != null) {
                        if (mentionTypeString.equals("users")) {
                            mentionType = BaseMessageParams.MentionType.USERS;
                        } else if (mentionTypeString.equals("channel")) {
                            mentionType = BaseMessageParams.MentionType.CHANNEL;
                        }
                    }
                    String mentionedUsers = obj.has("mentioned_users") ? obj.get("mentioned_users").toString() : null;
                    String metaArray = obj.has("metaarray") ? obj.get("metaarray").toString() : null;
                    boolean isGlobalBlocked = obj.has("is_global_block") && obj.get("is_global_block").getAsBoolean();
                    return new AdminMessage(AdminMessage.build(msgId, channelUrl, channelType, message, data, customType, createdAt, updatedAt, mentionType, null, mentionedUsers, metaArray, isGlobalBlocked));
                }
            }
            Logger.e("Unknown message type: " + type);
        }
        catch (Exception e) {
            Logger.e(e);
        }
        return null;
    }

    protected BaseMessage(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        this.mMessageId = obj.has("msg_id") ? obj.get("msg_id").getAsLong() : 0L;
        this.mChannelUrl = obj.has("channel_url") ? obj.get("channel_url").getAsString() : "";
        this.mChannelType = obj.has("channel_type") ? obj.get("channel_type").getAsString() : "group";
        this.mCreatedAt = obj.has("ts") ? obj.get("ts").getAsLong() : 0L;
        long l = this.mUpdatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
        if (obj.has("mention_type")) {
            String mentionType = obj.get("mention_type").getAsString();
            if (mentionType.equals("users")) {
                this.mMentionType = BaseMessageParams.MentionType.USERS;
            } else if (mentionType.equals("channel")) {
                this.mMentionType = BaseMessageParams.MentionType.CHANNEL;
            }
        }
        this.mMentionedUsers = new ArrayList<User>();
        if (obj.has("mentioned_users")) {
            JsonArray array = obj.getAsJsonArray("mentioned_users");
            for (int i = 0; i < array.size(); ++i) {
                this.mMentionedUsers.add(new User(array.get(i)));
            }
        }
        this.mMetaArray = new HashMap<String, List<String>>();
        if (obj.has("metaarray")) {
            JsonObject metaArrayObj = obj.getAsJsonObject("metaarray");
            for (String key : metaArrayObj.keySet()) {
                if (key == null) continue;
                ArrayList<String> values = new ArrayList<String>();
                JsonArray array = metaArrayObj.get(key).getAsJsonArray();
                for (int i = 0; i < array.size(); ++i) {
                    String value = array.get(i).getAsString();
                    values.add(value);
                }
                this.mMetaArray.put(key, values);
            }
        }
        this.mIsGlobalBlocked = obj.has("is_global_block") && obj.get("is_global_block").getAsBoolean();
    }

    JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("message_id", this.mMessageId);
        obj.addProperty("channel_url", this.mChannelUrl);
        obj.addProperty("channel_type", this.mChannelType);
        obj.addProperty("created_at", this.mCreatedAt);
        obj.addProperty("updated_at", this.mUpdatedAt);
        if (this.mMentionType == BaseMessageParams.MentionType.USERS) {
            obj.addProperty("mention_type", "users");
        } else if (this.mMentionType == BaseMessageParams.MentionType.CHANNEL) {
            obj.addProperty("mention_type", "channel");
        }
        if (this.mMentionedUsers != null && this.mMentionedUsers.size() > 0) {
            JsonArray array = new JsonArray();
            for (User mentionedUser : this.mMentionedUsers) {
                if (mentionedUser == null) continue;
                array.add(mentionedUser.toJson());
            }
            obj.add("mentioned_users", array);
        }
        if (this.mMetaArray != null && this.mMetaArray.size() > 0) {
            JsonObject metaArrayObj = new JsonObject();
            for (String key : this.mMetaArray.keySet()) {
                if (key == null) continue;
                List<String> values = this.mMetaArray.get(key);
                JsonArray array = new JsonArray();
                for (int i = 0; i < values.size(); ++i) {
                    String value = values.get(i);
                    array.add(value);
                }
                metaArrayObj.add(key, array);
            }
            obj.add("metaarray", metaArrayObj);
        }
        obj.addProperty("is_global_block", this.mIsGlobalBlocked);
        return obj;
    }

    public static BaseMessage buildFromSerializedData(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(data[i] ^ i & 0xFF);
        }
        try {
            String str = new String(Base64.decode((byte[])data, (int)0), "UTF-8");
            JsonObject obj = new JsonParser().parse(str).getAsJsonObject();
            return BaseMessage.build(obj, obj.get("channel_url").getAsString(), obj.get("channel_type").getAsString());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getMessageId() {
        return this.mMessageId;
    }

    public long getCreatedAt() {
        return this.mCreatedAt;
    }

    public long getUpdatedAt() {
        return this.mUpdatedAt;
    }

    public BaseMessageParams.MentionType getMentionType() {
        return this.mMentionType;
    }

    public List<User> getMentionedUsers() {
        return this.mMentionedUsers;
    }

    List<String> getMentionedUserIds() {
        ArrayList<String> mentionedUserIds = null;
        if (this.mMentionedUsers != null && this.mMentionedUsers.size() > 0) {
            mentionedUserIds = new ArrayList<String>();
            for (User mentionedUser : this.mMentionedUsers) {
                if (mentionedUser == null || mentionedUser.getUserId() == null || mentionedUser.getUserId().length() <= 0) continue;
                mentionedUserIds.add(mentionedUser.getUserId());
            }
        }
        return mentionedUserIds;
    }

    boolean isMentionedFromSomeoneToMe(User sender) {
        String currentUserId;
        boolean result = false;
        String string = currentUserId = SendBird.getCurrentUser() != null ? SendBird.getCurrentUser().getUserId() : null;
        if (sender == null || currentUserId != null && !currentUserId.equals(sender.getUserId())) {
            if (this.mMentionType == BaseMessageParams.MentionType.CHANNEL) {
                result = true;
            } else if (currentUserId != null && currentUserId.length() > 0 && this.mMentionedUsers != null && this.mMentionedUsers.size() > 0) {
                for (User mentionedUser : this.mMentionedUsers) {
                    if (!mentionedUser.getUserId().equals(currentUserId)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    public String getChannelUrl() {
        return this.mChannelUrl;
    }

    public boolean isOpenChannel() {
        return this.mChannelType.equals("open");
    }

    public boolean isGroupChannel() {
        return this.mChannelType.equals("group");
    }

    public String getData() {
        return this.mData;
    }

    public String getCustomType() {
        return this.mCustomType;
    }

    public Map<String, List<String>> getAllMetaArray() {
        return this.mMetaArray;
    }

    public Map<String, List<String>> getMetaArray(Collection<String> metaArrayKeys) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        if (this.mMetaArray != null && metaArrayKeys != null && metaArrayKeys.size() > 0) {
            for (String key : metaArrayKeys) {
                if (key == null || !this.mMetaArray.containsKey(key)) continue;
                resultMap.put(key, this.mMetaArray.get(key));
            }
        }
        return resultMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        BaseMessage other = (BaseMessage)o;
        return this.isEquals(other);
    }

    boolean isEquals(BaseMessage message) {
        if (this.getMessageId() != message.getMessageId()) {
            return false;
        }
        if (!this.getChannelUrl().equals(message.getChannelUrl())) {
            return false;
        }
        if (!this.mChannelType.equals(message.mChannelType)) {
            return false;
        }
        if (!this.getData().equals(message.getData())) {
            return false;
        }
        if (!this.getCustomType().equals(message.getCustomType())) {
            return false;
        }
        if (this.getCreatedAt() != message.getCreatedAt()) {
            return false;
        }
        if (this.getUpdatedAt() != message.getUpdatedAt()) {
            return false;
        }
        if (this.getMentionType() != message.getMentionType()) {
            return false;
        }
        if (!this.getMentionedUsers().equals(message.getMentionedUsers())) {
            return false;
        }
        if (!this.getAllMetaArray().equals(message.getAllMetaArray())) {
            return false;
        }
        return this.mIsGlobalBlocked == message.mIsGlobalBlocked;
    }
}

