/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public final class GroupChannelListQuery {
    private static final String ORDER_LATEST_LAST_MESSAGE = "latest_last_message";
    private static final String ORDER_CHRONOLOGICAL = "chronological";
    private static final String ORDER_CHANNEL_NAME_ALPHABETICAL = "channel_name_alphabetical";
    static final String ORDER_METADATA_VALUE_ALPHABETICAL = "metadata_value_alphabetical";
    private static final String MEMBER_STATE_ALL = "all";
    private static final String MEMBER_STATE_INVITED_ONLY = "invited_only";
    private static final String MEMBER_STATE_INVITED_BY_FRIEND_ONLY = "invited_by_friend";
    private static final String MEMBER_STATE_INVITED_BY_NON_FRIEND_ONLY = "invited_by_non_friend";
    private static final String MEMBER_STATE_JOINED_ONLY = "joined_only";
    private final User mUser;
    private String mToken = "";
    private boolean mHasNext = true;
    private int mLimit = 20;
    private boolean mLoading = false;
    private boolean mIncludeEmpty = false;
    private String mOrder = "latest_last_message";
    private String mMetaDataOrderKey;
    private FilterMode mFilterMode = FilterMode.ALL;
    private QueryType mQueryType = QueryType.AND;
    private ArrayList<String> mFilter;
    private String mCustomType;
    private String mCustomTypeStartsWith;
    private String mMemberState = "all";
    private ArrayList<String> mChannelUrls;
    private String mNameContains;
    private ArrayList<String> mCustomTypes;
    private SuperChannelFilter mSuperChannelFilter = SuperChannelFilter.ALL;
    private PublicChannelFilter mPublicChannelFilter = PublicChannelFilter.ALL;
    private UnreadChannelFilter mUnreadChannelFilter = UnreadChannelFilter.ALL;
    private HiddenChannelFilter mHiddenChannelFilter = HiddenChannelFilter.UNHIDDEN;

    GroupChannelListQuery(User user) {
        this.mUser = user;
    }

    public int getLimit() {
        return this.mLimit;
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public boolean isIncludeEmpty() {
        return this.mIncludeEmpty;
    }

    public void setIncludeEmpty(boolean includeEmpty) {
        this.mIncludeEmpty = includeEmpty;
    }

    public Order getOrder() {
        if (this.mOrder.equals(ORDER_CHRONOLOGICAL)) {
            return Order.CHRONOLOGICAL;
        }
        if (this.mOrder.equals(ORDER_CHANNEL_NAME_ALPHABETICAL)) {
            return Order.CHANNEL_NAME_ALPHABETICAL;
        }
        if (this.mOrder.equals(ORDER_METADATA_VALUE_ALPHABETICAL)) {
            return Order.METADATA_VALUE_ALPHABETICAL;
        }
        return Order.LATEST_LAST_MESSAGE;
    }

    public void setOrder(Order order) {
        this.mOrder = order == Order.CHRONOLOGICAL ? ORDER_CHRONOLOGICAL : (order == Order.CHANNEL_NAME_ALPHABETICAL ? ORDER_CHANNEL_NAME_ALPHABETICAL : (order == Order.METADATA_VALUE_ALPHABETICAL ? ORDER_METADATA_VALUE_ALPHABETICAL : ORDER_LATEST_LAST_MESSAGE));
    }

    public String getMetaDataOrderKeyFilter() {
        return this.mMetaDataOrderKey;
    }

    public void setMetaDataOrderKeyFilter(String metaDataOrderKey) {
        this.mMetaDataOrderKey = metaDataOrderKey;
    }

    public String getNicknameContainsFilter() {
        if (this.mFilterMode != FilterMode.MEMBERS_NICKNAME_CONTAINS || this.mFilter == null) {
            return null;
        }
        return this.mFilter.get(0);
    }

    public void setNicknameContainsFilter(String nickname) {
        if (nickname == null || nickname.length() == 0) {
            this.mFilterMode = FilterMode.ALL;
            return;
        }
        this.mFilterMode = FilterMode.MEMBERS_NICKNAME_CONTAINS;
        this.mFilter = new ArrayList();
        this.mFilter.add(nickname);
    }

    @Deprecated
    public void setUserIdsFilter(List<String> userIds, boolean exactMatch) {
        if (userIds == null) {
            this.mFilterMode = FilterMode.ALL;
            return;
        }
        this.mFilterMode = exactMatch ? FilterMode.MEMBERS_EXACTLY_IN : FilterMode.MEMBERS_INCLUDE_IN;
        this.mFilter = new ArrayList();
        this.mFilter.addAll(userIds);
    }

    public List<String> getUserIdsIncludeFilter() {
        if (this.mFilterMode != FilterMode.MEMBERS_INCLUDE_IN || this.mFilter == null) {
            return null;
        }
        return new ArrayList<String>(this.mFilter);
    }

    public QueryType getUserIdsIncludeFilterQueryType() {
        return this.mQueryType;
    }

    public void setUserIdsIncludeFilter(List<String> userIds, QueryType queryType) {
        if (userIds == null) {
            this.mFilterMode = FilterMode.ALL;
            return;
        }
        this.mFilterMode = FilterMode.MEMBERS_INCLUDE_IN;
        this.mQueryType = queryType;
        this.mFilter = new ArrayList();
        this.mFilter.addAll(userIds);
    }

    public List<String> getUserIdsExactFilter() {
        if (this.mFilterMode != FilterMode.MEMBERS_EXACTLY_IN || this.mFilter == null) {
            return null;
        }
        return new ArrayList<String>(this.mFilter);
    }

    public void setUserIdsExactFilter(List<String> userIds) {
        if (userIds == null) {
            this.mFilterMode = FilterMode.ALL;
            return;
        }
        this.mFilterMode = FilterMode.MEMBERS_EXACTLY_IN;
        this.mFilter = new ArrayList();
        this.mFilter.addAll(userIds);
    }

    @Deprecated
    public void setCustomTypeFilter(String customType) {
        this.mCustomType = customType;
    }

    public String getCustomTypeStartsWithFilter() {
        return this.mCustomTypeStartsWith;
    }

    public void setCustomTypeStartsWithFilter(String customType) {
        this.mCustomTypeStartsWith = customType;
    }

    public List<String> getCustomTypesFilter() {
        return this.mCustomTypes;
    }

    public void setCustomTypesFilter(List<String> customTypes) {
        if (customTypes == null || customTypes.size() <= 0) {
            return;
        }
        this.mCustomTypes = new ArrayList();
        this.mCustomTypes.addAll(customTypes);
    }

    @Deprecated
    public void setMemberStateFilter(MemberState memberState) {
        this.mMemberState = memberState == MemberState.INVITED_ONLY ? MEMBER_STATE_INVITED_ONLY : (memberState == MemberState.JOINED_ONLY ? MEMBER_STATE_JOINED_ONLY : MEMBER_STATE_ALL);
    }

    @Deprecated
    public void setMemberStateFilter(GroupChannel.MemberState memberState) {
        this.mMemberState = memberState == GroupChannel.MemberState.INVITED ? MEMBER_STATE_INVITED_ONLY : (memberState == GroupChannel.MemberState.INVITED_BY_FRIEND ? MEMBER_STATE_INVITED_BY_FRIEND_ONLY : (memberState == GroupChannel.MemberState.INVITED_BY_NON_FRIEND ? MEMBER_STATE_INVITED_BY_NON_FRIEND_ONLY : (memberState == GroupChannel.MemberState.JOINED ? MEMBER_STATE_JOINED_ONLY : MEMBER_STATE_ALL)));
    }

    public MemberStateFilter getMemberStateFilter() {
        if (this.mMemberState.equals(MEMBER_STATE_INVITED_ONLY)) {
            return MemberStateFilter.INVITED;
        }
        if (this.mMemberState.equals(MEMBER_STATE_INVITED_BY_FRIEND_ONLY)) {
            return MemberStateFilter.INVITED_BY_FRIEND;
        }
        if (this.mMemberState.equals(MEMBER_STATE_INVITED_BY_NON_FRIEND_ONLY)) {
            return MemberStateFilter.INVITED_BY_NON_FRIEND;
        }
        if (this.mMemberState.equals(MEMBER_STATE_JOINED_ONLY)) {
            return MemberStateFilter.JOINED;
        }
        return MemberStateFilter.ALL;
    }

    public void setMemberStateFilter(MemberStateFilter memberStateFilter) {
        this.mMemberState = memberStateFilter == MemberStateFilter.INVITED ? MEMBER_STATE_INVITED_ONLY : (memberStateFilter == MemberStateFilter.INVITED_BY_FRIEND ? MEMBER_STATE_INVITED_BY_FRIEND_ONLY : (memberStateFilter == MemberStateFilter.INVITED_BY_NON_FRIEND ? MEMBER_STATE_INVITED_BY_NON_FRIEND_ONLY : (memberStateFilter == MemberStateFilter.JOINED ? MEMBER_STATE_JOINED_ONLY : MEMBER_STATE_ALL)));
    }

    public List<String> getChannelUrlsFilter() {
        return this.mChannelUrls;
    }

    public void setChannelUrlsFilter(List<String> channelUrls) {
        if (channelUrls == null || channelUrls.size() <= 0) {
            return;
        }
        this.mChannelUrls = new ArrayList();
        this.mChannelUrls.addAll(channelUrls);
    }

    public String getChannelNameContainsFilter() {
        return this.mNameContains;
    }

    public void setChannelNameContainsFilter(String channelName) {
        this.mNameContains = channelName;
    }

    public SuperChannelFilter getSuperChannelFilter() {
        return this.mSuperChannelFilter;
    }

    public void setSuperChannelFilter(SuperChannelFilter superChannelFilter) {
        this.mSuperChannelFilter = superChannelFilter;
    }

    public PublicChannelFilter getPublicChannelFilter() {
        return this.mPublicChannelFilter;
    }

    public void setPublicChannelFilter(PublicChannelFilter publicChannelFilter) {
        this.mPublicChannelFilter = publicChannelFilter;
    }

    public UnreadChannelFilter getUnreadChannelFilter() {
        return this.mUnreadChannelFilter;
    }

    public void setUnreadChannelFilter(UnreadChannelFilter unreadChannelFilter) {
        this.mUnreadChannelFilter = unreadChannelFilter;
    }

    public HiddenChannelFilter getHiddenChannelFilter() {
        return this.mHiddenChannelFilter;
    }

    public void setHiddenChannelFilter(HiddenChannelFilter hiddenChannelFilter) {
        this.mHiddenChannelFilter = hiddenChannelFilter;
    }

    public boolean hasNext() {
        return this.mHasNext;
    }

    public synchronized boolean isLoading() {
        return this.mLoading;
    }

    synchronized void setLoading(boolean tf) {
        this.mLoading = tf;
    }

    public synchronized void next(final GroupChannelListQueryResultHandler handler) {
        if (!this.hasNext()) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new ArrayList<GroupChannel>(), null);
                    }
                });
            }
            return;
        }
        if (this.isLoading()) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Query in progress.", 800170));
                    }
                });
            }
            return;
        }
        this.setLoading(true);
        APIClient.getInstance().loadUserGroupChannelList(this.mToken, this.mLimit, this.mIncludeEmpty, this.mOrder, this.mMetaDataOrderKey, this.mFilterMode, this.mFilter, this.mQueryType, this.mCustomType, this.mCustomTypeStartsWith, this.mMemberState, this.mChannelUrls, this.mNameContains, this.mCustomTypes, this.mSuperChannelFilter, this.mPublicChannelFilter, this.mUnreadChannelFilter, this.mHiddenChannelFilter, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                GroupChannelListQuery.this.setLoading(false);
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                GroupChannelListQuery.this.mToken = result.get("next").getAsString();
                if (GroupChannelListQuery.this.mToken == null || GroupChannelListQuery.this.mToken.length() <= 0) {
                    GroupChannelListQuery.this.mHasNext = false;
                }
                JsonArray channelObjs = result.get("channels").getAsJsonArray();
                final ArrayList<GroupChannel> channels = new ArrayList<GroupChannel>();
                for (int i = 0; i < channelObjs.size(); ++i) {
                    channels.add(GroupChannel.upsert(channelObjs.get(i), false));
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(channels, null);
                        }
                    });
                }
            }
        });
    }

    public static interface GroupChannelListQueryResultHandler {
        public void onResult(List<GroupChannel> var1, SendBirdException var2);
    }

    static enum FilterMode {
        ALL,
        MEMBERS_EXACTLY_IN,
        MEMBERS_NICKNAME_CONTAINS,
        MEMBERS_INCLUDE_IN;

    }

    public static enum HiddenChannelFilter {
        UNHIDDEN,
        HIDDEN,
        HIDDEN_ALLOW_AUTO_UNHIDE,
        HIDDEN_PREVENT_AUTO_UNHIDE;

    }

    public static enum UnreadChannelFilter {
        ALL,
        UNREAD_MESSAGE;

    }

    public static enum PublicChannelFilter {
        ALL,
        PUBLIC,
        PRIVATE;

    }

    public static enum SuperChannelFilter {
        ALL,
        SUPER_CHANNEL_ONLY,
        NONSUPER_CHANNEL_ONLY;

    }

    public static enum MemberStateFilter {
        ALL,
        INVITED,
        INVITED_BY_FRIEND,
        INVITED_BY_NON_FRIEND,
        JOINED;

    }

    @Deprecated
    public static enum MemberState {
        ALL,
        INVITED_ONLY,
        JOINED_ONLY;

    }

    public static enum QueryType {
        AND,
        OR;

    }

    public static enum Order {
        CHRONOLOGICAL,
        LATEST_LAST_MESSAGE,
        CHANNEL_NAME_ALPHABETICAL,
        METADATA_VALUE_ALPHABETICAL;

    }
}

