/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.Sender;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;

public final class FileMessage
extends BaseMessage {
    Sender mSender;
    private String mUrl;
    private String mName;
    private int mSize;
    private String mType;
    private String mReqId = "";
    private List<Thumbnail> mThumbnails;
    private boolean mRequireAuth;

    static JsonElement build(String requestId, long msgId, Sender sender, String channelUrl, String channelType, String url, String name, String type, int size, String data, String customType, String thumbnails, boolean requireAuth, long createdAt, long updatedAt, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, String mentionedUsers, String metaArray, boolean isGlobalBlocked) {
        JsonObject obj = new JsonObject();
        obj.addProperty("req_id", requestId);
        obj.addProperty("msg_id", msgId);
        obj.addProperty("channel_url", channelUrl);
        obj.addProperty("channel_type", channelType);
        obj.addProperty("ts", createdAt);
        obj.addProperty("updated_at", updatedAt);
        obj.addProperty("url", url);
        obj.addProperty("name", name);
        obj.addProperty("type", type);
        obj.addProperty("size", size);
        if (data != null) {
            obj.addProperty("custom", data);
        }
        if (customType != null) {
            obj.addProperty("custom_type", customType);
        }
        if (thumbnails != null) {
            obj.add("thumbnails", new JsonParser().parse(thumbnails));
        }
        if (requireAuth) {
            obj.addProperty("require_auth", requireAuth);
        }
        if (sender != null) {
            JsonObject userObj = sender.toJson().getAsJsonObject();
            obj.add("user", userObj);
        }
        if (mentionType == BaseMessageParams.MentionType.USERS) {
            obj.addProperty("mention_type", "users");
        } else if (mentionType == BaseMessageParams.MentionType.CHANNEL) {
            obj.addProperty("mention_type", "channel");
        }
        if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
            JsonArray array = new JsonArray();
            for (String mentionedUserId : mentionedUserIds) {
                if (mentionedUserId == null || mentionedUserId.length() <= 0) continue;
                array.add(mentionedUserId);
            }
            obj.add("mentioned_user_ids", array);
        }
        if (mentionedUsers != null) {
            obj.add("mentioned_users", new JsonParser().parse(mentionedUsers));
        }
        if (metaArray != null) {
            obj.add("metaarray", new JsonParser().parse(metaArray));
        }
        obj.addProperty("is_global_block", isGlobalBlocked);
        return obj;
    }

    FileMessage(JsonElement el) {
        super(el);
        JsonObject obj = el.getAsJsonObject();
        this.mSender = new Sender(obj.get("user"));
        this.mUrl = obj.get("url").getAsString();
        this.mName = obj.has("name") ? obj.get("name").getAsString() : "File";
        this.mSize = obj.get("size").getAsInt();
        this.mType = obj.get("type").getAsString();
        this.mData = obj.has("custom") ? obj.get("custom").getAsString() : "";
        this.mReqId = obj.has("req_id") ? obj.get("req_id").getAsString() : "";
        this.mCustomType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : "";
        this.mRequireAuth = obj.has("require_auth") && obj.get("require_auth").getAsBoolean();
        this.mThumbnails = new ArrayList<Thumbnail>();
        if (obj.has("thumbnails")) {
            JsonArray thumbnailsArray = obj.get("thumbnails").getAsJsonArray();
            for (JsonElement element : thumbnailsArray) {
                Thumbnail thumbnail = new Thumbnail(element, this.mRequireAuth);
                this.mThumbnails.add(thumbnail);
            }
        }
    }

    @Override
    JsonElement toJson() {
        JsonObject obj = super.toJson().getAsJsonObject();
        obj.addProperty("type", "FILE");
        obj.addProperty("req_id", this.mReqId);
        JsonObject fileObj = new JsonObject();
        fileObj.addProperty("url", this.mUrl);
        fileObj.addProperty("name", this.mName);
        fileObj.addProperty("type", this.mType);
        fileObj.addProperty("size", this.mSize);
        fileObj.addProperty("data", this.mData);
        obj.add("file", fileObj);
        obj.addProperty("custom_type", this.mCustomType);
        obj.add("user", this.mSender.toJson());
        if (this.mRequireAuth) {
            obj.addProperty("require_auth", this.mRequireAuth);
        }
        JsonArray thumbnailObj = new JsonArray();
        for (Thumbnail thumbnail : this.mThumbnails) {
            thumbnailObj.add(thumbnail.toJson());
        }
        obj.add("thumbnails", thumbnailObj);
        return obj;
    }

    String getOriginalUrl() {
        return this.mUrl;
    }

    boolean requiredAuth() {
        return this.mRequireAuth;
    }

    public String getRequestId() {
        return this.mReqId;
    }

    public Sender getSender() {
        if (SendBird.Options.useMemberAsMessageSender && GroupChannel.sCachedChannels.containsKey(this.mChannelUrl)) {
            GroupChannel channel = GroupChannel.sCachedChannels.get(this.mChannelUrl);
            User member = channel.mMemberMap.get(this.mSender.getUserId());
            if (member != null) {
                this.mSender.updatePropertiesByUser(member);
            }
        }
        return this.mSender;
    }

    public String getUrl() {
        if (this.mRequireAuth) {
            return String.format("%s?auth=%s", this.mUrl, APIClient.getInstance().getEKey());
        }
        return this.mUrl;
    }

    public String getName() {
        return this.mName;
    }

    public int getSize() {
        return this.mSize;
    }

    public String getType() {
        return this.mType;
    }

    public List<Thumbnail> getThumbnails() {
        return this.mThumbnails;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileMessage other = (FileMessage)o;
        return this.isEquals(other);
    }

    private boolean isEquals(FileMessage other) {
        if (!super.isEquals(other)) {
            return false;
        }
        if (!this.getSender().equals(other.getSender())) {
            return false;
        }
        if (!this.getUrl().equals(other.getUrl())) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (!this.getType().equals(other.getType())) {
            return false;
        }
        if (this.getMessageId() == 0L && other.getMessageId() == 0L && !this.getRequestId().equals(other.getRequestId())) {
            return false;
        }
        if (!this.getThumbnails().equals(other.getThumbnails())) {
            return false;
        }
        if (!this.getOriginalUrl().equals(other.getOriginalUrl())) {
            return false;
        }
        return this.requiredAuth() == other.requiredAuth();
    }

    public static class ThumbnailSize {
        private int mMaxWidth;
        private int mMaxHeight;

        public ThumbnailSize(int maxWidth, int maxHeight) {
            this.mMaxWidth = maxWidth >= 0 ? maxWidth : 0;
            this.mMaxHeight = maxHeight >= 0 ? maxHeight : 0;
        }

        public int getMaxWidth() {
            return this.mMaxWidth;
        }

        public int getMaxHeight() {
            return this.mMaxHeight;
        }
    }

    public static class Thumbnail {
        private int mMaxWidth;
        private int mMaxHeight;
        private int mRealWidth;
        private int mRealHeight;
        private String mUrl;
        private boolean mRequireAuth;

        private Thumbnail(JsonElement el, boolean requireAuth) {
            JsonObject obj = el.getAsJsonObject();
            this.mMaxWidth = obj.has("width") ? obj.get("width").getAsInt() : 0;
            this.mMaxHeight = obj.has("height") ? obj.get("height").getAsInt() : 0;
            this.mRealWidth = obj.has("real_width") ? obj.get("real_width").getAsInt() : -1;
            this.mRealHeight = obj.has("real_height") ? obj.get("real_height").getAsInt() : -1;
            this.mUrl = obj.has("url") ? obj.get("url").getAsString() : "";
            this.mRequireAuth = requireAuth;
        }

        public int getMaxWidth() {
            return this.mMaxWidth;
        }

        public int getMaxHeight() {
            return this.mMaxHeight;
        }

        public int getRealWidth() {
            return this.mRealWidth;
        }

        public int getRealHeight() {
            return this.mRealHeight;
        }

        public String getUrl() {
            if (this.mRequireAuth) {
                return String.format("%s?auth=%s", this.mUrl, APIClient.getInstance().getEKey());
            }
            return this.mUrl;
        }

        String getOriginalUrl() {
            return this.mUrl;
        }

        JsonElement toJson() {
            JsonObject obj = new JsonObject();
            obj.addProperty("width", this.mMaxWidth);
            obj.addProperty("height", this.mMaxHeight);
            obj.addProperty("real_width", this.mRealWidth);
            obj.addProperty("real_height", this.mRealHeight);
            obj.addProperty("url", this.mUrl);
            return obj;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            Thumbnail other = (Thumbnail)o;
            if (this.getMaxWidth() != other.getMaxWidth()) {
                return false;
            }
            if (this.getMaxHeight() != other.getMaxHeight()) {
                return false;
            }
            if (this.getRealWidth() != other.getRealWidth()) {
                return false;
            }
            if (this.getRealHeight() != other.getRealHeight()) {
                return false;
            }
            if (!this.getUrl().equals(other.getUrl())) {
                return false;
            }
            return this.mRequireAuth == other.mRequireAuth;
        }
    }
}

