/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.preference.PreferenceManager;
import com.sendbird.android.APIClient;
import com.sendbird.android.AdminMessage;
import com.sendbird.android.ApplicationUserListQuery;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.BlockedUserListQuery;
import com.sendbird.android.ChannelEvent;
import com.sendbird.android.Command;
import com.sendbird.android.ConnectionManager;
import com.sendbird.android.CountDownTimer;
import com.sendbird.android.FileMessage;
import com.sendbird.android.FriendListQuery;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelListQuery;
import com.sendbird.android.GroupChannelTotalUnreadMessageCountParams;
import com.sendbird.android.Logger;
import com.sendbird.android.Member;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.ReadStatus;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.Sender;
import com.sendbird.android.User;
import com.sendbird.android.UserEvent;
import com.sendbird.android.UserListQuery;
import com.sendbird.android.UserMessage;
import com.sendbird.android.WSClient;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SendBird {
    private static final String VERSION = "3.0.82";
    private static final int CMD_ACK_TIMEOUT = 10000;
    static final BuildConfig BUILD_CONFIG = BuildConfig.RELEASE;
    static String CUSTOM_WS_HOST;
    static String CUSTOM_API_HOST;
    private static SendBird sInstance;
    private static final Handler sUIThreadHandler;
    private String mAppId;
    private final Context mAppContext;
    private String mPushToken;
    private WSClient mWSClient;
    private User mCurrentUser;
    private int mReconnectDelay = 0;
    private int mReconnectCount;
    private boolean mConnecting = false;
    private boolean mReconnecting = false;
    private boolean mReconnectingFromOnError = false;
    private boolean mReconnectStartedFromOnError = false;
    private boolean mIsAppBackground;
    private static final int INITIAL_DELAY = 0;
    private CountDownTimer mReconnectTimer;
    private CountDownTimer mLoginTimer;
    private CountDownTimer mGlobalTimer;
    private SendBirdException mLoginException;
    private final Object mLoginTimerLock = new Object();
    private final Object mGlobalTimerLock = new Object();
    private final Object mReconnectTimerLock = new Object();
    private final Object mWSClientLock = new Object();
    private final Object mAckStateMapLock = new Object();
    private final Object mConnectingLock = new Object();
    private final Object mReconnectingLock = new Object();
    private final HashMap<String, HashMap<String, Object>> mAckStateMap = new HashMap();
    final ConcurrentHashMap<String, ChannelHandler> mChannelHandlers = new ConcurrentHashMap();
    final ConcurrentHashMap<String, UserEventHandler> mUserEventHandlers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConnectionHandler> mConnectionHandlers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, LocalNetworkHandler> mLocalNetworkHandlers = new ConcurrentHashMap();
    private final LinkedHashSet<ConnectHandler> mConnectHandlers = new LinkedHashSet();
    private final LinkedHashSet<Timer> mAuthenticationTimers = new LinkedHashSet();
    private ApplicationStateHandler mApplicationStateHandler;
    private boolean mIsTrackingApplicationState = true;
    private boolean mIsNetworkAwarenessReconnection = true;
    private ConnectivityManager mConnectivityManager;
    private NetworkReceiver mNetworkReceiver;
    private String mPrefApiHost;
    private String mPrefWsHost;
    private long mLastConnectedAt = 0L;
    private final SubscribedUnreadMessageCount mSubscribedUnreadMessageCount = new SubscribedUnreadMessageCount();
    public static final int LOGGER_NONE = 0;
    public static final int LOGGER_INFO = 1;
    public static final String PUSH_TEMPLATE_DEFAULT = "default";
    public static final String PUSH_TEMPLATE_ALTERNATIVE = "alternative";

    public static String getOSVersion() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    public static String getSDKVersion() {
        return VERSION;
    }

    public static String getApplicationId() {
        return SendBird.getInstance().mAppId;
    }

    private boolean setApplicationId(String appId) {
        boolean result = false;
        if (appId != null && appId.length() > 0) {
            if (appId.equals(SendBird.getApplicationId())) {
                result = true;
            } else {
                SendBird sendBird = SendBird.getInstance();
                if (sendBird != null && SendBird.getConnectionState() == ConnectionState.CLOSED) {
                    sendBird.setAppId(appId, true);
                    result = true;
                }
            }
        }
        return result;
    }

    public static void setLoggerLevel(int level) {
        Logger.sLevel = level;
    }

    private void setAppId(String appId, boolean resetHosts) {
        this.mAppId = appId;
        this.mPrefApiHost = "com.sendbird." + this.mAppId + ".PREF_API_HOST";
        this.mPrefWsHost = "com.sendbird." + this.mAppId + ".PREF_WS_HOST";
        if (resetHosts) {
            APIClient.getInstance().initCheckRouting();
        }
    }

    private SendBird(String appId, Context context) {
        this.setAppId(appId, false);
        this.mAppContext = context;
        if (context != null) {
            this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            this.mNetworkReceiver = new NetworkReceiver();
            context.registerReceiver((BroadcastReceiver)this.mNetworkReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        if (Build.VERSION.SDK_INT >= 14 && context instanceof Application) {
            ((Application)context).registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                }

                public void onActivityStarted(Activity activity) {
                }

                public void onActivityResumed(Activity activity) {
                    if (SendBird.this.mApplicationStateHandler == null) {
                        return;
                    }
                    Logger.d("onActivityResumed: " + activity.getPackageName() + ":" + activity.getLocalClassName());
                    SendBird.this.mApplicationStateHandler.onActivityResumed();
                }

                public void onActivityPaused(Activity activity) {
                    if (SendBird.this.mApplicationStateHandler == null) {
                        return;
                    }
                    Logger.d("onActivityPaused: " + activity.getPackageName() + ":" + activity.getLocalClassName());
                    SendBird.this.mApplicationStateHandler.onActivityPaused();
                }

                public void onActivityStopped(Activity activity) {
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                }

                public void onActivityDestroyed(Activity activity) {
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startGlobalTimer() {
        SendBird I = SendBird.getInstance();
        Object object = I.mGlobalTimerLock;
        synchronized (object) {
            if (this.mGlobalTimer != null) {
                this.mGlobalTimer.cancel();
                this.mGlobalTimer = null;
            }
            this.mGlobalTimer = new CountDownTimer(1000, 100, true);
            this.mGlobalTimer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){
                long tickCount = 0L;

                @Override
                public void onStart() {
                }

                @Override
                public void onStop() {
                }

                @Override
                public void onCancel() {
                }

                @Override
                public void onTimeout() {
                }

                @Override
                public void onTick(int timeout, int elapsed) {
                    ++this.tickCount;
                    if (this.tickCount % 10L == 0L && GroupChannel.sCachedChannels != null) {
                        for (final GroupChannel channel : GroupChannel.sCachedChannels.values()) {
                            if (!channel.invalidateTypingStatus()) continue;
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        handler.onTypingStatusUpdated(channel);
                                    }
                                }
                            });
                        }
                    }
                    if (this.tickCount % 20L == 2L) {
                        // empty if block
                    }
                    if (this.tickCount % 50L == 2L) {
                        // empty if block
                    }
                }
            });
            this.mGlobalTimer.start();
        }
    }

    protected static void runOnUIThread(Runnable runnable) {
        if (sUIThreadHandler != null && Options.useUiThreadForCallbacks) {
            sUIThreadHandler.post(runnable);
        } else {
            runnable.run();
        }
    }

    protected static synchronized SendBird getInstance() {
        if (sInstance == null) {
            Logger.e("SendBird instance hasn't been initialized. Try SendBird.init().");
            throw new RuntimeException("SendBird instance hasn't been initialized.");
        }
        return sInstance;
    }

    protected static synchronized boolean isInitialized() {
        return sInstance != null;
    }

    public static synchronized boolean init(String appId, Context context) {
        boolean result = true;
        if (sInstance == null) {
            sInstance = new SendBird(appId, context.getApplicationContext());
            ConnectionManager.init();
            APIClient.init();
        } else {
            result = sInstance.setApplicationId(appId);
        }
        SendBird.disconnect(true, true, null);
        if (SendBird.sInstance.mApplicationStateHandler != null) {
            SendBird.sInstance.mApplicationStateHandler.stop();
        }
        SendBird.sInstance.mIsTrackingApplicationState = true;
        SendBird.sInstance.mIsNetworkAwarenessReconnection = true;
        SendBird.sInstance.mApplicationStateHandler = new ApplicationStateHandler(){
            boolean isBackground;
            boolean tryConnect;
            Handler handler;
            Thread thread = new Thread(){

                @Override
                public void run() {
                    Looper.prepare();
                    handler = new Handler();
                    Looper.loop();
                }
            };
            Runnable disconnectRunnable = new Runnable(){

                @Override
                public void run() {
                    if (!isBackground) {
                        Logger.d("Application is on background.");
                        if (SendBird.getConnectionState() != ConnectionState.CLOSED || sInstance.mReconnectCount > 0) {
                            SendBird.disconnect(false, true, null);
                            tryConnect = true;
                        } else {
                            tryConnect = false;
                        }
                        isBackground = true;
                        sInstance.mIsAppBackground = true;
                    }
                }
            };

            @Override
            void start() {
                this.thread.start();
            }

            @Override
            void stop() {
                if (this.handler != null && this.handler.getLooper() != null) {
                    this.handler.getLooper().quit();
                }
            }

            @Override
            public void onActivityResumed() {
                if (!SendBird.getAutoBackgroundDetection() || this.handler == null) {
                    return;
                }
                this.handler.removeCallbacksAndMessages(null);
                if (this.isBackground) {
                    Logger.d("Application is on foreground.");
                    this.isBackground = false;
                    sInstance.mIsAppBackground = false;
                    if (SendBird.getConnectionState() == ConnectionState.CLOSED && this.tryConnect && sInstance.mCurrentUser != null) {
                        boolean callStart = sInstance.mReconnectCount == 0;
                        SendBird.disconnect(false, true, null);
                        SendBird.reconnectWS(sInstance.mCurrentUser.getUserId(), callStart, false);
                    }
                }
            }

            @Override
            public void onActivityPaused() {
                if (!SendBird.getAutoBackgroundDetection() || this.handler == null) {
                    return;
                }
                this.handler.removeCallbacksAndMessages(null);
                this.handler.postDelayed(this.disconnectRunnable, 500L);
            }
        };
        SendBird.sInstance.mApplicationStateHandler.start();
        return result;
    }

    public static void notifyActivityResumedForOldAndroids() {
        if (Build.VERSION.SDK_INT >= 14 || SendBird.getInstance().mApplicationStateHandler == null) {
            return;
        }
        SendBird.getInstance().mApplicationStateHandler.onActivityResumed();
    }

    public static void notifyActivityPausedForOldAndroids() {
        if (Build.VERSION.SDK_INT >= 14 || SendBird.getInstance().mApplicationStateHandler == null) {
            return;
        }
        SendBird.getInstance().mApplicationStateHandler.onActivityPaused();
    }

    public static void setAutoBackgroundDetection(boolean enable) {
        SendBird.getInstance().mIsTrackingApplicationState = enable;
    }

    public static boolean getAutoBackgroundDetection() {
        return SendBird.getInstance().mIsTrackingApplicationState;
    }

    public static void setNetworkAwarenessReconnection(boolean enable) {
        SendBird.getInstance().mIsNetworkAwarenessReconnection = enable;
    }

    public static boolean getNetworkAwarenessReconnection() {
        return SendBird.getInstance().mIsNetworkAwarenessReconnection;
    }

    public static ConnectionState getConnectionState() {
        if (!SendBird.isInitialized()) {
            return ConnectionState.CLOSED;
        }
        try {
            if (SendBird.getInstance().mConnecting || SendBird.getInstance().mReconnecting) {
                return ConnectionState.CONNECTING;
            }
            if (SendBird.getInstance().mWSClient == null) {
                return ConnectionState.CLOSED;
            }
            return SendBird.getInstance().mWSClient.getConnectionState();
        }
        catch (RuntimeException e) {
            return ConnectionState.CLOSED;
        }
    }

    public static void connect(String userId, ConnectHandler handler) {
        SendBird._connect(userId, null, null, null, handler);
    }

    public static void connect(String userId, String accessToken, ConnectHandler handler) {
        SendBird._connect(userId, accessToken, null, null, handler);
    }

    public static void connect(String userId, String accessToken, String apiHost, String wsHost, ConnectHandler handler) {
        SendBird._connect(userId, accessToken, apiHost, wsHost, handler);
    }

    private static void _connect(String userId, String accessToken, String apiHost, String wsHost, final ConnectHandler handler) {
        CUSTOM_API_HOST = apiHost;
        CUSTOM_WS_HOST = wsHost;
        if (userId == null || userId.length() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onConnected(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        if (SendBird.getConnectionState() == ConnectionState.OPEN && SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(userId)) {
            Logger.d("_connect() in ConnectionState.OPEN");
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onConnected(SendBird.getCurrentUser(), null);
                    }
                });
            }
        } else if (SendBird.getInstance().mConnecting && SendBird.getInstance().mConnectHandlers.size() > 0) {
            Logger.d("_connect() in mConnecting");
            SendBird.addConnectHandler(handler);
        } else {
            Logger.d("_connect() in ConnectionState.CLOSED or mReconnecting");
            SendBird.addConnectHandler(handler);
            SendBird.disconnect(false, true, null);
            User currentUser = SendBird.getCurrentUser();
            if (currentUser == null || !currentUser.getUserId().equals(userId)) {
                if (currentUser != null && !currentUser.getUserId().equals(userId)) {
                    SendBird.disconnect(true, true, null);
                }
                APIClient.getInstance().evictAllConnections();
                SendBird.connectWS(userId, accessToken, handler);
            } else {
                APIClient.getInstance().evictAllConnections();
                SendBird.connectWS(currentUser.getUserId(), null, handler);
            }
        }
    }

    public static synchronized boolean reconnect() {
        return SendBird.reconnect(false);
    }

    static boolean reconnect(boolean fromOnError) {
        if (SendBird.getCurrentUser() == null || APIClient.getInstance().getSessionKey() == null) {
            return false;
        }
        boolean callStart = SendBird.getInstance().mReconnectCount == 0;
        SendBird.disconnect(false, true, null);
        APIClient.getInstance().evictAllConnections();
        SendBird.reconnectWS(SendBird.getCurrentUser().getUserId(), callStart, fromOnError);
        return true;
    }

    public static void addChannelHandler(String identifier, ChannelHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        SendBird.getInstance().mChannelHandlers.put(identifier, handler);
    }

    public static ChannelHandler removeChannelHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return SendBird.getInstance().mChannelHandlers.remove(identifier);
    }

    public static void removeAllChannelHandlers() {
        SendBird.getInstance().mChannelHandlers.clear();
    }

    public static void addUserEventHandler(String identifier, UserEventHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        SendBird.getInstance().mUserEventHandlers.put(identifier, handler);
    }

    public static UserEventHandler removeUserEventHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return SendBird.getInstance().mUserEventHandlers.remove(identifier);
    }

    public static void removeAllUserEventHandlers() {
        SendBird.getInstance().mUserEventHandlers.clear();
    }

    public static void addConnectionHandler(String identifier, ConnectionHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        SendBird.getInstance().mConnectionHandlers.put(identifier, handler);
    }

    public static ConnectionHandler removeConnectionHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return SendBird.getInstance().mConnectionHandlers.remove(identifier);
    }

    public static void removeAllConnectionHandlers() {
        SendBird.getInstance().mConnectionHandlers.clear();
    }

    static void addLocalNetworkHandler(String identifier, LocalNetworkHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        SendBird.getInstance().mLocalNetworkHandlers.put(identifier, handler);
    }

    static LocalNetworkHandler removeLocalNetworkHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return SendBird.getInstance().mLocalNetworkHandlers.remove(identifier);
    }

    static void removeAllLocalNetworkHandlers() {
        SendBird.getInstance().mLocalNetworkHandlers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReconnectingFromOnError() {
        boolean result;
        Object object = this.mReconnectingLock;
        synchronized (object) {
            result = this.mReconnectingFromOnError;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reconnectStartedFromOnErrorForNetworkHandler() {
        final SendBird I = SendBird.getInstance();
        if (!I.mReconnectStartedFromOnError) {
            Object object = I.mReconnectingLock;
            synchronized (object) {
                I.mReconnectStartedFromOnError = true;
            }
            if (I.mLocalNetworkHandlers.size() > 0) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (LocalNetworkHandler handler : I.mLocalNetworkHandlers.values()) {
                            if (handler == null) continue;
                            handler.onLocalUnexpectedDisconnect();
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reconnectSucceededFromOnErrorForNetworkHandler() {
        final SendBird I = SendBird.getInstance();
        Object object = I.mReconnectingLock;
        synchronized (object) {
            I.mReconnectStartedFromOnError = false;
        }
        if (I.mLocalNetworkHandlers.size() > 0) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    for (LocalNetworkHandler handler : I.mLocalNetworkHandlers.values()) {
                        if (handler == null) continue;
                        handler.onLocalReconnected();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reconnectFailedForNetworkHandler() {
        final SendBird I = SendBird.getInstance();
        Object object = I.mReconnectingLock;
        synchronized (object) {
            I.mReconnectStartedFromOnError = false;
        }
        if (I.mLocalNetworkHandlers.size() > 0) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    for (LocalNetworkHandler handler : I.mLocalNetworkHandlers.values()) {
                        if (handler == null) continue;
                        handler.onLocalReconnectFailed();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addConnectHandler(ConnectHandler handler) {
        if (handler != null) {
            SendBird I = SendBird.getInstance();
            LinkedHashSet<ConnectHandler> linkedHashSet = I.mConnectHandlers;
            synchronized (linkedHashSet) {
                I.mConnectHandlers.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processAllConnectHandlers(final SendBirdException e) {
        LinkedHashSet<ConnectHandler> tempConnectHandlers;
        SendBird I = SendBird.getInstance();
        LinkedHashSet<ConnectHandler> linkedHashSet = I.mConnectHandlers;
        synchronized (linkedHashSet) {
            if (I.mConnectHandlers.size() > 0) {
                tempConnectHandlers = new LinkedHashSet<ConnectHandler>(I.mConnectHandlers);
                I.mConnectHandlers.clear();
            } else {
                tempConnectHandlers = null;
            }
        }
        if (tempConnectHandlers != null) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    for (ConnectHandler handler : tempConnectHandlers) {
                        if (e != null) {
                            handler.onConnected(null, e);
                            continue;
                        }
                        handler.onConnected(SendBird.getCurrentUser(), null);
                    }
                }
            });
        }
        ConnectionManager.processAllReadyHandlers(false, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void reconnectWS(final String userId, boolean callStart, boolean fromOnError) {
        final SendBird I = SendBird.getInstance();
        Object object = I.mReconnectingLock;
        synchronized (object) {
            I.mReconnecting = true;
            I.mReconnectingFromOnError = fromOnError;
        }
        I.mReconnectDelay = Math.min(I.mReconnectDelay, 300000);
        ++I.mReconnectCount;
        if (I.mReconnectingFromOnError) {
            SendBird.reconnectStartedFromOnErrorForNetworkHandler();
        }
        if (I.mReconnectCount == 1 && callStart) {
            Logger.d("Reconnect Started.");
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    for (ConnectionHandler handler : I.mConnectionHandlers.values()) {
                        handler.onReconnectStarted();
                    }
                }
            });
        }
        if (I.mReconnectCount <= 5) {
            object = I.mReconnectTimerLock;
            synchronized (object) {
                if (I.mReconnectTimer == null) {
                    I.mReconnectTimer = new CountDownTimer(I.mReconnectDelay, I.mReconnectDelay == 0 ? 0 : 1000);
                    I.mReconnectTimer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){

                        @Override
                        public void onStart() {
                            Logger.d("ReconnectTimer start.");
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onStop() {
                            Object object = I.mReconnectTimerLock;
                            synchronized (object) {
                                I.mReconnectTimer = null;
                            }
                            Logger.d("ReconnectTimer stop.");
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onCancel() {
                            Object object = I.mReconnectTimerLock;
                            synchronized (object) {
                                I.mReconnectTimer = null;
                            }
                            Logger.d("ReconnectTimer cancel.");
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onTimeout() {
                            Object object = I.mReconnectTimerLock;
                            synchronized (object) {
                                I.mReconnectTimer = null;
                            }
                            Logger.d("ReconnectTimer timeout. Try to reconnect...");
                            object = I.mWSClientLock;
                            synchronized (object) {
                                if (I.mWSClient != null) {
                                    I.mWSClient.disconnect();
                                    I.mWSClient = null;
                                }
                                I.mWSClient = new WSClient();
                                I.mWSClient.setEventHandler(new WSClient.WSClientHandler(){

                                    @Override
                                    public void onReady() {
                                        Logger.d("WS Ready.");
                                        if (I.mWSClient != null) {
                                            I.mWSClient.connect();
                                        }
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void onOpen() {
                                        Logger.d("WS Open.");
                                        Object object = I.mLoginTimerLock;
                                        synchronized (object) {
                                            this.startLoginTimer();
                                        }
                                    }

                                    private void startLoginTimer() {
                                        I.mLoginTimer = new CountDownTimer(10000, 100);
                                        I.mLoginTimer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){
                                            private boolean timeout;

                                            @Override
                                            public void onStart() {
                                            }

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            @Override
                                            public void onStop() {
                                                Object object;
                                                if (this.timeout) {
                                                    Logger.d("Reconnect login timer failed.");
                                                    SendBird.disconnect(false, false, null);
                                                    object = I.mReconnectingLock;
                                                    synchronized (object) {
                                                        I.mReconnecting = false;
                                                    }
                                                    if (I.mConnectionHandlers.size() > 0) {
                                                        SendBird.runOnUIThread(new Runnable(){

                                                            @Override
                                                            public void run() {
                                                                for (ConnectionHandler handler : I.mConnectionHandlers.values()) {
                                                                    handler.onReconnectFailed();
                                                                }
                                                            }
                                                        });
                                                    }
                                                    object = I.mReconnectingLock;
                                                    synchronized (object) {
                                                        I.mReconnectingFromOnError = false;
                                                    }
                                                    ConnectionManager.errorAllReadyHandlers(true);
                                                    SendBird.reconnectFailedForNetworkHandler();
                                                } else {
                                                    Logger.d("Reconnect login timer succeeded.");
                                                    I.mReconnectDelay = 0;
                                                    I.mReconnectCount = 0;
                                                    Collection<OpenChannel> enteredOpenChannels = OpenChannel.getEnteredChannels();
                                                    final AtomicBoolean errorOnEnter = new AtomicBoolean(false);
                                                    if (enteredOpenChannels.size() > 0) {
                                                        Logger.d("Enter open channels: " + enteredOpenChannels.size());
                                                        final CountDownLatch latch = new CountDownLatch(enteredOpenChannels.size());
                                                        final ArrayList openChannelUrlsOnError = new ArrayList();
                                                        for (final OpenChannel channel : OpenChannel.getEnteredChannels()) {
                                                            channel.enter(false, new OpenChannel.OpenChannelEnterHandler(){

                                                                @Override
                                                                public void onResult(SendBirdException e) {
                                                                    if (e != null) {
                                                                        Logger.d("enter() => error: " + e.getCode());
                                                                        String channelUrl = channel.getUrl();
                                                                        if (channelUrl != null && channelUrl.length() > 0) {
                                                                            openChannelUrlsOnError.add(channelUrl);
                                                                        }
                                                                    }
                                                                    latch.countDown();
                                                                }
                                                            });
                                                        }
                                                        try {
                                                            latch.await();
                                                        }
                                                        catch (InterruptedException e) {
                                                            errorOnEnter.set(true);
                                                        }
                                                        if (openChannelUrlsOnError.size() > 0) {
                                                            for (String channelUrl : openChannelUrlsOnError) {
                                                                OpenChannel.removeChannelFromEntered(channelUrl);
                                                            }
                                                        }
                                                        if (errorOnEnter.get()) {
                                                            Logger.d("Error on enter: true");
                                                            SendBird.disconnect(false, false, null);
                                                        } else {
                                                            Logger.d("Error on enter: false");
                                                        }
                                                        Object object2 = I.mReconnectingLock;
                                                        synchronized (object2) {
                                                            I.mReconnecting = false;
                                                        }
                                                        if (I.mConnectionHandlers.size() > 0) {
                                                            SendBird.runOnUIThread(new Runnable(){

                                                                @Override
                                                                public void run() {
                                                                    for (ConnectionHandler handler : I.mConnectionHandlers.values()) {
                                                                        if (errorOnEnter.get()) {
                                                                            handler.onReconnectFailed();
                                                                            continue;
                                                                        }
                                                                        handler.onReconnectSucceeded();
                                                                    }
                                                                }
                                                            });
                                                        }
                                                        if (I.mReconnectingFromOnError) {
                                                            object2 = I.mReconnectingLock;
                                                            synchronized (object2) {
                                                                I.mReconnectingFromOnError = false;
                                                            }
                                                            if (errorOnEnter.get()) {
                                                                ConnectionManager.errorAllReadyHandlers(true);
                                                                SendBird.reconnectFailedForNetworkHandler();
                                                            } else {
                                                                SendBird.reconnectSucceededFromOnErrorForNetworkHandler();
                                                            }
                                                        } else if (errorOnEnter.get()) {
                                                            ConnectionManager.errorAllReadyHandlers(true);
                                                            SendBird.reconnectFailedForNetworkHandler();
                                                        } else {
                                                            ConnectionManager.processAllReadyHandlers(true, null);
                                                        }
                                                    } else {
                                                        Logger.d("No open channels to enter.");
                                                        Object object3 = I.mReconnectingLock;
                                                        synchronized (object3) {
                                                            I.mReconnecting = false;
                                                        }
                                                        if (I.mConnectionHandlers.size() > 0) {
                                                            SendBird.runOnUIThread(new Runnable(){

                                                                @Override
                                                                public void run() {
                                                                    for (ConnectionHandler handler : I.mConnectionHandlers.values()) {
                                                                        handler.onReconnectSucceeded();
                                                                    }
                                                                }
                                                            });
                                                        }
                                                        if (I.mReconnectingFromOnError) {
                                                            object3 = I.mReconnectingLock;
                                                            synchronized (object3) {
                                                                I.mReconnectingFromOnError = false;
                                                            }
                                                            SendBird.reconnectSucceededFromOnErrorForNetworkHandler();
                                                        } else {
                                                            ConnectionManager.processAllReadyHandlers(true, null);
                                                        }
                                                    }
                                                }
                                                object = I.mLoginTimerLock;
                                                synchronized (object) {
                                                    I.mLoginTimer = null;
                                                }
                                            }

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            @Override
                                            public void onCancel() {
                                                Logger.d("Reconnect login timer canceled.");
                                                Object object = I.mLoginTimerLock;
                                                synchronized (object) {
                                                    I.mLoginTimer = null;
                                                }
                                            }

                                            @Override
                                            public void onTimeout() {
                                                this.timeout = true;
                                            }

                                            @Override
                                            public void onTick(int timeout, int elapsed) {
                                            }
                                        });
                                        I.mLoginTimer.start();
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void onClose() {
                                        Logger.d("WS onClose.");
                                        Object object = I.mReconnectingLock;
                                        synchronized (object) {
                                            I.mReconnecting = false;
                                            I.mReconnectingFromOnError = false;
                                        }
                                    }

                                    @Override
                                    public void onMessage(String message) {
                                        Logger.d("WS onMessage: " + message);
                                        I.messageReceived(message);
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void onError(SendBirdException e) {
                                        Logger.d("WS onError.");
                                        Logger.d(e);
                                        Object object = I.mReconnectingLock;
                                        synchronized (object) {
                                            I.mReconnecting = false;
                                            I.mReconnectingFromOnError = false;
                                        }
                                        APIClient.getInstance().cancelAllRequests();
                                        APIClient.getInstance().evictAllConnections();
                                        ConnectionManager.errorAllReadyHandlers(true);
                                        SendBird.reconnectWS(userId, I.mReconnectCount == 0, true);
                                    }
                                });
                            }
                            if (I.mWSClient != null) {
                                I.mWSClient.initWebSocket(userId, null);
                            }
                        }

                        @Override
                        public void onTick(int timeout, int elapsed) {
                            Logger.d("ReconnectTimer Tick: " + (timeout - elapsed));
                        }
                    });
                    I.mReconnectTimer.start();
                } else {
                    Logger.d("Reconnecting is in progress.");
                }
            }
            I.mReconnectDelay = I.mReconnectDelay == 0 ? 3000 : (I.mReconnectDelay *= 2);
        } else {
            Logger.d("Reconnect Failed.");
            SendBird.disconnect(false, false, null);
            object = I.mReconnectingLock;
            synchronized (object) {
                I.mReconnecting = false;
            }
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    for (ConnectionHandler handler : I.mConnectionHandlers.values()) {
                        handler.onReconnectFailed();
                    }
                }
            });
            object = I.mReconnectingLock;
            synchronized (object) {
                I.mReconnectingFromOnError = false;
            }
            ConnectionManager.errorAllReadyHandlers(true);
            SendBird.reconnectFailedForNetworkHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void connectWS(final String userId, String accessToken, ConnectHandler handler) {
        final SendBird I = SendBird.getInstance();
        Object object = I.mConnectingLock;
        synchronized (object) {
            I.mConnecting = true;
        }
        object = I.mWSClientLock;
        synchronized (object) {
            if (I.mWSClient != null) {
                I.mWSClient.disconnect();
                I.mWSClient = null;
            }
            I.mWSClient = new WSClient();
            I.mWSClient.setEventHandler(new WSClient.WSClientHandler(){

                @Override
                public void onReady() {
                    Logger.d("WS Ready.");
                    if (I.mWSClient != null) {
                        I.mWSClient.connect();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onOpen() {
                    Logger.d("WS Open.");
                    Object object = I.mLoginTimerLock;
                    synchronized (object) {
                        I.mLoginTimer = new CountDownTimer(10000, 100);
                        I.mLoginTimer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){
                            private boolean timeout;

                            @Override
                            public void onStart() {
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void onStop() {
                                int errCode;
                                String errMsg;
                                boolean loginException;
                                Object object = I.mLoginTimerLock;
                                synchronized (object) {
                                    boolean bl = loginException = I.mLoginException != null;
                                    if (loginException) {
                                        errMsg = I.mLoginException.getMessage();
                                        errCode = I.mLoginException.getCode();
                                    } else {
                                        errMsg = "";
                                        errCode = 0;
                                    }
                                }
                                if (this.timeout) {
                                    Logger.d("Connect login timer failed.");
                                    SendBird.disconnect(true, false, null);
                                    object = I.mConnectingLock;
                                    synchronized (object) {
                                        I.mConnecting = false;
                                    }
                                    SendBird.processAllConnectHandlers(new SendBirdException("Login timeout.", 800190));
                                } else if (loginException) {
                                    Logger.d("Connect login failed.");
                                    SendBird.disconnect(true, false, null);
                                    object = I.mConnectingLock;
                                    synchronized (object) {
                                        I.mConnecting = false;
                                    }
                                    SendBird.processAllConnectHandlers(new SendBirdException(errMsg, errCode));
                                } else {
                                    Logger.d("Connect login timer succeeded.");
                                    I.mReconnectDelay = 0;
                                    I.mReconnectCount = 0;
                                    I.startGlobalTimer();
                                    object = I.mConnectingLock;
                                    synchronized (object) {
                                        I.mConnecting = false;
                                    }
                                    SendBird.processAllConnectHandlers(null);
                                }
                                object = I.mLoginTimerLock;
                                synchronized (object) {
                                    I.mLoginTimer = null;
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void onCancel() {
                                Logger.d("Connect login timer canceled.");
                                Object object = I.mLoginTimerLock;
                                synchronized (object) {
                                    I.mLoginTimer = null;
                                }
                            }

                            @Override
                            public void onTimeout() {
                                this.timeout = true;
                            }

                            @Override
                            public void onTick(int timeout, int elapsed) {
                            }
                        });
                        I.mLoginTimer.start();
                        I.mLoginException = null;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onClose() {
                    Logger.d("WS Close.");
                    Object object = I.mConnectingLock;
                    synchronized (object) {
                        I.mConnecting = false;
                    }
                }

                @Override
                public void onMessage(String message) {
                    Logger.d("WS Received: " + message);
                    I.messageReceived(message);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onError(SendBirdException e) {
                    Logger.d("WS Error.");
                    Logger.d(e);
                    if (SendBird.getCurrentUser() == null) {
                        SendBird.disconnect(true, false, null);
                        Object object = I.mConnectingLock;
                        synchronized (object) {
                            I.mConnecting = false;
                        }
                        SendBird.processAllConnectHandlers(e);
                        return;
                    }
                    APIClient.getInstance().cancelAllRequests();
                    APIClient.getInstance().evictAllConnections();
                    ConnectionManager.errorAllReadyHandlers(false);
                    SendBird.reconnectWS(userId, I.mReconnectCount == 0, true);
                }
            });
        }
        if (I.mWSClient != null) {
            I.mWSClient.initWebSocket(userId, accessToken);
        }
    }

    public static void disconnect(DisconnectHandler handler) {
        SendBird.disconnect(true, true, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void disconnect(boolean logout, boolean checkConnectionCanceled, final DisconnectHandler handler) {
        Logger.d("Disconnect.");
        SendBird I = SendBird.getInstance();
        if (checkConnectionCanceled && I.mWSClient != null && I.mWSClient.getConnectionState() == ConnectionState.CONNECTING) {
            SendBird.processAllConnectHandlers(new SendBirdException("Connection has been canceled.", 800102));
        }
        I.mReconnectDelay = 0;
        I.mReconnectCount = 0;
        Object object = I.mLoginTimerLock;
        synchronized (object) {
            if (I.mLoginTimer != null) {
                I.mLoginTimer.cancel();
                I.mLoginTimer = null;
            }
        }
        object = I.mReconnectTimerLock;
        synchronized (object) {
            if (I.mReconnectTimer != null) {
                I.mReconnectTimer.cancel();
                I.mReconnectTimer = null;
            }
        }
        object = I.mWSClientLock;
        synchronized (object) {
            if (I.mWSClient != null) {
                I.mWSClient.disconnect();
                I.mWSClient = null;
            }
        }
        object = I.mConnectingLock;
        synchronized (object) {
            I.mConnecting = false;
        }
        object = I.mReconnectingLock;
        synchronized (object) {
            I.mReconnecting = false;
            I.mReconnectingFromOnError = false;
        }
        if (logout) {
            Logger.d("Clear local data.");
            object = I.mGlobalTimerLock;
            synchronized (object) {
                if (I.mGlobalTimer != null) {
                    I.mGlobalTimer.cancel();
                    I.mGlobalTimer = null;
                }
            }
            object = I.mAckStateMapLock;
            synchronized (object) {
                for (HashMap<String, Object> map : I.mAckStateMap.values()) {
                    CountDownTimer timer = (CountDownTimer)map.get("timer");
                    if (timer == null) continue;
                    timer.cancel();
                }
                I.mAckStateMap.clear();
            }
            if (I.mCurrentUser != null) {
                I.mCurrentUser = null;
            }
            APIClient.getInstance().cancelAllRequests();
            APIClient.getInstance().setSessionKey("");
            APIClient.getInstance().setEKey("");
            OpenChannel.clearEnteredChannels();
            OpenChannel.clearCache();
            GroupChannel.clearCache();
            I.mLastConnectedAt = 0L;
        }
        if (handler != null) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    handler.onDisconnected();
                }
            });
        }
    }

    public static User getCurrentUser() {
        return SendBird.getInstance().mCurrentUser;
    }

    public static long getLastConnectedAt() {
        if (SendBird.getConnectionState() == ConnectionState.OPEN) {
            return SendBird.getInstance().mLastConnectedAt;
        }
        return 0L;
    }

    @Deprecated
    public static UserListQuery createUserListQuery() {
        return new UserListQuery(UserListQuery.QueryType.ALL_USER);
    }

    @Deprecated
    public static UserListQuery createUserListQuery(List<String> userIds) {
        return new UserListQuery(UserListQuery.QueryType.FILTERED_USER, userIds);
    }

    public static ApplicationUserListQuery createApplicationUserListQuery() {
        return new ApplicationUserListQuery();
    }

    public static BlockedUserListQuery createBlockedUserListQuery() {
        return new BlockedUserListQuery();
    }

    public static void updateCurrentUserInfoWithProfileImage(String nickname, File profileImage, UserInfoUpdateHandler handler) {
        SendBird.updateCurrentUserInfoWithProfileImage(nickname, profileImage, null, handler);
    }

    private static void updateCurrentUserInfoWithProfileImage(String nickname, File profileImage, List<String> discoveryKeys, final UserInfoUpdateHandler handler) {
        APIClient.getInstance().updateUserInfo(nickname, profileImage, discoveryKeys, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUpdated(e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                User user = SendBird.getCurrentUser();
                if (obj.has("nickname")) {
                    user.setNickname(obj.get("nickname").getAsString());
                }
                if (obj.has("profile_url")) {
                    user.setProfileUrl(obj.get("profile_url").getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUpdated(null);
                        }
                    });
                }
            }
        });
    }

    public static void updateCurrentUserInfo(String nickname, String profileUrl, UserInfoUpdateHandler handler) {
        SendBird.updateCurrentUserInfo(nickname, profileUrl, null, handler);
    }

    private static void updateCurrentUserInfo(String nickname, String profileUrl, List<String> discoveryKeys, final UserInfoUpdateHandler handler) {
        APIClient.getInstance().updateUserInfo(nickname, profileUrl, discoveryKeys, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUpdated(e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                User user = SendBird.getCurrentUser();
                if (obj.has("nickname")) {
                    user.setNickname(obj.get("nickname").getAsString());
                }
                if (obj.has("profile_url")) {
                    user.setProfileUrl(obj.get("profile_url").getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUpdated(null);
                        }
                    });
                }
            }
        });
    }

    public static String getPendingPushToken() {
        return SendBird.getInstance().mPushToken;
    }

    @Deprecated
    public static void registerPushTokenForCurrentUser(String gcmRegToken, final RegisterPushTokenHandler handler) {
        if (gcmRegToken == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onRegistered(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().registerPushToken(gcmRegToken, false, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onRegistered(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onRegistered(null);
                        }
                    });
                }
            }
        });
    }

    public static void registerPushTokenForCurrentUser(String gcmRegToken, RegisterPushTokenWithStatusHandler handler) {
        SendBird.registerPushTokenForCurrentUser(gcmRegToken, false, handler);
    }

    public static void registerPushTokenForCurrentUser(String gcmRegToken, boolean unique, final RegisterPushTokenWithStatusHandler handler) {
        if (gcmRegToken == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onRegistered(PushTokenRegistrationStatus.ERROR, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        if (SendBird.getCurrentUser() == null) {
            SendBird.getInstance().mPushToken = gcmRegToken;
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onRegistered(PushTokenRegistrationStatus.PENDING, null);
                    }
                });
            }
            return;
        }
        APIClient.getInstance().registerPushToken(gcmRegToken, unique, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onRegistered(PushTokenRegistrationStatus.ERROR, e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.getInstance().mPushToken = null;
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onRegistered(PushTokenRegistrationStatus.SUCCESS, null);
                        }
                    });
                }
            }
        });
    }

    public static void unregisterPushTokenForCurrentUser(String gcmRegToken, final UnregisterPushTokenHandler handler) {
        if (gcmRegToken == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnregistered(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().unregisterPushToken(gcmRegToken, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUnregistered(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUnregistered(null);
                        }
                    });
                }
            }
        });
    }

    public static void unregisterPushTokenAllForCurrentUser(final UnregisterPushTokenHandler handler) {
        APIClient.getInstance().unregisterPushTokenAll(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUnregistered(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUnregistered(null);
                        }
                    });
                }
            }
        });
    }

    public static void setDoNotDisturb(boolean doNotDisturbOn, int startHour, int startMin, int endHour, int endMin, String timezone, final SetDoNotDisturbHandler handler) {
        if (startHour < 0 || startHour > 23 || startMin < 0 || startMin > 59 || endHour < 0 || endHour > 23 || endMin < 0 || endMin > 59) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().setDoNotDisturb(doNotDisturbOn, startHour, startMin, endHour, endMin, timezone, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void getDoNotDisturb(final GetDoNotDisturbHandler handler) {
        APIClient.getInstance().getDoNotDisturb(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(false, 0, 0, 0, 0, null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                final boolean isDisturbOn = obj.get("do_not_disturb").getAsBoolean();
                final int startHour = obj.get("start_hour").getAsInt();
                final int startMin = obj.get("start_min").getAsInt();
                final int endHour = obj.get("end_hour").getAsInt();
                final int endMin = obj.get("end_min").getAsInt();
                final String timezone = obj.get("timezone").getAsString();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(isDisturbOn, startHour, startMin, endHour, endMin, timezone, null);
                        }
                    });
                }
            }
        });
    }

    public static void setPushSound(String sound, final SetPushSoundHandler handler) {
        if (sound == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().setPushSound(sound, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void getPushSound(final GetPushSoundHandler handler) {
        APIClient.getInstance().getPushSound(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                String sound;
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                String string = sound = obj.has("push_sound") && !obj.get("push_sound").isJsonNull() ? obj.get("push_sound").getAsString() : "";
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(sound, null);
                        }
                    });
                }
            }
        });
    }

    public static void setPushTemplate(String templateName, final SetPushTemplateHandler handler) {
        if (templateName == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().setPushTemplate(templateName, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (e != null) {
                                handler.onResult(e);
                            } else {
                                handler.onResult(null);
                            }
                        }
                    });
                }
            }
        });
    }

    public static void getPushTemplate(final GetPushTemplateHandler handler) {
        APIClient.getInstance().getPushTemplate(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final String name = response.getAsJsonObject().get("name").getAsString();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(name, null);
                        }
                    });
                }
            }
        });
    }

    public static void setChannelInvitationPreference(boolean autoAccept, final SetChannelInvitationPreferenceHandler handler) {
        APIClient.getInstance().setAutoAcceptInvitation(autoAccept, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void getChannelInvitationPreference(final GetChannelInvitationPreferenceHandler handler) {
        APIClient.getInstance().getAutoAcceptInvitation(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(false, e);
                            }
                        });
                    }
                    return;
                }
                final boolean autoAccept = response.getAsJsonObject().get("auto_accept").getAsBoolean();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(autoAccept, null);
                        }
                    });
                }
            }
        });
    }

    public static void blockUser(User userToBlock, final UserBlockHandler handler) {
        if (userToBlock == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onBlocked(null, new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.blockUserWithUserId(userToBlock.getUserId(), handler);
    }

    public static void blockUserWithUserId(String userIdToBlock, final UserBlockHandler handler) {
        if (userIdToBlock == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onBlocked(null, new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().blockUser(userIdToBlock, new APIClient.APIClientHandler(){

            @Override
            public void onResult(final JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onBlocked(null, e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onBlocked(new User(response), null);
                        }
                    });
                }
            }
        });
    }

    public static void unblockUser(User blockedUser, final UserUnblockHandler handler) {
        if (blockedUser == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnblocked(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.unblockUserWithUserId(blockedUser.getUserId(), handler);
    }

    public static void unblockUserWithUserId(String blockedUserId, final UserUnblockHandler handler) {
        if (blockedUserId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnblocked(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().unblockUser(blockedUserId, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUnblocked(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUnblocked(null);
                        }
                    });
                }
            }
        });
    }

    public static void addFriends(List<String> userIds, final AddFriendsHandler handler) {
        if (userIds == null || userIds.size() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().addFriends(userIds, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    JsonArray array;
                    JsonObject obj;
                    final ArrayList<User> users = new ArrayList<User>();
                    if (response != null && (obj = response.getAsJsonObject()) != null && obj.has("users") && (array = obj.getAsJsonArray("users")) != null) {
                        for (int i = 0; i < array.size(); ++i) {
                            users.add(new User(array.get(i)));
                        }
                    }
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(users, null);
                        }
                    });
                }
            }
        });
    }

    public static void deleteFriends(List<String> userIds, final DeleteFriendsHandler handler) {
        if (userIds == null || userIds.size() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteFriends(userIds, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void deleteFriend(String userId, final DeleteFriendHandler handler) {
        if (userId == null || userId.length() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteFriend(userId, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void uploadFriendDiscoveries(Map<String, String> discoveryMap, final UploadFriendDiscoveriesHandler handler) {
        if (discoveryMap == null || discoveryMap.size() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().uploadFriendDiscoveries(discoveryMap, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void deleteFriendDiscoveries(List<String> discoveryKeys, final DeleteFriendDiscoveriesHandler handler) {
        if (discoveryKeys == null || discoveryKeys.size() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteFriendDiscoveries(discoveryKeys, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void deleteFriendDiscovery(String discoveryKey, final DeleteFriendDiscoveryHandler handler) {
        if (discoveryKey == null || discoveryKey.length() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteFriendDiscovery(discoveryKey, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void getFriendChangeLogsByToken(String token, final GetFriendChangeLogsByTokenHandler handler) {
        APIClient.getInstance().getFriendChangeLogsByToken(token, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, null, false, null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                JsonArray updatedJsonArray = result.get("updated").getAsJsonArray();
                final ArrayList<User> updatedUsers = new ArrayList<User>();
                for (int i = 0; i < updatedJsonArray.size(); ++i) {
                    updatedUsers.add(new User(updatedJsonArray.get(i)));
                }
                JsonArray deletedJsonArray = result.get("deleted").getAsJsonArray();
                final ArrayList<String> deletedUserIds = new ArrayList<String>();
                for (int i = 0; i < deletedJsonArray.size(); ++i) {
                    deletedUserIds.add(deletedJsonArray.get(i).getAsString());
                }
                final boolean hasMore = result.get("has_more").getAsBoolean();
                final String token = result.get("next").getAsString();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(updatedUsers, deletedUserIds, hasMore, token, null);
                        }
                    });
                }
            }
        });
    }

    public static FriendListQuery createFriendListQuery() {
        return new FriendListQuery();
    }

    public static void markAsReadAll(MarkAsReadHandler handler) {
        GroupChannel.localMarkAsReadAll(null, handler);
    }

    public static void markAsReadWithChannelUrls(List<String> channelUrls, MarkAsReadHandler handler) {
        GroupChannel.localMarkAsReadWithChannelUrls(channelUrls, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageReceived(String message) {
        final Command cmd = new Command(message);
        Logger.d("messageReceived() => " + cmd.getRequestId() + ":" + cmd.getCommand() + ":" + cmd.getPayload());
        this.processSubscribedUnreadMessageCount(cmd);
        if (cmd.hasRequestId()) {
            HashMap<String, Object> ackInfo = this.getAckInfo(cmd.getRequestId());
            if (ackInfo == null) {
                return;
            }
            CountDownTimer timer = (CountDownTimer)ackInfo.get("timer");
            Command.SendCommandHandler handler = (Command.SendCommandHandler)ackInfo.get("handler");
            if (timer != null) {
                timer.stop();
            }
            if (handler != null) {
                switch (cmd.getCommand()) {
                    case "EROR": {
                        JsonObject error = cmd.getJsonElement().getAsJsonObject();
                        int errCode = error.get("code").getAsInt();
                        String errMessage = error.get("message").getAsString();
                        handler.onResult(cmd, new SendBirdException(errMessage, errCode));
                        break;
                    }
                    case "MESG": 
                    case "FILE": {
                        Sender sender;
                        BaseMessage msg;
                        if (cmd.getCommand().equals("MESG")) {
                            msg = new UserMessage(cmd.getJsonElement());
                            sender = ((UserMessage)msg).mSender;
                        } else {
                            msg = new FileMessage(cmd.getJsonElement());
                            sender = ((FileMessage)msg).mSender;
                        }
                        if (sender != null && this.mCurrentUser != null && sender.getUserId().equals(this.mCurrentUser.getUserId())) {
                            this.mCurrentUser.updatePropertiesByUser(sender);
                        }
                        if (msg.isGroupChannel()) {
                            GroupChannel.getChannel(msg.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                                @Override
                                public void onResult(final GroupChannel channel, SendBirdException e) {
                                    if (e == null) {
                                        channel.setLastMessage(msg);
                                        SendBird.runOnUIThread(new Runnable(){

                                            @Override
                                            public void run() {
                                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                                    handler.onChannelChanged(channel);
                                                }
                                            }
                                        });
                                    }
                                }
                            });
                        }
                        handler.onResult(cmd, null);
                        break;
                    }
                    default: {
                        handler.onResult(cmd, null);
                    }
                }
            }
            return;
        }
        block36 : switch (cmd.getCommand()) {
            case "LOGI": {
                Object handler = this.mLoginTimerLock;
                synchronized (handler) {
                    if (this.mLoginTimer != null) {
                        JsonObject obj = cmd.getJsonElement().getAsJsonObject();
                        if (obj.getAsJsonObject().has("error") && obj.getAsJsonObject().get("error").isJsonPrimitive() && obj.getAsJsonObject().get("error").getAsBoolean()) {
                            String errMsg = "";
                            int errCode = 0;
                            if (obj.getAsJsonObject().has("message") && obj.getAsJsonObject().get("message").isJsonPrimitive()) {
                                errMsg = obj.getAsJsonObject().get("message").getAsString();
                            }
                            if (obj.getAsJsonObject().has("code") && obj.getAsJsonObject().get("code").isJsonPrimitive()) {
                                errCode = obj.getAsJsonObject().get("code").getAsInt();
                            }
                            this.mLoginException = new SendBirdException(errMsg, errCode);
                        } else {
                            Object errMsg;
                            if (obj.has("key")) {
                                APIClient.getInstance().setSessionKey(obj.get("key").getAsString());
                            }
                            if (obj.has("ekey")) {
                                APIClient.getInstance().setEKey(obj.get("ekey").getAsString());
                            }
                            if (obj.has("user_id")) {
                                SendBird.getInstance().mCurrentUser = new User(cmd.getJsonElement());
                            }
                            if (obj.has("ping_interval") && obj.get("ping_interval").isJsonPrimitive()) {
                                errMsg = this.mWSClientLock;
                                synchronized (errMsg) {
                                    if (this.mWSClient != null) {
                                        int pingInterval = obj.get("ping_interval").getAsInt();
                                        Logger.d("[LOGI] ping_interval: " + pingInterval + "sec");
                                        this.mWSClient.setPingIntervalMs(pingInterval * 1000);
                                    }
                                }
                            }
                            if (obj.has("pong_timeout") && obj.get("pong_timeout").isJsonPrimitive()) {
                                errMsg = this.mWSClientLock;
                                synchronized (errMsg) {
                                    if (this.mWSClient != null) {
                                        int pongTimeout = obj.get("pong_timeout").getAsInt();
                                        Logger.d("[LOGI] pong_timeout: " + pongTimeout + "sec");
                                        this.mWSClient.setWatchdogTimeoutMs(pongTimeout * 1000);
                                    }
                                }
                            }
                            if (obj.has("login_ts") && obj.get("login_ts").isJsonPrimitive()) {
                                this.mLastConnectedAt = obj.get("login_ts").getAsLong();
                                Logger.d("[LOGI] login_ts: " + this.mLastConnectedAt + " (" + new Date(this.mLastConnectedAt).toString() + ")");
                            }
                            this.mLoginException = null;
                            errMsg = this.mWSClientLock;
                            synchronized (errMsg) {
                                if (this.mWSClient != null) {
                                    this.mWSClient.setSessionOpened(true);
                                    this.mWSClient.startPing();
                                }
                            }
                        }
                        this.mLoginTimer.stop();
                    }
                    break;
                }
            }
            case "MESG": 
            case "FILE": 
            case "BRDM": 
            case "ADMM": {
                BaseMessage msg;
                switch (cmd.getCommand()) {
                    case "MESG": {
                        msg = new UserMessage(cmd.getJsonElement());
                        break;
                    }
                    case "FILE": {
                        msg = new FileMessage(cmd.getJsonElement());
                        break;
                    }
                    case "BRDM": 
                    case "ADMM": {
                        msg = new AdminMessage(cmd.getJsonElement());
                        break;
                    }
                    default: {
                        Logger.d("Discard a command: " + cmd.getCommand());
                        return;
                    }
                }
                if (msg.isGroupChannel()) {
                    String channelUrl = msg.getChannelUrl();
                    if (!GroupChannel.sCachedChannels.containsKey(channelUrl)) {
                        GroupChannel.getChannelWithoutCache(channelUrl, new GroupChannel.GroupChannelGetHandler(){

                            @Override
                            public void onResult(final GroupChannel channel, SendBirdException e) {
                                if (e != null) {
                                    Logger.d("Discard a command.");
                                    return;
                                }
                                final boolean callChannelChanged = !(msg instanceof AdminMessage) || !((AdminMessage)msg).isSilent();
                                Sender sender = null;
                                if (msg instanceof UserMessage) {
                                    sender = ((UserMessage)msg).mSender;
                                } else if (msg instanceof FileMessage) {
                                    sender = ((FileMessage)msg).mSender;
                                }
                                if (sender != null && channel.mMemberMap.containsKey(sender.getUserId())) {
                                    Member member = channel.mMemberMap.get(sender.getUserId());
                                    member.updatePropertiesBySender(sender);
                                }
                                if (sender != null && SendBird.this.mCurrentUser != null && sender.getUserId().equals(SendBird.this.mCurrentUser.getUserId())) {
                                    SendBird.this.mCurrentUser.updatePropertiesByUser(sender);
                                }
                                final boolean isMentionedFromSomeoneToMe = msg.isMentionedFromSomeoneToMe(sender);
                                if (channel.isEphemeral() && callChannelChanged) {
                                    channel.setLastMessage(msg);
                                    if (sender == null || SendBird.getCurrentUser() != null && !sender.getUserId().equals(SendBird.getCurrentUser().getUserId())) {
                                        channel.setUnreadMessageCount(channel.getUnreadMessageCount() + 1);
                                    }
                                    if (isMentionedFromSomeoneToMe) {
                                        channel.setUnreadMentionCount(channel.getUnreadMentionCount() + 1);
                                    }
                                }
                                SendBird.runOnUIThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                            handler.onMessageReceived(channel, msg);
                                            if (callChannelChanged) {
                                                handler.onChannelChanged(channel);
                                            }
                                            if (!isMentionedFromSomeoneToMe) continue;
                                            handler.onMentionReceived(channel, msg);
                                        }
                                    }
                                });
                            }
                        });
                        break;
                    }
                    GroupChannel.getChannel(msg.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                        @Override
                        public void onResult(final GroupChannel channel, SendBirdException e) {
                            boolean callChannelChanged;
                            if (e != null) {
                                Logger.d("Discard a command.");
                                return;
                            }
                            channel.setIsHidden(false);
                            Sender sender = null;
                            if (msg instanceof UserMessage) {
                                sender = ((UserMessage)msg).mSender;
                            } else if (msg instanceof FileMessage) {
                                sender = ((FileMessage)msg).mSender;
                            }
                            final boolean isMentionedFromSomeoneToMe = msg.isMentionedFromSomeoneToMe(sender);
                            if (!(msg instanceof AdminMessage && ((AdminMessage)msg).isSilent() || !channel.mHasBeenUpdated && channel.getLastMessage() != null && channel.getLastMessage().getCreatedAt() >= msg.getCreatedAt())) {
                                channel.setLastMessage(msg);
                                if (sender == null || SendBird.getCurrentUser() != null && !sender.getUserId().equals(SendBird.getCurrentUser().getUserId())) {
                                    channel.setUnreadMessageCount(channel.getUnreadMessageCount() + 1);
                                }
                                if (isMentionedFromSomeoneToMe) {
                                    channel.setUnreadMentionCount(channel.getUnreadMentionCount() + 1);
                                }
                                callChannelChanged = true;
                                channel.mHasBeenUpdated = true;
                            } else {
                                callChannelChanged = false;
                            }
                            if (sender != null && channel.mMemberMap.containsKey(sender.getUserId())) {
                                Member member = channel.mMemberMap.get(sender.getUserId());
                                member.updatePropertiesBySender(sender);
                            }
                            if (sender != null && SendBird.this.mCurrentUser != null && sender.getUserId().equals(SendBird.this.mCurrentUser.getUserId())) {
                                SendBird.this.mCurrentUser.updatePropertiesByUser(sender);
                            }
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        handler.onMessageReceived(channel, msg);
                                        if (callChannelChanged) {
                                            handler.onChannelChanged(channel);
                                        }
                                        if (!isMentionedFromSomeoneToMe) continue;
                                        handler.onMentionReceived(channel, msg);
                                    }
                                }
                            });
                        }
                    });
                    break;
                }
                OpenChannel.getChannel(msg.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                    @Override
                    public void onResult(final OpenChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command.");
                            return;
                        }
                        Sender sender = null;
                        if (msg instanceof UserMessage) {
                            sender = ((UserMessage)msg).mSender;
                        } else if (msg instanceof FileMessage) {
                            sender = ((FileMessage)msg).mSender;
                        }
                        final boolean isMentionedFromSomeoneToMe = msg.isMentionedFromSomeoneToMe(sender);
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (OpenChannel.isEnteredChannel(channel.getUrl())) {
                                        handler.onMessageReceived(channel, msg);
                                    }
                                    if (!isMentionedFromSomeoneToMe) continue;
                                    handler.onMentionReceived(channel, msg);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case "MEDI": 
            case "FEDI": 
            case "AEDI": {
                BaseMessage updatedMsg;
                switch (cmd.getCommand()) {
                    case "MEDI": {
                        updatedMsg = new UserMessage(cmd.getJsonElement());
                        break;
                    }
                    case "FEDI": {
                        updatedMsg = new FileMessage(cmd.getJsonElement());
                        break;
                    }
                    case "AEDI": {
                        updatedMsg = new AdminMessage(cmd.getJsonElement());
                        break;
                    }
                    default: {
                        Logger.d("Discard a command: " + cmd.getCommand());
                        return;
                    }
                }
                if (updatedMsg.isGroupChannel()) {
                    final boolean isCachedChannel = GroupChannel.sCachedChannels.containsKey(updatedMsg.getChannelUrl());
                    GroupChannel.getChannel(updatedMsg.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                        @Override
                        public void onResult(final GroupChannel channel, SendBirdException e) {
                            boolean callChannelChanged;
                            if (e != null) {
                                Logger.d("Discard a command.");
                                return;
                            }
                            boolean mentionReceived = false;
                            boolean unreadMentionCountChanged = false;
                            if (SendBird.getCurrentUser() != null && updatedMsg.getCreatedAt() > channel.getMyReadTs()) {
                                Sender sender = null;
                                if (updatedMsg instanceof UserMessage) {
                                    sender = ((UserMessage)updatedMsg).mSender;
                                } else if (updatedMsg instanceof FileMessage) {
                                    sender = ((FileMessage)updatedMsg).mSender;
                                }
                                JsonObject payload = cmd.getJsonElement().getAsJsonObject();
                                if (payload.has("old_values")) {
                                    BaseMessageParams.MentionType mentionType = updatedMsg.getMentionType();
                                    List<String> mentionedUserIds = updatedMsg.getMentionedUserIds();
                                    BaseMessageParams.MentionType oldMentionType = BaseMessageParams.MentionType.USERS;
                                    List<String> oldMentionedUserIds = null;
                                    JsonObject oldValuesObject = payload.get("old_values").getAsJsonObject();
                                    if (oldValuesObject.has("mention_type")) {
                                        String oldMentionTypeString = oldValuesObject.get("mention_type").getAsString();
                                        if (oldMentionTypeString.equals("users")) {
                                            oldMentionType = BaseMessageParams.MentionType.USERS;
                                        } else if (oldMentionTypeString.equals("channel")) {
                                            oldMentionType = BaseMessageParams.MentionType.CHANNEL;
                                        }
                                    } else {
                                        oldMentionType = mentionType;
                                    }
                                    if (oldValuesObject.has("mentioned_user_ids")) {
                                        JsonArray array = oldValuesObject.get("mentioned_user_ids").getAsJsonArray();
                                        if (array != null) {
                                            oldMentionedUserIds = new ArrayList<String>();
                                            for (int i = 0; i < array.size(); ++i) {
                                                oldMentionedUserIds.add(array.get(i).getAsString());
                                            }
                                        }
                                    } else {
                                        oldMentionedUserIds = mentionedUserIds;
                                    }
                                    boolean isMentionedFromSomeoneToMe = updatedMsg.isMentionedFromSomeoneToMe(sender);
                                    if (oldMentionType == BaseMessageParams.MentionType.USERS && mentionType == BaseMessageParams.MentionType.USERS) {
                                        if (mentionedUserIds != null && mentionedUserIds.contains(SendBird.getCurrentUser().getUserId()) && isMentionedFromSomeoneToMe) {
                                            if (isCachedChannel) {
                                                channel.setUnreadMentionCount(channel.getUnreadMentionCount() + 1);
                                            }
                                            unreadMentionCountChanged = true;
                                            mentionReceived = true;
                                        }
                                    } else if (oldMentionType == BaseMessageParams.MentionType.USERS && mentionType == BaseMessageParams.MentionType.CHANNEL && oldMentionedUserIds != null && !oldMentionedUserIds.contains(SendBird.getCurrentUser().getUserId()) && isMentionedFromSomeoneToMe) {
                                        if (isCachedChannel) {
                                            channel.setUnreadMentionCount(channel.getUnreadMentionCount() + 1);
                                        }
                                        unreadMentionCountChanged = true;
                                        mentionReceived = true;
                                    }
                                }
                            }
                            if (unreadMentionCountChanged || (!(updatedMsg instanceof AdminMessage) || !((AdminMessage)updatedMsg).isSilent()) && channel.getLastMessage() != null && channel.getLastMessage().getMessageId() == updatedMsg.getMessageId() && channel.getLastMessage().getUpdatedAt() < updatedMsg.getUpdatedAt()) {
                                channel.setLastMessage(updatedMsg);
                                callChannelChanged = true;
                            } else {
                                callChannelChanged = false;
                            }
                            final boolean paramMentionReceived = mentionReceived;
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        handler.onMessageUpdated(channel, updatedMsg);
                                        if (callChannelChanged) {
                                            handler.onChannelChanged(channel);
                                        }
                                        if (!paramMentionReceived) continue;
                                        handler.onMentionReceived(channel, updatedMsg);
                                    }
                                }
                            });
                        }
                    });
                    break;
                }
                OpenChannel.getChannel(updatedMsg.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                    @Override
                    public void onResult(final OpenChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command.");
                            return;
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onMessageUpdated(channel, updatedMsg);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case "READ": {
                final ReadStatus rst = new ReadStatus(cmd.getJsonElement());
                if (!GroupChannel.sCachedChannels.containsKey(rst.getChannelUrl())) {
                    GroupChannel.getChannelWithoutCache(rst.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                        @Override
                        public void onResult(final GroupChannel channel, SendBirdException e) {
                            if (e != null) {
                                Logger.d("Discard a command. ");
                                return;
                            }
                            final boolean readFromMyself = SendBird.getCurrentUser() != null && rst.getReader().getUserId().equals(SendBird.getCurrentUser().getUserId());
                            final boolean callChannelChanged = readFromMyself && (channel.getUnreadMessageCount() == 0 || channel.getUnreadMentionCount() == 0);
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        if (!readFromMyself) {
                                            handler.onReadReceiptUpdated(channel);
                                        }
                                        if (!callChannelChanged) continue;
                                        handler.onChannelChanged(channel);
                                    }
                                }
                            });
                        }
                    });
                    break;
                }
                GroupChannel.getChannel(rst.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        boolean callChannelChanged;
                        boolean readFromMyself;
                        if (e != null) {
                            Logger.d("Discard a command. ");
                            return;
                        }
                        channel.updateReadReceipt(rst.getReader().getUserId(), rst.getTimestamp());
                        boolean bl = readFromMyself = SendBird.getCurrentUser() != null && rst.getReader().getUserId().equals(SendBird.getCurrentUser().getUserId());
                        if (readFromMyself && (channel.getUnreadMessageCount() > 0 || channel.getUnreadMentionCount() > 0)) {
                            channel.setUnreadMessageCount(0);
                            channel.setUnreadMentionCount(0);
                            callChannelChanged = channel.getUnreadMessageCount() == 0 || channel.getUnreadMentionCount() == 0;
                        } else {
                            callChannelChanged = false;
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (!readFromMyself) {
                                        handler.onReadReceiptUpdated(channel);
                                    }
                                    if (!callChannelChanged) continue;
                                    handler.onChannelChanged(channel);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case "TPST": 
            case "TPEN": {
                break;
            }
            case "MTIO": {
                break;
            }
            case "SYEV": {
                this.processChannelEvent(cmd);
                break;
            }
            case "USEV": {
                this.processUserEvent(cmd);
                break;
            }
            case "DELM": {
                JsonObject obj = cmd.getJsonElement().getAsJsonObject();
                String channelType = obj.get("channel_type").getAsString();
                String channelUrl = obj.get("channel_url").getAsString();
                final long msgId = obj.get("msg_id").getAsLong();
                switch (channelType) {
                    case "open": {
                        OpenChannel.getChannel(channelUrl, new OpenChannel.OpenChannelGetHandler(){

                            @Override
                            public void onResult(final OpenChannel channel, SendBirdException e) {
                                if (e != null) {
                                    Logger.d("Discard a command.");
                                    return;
                                }
                                SendBird.runOnUIThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                            handler.onMessageDeleted(channel, msgId);
                                        }
                                    }
                                });
                            }
                        });
                        break block36;
                    }
                    case "group": {
                        GroupChannel.getChannel(channelUrl, new GroupChannel.GroupChannelGetHandler(){

                            @Override
                            public void onResult(final GroupChannel channel, SendBirdException e) {
                                if (e != null) {
                                    Logger.d("Discard a command.");
                                    return;
                                }
                                SendBird.runOnUIThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                            handler.onMessageDeleted(channel, msgId);
                                        }
                                    }
                                });
                            }
                        });
                        break block36;
                    }
                }
                Logger.d("Discard a command.");
                return;
            }
            case "LEAV": {
                break;
            }
            case "JOIN": {
                break;
            }
            default: {
                Logger.d("Discard a command: " + cmd.getCommand());
            }
        }
    }

    private void processSubscribedUnreadMessageCount(Command cmd) {
        JsonObject obj;
        if (cmd.getCommand().equals("LOGI")) {
            this.mSubscribedUnreadMessageCount.init();
        }
        if ((obj = cmd.getJsonElement().getAsJsonObject()) != null && obj.has("unread_cnt")) {
            long ts;
            JsonObject unreadCntObj = obj.getAsJsonObject("unread_cnt");
            long l = ts = unreadCntObj.has("ts") ? unreadCntObj.get("ts").getAsLong() : 0L;
            if (ts > this.mSubscribedUnreadMessageCount.mTimestamp) {
                this.mSubscribedUnreadMessageCount.mTimestamp = ts;
                if (unreadCntObj.has("all")) {
                    this.mSubscribedUnreadMessageCount.mTotalCount = unreadCntObj.get("all").getAsInt();
                }
                if (unreadCntObj.has("custom_types")) {
                    JsonObject customTypesObj = unreadCntObj.getAsJsonObject("custom_types");
                    for (Map.Entry<String, JsonElement> entry : customTypesObj.entrySet()) {
                        String key = entry.getKey();
                        if (!entry.getValue().isJsonPrimitive()) continue;
                        int value = entry.getValue().getAsInt();
                        this.mSubscribedUnreadMessageCount.mCustomTypeMap.put(key, value);
                    }
                    this.mSubscribedUnreadMessageCount.mTotalCountByCustomTypes = 0;
                    for (Integer count : this.mSubscribedUnreadMessageCount.mCustomTypeMap.values()) {
                        if (count == null) continue;
                        this.mSubscribedUnreadMessageCount.mTotalCountByCustomTypes += count.intValue();
                    }
                }
            }
        }
    }

    private void processChannelEvent(final Command cmd) {
        final ChannelEvent event = new ChannelEvent(cmd.getJsonElement());
        switch (event.getCategory()) {
            case 10020: {
                GroupChannel.getChannel(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        if (channel.isSuper()) {
                            channel.setMemberCount(event.getData(), event.getTs());
                        }
                        final User inviter = new User(event.getData().getAsJsonObject().get("inviter"));
                        final ArrayList<Member> invitees = new ArrayList<Member>();
                        JsonArray inviteesArray = event.getData().getAsJsonObject().get("invitees").getAsJsonArray();
                        for (JsonElement inviteeEl : inviteesArray) {
                            JsonObject inviteeObj = inviteeEl.getAsJsonObject();
                            String userId = inviteeObj.get("user_id").getAsString();
                            Member inviteeInCache = channel.mMemberMap.get(userId);
                            if (SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(userId)) {
                                channel.setIsHidden(false);
                                if (channel.getMyMemberState() != Member.MemberState.JOINED) {
                                    channel.setMyMemberState(Member.MemberState.INVITED);
                                }
                                if (event.getData().getAsJsonObject().has("invited_at")) {
                                    channel.setInvitedAt(event.getData().getAsJsonObject().get("invited_at").getAsLong());
                                }
                            }
                            if (inviteeInCache == null) {
                                inviteeObj.addProperty("state", "invited");
                                Member invitee = new Member(inviteeObj);
                                if (!channel.isSuper()) {
                                    channel.addMember(invitee);
                                }
                                invitees.add(invitee);
                                continue;
                            }
                            invitees.add(inviteeInCache);
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onUserReceivedInvitation(channel, inviter, invitees);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10022: {
                GroupChannel.getChannel(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        final User inviter = new User(event.getData().getAsJsonObject().get("inviter"));
                        JsonElement inviteeEl = event.getData().getAsJsonObject().get("invitee");
                        final Member invitee = new Member(inviteeEl);
                        if (channel.isSuper()) {
                            channel.setMemberCount(event.getData(), event.getTs());
                        } else {
                            channel.removeMember(invitee);
                        }
                        if (SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(invitee.getUserId())) {
                            channel.setMyMemberState(Member.MemberState.NONE);
                            channel.setInvitedAt(0L);
                            if (!channel.isPublic()) {
                                GroupChannel.removeChannelFromCache(channel.getUrl());
                            }
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onUserDeclinedInvitation(channel, inviter, invitee);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10000: 
            case 10001: {
                GroupChannel.getChannel(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        if (event.getCategory() == 10000) {
                            ArrayList<Member> members = new ArrayList<Member>();
                            if (event.getData().getAsJsonObject().has("users")) {
                                JsonArray membersArray = event.getData().getAsJsonObject().get("users").getAsJsonArray();
                                for (int i = 0; i < membersArray.size(); ++i) {
                                    members.add(new Member(membersArray.get(i)));
                                }
                            } else {
                                members.add(new Member(event.getData()));
                            }
                            for (int i = 0; i < members.size(); ++i) {
                                final Member member = (Member)members.get(i);
                                if (channel.isSuper()) {
                                    channel.setMemberCount(event.getData(), event.getTs());
                                } else {
                                    channel.addMember(member);
                                    channel.updateJoinedMemberCount();
                                }
                                if (SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(member.getUserId())) {
                                    channel.setMyMemberState(Member.MemberState.JOINED);
                                }
                                SendBird.runOnUIThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                            handler.onUserJoined(channel, member);
                                        }
                                    }
                                });
                            }
                        } else {
                            final Member member = new Member(event.getData());
                            if (channel.isSuper()) {
                                channel.setMemberCount(event.getData(), event.getTs());
                            } else {
                                channel.removeMember(member);
                                channel.updateJoinedMemberCount();
                            }
                            if (SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(member.getUserId())) {
                                channel.setMyMemberState(Member.MemberState.NONE);
                                channel.setUnreadMessageCount(0);
                                channel.setUnreadMentionCount(0);
                                channel.setInvitedAt(0L);
                                if (!channel.isPublic()) {
                                    GroupChannel.removeChannelFromCache(channel.getUrl());
                                }
                            }
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        handler.onUserLeft(channel, member);
                                    }
                                }
                            });
                        }
                    }
                });
                break;
            }
            case 10900: 
            case 10901: {
                GroupChannel.getChannel(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        User user = new User(event.getData());
                        if (event.getCategory() == 10900) {
                            channel.updateTypingStatus(user, true);
                        } else {
                            channel.updateTypingStatus(user, false);
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onTypingStatusUpdated(channel);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10102: 
            case 10103: {
                OpenChannel.getChannel(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                    @Override
                    public void onResult(final OpenChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        JsonObject obj = event.getData().getAsJsonObject();
                        if (obj.has("participant_count")) {
                            channel.setParticipantCount(obj.get("participant_count").getAsInt());
                        }
                        final User user = new User(event.getData());
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (event.getCategory() == 10102) {
                                        handler.onUserEntered(channel, user);
                                        continue;
                                    }
                                    handler.onUserExited(channel, user);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10200: 
            case 10201: {
                if (event.isOpenChannel()) {
                    OpenChannel.getChannel(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                        @Override
                        public void onResult(final OpenChannel channel, SendBirdException e) {
                            if (e != null) {
                                Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                                return;
                            }
                            final User user = new User(event.getData());
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        if (event.getCategory() == 10201) {
                                            handler.onUserMuted(channel, user);
                                            continue;
                                        }
                                        handler.onUserUnmuted(channel, user);
                                    }
                                }
                            });
                        }
                    });
                    break;
                }
                GroupChannel.getChannel(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        final User user = new User(event.getData());
                        if (SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(user.getUserId())) {
                            if (event.getCategory() == 10201) {
                                channel.setMyMutedState(Member.MutedState.MUTED);
                            } else {
                                channel.setMyMutedState(Member.MutedState.UNMUTED);
                            }
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (event.getCategory() == 10201) {
                                        handler.onUserMuted(channel, user);
                                        continue;
                                    }
                                    handler.onUserUnmuted(channel, user);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10600: 
            case 10601: {
                if (event.isOpenChannel()) {
                    OpenChannel.getChannel(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                        @Override
                        public void onResult(final OpenChannel channel, SendBirdException e) {
                            if (e != null) {
                                Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                                return;
                            }
                            final User user = new User(event.getData());
                            if (event.getCategory() == 10601 && SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(user.getUserId())) {
                                OpenChannel.removeChannelFromEntered(channel.getUrl());
                            }
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        if (event.getCategory() == 10601) {
                                            handler.onUserBanned(channel, user);
                                            continue;
                                        }
                                        handler.onUserUnbanned(channel, user);
                                    }
                                }
                            });
                        }
                    });
                    break;
                }
                GroupChannel.getChannel(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        final User user = new User(event.getData());
                        if (event.getCategory() == 10601) {
                            if (channel.isSuper()) {
                                channel.setMemberCount(event.getData(), event.getTs());
                            } else {
                                channel.removeMember(user);
                                channel.updateJoinedMemberCount();
                            }
                            if (SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(user.getUserId())) {
                                channel.setMyMemberState(Member.MemberState.NONE);
                                channel.setUnreadMessageCount(0);
                                channel.setUnreadMentionCount(0);
                                channel.setInvitedAt(0L);
                                if (!channel.isPublic()) {
                                    GroupChannel.removeChannelFromCache(channel.getUrl());
                                }
                            }
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (event.getCategory() == 10601) {
                                        handler.onUserBanned(channel, user);
                                        continue;
                                    }
                                    handler.onUserUnbanned(channel, user);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10700: 
            case 10701: {
                if (event.isOpenChannel()) {
                    OpenChannel.getChannel(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                        @Override
                        public void onResult(final OpenChannel channel, SendBirdException e) {
                            if (e != null) {
                                Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                                return;
                            }
                            JsonObject jsonObject = event.getData().getAsJsonObject();
                            if (jsonObject.has("freeze")) {
                                channel.setFreeze(jsonObject.get("freeze").getAsBoolean());
                            }
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        if (event.getCategory() == 10701) {
                                            handler.onChannelFrozen(channel);
                                            continue;
                                        }
                                        handler.onChannelUnfrozen(channel);
                                    }
                                }
                            });
                        }
                    });
                    break;
                }
                GroupChannel.getChannel(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        JsonObject jsonObject = event.getData().getAsJsonObject();
                        if (jsonObject.has("freeze")) {
                            channel.setFreeze(jsonObject.get("freeze").getAsBoolean());
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (event.getCategory() == 10701) {
                                        handler.onChannelFrozen(channel);
                                        continue;
                                    }
                                    handler.onChannelUnfrozen(channel);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 11000: {
                if (event.isOpenChannel()) {
                    OpenChannel.getChannelWithoutCache(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                        @Override
                        public void onResult(final OpenChannel channel, SendBirdException e) {
                            if (e != null) {
                                Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                                return;
                            }
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        handler.onChannelChanged(channel);
                                    }
                                }
                            });
                        }
                    });
                    break;
                }
                GroupChannel.getChannelWithoutCache(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        if (!channel.isMyUnreadMessageCountEnabled()) {
                            channel.setUnreadMessageCount(0);
                        }
                        if (!channel.isMyUnreadMentionCountEnabled()) {
                            channel.setUnreadMentionCount(0);
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onChannelChanged(channel);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 12000: {
                if (event.isOpenChannel()) {
                    OpenChannel.removeChannelFromCache(event.getChannelUrl());
                    OpenChannel.removeChannelFromEntered(event.getChannelUrl());
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                handler.onChannelDeleted(event.getChannelUrl(), BaseChannel.ChannelType.OPEN);
                            }
                        }
                    });
                    break;
                }
                GroupChannel.removeChannelFromCache(event.getChannelUrl());
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                            handler.onChannelDeleted(event.getChannelUrl(), BaseChannel.ChannelType.GROUP);
                        }
                    }
                });
                break;
            }
            case 11100: 
            case 11200: {
                if (event.isOpenChannel()) {
                    OpenChannel.getChannel(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                        @Override
                        public void onResult(OpenChannel channel, SendBirdException e) {
                            if (e != null) {
                                Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                                return;
                            }
                            SendBird.this.processChannelMetaDataAndCountersChangedEvent(channel, event);
                        }
                    });
                    break;
                }
                GroupChannel.getChannel(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        SendBird.this.processChannelMetaDataAndCountersChangedEvent(channel, event);
                    }
                });
                break;
            }
            case 13000: {
                if (!event.isGroupChannel()) break;
                GroupChannel.getChannel(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        channel.setIsHidden(true);
                        JsonObject jsonObject = event.getData().getAsJsonObject();
                        if (jsonObject.has("hide_previous_messages") && jsonObject.get("hide_previous_messages").getAsBoolean()) {
                            channel.setUnreadMessageCount(0);
                            channel.setUnreadMentionCount(0);
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onChannelHidden(channel);
                                }
                            }
                        });
                    }
                });
            }
        }
    }

    private void processChannelMetaDataAndCountersChangedEvent(final BaseChannel channel, ChannelEvent event) {
        try {
            JsonObject jsonObject = event.getData().getAsJsonObject();
            if (event.getCategory() == 11100) {
                JsonObject obj;
                Cloneable result;
                if (jsonObject.has("created")) {
                    result = new HashMap();
                    obj = jsonObject.getAsJsonObject("created");
                    for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                        if (!entry.getValue().isJsonPrimitive()) continue;
                        ((HashMap)result).put(entry.getKey(), entry.getValue().getAsString());
                    }
                    SendBird.runOnUIThread(new Runnable((HashMap)result){
                        final /* synthetic */ HashMap val$result;
                        {
                            this.val$result = hashMap;
                        }

                        @Override
                        public void run() {
                            for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                handler.onMetaDataCreated(channel, this.val$result);
                            }
                        }
                    });
                }
                if (jsonObject.has("updated")) {
                    result = new HashMap();
                    obj = jsonObject.getAsJsonObject("updated");
                    for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                        if (!entry.getValue().isJsonPrimitive()) continue;
                        ((HashMap)result).put(entry.getKey(), entry.getValue().getAsString());
                    }
                    SendBird.runOnUIThread(new Runnable((HashMap)result){
                        final /* synthetic */ HashMap val$result;
                        {
                            this.val$result = hashMap;
                        }

                        @Override
                        public void run() {
                            for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                handler.onMetaDataUpdated(channel, this.val$result);
                            }
                        }
                    });
                }
                if (jsonObject.has("deleted")) {
                    result = new ArrayList();
                    JsonArray array = jsonObject.getAsJsonArray("deleted");
                    for (int i = 0; i < array.size(); ++i) {
                        if (!array.get(i).isJsonPrimitive()) continue;
                        result.add(array.get(i).getAsString());
                    }
                    SendBird.runOnUIThread(new Runnable((List)((Object)result)){
                        final /* synthetic */ List val$result;
                        {
                            this.val$result = list;
                        }

                        @Override
                        public void run() {
                            for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                handler.onMetaDataDeleted(channel, this.val$result);
                            }
                        }
                    });
                }
            } else {
                JsonObject obj;
                Cloneable result;
                if (jsonObject.has("created")) {
                    result = new HashMap();
                    obj = jsonObject.getAsJsonObject("created");
                    for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                        if (!entry.getValue().isJsonPrimitive()) continue;
                        ((HashMap)result).put(entry.getKey(), entry.getValue().getAsInt());
                    }
                    SendBird.runOnUIThread(new Runnable((HashMap)result){
                        final /* synthetic */ HashMap val$result;
                        {
                            this.val$result = hashMap;
                        }

                        @Override
                        public void run() {
                            for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                handler.onMetaCountersCreated(channel, this.val$result);
                            }
                        }
                    });
                }
                if (jsonObject.has("updated")) {
                    result = new HashMap();
                    obj = jsonObject.getAsJsonObject("updated");
                    for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                        if (!entry.getValue().isJsonPrimitive()) continue;
                        ((HashMap)result).put(entry.getKey(), entry.getValue().getAsInt());
                    }
                    SendBird.runOnUIThread(new Runnable((HashMap)result){
                        final /* synthetic */ HashMap val$result;
                        {
                            this.val$result = hashMap;
                        }

                        @Override
                        public void run() {
                            for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                handler.onMetaCountersUpdated(channel, this.val$result);
                            }
                        }
                    });
                }
                if (jsonObject.has("deleted")) {
                    result = new ArrayList();
                    JsonArray array = jsonObject.getAsJsonArray("deleted");
                    for (int i = 0; i < array.size(); ++i) {
                        if (!array.get(i).isJsonPrimitive()) continue;
                        result.add(array.get(i).getAsString());
                    }
                    SendBird.runOnUIThread(new Runnable((List)((Object)result)){
                        final /* synthetic */ List val$result;
                        {
                            this.val$result = list;
                        }

                        @Override
                        public void run() {
                            for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                handler.onMetaCountersDeleted(channel, this.val$result);
                            }
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processUserEvent(Command cmd) {
        UserEvent event = new UserEvent(cmd.getJsonElement());
        switch (event.getCategory()) {
            case 20000: {
                Member member;
                User blocker = null;
                User blockee = null;
                if (event.getData() != null && event.getData().getAsJsonObject().has("blocker") && event.getData().getAsJsonObject().has("blockee")) {
                    blocker = new User(event.getData().getAsJsonObject().get("blocker"));
                    blockee = new User(event.getData().getAsJsonObject().get("blockee"));
                }
                if (blocker == null || blockee == null) break;
                if (SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(blocker.getUserId())) {
                    for (Map.Entry<String, GroupChannel> cachedChannel : GroupChannel.sCachedChannels.entrySet()) {
                        member = cachedChannel.getValue().mMemberMap.get(blockee.getUserId());
                        if (member == null) continue;
                        member.setIsBlockedByMe(false);
                    }
                }
                if (SendBird.getCurrentUser() == null || !SendBird.getCurrentUser().getUserId().equals(blockee.getUserId())) break;
                for (Map.Entry<String, GroupChannel> cachedChannel : GroupChannel.sCachedChannels.entrySet()) {
                    member = cachedChannel.getValue().mMemberMap.get(blocker.getUserId());
                    if (member == null) continue;
                    member.setIsBlockingMe(false);
                }
                break;
            }
            case 20001: {
                Member member;
                User blocker = null;
                User blockee = null;
                if (event.getData() != null && event.getData().getAsJsonObject().has("blocker") && event.getData().getAsJsonObject().has("blockee")) {
                    blocker = new User(event.getData().getAsJsonObject().get("blocker"));
                    blockee = new User(event.getData().getAsJsonObject().get("blockee"));
                }
                if (blocker == null || blockee == null) break;
                if (SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(blocker.getUserId())) {
                    for (Map.Entry<String, GroupChannel> cachedChannel : GroupChannel.sCachedChannels.entrySet()) {
                        member = cachedChannel.getValue().mMemberMap.get(blockee.getUserId());
                        if (member == null) continue;
                        member.setIsBlockedByMe(true);
                    }
                }
                if (SendBird.getCurrentUser() == null || !SendBird.getCurrentUser().getUserId().equals(blockee.getUserId())) break;
                for (Map.Entry<String, GroupChannel> cachedChannel : GroupChannel.sCachedChannels.entrySet()) {
                    member = cachedChannel.getValue().mMemberMap.get(blocker.getUserId());
                    if (member == null) continue;
                    member.setIsBlockingMe(true);
                }
                break;
            }
            case 20900: {
                if (event.getData() == null || !event.getData().getAsJsonObject().has("friend_discoveries")) break;
                JsonObject result = event.getData().getAsJsonObject();
                JsonArray usersArray = result.get("friend_discoveries").getAsJsonArray();
                final ArrayList<User> users = new ArrayList<User>();
                for (int i = 0; i < usersArray.size(); ++i) {
                    users.add(new User(usersArray.get(i)));
                }
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (UserEventHandler handler : SendBird.this.mUserEventHandlers.values()) {
                            handler.onFriendsDiscovered(users);
                        }
                    }
                });
            }
        }
    }

    void sendCommand(final Command cmd, boolean lazy, final Command.SendCommandHandler handler) {
        if (this.mWSClient == null || this.mWSClient.getConnectionState() != ConnectionState.OPEN && !lazy) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("WS connection closed.", 800200));
            }
            return;
        }
        if (cmd.isAckRequired()) {
            this.startAckTimer(cmd, handler);
            if (this.mWSClient != null) {
                this.mWSClient.send(cmd, lazy, new WSClient.WSClientSendHandler(){

                    @Override
                    public void onResult(SendBirdException e) {
                        if (e != null) {
                            HashMap ackInfo = SendBird.this.getAckInfo(cmd.getRequestId());
                            if (ackInfo != null) {
                                CountDownTimer timer = (CountDownTimer)ackInfo.get("timer");
                                Command.SendCommandHandler handler2 = (Command.SendCommandHandler)ackInfo.get("handler");
                                timer.stop();
                            }
                            if (handler != null) {
                                handler.onResult(null, e);
                            }
                            return;
                        }
                    }
                });
            }
        } else if (this.mWSClient != null) {
            this.mWSClient.send(cmd, lazy, new WSClient.WSClientSendHandler(){

                @Override
                public void onResult(SendBirdException e) {
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    if (handler != null) {
                        handler.onResult(null, null);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAckTimer(Command command, final Command.SendCommandHandler handler) {
        final SendBird I = SendBird.getInstance();
        final String reqId = command.getRequestId();
        CountDownTimer timer = new CountDownTimer(10000, 100);
        timer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){

            @Override
            public void onStart() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStop() {
                Object object = I.mAckStateMapLock;
                synchronized (object) {
                    SendBird.this.mAckStateMap.remove(reqId);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCancel() {
                Object object = I.mAckStateMapLock;
                synchronized (object) {
                    SendBird.this.mAckStateMap.remove(reqId);
                }
            }

            @Override
            public void onTimeout() {
                handler.onResult(null, new SendBirdException("Command received no ack.", 800180));
            }

            @Override
            public void onTick(int timeout, int elapsed) {
            }
        });
        Object object = I.mAckStateMapLock;
        synchronized (object) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("handler", handler);
            map.put("timer", timer);
            this.mAckStateMap.put(reqId, map);
        }
        timer.start();
    }

    private HashMap<String, Object> getAckInfo(String requestId) {
        return this.mAckStateMap.get(requestId);
    }

    private String getStringPref(String key) {
        String result = null;
        if (this.mAppContext != null) {
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)this.mAppContext);
            result = sp.getString(key, null);
        }
        return result;
    }

    private void setStringPref(String key, String value) {
        if (this.mAppContext != null) {
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)this.mAppContext);
            SharedPreferences.Editor editor = sp.edit();
            editor.putString(key, value);
            editor.commit();
        }
    }

    String getAPIHostFromPref() {
        return this.getStringPref(this.mPrefApiHost);
    }

    void setAPIHostToPref(String apiHost) {
        this.setStringPref(this.mPrefApiHost, apiHost);
    }

    String getWSHostFromPref() {
        return this.getStringPref(this.mPrefWsHost);
    }

    void setWSHostToPref(String wsHost) {
        this.setStringPref(this.mPrefWsHost, wsHost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAuthenticationTimer(Timer timer) {
        Object object = this.mAuthenticationTimers;
        synchronized (object) {
            if (timer != null) {
                this.mAuthenticationTimers.add(timer);
            }
        }
        object = this.mConnectingLock;
        synchronized (object) {
            this.mConnecting = true;
        }
        Logger.d("[ConnectionManager] addAuthenticationTimer() => " + this.mAuthenticationTimers.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeAuthenticationTimer(Timer timer) {
        boolean removed = false;
        Object object = this.mAuthenticationTimers;
        synchronized (object) {
            if (timer != null) {
                timer.cancel();
                removed = this.mAuthenticationTimers.remove(timer);
            }
        }
        if (this.mConnecting && this.mConnectHandlers.isEmpty() && this.mAuthenticationTimers.isEmpty()) {
            object = this.mConnectingLock;
            synchronized (object) {
                this.mConnecting = false;
            }
        }
        Logger.d("[ConnectionManager] removeAuthenticationTimer() => " + this.mAuthenticationTimers.size());
        return removed;
    }

    public static void getTotalUnreadMessageCount(GroupChannel.GroupChannelTotalUnreadMessageCountHandler handler) {
        SendBird.localGetTotalUnreadMessageCount(null, null, handler);
    }

    public static void getTotalUnreadMessageCount(List<String> channelCustomTypes, GroupChannel.GroupChannelTotalUnreadMessageCountHandler handler) {
        SendBird.localGetTotalUnreadMessageCount(null, channelCustomTypes, handler);
    }

    public static void getTotalUnreadMessageCount(GroupChannelTotalUnreadMessageCountParams params, GroupChannel.GroupChannelTotalUnreadMessageCountHandler handler) {
        SendBird.localGetTotalUnreadMessageCount(params.mSuperChannelFilter, params.mChannelCustomTypes, handler);
    }

    static void localGetTotalUnreadMessageCount(GroupChannelTotalUnreadMessageCountParams.SuperChannelFilter superChannelFilter, List<String> channelCustomTypes, final GroupChannel.GroupChannelTotalUnreadMessageCountHandler handler) {
        APIClient.getInstance().getTotalUnreadMessageCount(superChannelFilter, channelCustomTypes, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(0, e);
                            }
                        });
                    }
                    return;
                }
                final int unreadCount = response.getAsJsonObject().get("unread_count").getAsInt();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(unreadCount, null);
                        }
                    });
                }
            }
        });
    }

    public static int getSubscribedTotalUnreadMessageCount() {
        return SendBird.getInstance().mSubscribedUnreadMessageCount.mTotalCount;
    }

    public static int getSubscribedCustomTypeTotalUnreadMessageCount() {
        return SendBird.getInstance().mSubscribedUnreadMessageCount.mTotalCountByCustomTypes;
    }

    public static int getSubscribedCustomTypeUnreadMessageCount(String customType) {
        Integer count;
        int result = 0;
        if (customType != null && (count = SendBird.getInstance().mSubscribedUnreadMessageCount.mCustomTypeMap.get(customType)) != null) {
            result = count;
        }
        return result;
    }

    public static void getUnreadItemCount(Collection<GroupChannel.UnreadItemKey> keys, final GroupChannel.GroupChannelGetUnreadItemCountHandler handler) {
        if (keys == null || keys.size() <= 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().getUnreadItemCount(keys, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                final HashMap<GroupChannel.UnreadItemKey, Integer> result = new HashMap<GroupChannel.UnreadItemKey, Integer>();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    GroupChannel.UnreadItemKey unreadItemKey = null;
                    String key = entry.getKey();
                    if (key.equals("group_channel_unread_message_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.GROUP_CHANNEL_UNREAD_MESSAGE_COUNT;
                    } else if (key.equals("group_channel_unread_mention_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.GROUP_CHANNEL_UNREAD_MENTION_COUNT;
                    } else if (key.equals("group_channel_invitation_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.GROUP_CHANNEL_INVITATION_COUNT;
                    } else if (key.equals("non_super_group_channel_unread_message_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.NONSUPER_UNREAD_MESSAGE_COUNT;
                    } else if (key.equals("super_group_channel_unread_message_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.SUPER_UNREAD_MESSAGE_COUNT;
                    } else if (key.equals("non_super_group_channel_unread_mention_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.NONSUPER_UNREAD_MENTION_COUNT;
                    } else if (key.equals("super_group_channel_unread_mention_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.SUPER_UNREAD_MENTION_COUNT;
                    } else if (key.equals("non_super_group_channel_invitation_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.NONSUPER_INVITATION_COUNT;
                    } else if (key.equals("super_group_channel_invitation_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.SUPER_INVITATION_COUNT;
                    }
                    if (unreadItemKey == null) continue;
                    result.put(unreadItemKey, entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public static void getTotalUnreadChannelCount(final GroupChannel.GroupChannelTotalUnreadChannelCountHandler handler) {
        APIClient.getInstance().getTotalUnreadChannelCount(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(0, e);
                            }
                        });
                    }
                    return;
                }
                final int unreadCount = response.getAsJsonObject().get("unread_count").getAsInt();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(unreadCount, null);
                        }
                    });
                }
            }
        });
    }

    public static void getGroupChannelCount(GroupChannelListQuery.MemberStateFilter memberStateFilter, GroupChannel.GroupChannelChannelCountHandler handler) {
        String state;
        switch (memberStateFilter) {
            case ALL: {
                state = "all";
                break;
            }
            case INVITED: {
                state = "invited";
                break;
            }
            case INVITED_BY_FRIEND: {
                state = "invited_by_friend";
                break;
            }
            case INVITED_BY_NON_FRIEND: {
                state = "invited_by_non_friend";
                break;
            }
            case JOINED: {
                state = "joined";
                break;
            }
            default: {
                state = null;
            }
        }
        SendBird.localGetGroupChannelCount(state, handler);
    }

    static void localGetGroupChannelCount(String state, final GroupChannel.GroupChannelChannelCountHandler handler) {
        APIClient.getInstance().getChannelCount(state, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(0, e);
                            }
                        });
                    }
                    return;
                }
                final int myChannelCount = response.getAsJsonObject().get("group_channel_count").getAsInt();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(myChannelCount, null);
                        }
                    });
                }
            }
        });
    }

    static {
        sUIThreadHandler = new Handler(Looper.getMainLooper());
    }

    private class NetworkReceiver
    extends BroadcastReceiver {
        private boolean mNeedReconnect = false;

        private NetworkReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            NetworkInfo networkInfo = null;
            try {
                networkInfo = SendBird.this.mConnectivityManager.getActiveNetworkInfo();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (networkInfo != null && networkInfo.isConnected()) {
                if (this.mNeedReconnect && !SendBird.this.mIsAppBackground) {
                    this.mNeedReconnect = false;
                    try {
                        if (SendBird.getNetworkAwarenessReconnection()) {
                            SendBird.reconnect(true);
                        }
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
            } else if (networkInfo == null) {
                this.mNeedReconnect = true;
            }
        }
    }

    private static abstract class ApplicationStateHandler {
        private ApplicationStateHandler() {
        }

        abstract void start();

        abstract void stop();

        abstract void onActivityResumed();

        abstract void onActivityPaused();
    }

    public static interface MarkAsReadHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetFriendChangeLogsByTokenHandler {
        public void onResult(List<User> var1, List<String> var2, boolean var3, String var4, SendBirdException var5);
    }

    public static interface DeleteFriendDiscoveryHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface DeleteFriendDiscoveriesHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface UploadFriendDiscoveriesHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface DeleteFriendHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface DeleteFriendsHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface AddFriendsHandler {
        public void onResult(List<User> var1, SendBirdException var2);
    }

    public static interface UserUnblockHandler {
        public void onUnblocked(SendBirdException var1);
    }

    public static interface UserBlockHandler {
        public void onBlocked(User var1, SendBirdException var2);
    }

    public static interface GetChannelInvitationPreferenceHandler {
        public void onResult(boolean var1, SendBirdException var2);
    }

    public static interface SetChannelInvitationPreferenceHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface UserInfoUpdateHandler {
        public void onUpdated(SendBirdException var1);
    }

    public static interface GetPushTemplateHandler {
        public void onResult(String var1, SendBirdException var2);
    }

    public static interface SetPushTemplateHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetPushSoundHandler {
        public void onResult(String var1, SendBirdException var2);
    }

    public static interface SetPushSoundHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetDoNotDisturbHandler {
        public void onResult(boolean var1, int var2, int var3, int var4, int var5, String var6, SendBirdException var7);
    }

    public static interface SetDoNotDisturbHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface UnregisterPushTokenHandler {
        public void onUnregistered(SendBirdException var1);
    }

    public static interface RegisterPushTokenWithStatusHandler {
        public void onRegistered(PushTokenRegistrationStatus var1, SendBirdException var2);
    }

    @Deprecated
    public static interface RegisterPushTokenHandler {
        @Deprecated
        public void onRegistered(SendBirdException var1);
    }

    public static enum PushTokenRegistrationStatus {
        SUCCESS,
        PENDING,
        ERROR;

    }

    public static interface DisconnectHandler {
        public void onDisconnected();
    }

    static interface LocalNetworkHandler {
        public void onLocalUnexpectedDisconnect();

        public void onLocalReconnected();

        public void onLocalReconnectFailed();
    }

    public static interface ConnectionHandler {
        public void onReconnectStarted();

        public void onReconnectSucceeded();

        public void onReconnectFailed();
    }

    public static abstract class UserEventHandler {
        public abstract void onFriendsDiscovered(List<User> var1);
    }

    public static abstract class ChannelHandler {
        public abstract void onMessageReceived(BaseChannel var1, BaseMessage var2);

        public void onMentionReceived(BaseChannel channel, BaseMessage message) {
        }

        public void onMessageDeleted(BaseChannel channel, long msgId) {
        }

        public void onMessageUpdated(BaseChannel channel, BaseMessage message) {
        }

        public void onChannelChanged(BaseChannel channel) {
        }

        public void onChannelDeleted(String channelUrl, BaseChannel.ChannelType channelType) {
        }

        public void onReadReceiptUpdated(GroupChannel channel) {
        }

        public void onTypingStatusUpdated(GroupChannel channel) {
        }

        public void onUserReceivedInvitation(GroupChannel channel, User inviter, List<User> invitees) {
        }

        public void onUserJoined(GroupChannel channel, User user) {
        }

        public void onUserDeclinedInvitation(GroupChannel channel, User inviter, User invitee) {
        }

        public void onUserLeft(GroupChannel channel, User user) {
        }

        public void onUserEntered(OpenChannel channel, User user) {
        }

        public void onUserExited(OpenChannel channel, User user) {
        }

        public void onUserMuted(BaseChannel channel, User user) {
        }

        public void onUserUnmuted(BaseChannel channel, User user) {
        }

        public void onUserBanned(BaseChannel channel, User user) {
        }

        public void onUserUnbanned(BaseChannel channel, User user) {
        }

        public void onChannelFrozen(BaseChannel channel) {
        }

        public void onChannelUnfrozen(BaseChannel channel) {
        }

        public void onMetaDataCreated(BaseChannel channel, Map<String, String> metaDataMap) {
        }

        public void onMetaDataUpdated(BaseChannel channel, Map<String, String> metaDataMap) {
        }

        public void onMetaDataDeleted(BaseChannel channel, List<String> keys) {
        }

        public void onMetaCountersCreated(BaseChannel channel, Map<String, Integer> metaCounterMap) {
        }

        public void onMetaCountersUpdated(BaseChannel channel, Map<String, Integer> metaCounterMap) {
        }

        public void onMetaCountersDeleted(BaseChannel channel, List<String> keys) {
        }

        public void onChannelHidden(GroupChannel channel) {
        }
    }

    public static interface ConnectHandler {
        public void onConnected(User var1, SendBirdException var2);
    }

    public static class Options {
        static boolean useMemberAsMessageSender = true;
        static boolean useUiThreadForCallbacks = true;
        static int connectionTimeout = 10;
        static int authenticationTimeout = 10;
        static int typingIndicatorThrottle = 1000;

        public static void useMemberAsMessageSender(boolean tf) {
            useMemberAsMessageSender = tf;
        }

        public static void useUiThreadForCallbacks(boolean tf) {
            useUiThreadForCallbacks = tf;
        }

        public static void setConnectionTimeout(int connectionTimeout) {
            Options.connectionTimeout = connectionTimeout > 0 ? connectionTimeout : 10;
        }

        public static void setAuthenticationTimeout(int authenticationTimeout) {
            Options.authenticationTimeout = authenticationTimeout > 0 ? authenticationTimeout : 10;
        }

        public static void setTypingIndicatorThrottle(int msec) {
            if (msec >= 1000 && msec <= 9000) {
                typingIndicatorThrottle = msec;
            }
        }
    }

    private static class SubscribedUnreadMessageCount {
        int mTotalCount;
        int mTotalCountByCustomTypes;
        ConcurrentHashMap<String, Integer> mCustomTypeMap;
        long mTimestamp;

        SubscribedUnreadMessageCount() {
            this.init();
        }

        void init() {
            this.mTotalCount = 0;
            this.mTotalCountByCustomTypes = 0;
            if (this.mCustomTypeMap == null) {
                this.mCustomTypeMap = new ConcurrentHashMap();
            } else {
                this.mCustomTypeMap.clear();
            }
            this.mTimestamp = 0L;
        }
    }

    static enum BuildConfig {
        DEBUG,
        CI,
        RELEASE;

    }

    public static enum ConnectionState {
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

