/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.util.Base64;
import com.sendbird.android.APIClient;
import com.sendbird.android.AdminMessage;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.Command;
import com.sendbird.android.FileMessage;
import com.sendbird.android.FileMessageParams;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.MessageListQuery;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.OperatorListQuery;
import com.sendbird.android.PreviousMessageListQuery;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.Sender;
import com.sendbird.android.User;
import com.sendbird.android.UserMessage;
import com.sendbird.android.UserMessageParams;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class BaseChannel {
    protected static final String CHANNEL_TYPE_OPEN = "open";
    protected static final String CHANNEL_TYPE_GROUP = "group";
    protected String mUrl;
    protected String mName;
    protected String mCoverUrl;
    protected long mCreatedAt;
    protected String mData;
    protected boolean mFreeze;
    protected boolean mIsEphemeral;
    private boolean mDirty = false;
    private final ConcurrentLinkedQueue<SendFileMessageData> mSendFileMessageDataList = new ConcurrentLinkedQueue();
    private boolean mIsSendingFileMessage = false;

    protected BaseChannel(JsonElement el) {
        this.update(el);
    }

    protected void update(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        this.mUrl = obj.has("channel_url") && !obj.get("channel_url").isJsonNull() ? obj.get("channel_url").getAsString() : "";
        this.mName = obj.has("name") && !obj.get("name").isJsonNull() ? obj.get("name").getAsString() : "";
        this.mCreatedAt = obj.has("created_at") && !obj.get("created_at").isJsonNull() ? obj.get("created_at").getAsLong() * 1000L : 0L;
        this.mCoverUrl = obj.has("cover_url") && !obj.get("cover_url").isJsonNull() ? obj.get("cover_url").getAsString() : "";
        this.mData = obj.has("data") && !obj.get("data").isJsonNull() ? obj.get("data").getAsString() : "";
        this.mFreeze = obj.has("freeze") && obj.get("freeze").getAsBoolean();
        this.mIsEphemeral = obj.has("is_ephemeral") && obj.get("is_ephemeral").getAsBoolean();
    }

    JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("channel_url", this.mUrl);
        obj.addProperty("name", this.mName);
        obj.addProperty("created_at", this.mCreatedAt);
        obj.addProperty("cover_url", this.mCoverUrl);
        obj.addProperty("data", this.mData);
        obj.addProperty("freeze", this.mFreeze);
        obj.addProperty("is_ephemeral", this.mIsEphemeral);
        return obj;
    }

    protected void setDirty(boolean dirty) {
        this.mDirty = dirty;
    }

    protected boolean isDirty() {
        return this.mDirty;
    }

    public static BaseChannel buildFromSerializedData(byte[] data) {
        BaseChannel channel = null;
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            try {
                String str = new String(Base64.decode((byte[])data, (int)0), "UTF-8");
                JsonObject obj = new JsonParser().parse(str).getAsJsonObject();
                if (obj.get("channel_type").getAsString().equals(CHANNEL_TYPE_OPEN)) {
                    channel = OpenChannel.upsert(obj, true);
                } else if (obj.get("channel_type").getAsString().equals(CHANNEL_TYPE_GROUP)) {
                    channel = GroupChannel.upsert(obj, true);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return channel;
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    String getType() {
        if (this.isOpenChannel()) {
            return CHANNEL_TYPE_OPEN;
        }
        return CHANNEL_TYPE_GROUP;
    }

    public String getData() {
        return this.mData;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public long getCreatedAt() {
        return this.mCreatedAt;
    }

    public String getName() {
        return this.mName;
    }

    public String getCoverUrl() {
        return this.mCoverUrl;
    }

    public boolean isOpenChannel() {
        return this instanceof OpenChannel;
    }

    public boolean isGroupChannel() {
        return this instanceof GroupChannel;
    }

    public boolean isFrozen() {
        return this.mFreeze;
    }

    void setFreeze(boolean freeze) {
        this.mFreeze = freeze;
    }

    public boolean isEphemeral() {
        return this.mIsEphemeral;
    }

    void setEphemeral(boolean ephemeral) {
        this.mIsEphemeral = ephemeral;
    }

    public PreviousMessageListQuery createPreviousMessageListQuery() {
        return new PreviousMessageListQuery(this);
    }

    @Deprecated
    public MessageListQuery createMessageListQuery() {
        return new MessageListQuery(this);
    }

    public OperatorListQuery createOperatorListQuery() {
        return new OperatorListQuery(this);
    }

    private void getMessagesByTimestamp(long ts, boolean isInclusive, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, final GetMessagesHandler handler) {
        String msgType;
        switch (messageType) {
            case USER: {
                msgType = "MESG";
                break;
            }
            case FILE: {
                msgType = "FILE";
                break;
            }
            case ADMIN: {
                msgType = "ADMM";
                break;
            }
            default: {
                msgType = null;
            }
        }
        LinkedHashSet<String> senderUserIdsSet = null;
        if (senderUserIds != null) {
            senderUserIdsSet = new LinkedHashSet<String>(senderUserIds);
        }
        APIClient.getInstance().messageList(this instanceof OpenChannel, this.getUrl(), ts, prevResultSize, nextResultSize, isInclusive, reverse, msgType, customType, senderUserIdsSet, includeMetaArray, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                JsonArray objs = result.get("messages").getAsJsonArray();
                final ArrayList<BaseMessage> messages = new ArrayList<BaseMessage>();
                for (int i = 0; i < objs.size(); ++i) {
                    BaseMessage msg = BaseMessage.build(objs.get(i), BaseChannel.this.getUrl(), BaseChannel.this.getType());
                    if (msg == null) continue;
                    messages.add(msg);
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(messages, null);
                        }
                    });
                }
            }
        });
    }

    private void getMessagesById(long msgId, boolean isInclusive, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, final GetMessagesHandler handler) {
        String msgType;
        switch (messageType) {
            case USER: {
                msgType = "MESG";
                break;
            }
            case FILE: {
                msgType = "FILE";
                break;
            }
            case ADMIN: {
                msgType = "ADMM";
                break;
            }
            default: {
                msgType = null;
            }
        }
        LinkedHashSet<String> senderUserIdsSet = null;
        if (senderUserIds != null) {
            senderUserIdsSet = new LinkedHashSet<String>(senderUserIds);
        }
        APIClient.getInstance().messageListById(this instanceof OpenChannel, this.getUrl(), msgId, prevResultSize, nextResultSize, isInclusive, reverse, msgType, customType, senderUserIdsSet, includeMetaArray, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                JsonArray objs = result.get("messages").getAsJsonArray();
                final ArrayList<BaseMessage> messages = new ArrayList<BaseMessage>();
                for (int i = 0; i < objs.size(); ++i) {
                    BaseMessage msg = BaseMessage.build(objs.get(i), BaseChannel.this.getUrl(), BaseChannel.this.getType());
                    if (msg == null) continue;
                    messages.add(msg);
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(messages, null);
                        }
                    });
                }
            }
        });
    }

    private void getMessageChangeLogs(String token, boolean includeMetaArray, final GetMessageChangeLogsByTokenHandler handler) {
        APIClient.getInstance().messageChangeLogsByToken(this instanceof OpenChannel, this.getUrl(), token, includeMetaArray, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, null, false, null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                JsonArray updatedJsonArray = result.get("updated").getAsJsonArray();
                final ArrayList<BaseMessage> updatedMessages = new ArrayList<BaseMessage>();
                for (int i = 0; i < updatedJsonArray.size(); ++i) {
                    BaseMessage msg = BaseMessage.build(updatedJsonArray.get(i), BaseChannel.this.getUrl(), BaseChannel.this.getType());
                    if (msg == null) continue;
                    updatedMessages.add(msg);
                }
                JsonArray deletedJsonArray = result.get("deleted").getAsJsonArray();
                final ArrayList<Long> deletedMessageIds = new ArrayList<Long>();
                for (int i = 0; i < deletedJsonArray.size(); ++i) {
                    deletedMessageIds.add(deletedJsonArray.get(i).getAsJsonObject().get("message_id").getAsLong());
                }
                final boolean hasMore = result.get("has_more").getAsBoolean();
                final String token = result.get("next").getAsString();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(updatedMessages, deletedMessageIds, hasMore, token, null);
                        }
                    });
                }
            }
        });
    }

    public void getNextMessagesByTimestamp(long ts, boolean isInclusive, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, isInclusive, 0, nextResultSize, reverse, messageType, customType, null, false, handler);
    }

    public void getNextMessagesByTimestamp(long ts, boolean isInclusive, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, isInclusive, 0, nextResultSize, reverse, messageType, customType, senderUserIds, false, handler);
    }

    public void getNextMessagesByTimestamp(long ts, boolean isInclusive, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, isInclusive, 0, nextResultSize, reverse, messageType, customType, senderUserIds, includeMetaArray, handler);
    }

    public void getPreviousMessagesByTimestamp(long ts, boolean isInclusive, int prevResultSize, boolean reverse, MessageTypeFilter messageType, String customType, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, isInclusive, prevResultSize, 0, reverse, messageType, customType, null, false, handler);
    }

    public void getPreviousMessagesByTimestamp(long ts, boolean isInclusive, int prevResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, isInclusive, prevResultSize, 0, reverse, messageType, customType, senderUserIds, false, handler);
    }

    public void getPreviousMessagesByTimestamp(long ts, boolean isInclusive, int prevResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, isInclusive, prevResultSize, 0, reverse, messageType, customType, senderUserIds, includeMetaArray, handler);
    }

    public void getPreviousAndNextMessagesByTimestamp(long ts, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, true, prevResultSize, nextResultSize, reverse, messageType, customType, null, false, handler);
    }

    public void getPreviousAndNextMessagesByTimestamp(long ts, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, true, prevResultSize, nextResultSize, reverse, messageType, customType, senderUserIds, false, handler);
    }

    public void getPreviousAndNextMessagesByTimestamp(long ts, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, true, prevResultSize, nextResultSize, reverse, messageType, customType, senderUserIds, includeMetaArray, handler);
    }

    public void getNextMessagesById(long msgId, boolean isInclusive, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, GetMessagesHandler handler) {
        this.getMessagesById(msgId, isInclusive, 0, nextResultSize, reverse, messageType, customType, null, false, handler);
    }

    public void getNextMessagesById(long msgId, boolean isInclusive, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, GetMessagesHandler handler) {
        this.getMessagesById(msgId, isInclusive, 0, nextResultSize, reverse, messageType, customType, senderUserIds, false, handler);
    }

    public void getNextMessagesById(long msgId, boolean isInclusive, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, GetMessagesHandler handler) {
        this.getMessagesById(msgId, isInclusive, 0, nextResultSize, reverse, messageType, customType, senderUserIds, includeMetaArray, handler);
    }

    public void getPreviousMessagesById(long msgId, boolean isInclusive, int prevResultSize, boolean reverse, MessageTypeFilter messageType, String customType, GetMessagesHandler handler) {
        this.getMessagesById(msgId, isInclusive, prevResultSize, 0, reverse, messageType, customType, null, false, handler);
    }

    public void getPreviousMessagesById(long msgId, boolean isInclusive, int prevResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, GetMessagesHandler handler) {
        this.getMessagesById(msgId, isInclusive, prevResultSize, 0, reverse, messageType, customType, senderUserIds, false, handler);
    }

    public void getPreviousMessagesById(long msgId, boolean isInclusive, int prevResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, GetMessagesHandler handler) {
        this.getMessagesById(msgId, isInclusive, prevResultSize, 0, reverse, messageType, customType, senderUserIds, includeMetaArray, handler);
    }

    public void getPreviousAndNextMessagesById(long msgId, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, GetMessagesHandler handler) {
        this.getMessagesById(msgId, true, prevResultSize, nextResultSize, reverse, messageType, customType, null, false, handler);
    }

    public void getPreviousAndNextMessagesById(long msgId, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, GetMessagesHandler handler) {
        this.getMessagesById(msgId, true, prevResultSize, nextResultSize, reverse, messageType, customType, senderUserIds, false, handler);
    }

    public void getPreviousAndNextMessagesById(long msgId, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, GetMessagesHandler handler) {
        this.getMessagesById(msgId, true, prevResultSize, nextResultSize, reverse, messageType, customType, senderUserIds, includeMetaArray, handler);
    }

    public void getMessageChangeLogsByToken(String token, GetMessageChangeLogsByTokenHandler handler) {
        this.getMessageChangeLogs(token, false, handler);
    }

    public void getMessageChangeLogsByToken(String token, boolean includeMetaArray, GetMessageChangeLogsByTokenHandler handler) {
        this.getMessageChangeLogs(token, includeMetaArray, handler);
    }

    public FileMessage sendFileMessage(String fileUrl, String name, String type, int size, String data, SendFileMessageHandler handler) {
        return this.sendFileMessage(fileUrl, name, type, size, data, null, handler);
    }

    public FileMessage sendFileMessage(String fileUrl, String name, String type, int size, String data, String customType, SendFileMessageHandler handler) {
        return this.localSendFileMessage(fileUrl, name, type, size, data, customType, null, null, null, null, null, handler, null, null, true);
    }

    public FileMessage sendFileMessage(File file, String name, String type, int size, String data, SendFileMessageHandler handler) {
        return this.sendFileMessage(file, name, type, size, data, null, null, handler);
    }

    @Deprecated
    public FileMessage sendFileMessage(File file, String name, String type, int size, String data, String customType, SendFileMessageHandler handler) {
        return this.sendFileMessage(file, name, type, size, data, customType, null, handler);
    }

    public FileMessage sendFileMessage(File file, String name, String type, int size, String data, String customType, List<FileMessage.ThumbnailSize> thumbnailSizes, SendFileMessageHandler handler) {
        return this.localSendFileMessage(file, name, type, size, data, customType, thumbnailSizes, null, null, null, null, handler, null, null, true);
    }

    public FileMessage sendFileMessage(File file, String name, String type, int size, String data, SendFileMessageWithProgressHandler handler) {
        return this.sendFileMessage(file, name, type, size, data, null, null, handler);
    }

    @Deprecated
    public FileMessage sendFileMessage(File file, String name, String type, int size, String data, String customType, SendFileMessageWithProgressHandler handler) {
        return this.sendFileMessage(file, name, type, size, data, customType, null, handler);
    }

    public FileMessage sendFileMessage(File file, String name, String type, int size, String data, String customType, List<FileMessage.ThumbnailSize> thumbnailSizes, SendFileMessageWithProgressHandler handler) {
        return this.localSendFileMessage(file, name, type, size, data, customType, thumbnailSizes, null, null, null, null, null, handler, null, true);
    }

    public FileMessage sendFileMessage(FileMessageParams params, final SendFileMessageHandler handler) {
        if (params == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        return this.localSendFileMessage(params.mFileUrlOrFile, params.mFileName, params.mMimeType, params.mFileSize, params.mData, params.mCustomType, params.mThumbnailSizes, params.mMentionType, params.mMentionedUserIds, params.mPushNotificationDeliveryOption, params.mMetaArray, handler, null, null, true);
    }

    public FileMessage sendFileMessage(FileMessageParams params, final SendFileMessageWithProgressHandler handler) {
        if (params == null || !(params.mFileUrlOrFile instanceof File)) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        return this.localSendFileMessage(params.mFileUrlOrFile, params.mFileName, params.mMimeType, params.mFileSize, params.mData, params.mCustomType, params.mThumbnailSizes, params.mMentionType, params.mMentionedUserIds, params.mPushNotificationDeliveryOption, params.mMetaArray, null, handler, null, true);
    }

    public List<FileMessage> sendFileMessages(List<FileMessageParams> params, final SendFileMessagesHandler handler) {
        if (params == null || params.size() == 0 || params.size() > 20) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        ArrayList<FileMessage> fileMessages = new ArrayList<FileMessage>();
        for (int i = 0; i < params.size(); ++i) {
            FileMessageParams param = params.get(i);
            FileMessage fileMessage = param != null ? this.localCreateFileMessage(param.mFileUrlOrFile, param.mFileName, param.mMimeType, param.mFileSize, param.mData, param.mCustomType, param.mThumbnailSizes, param.mMentionType, param.mMentionedUserIds, param.mPushNotificationDeliveryOption, param.mMetaArray, handler, null) : null;
            fileMessages.add(fileMessage);
        }
        this.localSendFileMessages(params, fileMessages, handler, null);
        return fileMessages;
    }

    public List<FileMessage> sendFileMessages(List<FileMessageParams> params, final SendFileMessagesWithProgressHandler handler) {
        if (params == null || params.size() == 0 || params.size() > 20) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        ArrayList<FileMessage> fileMessages = new ArrayList<FileMessage>();
        for (int i = 0; i < params.size(); ++i) {
            FileMessageParams param = params.get(i);
            FileMessage fileMessage = param != null ? (param.mFileUrlOrFile instanceof File ? this.localCreateFileMessage(param.mFileUrlOrFile, param.mFileName, param.mMimeType, param.mFileSize, param.mData, param.mCustomType, param.mThumbnailSizes, param.mMentionType, param.mMentionedUserIds, param.mPushNotificationDeliveryOption, param.mMetaArray, null, handler) : null) : null;
            fileMessages.add(fileMessage);
        }
        this.localSendFileMessages(params, fileMessages, null, handler);
        return fileMessages;
    }

    private FileMessage localCreateFileMessage(Object fileUrlOrFile, String name, String type, Integer size, String data, String customType, List<FileMessage.ThumbnailSize> thumbnailSizes, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, BaseMessageParams.PushNotificationDeliveryOption pushNotificationDeliveryOption, Map<String, List<String>> metaArray, final Object handler, final Object progressHandler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (handler instanceof SendFileMessageHandler) {
                            ((SendFileMessageHandler)handler).onSent(null, new SendBirdException("Connection must be made before you send message.", 800101));
                        } else if (handler instanceof SendFileMessagesHandler) {
                            ((SendFileMessagesHandler)handler).onSent(null, new SendBirdException("Connection must be made before you send message.", 800101));
                        }
                    }
                });
            } else if (progressHandler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (progressHandler instanceof SendFileMessageWithProgressHandler) {
                            ((SendFileMessageWithProgressHandler)progressHandler).onSent(null, new SendBirdException("Connection must be made before you send message.", 800101));
                        } else if (progressHandler instanceof SendFileMessagesWithProgressHandler) {
                            ((SendFileMessagesWithProgressHandler)progressHandler).onSent(null, new SendBirdException("Connection must be made before you send message.", 800101));
                        }
                    }
                });
            }
            return null;
        }
        String fileUrl = "";
        String thumbnailSizesString = null;
        if (fileUrlOrFile instanceof String) {
            fileUrl = (String)fileUrlOrFile;
            if (name == null || name.length() == 0) {
                name = "";
            }
            if (type == null || type.length() == 0) {
                type = "";
            }
            if (size == null) {
                size = 0;
            }
        } else if (fileUrlOrFile instanceof File) {
            File file = (File)fileUrlOrFile;
            if (name == null || name.length() == 0) {
                name = file.getName();
            }
            if ((type = APIClient.checkMimeType(file, type, null)) == null || type.length() == 0) {
                type = "";
            }
            if (size == null) {
                size = (int)file.length();
            }
        } else {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (handler instanceof SendFileMessageHandler) {
                            ((SendFileMessageHandler)handler).onSent(null, new SendBirdException("Invalid arguments.", 800110));
                        } else if (handler instanceof SendFileMessagesHandler) {
                            ((SendFileMessagesHandler)handler).onSent(null, new SendBirdException("Invalid arguments.", 800110));
                        }
                    }
                });
            } else if (progressHandler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (progressHandler instanceof SendFileMessageWithProgressHandler) {
                            ((SendFileMessageWithProgressHandler)progressHandler).onSent(null, new SendBirdException("Invalid arguments.", 800110));
                        } else if (progressHandler instanceof SendFileMessagesWithProgressHandler) {
                            ((SendFileMessagesWithProgressHandler)progressHandler).onSent(null, new SendBirdException("Invalid arguments.", 800110));
                        }
                    }
                });
            }
            return null;
        }
        JsonObject obj = new JsonObject();
        JsonArray thumbnails = new JsonArray();
        if (thumbnailSizes != null) {
            for (FileMessage.ThumbnailSize thumbnailSize : thumbnailSizes) {
                JsonObject thumbnail = new JsonObject();
                thumbnail.addProperty("width", thumbnailSize.getMaxWidth());
                thumbnail.addProperty("height", thumbnailSize.getMaxHeight());
                thumbnail.addProperty("url", "");
                thumbnails.add(thumbnail);
            }
        }
        obj.add("thumbnails", thumbnails);
        thumbnailSizesString = obj.get("thumbnails").toString();
        JsonObject metaArraySuperObj = new JsonObject();
        JsonObject metaArrayObj = new JsonObject();
        if (metaArray != null && metaArray.size() > 0) {
            for (String key : metaArray.keySet()) {
                if (key == null) continue;
                List<String> values = metaArray.get(key);
                JsonArray array = new JsonArray();
                for (int i = 0; i < values.size(); ++i) {
                    String value = values.get(i);
                    array.add(value);
                }
                metaArrayObj.add(key, array);
            }
        }
        metaArraySuperObj.add("metaarray", metaArrayObj);
        String reqId = Command.generateRequestId();
        return new FileMessage(FileMessage.build(reqId, 0L, Sender.toSender(SendBird.getCurrentUser()), this.getUrl(), this.getType(), fileUrl, name, type, size, data, customType, thumbnailSizesString, false, System.currentTimeMillis(), 0L, mentionType, mentionedUserIds, null, metaArraySuperObj.get("metaarray").toString(), false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileMessage localSendFileMessage(Object fileUrlOrFile, String name, String type, Integer size, final String data, final String customType, List<FileMessage.ThumbnailSize> thumbnailSizes, final BaseMessageParams.MentionType mentionType, final List<String> mentionedUserIds, final BaseMessageParams.PushNotificationDeliveryOption pushNotificationDeliveryOption, final Map<String, List<String>> metaArray, final Object handler, final Object progressHandler, FileMessage createdFileMessage, final boolean order) {
        FileMessage fileMessage;
        if (createdFileMessage != null) {
            fileMessage = createdFileMessage;
        } else {
            fileMessage = this.localCreateFileMessage(fileUrlOrFile, name, type, size, data, customType, thumbnailSizes, mentionType, mentionedUserIds, pushNotificationDeliveryOption, metaArray, handler, progressHandler);
            if (fileMessage == null) {
                return null;
            }
        }
        if (fileUrlOrFile instanceof String) {
            String fileUrl = (String)fileUrlOrFile;
            if (order) {
                SendFileMessageData sendFileMessageData = new SendFileMessageData(true, fileMessage.getRequestId(), fileUrl, fileMessage, data, customType, null, false, mentionType, mentionedUserIds, pushNotificationDeliveryOption, metaArray, handler, progressHandler);
                ConcurrentLinkedQueue<SendFileMessageData> concurrentLinkedQueue = this.mSendFileMessageDataList;
                synchronized (concurrentLinkedQueue) {
                    this.mSendFileMessageDataList.add(sendFileMessageData);
                }
                this.localDoSendFileMessageWithOrder();
            } else {
                this.localDoSendFileMessage(fileUrl, fileMessage, data, customType, null, false, mentionType, mentionedUserIds, pushNotificationDeliveryOption, metaArray, handler, progressHandler);
            }
        } else if (fileUrlOrFile instanceof File) {
            SendFileMessageData sendFileMessageData;
            File file = (File)fileUrlOrFile;
            if (order) {
                sendFileMessageData = new SendFileMessageData(false, fileMessage.getRequestId(), null, fileMessage, data, customType, null, false, mentionType, mentionedUserIds, pushNotificationDeliveryOption, metaArray, handler, progressHandler);
                ConcurrentLinkedQueue<SendFileMessageData> concurrentLinkedQueue = this.mSendFileMessageDataList;
                synchronized (concurrentLinkedQueue) {
                    this.mSendFileMessageDataList.add(sendFileMessageData);
                }
            } else {
                sendFileMessageData = null;
            }
            APIClient.APIClientProgressHandler localProgressHandler = null;
            if (progressHandler != null) {
                localProgressHandler = new APIClient.APIClientProgressHandler(){

                    @Override
                    public void onProgress(final String requestId, final long bytesSent, final long totalBytesSent, final long totalBytesToSend) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                if (progressHandler instanceof SendFileMessageWithProgressHandler) {
                                    ((SendFileMessageWithProgressHandler)progressHandler).onProgress((int)bytesSent, (int)totalBytesSent, (int)totalBytesToSend);
                                } else if (progressHandler instanceof SendFileMessagesWithProgressHandler) {
                                    ((SendFileMessagesWithProgressHandler)progressHandler).onProgress(requestId, (int)bytesSent, (int)totalBytesSent, (int)totalBytesToSend);
                                }
                            }
                        });
                    }
                };
            }
            APIClient.getInstance().uploadFile(file, type, thumbnailSizes, this.getUrl(), fileMessage.getRequestId(), localProgressHandler, new APIClient.APIClientHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResult(JsonElement response, final SendBirdException e) {
                    boolean requireAuth;
                    if (e != null) {
                        if (handler != null) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (handler instanceof SendFileMessageHandler) {
                                        ((SendFileMessageHandler)handler).onSent(fileMessage, e);
                                    } else if (handler instanceof SendFileMessagesHandler) {
                                        ((SendFileMessagesHandler)handler).onSent(fileMessage, e);
                                    }
                                }
                            });
                        } else if (progressHandler != null) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (progressHandler instanceof SendFileMessageWithProgressHandler) {
                                        ((SendFileMessageWithProgressHandler)progressHandler).onSent(fileMessage, e);
                                    } else if (progressHandler instanceof SendFileMessagesWithProgressHandler) {
                                        ((SendFileMessagesWithProgressHandler)progressHandler).onSent(fileMessage, e);
                                    }
                                }
                            });
                        }
                        ConcurrentLinkedQueue concurrentLinkedQueue = BaseChannel.this.mSendFileMessageDataList;
                        synchronized (concurrentLinkedQueue) {
                            BaseChannel.this.mSendFileMessageDataList.remove(sendFileMessageData);
                        }
                        BaseChannel.this.localDoSendFileMessageWithOrder();
                        return;
                    }
                    JsonObject result = response.getAsJsonObject();
                    String fileUrl = result.get("url").getAsString();
                    String thumbnails = result.has("thumbnails") ? result.get("thumbnails").toString() : null;
                    boolean bl = requireAuth = result.has("require_auth") && result.get("require_auth").getAsBoolean();
                    if (order) {
                        sendFileMessageData.mIsReadyToSend = true;
                        sendFileMessageData.mFileUrl = fileUrl;
                        sendFileMessageData.mThumbnails = thumbnails;
                        sendFileMessageData.mRequireAuth = requireAuth;
                        BaseChannel.this.localDoSendFileMessageWithOrder();
                    } else {
                        BaseChannel.this.localDoSendFileMessage(fileUrl, fileMessage, data, customType, thumbnails, requireAuth, mentionType, mentionedUserIds, pushNotificationDeliveryOption, metaArray, handler, progressHandler);
                    }
                }
            });
        }
        return fileMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localDoSendFileMessageWithOrder() {
        int sleepMs = 200;
        if (!this.mIsSendingFileMessage) {
            this.mIsSendingFileMessage = true;
            ConcurrentLinkedQueue<SendFileMessageData> concurrentLinkedQueue = this.mSendFileMessageDataList;
            synchronized (concurrentLinkedQueue) {
                if (this.mSendFileMessageDataList.size() > 0) {
                    final SendFileMessageData d = this.mSendFileMessageDataList.peek();
                    if (d != null && d.mIsReadyToSend) {
                        this.mSendFileMessageDataList.remove(d);
                        new Thread(){

                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(200L);
                                }
                                catch (InterruptedException e1) {
                                    e1.printStackTrace();
                                }
                                BaseChannel.this.localDoSendFileMessage(d);
                                BaseChannel.this.mIsSendingFileMessage = false;
                                BaseChannel.this.localDoSendFileMessageWithOrder();
                            }
                        }.start();
                    } else {
                        this.mIsSendingFileMessage = false;
                    }
                } else {
                    this.mIsSendingFileMessage = false;
                }
            }
        }
    }

    private void localDoSendFileMessage(SendFileMessageData d) {
        this.localDoSendFileMessage(d.mFileUrl, d.mTempFileMessage, d.mData, d.mCustomType, d.mThumbnails, d.mRequireAuth, d.mMentionType, d.mMentionedUserIds, d.mPushNotificationDeliveryOption, d.mMetaArray, d.mHandler, d.mProgressHandler);
    }

    private void localDoSendFileMessage(String fileUrl, final FileMessage tempFileMessage, String data, String customType, String thumbnails, boolean requireAuth, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, BaseMessageParams.PushNotificationDeliveryOption pushNotificationDeliveryOption, Map<String, List<String>> metaArray, final Object handler, final Object progressHandler) {
        if (SendBird.getConnectionState() == SendBird.ConnectionState.OPEN) {
            Command cmd = Command.bFile(tempFileMessage.getRequestId(), this.getUrl(), fileUrl, tempFileMessage.getName(), tempFileMessage.getType(), tempFileMessage.getSize(), data, customType, thumbnails, requireAuth, mentionType, mentionedUserIds, pushNotificationDeliveryOption, metaArray);
            SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

                @Override
                public void onResult(final Command acked, final SendBirdException e) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (e != null) {
                                if (handler != null) {
                                    if (handler instanceof SendFileMessageHandler) {
                                        ((SendFileMessageHandler)handler).onSent(tempFileMessage, e);
                                    } else if (handler instanceof SendFileMessagesHandler) {
                                        ((SendFileMessagesHandler)handler).onSent(tempFileMessage, e);
                                    }
                                } else if (progressHandler != null) {
                                    if (progressHandler instanceof SendFileMessageWithProgressHandler) {
                                        ((SendFileMessageWithProgressHandler)progressHandler).onSent(tempFileMessage, e);
                                    } else if (progressHandler instanceof SendFileMessagesWithProgressHandler) {
                                        ((SendFileMessagesWithProgressHandler)progressHandler).onSent(tempFileMessage, e);
                                    }
                                }
                                return;
                            }
                            FileMessage fileMessage = new FileMessage(acked.getJsonElement());
                            if (handler != null) {
                                if (handler instanceof SendFileMessageHandler) {
                                    ((SendFileMessageHandler)handler).onSent(fileMessage, null);
                                } else if (handler instanceof SendFileMessagesHandler) {
                                    ((SendFileMessagesHandler)handler).onSent(fileMessage, null);
                                }
                            } else if (progressHandler != null) {
                                if (progressHandler instanceof SendFileMessageWithProgressHandler) {
                                    ((SendFileMessageWithProgressHandler)progressHandler).onSent(fileMessage, null);
                                } else if (progressHandler instanceof SendFileMessagesWithProgressHandler) {
                                    ((SendFileMessagesWithProgressHandler)progressHandler).onSent(fileMessage, null);
                                }
                            }
                        }
                    });
                }
            });
        } else {
            APIClient.getInstance().sendFileMessage(this instanceof OpenChannel, this.getUrl(), fileUrl, tempFileMessage.getName(), tempFileMessage.getSize(), tempFileMessage.getType(), customType, data, thumbnails, requireAuth, mentionType, mentionedUserIds, pushNotificationDeliveryOption, metaArray, new APIClient.APIClientHandler(){

                @Override
                public void onResult(final JsonElement response, final SendBirdException e) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (e != null) {
                                if (handler != null) {
                                    if (handler instanceof SendFileMessageHandler) {
                                        ((SendFileMessageHandler)handler).onSent(tempFileMessage, e);
                                    } else if (handler instanceof SendFileMessagesHandler) {
                                        ((SendFileMessagesHandler)handler).onSent(tempFileMessage, e);
                                    }
                                } else if (progressHandler != null) {
                                    if (progressHandler instanceof SendFileMessageWithProgressHandler) {
                                        ((SendFileMessageWithProgressHandler)progressHandler).onSent(tempFileMessage, e);
                                    } else if (progressHandler instanceof SendFileMessagesWithProgressHandler) {
                                        ((SendFileMessagesWithProgressHandler)progressHandler).onSent(tempFileMessage, e);
                                    }
                                }
                                return;
                            }
                            JsonObject responseObj = response.getAsJsonObject();
                            responseObj.addProperty("req_id", tempFileMessage.getRequestId());
                            FileMessage fileMessage = (FileMessage)BaseMessage.build(responseObj, BaseChannel.this.getUrl(), BaseChannel.this.getType());
                            if (handler != null) {
                                if (handler instanceof SendFileMessageHandler) {
                                    ((SendFileMessageHandler)handler).onSent(fileMessage, null);
                                } else if (handler instanceof SendFileMessagesHandler) {
                                    ((SendFileMessagesHandler)handler).onSent(fileMessage, null);
                                }
                            } else if (progressHandler != null) {
                                if (progressHandler instanceof SendFileMessageWithProgressHandler) {
                                    ((SendFileMessageWithProgressHandler)progressHandler).onSent(fileMessage, null);
                                } else if (progressHandler instanceof SendFileMessagesWithProgressHandler) {
                                    ((SendFileMessagesWithProgressHandler)progressHandler).onSent(fileMessage, null);
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    private void localSendFileMessages(List<FileMessageParams> params, List<FileMessage> fileMessages, final SendFileMessagesHandler handler, final SendFileMessagesWithProgressHandler progressHandler) {
        FileMessage fileMessage;
        FileMessageParams param;
        int i;
        final LinkedList<String> countList = new LinkedList<String>();
        for (i = 0; i < params.size(); ++i) {
            param = params.get(i);
            fileMessage = fileMessages.get(i);
            if (param == null || fileMessage == null) continue;
            countList.add(fileMessage.getRequestId());
        }
        for (i = 0; i < params.size(); ++i) {
            param = params.get(i);
            fileMessage = fileMessages.get(i);
            if (param == null || fileMessage == null) continue;
            this.localSendFileMessage(param.mFileUrlOrFile, fileMessage.getName(), fileMessage.getType(), fileMessage.getSize(), param.mData, param.mCustomType, param.mThumbnailSizes, param.mMentionType, param.mMentionedUserIds, param.mPushNotificationDeliveryOption, param.mMetaArray, null, new SendFileMessagesWithProgressHandler(){

                @Override
                public void onProgress(String reqId, int bytesSent, int totalBytesSent, int totalBytesToSend) {
                    if (progressHandler != null) {
                        progressHandler.onProgress(reqId, bytesSent, totalBytesSent, totalBytesToSend);
                    }
                }

                @Override
                public void onSent(FileMessage message, SendBirdException e) {
                    if (handler != null) {
                        handler.onSent(message, e);
                    } else if (progressHandler != null) {
                        progressHandler.onSent(message, e);
                    }
                    if (message != null && countList.remove(message.getRequestId()) && countList.size() == 0) {
                        if (handler != null) {
                            handler.onResult(null);
                        } else if (progressHandler != null) {
                            progressHandler.onResult(null);
                        }
                    }
                }

                @Override
                public void onResult(SendBirdException e) {
                }
            }, fileMessage, true);
        }
    }

    public UserMessage sendUserMessage(String message, SendUserMessageHandler handler) {
        return this.sendUserMessage(message, null, null, handler);
    }

    @Deprecated
    public UserMessage sendUserMessage(String message, String data, SendUserMessageHandler handler) {
        return this.sendUserMessage(message, data, null, null, handler);
    }

    @Deprecated
    public UserMessage sendUserMessage(String message, String data, String customType, SendUserMessageHandler handler) {
        return this.sendUserMessage(message, data, customType, null, handler);
    }

    public UserMessage sendUserMessage(String message, String data, String customType, List<String> targetLanguages, SendUserMessageHandler handler) {
        return this.localSendUserMessage(message, data, customType, targetLanguages, null, null, null, null, handler);
    }

    public UserMessage sendUserMessage(UserMessageParams params, final SendUserMessageHandler handler) {
        if (params == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        return this.localSendUserMessage(params.mMessage, params.mData, params.mCustomType, params.mTargetLanguages, params.mMentionType, params.mMentionedUserIds, params.mPushNotificationDeliveryOption, params.mMetaArray, handler);
    }

    private UserMessage localSendUserMessage(String message, String data, String customType, List<String> targetLanguages, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, BaseMessageParams.PushNotificationDeliveryOption pushNotificationDeliveryOption, Map<String, List<String>> metaArray, final SendUserMessageHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Connection must be made before you send message.", 800101));
                    }
                });
            }
            return null;
        }
        if (message == null) {
            message = "";
        }
        Command cmd = Command.bMessage(this.getUrl(), message, data, customType, mentionType, mentionedUserIds, pushNotificationDeliveryOption, metaArray, targetLanguages);
        JsonObject obj = new JsonObject();
        JsonObject transObj = new JsonObject();
        if (targetLanguages != null) {
            for (String targetLanguage : targetLanguages) {
                transObj.addProperty(targetLanguage, "");
            }
        }
        obj.add("translations", transObj);
        JsonObject metaArraySuperObj = new JsonObject();
        JsonObject metaArrayObj = new JsonObject();
        if (metaArray != null && metaArray.size() > 0) {
            for (String key : metaArray.keySet()) {
                if (key == null) continue;
                List<String> values = metaArray.get(key);
                JsonArray array = new JsonArray();
                for (int i = 0; i < values.size(); ++i) {
                    String value = values.get(i);
                    array.add(value);
                }
                metaArrayObj.add(key, array);
            }
        }
        metaArraySuperObj.add("metaarray", metaArrayObj);
        final UserMessage msg = new UserMessage(UserMessage.build(cmd.getRequestId(), 0L, Sender.toSender(SendBird.getCurrentUser()), this.getUrl(), this.getType(), message, data, customType, obj.get("translations").toString(), System.currentTimeMillis(), 0L, mentionType, mentionedUserIds, null, metaArraySuperObj.get("metaarray").toString(), false));
        SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

            @Override
            public void onResult(final Command acked, final SendBirdException e) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (e != null) {
                            if (handler != null) {
                                handler.onSent(msg, e);
                            }
                            return;
                        }
                        UserMessage userMessage = new UserMessage(acked.getJsonElement());
                        if (handler != null) {
                            handler.onSent(userMessage, null);
                        }
                    }
                });
            }
        });
        return msg;
    }

    public FileMessage copyFileMessage(BaseChannel targetChannel, FileMessage fileMessage, final CopyFileMessageHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCopied(null, new SendBirdException("Connection must be made before you send message.", 800101));
                    }
                });
            }
            return null;
        }
        if (targetChannel == null || fileMessage == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCopied(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        if (!this.getUrl().equals(fileMessage.getChannelUrl())) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCopied(null, new SendBirdException("The message does not belong to this channel.", 800110));
                    }
                });
            }
            return null;
        }
        JsonObject obj = new JsonObject();
        JsonArray thumbnailsArray = new JsonArray();
        for (FileMessage.Thumbnail thumbnail : fileMessage.getThumbnails()) {
            JsonObject thumbnailObj = new JsonObject();
            thumbnailObj.addProperty("width", thumbnail.getMaxWidth());
            thumbnailObj.addProperty("height", thumbnail.getMaxHeight());
            thumbnailObj.addProperty("real_width", thumbnail.getRealWidth());
            thumbnailObj.addProperty("real_height", thumbnail.getRealHeight());
            thumbnailObj.addProperty("url", thumbnail.getOriginalUrl());
            thumbnailsArray.add(thumbnailObj);
        }
        obj.add("thumbnails", thumbnailsArray);
        JsonObject mentionedUsersObj = new JsonObject();
        JsonArray mentionedUsersArray = new JsonArray();
        for (User user : fileMessage.getMentionedUsers()) {
            if (user == null) continue;
            JsonObject userObj = user.toJson().getAsJsonObject();
            mentionedUsersArray.add(userObj);
        }
        mentionedUsersObj.add("mentioned_users", mentionedUsersArray);
        final String reqId = Command.generateRequestId();
        final FileMessage msg = new FileMessage(FileMessage.build(reqId, 0L, Sender.toSender(SendBird.getCurrentUser()), targetChannel.getUrl(), targetChannel.getType(), fileMessage.getOriginalUrl(), fileMessage.getName(), fileMessage.getType(), fileMessage.getSize(), fileMessage.getData(), fileMessage.getCustomType(), obj.get("thumbnails").toString(), fileMessage.requiredAuth(), System.currentTimeMillis(), 0L, fileMessage.getMentionType(), fileMessage.getMentionedUserIds(), mentionedUsersObj.get("mentioned_users").toString(), null, false));
        if (SendBird.getConnectionState() == SendBird.ConnectionState.OPEN) {
            Command cmd = Command.bFile(reqId, targetChannel.getUrl(), fileMessage.getOriginalUrl(), fileMessage.getName(), fileMessage.getType(), fileMessage.getSize(), fileMessage.getData(), fileMessage.getCustomType(), obj.get("thumbnails").toString(), fileMessage.requiredAuth(), fileMessage.getMentionType(), fileMessage.getMentionedUserIds(), null, null);
            SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

                @Override
                public void onResult(final Command acked, final SendBirdException e) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (e != null) {
                                if (handler != null) {
                                    handler.onCopied(msg, e);
                                }
                                return;
                            }
                            FileMessage fileMessage = new FileMessage(acked.getJsonElement());
                            if (handler != null) {
                                handler.onCopied(fileMessage, null);
                            }
                        }
                    });
                }
            });
        } else {
            APIClient.getInstance().sendFileMessage(targetChannel instanceof OpenChannel, targetChannel.getUrl(), fileMessage.getOriginalUrl(), fileMessage.getName(), fileMessage.getSize(), fileMessage.getType(), fileMessage.getCustomType(), fileMessage.getData(), obj.get("thumbnails").toString(), fileMessage.requiredAuth(), fileMessage.getMentionType(), fileMessage.getMentionedUserIds(), null, null, new APIClient.APIClientHandler(){

                @Override
                public void onResult(final JsonElement response, final SendBirdException e) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (e != null) {
                                if (handler != null) {
                                    handler.onCopied(msg, e);
                                }
                                return;
                            }
                            JsonObject responseObj = response.getAsJsonObject();
                            responseObj.addProperty("req_id", reqId);
                            FileMessage fileMessage = (FileMessage)BaseMessage.build(responseObj, BaseChannel.this.getUrl(), BaseChannel.this.getType());
                            if (handler != null) {
                                handler.onCopied(fileMessage, null);
                            }
                        }
                    });
                }
            });
        }
        return msg;
    }

    public UserMessage copyUserMessage(BaseChannel targetChannel, UserMessage userMessage, final CopyUserMessageHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCopied(null, new SendBirdException("Connection must be made before you forward message.", 800101));
                    }
                });
            }
            return null;
        }
        if (targetChannel == null || userMessage == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCopied(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        if (!this.getUrl().equals(userMessage.getChannelUrl())) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCopied(null, new SendBirdException("The message does not belong to this channel.", 800110));
                    }
                });
            }
            return null;
        }
        ArrayList<String> targetLanguages = null;
        if (userMessage.getTranslations().size() > 0) {
            targetLanguages = new ArrayList<String>();
            targetLanguages.addAll(userMessage.getTranslations().keySet());
        }
        Command cmd = Command.bMessage(targetChannel.getUrl(), userMessage.getMessage(), userMessage.getData(), userMessage.getCustomType(), userMessage.getMentionType(), userMessage.getMentionedUserIds(), null, null, targetLanguages);
        JsonObject obj = new JsonObject();
        JsonObject transObj = new JsonObject();
        if (targetLanguages != null) {
            for (String targetLanguage : targetLanguages) {
                transObj.addProperty(targetLanguage, "");
            }
        }
        obj.add("translations", transObj);
        JsonObject mentionedUsersObj = new JsonObject();
        JsonArray mentionedUsersArray = new JsonArray();
        for (User user : userMessage.getMentionedUsers()) {
            if (user == null) continue;
            JsonObject userObj = user.toJson().getAsJsonObject();
            mentionedUsersArray.add(userObj);
        }
        mentionedUsersObj.add("mentioned_users", mentionedUsersArray);
        final UserMessage msg = new UserMessage(UserMessage.build(cmd.getRequestId(), 0L, Sender.toSender(SendBird.getCurrentUser()), targetChannel.getUrl(), targetChannel.getType(), userMessage.getMessage(), userMessage.getData(), userMessage.getCustomType(), obj.get("translations").toString(), System.currentTimeMillis(), 0L, userMessage.getMentionType(), userMessage.getMentionedUserIds(), mentionedUsersObj.get("mentioned_users").toString(), null, false));
        SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

            @Override
            public void onResult(final Command acked, final SendBirdException e) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (e != null) {
                            if (handler != null) {
                                handler.onCopied(msg, e);
                            }
                            return;
                        }
                        UserMessage userMessage = new UserMessage(acked.getJsonElement());
                        if (handler != null) {
                            handler.onCopied(userMessage, null);
                        }
                    }
                });
            }
        });
        return msg;
    }

    public void createMetaCounters(Map<String, Integer> metaCounterMap, final MetaCounterHandler handler) {
        if (metaCounterMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().createMetaCounters(this instanceof OpenChannel, this.getUrl(), metaCounterMap, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void updateMetaCounters(Map<String, Integer> metaCounterMap, final MetaCounterHandler handler) {
        if (metaCounterMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().updateMetaCounters(this instanceof OpenChannel, this.getUrl(), metaCounterMap, true, 0, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void increaseMetaCounters(Map<String, Integer> metaCounterMap, final MetaCounterHandler handler) {
        if (metaCounterMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().updateMetaCounters(this instanceof OpenChannel, this.getUrl(), metaCounterMap, false, 1, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void decreaseMetaCounters(Map<String, Integer> metaCounterMap, final MetaCounterHandler handler) {
        if (metaCounterMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().updateMetaCounters(this instanceof OpenChannel, this.getUrl(), metaCounterMap, false, 2, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void getMetaCounters(Collection<String> keys, final MetaCounterHandler handler) {
        if (keys == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().getMetaCounters(this instanceof OpenChannel, this.getUrl(), keys, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void getAllMetaCounters(final MetaCounterHandler handler) {
        APIClient.getInstance().getAllMetaCounters(this instanceof OpenChannel, this.getUrl(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void deleteMetaCounter(String key, final DeleteMetaCounterHandler handler) {
        if (key == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteMetaCounter(this instanceof OpenChannel, this.getUrl(), key, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void deleteAllMetaCounters(final DeleteMetaCounterHandler handler) {
        APIClient.getInstance().deleteAllMetaCounters(this instanceof OpenChannel, this.getUrl(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void createMetaData(Map<String, String> metaDataMap, final MetaDataHandler handler) {
        if (metaDataMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().createMetaData(this instanceof OpenChannel, this.getUrl(), metaDataMap, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, String> result = new HashMap<String, String>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void updateMetaData(Map<String, String> metaDataMap, final MetaDataHandler handler) {
        if (metaDataMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().updateMetaData(this instanceof OpenChannel, this.getUrl(), metaDataMap, true, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, String> result = new HashMap<String, String>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void getMetaData(Collection<String> keys, final MetaDataHandler handler) {
        if (keys == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().getMetaData(this instanceof OpenChannel, this.getUrl(), keys, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, String> result = new HashMap<String, String>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void getAllMetaData(final MetaDataHandler handler) {
        APIClient.getInstance().getAllMetaData(this instanceof OpenChannel, this.getUrl(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, String> result = new HashMap<String, String>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void deleteMetaData(String key, final DeleteMetaDataHandler handler) {
        if (key == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteMetaData(this instanceof OpenChannel, this.getUrl(), key, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void deleteAllMetaData(final DeleteMetaDataHandler handler) {
        APIClient.getInstance().deleteAllMetaData(this instanceof OpenChannel, this.getUrl(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null && handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(e);
                        }
                    });
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void deleteMessage(BaseMessage message, final DeleteMessageHandler handler) {
        if (message == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteMessage(this instanceof OpenChannel, this.getUrl(), message.getMessageId(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void updateUserMessage(long messageId, String body, String data, String customType, UpdateUserMessageHandler handler) {
        this.localUpdateUserMessage(messageId, body, data, customType, null, null, handler);
    }

    public void updateUserMessage(long messageId, UserMessageParams params, UpdateUserMessageHandler handler) {
        this.localUpdateUserMessage(messageId, params.mMessage, params.mData, params.mCustomType, params.mMentionType, params.mMentionedUserIds, handler);
    }

    private void localUpdateUserMessage(long messageId, String body, String data, String customType, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, final UpdateUserMessageHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUpdated(null, new SendBirdException("Connection must be made.", 800101));
                    }
                });
            }
            return;
        }
        Command cmd = Command.bUpdateMessage(this.getUrl(), messageId, body, data, customType, mentionType, mentionedUserIds, null, null, null);
        SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

            @Override
            public void onResult(final Command acked, final SendBirdException e) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (e != null) {
                            if (handler != null) {
                                handler.onUpdated(null, e);
                            }
                            return;
                        }
                        UserMessage userMessage = new UserMessage(acked.getJsonElement());
                        if (handler != null) {
                            handler.onUpdated(userMessage, null);
                        }
                    }
                });
            }
        });
    }

    public void updateFileMessage(long messageId, String data, String customType, UpdateFileMessageHandler handler) {
        this.localUpdateFileMessage(messageId, data, customType, null, null, handler);
    }

    public void updateFileMessage(long messageId, FileMessageParams params, UpdateFileMessageHandler handler) {
        this.localUpdateFileMessage(messageId, params.mData, params.mCustomType, params.mMentionType, params.mMentionedUserIds, handler);
    }

    private void localUpdateFileMessage(long messageId, String data, String customType, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, final UpdateFileMessageHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUpdated(null, new SendBirdException("Connection must be made.", 800101));
                    }
                });
            }
            return;
        }
        Command cmd = Command.bUpdateFile(this.getUrl(), messageId, data, customType, mentionType, mentionedUserIds, null, null, null);
        SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

            @Override
            public void onResult(final Command acked, final SendBirdException e) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (e != null) {
                            if (handler != null) {
                                handler.onUpdated(null, e);
                            }
                            return;
                        }
                        FileMessage fileMessage = new FileMessage(acked.getJsonElement());
                        if (handler != null) {
                            handler.onUpdated(fileMessage, null);
                        }
                    }
                });
            }
        });
    }

    public boolean cancelFileMessageUpload(String requestId) {
        return APIClient.getInstance().cancelRequest(requestId);
    }

    public void createMessageMetaArrayKeys(final BaseMessage message, List<String> metaArrayKeys, final MessageMetaArrayHandler handler) {
        if (message == null || message instanceof AdminMessage || metaArrayKeys == null || metaArrayKeys.size() <= 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(message, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        ArrayList<String> paramMetaArrayKeys = new ArrayList<String>(new LinkedHashSet<String>(metaArrayKeys));
        HashMap<String, List<String>> metaArrayMap = new HashMap<String, List<String>>();
        for (String metaArrayKey : paramMetaArrayKeys) {
            if (metaArrayKey == null) continue;
            metaArrayMap.put(metaArrayKey, new ArrayList());
        }
        Command cmd = null;
        if (message instanceof UserMessage) {
            cmd = Command.bUpdateMessage(this.getUrl(), message.getMessageId(), null, null, null, null, null, metaArrayMap, true, true);
        } else if (message instanceof FileMessage) {
            cmd = Command.bUpdateFile(this.getUrl(), message.getMessageId(), null, null, null, null, metaArrayMap, true, true);
        }
        if (cmd != null) {
            SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

                @Override
                public void onResult(Command acked, final SendBirdException e) {
                    if (e != null) {
                        if (handler != null) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    handler.onResult(message, e);
                                }
                            });
                        }
                        return;
                    }
                    JsonObject obj = acked.getJsonElement().getAsJsonObject();
                    if (obj != null && obj.has("metaarray")) {
                        JsonObject metaArrayObj = obj.getAsJsonObject("metaarray");
                        if (message.mMetaArray != null) {
                            for (Map.Entry<String, JsonElement> entry : metaArrayObj.entrySet()) {
                                String key = entry.getKey();
                                if (key == null || message.mMetaArray.containsKey(key)) continue;
                                message.mMetaArray.put(key, new ArrayList());
                            }
                        }
                        if (handler != null) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    handler.onResult(message, null);
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    public void deleteMessageMetaArrayKeys(final BaseMessage message, List<String> metaArrayKeys, final MessageMetaArrayHandler handler) {
        if (message == null || message instanceof AdminMessage || metaArrayKeys == null || metaArrayKeys.size() <= 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(message, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        final ArrayList<String> paramMetaArrayKeys = new ArrayList<String>(new LinkedHashSet<String>(metaArrayKeys));
        HashMap<String, List<String>> metaArrayMap = new HashMap<String, List<String>>();
        for (String metaArrayKey : metaArrayKeys) {
            if (metaArrayKey == null) continue;
            metaArrayMap.put(metaArrayKey, new ArrayList());
        }
        Command cmd = null;
        if (message instanceof UserMessage) {
            cmd = Command.bUpdateMessage(this.getUrl(), message.getMessageId(), null, null, null, null, null, metaArrayMap, false, true);
        } else if (message instanceof FileMessage) {
            cmd = Command.bUpdateFile(this.getUrl(), message.getMessageId(), null, null, null, null, metaArrayMap, false, true);
        }
        if (cmd != null) {
            SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

                @Override
                public void onResult(Command acked, final SendBirdException e) {
                    if (e != null) {
                        if (handler != null) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    handler.onResult(message, e);
                                }
                            });
                        }
                        return;
                    }
                    if (message.mMetaArray != null) {
                        for (String key : paramMetaArrayKeys) {
                            if (key == null) continue;
                            message.mMetaArray.remove(key);
                        }
                    }
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(message, null);
                            }
                        });
                    }
                }
            });
        }
    }

    public void addMessageMetaArrayValues(BaseMessage message, Map<String, List<String>> metaArrayMap, MessageMetaArrayHandler handler) {
        this.localUpdateMessageMetaArrayValues(message, metaArrayMap, true, handler);
    }

    public void removeMessageMetaArrayValues(BaseMessage message, Map<String, List<String>> metaArrayMap, MessageMetaArrayHandler handler) {
        this.localUpdateMessageMetaArrayValues(message, metaArrayMap, false, handler);
    }

    private void localUpdateMessageMetaArrayValues(final BaseMessage message, Map<String, List<String>> metaArrayMap, boolean add, final MessageMetaArrayHandler handler) {
        if (message == null || message instanceof AdminMessage || metaArrayMap == null || metaArrayMap.size() <= 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(message, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        Command cmd = null;
        if (message instanceof UserMessage) {
            cmd = Command.bUpdateMessage(this.getUrl(), message.getMessageId(), null, null, null, null, null, metaArrayMap, add, false);
        } else if (message instanceof FileMessage) {
            cmd = Command.bUpdateFile(this.getUrl(), message.getMessageId(), null, null, null, null, metaArrayMap, add, false);
        }
        if (cmd != null) {
            SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

                @Override
                public void onResult(Command acked, final SendBirdException e) {
                    if (e != null) {
                        if (handler != null) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    handler.onResult(message, e);
                                }
                            });
                        }
                        return;
                    }
                    JsonObject obj = acked.getJsonElement().getAsJsonObject();
                    if (obj != null && obj.has("metaarray")) {
                        JsonObject metaArrayObj = obj.getAsJsonObject("metaarray");
                        if (message.mMetaArray != null) {
                            for (Map.Entry<String, JsonElement> entry : metaArrayObj.entrySet()) {
                                String key = entry.getKey();
                                if (key == null) continue;
                                if (!message.mMetaArray.containsKey(key)) {
                                    message.mMetaArray.put(key, new ArrayList());
                                }
                                if (!metaArrayObj.get(key).isJsonArray()) continue;
                                ArrayList<String> values = new ArrayList<String>();
                                JsonArray array = metaArrayObj.get(key).getAsJsonArray();
                                if (array != null) {
                                    for (int i = 0; i < array.size(); ++i) {
                                        String value = array.get(i).getAsString();
                                        if (value == null) continue;
                                        values.add(value);
                                    }
                                }
                                message.mMetaArray.put(key, values);
                            }
                        }
                        if (handler != null) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    handler.onResult(message, null);
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    public void getMyMutedInfo(final GetMyMutedInfoHandler handler) {
        APIClient.getInstance().getMyMutedInfo(this instanceof OpenChannel, this.getUrl(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                long remainingDuration;
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(false, null, -1L, -1L, -1L, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                final boolean isMuted = obj.has("is_muted") && obj.get("is_muted").getAsBoolean();
                final String description = obj.has("description") ? obj.get("description").getAsString() : null;
                final long startAt = obj.has("start_at") ? obj.get("start_at").getAsLong() : -1L;
                final long endAt = obj.has("end_at") ? obj.get("end_at").getAsLong() : -1L;
                long l = remainingDuration = obj.has("remaining_duration") ? obj.get("remaining_duration").getAsLong() : -1L;
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(isMuted, description, startAt, endAt, remainingDuration, null);
                        }
                    });
                }
            }
        });
    }

    public static interface GetMyMutedInfoHandler {
        public void onResult(boolean var1, String var2, long var3, long var5, long var7, SendBirdException var9);
    }

    public static interface MessageMetaArrayHandler {
        public void onResult(BaseMessage var1, SendBirdException var2);
    }

    public static interface UpdateFileMessageHandler {
        public void onUpdated(FileMessage var1, SendBirdException var2);
    }

    public static interface UpdateUserMessageHandler {
        public void onUpdated(UserMessage var1, SendBirdException var2);
    }

    public static interface DeleteMessageHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface CopyFileMessageHandler {
        public void onCopied(FileMessage var1, SendBirdException var2);
    }

    public static interface CopyUserMessageHandler {
        public void onCopied(UserMessage var1, SendBirdException var2);
    }

    public static interface SendFileMessagesWithProgressHandler {
        public void onProgress(String var1, int var2, int var3, int var4);

        public void onSent(FileMessage var1, SendBirdException var2);

        public void onResult(SendBirdException var1);
    }

    public static interface SendFileMessagesHandler {
        public void onSent(FileMessage var1, SendBirdException var2);

        public void onResult(SendBirdException var1);
    }

    public static interface SendFileMessageWithProgressHandler {
        public void onProgress(int var1, int var2, int var3);

        public void onSent(FileMessage var1, SendBirdException var2);
    }

    public static interface SendFileMessageHandler {
        public void onSent(FileMessage var1, SendBirdException var2);
    }

    public static interface SendUserMessageHandler {
        public void onSent(UserMessage var1, SendBirdException var2);
    }

    public static interface DeleteMetaDataHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface MetaDataHandler {
        public void onResult(Map<String, String> var1, SendBirdException var2);
    }

    public static interface DeleteMetaCounterHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface MetaCounterHandler {
        public void onResult(Map<String, Integer> var1, SendBirdException var2);
    }

    public static interface GetMessageChangeLogsByTokenHandler {
        public void onResult(List<BaseMessage> var1, List<Long> var2, boolean var3, String var4, SendBirdException var5);
    }

    public static interface GetMessagesHandler {
        public void onResult(List<BaseMessage> var1, SendBirdException var2);
    }

    private class SendFileMessageData {
        boolean mIsReadyToSend;
        String mReqId;
        String mFileUrl;
        final FileMessage mTempFileMessage;
        final String mData;
        final String mCustomType;
        String mThumbnails;
        boolean mRequireAuth;
        final BaseMessageParams.MentionType mMentionType;
        final List<String> mMentionedUserIds;
        final BaseMessageParams.PushNotificationDeliveryOption mPushNotificationDeliveryOption;
        final Map<String, List<String>> mMetaArray;
        final Object mHandler;
        final Object mProgressHandler;

        SendFileMessageData(boolean isReadyToSend, String reqId, String fileUrl, FileMessage tempFileMessage, String data, String customType, String thumbnails, boolean requireAuth, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, BaseMessageParams.PushNotificationDeliveryOption pushNotificationDeliveryOption, Map<String, List<String>> metaArray, Object handler, Object progressHandler) {
            this.mIsReadyToSend = isReadyToSend;
            this.mReqId = reqId;
            this.mFileUrl = fileUrl;
            this.mTempFileMessage = tempFileMessage;
            this.mData = data;
            this.mCustomType = customType;
            this.mThumbnails = thumbnails;
            this.mRequireAuth = requireAuth;
            this.mMentionType = mentionType;
            this.mMentionedUserIds = mentionedUserIds;
            this.mPushNotificationDeliveryOption = pushNotificationDeliveryOption;
            this.mMetaArray = metaArray;
            this.mHandler = handler;
            this.mProgressHandler = progressHandler;
        }
    }

    public static enum MessageTypeFilter {
        ALL,
        USER,
        FILE,
        ADMIN;

    }

    public static enum ChannelType {
        OPEN,
        GROUP;

    }
}

