/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.Command;
import com.sendbird.android.OpenChannelListQuery;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.UserListQuery;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public final class OpenChannel
extends BaseChannel {
    private static final ConcurrentHashMap<String, OpenChannel> sCachedChannels = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, OpenChannel> sEnteredChannels = new ConcurrentHashMap();
    protected int mParticipantCount;
    protected List<User> mOperators;

    static synchronized void clearCache() {
        sCachedChannels.clear();
    }

    protected static void clearEnteredChannels() {
        sEnteredChannels.clear();
    }

    static synchronized void removeChannelFromCache(String channelUrl) {
        sCachedChannels.remove(channelUrl);
    }

    protected static Collection<OpenChannel> getEnteredChannels() {
        return sEnteredChannels.values();
    }

    public void refresh(final OpenChannelRefreshHandler handler) {
        OpenChannel.getChannelWithoutCache(this.getUrl(), new OpenChannelGetHandler(){

            @Override
            public void onResult(OpenChannel channel, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    protected static synchronized OpenChannel upsert(JsonElement el) {
        String channelUrl = el.getAsJsonObject().get("channel_url").getAsString();
        if (sCachedChannels.containsKey(channelUrl)) {
            sCachedChannels.get(channelUrl).update(el);
        } else {
            sCachedChannels.put(channelUrl, new OpenChannel(el));
        }
        return sCachedChannels.get(channelUrl);
    }

    protected OpenChannel(JsonElement el) {
        super(el);
    }

    @Override
    protected void update(JsonElement el) {
        super.update(el);
        this.parse(el);
    }

    private void parse(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        if (obj.has("participant_count")) {
            this.mParticipantCount = obj.get("participant_count").getAsInt();
        }
        if (obj.has("operators") && obj.get("operators").isJsonArray()) {
            this.mOperators = new ArrayList<User>();
            JsonArray ops = obj.get("operators").getAsJsonArray();
            for (int i = 0; i < ops.size(); ++i) {
                this.mOperators.add(new User(ops.get(i)));
            }
        }
    }

    public int getParticipantCount() {
        return this.mParticipantCount;
    }

    protected void setParticipantCount(int count) {
        this.mParticipantCount = count;
    }

    public List<User> getOperators() {
        return this.mOperators;
    }

    public static OpenChannelListQuery createOpenChannelListQuery() {
        return new OpenChannelListQuery();
    }

    public static void createChannel(OpenChannelCreateHandler handler) {
        OpenChannel.createChannelWithOperatorUserIds(null, null, null, null, handler);
    }

    public static void createChannel(String name, Object coverUrlOrImage, String data, OpenChannelCreateHandler handler) throws ClassCastException {
        OpenChannel.createChannelWithOperatorUserIds(name, coverUrlOrImage, data, null, handler);
    }

    public static void createChannel(String name, Object coverUrlOrImage, String data, List<User> operatorUsers, OpenChannelCreateHandler handler) throws ClassCastException {
        ArrayList<String> operatorUserIds = new ArrayList<String>();
        if (operatorUsers != null) {
            for (User user : operatorUsers) {
                if (user == null) continue;
                operatorUserIds.add(user.getUserId());
            }
        }
        OpenChannel.createChannelWithOperatorUserIds(name, coverUrlOrImage, data, operatorUserIds, handler);
    }

    public static void createChannelWithOperatorUserIds(String name, Object coverUrlOrImage, String data, List<String> operatorUserIds, final OpenChannelCreateHandler handler) throws ClassCastException {
        if (!(coverUrlOrImage instanceof String) && !(coverUrlOrImage instanceof File) && coverUrlOrImage != null) {
            throw new ClassCastException();
        }
        APIClient.APIClientHandler apiClientHandler = new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final OpenChannel channel = OpenChannel.upsert(response);
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(channel, null);
                        }
                    });
                }
            }
        };
        if (coverUrlOrImage instanceof String || coverUrlOrImage == null) {
            APIClient.getInstance().createOpenChannel(name, (String)coverUrlOrImage, data, operatorUserIds, apiClientHandler);
        } else {
            APIClient.getInstance().createOpenChannel(name, (File)coverUrlOrImage, data, operatorUserIds, apiClientHandler);
        }
    }

    protected static void getChannelWithoutCache(final String channelUrl, final OpenChannelGetHandler handler) {
        APIClient.getInstance().getOpenChannel(channelUrl, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                OpenChannel.upsert(response);
                if (handler != null) {
                    handler.onResult((OpenChannel)sCachedChannels.get(channelUrl), null);
                }
            }
        });
    }

    public static void getChannel(final String channelUrl, final OpenChannelGetHandler handler) {
        if (channelUrl == null || channelUrl.length() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        if (sCachedChannels.containsKey(channelUrl)) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        OpenChannel channel = (OpenChannel)sCachedChannels.get(channelUrl);
                        if (channel == null) {
                            return;
                        }
                        handler.onResult(channel, null);
                    }
                });
            }
        } else {
            OpenChannel.getChannelWithoutCache(channelUrl, new OpenChannelGetHandler(){

                @Override
                public void onResult(final OpenChannel channel, final SendBirdException e) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(channel, e);
                            }
                        });
                    }
                }
            });
        }
    }

    public void updateChannel(String name, Object coverUrlOrImage, String data, OpenChannelUpdateHandler handler) throws ClassCastException {
        this.updateChannelWithOperatorUserIds(name, coverUrlOrImage, data, null, handler);
    }

    public void updateChannel(String name, Object coverUrlOrImage, String data, List<User> operatorUsers, OpenChannelUpdateHandler handler) throws ClassCastException {
        ArrayList<String> operatorUserIds = new ArrayList<String>();
        if (operatorUsers != null) {
            for (User user : operatorUsers) {
                if (user == null) continue;
                operatorUserIds.add(user.getUserId());
            }
        }
        this.updateChannelWithOperatorUserIds(name, coverUrlOrImage, data, operatorUserIds, handler);
    }

    public void updateChannelWithOperatorUserIds(String name, Object coverUrlOrImage, String data, List<String> operatorUserIds, final OpenChannelUpdateHandler handler) throws ClassCastException {
        if (!(coverUrlOrImage instanceof String) && !(coverUrlOrImage instanceof File) && coverUrlOrImage != null) {
            throw new ClassCastException();
        }
        APIClient.APIClientHandler apiClientHandler = new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final OpenChannel channel = OpenChannel.upsert(response);
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(channel, null);
                        }
                    });
                }
            }
        };
        if (coverUrlOrImage instanceof String || coverUrlOrImage == null) {
            APIClient.getInstance().updateOpenChannel(this.getUrl(), name, (String)coverUrlOrImage, data, operatorUserIds, apiClientHandler);
        } else {
            APIClient.getInstance().updateOpenChannel(this.getUrl(), name, (File)coverUrlOrImage, data, operatorUserIds, apiClientHandler);
        }
    }

    public void enter(final OpenChannelEnterHandler handler) {
        Command cmd = Command.bEnter(this.getUrl());
        SendBird.getInstance().sendCommand(cmd, new Command.SendCommandHandler(){

            @Override
            public void onResult(Command acked, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                sEnteredChannels.put(OpenChannel.this.getUrl(), OpenChannel.this);
                JsonObject obj = acked.getJsonElement().getAsJsonObject();
                if (obj.has("participant_count")) {
                    OpenChannel.this.setParticipantCount(obj.get("participant_count").getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void exit(final OpenChannelExitHandler handler) {
        Command cmd = Command.bExit(this.getUrl());
        SendBird.getInstance().sendCommand(cmd, new Command.SendCommandHandler(){

            @Override
            public void onResult(Command acked, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                sEnteredChannels.remove(OpenChannel.this.getUrl());
                JsonObject obj = acked.getJsonElement().getAsJsonObject();
                if (obj.has("participant_count")) {
                    OpenChannel.this.setParticipantCount(obj.get("participant_count").getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public UserListQuery createParticipantListQuery() {
        return new UserListQuery(UserListQuery.QueryType.PARTICIPANT, this);
    }

    public UserListQuery createMutedUserListQuery() {
        return new UserListQuery(UserListQuery.QueryType.MUTED_USER, this);
    }

    public UserListQuery createBannedUserListQuery() {
        return new UserListQuery(UserListQuery.QueryType.BANNED_USER, this);
    }

    public void banUser(User user, int seconds, final OpenChannelBanHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.banUserWithUserId(user.getUserId(), seconds, handler);
    }

    public void banUserWithUserId(String userId, int seconds, final OpenChannelBanHandler handler) {
        if (userId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().banUser(this.getUrl(), userId, null, seconds, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void unbanUser(User user, final OpenChannelUnbanHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.unbanUserWithUserId(user.getUserId(), handler);
    }

    public void unbanUserWithUserId(String userId, final OpenChannelUnbanHandler handler) {
        if (userId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().unbanUser(this.getUrl(), userId, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void muteUser(User user, final OpenChannelMuteHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.muteUserWithUserId(user.getUserId(), handler);
    }

    public void muteUserWithUserId(String userId, final OpenChannelMuteHandler handler) {
        if (userId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().muteUser(this.getUrl(), userId, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void unmuteUser(User user, final OpenChannelUnmuteHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.unmuteUserWithUserId(user.getUserId(), handler);
    }

    public void unmuteUserWithUserId(String userId, final OpenChannelUnmuteHandler handler) {
        if (userId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().unmuteUser(this.getUrl(), userId, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public boolean isOperator(User user) {
        if (user == null) {
            return false;
        }
        return this.isOperatorWithUserId(user.getUserId());
    }

    public boolean isOperatorWithUserId(String userId) {
        boolean result = false;
        for (User operator : this.mOperators) {
            if (!operator.getUserId().equals(userId)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static interface OpenChannelUnmuteHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelMuteHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelUnbanHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelBanHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelUpdateHandler {
        public void onResult(OpenChannel var1, SendBirdException var2);
    }

    public static interface OpenChannelCreateHandler {
        public void onResult(OpenChannel var1, SendBirdException var2);
    }

    public static interface OpenChannelGetHandler {
        public void onResult(OpenChannel var1, SendBirdException var2);
    }

    public static interface OpenChannelExitHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelEnterHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelRefreshHandler {
        public void onResult(SendBirdException var1);
    }
}

