/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public final class GroupChannelListQuery {
    private static final String ORDER_LATEST_LAST_MESSAGE = "latest_last_message";
    private static final String ORDER_CHRONOLOGICAL = "chronological";
    private final User mUser;
    private String mToken = "";
    private boolean mHasNext = true;
    private int mLimit = 20;
    private boolean mLoading = false;
    private boolean mIncludeEmpty = false;
    private String mOrder = "latest_last_message";
    private FilterMode mFilterMode = FilterMode.ALL;
    private ArrayList<String> mFilter;

    GroupChannelListQuery(User user) {
        this.mUser = user;
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public void setIncludeEmpty(boolean includeEmpty) {
        this.mIncludeEmpty = includeEmpty;
    }

    public void setOrder(Order order) {
        this.mOrder = order == Order.CHRONOLOGICAL ? ORDER_CHRONOLOGICAL : ORDER_LATEST_LAST_MESSAGE;
    }

    public void setNicknameContainsFilter(String nickname) {
        if (nickname == null || nickname.length() == 0) {
            this.mFilterMode = FilterMode.ALL;
            return;
        }
        this.mFilterMode = FilterMode.MEMBERS_NICKNAME_CONTAINS;
        this.mFilter = new ArrayList();
        this.mFilter.add(nickname);
    }

    public void setUserIdsFilter(List<String> userIds, boolean exactMatch) {
        if (userIds == null) {
            this.mFilterMode = FilterMode.ALL;
            return;
        }
        this.mFilterMode = exactMatch ? FilterMode.MEMBERS_EXACTLY_IN : FilterMode.MEMBERS_INCLUDE_IN;
        this.mFilter = new ArrayList();
        this.mFilter.addAll(userIds);
    }

    public boolean hasNext() {
        return this.mHasNext;
    }

    public synchronized boolean isLoading() {
        return this.mLoading;
    }

    synchronized void setLoading(boolean tf) {
        this.mLoading = tf;
    }

    public synchronized void next(final GroupChannelListQueryResultHandler handler) {
        if (!this.hasNext()) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new ArrayList<GroupChannel>(), null);
                    }
                });
            }
            return;
        }
        if (this.isLoading()) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Query in progress.", 800170));
                    }
                });
            }
            return;
        }
        this.setLoading(true);
        APIClient.getInstance().loadUserGroupChannelList(this.mUser.getUserId(), this.mToken, this.mLimit, this.mIncludeEmpty, this.mOrder, this.mFilterMode, this.mFilter, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                GroupChannelListQuery.this.setLoading(false);
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                GroupChannelListQuery.this.mToken = result.get("next").getAsString();
                if (GroupChannelListQuery.this.mToken == null || GroupChannelListQuery.this.mToken.length() <= 0) {
                    GroupChannelListQuery.this.mHasNext = false;
                }
                JsonArray channelObjs = result.get("channels").getAsJsonArray();
                final ArrayList<GroupChannel> channels = new ArrayList<GroupChannel>();
                for (int i = 0; i < channelObjs.size(); ++i) {
                    channels.add(GroupChannel.upsert(channelObjs.get(i)));
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(channels, null);
                        }
                    });
                }
            }
        });
    }

    public static interface GroupChannelListQueryResultHandler {
        public void onResult(List<GroupChannel> var1, SendBirdException var2);
    }

    static enum FilterMode {
        ALL,
        MEMBERS_EXACTLY_IN,
        MEMBERS_NICKNAME_CONTAINS,
        MEMBERS_INCLUDE_IN;

    }

    public static enum Order {
        CHRONOLOGICAL,
        LATEST_LAST_MESSAGE;

    }
}

