/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.SendBird;
import com.sendbird.android.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public abstract class BaseMessageParams {
    String mData;
    String mCustomType;
    MentionType mMentionType = MentionType.USERS;
    List<String> mMentionedUserIds;
    PushNotificationDeliveryOption mPushNotificationDeliveryOption;
    Map<String, List<String>> mMetaArray;

    BaseMessageParams setData(String data) {
        this.mData = data;
        return this;
    }

    BaseMessageParams setCustomType(String customType) {
        this.mCustomType = customType;
        return this;
    }

    BaseMessageParams setMentionType(MentionType mentionType) {
        this.mMentionType = mentionType;
        return this;
    }

    BaseMessageParams setMentionedUsers(List<User> mentionedUsers) {
        if (this.mMentionedUserIds == null) {
            this.mMentionedUserIds = new ArrayList<String>();
        }
        this.mMentionedUserIds.clear();
        if (mentionedUsers != null && mentionedUsers.size() > 0) {
            mentionedUsers = new ArrayList<User>(new LinkedHashSet<User>(mentionedUsers));
            String currentUserId = SendBird.getCurrentUser() != null ? SendBird.getCurrentUser().getUserId() : null;
            for (User user : mentionedUsers) {
                String userId;
                if (user == null || (userId = user.getUserId()) == null || userId.length() <= 0 || currentUserId != null && currentUserId.equals(userId)) continue;
                this.mMentionedUserIds.add(user.getUserId());
            }
        }
        return this;
    }

    BaseMessageParams setMentionedUserIds(List<String> mentionedUserIds) {
        if (this.mMentionedUserIds == null) {
            this.mMentionedUserIds = new ArrayList<String>();
        }
        this.mMentionedUserIds.clear();
        if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
            mentionedUserIds = new ArrayList<String>(new LinkedHashSet<String>(mentionedUserIds));
            String currentUserId = SendBird.getCurrentUser() != null ? SendBird.getCurrentUser().getUserId() : null;
            for (String userId : mentionedUserIds) {
                if (userId == null || userId.length() <= 0 || currentUserId != null && currentUserId.equals(userId)) continue;
                this.mMentionedUserIds.add(userId);
            }
        }
        return this;
    }

    BaseMessageParams setPushNotificationDeliveryOption(PushNotificationDeliveryOption pushNotificationDeliveryOption) {
        this.mPushNotificationDeliveryOption = pushNotificationDeliveryOption;
        return this;
    }

    BaseMessageParams setMetaArrayKeys(List<String> metaArrayKeys) {
        if (metaArrayKeys != null && metaArrayKeys.size() > 0) {
            metaArrayKeys = new ArrayList<String>(new LinkedHashSet<String>(metaArrayKeys));
            if (this.mMetaArray == null) {
                this.mMetaArray = new HashMap<String, List<String>>();
            }
            for (String metaArrayKey : metaArrayKeys) {
                if (metaArrayKey == null) continue;
                this.mMetaArray.put(metaArrayKey, new ArrayList());
            }
        }
        return this;
    }

    public static enum MentionType {
        USERS,
        CHANNEL;

    }

    public static enum PushNotificationDeliveryOption {
        DEFAULT,
        SUPPRESS;

    }
}

