/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public final class FriendListQuery {
    private String mToken = "";
    private int mLimit = 20;
    private boolean mHasNext = true;
    private boolean mLoading = false;

    FriendListQuery() {
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public boolean hasNext() {
        return this.mHasNext;
    }

    public synchronized boolean isLoading() {
        return this.mLoading;
    }

    synchronized void setLoading(boolean tf) {
        this.mLoading = tf;
    }

    public synchronized void next(final FriendListQueryResultHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Connection must be required.", 800101));
                    }
                });
            }
            return;
        }
        if (!this.hasNext()) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new ArrayList<User>(), null);
                    }
                });
            }
            return;
        }
        if (this.isLoading()) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Query in progress.", 800170));
                    }
                });
            }
            return;
        }
        this.setLoading(true);
        APIClient.getInstance().loadFriendList(SendBird.getCurrentUser().getUserId(), this.mToken, this.mLimit, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                FriendListQuery.this.setLoading(false);
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                FriendListQuery.this.mToken = result.get("next").getAsString();
                if (FriendListQuery.this.mToken == null || FriendListQuery.this.mToken.length() <= 0) {
                    FriendListQuery.this.mHasNext = false;
                }
                JsonArray usersArray = result.get("users").getAsJsonArray();
                final ArrayList<User> users = new ArrayList<User>();
                for (int i = 0; i < usersArray.size(); ++i) {
                    users.add(new User(usersArray.get(i)));
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(users, null);
                        }
                    });
                }
            }
        });
    }

    public static interface FriendListQueryResultHandler {
        public void onResult(List<User> var1, SendBirdException var2);
    }
}

