/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.util.Base64;
import com.sendbird.android.AdminMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.android.Logger;
import com.sendbird.android.SendBird;
import com.sendbird.android.User;
import com.sendbird.android.UserMessage;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseMessage {
    protected long mMessageId;
    protected String mChannelUrl;
    protected String mChannelType;
    protected long mCreatedAt;
    protected long mUpdatedAt;
    protected List<User> mMentionedUsers;

    protected static BaseMessage build(JsonElement el, String channelUrl, String channelType) {
        try {
            String type;
            JsonObject obj = el.getAsJsonObject();
            switch (type = obj.get("type").getAsString()) {
                case "MESG": {
                    String reqId = obj.has("req_id") ? obj.get("req_id").getAsString() : "";
                    User user = new User(obj.get("user"));
                    long msgId = obj.get("message_id").getAsLong();
                    String message = obj.get("message").getAsString();
                    String data = obj.get("data").getAsString();
                    long createdAt = obj.get("created_at").getAsLong();
                    long updatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
                    String customType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : null;
                    String translations = obj.has("translations") ? obj.get("translations").toString() : null;
                    String mentionedUsers = obj.has("mentioned_users") ? obj.get("mentioned_users").toString() : null;
                    return new UserMessage(UserMessage.build(reqId, msgId, user, channelUrl, channelType, message, data, customType, translations, createdAt, updatedAt, null, mentionedUsers));
                }
                case "FILE": {
                    String reqId = obj.has("req_id") ? obj.get("req_id").getAsString() : "";
                    User user = new User(obj.get("user"));
                    long msgId = obj.get("message_id").getAsLong();
                    JsonObject file = obj.get("file").getAsJsonObject();
                    String url = file.get("url").getAsString();
                    String name = file.get("name").getAsString();
                    String fileType = file.get("type").getAsString();
                    int size = file.get("size").getAsInt();
                    String data = file.get("data").getAsString();
                    long createdAt = obj.get("created_at").getAsLong();
                    long updatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
                    String customType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : null;
                    String thumbnails = obj.has("thumbnails") ? obj.get("thumbnails").toString() : null;
                    boolean requireAuth = obj.has("require_auth") && obj.get("require_auth").getAsBoolean();
                    String mentionedUsers = obj.has("mentioned_users") ? obj.get("mentioned_users").toString() : null;
                    return new FileMessage(FileMessage.build(reqId, msgId, user, channelUrl, channelType, url, name, fileType, size, data, customType, thumbnails, requireAuth, createdAt, updatedAt, null, mentionedUsers));
                }
                case "BRDM": 
                case "ADMM": {
                    long msgId = obj.get("message_id").getAsLong();
                    String message = obj.get("message").getAsString();
                    String data = obj.get("data").getAsString();
                    long createdAt = obj.get("created_at").getAsLong();
                    long updatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
                    String customType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : null;
                    String mentionedUsers = obj.has("mentioned_users") ? obj.get("mentioned_users").toString() : null;
                    return new AdminMessage(AdminMessage.build(msgId, channelUrl, channelType, message, data, customType, createdAt, updatedAt, null, mentionedUsers));
                }
            }
            Logger.e("Unknown message type: " + type);
        }
        catch (Exception e) {
            Logger.e(e);
        }
        return null;
    }

    protected BaseMessage(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        this.mMessageId = obj.has("msg_id") ? obj.get("msg_id").getAsLong() : 0L;
        this.mChannelUrl = obj.has("channel_url") ? obj.get("channel_url").getAsString() : "";
        this.mChannelType = obj.has("channel_type") ? obj.get("channel_type").getAsString() : "group";
        this.mCreatedAt = obj.has("ts") ? obj.get("ts").getAsLong() : 0L;
        this.mUpdatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
        this.mMentionedUsers = new ArrayList<User>();
        if (obj.has("mentioned_users")) {
            JsonArray array = obj.getAsJsonArray("mentioned_users");
            for (int i = 0; i < array.size(); ++i) {
                this.mMentionedUsers.add(new User(array.get(i)));
            }
        }
    }

    JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("message_id", this.mMessageId);
        obj.addProperty("channel_url", this.mChannelUrl);
        obj.addProperty("channel_type", this.mChannelType);
        obj.addProperty("created_at", this.mCreatedAt);
        obj.addProperty("updated_at", this.mUpdatedAt);
        if (this.mMentionedUsers != null && this.mMentionedUsers.size() > 0) {
            JsonArray array = new JsonArray();
            for (User mentionedUser : this.mMentionedUsers) {
                if (mentionedUser == null) continue;
                array.add(mentionedUser.toJson());
            }
            obj.add("mentioned_users", array);
        }
        return obj;
    }

    public static BaseMessage buildFromSerializedData(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(data[i] ^ i & 0xFF);
        }
        try {
            String str = new String(Base64.decode((byte[])data, (int)0), "UTF-8");
            JsonObject obj = new JsonParser().parse(str).getAsJsonObject();
            return BaseMessage.build(obj, obj.get("channel_url").getAsString(), obj.get("channel_type").getAsString());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getMessageId() {
        return this.mMessageId;
    }

    public long getCreatedAt() {
        return this.mCreatedAt;
    }

    public long getUpdatedAt() {
        return this.mUpdatedAt;
    }

    public List<User> getMentionedUsers() {
        return this.mMentionedUsers;
    }

    List<String> getMentionedUserIds() {
        ArrayList<String> mentionedUserIds = null;
        if (this.mMentionedUsers != null && this.mMentionedUsers.size() > 0) {
            mentionedUserIds = new ArrayList<String>();
            for (User mentionedUser : this.mMentionedUsers) {
                if (mentionedUser == null || mentionedUser.getUserId() == null || mentionedUser.getUserId().length() <= 0) continue;
                mentionedUserIds.add(mentionedUser.getUserId());
            }
        }
        return mentionedUserIds;
    }

    boolean isMentionedUser(String userId) {
        boolean result = false;
        if (this.mMentionedUsers != null && this.mMentionedUsers.size() > 0) {
            for (User mentionedUser : this.mMentionedUsers) {
                if (!mentionedUser.getUserId().equals(userId)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public String getChannelUrl() {
        return this.mChannelUrl;
    }

    public boolean isOpenChannel() {
        return this.mChannelType.equals("open");
    }

    public boolean isGroupChannel() {
        return this.mChannelType.equals("group");
    }
}

