/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.FileMessage;
import com.sendbird.android.GroupChannelListQuery;
import com.sendbird.android.GroupChannelMemberListQuery;
import com.sendbird.android.Logger;
import com.sendbird.android.PublicGroupChannelListQuery;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.shadow.com.google.gson.Gson;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonNull;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import com.sendbird.android.shadow.okhttp3.Call;
import com.sendbird.android.shadow.okhttp3.Callback;
import com.sendbird.android.shadow.okhttp3.Headers;
import com.sendbird.android.shadow.okhttp3.MediaType;
import com.sendbird.android.shadow.okhttp3.OkHttpClient;
import com.sendbird.android.shadow.okhttp3.Request;
import com.sendbird.android.shadow.okhttp3.RequestBody;
import com.sendbird.android.shadow.okhttp3.Response;
import com.sendbird.android.shadow.okhttp3.internal.Util;
import com.sendbird.android.shadow.okio.Buffer;
import com.sendbird.android.shadow.okio.BufferedSink;
import com.sendbird.android.shadow.okio.ByteString;
import com.sendbird.android.shadow.okio.ForwardingSink;
import com.sendbird.android.shadow.okio.Okio;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

class APIClient {
    private static final Gson sGson = new Gson();
    private static final String ROUTING_URL = "https://api-p.sendbird.com/routing/%s";
    private static final String API_USERS = "/v3/users";
    private static final String API_USERS_USERID_LOGIN = "/v3/users/%s/login";
    private static final String API_USERS_USERID = "/v3/users/%s";
    private static final String API_USERS_USERID_UNREADCOUNT = "/v3/users/%s/unread_count";
    private static final String API_USERS_USERID_UNREADMESSAGECOUNT = "/v3/users/%s/unread_message_count";
    private static final String API_USERS_USERID_UNREADCHANNELCOUNT = "/v3/users/%s/unread_channel_count";
    private static final String API_USERS_USERID_GROUPCHANNELCOUNT = "/v3/users/%s/group_channel_count";
    private static final String API_USERS_USERID_MARKASREADALL = "/v3/users/%s/mark_as_read_all";
    private static final String API_USERS_USERID_PUSH_GCM_TOKEN = "/v3/users/%s/push/gcm/%s";
    private static final String API_USERS_USERID_PUSH_GCM = "/v3/users/%s/push/gcm";
    private static final String API_USERS_USERID_PUSH = "/v3/users/%s/push";
    private static final String API_USERS_USERID_PUSH_TEMPLATE = "/v3/users/%s/push/template";
    private static final String API_USERS_USERID_PUSHPREFERENCE_CHANNELURL = "/v3/users/%s/push_preference/%s";
    private static final String API_USERS_USERID_PUSHPREFERENCE = "/v3/users/%s/push_preference/";
    private static final String API_USERS_USERID_BLOCK = "/v3/users/%s/block";
    private static final String API_USERS_USERID_BLOCK_TARGETID = "/v3/users/%s/block/%s";
    private static final String API_USERS_USERID_FRIENDS = "/v3/users/%s/friends";
    private static final String API_USERS_USERID_FRIENDS_USERID = "/v3/users/%s/friends/%s";
    private static final String API_USERS_USERID_FRIENDDISCOVERIES = "/v3/users/%s/friend_discoveries";
    private static final String API_USERS_USERID_FRIENDDISCOVERIES_DISCOVERYKEY = "/v3/users/%s/friend_discoveries/%s";
    private static final String API_USERS_USERID_FRIENDS_CHANGELOGS = "/v3/users/%s/friends/changelogs";
    private static final String API_USERS_USERID_MYGROUPCHANNELS = "/v3/users/%s/my_group_channels";
    private static final String API_USERS_USERID_MYGROUPCHANNELS_CHANNELURL_MEMBERS = "/v3/users/%s/my_group_channels/%s/members";
    private static final String API_USERS_USERID_CHANNELINVITATIONPREFERENCE = "/v3/users/%s/channel_invitation_preference";
    private static final String API_USERS_USERID_METADATA = "/v3/users/%s/metadata";
    private static final String API_USERS_USERID_METADATA_KEY = "/v3/users/%s/metadata/%s";
    private static final String API_OPENCHANNELS = "/v3/open_channels";
    private static final String API_OPENCHANNELS_CHANNELURL = "/v3/open_channels/%s";
    private static final String API_OPENCHANNELS_CHANNELURL_MESSAGES = "/v3/open_channels/%s/messages";
    private static final String API_OPENCHANNELS_CHANNELURL_MESSAGES_CHANGELOGS = "/v3/open_channels/%s/messages/changelogs";
    private static final String API_OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID = "/v3/open_channels/%s/messages/%s";
    private static final String API_OPENCHANNELS_CHANNELURL_PARTICIPANTS = "/v3/open_channels/%s/participants";
    private static final String API_OPENCHANNELS_CHANNELURL_METADATA = "/v3/open_channels/%s/metadata";
    private static final String API_OPENCHANNELS_CHANNELURL_METADATA_KEY = "/v3/open_channels/%s/metadata/%s";
    private static final String API_OPENCHANNELS_CHANNELURL_METACOUNTER = "/v3/open_channels/%s/metacounter";
    private static final String API_OPENCHANNELS_CHANNELURL_METACOUNTER_KEY = "/v3/open_channels/%s/metacounter/%s";
    private static final String API_OPENCHANNELS_CHANNELURL_BAN = "/v3/open_channels/%s/ban";
    private static final String API_OPENCHANNELS_CHANNELURL_BAN_USERID = "/v3/open_channels/%s/ban/%s";
    private static final String API_OPENCHANNELS_CHANNELURL_MUTE = "/v3/open_channels/%s/mute";
    private static final String API_OPENCHANNELS_CHANNELURL_MUTE_USERID = "/v3/open_channels/%s/mute/%s";
    private static final String API_GROUPCHANNELS = "/v3/group_channels";
    private static final String API_GROUPCHANNELS_CHANNELURL = "/v3/group_channels/%s";
    private static final String API_GROUPCHANNELS_CHANNELURL_INVITE = "/v3/group_channels/%s/invite";
    private static final String API_GROUPCHANNELS_CHANNELURL_JOIN = "/v3/group_channels/%s/join";
    private static final String API_GROUPCHANNELS_CHANNELURL_HIDE = "/v3/group_channels/%s/hide";
    private static final String API_GROUPCHANNELS_CHANNELURL_LEAVE = "/v3/group_channels/%s/leave";
    private static final String API_GROUPCHANNELS_CHANNELURL_ACCEPT = "/v3/group_channels/%s/accept";
    private static final String API_GROUPCHANNELS_CHANNELURL_DECLINE = "/v3/group_channels/%s/decline";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES = "/v3/group_channels/%s/messages";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES_CHANGELOGS = "/v3/group_channels/%s/messages/changelogs";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES_MARKASREAD = "/v3/group_channels/%s/messages/mark_as_read";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES_TOTALCOUNT = "/v3/group_channels/%s/messages/total_count";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES_UNREADCOUNT = "/v3/group_channels/%s/messages/unread_count";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID = "/v3/group_channels/%s/messages/%s";
    private static final String API_GROUPCHANNELS_CHANNELURL_MEMBERS = "/v3/group_channels/%s/members";
    private static final String API_GROUPCHANNELS_CHANNELURL_METADATA = "/v3/group_channels/%s/metadata";
    private static final String API_GROUPCHANNELS_CHANNELURL_METADATA_KEY = "/v3/group_channels/%s/metadata/%s";
    private static final String API_GROUPCHANNELS_CHANNELURL_METACOUNTER = "/v3/group_channels/%s/metacounter";
    private static final String API_GROUPCHANNELS_CHANNELURL_METACOUNTER_KEY = "/v3/group_channels/%s/metacounter/%s";
    private static final String API_GROUPCHANNELS_CHANNELURL_RESETUSERHISTORY = "/v3/group_channels/%s/reset_user_history";
    private static final String API_GROUPCHANNELS_CHANNELURL_BAN = "/v3/group_channels/%s/ban";
    private static final String API_GROUPCHANNELS_CHANNELURL_BAN_USERID = "/v3/group_channels/%s/ban/%s";
    private static final String API_GROUPCHANNELS_CHANNELURL_MUTE = "/v3/group_channels/%s/mute";
    private static final String API_GROUPCHANNELS_CHANNELURL_MUTE_USERID = "/v3/group_channels/%s/mute/%s";
    private static final String API_GROUPCHANNELS_CHANNELURL_FREEZE = "/v3/group_channels/%s/freeze";
    private static final String API_STORAGE_FILE = "/v3/storage/file";
    private static final String API_STORAGE_PROFILEIMAGE = "/v3/storage/profile_image";
    private static final MediaType MIME_JSON = MediaType.parse("application/json; charset=utf-8");
    private static APIClient sInstance;
    private String mSessionKey = "";
    private String mEKey = "";
    private OkHttpClient mOkHttpClient = new OkHttpClient();
    private OkHttpClient mOkHttpClientLong = new OkHttpClient.Builder().writeTimeout(60000L, TimeUnit.MILLISECONDS).build();
    private ConcurrentHashMap<String, Call> mOngoingRequestsMap;
    private final Object mOngoingRequestsLock = new Object();
    static final int UPDATE_META_COUNTER_MODE_SET = 0;
    static final int UPDATE_META_COUNTER_MODE_INC = 1;
    static final int UPDATE_META_COUNTER_MODE_DEC = 2;

    static synchronized APIClient getInstance() {
        if (sInstance == null) {
            Logger.e("SendBird instance hasn't been initialized. Try SendBird.init().");
            throw new RuntimeException("SendBird instance hasn't been initialized.");
        }
        return sInstance;
    }

    static synchronized void init() {
        if (sInstance == null) {
            sInstance = new APIClient();
        }
    }

    protected APIClient() {
        this.mOngoingRequestsMap = new ConcurrentHashMap();
    }

    void evictAllConnections() {
        Logger.d("Evict all connections.");
        new Thread(){

            @Override
            public void run() {
                APIClient.this.mOkHttpClient.connectionPool().evictAll();
                APIClient.this.mOkHttpClientLong.connectionPool().evictAll();
            }
        }.start();
    }

    void cancelAllRequests() {
        Logger.d("Cancel all API calls.");
        this.mOkHttpClient.dispatcher().cancelAll();
        this.mOkHttpClientLong.dispatcher().cancelAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancelRequest(String requestId) {
        Object object = this.mOngoingRequestsLock;
        synchronized (object) {
            if (this.mOngoingRequestsMap.containsKey(requestId)) {
                this.mOngoingRequestsMap.get(requestId).cancel();
                this.mOngoingRequestsMap.remove(requestId);
                return true;
            }
        }
        return false;
    }

    void groupChannelInvite(String channelUrl, List<String> userIds, APIClientHandler handler) {
        String url = String.format(API_GROUPCHANNELS_CHANNELURL_INVITE, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        JsonArray userIdsObj = new JsonArray();
        for (String userId : userIds) {
            userIdsObj.add(userId);
        }
        form.add("user_ids", userIdsObj);
        this.requestPOST(url, form, handler);
    }

    void groupChannelJoin(String channelUrl, String userId, APIClientHandler handler) {
        String url = String.format(API_GROUPCHANNELS_CHANNELURL_JOIN, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", userId);
        this.requestPUT(url, form, handler);
    }

    void groupChannelHide(String channelUrl, String userId, boolean hidePreviousMessages, APIClientHandler handler) {
        String url = String.format(API_GROUPCHANNELS_CHANNELURL_HIDE, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", userId);
        form.addProperty("hide_previous_messages", hidePreviousMessages);
        this.requestPUT(url, form, handler);
    }

    void groupChannelLeave(String channelUrl, String userId, APIClientHandler handler) {
        String url = String.format(API_GROUPCHANNELS_CHANNELURL_LEAVE, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", userId);
        this.requestPUT(url, form, handler);
    }

    void groupChannelAcceptInvitation(String channelUrl, String userId, APIClientHandler handler) {
        String url = String.format(API_GROUPCHANNELS_CHANNELURL_ACCEPT, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", userId);
        this.requestPUT(url, form, handler);
    }

    void groupChannelDeclineInvitation(String channelUrl, String userId, APIClientHandler handler) {
        String url = String.format(API_GROUPCHANNELS_CHANNELURL_DECLINE, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", userId);
        this.requestPUT(url, form, handler);
    }

    void groupChannelMarkAsRead(String channelUrl, String userId, long ts, APIClientHandler handler) {
        String url = String.format(API_GROUPCHANNELS_CHANNELURL_MESSAGES_MARKASREAD, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", userId);
        form.addProperty("ts", ts);
        this.requestPUT(url, form, handler);
    }

    void groupChannelMarkAsReadAll(String userId, List<String> channelUrls, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_MARKASREADALL, UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        if (channelUrls != null) {
            JsonArray channelUrlsArray = new JsonArray();
            for (String channelUrl : channelUrls) {
                channelUrlsArray.add(channelUrl);
            }
            form.add("channel_urls", channelUrlsArray);
        }
        this.requestPUT(url, form, handler);
    }

    void groupChannelResetMyHistory(String channelUrl, APIClientHandler handler) {
        String url = String.format(API_GROUPCHANNELS_CHANNELURL_RESETUSERHISTORY, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        this.requestPUT(url, form, handler);
    }

    void sendFileMessage(boolean isOpenChannel, String channelUrl, String userId, String fileUrl, String fileName, int fileSize, String fileType, String customType, String data, String thumbnails, boolean requireAuth, List<String> mentionedUserIds, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_MESSAGES, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_MESSAGES, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("message_type", "FILE");
        form.addProperty("user_id", userId);
        form.addProperty("url", fileUrl);
        if (fileName != null) {
            form.addProperty("file_name", fileName);
        }
        if (fileSize > 0) {
            form.addProperty("file_size", fileSize);
        }
        if (fileType != null) {
            form.addProperty("file_type", fileType);
        }
        if (customType != null) {
            form.addProperty("custom_type", customType);
        }
        if (data != null) {
            form.addProperty("custom_field", data);
        }
        if (thumbnails != null) {
            form.add("thumbnails", new JsonParser().parse(thumbnails));
        }
        if (requireAuth) {
            form.addProperty("require_auth", true);
        }
        if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
            JsonArray array = new JsonArray();
            for (String mentionedUserId : mentionedUserIds) {
                array.add(mentionedUserId);
            }
            form.add("mentioned_user_ids", array);
        }
        this.requestPOST(url, form, handler);
    }

    void messageList(boolean isOpenChannel, String channelUrl, long messageTimestamp, int prevLimit, int nextLimit, boolean include, boolean reverse, String messageType, String customType, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_MESSAGES, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_MESSAGES, UrlUtil.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("is_sdk", String.valueOf(true));
        params.put("message_ts", String.valueOf(messageTimestamp));
        params.put("prev_limit", String.valueOf(prevLimit));
        params.put("next_limit", String.valueOf(nextLimit));
        params.put("include", String.valueOf(include));
        params.put("reverse", String.valueOf(reverse));
        if (messageType != null) {
            params.put("message_type", messageType);
        }
        if (customType != null) {
            params.put("custom_type", customType);
        }
        this.requestGET(url, params, null, handler);
    }

    void messageListById(boolean isOpenChannel, String channelUrl, long messageId, int prevLimit, int nextLimit, boolean include, boolean reverse, String messageType, String customType, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_MESSAGES, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_MESSAGES, UrlUtil.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("is_sdk", String.valueOf(true));
        params.put("message_id", String.valueOf(messageId));
        params.put("prev_limit", String.valueOf(prevLimit));
        params.put("next_limit", String.valueOf(nextLimit));
        params.put("include", String.valueOf(include));
        params.put("reverse", String.valueOf(reverse));
        if (messageType != null) {
            params.put("message_type", messageType);
        }
        if (customType != null) {
            params.put("custom_type", customType);
        }
        this.requestGET(url, params, null, handler);
    }

    void messageChangeLogsByToken(boolean isOpenChannel, String channelUrl, String token, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_MESSAGES_CHANGELOGS, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_MESSAGES_CHANGELOGS, UrlUtil.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        if (token != null) {
            params.put("token", token);
        }
        this.requestGET(url, params, null, handler);
    }

    void login(String userId, String accessToken, final APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_LOGIN, UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        form.addProperty("app_id", SendBird.getApplicationId());
        if (accessToken != null) {
            form.addProperty("access_token", accessToken);
        }
        this.requestPOST(url, form, new APIClientHandler(){

            @Override
            public void onResult(JsonElement response, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String sessionKey = response.getAsJsonObject().get("key").getAsString();
                APIClient.this.setSessionKey(sessionKey);
                if (handler != null) {
                    handler.onResult(response, null);
                }
            }
        });
    }

    void updateUserInfo(String userId, String nickname, String profileUrl, List<String> discoveryKeys, APIClientHandler handler) {
        JsonObject form = this.defaultForm();
        if (nickname != null) {
            form.addProperty("nickname", nickname);
        }
        if (profileUrl != null) {
            form.addProperty("profile_url", profileUrl);
        }
        if (discoveryKeys != null) {
            JsonArray discoveryKeysArray = new JsonArray();
            for (String discoveryKey : discoveryKeys) {
                discoveryKeysArray.add(discoveryKey);
            }
            form.add("discovery_keys", discoveryKeysArray);
        }
        String url = String.format(API_USERS_USERID, UrlUtil.urlEncodeUTF8(userId));
        this.requestPUT(url, form, handler);
    }

    void updateUserInfo(String userId, String nickname, File profileFile, List<String> discoveryKeys, APIClientHandler handler) {
        HashMap<String, String> form = new HashMap<String, String>();
        String filename = null;
        if (nickname != null) {
            form.put("nickname", nickname);
        }
        if (profileFile != null) {
            filename = "profile_file";
        }
        if (discoveryKeys != null) {
            StringBuilder sb = new StringBuilder();
            String separator = "";
            for (String str : discoveryKeys) {
                sb.append(separator);
                separator = ",";
                sb.append(str);
            }
            String result = sb.toString();
            form.put("discovery_keys", result);
        }
        String url = String.format(API_USERS_USERID, UrlUtil.urlEncodeUTF8(userId));
        this.requestPUT(url, form, filename, profileFile, handler);
    }

    void getGroupChannel(String channelUrl, boolean member, boolean readReceipt, APIClientHandler handler) {
        String url = String.format(API_GROUPCHANNELS_CHANNELURL, UrlUtil.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("member", String.valueOf(member));
        params.put("read_receipt", String.valueOf(readReceipt));
        this.requestGET(url, params, null, handler);
    }

    void getOpenChannel(String channelUrl, APIClientHandler handler) {
        String url = String.format(API_OPENCHANNELS_CHANNELURL, UrlUtil.urlEncodeUTF8(channelUrl));
        this.requestGET(url, handler);
    }

    void createGroupChannel(List<String> userIds, List<String> operatorUserIds, Boolean isSuper, Boolean isPublic, Boolean isEphemeral, Boolean isDistinct, String channelUrl, String name, String coverUrl, String data, String customType, APIClientHandler handler) {
        String url = API_GROUPCHANNELS;
        JsonObject form = this.defaultForm();
        JsonArray userIdsObj = new JsonArray();
        for (String userId : userIds) {
            userIdsObj.add(userId);
        }
        form.add("user_ids", userIdsObj);
        if (operatorUserIds != null && operatorUserIds.size() > 0) {
            JsonArray operatorUserIdsObj = new JsonArray();
            for (String operatorUserId : operatorUserIds) {
                operatorUserIdsObj.add(operatorUserId);
            }
            form.add("operator_ids", operatorUserIdsObj);
        }
        if (isSuper != null) {
            form.addProperty("is_super", isSuper);
        }
        if (isPublic != null) {
            form.addProperty("is_public", isPublic);
        }
        if (isEphemeral != null) {
            form.addProperty("is_ephemeral", isEphemeral);
        }
        if (isDistinct != null) {
            form.addProperty("is_distinct", isDistinct);
        }
        if (channelUrl != null) {
            form.addProperty("channel_url", channelUrl);
        }
        if (name != null) {
            form.addProperty("name", name);
        }
        if (coverUrl != null) {
            form.addProperty("cover_url", coverUrl);
        }
        if (data != null) {
            form.addProperty("data", data);
        }
        if (customType != null) {
            form.addProperty("custom_type", customType);
        }
        this.requestPOST(url, form, handler);
    }

    void createGroupChannel(List<String> userIds, List<String> operatorUserIds, Boolean isSuper, Boolean isPublic, Boolean isEphemeral, Boolean isDistinct, String channelUrl, String name, File coverFile, String data, String customType, APIClientHandler handler) {
        String url = API_GROUPCHANNELS;
        HashMap<String, String> form = new HashMap<String, String>();
        String filename = null;
        if (userIds != null && userIds.size() > 0) {
            form.put("user_ids", UrlUtil.urlEncodeUTF8(userIds));
        }
        if (operatorUserIds != null && operatorUserIds.size() > 0) {
            form.put("operator_ids", UrlUtil.urlEncodeUTF8(operatorUserIds));
        }
        if (isSuper != null) {
            form.put("is_super", isSuper != false ? "true" : "false");
        }
        if (isPublic != null) {
            form.put("is_public", isPublic != false ? "true" : "false");
        }
        if (isEphemeral != null) {
            form.put("is_ephemeral", isEphemeral != false ? "true" : "false");
        }
        if (isDistinct != null) {
            form.put("is_distinct", isDistinct != false ? "true" : "false");
        }
        if (channelUrl != null) {
            form.put("channel_url", channelUrl);
        }
        if (name != null) {
            form.put("name", name);
        }
        if (coverFile != null) {
            filename = "cover_file";
        }
        if (data != null) {
            form.put("data", data);
        }
        if (customType != null) {
            form.put("custom_type", customType);
        }
        this.requestPOST(url, form, filename, coverFile, handler);
    }

    void updateGroupChannel(String channelUrl, Boolean isPublic, Boolean isEphemeral, Boolean isDistinct, String name, String coverUrl, String data, String customType, APIClientHandler handler) {
        String url = String.format(API_GROUPCHANNELS_CHANNELURL, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        if (isPublic != null) {
            form.addProperty("is_public", isPublic);
        }
        if (isEphemeral != null) {
            form.addProperty("is_ephemeral", isEphemeral);
        }
        if (isDistinct != null) {
            form.addProperty("is_distinct", isDistinct);
        }
        if (name != null) {
            form.addProperty("name", name);
        }
        if (coverUrl != null) {
            form.addProperty("cover_url", coverUrl);
        }
        if (data != null) {
            form.addProperty("data", data);
        }
        if (customType != null) {
            form.addProperty("custom_type", customType);
        }
        this.requestPUT(url, form, handler);
    }

    void updateGroupChannel(String channelUrl, Boolean isPublic, Boolean isEphemeral, Boolean isDistinct, String name, File coverFile, String data, String customType, APIClientHandler handler) {
        String url = String.format(API_GROUPCHANNELS_CHANNELURL, UrlUtil.urlEncodeUTF8(channelUrl));
        HashMap<String, String> form = new HashMap<String, String>();
        String filename = null;
        if (isPublic != null) {
            form.put("is_public", isPublic != false ? "true" : "false");
        }
        if (isEphemeral != null) {
            form.put("is_ephemeral", isEphemeral != false ? "true" : "false");
        }
        if (isDistinct != null) {
            form.put("is_distinct", isDistinct != false ? "true" : "false");
        }
        if (name != null) {
            form.put("name", name);
        }
        if (coverFile != null) {
            filename = "cover_file";
        }
        if (data != null) {
            form.put("data", data);
        }
        if (customType != null) {
            form.put("custom_type", customType);
        }
        this.requestPUT(url, form, filename, coverFile, handler);
    }

    void createOpenChannel(String name, String coverUrl, String data, String customType, List<String> operatorUserIds, APIClientHandler handler) {
        String url = API_OPENCHANNELS;
        JsonObject form = this.defaultForm();
        if (name != null) {
            form.addProperty("name", name);
        }
        if (coverUrl != null) {
            form.addProperty("cover_url", coverUrl);
        }
        if (data != null) {
            form.addProperty("data", data);
        }
        if (customType != null) {
            form.addProperty("custom_type", customType);
        }
        if (operatorUserIds != null && operatorUserIds.size() > 0) {
            JsonArray operatorUserIdsObj = new JsonArray();
            for (String operatorUserId : operatorUserIds) {
                operatorUserIdsObj.add(operatorUserId);
            }
            form.add("operators", operatorUserIdsObj);
        }
        this.requestPOST(url, form, handler);
    }

    void createOpenChannel(String name, File coverFile, String data, String customType, List<String> operatorUserIds, APIClientHandler handler) {
        String url = API_OPENCHANNELS;
        HashMap<String, String> form = new HashMap<String, String>();
        String filename = null;
        if (name != null) {
            form.put("name", name);
        }
        if (coverFile != null) {
            filename = "cover_file";
        }
        if (data != null) {
            form.put("data", data);
        }
        if (customType != null) {
            form.put("custom_type", customType);
        }
        if (operatorUserIds != null && operatorUserIds.size() > 0) {
            form.put("operators", UrlUtil.urlEncodeUTF8(operatorUserIds));
        }
        this.requestPOST(url, form, filename, coverFile, handler);
    }

    void updateOpenChannel(String channelUrl, String name, String coverUrl, String data, String customType, List<String> operatorUserIds, APIClientHandler handler) {
        String url = String.format(API_OPENCHANNELS_CHANNELURL, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        if (name != null) {
            form.addProperty("name", name);
        }
        if (coverUrl != null) {
            form.addProperty("cover_url", coverUrl);
        }
        if (data != null) {
            form.addProperty("data", data);
        }
        if (customType != null) {
            form.addProperty("custom_type", customType);
        }
        if (operatorUserIds != null && operatorUserIds.size() > 0) {
            JsonArray operatorUserIdsObj = new JsonArray();
            for (String operatorUserId : operatorUserIds) {
                operatorUserIdsObj.add(operatorUserId);
            }
            form.add("operators", operatorUserIdsObj);
        }
        this.requestPUT(url, form, handler);
    }

    void updateOpenChannel(String channelUrl, String name, File coverFile, String data, String customType, List<String> operatorUserIds, APIClientHandler handler) {
        String url = String.format(API_OPENCHANNELS_CHANNELURL, UrlUtil.urlEncodeUTF8(channelUrl));
        HashMap<String, String> form = new HashMap<String, String>();
        String filename = null;
        if (name != null) {
            form.put("name", name);
        }
        if (coverFile != null) {
            filename = "cover_file";
        }
        if (data != null) {
            form.put("data", data);
        }
        if (customType != null) {
            form.put("custom_type", customType);
        }
        if (operatorUserIds != null && operatorUserIds.size() > 0) {
            form.put("operators", UrlUtil.urlEncodeUTF8(operatorUserIds));
        }
        this.requestPUT(url, form, filename, coverFile, handler);
    }

    void createMetaCounters(boolean isOpenChannel, String channelUrl, Map<String, Integer> metaCounterMap, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        JsonObject metas = new JsonObject();
        for (Map.Entry<String, Integer> entry : metaCounterMap.entrySet()) {
            metas.addProperty(entry.getKey(), entry.getValue());
        }
        form.add("metacounter", metas);
        this.requestPOST(url, form, handler);
    }

    void updateMetaCounters(boolean isOpenChannel, String channelUrl, Map<String, Integer> metaCounterMap, boolean upsert, int mode, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        JsonObject metas = new JsonObject();
        for (Map.Entry<String, Integer> entry : metaCounterMap.entrySet()) {
            metas.addProperty(entry.getKey(), entry.getValue());
        }
        form.add("metacounter", metas);
        form.addProperty("upsert", upsert);
        switch (mode) {
            case 0: {
                form.addProperty("mode", "set");
                break;
            }
            case 1: {
                form.addProperty("mode", "increase");
                break;
            }
            case 2: {
                form.addProperty("mode", "decrease");
            }
        }
        this.requestPUT(url, form, handler);
    }

    void getAllMetaCounters(boolean isOpenChannel, String channelUrl, APIClientHandler handler) {
        this.getMetaCounters(isOpenChannel, channelUrl, new ArrayList<String>(), handler);
    }

    void getMetaCounters(boolean isOpenChannel, String channelUrl, Collection<String> keys, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl));
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        if (keys != null && keys.size() > 0) {
            paramsWithListValue.put("keys", keys);
        }
        this.requestGET(url, null, paramsWithListValue, handler);
    }

    void deleteMetaCounter(boolean isOpenChannel, String channelUrl, String key, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METACOUNTER_KEY, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(key)) : String.format(API_GROUPCHANNELS_CHANNELURL_METACOUNTER_KEY, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(key));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    void deleteAllMetaCounters(boolean isOpenChannel, String channelUrl, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    void createMetaData(boolean isOpenChannel, String channelUrl, Map<String, String> metaDataMap, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        JsonObject metas = new JsonObject();
        for (Map.Entry<String, String> entry : metaDataMap.entrySet()) {
            metas.addProperty(entry.getKey(), entry.getValue());
        }
        form.add("metadata", metas);
        this.requestPOST(url, form, handler);
    }

    void updateMetaData(boolean isOpenChannel, String channelUrl, Map<String, String> metaDataMap, boolean upsert, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        JsonObject metas = new JsonObject();
        for (Map.Entry<String, String> entry : metaDataMap.entrySet()) {
            metas.addProperty(entry.getKey(), entry.getValue());
        }
        form.add("metadata", metas);
        form.addProperty("upsert", upsert);
        this.requestPUT(url, form, handler);
    }

    void getAllMetaData(boolean isOpenChannel, String channelUrl, APIClientHandler handler) {
        this.getMetaData(isOpenChannel, channelUrl, new ArrayList<String>(), handler);
    }

    void getMetaData(boolean isOpenChannel, String channelUrl, Collection<String> keys, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl));
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        if (keys != null && keys.size() > 0) {
            paramsWithListValue.put("keys", keys);
        }
        this.requestGET(url, null, paramsWithListValue, handler);
    }

    void deleteMetaData(boolean isOpenChannel, String channelUrl, String key, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METADATA_KEY, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(key)) : String.format(API_GROUPCHANNELS_CHANNELURL_METADATA_KEY, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(key));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    void deleteAllMetaData(boolean isOpenChannel, String channelUrl, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    void createUserMetaData(String userId, Map<String, String> metaDataMap, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_METADATA, UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        JsonObject metas = new JsonObject();
        for (Map.Entry<String, String> entry : metaDataMap.entrySet()) {
            metas.addProperty(entry.getKey(), entry.getValue());
        }
        form.add("metadata", metas);
        this.requestPOST(url, form, handler);
    }

    void updateUserMetaData(String userId, Map<String, String> metaDataMap, boolean upsert, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_METADATA, UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        JsonObject metas = new JsonObject();
        for (Map.Entry<String, String> entry : metaDataMap.entrySet()) {
            metas.addProperty(entry.getKey(), entry.getValue());
        }
        form.add("metadata", metas);
        form.addProperty("upsert", upsert);
        this.requestPUT(url, form, handler);
    }

    void getAllUserMetaData(String userId, APIClientHandler handler) {
        this.getUserMetaData(userId, new ArrayList<String>(), handler);
    }

    void getUserMetaData(String userId, Collection<String> keys, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_METADATA, UrlUtil.urlEncodeUTF8(userId));
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        if (keys != null && keys.size() > 0) {
            paramsWithListValue.put("keys", keys);
        }
        this.requestGET(url, null, paramsWithListValue, handler);
    }

    void deleteUserMetaData(String userId, String key, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_METADATA_KEY, UrlUtil.urlEncodeUTF8(userId), UrlUtil.urlEncodeUTF8(key));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    void deleteAllUserMetaData(String userId, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_METADATA, UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    private void addMetaDataFilterToParams(Map<String, String> params, Map<String, Collection<String>> paramsWithListValue, Map<String, List<String>> metaDataFilter) {
        String key;
        List<String> values;
        Iterator<String> keys;
        if (metaDataFilter != null && (keys = metaDataFilter.keySet().iterator()).hasNext() && (values = metaDataFilter.get(key = keys.next())) != null && values.size() > 0) {
            params.put("metadatakey", key);
            paramsWithListValue.put("metadatavalues_in", values);
        }
    }

    void loadUserList(String token, int limit, List<String> userIds, Map<String, List<String>> metaDataFilter, APIClientHandler handler) {
        String url = API_USERS;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", token);
        params.put("limit", String.valueOf(limit));
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        if (userIds != null && userIds.size() > 0) {
            paramsWithListValue.put("user_ids", userIds);
        }
        this.addMetaDataFilterToParams(params, paramsWithListValue, metaDataFilter);
        this.requestGET(url, params, paramsWithListValue, handler);
    }

    void loadBlockedUserList(String blockerUserId, String token, int limit, Map<String, List<String>> metaDataFilter, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_BLOCK, UrlUtil.urlEncodeUTF8(blockerUserId));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", token);
        params.put("limit", String.valueOf(limit));
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        this.addMetaDataFilterToParams(params, paramsWithListValue, metaDataFilter);
        this.requestGET(url, params, paramsWithListValue, handler);
    }

    void loadOpenChannelList(String token, int limit, String nameKeyword, String urlKeyword, String customType, String customTypeStartsWith, ArrayList<String> customTypes, APIClientHandler handler) {
        String url = API_OPENCHANNELS;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", token);
        params.put("limit", String.valueOf(limit));
        if (customType != null) {
            params.put("custom_type", customType);
        }
        if (nameKeyword != null) {
            params.put("name_contains", nameKeyword);
        }
        if (urlKeyword != null) {
            params.put("url_contains", urlKeyword);
        }
        if (customTypeStartsWith != null) {
            params.put("custom_type_startswith", customTypeStartsWith);
        }
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        if (customTypes != null && customTypes.size() > 0) {
            paramsWithListValue.put("custom_types", customTypes);
        }
        this.requestGET(url, params, paramsWithListValue, handler);
    }

    void uploadFile(File file, String mimeType, List<FileMessage.ThumbnailSize> thumbnailSizes, String channelUrl, String requestId, APIClientProgressHandler progressHandler, APIClientHandler handler) {
        this.requestFILE(API_STORAGE_FILE, file, mimeType, thumbnailSizes, channelUrl, requestId, progressHandler, handler);
    }

    void uploadProfileImage(File file, APIClientHandler handler) {
        this.requestFILE(API_STORAGE_PROFILEIMAGE, file, null, null, null, null, null, handler);
    }

    private JsonObject defaultForm() {
        return new JsonObject();
    }

    void loadUserGroupChannelList(String userId, String token, int limit, boolean includeEmpty, String order, APIClientHandler handler) {
        String url = API_GROUPCHANNELS;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user_id", userId);
        params.put("token", token);
        params.put("limit", String.valueOf(limit));
        params.put("read_receipt", String.valueOf(true));
        params.put("member", String.valueOf(true));
        params.put("show_empty", String.valueOf(includeEmpty));
        params.put("order", order);
        this.requestGET(url, params, null, handler);
    }

    void loadUserGroupChannelList(String userId, String token, int limit, boolean includeEmpty, String order, GroupChannelListQuery.FilterMode mode, List<String> filter, GroupChannelListQuery.QueryType queryType, String customType, String customTypeStartsWith, String memberState, List<String> channelUrls, String nameContains, List<String> customTypes, GroupChannelListQuery.SuperChannelFilter superChannelFilter, GroupChannelListQuery.PublicChannelFilter publicChannelFilter, APIClientHandler handler) {
        String key;
        String url = String.format(API_USERS_USERID_MYGROUPCHANNELS, UrlUtil.urlEncodeUTF8(userId));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", token);
        params.put("limit", String.valueOf(limit));
        params.put("show_read_receipt", String.valueOf(true));
        params.put("show_member", String.valueOf(true));
        params.put("show_empty", String.valueOf(includeEmpty));
        params.put("distinct_mode", "all");
        params.put("order", order);
        if (customType != null) {
            params.put("custom_type", customType);
        }
        if (customTypeStartsWith != null) {
            params.put("custom_type_startswith", customTypeStartsWith);
        }
        if (memberState != null) {
            params.put("member_state_filter", memberState);
        }
        if (nameContains != null) {
            params.put("name_contains", nameContains);
        }
        if (mode == GroupChannelListQuery.FilterMode.MEMBERS_EXACTLY_IN) {
            key = "members_exactly_in";
        } else if (mode == GroupChannelListQuery.FilterMode.MEMBERS_NICKNAME_CONTAINS) {
            key = "members_nickname_contains";
        } else if (mode == GroupChannelListQuery.FilterMode.MEMBERS_INCLUDE_IN) {
            String qt;
            key = "members_include_in";
            String string = queryType == GroupChannelListQuery.QueryType.AND ? "AND" : (qt = queryType == GroupChannelListQuery.QueryType.OR ? "OR" : null);
            if (qt != null) {
                params.put("query_type", qt);
            }
        } else {
            key = null;
        }
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        if (key != null && filter != null && filter.size() > 0) {
            paramsWithListValue.put(key, filter);
        }
        if (channelUrls != null && channelUrls.size() > 0) {
            paramsWithListValue.put("channel_urls", channelUrls);
        }
        if (customTypes != null && customTypes.size() > 0) {
            paramsWithListValue.put("custom_types", customTypes);
        }
        if (superChannelFilter == GroupChannelListQuery.SuperChannelFilter.ALL) {
            params.put("super_mode", "all");
        } else if (superChannelFilter == GroupChannelListQuery.SuperChannelFilter.SUPER_CHANNEL_ONLY) {
            params.put("super_mode", "super");
        } else if (superChannelFilter == GroupChannelListQuery.SuperChannelFilter.NONSUPER_CHANNEL_ONLY) {
            params.put("super_mode", "nonsuper");
        }
        if (publicChannelFilter == GroupChannelListQuery.PublicChannelFilter.ALL) {
            params.put("public_mode", "all");
        } else if (publicChannelFilter == GroupChannelListQuery.PublicChannelFilter.PUBLIC) {
            params.put("public_mode", "public");
        } else if (publicChannelFilter == GroupChannelListQuery.PublicChannelFilter.PRIVATE) {
            params.put("public_mode", "private");
        }
        this.requestGET(url, params, paramsWithListValue, handler);
    }

    void loadPublicGroupChannelList(String token, int limit, boolean includeEmpty, String order, String customTypeStartsWith, String memberState, List<String> channelUrls, String nameContains, List<String> customTypes, PublicGroupChannelListQuery.SuperChannelFilter superChannelFilter, PublicGroupChannelListQuery.MembershipFilter membershipFilter, APIClientHandler handler) {
        String url = API_GROUPCHANNELS;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("public_mode", "public");
        params.put("token", token);
        params.put("limit", String.valueOf(limit));
        params.put("show_read_receipt", String.valueOf(true));
        params.put("show_member", String.valueOf(true));
        params.put("show_empty", String.valueOf(includeEmpty));
        params.put("distinct_mode", "all");
        params.put("order", order);
        if (customTypeStartsWith != null) {
            params.put("custom_type_startswith", customTypeStartsWith);
        }
        if (memberState != null) {
            params.put("member_state_filter", memberState);
        }
        if (nameContains != null) {
            params.put("name_contains", nameContains);
        }
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        if (channelUrls != null && channelUrls.size() > 0) {
            paramsWithListValue.put("channel_urls", channelUrls);
        }
        if (customTypes != null && customTypes.size() > 0) {
            paramsWithListValue.put("custom_types", customTypes);
        }
        if (superChannelFilter == PublicGroupChannelListQuery.SuperChannelFilter.ALL) {
            params.put("super_mode", "all");
        } else if (superChannelFilter == PublicGroupChannelListQuery.SuperChannelFilter.SUPER_CHANNEL_ONLY) {
            params.put("super_mode", "super");
        } else if (superChannelFilter == PublicGroupChannelListQuery.SuperChannelFilter.NONSUPER_CHANNEL_ONLY) {
            params.put("super_mode", "nonsuper");
        }
        if (membershipFilter == PublicGroupChannelListQuery.MembershipFilter.ALL) {
            params.put("public_membership_mode", "all");
        } else if (membershipFilter == PublicGroupChannelListQuery.MembershipFilter.JOINED) {
            params.put("public_membership_mode", "joined");
        }
        this.requestGET(url, params, paramsWithListValue, handler);
    }

    void loadOpenChannelParticipantList(String channelUrl, String token, int limit, Map<String, List<String>> metaDataFilter, APIClientHandler handler) {
        String url = String.format(API_OPENCHANNELS_CHANNELURL_PARTICIPANTS, UrlUtil.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", token);
        params.put("limit", String.valueOf(limit));
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        this.addMetaDataFilterToParams(params, paramsWithListValue, metaDataFilter);
        this.requestGET(url, params, paramsWithListValue, handler);
    }

    void loadMutedUserList(boolean isOpenChannel, String channelUrl, String token, int limit, Map<String, List<String>> metaDataFilter, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_MUTE, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_MUTE, UrlUtil.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", token);
        params.put("limit", String.valueOf(limit));
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        this.addMetaDataFilterToParams(params, paramsWithListValue, metaDataFilter);
        this.requestGET(url, params, paramsWithListValue, handler);
    }

    void loadBannedUserList(boolean isOpenChannel, String channelUrl, String token, int limit, Map<String, List<String>> metaDataFilter, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_BAN, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_BAN, UrlUtil.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", token);
        params.put("limit", String.valueOf(limit));
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        this.addMetaDataFilterToParams(params, paramsWithListValue, metaDataFilter);
        this.requestGET(url, params, paramsWithListValue, handler);
    }

    void registerPushToken(String userId, String gcmRegToken, boolean unique, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_PUSH_GCM, UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        form.addProperty("gcm_reg_token", gcmRegToken);
        form.addProperty("is_unique", unique);
        this.requestPOST(url, form, handler);
    }

    void unregisterPushToken(String userId, String gcmRegToken, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_PUSH_GCM_TOKEN, UrlUtil.urlEncodeUTF8(userId), UrlUtil.urlEncodeUTF8(gcmRegToken));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    void unregisterPushTokenAll(String userId, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_PUSH, UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    void setPushTemplate(String userId, String template, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_PUSH_TEMPLATE, UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        form.addProperty("name", template);
        this.requestPUT(url, form, handler);
    }

    void getPushTemplate(String userId, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_PUSH_TEMPLATE, UrlUtil.urlEncodeUTF8(userId));
        this.requestGET(url, handler);
    }

    void setAutoAcceptInvitation(String userId, boolean autoAccept, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_CHANNELINVITATIONPREFERENCE, UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        form.addProperty("auto_accept", autoAccept);
        this.requestPUT(url, form, handler);
    }

    void getAutoAcceptInvitation(String userId, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_CHANNELINVITATIONPREFERENCE, UrlUtil.urlEncodeUTF8(userId));
        this.requestGET(url, handler);
    }

    void blockUser(String blockerUserId, String blockeeUserId, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_BLOCK, UrlUtil.urlEncodeUTF8(blockerUserId));
        JsonObject form = this.defaultForm();
        form.addProperty("target_id", blockeeUserId);
        this.requestPOST(url, form, handler);
    }

    void unblockUser(String blockerUserId, String blockeeUserId, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_BLOCK_TARGETID, UrlUtil.urlEncodeUTF8(blockerUserId), UrlUtil.urlEncodeUTF8(blockeeUserId));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    void addFriends(String userId, List<String> userIds, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_FRIENDS, UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        JsonArray userIdsObj = new JsonArray();
        for (String friendUserId : userIds) {
            userIdsObj.add(friendUserId);
        }
        form.add("user_ids", userIdsObj);
        this.requestPOST(url, form, handler);
    }

    void deleteFriends(String userId, List<String> userIds, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_FRIENDS, UrlUtil.urlEncodeUTF8(userId));
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        paramsWithListValue.put("user_ids", userIds);
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, null, paramsWithListValue, form, handler);
    }

    void deleteFriend(String userId, String friendUserId, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_FRIENDS_USERID, UrlUtil.urlEncodeUTF8(userId), UrlUtil.urlEncodeUTF8(friendUserId));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    void uploadFriendDiscoveries(String userId, Map<String, String> discoveries, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_FRIENDDISCOVERIES, UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        JsonArray discoveriesArray = new JsonArray();
        for (String key : discoveries.keySet()) {
            if (key == null || key.length() <= 0) continue;
            String value = discoveries.get(key);
            JsonObject discoveryObj = new JsonObject();
            discoveryObj.addProperty("friend_discovery_key", key);
            discoveryObj.addProperty("friend_name", value);
            discoveriesArray.add(discoveryObj);
        }
        form.add("friend_discoveries", discoveriesArray);
        this.requestPUT(url, form, handler);
    }

    void deleteFriendDiscoveries(String userId, List<String> discoveryKeys, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_FRIENDDISCOVERIES, UrlUtil.urlEncodeUTF8(userId));
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        paramsWithListValue.put("friend_discovery_keys", discoveryKeys);
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, null, paramsWithListValue, form, handler);
    }

    void deleteFriendDiscovery(String userId, String discoveryKey, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_FRIENDDISCOVERIES_DISCOVERYKEY, UrlUtil.urlEncodeUTF8(userId), UrlUtil.urlEncodeUTF8(discoveryKey));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    void getFriendChangeLogsByToken(String userId, String token, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_FRIENDS_CHANGELOGS, UrlUtil.urlEncodeUTF8(userId));
        HashMap<String, String> params = new HashMap<String, String>();
        if (token != null) {
            params.put("token", token);
        }
        this.requestGET(url, params, null, handler);
    }

    void loadFriendList(String userId, String token, int limit, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_FRIENDS, UrlUtil.urlEncodeUTF8(userId));
        HashMap<String, String> params = new HashMap<String, String>();
        if (token != null) {
            params.put("token", token);
        }
        params.put("limit", String.valueOf(limit));
        this.requestGET(url, params, null, handler);
    }

    void loadGroupChannelMemberList(String userId, String channelUrl, String token, int limit, GroupChannelMemberListQuery.OperatorFilter operatorFilter, GroupChannelMemberListQuery.MutedMemberFilter mutedMemberFilter, APIClientHandler handler) {
        String url = String.format(API_GROUPCHANNELS_CHANNELURL_MEMBERS, UrlUtil.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        if (token != null) {
            params.put("token", token);
        }
        params.put("limit", String.valueOf(limit));
        if (operatorFilter == GroupChannelMemberListQuery.OperatorFilter.ALL) {
            params.put("operator_filter", "all");
        } else if (operatorFilter == GroupChannelMemberListQuery.OperatorFilter.OPERATOR) {
            params.put("operator_filter", "operator");
        } else if (operatorFilter == GroupChannelMemberListQuery.OperatorFilter.NONOPERATOR) {
            params.put("operator_filter", "nonoperator");
        }
        if (mutedMemberFilter == GroupChannelMemberListQuery.MutedMemberFilter.ALL) {
            params.put("muted_member_filter", "all");
        } else if (mutedMemberFilter == GroupChannelMemberListQuery.MutedMemberFilter.MUTED) {
            params.put("muted_member_filter", "muted");
        } else if (mutedMemberFilter == GroupChannelMemberListQuery.MutedMemberFilter.UNMUTED) {
            params.put("muted_member_filter", "unmuted");
        }
        this.requestGET(url, params, null, handler);
    }

    void banUser(boolean isOpenChannel, String channelUrl, String userId, String description, int seconds, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_BAN, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_BAN, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", userId);
        if (description != null) {
            form.addProperty("description", description);
        }
        form.addProperty("seconds", String.valueOf(seconds));
        this.requestPOST(url, form, handler);
    }

    void unbanUser(boolean isOpenChannel, String channelUrl, String userId, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_BAN_USERID, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(userId)) : String.format(API_GROUPCHANNELS_CHANNELURL_BAN_USERID, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    void muteUser(boolean isOpenChannel, String channelUrl, String userId, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_MUTE, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_MUTE, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", userId);
        this.requestPOST(url, form, handler);
    }

    void unmuteUser(boolean isOpenChannel, String channelUrl, String userId, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_MUTE_USERID, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(userId)) : String.format(API_GROUPCHANNELS_CHANNELURL_MUTE_USERID, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    void freezeGroupChannel(String channelUrl, boolean freeze, APIClientHandler handler) {
        String url = String.format(API_GROUPCHANNELS_CHANNELURL_FREEZE, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("freeze", freeze);
        this.requestPUT(url, form, handler);
    }

    void getTotalUnreadMessageCount(String userId, List<String> channelCustomTypes, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_UNREADMESSAGECOUNT, UrlUtil.urlEncodeUTF8(userId));
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        if (channelCustomTypes != null && channelCustomTypes.size() > 0) {
            paramsWithListValue.put("custom_types", channelCustomTypes);
        }
        this.requestGET(url, null, paramsWithListValue, handler);
    }

    void getTotalUnreadChannelCount(String userId, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_UNREADCHANNELCOUNT, UrlUtil.urlEncodeUTF8(userId));
        this.requestGET(url, handler);
    }

    void getChannelCount(String userId, String state, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_GROUPCHANNELCOUNT, UrlUtil.urlEncodeUTF8(userId));
        HashMap<String, String> params = new HashMap<String, String>();
        if (state != null) {
            params.put("state", state);
        }
        this.requestGET(url, params, null, handler);
    }

    void setDoNotDisturb(String userId, boolean enable, int startHour, int startMin, int endHour, int endMin, String timezone, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_PUSHPREFERENCE, UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        form.addProperty("do_not_disturb", enable);
        form.addProperty("start_hour", startHour);
        form.addProperty("start_min", startMin);
        form.addProperty("end_hour", endHour);
        form.addProperty("end_min", endMin);
        form.addProperty("timezone", timezone);
        this.requestPUT(url, form, handler);
    }

    void getDoNotDisturb(String userId, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_PUSHPREFERENCE, UrlUtil.urlEncodeUTF8(userId));
        this.requestGET(url, handler);
    }

    void setPushSound(String userId, String sound, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_PUSHPREFERENCE, UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        form.addProperty("push_sound", sound);
        this.requestPUT(url, form, handler);
    }

    void getPushSound(String userId, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_PUSHPREFERENCE, UrlUtil.urlEncodeUTF8(userId));
        this.requestGET(url, handler);
    }

    void setPushPreference(String userId, String channelUrl, boolean value, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_PUSHPREFERENCE_CHANNELURL, UrlUtil.urlEncodeUTF8(userId), UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("enable", value);
        this.requestPUT(url, form, handler);
    }

    void getPushPreference(String userId, String channelUrl, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_PUSHPREFERENCE_CHANNELURL, UrlUtil.urlEncodeUTF8(userId), UrlUtil.urlEncodeUTF8(channelUrl));
        this.requestGET(url, handler);
    }

    void deleteMessage(boolean isOpenChannel, String channelUrl, long messageId, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID, UrlUtil.urlEncodeUTF8(channelUrl), Long.toString(messageId)) : String.format(API_GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID, UrlUtil.urlEncodeUTF8(channelUrl), Long.toString(messageId));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    void deleteChannel(String channelUrl, APIClientHandler handler) {
        String url = String.format(API_OPENCHANNELS_CHANNELURL, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    synchronized void setSessionKey(String sessionKey) {
        if (sessionKey == null) {
            return;
        }
        this.mSessionKey = sessionKey;
    }

    synchronized void setEKey(String encryptionKey) {
        if (encryptionKey == null) {
            return;
        }
        this.mEKey = encryptionKey;
    }

    synchronized String getSessionKey() {
        return this.mSessionKey;
    }

    synchronized String getEKey() {
        return this.mEKey;
    }

    public void makeDummyCallToKeepConnectionAlive(String url) {
        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").url(url).build();
        this.newCall(request, false, null);
    }

    private void requestGET(String url, APIClientHandler handler) {
        this.requestGET(url, null, null, handler);
    }

    private void requestGET(final String url, final Map<String, String> params, final Map<String, Collection<String>> paramsWithListValue, final APIClientHandler handler) {
        if (this.getSessionKey() == null || this.getSessionKey().length() == 0) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("Connection must be made.", 800101));
            }
            return;
        }
        this.checkRouting(new CheckRouting.CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block4: {
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    try {
                        String queryUrl = APIClient.this.getQueryUrl(apiHost, url, params, paramsWithListValue);
                        Logger.d("GET: " + queryUrl);
                        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Session-Key", APIClient.this.mSessionKey).url(queryUrl).build();
                        APIClient.this.newCall(request, false, handler);
                    }
                    catch (Exception e1) {
                        if (handler == null) break block4;
                        handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                    }
                }
            }
        });
    }

    private void requestPOST(final String url, final JsonElement form, final APIClientHandler handler) {
        if (this.getSessionKey() == null || this.getSessionKey().length() == 0) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("Connection must be made.", 800101));
            }
            return;
        }
        this.checkRouting(new CheckRouting.CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block4: {
                    Logger.d("POST: " + apiHost + url);
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    try {
                        String formJson = sGson.toJson(form);
                        Logger.d("API request: " + formJson);
                        RequestBody body = RequestBody.create(MIME_JSON, formJson);
                        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Session-Key", APIClient.this.mSessionKey).url(apiHost + url).post(body).build();
                        APIClient.this.newCall(request, false, handler);
                    }
                    catch (Exception e1) {
                        if (handler == null) break block4;
                        handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                    }
                }
            }
        });
    }

    private void requestPOST(final String url, final Map<String, String> form, final String fieldFilename, final File file, final APIClientHandler handler) {
        if (this.getSessionKey() == null || this.getSessionKey().length() == 0) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("Connection must be made.", 800101));
            }
            return;
        }
        this.checkRouting(new CheckRouting.CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block7: {
                    Logger.d("POST: " + apiHost + url);
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    ArrayList<Headers> partHeaders = new ArrayList<Headers>();
                    ArrayList<RequestBody> partBodies = new ArrayList<RequestBody>();
                    for (Map.Entry content : form.entrySet()) {
                        partHeaders.add(Headers.of("Content-Disposition", String.format("form-data; name=\"%s\"", content.getKey())));
                        partBodies.add(RequestBody.create(null, (String)content.getValue()));
                    }
                    if (fieldFilename != null && file != null) {
                        String fileMime = APIClient.checkMimeType(file, null, handler);
                        if (fileMime == null) {
                            return;
                        }
                        MediaType MIME_FILE = MediaType.parse(fileMime);
                        Logger.d("File: " + file);
                        Logger.d("Mime: " + fileMime);
                        partHeaders.add(Headers.of("Content-Disposition", String.format("form-data; name=\"%s\"; filename=\"%s\"", fieldFilename, file.getName()), "Content-Transfer-Encoding", "binary"));
                        partBodies.add(RequestBody.create(MIME_FILE, file));
                    }
                    try {
                        FixedLengthMultipartRequestBody body = new FixedLengthMultipartRequestBody(partHeaders, partBodies, null);
                        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Session-Key", APIClient.this.mSessionKey).url(apiHost + url).post(body).build();
                        APIClient.this.newCall(request, fieldFilename != null && file != null, handler);
                    }
                    catch (Exception e1) {
                        if (handler == null) break block7;
                        handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                    }
                }
            }
        });
    }

    private void requestFILE(final String url, final File file, final String mimeType, final List<FileMessage.ThumbnailSize> thumbnailSizes, final String channelUrl, final String requestId, final APIClientProgressHandler progressHandler, final APIClientHandler handler) {
        if (this.getSessionKey() == null || this.getSessionKey().length() == 0) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("Connection must be made.", 800101));
            }
            return;
        }
        this.checkRouting(new CheckRouting.CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block8: {
                    Logger.d("FILE: " + apiHost + url);
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    String fileMime = APIClient.checkMimeType(file, mimeType, handler);
                    if (fileMime == null) {
                        return;
                    }
                    MediaType MIME_FILE = MediaType.parse(fileMime);
                    MediaType textMime = MediaType.parse("text/plain");
                    Logger.d("File: " + file);
                    Logger.d("Mime: " + fileMime);
                    ArrayList<Headers> partHeaders = new ArrayList<Headers>();
                    ArrayList<RequestBody> partBodies = new ArrayList<RequestBody>();
                    partHeaders.add(Headers.of("Content-Disposition", "form-data; name=\"file\"; filename=\"" + file.getName() + "\"", "Content-Transfer-Encoding", "binary"));
                    partBodies.add(RequestBody.create(MIME_FILE, file));
                    if (thumbnailSizes != null) {
                        int idx = 1;
                        for (FileMessage.ThumbnailSize thumbnailSize : thumbnailSizes) {
                            partHeaders.add(Headers.of("Content-Disposition", "form-data; name=\"thumbnail" + idx + "\""));
                            partBodies.add(RequestBody.create(textMime, thumbnailSize.getMaxWidth() + "," + thumbnailSize.getMaxHeight()));
                            ++idx;
                        }
                    }
                    if (channelUrl != null) {
                        partHeaders.add(Headers.of("Content-Disposition", "form-data; name=\"channel_url\""));
                        partBodies.add(RequestBody.create(textMime, channelUrl));
                    }
                    try {
                        FixedLengthMultipartRequestBody body = new FixedLengthMultipartRequestBody(partHeaders, partBodies, progressHandler);
                        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Session-Key", APIClient.this.mSessionKey).url(apiHost + url).post(body).build();
                        APIClient.this.newCall(request, true, requestId, handler);
                    }
                    catch (Exception e1) {
                        if (handler == null) break block8;
                        handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                    }
                }
            }
        });
    }

    static String checkMimeType(File file, String mimeType, APIClientHandler handler) {
        String fileMime;
        try {
            fileMime = mimeType != null && mimeType.length() > 0 ? mimeType : file.toURI().toURL().openConnection().getContentType();
        }
        catch (IOException e) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException(e.getMessage(), 800220));
            }
            return null;
        }
        catch (StringIndexOutOfBoundsException e2) {
            fileMime = "application/octet-stream";
        }
        return fileMime;
    }

    private void requestPUT(final String url, final JsonElement form, final APIClientHandler handler) {
        if (this.getSessionKey() == null || this.getSessionKey().length() == 0) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("Connection must be made.", 800101));
            }
            return;
        }
        this.checkRouting(new CheckRouting.CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block4: {
                    Logger.d("PUT: " + apiHost + url);
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    try {
                        String formJson = sGson.toJson(form);
                        Logger.d("API request: " + formJson);
                        RequestBody body = RequestBody.create(MIME_JSON, formJson);
                        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Session-Key", APIClient.this.mSessionKey).url(apiHost + url).put(body).build();
                        APIClient.this.newCall(request, false, handler);
                    }
                    catch (Exception e1) {
                        if (handler == null) break block4;
                        handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                    }
                }
            }
        });
    }

    private void requestPUT(final String url, final Map<String, String> form, final String fieldFilename, final File file, final APIClientHandler handler) {
        if (this.getSessionKey() == null || this.getSessionKey().length() == 0) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("Connection must be made.", 800101));
            }
            return;
        }
        this.checkRouting(new CheckRouting.CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block7: {
                    Logger.d("PUT: " + apiHost + url);
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    ArrayList<Headers> partHeaders = new ArrayList<Headers>();
                    ArrayList<RequestBody> partBodies = new ArrayList<RequestBody>();
                    for (Map.Entry content : form.entrySet()) {
                        partHeaders.add(Headers.of("Content-Disposition", String.format("form-data; name=\"%s\"", content.getKey())));
                        partBodies.add(RequestBody.create(null, (String)content.getValue()));
                    }
                    if (fieldFilename != null && file != null) {
                        String fileMime = APIClient.checkMimeType(file, null, handler);
                        if (fileMime == null) {
                            return;
                        }
                        MediaType MIME_FILE = MediaType.parse(fileMime);
                        Logger.d("File: " + file);
                        Logger.d("Mime: " + fileMime);
                        partHeaders.add(Headers.of("Content-Disposition", String.format("form-data; name=\"%s\"; filename=\"%s\"", fieldFilename, file.getName()), "Content-Transfer-Encoding", "binary"));
                        partBodies.add(RequestBody.create(MIME_FILE, file));
                    }
                    try {
                        FixedLengthMultipartRequestBody body = new FixedLengthMultipartRequestBody(partHeaders, partBodies, null);
                        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Session-Key", APIClient.this.mSessionKey).url(apiHost + url).put(body).build();
                        APIClient.this.newCall(request, fieldFilename != null && file != null, handler);
                    }
                    catch (Exception e1) {
                        if (handler == null) break block7;
                        handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                    }
                }
            }
        });
    }

    private void requestDELETE(String url, JsonElement form, APIClientHandler handler) {
        this.requestDELETE(url, null, null, form, handler);
    }

    private void requestDELETE(final String url, final Map<String, String> params, final Map<String, Collection<String>> paramsWithListValue, final JsonElement form, final APIClientHandler handler) {
        if (this.getSessionKey() == null || this.getSessionKey().length() == 0) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("Connection must be made.", 800101));
            }
            return;
        }
        this.checkRouting(new CheckRouting.CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block4: {
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    try {
                        String queryUrl = APIClient.this.getQueryUrl(apiHost, url, params, paramsWithListValue);
                        Logger.d("DELETE: " + queryUrl);
                        String formJson = sGson.toJson(form);
                        Logger.d("API request: " + formJson);
                        RequestBody body = RequestBody.create(MIME_JSON, formJson);
                        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Session-Key", APIClient.this.mSessionKey).url(queryUrl).delete(body).build();
                        APIClient.this.newCall(request, false, handler);
                    }
                    catch (Exception e1) {
                        if (handler == null) break block4;
                        handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                    }
                }
            }
        });
    }

    private synchronized void newCall(Request request, boolean waitLong, final APIClientHandler handler) {
        OkHttpClient client = waitLong ? this.mOkHttpClientLong : this.mOkHttpClient;
        client.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                if (handler != null && !call.isCanceled()) {
                    handler.onResult(null, new SendBirdException(e.getMessage(), 800220));
                }
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                block5: {
                    try {
                        JsonElement result = APIClient.processResponse(response);
                        if (handler != null) {
                            handler.onResult(result, null);
                        }
                    }
                    catch (SendBirdException e) {
                        Logger.d(e);
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                    }
                    catch (Exception e) {
                        Logger.d(e);
                        if (handler == null) break block5;
                        handler.onResult(null, new SendBirdException(e.getMessage(), 800220));
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void newCall(Request request, boolean waitLong, final String requestId, final APIClientHandler handler) {
        OkHttpClient client = waitLong ? this.mOkHttpClientLong : this.mOkHttpClient;
        Call call = client.newCall(request);
        call.enqueue(new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Call call, IOException e) {
                Object object = APIClient.this.mOngoingRequestsLock;
                synchronized (object) {
                    if (APIClient.this.mOngoingRequestsMap.containsKey(requestId)) {
                        APIClient.this.mOngoingRequestsMap.remove(requestId);
                    }
                }
                if (handler != null) {
                    if (call.isCanceled()) {
                        handler.onResult(null, new SendBirdException("File Message upload canceled."));
                    } else {
                        handler.onResult(null, new SendBirdException(e.getMessage(), 800220));
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(Call call, Response response) throws IOException {
                block9: {
                    Object object = APIClient.this.mOngoingRequestsLock;
                    synchronized (object) {
                        if (APIClient.this.mOngoingRequestsMap.containsKey(requestId)) {
                            APIClient.this.mOngoingRequestsMap.remove(requestId);
                        }
                    }
                    try {
                        JsonElement result = APIClient.processResponse(response);
                        if (handler != null) {
                            handler.onResult(result, null);
                        }
                    }
                    catch (SendBirdException e) {
                        Logger.d(e);
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                    }
                    catch (Exception e) {
                        Logger.d(e);
                        if (handler == null) break block9;
                        handler.onResult(null, new SendBirdException(e.getMessage(), 800220));
                    }
                }
            }
        });
        if (requestId != null) {
            Object object = this.mOngoingRequestsLock;
            synchronized (object) {
                this.mOngoingRequestsMap.put(requestId, call);
            }
        }
    }

    protected static JsonElement processResponse(Response response) throws SendBirdException {
        JsonElement json;
        String body;
        try {
            body = response.body().string();
            Logger.d("API response: " + body);
        }
        catch (IOException e) {
            throw new SendBirdException(e.getMessage(), 800130);
        }
        if (body == null || body.length() <= 0) {
            return JsonNull.INSTANCE;
        }
        try {
            json = new JsonParser().parse(body);
        }
        catch (Exception e) {
            throw new SendBirdException(e.getMessage(), 800130);
        }
        if (!response.isSuccessful() && json.isJsonObject() && json.getAsJsonObject().has("error") && json.getAsJsonObject().get("error").isJsonPrimitive() && json.getAsJsonObject().get("error").getAsBoolean()) {
            String message = "";
            int code = 0;
            if (json.getAsJsonObject().has("message") && json.getAsJsonObject().get("message").isJsonPrimitive()) {
                message = json.getAsJsonObject().get("message").getAsString();
            }
            if (json.getAsJsonObject().has("code") && json.getAsJsonObject().get("code").isJsonPrimitive()) {
                code = json.getAsJsonObject().get("code").getAsInt();
            }
            throw new SendBirdException(message, code);
        }
        return json;
    }

    private String getQueryString(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        if (map != null && map.size() > 0) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(String.format("%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        return sb.toString();
    }

    private String getQueryUrl(String apiHost, String url, Map<String, String> params, Map<String, Collection<String>> paramsWithListValue) {
        String queryUrl;
        Object value;
        String key;
        HashMap<String, String> paramsAll = new HashMap<String, String>();
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                key = entry.getKey();
                value = (String)entry.getValue();
                paramsAll.put(UrlUtil.urlEncodeUTF8(key), UrlUtil.urlEncodeUTF8((String)value));
            }
        }
        if (paramsWithListValue != null && paramsWithListValue.size() > 0) {
            for (Map.Entry<String, Object> entry : paramsWithListValue.entrySet()) {
                key = entry.getKey();
                value = (Collection)entry.getValue();
                paramsAll.put(UrlUtil.urlEncodeUTF8(key), UrlUtil.urlEncodeUTF8((Collection<String>)value));
            }
        }
        if (paramsAll.size() > 0) {
            String query = this.getQueryString(paramsAll);
            queryUrl = apiHost + url + "?" + query;
        } else {
            queryUrl = apiHost + url;
        }
        return queryUrl;
    }

    protected void checkRouting(CheckRouting.CheckRoutingHandler handler) {
        CheckRouting.check(this.mOkHttpClient, handler);
    }

    protected void initCheckRouting() {
        CheckRouting.init();
    }

    protected static class CheckRouting {
        private static CheckRouting sInstance;
        private static Object sLock;
        private String mAPIHost;
        private String mWSHost;
        private long mRoutingUpdatedAt = 0L;

        protected CheckRouting() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void check(OkHttpClient okHttpClient, CheckRoutingHandler handler) {
            Object object = sLock;
            synchronized (object) {
                if (sInstance == null) {
                    sInstance = new CheckRouting();
                    sInstance.getHostsFromPref();
                }
            }
            sInstance.run(okHttpClient, handler);
        }

        static void init() {
            SendBird.getInstance().setAPIHostToPref(null);
            SendBird.getInstance().setWSHostToPref(null);
            if (sInstance != null) {
                sInstance.getHostsFromPref();
            }
        }

        private void getHostsFromPref() {
            this.mAPIHost = SendBird.getInstance().getAPIHostFromPref();
            this.mWSHost = SendBird.getInstance().getWSHostFromPref();
        }

        private void setHostsToPref() {
            SendBird.getInstance().setAPIHostToPref(this.mAPIHost);
            SendBird.getInstance().setWSHostToPref(this.mWSHost);
        }

        private boolean checkHosts() {
            return this.mAPIHost != null && this.mAPIHost.length() > 0 && this.mWSHost != null && this.mWSHost.length() > 0;
        }

        private void run(OkHttpClient okHttpClient, final CheckRoutingHandler handler) {
            block10: {
                if (SendBird.getApplicationId() == null || SendBird.getApplicationId().length() == 0) {
                    if (handler != null) {
                        handler.onResult(null, null, new SendBirdException("Application ID is not set. Initialize SendBird class.", 800100));
                    }
                    return;
                }
                if (SendBird.CUSTOM_WS_HOST != null && SendBird.CUSTOM_API_HOST != null) {
                    if (handler != null) {
                        handler.onResult(SendBird.CUSTOM_API_HOST, SendBird.CUSTOM_WS_HOST, null);
                    }
                    return;
                }
                if (System.currentTimeMillis() - this.mRoutingUpdatedAt <= 300000L && this.checkHosts()) {
                    if (handler != null) {
                        handler.onResult(this.mAPIHost, this.mWSHost, null);
                    }
                    return;
                }
                boolean callbackInvoked = false;
                if (this.checkHosts() && handler != null) {
                    handler.onResult(this.mAPIHost, this.mWSHost, null);
                    callbackInvoked = true;
                }
                try {
                    String routingUrl = APIClient.ROUTING_URL;
                    Logger.d("Router: " + routingUrl);
                    Request routeRequest = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").url(String.format(routingUrl, SendBird.getApplicationId())).tag(callbackInvoked).build();
                    okHttpClient.newCall(routeRequest).enqueue(new Callback(){

                        @Override
                        public void onFailure(Call call, IOException e) {
                            Logger.d("Routing failed: ");
                            Logger.d(e);
                            boolean callbackInvoked = (Boolean)call.request().tag();
                            if (!callbackInvoked && handler != null) {
                                if (CheckRouting.this.checkHosts()) {
                                    handler.onResult(CheckRouting.this.mAPIHost, CheckRouting.this.mWSHost, null);
                                } else {
                                    handler.onResult(null, null, new SendBirdException(e.getMessage(), 800121));
                                }
                            }
                        }

                        @Override
                        public void onResponse(Call call, Response response) throws IOException {
                            block8: {
                                boolean callbackInvoked = (Boolean)call.request().tag();
                                try {
                                    JsonElement result = APIClient.processResponse(response);
                                    CheckRouting.this.mAPIHost = result.getAsJsonObject().get("api_server").getAsString();
                                    CheckRouting.this.mWSHost = result.getAsJsonObject().get("ws_server").getAsString();
                                    CheckRouting.this.mRoutingUpdatedAt = System.currentTimeMillis();
                                    CheckRouting.this.setHostsToPref();
                                    Logger.d("Routing to: " + CheckRouting.this.mAPIHost + " : " + CheckRouting.this.mWSHost);
                                    if (!callbackInvoked && handler != null) {
                                        handler.onResult(CheckRouting.this.mAPIHost, CheckRouting.this.mWSHost, null);
                                    }
                                }
                                catch (SendBirdException e) {
                                    Logger.d(e);
                                    if (!callbackInvoked && handler != null) {
                                        if (CheckRouting.this.checkHosts()) {
                                            handler.onResult(CheckRouting.this.mAPIHost, CheckRouting.this.mWSHost, null);
                                        } else {
                                            handler.onResult(null, null, e);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    Logger.d(e);
                                    if (callbackInvoked || handler == null) break block8;
                                    if (CheckRouting.this.checkHosts()) {
                                        handler.onResult(CheckRouting.this.mAPIHost, CheckRouting.this.mWSHost, null);
                                    }
                                    handler.onResult(null, null, new SendBirdException(e.getMessage(), 800121));
                                }
                            }
                        }
                    });
                }
                catch (Exception e) {
                    if (callbackInvoked || handler == null) break block10;
                    if (this.checkHosts()) {
                        handler.onResult(this.mAPIHost, this.mWSHost, null);
                    }
                    handler.onResult(null, null, new SendBirdException(e.getMessage(), 800121));
                }
            }
        }

        static {
            sLock = new Object();
        }

        public static interface CheckRoutingHandler {
            public void onResult(String var1, String var2, SendBirdException var3);
        }
    }

    static final class FixedLengthMultipartRequestBody
    extends RequestBody {
        private static final MediaType FORM = MediaType.parse("multipart/form-data");
        private static final byte[] COLONSPACE = new byte[]{58, 32};
        private static final byte[] CRLF = new byte[]{13, 10};
        private static final byte[] DASHDASH = new byte[]{45, 45};
        private final ByteString boundary = ByteString.encodeUtf8(UUID.randomUUID().toString());
        private final MediaType contentType = MediaType.parse(FORM + "; boundary=" + this.boundary.utf8());
        private final List<Headers> partHeaders;
        private final List<RequestBody> partBodies;
        private long totalSent;
        private long totalToSend;
        private final APIClientProgressHandler progressHandler;

        FixedLengthMultipartRequestBody(List<Headers> partHeaders, List<RequestBody> partBodies, APIClientProgressHandler progressHandler) {
            this.partHeaders = Util.immutableList(partHeaders);
            this.partBodies = Util.immutableList(partBodies);
            this.totalSent = 0L;
            this.totalToSend = 0L;
            this.progressHandler = progressHandler;
        }

        @Override
        public MediaType contentType() {
            return this.contentType;
        }

        @Override
        public long contentLength() throws IOException {
            int length = 0;
            int partCount = this.partHeaders.size();
            for (int p = 0; p < partCount; ++p) {
                MediaType contentType;
                Headers headers = this.partHeaders.get(p);
                RequestBody body = this.partBodies.get(p);
                long contentLength = body.contentLength();
                if (contentLength == -1L) {
                    return -1L;
                }
                length += DASHDASH.length + this.boundary.size() + CRLF.length;
                if (headers != null) {
                    int headerCount = headers.size();
                    for (int h = 0; h < headerCount; ++h) {
                        length += headers.name(h).getBytes("UTF-8").length + COLONSPACE.length + headers.value(h).getBytes("UTF-8").length + CRLF.length;
                    }
                }
                if ((contentType = body.contentType()) != null) {
                    length += "Content-Type: ".getBytes("UTF-8").length + contentType.toString().getBytes("UTF-8").length + CRLF.length;
                }
                length += "Content-Length: ".getBytes("UTF-8").length + Long.toString(contentLength).getBytes("UTF-8").length + CRLF.length;
                length = (int)((long)length + ((long)CRLF.length + contentLength + (long)CRLF.length));
            }
            this.totalToSend = length += DASHDASH.length + this.boundary.size() + DASHDASH.length + CRLF.length;
            return length;
        }

        @Override
        public void writeTo(BufferedSink sink) throws IOException {
            ForwardingSink forwardingSink = new ForwardingSink(sink){

                @Override
                public void write(Buffer source, long byteCount) throws IOException {
                    super.write(source, byteCount);
                    FixedLengthMultipartRequestBody.this.totalSent = FixedLengthMultipartRequestBody.this.totalSent + byteCount;
                    if (FixedLengthMultipartRequestBody.this.progressHandler != null) {
                        FixedLengthMultipartRequestBody.this.progressHandler.onProgress(byteCount, FixedLengthMultipartRequestBody.this.totalSent, FixedLengthMultipartRequestBody.this.totalToSend);
                    }
                }
            };
            BufferedSink bufferedSink = Okio.buffer(forwardingSink);
            int partCount = this.partHeaders.size();
            for (int p = 0; p < partCount; ++p) {
                long contentLength;
                MediaType contentType;
                Headers headers = this.partHeaders.get(p);
                RequestBody body = this.partBodies.get(p);
                bufferedSink.write(DASHDASH);
                bufferedSink.write(this.boundary);
                bufferedSink.write(CRLF);
                if (headers != null) {
                    int headerCount = headers.size();
                    for (int h = 0; h < headerCount; ++h) {
                        bufferedSink.writeUtf8(headers.name(h)).write(COLONSPACE).writeUtf8(headers.value(h)).write(CRLF);
                    }
                }
                if ((contentType = body.contentType()) != null) {
                    bufferedSink.writeUtf8("Content-Type: ").writeUtf8(contentType.toString()).write(CRLF);
                }
                if ((contentLength = body.contentLength()) != -1L) {
                    bufferedSink.writeUtf8("Content-Length: ").writeUtf8(Long.toString(contentLength)).write(CRLF);
                }
                bufferedSink.write(CRLF);
                body.writeTo(bufferedSink);
                bufferedSink.write(CRLF);
            }
            bufferedSink.write(DASHDASH);
            bufferedSink.write(this.boundary);
            bufferedSink.write(DASHDASH);
            bufferedSink.write(CRLF);
            bufferedSink.flush();
        }
    }

    static class UrlUtil {
        UrlUtil() {
        }

        static String urlEncodeUTF8(String s) {
            String result = null;
            if (s != null) {
                try {
                    result = URLEncoder.encode(s, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new UnsupportedOperationException(e);
                }
            }
            return result;
        }

        static String urlEncodeUTF8(Collection<String> strList) {
            String result = null;
            if (strList != null && strList.size() > 0) {
                StringBuilder sb = new StringBuilder();
                String separator = "";
                for (String str : strList) {
                    sb.append(separator);
                    separator = ",";
                    sb.append(UrlUtil.urlEncodeUTF8(str));
                }
                result = sb.toString();
            }
            return result;
        }
    }

    public static interface APIClientProgressHandler {
        public void onProgress(long var1, long var3, long var5);
    }

    public static interface APIClientHandler {
        public void onResult(JsonElement var1, SendBirdException var2);
    }
}

