/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;

public class Member
extends User {
    private InvitationState mState;
    private boolean mIsBlockingMe;
    private boolean mIsBlockedByMe;

    protected Member(JsonElement el) {
        super(el);
        if (el.isJsonNull()) {
            return;
        }
        JsonObject obj = el.getAsJsonObject();
        this.mState = obj.has("state") && obj.get("state").getAsString().equals("invited") ? InvitationState.INVITED : InvitationState.JOINED;
        this.mIsBlockingMe = obj.has("is_blocking_me") && obj.get("is_blocking_me").getAsBoolean();
        this.mIsBlockedByMe = obj.has("is_blocked_by_me") && obj.get("is_blocked_by_me").getAsBoolean();
    }

    @Override
    JsonElement toJson() {
        JsonObject obj = super.toJson().getAsJsonObject();
        if (this.mState == InvitationState.INVITED) {
            obj.addProperty("state", "invited");
        } else {
            obj.addProperty("state", "joined");
        }
        obj.addProperty("is_blocking_me", this.mIsBlockingMe);
        obj.addProperty("is_blocked_by_me", this.mIsBlockedByMe);
        return obj;
    }

    void setIsBlockingMe(boolean tf) {
        this.mIsBlockingMe = tf;
    }

    void setIsBlockedByMe(boolean tf) {
        this.mIsBlockedByMe = tf;
    }

    public InvitationState getState() {
        return this.mState;
    }

    void setState(InvitationState state) {
        this.mState = state;
    }

    public boolean isBlockingMe() {
        return this.mIsBlockingMe;
    }

    public boolean isBlockedByMe() {
        return this.mIsBlockedByMe;
    }

    public static enum InvitationState {
        INVITED,
        JOINED;

    }
}

