/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;

public final class UserMessage
extends BaseMessage {
    private String mMessage = "";
    private String mData = "";
    private User mSender;
    private String mReqId = "";
    private String mCustomType = "";

    static JsonElement build(String requestId, long msgId, User user, BaseChannel channel, String message, String data, String customType, long createdAt) {
        JsonObject obj = new JsonObject();
        obj.addProperty("req_id", requestId);
        obj.addProperty("msg_id", msgId);
        obj.addProperty("channel_url", channel.getUrl());
        obj.addProperty("channel_type", channel instanceof OpenChannel ? "open" : "group");
        obj.addProperty("ts", createdAt);
        obj.addProperty("message", message);
        if (data != null) {
            obj.addProperty("data", data);
        }
        if (customType != null) {
            obj.addProperty("custom_type", customType);
        }
        JsonObject userObj = new JsonObject();
        userObj.addProperty("user_id", user.getUserId());
        userObj.addProperty("nickname", user.getNickname());
        userObj.addProperty("profile_url", user.getProfileUrl());
        obj.add("user", userObj);
        return obj;
    }

    UserMessage(JsonElement el) {
        super(el);
        JsonObject obj = el.getAsJsonObject();
        this.mMessage = obj.get("message").getAsString();
        this.mData = obj.has("data") ? obj.get("data").getAsString() : "";
        this.mSender = new User(obj.get("user"));
        this.mReqId = obj.has("req_id") ? obj.get("req_id").getAsString() : "";
        this.mCustomType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : "";
    }

    public String getMessage() {
        return this.mMessage;
    }

    public String getData() {
        return this.mData;
    }

    public User getSender() {
        return this.mSender;
    }

    public String getRequestId() {
        return this.mReqId;
    }

    public String getCustomType() {
        return this.mCustomType;
    }
}

