/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.SendBirdException;
import com.sendbird.android.shadow.com.google.gson.Gson;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import com.sendbird.android.shadow.com.google.gson.JsonPrimitive;
import java.util.List;

class Command {
    private static long requestIdSeed = System.currentTimeMillis();
    private static final Gson sGson = new Gson();
    private String command;
    private String payload;
    private String requestId;

    protected static synchronized String generateRequestId() {
        return String.valueOf(++requestIdSeed);
    }

    public Command(String data) {
        JsonElement el;
        if (data == null || data.length() <= 4) {
            this.command = "NOOP";
            this.payload = "{}";
            return;
        }
        data = data.trim();
        this.command = data.substring(0, 4);
        this.payload = data.substring(4);
        if (this.isRequestIdCommand() && (el = this.getJsonElement()) != null && el.isJsonObject()) {
            JsonObject obj = el.getAsJsonObject();
            this.requestId = obj.has("req_id") ? obj.get("req_id").getAsString() : "";
        }
    }

    public Command(String command, JsonElement payload) {
        this(command, payload, null);
    }

    public Command(String command, JsonElement payload, String reqId) {
        this.command = command;
        this.requestId = reqId;
        if (this.requestId == null && this.isRequestIdCommand()) {
            this.requestId = Command.generateRequestId();
        }
        payload.getAsJsonObject().addProperty("req_id", this.requestId);
        this.payload = sGson.toJson(payload);
    }

    protected boolean isAckRequired() {
        return this.command.equals("MESG") || this.command.equals("FILE") || this.command.equals("ENTR") || this.command.equals("EXIT");
    }

    protected boolean isRequestIdCommand() {
        return this.isAckRequired() || this.command.equals("EROR");
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String encode() {
        return this.command + this.payload + "\n";
    }

    private void decode(String command) {
        command = command.trim();
        this.command = command.substring(0, 4);
        this.payload = command.substring(4);
    }

    public String getCommand() {
        return this.command;
    }

    public String getPayload() {
        return this.payload;
    }

    public JsonElement getJsonElement() {
        return new JsonParser().parse(this.getPayload());
    }

    public static Command bMessage(String channelUrl, String message, String data, String customType, List<String> mentionedUserIds) {
        JsonObject obj = new JsonObject();
        obj.addProperty("channel_url", channelUrl);
        obj.addProperty("message", message);
        obj.addProperty("data", data);
        obj.addProperty("custom_type", customType);
        JsonArray array = new JsonArray();
        if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
            for (String userId : mentionedUserIds) {
                array.add(new JsonPrimitive(userId));
            }
        }
        obj.add("mentioned", array);
        return new Command("MESG", obj);
    }

    public static Command bTypeStart(String channelUrl, long time) {
        JsonObject obj = new JsonObject();
        obj.addProperty("channel_url", channelUrl);
        obj.addProperty("time", time);
        return new Command("TPST", obj);
    }

    public static Command bTypeEnd(String channelUrl, long time) {
        JsonObject obj = new JsonObject();
        obj.addProperty("channel_url", channelUrl);
        obj.addProperty("time", time);
        return new Command("TPEN", obj);
    }

    public static Command bFile(String requestId, String channelUrl, String url, String name, String type, int size, String data, String customType) {
        JsonObject obj = new JsonObject();
        obj.addProperty("channel_url", channelUrl);
        obj.addProperty("url", url);
        obj.addProperty("name", name);
        obj.addProperty("type", type);
        obj.addProperty("size", size);
        obj.addProperty("custom", data);
        obj.addProperty("custom_type", customType);
        return new Command("FILE", obj, requestId);
    }

    public static Command bPing() {
        JsonObject obj = new JsonObject();
        obj.addProperty("id", System.currentTimeMillis());
        return new Command("PING", obj);
    }

    public static Command bEnter(String channelUrl) {
        JsonObject obj = new JsonObject();
        obj.addProperty("channel_url", channelUrl);
        return new Command("ENTR", obj);
    }

    public static Command bExit(String channelUrl) {
        JsonObject obj = new JsonObject();
        obj.addProperty("channel_url", channelUrl);
        return new Command("EXIT", obj);
    }

    protected boolean hasRequestId() {
        return this.requestId != null && this.requestId.length() > 0;
    }

    public static interface SendCommandHandler {
        public void onResult(Command var1, SendBirdException var2);
    }
}

