/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.Command;
import com.sendbird.android.FileMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.MessageListQuery;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.PreviousMessageListQuery;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.UserMessage;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseChannel {
    protected static final String CHANNEL_TYPE_OPEN = "open";
    protected static final String CHANNEL_TYPE_GROUP = "group";
    protected String mUrl;
    protected String mName;
    protected String mCoverUrl;
    protected long mCreatedAt;
    protected String mData;

    protected BaseChannel(JsonElement el) {
        this.update(el);
    }

    protected void update(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        this.mUrl = obj.get("channel_url").getAsString();
        this.mName = obj.get("name").getAsString();
        this.mCreatedAt = obj.has("created_at") ? obj.get("created_at").getAsLong() * 1000L : 0L;
        this.mCoverUrl = obj.has("cover_url") ? obj.get("cover_url").getAsString() : "";
        this.mData = obj.has("data") ? obj.get("data").getAsString() : "";
    }

    public String getData() {
        return this.mData;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public long getCreatedAt() {
        return this.mCreatedAt;
    }

    public String getName() {
        return this.mName;
    }

    public String getCoverUrl() {
        return this.mCoverUrl;
    }

    public boolean isOpenChannel() {
        return this instanceof OpenChannel;
    }

    public boolean isGroupChannel() {
        return this instanceof GroupChannel;
    }

    public PreviousMessageListQuery createPreviousMessageListQuery() {
        return new PreviousMessageListQuery(this);
    }

    public MessageListQuery createMessageListQuery() {
        return new MessageListQuery(this);
    }

    public FileMessage sendFileMessage(String fileUrl, String name, String type, int size, String data, SendFileMessageHandler handler) {
        return this.sendFileMessage(fileUrl, name, type, size, data, null, handler);
    }

    public FileMessage sendFileMessage(String fileUrl, String name, String type, int size, String data, String customType, final SendFileMessageHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Connection must be made before you send message.", 800101));
                    }
                });
            }
            return null;
        }
        if (fileUrl == null || fileUrl.length() == 0 || name == null || name.length() == 0 || type == null || type.length() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        String reqId = Command.generateRequestId();
        Command cmd = Command.bFile(reqId, this.getUrl(), fileUrl, name, type, size, data, customType);
        SendBird.getInstance().sendCommand(cmd, new Command.SendCommandHandler(){

            @Override
            public void onResult(final Command acked, final SendBirdException e) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (e != null) {
                            if (handler != null) {
                                handler.onSent(null, e);
                            }
                            return;
                        }
                        FileMessage fileMessage = new FileMessage(acked.getJsonElement());
                        if (handler != null) {
                            handler.onSent(fileMessage, null);
                        }
                    }
                });
            }
        });
        return new FileMessage(FileMessage.build(reqId, 0L, SendBird.getCurrentUser(), this, fileUrl, name, type, size, data, customType, System.currentTimeMillis()));
    }

    public FileMessage sendFileMessage(File file, String name, String type, int size, String data, SendFileMessageHandler handler) {
        return this.sendFileMessage(file, name, type, size, data, null, handler);
    }

    public FileMessage sendFileMessage(File file, final String name, final String type, final int size, final String data, final String customType, final SendFileMessageHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Connection must be made before you send message.", 800101));
                    }
                });
            }
            return null;
        }
        if (file == null || name == null || name.length() == 0 || type == null || type.length() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        final String reqId = Command.generateRequestId();
        APIClient.getInstance().uploadFile(file, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onSent(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                String fileUrl = result.get("url").getAsString();
                Command cmd = Command.bFile(reqId, BaseChannel.this.getUrl(), fileUrl, name, type, size, data, customType);
                SendBird.getInstance().sendCommand(cmd, new Command.SendCommandHandler(){

                    @Override
                    public void onResult(final Command acked, final SendBirdException e) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                if (e != null) {
                                    if (handler != null) {
                                        handler.onSent(null, e);
                                    }
                                    return;
                                }
                                FileMessage fileMessage = new FileMessage(acked.getJsonElement());
                                if (handler != null) {
                                    handler.onSent(fileMessage, null);
                                }
                            }
                        });
                    }
                });
            }
        });
        return new FileMessage(FileMessage.build(reqId, 0L, SendBird.getCurrentUser(), this, "", file.getName(), type, size, data, customType, System.currentTimeMillis()));
    }

    public UserMessage sendUserMessage(String message, SendUserMessageHandler handler) {
        return this.sendUserMessage(message, null, handler);
    }

    public UserMessage sendUserMessage(String message, String data, SendUserMessageHandler handler) {
        return this.sendUserMessage(message, data, null, handler);
    }

    public UserMessage sendUserMessage(String message, String data, String customType, final SendUserMessageHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Connection must be made before you send message.", 800101));
                    }
                });
            }
            return null;
        }
        if (message == null) {
            message = "";
        }
        Command cmd = Command.bMessage(this.getUrl(), message, data, customType, new ArrayList<String>());
        UserMessage msg = new UserMessage(UserMessage.build(cmd.getRequestId(), 0L, SendBird.getCurrentUser(), this, message, data, customType, System.currentTimeMillis()));
        SendBird.getInstance().sendCommand(cmd, new Command.SendCommandHandler(){

            @Override
            public void onResult(final Command acked, final SendBirdException e) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (e != null) {
                            if (handler != null) {
                                handler.onSent(null, e);
                            }
                            return;
                        }
                        UserMessage userMessage = new UserMessage(acked.getJsonElement());
                        if (handler != null) {
                            handler.onSent(userMessage, null);
                        }
                    }
                });
            }
        });
        return msg;
    }

    public void createMetaCounters(Map<String, Integer> metaCounterMap, final MetaCounterHandler handler) {
        if (metaCounterMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().createMetaCounters(this instanceof OpenChannel, this.getUrl(), metaCounterMap, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void updateMetaCounters(Map<String, Integer> metaCounterMap, final MetaCounterHandler handler) {
        if (metaCounterMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().updateMetaCounters(this instanceof OpenChannel, this.getUrl(), metaCounterMap, true, 0, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void increaseMetaCounters(Map<String, Integer> metaCounterMap, final MetaCounterHandler handler) {
        if (metaCounterMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().updateMetaCounters(this instanceof OpenChannel, this.getUrl(), metaCounterMap, false, 1, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void decreaseMetaCounters(Map<String, Integer> metaCounterMap, final MetaCounterHandler handler) {
        if (metaCounterMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().updateMetaCounters(this instanceof OpenChannel, this.getUrl(), metaCounterMap, false, 2, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void getMetaCounters(Collection<String> keys, final MetaCounterHandler handler) {
        if (keys == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().getMetaCounters(this instanceof OpenChannel, this.getUrl(), keys, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void getAllMetaCounters(final MetaCounterHandler handler) {
        APIClient.getInstance().getAllMetaCounters(this instanceof OpenChannel, this.getUrl(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void deleteMetaCounter(String key, final DeleteMetaCounterHandler handler) {
        if (key == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteMetaCounter(this instanceof OpenChannel, this.getUrl(), key, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void deleteAllMetaCounters(final DeleteMetaCounterHandler handler) {
        APIClient.getInstance().deleteAllMetaCounters(this instanceof OpenChannel, this.getUrl(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void createMetaData(Map<String, String> metaDataMap, final MetaDataHandler handler) {
        if (metaDataMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().createMetaData(this instanceof OpenChannel, this.getUrl(), metaDataMap, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, String> result = new HashMap<String, String>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void updateMetaData(Map<String, String> metaDataMap, final MetaDataHandler handler) {
        if (metaDataMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().updateMetaData(this instanceof OpenChannel, this.getUrl(), metaDataMap, true, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, String> result = new HashMap<String, String>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void getMetaData(Collection<String> keys, final MetaDataHandler handler) {
        if (keys == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().getMetaData(this instanceof OpenChannel, this.getUrl(), keys, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, String> result = new HashMap<String, String>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void getAllMetaData(final MetaDataHandler handler) {
        APIClient.getInstance().getAllMetaData(this instanceof OpenChannel, this.getUrl(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, String> result = new HashMap<String, String>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void deleteMetaData(String key, final DeleteMetaDataHandler handler) {
        if (key == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteMetaData(this instanceof OpenChannel, this.getUrl(), key, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                HashMap<String, String> result = new HashMap<String, String>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void deleteAllMetaData(final DeleteMetaDataHandler handler) {
        APIClient.getInstance().deleteAllMetaData(this instanceof OpenChannel, this.getUrl(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null && handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(e);
                        }
                    });
                }
                HashMap<String, String> result = new HashMap<String, String>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void deleteMessage(BaseMessage message, final DeleteMessageHandler handler) {
        if (message == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteMessage(this instanceof OpenChannel, this.getUrl(), message.getMessageId(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static interface DeleteMessageHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface SendFileMessageHandler {
        public void onSent(FileMessage var1, SendBirdException var2);
    }

    public static interface SendUserMessageHandler {
        public void onSent(UserMessage var1, SendBirdException var2);
    }

    public static interface DeleteMetaDataHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface MetaDataHandler {
        public void onResult(Map<String, String> var1, SendBirdException var2);
    }

    public static interface DeleteMetaCounterHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface MetaCounterHandler {
        public void onResult(Map<String, Integer> var1, SendBirdException var2);
    }

    public static enum ChannelType {
        OPEN,
        GROUP;

    }
}

