/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.util.Base64;
import com.sendbird.android.APIClient;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.Command;
import com.sendbird.android.FileMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.MessageListQuery;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.PreviousMessageListQuery;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.UserMessage;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseChannel {
    protected static final String CHANNEL_TYPE_OPEN = "open";
    protected static final String CHANNEL_TYPE_GROUP = "group";
    protected String mUrl;
    protected String mName;
    protected String mCoverUrl;
    protected long mCreatedAt;
    protected String mData;
    private boolean mDirty = false;

    protected BaseChannel(JsonElement el) {
        this.update(el);
    }

    protected void update(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        this.mUrl = obj.has("channel_url") && !obj.get("channel_url").isJsonNull() ? obj.get("channel_url").getAsString() : "";
        this.mName = obj.has("name") && !obj.get("name").isJsonNull() ? obj.get("name").getAsString() : "";
        this.mCreatedAt = obj.has("created_at") && !obj.get("created_at").isJsonNull() ? obj.get("created_at").getAsLong() * 1000L : 0L;
        this.mCoverUrl = obj.has("cover_url") && !obj.get("cover_url").isJsonNull() ? obj.get("cover_url").getAsString() : "";
        this.mData = obj.has("data") && !obj.get("data").isJsonNull() ? obj.get("data").getAsString() : "";
    }

    JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("channel_url", this.mUrl);
        obj.addProperty("name", this.mName);
        obj.addProperty("cover_url", this.mCoverUrl);
        obj.addProperty("data", this.mData);
        obj.addProperty("created_at", this.mCreatedAt);
        return obj;
    }

    protected void setDirty(boolean dirty) {
        this.mDirty = dirty;
    }

    protected boolean isDirty() {
        return this.mDirty;
    }

    public static BaseChannel buildFromSerializedData(byte[] data) {
        BaseChannel channel = null;
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            try {
                String str = new String(Base64.decode((byte[])data, (int)0), "UTF-8");
                JsonObject obj = new JsonParser().parse(str).getAsJsonObject();
                if (obj.get("channel_type").getAsString().equals(CHANNEL_TYPE_OPEN)) {
                    channel = OpenChannel.upsert(obj, true);
                } else if (obj.get("channel_type").getAsString().equals(CHANNEL_TYPE_GROUP)) {
                    channel = GroupChannel.upsert(obj, true);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return channel;
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    String getType() {
        if (this.isOpenChannel()) {
            return CHANNEL_TYPE_OPEN;
        }
        return CHANNEL_TYPE_GROUP;
    }

    public String getData() {
        return this.mData;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public long getCreatedAt() {
        return this.mCreatedAt;
    }

    public String getName() {
        return this.mName;
    }

    public String getCoverUrl() {
        return this.mCoverUrl;
    }

    public boolean isOpenChannel() {
        return this instanceof OpenChannel;
    }

    public boolean isGroupChannel() {
        return this instanceof GroupChannel;
    }

    public PreviousMessageListQuery createPreviousMessageListQuery() {
        return new PreviousMessageListQuery(this);
    }

    @Deprecated
    public MessageListQuery createMessageListQuery() {
        return new MessageListQuery(this);
    }

    private void getMessagesByTimestamp(long ts, boolean isInclusive, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, final GetMessagesHandler handler) {
        String msgType;
        switch (messageType) {
            case USER: {
                msgType = "MESG";
                break;
            }
            case FILE: {
                msgType = "FILE";
                break;
            }
            case ADMIN: {
                msgType = "ADMM";
                break;
            }
            default: {
                msgType = null;
            }
        }
        APIClient.getInstance().messageList(this instanceof OpenChannel, this.getUrl(), ts, prevResultSize, nextResultSize, isInclusive, reverse, msgType, customType, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                JsonArray objs = result.get("messages").getAsJsonArray();
                final ArrayList<BaseMessage> messages = new ArrayList<BaseMessage>();
                for (int i = 0; i < objs.size(); ++i) {
                    BaseMessage msg = BaseMessage.build(objs.get(i), BaseChannel.this.getUrl(), BaseChannel.this.getType());
                    if (msg == null) continue;
                    messages.add(msg);
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(messages, null);
                        }
                    });
                }
            }
        });
    }

    private void getMessagesById(long msgId, boolean isInclusive, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, final GetMessagesHandler handler) {
        String msgType;
        switch (messageType) {
            case USER: {
                msgType = "MESG";
                break;
            }
            case FILE: {
                msgType = "FILE";
                break;
            }
            case ADMIN: {
                msgType = "ADMM";
                break;
            }
            default: {
                msgType = null;
            }
        }
        APIClient.getInstance().messageListById(this instanceof OpenChannel, this.getUrl(), msgId, prevResultSize, nextResultSize, isInclusive, reverse, msgType, customType, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                JsonArray objs = result.get("messages").getAsJsonArray();
                final ArrayList<BaseMessage> messages = new ArrayList<BaseMessage>();
                for (int i = 0; i < objs.size(); ++i) {
                    BaseMessage msg = BaseMessage.build(objs.get(i), BaseChannel.this.getUrl(), BaseChannel.this.getType());
                    if (msg == null) continue;
                    messages.add(msg);
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(messages, null);
                        }
                    });
                }
            }
        });
    }

    private void getMessageChangeLogs(String token, final GetMessageChangeLogsByTokenHandler handler) {
        APIClient.getInstance().messageChangeLogsByToken(this instanceof OpenChannel, this.getUrl(), token, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, null, false, null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                JsonArray updatedJsonArray = result.get("updated").getAsJsonArray();
                final ArrayList<BaseMessage> updatedMessages = new ArrayList<BaseMessage>();
                for (int i = 0; i < updatedJsonArray.size(); ++i) {
                    BaseMessage msg = BaseMessage.build(updatedJsonArray.get(i), BaseChannel.this.getUrl(), BaseChannel.this.getType());
                    if (msg == null) continue;
                    updatedMessages.add(msg);
                }
                JsonArray deletedJsonArray = result.get("deleted").getAsJsonArray();
                final ArrayList<Long> deletedMessageIds = new ArrayList<Long>();
                for (int i = 0; i < deletedJsonArray.size(); ++i) {
                    deletedMessageIds.add(deletedJsonArray.get(i).getAsJsonObject().get("message_id").getAsLong());
                }
                final boolean hasMore = result.get("has_more").getAsBoolean();
                final String token = result.get("next").getAsString();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(updatedMessages, deletedMessageIds, hasMore, token, null);
                        }
                    });
                }
            }
        });
    }

    public void getNextMessagesByTimestamp(long ts, boolean isInclusive, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, isInclusive, 0, nextResultSize, reverse, messageType, customType, handler);
    }

    public void getPreviousMessagesByTimestamp(long ts, boolean isInclusive, int prevResultSize, boolean reverse, MessageTypeFilter messageType, String customType, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, isInclusive, prevResultSize, 0, reverse, messageType, customType, handler);
    }

    public void getPreviousAndNextMessagesByTimestamp(long ts, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, true, prevResultSize, nextResultSize, reverse, messageType, customType, handler);
    }

    public void getNextMessagesById(long msgId, boolean isInclusive, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, GetMessagesHandler handler) {
        this.getMessagesById(msgId, isInclusive, 0, nextResultSize, reverse, messageType, customType, handler);
    }

    public void getPreviousMessagesById(long msgId, boolean isInclusive, int prevResultSize, boolean reverse, MessageTypeFilter messageType, String customType, GetMessagesHandler handler) {
        this.getMessagesById(msgId, isInclusive, prevResultSize, 0, reverse, messageType, customType, handler);
    }

    public void getPreviousAndNextMessagesById(long msgId, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, GetMessagesHandler handler) {
        this.getMessagesById(msgId, true, prevResultSize, nextResultSize, reverse, messageType, customType, handler);
    }

    public void getMessageChangeLogsByToken(String token, GetMessageChangeLogsByTokenHandler handler) {
        this.getMessageChangeLogs(token, handler);
    }

    public FileMessage sendFileMessage(String fileUrl, String name, String type, int size, String data, SendFileMessageHandler handler) {
        return this.sendFileMessage(fileUrl, name, type, size, data, null, handler);
    }

    public FileMessage sendFileMessage(String fileUrl, String name, String type, int size, String data, String customType, final SendFileMessageHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Connection must be made before you send message.", 800101));
                    }
                });
            }
            return null;
        }
        if (fileUrl == null || fileUrl.length() == 0 || name == null || name.length() == 0 || type == null || type.length() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        final String reqId = Command.generateRequestId();
        final FileMessage fileMessage = new FileMessage(FileMessage.build(reqId, 0L, SendBird.getCurrentUser(), this.getUrl(), this.getType(), fileUrl, name, type, size, data, customType, null, false, System.currentTimeMillis(), 0L));
        if (SendBird.getConnectionState() == SendBird.ConnectionState.OPEN) {
            Command cmd = Command.bFile(reqId, this.getUrl(), fileUrl, name, type, size, data, customType, null, false);
            SendBird.getInstance().sendCommand(cmd, new Command.SendCommandHandler(){

                @Override
                public void onResult(final Command acked, final SendBirdException e) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (e != null) {
                                if (handler != null) {
                                    handler.onSent(fileMessage, e);
                                }
                                return;
                            }
                            FileMessage fileMessage = new FileMessage(acked.getJsonElement());
                            if (handler != null) {
                                handler.onSent(fileMessage, null);
                            }
                        }
                    });
                }
            });
        } else {
            APIClient.getInstance().sendFileMessage(this instanceof OpenChannel, this.getUrl(), SendBird.getCurrentUser().getUserId(), fileUrl, name, size, type, customType, data, null, false, new APIClient.APIClientHandler(){

                @Override
                public void onResult(final JsonElement response, final SendBirdException e) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (e != null) {
                                if (handler != null) {
                                    handler.onSent(fileMessage, e);
                                }
                                return;
                            }
                            JsonObject responseObj = response.getAsJsonObject();
                            responseObj.addProperty("req_id", reqId);
                            FileMessage fileMessage = (FileMessage)BaseMessage.build(responseObj, BaseChannel.this.getUrl(), BaseChannel.this.getType());
                            if (handler != null) {
                                handler.onSent(fileMessage, null);
                            }
                        }
                    });
                }
            });
        }
        return fileMessage;
    }

    public FileMessage sendFileMessage(File file, String name, String type, int size, String data, SendFileMessageHandler handler) {
        return this.sendFileMessage(file, name, type, size, data, null, null, handler);
    }

    public FileMessage sendFileMessage(File file, String name, String type, int size, String data, String customType, SendFileMessageHandler handler) {
        return this.sendFileMessage(file, name, type, size, data, customType, null, handler);
    }

    public FileMessage sendFileMessage(File file, final String name, final String type, final int size, final String data, final String customType, List<FileMessage.ThumbnailSize> thumbnailSizes, final SendFileMessageHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Connection must be made before you send message.", 800101));
                    }
                });
            }
            return null;
        }
        if (file == null || name == null || name.length() == 0 || type == null || type.length() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        final String reqId = Command.generateRequestId();
        JsonObject obj = new JsonObject();
        JsonArray thumbnails = new JsonArray();
        if (thumbnailSizes != null) {
            for (FileMessage.ThumbnailSize thumbnailSize : thumbnailSizes) {
                JsonObject thumbnail = new JsonObject();
                thumbnail.addProperty("width", thumbnailSize.getMaxWidth());
                thumbnail.addProperty("height", thumbnailSize.getMaxHeight());
                thumbnail.addProperty("url", "");
                thumbnails.add(thumbnail);
            }
        }
        obj.add("thumbnails", thumbnails);
        final FileMessage fileMessage = new FileMessage(FileMessage.build(reqId, 0L, SendBird.getCurrentUser(), this.getUrl(), this.getType(), "", file.getName(), type, size, data, customType, obj.get("thumbnails").toString(), false, System.currentTimeMillis(), 0L));
        APIClient.getInstance().uploadFile(file, type, thumbnailSizes, this.getUrl(), reqId, null, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                boolean requireAuth;
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onSent(fileMessage, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                String fileUrl = result.get("url").getAsString();
                String thumbnails = result.has("thumbnails") ? result.get("thumbnails").toString() : null;
                boolean bl = requireAuth = result.has("require_auth") && result.get("require_auth").getAsBoolean();
                if (SendBird.getConnectionState() == SendBird.ConnectionState.OPEN) {
                    Command cmd = Command.bFile(reqId, BaseChannel.this.getUrl(), fileUrl, name, type, size, data, customType, thumbnails, requireAuth);
                    SendBird.getInstance().sendCommand(cmd, new Command.SendCommandHandler(){

                        @Override
                        public void onResult(final Command acked, final SendBirdException e) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (e != null) {
                                        if (handler != null) {
                                            handler.onSent(fileMessage, e);
                                        }
                                        return;
                                    }
                                    FileMessage fileMessage = new FileMessage(acked.getJsonElement());
                                    if (handler != null) {
                                        handler.onSent(fileMessage, null);
                                    }
                                }
                            });
                        }
                    });
                } else {
                    APIClient.getInstance().sendFileMessage(BaseChannel.this instanceof OpenChannel, BaseChannel.this.getUrl(), SendBird.getCurrentUser().getUserId(), fileUrl, name, size, type, customType, data, thumbnails, requireAuth, new APIClient.APIClientHandler(){

                        @Override
                        public void onResult(final JsonElement response, final SendBirdException e) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (e != null) {
                                        if (handler != null) {
                                            handler.onSent(fileMessage, e);
                                        }
                                        return;
                                    }
                                    JsonObject responseObj = response.getAsJsonObject();
                                    responseObj.addProperty("req_id", reqId);
                                    FileMessage fileMessage = (FileMessage)BaseMessage.build(responseObj, BaseChannel.this.getUrl(), BaseChannel.this.getType());
                                    if (handler != null) {
                                        handler.onSent(fileMessage, null);
                                    }
                                }
                            });
                        }
                    });
                }
            }
        });
        return fileMessage;
    }

    public FileMessage sendFileMessage(File file, String name, String type, int size, String data, SendFileMessageWithProgressHandler handler) {
        return this.sendFileMessage(file, name, type, size, data, null, null, handler);
    }

    public FileMessage sendFileMessage(File file, String name, String type, int size, String data, String customType, SendFileMessageWithProgressHandler handler) {
        return this.sendFileMessage(file, name, type, size, data, customType, null, handler);
    }

    public FileMessage sendFileMessage(File file, final String name, final String type, final int size, final String data, final String customType, List<FileMessage.ThumbnailSize> thumbnailSizes, final SendFileMessageWithProgressHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Connection must be made before you send message.", 800101));
                    }
                });
            }
            return null;
        }
        if (file == null || name == null || name.length() == 0 || type == null || type.length() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        final String reqId = Command.generateRequestId();
        JsonObject obj = new JsonObject();
        JsonArray thumbnails = new JsonArray();
        if (thumbnailSizes != null) {
            for (FileMessage.ThumbnailSize thumbnailSize : thumbnailSizes) {
                JsonObject thumbnail = new JsonObject();
                thumbnail.addProperty("width", thumbnailSize.getMaxWidth());
                thumbnail.addProperty("height", thumbnailSize.getMaxHeight());
                thumbnail.addProperty("url", "");
                thumbnails.add(thumbnail);
            }
        }
        obj.add("thumbnails", thumbnails);
        final FileMessage fileMessage = new FileMessage(FileMessage.build(reqId, 0L, SendBird.getCurrentUser(), this.getUrl(), this.getType(), "", file.getName(), type, size, data, customType, obj.get("thumbnails").toString(), false, System.currentTimeMillis(), 0L));
        APIClient.getInstance().uploadFile(file, type, thumbnailSizes, this.getUrl(), reqId, new APIClient.APIClientProgressHandler(){

            @Override
            public void onProgress(final long bytesSent, final long totalBytesSent, final long totalBytesToSend) {
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onProgress((int)bytesSent, (int)totalBytesSent, (int)totalBytesToSend);
                        }
                    });
                }
            }
        }, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                boolean requireAuth;
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onSent(fileMessage, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                String fileUrl = result.get("url").getAsString();
                String thumbnails = result.has("thumbnails") ? result.get("thumbnails").toString() : null;
                boolean bl = requireAuth = result.has("require_auth") && result.get("require_auth").getAsBoolean();
                if (SendBird.getConnectionState() == SendBird.ConnectionState.OPEN) {
                    Command cmd = Command.bFile(reqId, BaseChannel.this.getUrl(), fileUrl, name, type, size, data, customType, thumbnails, requireAuth);
                    SendBird.getInstance().sendCommand(cmd, new Command.SendCommandHandler(){

                        @Override
                        public void onResult(final Command acked, final SendBirdException e) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (e != null) {
                                        if (handler != null) {
                                            handler.onSent(fileMessage, e);
                                        }
                                        return;
                                    }
                                    FileMessage fileMessage = new FileMessage(acked.getJsonElement());
                                    if (handler != null) {
                                        handler.onSent(fileMessage, null);
                                    }
                                }
                            });
                        }
                    });
                } else {
                    APIClient.getInstance().sendFileMessage(BaseChannel.this instanceof OpenChannel, BaseChannel.this.getUrl(), SendBird.getCurrentUser().getUserId(), fileUrl, name, size, type, customType, data, thumbnails, requireAuth, new APIClient.APIClientHandler(){

                        @Override
                        public void onResult(final JsonElement response, final SendBirdException e) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (e != null) {
                                        if (handler != null) {
                                            handler.onSent(fileMessage, e);
                                        }
                                        return;
                                    }
                                    JsonObject responseObj = response.getAsJsonObject();
                                    responseObj.addProperty("req_id", reqId);
                                    FileMessage fileMessage = (FileMessage)BaseMessage.build(responseObj, BaseChannel.this.getUrl(), BaseChannel.this.getType());
                                    if (handler != null) {
                                        handler.onSent(fileMessage, null);
                                    }
                                }
                            });
                        }
                    });
                }
            }
        });
        return fileMessage;
    }

    public UserMessage sendUserMessage(String message, SendUserMessageHandler handler) {
        return this.sendUserMessage(message, null, null, handler);
    }

    public UserMessage sendUserMessage(String message, String data, SendUserMessageHandler handler) {
        return this.sendUserMessage(message, data, null, null, handler);
    }

    public UserMessage sendUserMessage(String message, String data, String customType, SendUserMessageHandler handler) {
        return this.sendUserMessage(message, data, customType, null, handler);
    }

    public UserMessage sendUserMessage(String message, String data, String customType, List<String> targetLanguages, final SendUserMessageHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Connection must be made before you send message.", 800101));
                    }
                });
            }
            return null;
        }
        if (message == null) {
            message = "";
        }
        Command cmd = Command.bMessage(this.getUrl(), message, data, customType, null, targetLanguages);
        JsonObject obj = new JsonObject();
        JsonObject transObj = new JsonObject();
        if (targetLanguages != null) {
            for (String targetLanguage : targetLanguages) {
                transObj.addProperty(targetLanguage, "");
            }
        }
        obj.add("translations", transObj);
        final UserMessage msg = new UserMessage(UserMessage.build(cmd.getRequestId(), 0L, SendBird.getCurrentUser(), this.getUrl(), this.getType(), message, data, customType, obj.get("translations").toString(), System.currentTimeMillis(), 0L));
        SendBird.getInstance().sendCommand(cmd, new Command.SendCommandHandler(){

            @Override
            public void onResult(final Command acked, final SendBirdException e) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (e != null) {
                            if (handler != null) {
                                handler.onSent(msg, e);
                            }
                            return;
                        }
                        UserMessage userMessage = new UserMessage(acked.getJsonElement());
                        if (handler != null) {
                            handler.onSent(userMessage, null);
                        }
                    }
                });
            }
        });
        return msg;
    }

    public FileMessage copyFileMessage(BaseChannel targetChannel, FileMessage fileMessage, final CopyFileMessageHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCopied(null, new SendBirdException("Connection must be made before you send message.", 800101));
                    }
                });
            }
            return null;
        }
        if (targetChannel == null || fileMessage == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCopied(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        if (!this.getUrl().equals(fileMessage.getChannelUrl())) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCopied(null, new SendBirdException("The message does not belong to this channel.", 800110));
                    }
                });
            }
            return null;
        }
        JsonObject obj = new JsonObject();
        JsonArray thumbnailsArray = new JsonArray();
        for (FileMessage.Thumbnail thumbnail : fileMessage.getThumbnails()) {
            JsonObject thumbnailObj = new JsonObject();
            thumbnailObj.addProperty("width", thumbnail.getMaxWidth());
            thumbnailObj.addProperty("height", thumbnail.getMaxHeight());
            thumbnailObj.addProperty("real_width", thumbnail.getRealWidth());
            thumbnailObj.addProperty("real_height", thumbnail.getRealHeight());
            thumbnailObj.addProperty("url", thumbnail.getOriginalUrl());
            thumbnailsArray.add(thumbnailObj);
        }
        obj.add("thumbnails", thumbnailsArray);
        final String reqId = Command.generateRequestId();
        final FileMessage msg = new FileMessage(FileMessage.build(reqId, 0L, SendBird.getCurrentUser(), targetChannel.getUrl(), targetChannel.getType(), fileMessage.getOriginalUrl(), fileMessage.getName(), fileMessage.getType(), fileMessage.getSize(), fileMessage.getData(), fileMessage.getCustomType(), obj.get("thumbnails").toString(), fileMessage.requiredAuth(), System.currentTimeMillis(), 0L));
        if (SendBird.getConnectionState() == SendBird.ConnectionState.OPEN) {
            Command cmd = Command.bFile(reqId, targetChannel.getUrl(), fileMessage.getOriginalUrl(), fileMessage.getName(), fileMessage.getType(), fileMessage.getSize(), fileMessage.getData(), fileMessage.getCustomType(), obj.get("thumbnails").toString(), fileMessage.requiredAuth());
            SendBird.getInstance().sendCommand(cmd, new Command.SendCommandHandler(){

                @Override
                public void onResult(final Command acked, final SendBirdException e) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (e != null) {
                                if (handler != null) {
                                    handler.onCopied(msg, e);
                                }
                                return;
                            }
                            FileMessage fileMessage = new FileMessage(acked.getJsonElement());
                            if (handler != null) {
                                handler.onCopied(fileMessage, null);
                            }
                        }
                    });
                }
            });
        } else {
            APIClient.getInstance().sendFileMessage(targetChannel instanceof OpenChannel, targetChannel.getUrl(), SendBird.getCurrentUser().getUserId(), fileMessage.getOriginalUrl(), fileMessage.getName(), fileMessage.getSize(), fileMessage.getType(), fileMessage.getCustomType(), fileMessage.getData(), obj.get("thumbnails").toString(), fileMessage.requiredAuth(), new APIClient.APIClientHandler(){

                @Override
                public void onResult(final JsonElement response, final SendBirdException e) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (e != null) {
                                if (handler != null) {
                                    handler.onCopied(msg, e);
                                }
                                return;
                            }
                            JsonObject responseObj = response.getAsJsonObject();
                            responseObj.addProperty("req_id", reqId);
                            FileMessage fileMessage = (FileMessage)BaseMessage.build(responseObj, BaseChannel.this.getUrl(), BaseChannel.this.getType());
                            if (handler != null) {
                                handler.onCopied(fileMessage, null);
                            }
                        }
                    });
                }
            });
        }
        return msg;
    }

    public UserMessage copyUserMessage(BaseChannel targetChannel, UserMessage userMessage, final CopyUserMessageHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCopied(null, new SendBirdException("Connection must be made before you forward message.", 800101));
                    }
                });
            }
            return null;
        }
        if (targetChannel == null || userMessage == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCopied(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        if (!this.getUrl().equals(userMessage.getChannelUrl())) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCopied(null, new SendBirdException("The message does not belong to this channel.", 800110));
                    }
                });
            }
            return null;
        }
        ArrayList<String> targetLanguages = null;
        if (userMessage.getTranslations().size() > 0) {
            targetLanguages = new ArrayList<String>();
            targetLanguages.addAll(userMessage.getTranslations().keySet());
        }
        Command cmd = Command.bMessage(targetChannel.getUrl(), userMessage.getMessage(), userMessage.getData(), userMessage.getCustomType(), null, targetLanguages);
        JsonObject obj = new JsonObject();
        JsonObject transObj = new JsonObject();
        if (targetLanguages != null) {
            for (String targetLanguage : targetLanguages) {
                transObj.addProperty(targetLanguage, "");
            }
        }
        obj.add("translations", transObj);
        final UserMessage msg = new UserMessage(UserMessage.build(cmd.getRequestId(), 0L, SendBird.getCurrentUser(), targetChannel.getUrl(), targetChannel.getType(), userMessage.getMessage(), userMessage.getData(), userMessage.getCustomType(), obj.get("translations").toString(), System.currentTimeMillis(), 0L));
        SendBird.getInstance().sendCommand(cmd, new Command.SendCommandHandler(){

            @Override
            public void onResult(final Command acked, final SendBirdException e) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (e != null) {
                            if (handler != null) {
                                handler.onCopied(msg, e);
                            }
                            return;
                        }
                        UserMessage userMessage = new UserMessage(acked.getJsonElement());
                        if (handler != null) {
                            handler.onCopied(userMessage, null);
                        }
                    }
                });
            }
        });
        return msg;
    }

    public void createMetaCounters(Map<String, Integer> metaCounterMap, final MetaCounterHandler handler) {
        if (metaCounterMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().createMetaCounters(this instanceof OpenChannel, this.getUrl(), metaCounterMap, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void updateMetaCounters(Map<String, Integer> metaCounterMap, final MetaCounterHandler handler) {
        if (metaCounterMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().updateMetaCounters(this instanceof OpenChannel, this.getUrl(), metaCounterMap, true, 0, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void increaseMetaCounters(Map<String, Integer> metaCounterMap, final MetaCounterHandler handler) {
        if (metaCounterMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().updateMetaCounters(this instanceof OpenChannel, this.getUrl(), metaCounterMap, false, 1, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void decreaseMetaCounters(Map<String, Integer> metaCounterMap, final MetaCounterHandler handler) {
        if (metaCounterMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().updateMetaCounters(this instanceof OpenChannel, this.getUrl(), metaCounterMap, false, 2, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void getMetaCounters(Collection<String> keys, final MetaCounterHandler handler) {
        if (keys == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().getMetaCounters(this instanceof OpenChannel, this.getUrl(), keys, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void getAllMetaCounters(final MetaCounterHandler handler) {
        APIClient.getInstance().getAllMetaCounters(this instanceof OpenChannel, this.getUrl(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void deleteMetaCounter(String key, final DeleteMetaCounterHandler handler) {
        if (key == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteMetaCounter(this instanceof OpenChannel, this.getUrl(), key, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void deleteAllMetaCounters(final DeleteMetaCounterHandler handler) {
        APIClient.getInstance().deleteAllMetaCounters(this instanceof OpenChannel, this.getUrl(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void createMetaData(Map<String, String> metaDataMap, final MetaDataHandler handler) {
        if (metaDataMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().createMetaData(this instanceof OpenChannel, this.getUrl(), metaDataMap, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, String> result = new HashMap<String, String>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void updateMetaData(Map<String, String> metaDataMap, final MetaDataHandler handler) {
        if (metaDataMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().updateMetaData(this instanceof OpenChannel, this.getUrl(), metaDataMap, true, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, String> result = new HashMap<String, String>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void getMetaData(Collection<String> keys, final MetaDataHandler handler) {
        if (keys == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().getMetaData(this instanceof OpenChannel, this.getUrl(), keys, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, String> result = new HashMap<String, String>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void getAllMetaData(final MetaDataHandler handler) {
        APIClient.getInstance().getAllMetaData(this instanceof OpenChannel, this.getUrl(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap<String, String> result = new HashMap<String, String>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void deleteMetaData(String key, final DeleteMetaDataHandler handler) {
        if (key == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteMetaData(this instanceof OpenChannel, this.getUrl(), key, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                HashMap<String, String> result = new HashMap<String, String>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void deleteAllMetaData(final DeleteMetaDataHandler handler) {
        APIClient.getInstance().deleteAllMetaData(this instanceof OpenChannel, this.getUrl(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null && handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(e);
                        }
                    });
                }
                HashMap<String, String> result = new HashMap<String, String>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                    if (!entry.getValue().isJsonPrimitive()) continue;
                    result.put(entry.getKey(), entry.getValue().getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void deleteMessage(BaseMessage message, final DeleteMessageHandler handler) {
        if (message == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteMessage(this instanceof OpenChannel, this.getUrl(), message.getMessageId(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void updateUserMessage(long messageId, String body, String data, String customType, final UpdateUserMessageHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUpdated(null, new SendBirdException("Connection must be made.", 800101));
                    }
                });
            }
            return;
        }
        Command cmd = Command.bUpdateMessage(this.getUrl(), messageId, body, data, customType);
        SendBird.getInstance().sendCommand(cmd, new Command.SendCommandHandler(){

            @Override
            public void onResult(final Command acked, final SendBirdException e) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (e != null) {
                            if (handler != null) {
                                handler.onUpdated(null, e);
                            }
                            return;
                        }
                        UserMessage userMessage = new UserMessage(acked.getJsonElement());
                        if (handler != null) {
                            handler.onUpdated(userMessage, null);
                        }
                    }
                });
            }
        });
    }

    public void updateFileMessage(long messageId, String data, String customType, final UpdateFileMessageHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUpdated(null, new SendBirdException("Connection must be made.", 800101));
                    }
                });
            }
            return;
        }
        Command cmd = Command.bUpdateFile(this.getUrl(), messageId, data, customType);
        SendBird.getInstance().sendCommand(cmd, new Command.SendCommandHandler(){

            @Override
            public void onResult(final Command acked, final SendBirdException e) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (e != null) {
                            if (handler != null) {
                                handler.onUpdated(null, e);
                            }
                            return;
                        }
                        FileMessage fileMessage = new FileMessage(acked.getJsonElement());
                        if (handler != null) {
                            handler.onUpdated(fileMessage, null);
                        }
                    }
                });
            }
        });
    }

    public boolean cancelFileMessageUpload(String requestId) {
        return APIClient.getInstance().cancelRequest(requestId);
    }

    public static interface UpdateFileMessageHandler {
        public void onUpdated(FileMessage var1, SendBirdException var2);
    }

    public static interface UpdateUserMessageHandler {
        public void onUpdated(UserMessage var1, SendBirdException var2);
    }

    public static interface DeleteMessageHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface CopyFileMessageHandler {
        public void onCopied(FileMessage var1, SendBirdException var2);
    }

    public static interface CopyUserMessageHandler {
        public void onCopied(UserMessage var1, SendBirdException var2);
    }

    public static interface SendFileMessageWithProgressHandler {
        public void onProgress(int var1, int var2, int var3);

        public void onSent(FileMessage var1, SendBirdException var2);
    }

    public static interface SendFileMessageHandler {
        public void onSent(FileMessage var1, SendBirdException var2);
    }

    public static interface SendUserMessageHandler {
        public void onSent(UserMessage var1, SendBirdException var2);
    }

    public static interface DeleteMetaDataHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface MetaDataHandler {
        public void onResult(Map<String, String> var1, SendBirdException var2);
    }

    public static interface DeleteMetaCounterHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface MetaCounterHandler {
        public void onResult(Map<String, Integer> var1, SendBirdException var2);
    }

    public static interface GetMessageChangeLogsByTokenHandler {
        public void onResult(List<BaseMessage> var1, List<Long> var2, boolean var3, String var4, SendBirdException var5);
    }

    public static interface GetMessagesHandler {
        public void onResult(List<BaseMessage> var1, SendBirdException var2);
    }

    public static enum MessageTypeFilter {
        ALL,
        USER,
        FILE,
        ADMIN;

    }

    public static enum ChannelType {
        OPEN,
        GROUP;

    }
}

