/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;

public final class FileMessage
extends BaseMessage {
    User mSender;
    private String mUrl;
    private String mName;
    private int mSize;
    private String mType;
    private String mData;
    private String mReqId = "";
    private String mCustomType = "";
    private List<Thumbnail> mThumbnails;
    private boolean mRequireAuth;

    static JsonElement build(String requestId, long msgId, User user, String channelUrl, String channelType, String url, String name, String type, int size, String data, String customType, String thumbnails, boolean requireAuth, long createdAt, long updatedAt) {
        JsonObject obj = new JsonObject();
        obj.addProperty("req_id", requestId);
        obj.addProperty("msg_id", msgId);
        obj.addProperty("channel_url", channelUrl);
        obj.addProperty("channel_type", channelType);
        obj.addProperty("ts", createdAt);
        obj.addProperty("updated_at", updatedAt);
        obj.addProperty("url", url);
        obj.addProperty("name", name);
        obj.addProperty("type", type);
        obj.addProperty("size", size);
        if (data != null) {
            obj.addProperty("custom", data);
        }
        if (customType != null) {
            obj.addProperty("custom_type", customType);
        }
        if (thumbnails != null) {
            obj.add("thumbnails", new JsonParser().parse(thumbnails));
        }
        if (requireAuth) {
            obj.addProperty("require_auth", requireAuth);
        }
        JsonObject userObj = new JsonObject();
        userObj.addProperty("user_id", user.getUserId());
        userObj.addProperty("nickname", user.getNickname());
        userObj.addProperty("profile_url", user.getProfileUrl());
        obj.add("user", userObj);
        return obj;
    }

    FileMessage(JsonElement el) {
        super(el);
        JsonObject obj = el.getAsJsonObject();
        this.mSender = new User(obj.get("user"));
        this.mUrl = obj.get("url").getAsString();
        this.mName = obj.has("name") ? obj.get("name").getAsString() : "File";
        this.mSize = obj.get("size").getAsInt();
        this.mType = obj.get("type").getAsString();
        this.mData = obj.has("custom") ? obj.get("custom").getAsString() : "";
        this.mReqId = obj.has("req_id") ? obj.get("req_id").getAsString() : "";
        this.mCustomType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : "";
        this.mRequireAuth = obj.has("require_auth") && obj.get("require_auth").getAsBoolean();
        this.mThumbnails = new ArrayList<Thumbnail>();
        if (obj.has("thumbnails")) {
            JsonArray thumbnailsArray = obj.get("thumbnails").getAsJsonArray();
            for (JsonElement element : thumbnailsArray) {
                Thumbnail thumbnail = new Thumbnail(element, this.mRequireAuth);
                this.mThumbnails.add(thumbnail);
            }
        }
    }

    @Override
    JsonElement toJson() {
        JsonObject obj = super.toJson().getAsJsonObject();
        obj.addProperty("type", "FILE");
        obj.addProperty("req_id", this.mReqId);
        JsonObject fileObj = new JsonObject();
        fileObj.addProperty("url", this.mUrl);
        fileObj.addProperty("name", this.mName);
        fileObj.addProperty("type", this.mType);
        fileObj.addProperty("size", this.mSize);
        fileObj.addProperty("data", this.mData);
        obj.add("file", fileObj);
        obj.addProperty("custom_type", this.mCustomType);
        obj.add("user", this.mSender.toJson());
        if (this.mRequireAuth) {
            obj.addProperty("require_auth", this.mRequireAuth);
        }
        JsonArray thumbnailObj = new JsonArray();
        for (Thumbnail thumbnail : this.mThumbnails) {
            thumbnailObj.add(thumbnail.toJson());
        }
        obj.add("thumbnails", thumbnailObj);
        return obj;
    }

    String getOriginalUrl() {
        return this.mUrl;
    }

    boolean requiredAuth() {
        return this.mRequireAuth;
    }

    public String getRequestId() {
        return this.mReqId;
    }

    public User getSender() {
        if (SendBird.Options.useMemberAsMessageSender && GroupChannel.sCachedChannels.containsKey(this.mChannelUrl)) {
            GroupChannel channel = GroupChannel.sCachedChannels.get(this.mChannelUrl);
            User member = channel.mMemberMap.get(this.mSender.getUserId());
            if (member != null) {
                if (!member.getNickname().equals(this.mSender.getNickname())) {
                    this.mSender.setNickname(member.getNickname());
                }
                if (!member.getProfileUrl().equals(this.mSender.getProfileUrl())) {
                    this.mSender.setProfileUrl(member.getProfileUrl());
                }
            }
        }
        return this.mSender;
    }

    public String getUrl() {
        if (this.mRequireAuth) {
            return String.format("%s?auth=%s", this.mUrl, APIClient.getInstance().getEKey());
        }
        return this.mUrl;
    }

    public String getName() {
        return this.mName;
    }

    public int getSize() {
        return this.mSize;
    }

    public String getType() {
        return this.mType;
    }

    public String getData() {
        return this.mData;
    }

    public String getCustomType() {
        return this.mCustomType;
    }

    public List<Thumbnail> getThumbnails() {
        return this.mThumbnails;
    }

    public static class ThumbnailSize {
        private int mMaxWidth;
        private int mMaxHeight;

        public ThumbnailSize(int maxWidth, int maxHeight) {
            this.mMaxWidth = maxWidth >= 0 ? maxWidth : 0;
            this.mMaxHeight = maxHeight >= 0 ? maxHeight : 0;
        }

        public int getMaxWidth() {
            return this.mMaxWidth;
        }

        public int getMaxHeight() {
            return this.mMaxHeight;
        }
    }

    public static class Thumbnail {
        private int mMaxWidth;
        private int mMaxHeight;
        private int mRealWidth;
        private int mRealHeight;
        private String mUrl;
        private boolean mRequireAuth;

        private Thumbnail(JsonElement el, boolean requireAuth) {
            JsonObject obj = el.getAsJsonObject();
            this.mMaxWidth = obj.has("width") ? obj.get("width").getAsInt() : 0;
            this.mMaxHeight = obj.has("height") ? obj.get("height").getAsInt() : 0;
            this.mRealWidth = obj.has("real_width") ? obj.get("real_width").getAsInt() : -1;
            this.mRealHeight = obj.has("real_height") ? obj.get("real_height").getAsInt() : -1;
            this.mUrl = obj.has("url") ? obj.get("url").getAsString() : "";
            this.mRequireAuth = requireAuth;
        }

        public int getMaxWidth() {
            return this.mMaxWidth;
        }

        public int getMaxHeight() {
            return this.mMaxHeight;
        }

        public int getRealWidth() {
            return this.mRealWidth;
        }

        public int getRealHeight() {
            return this.mRealHeight;
        }

        public String getUrl() {
            if (this.mRequireAuth) {
                return String.format("%s?auth=%s", this.mUrl, APIClient.getInstance().getEKey());
            }
            return this.mUrl;
        }

        String getOriginalUrl() {
            return this.mUrl;
        }

        JsonElement toJson() {
            JsonObject obj = new JsonObject();
            obj.addProperty("width", this.mMaxWidth);
            obj.addProperty("height", this.mMaxHeight);
            obj.addProperty("real_width", this.mRealWidth);
            obj.addProperty("real_height", this.mRealHeight);
            obj.addProperty("url", this.mUrl);
            return obj;
        }
    }
}

