/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;

public final class FileMessage
extends BaseMessage {
    private User mSender;
    private String mUrl;
    private String mName;
    private int mSize;
    private String mType;
    private String mData;
    private String mReqId = "";

    static JsonElement build(String requestId, long msgId, User user, BaseChannel channel, String url, String name, String type, int size, String data, long createdAt) {
        JsonObject obj = new JsonObject();
        obj.addProperty("req_id", requestId);
        obj.addProperty("msg_id", msgId);
        obj.addProperty("channel_url", channel.getUrl());
        obj.addProperty("channel_type", channel instanceof OpenChannel ? "open" : "group");
        obj.addProperty("ts", createdAt);
        obj.addProperty("url", url);
        obj.addProperty("name", name);
        obj.addProperty("type", type);
        obj.addProperty("size", size);
        obj.addProperty("custom", data);
        JsonObject userObj = new JsonObject();
        userObj.addProperty("user_id", user.getUserId());
        userObj.addProperty("nickname", user.getNickname());
        userObj.addProperty("profile_url", user.getProfileUrl());
        obj.add("user", userObj);
        return obj;
    }

    FileMessage(JsonElement el) {
        super(el);
        JsonObject obj = el.getAsJsonObject();
        this.mSender = new User(obj.get("user"));
        this.mUrl = obj.get("url").getAsString();
        this.mName = obj.has("name") ? obj.get("name").getAsString() : "File";
        this.mSize = obj.get("size").getAsInt();
        this.mType = obj.get("type").getAsString();
        this.mData = obj.get("custom").getAsString();
        this.mReqId = obj.has("req_id") ? obj.get("req_id").getAsString() : "";
    }

    public String getRequestId() {
        return this.mReqId;
    }

    public User getSender() {
        return this.mSender;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public String getName() {
        return this.mName;
    }

    public int getSize() {
        return this.mSize;
    }

    public String getType() {
        return this.mType;
    }

    public String getData() {
        return this.mData;
    }
}

