/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.Logger;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.shadow.com.google.gson.Gson;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonNull;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import com.sendbird.android.shadow.okhttp3.Call;
import com.sendbird.android.shadow.okhttp3.Callback;
import com.sendbird.android.shadow.okhttp3.Headers;
import com.sendbird.android.shadow.okhttp3.MediaType;
import com.sendbird.android.shadow.okhttp3.OkHttpClient;
import com.sendbird.android.shadow.okhttp3.Request;
import com.sendbird.android.shadow.okhttp3.RequestBody;
import com.sendbird.android.shadow.okhttp3.Response;
import com.sendbird.android.shadow.okhttp3.internal.Util;
import com.sendbird.android.shadow.okio.BufferedSink;
import com.sendbird.android.shadow.okio.ByteString;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

class APIClient {
    private static final Gson sGson = new Gson();
    private static final String API_ROUTING_URL = "https://api.sendbird.com/routing/%s";
    private static final String API_USERS = "/v3/users";
    private static final String API_USERS_USERID_LOGIN = "/v3/users/%s/login";
    private static final String API_USERS_USERID = "/v3/users/%s";
    private static final String API_USERS_USERID_UNREADCOUNT = "/v3/users/%s/unread_count";
    private static final String API_USERS_USERID_MARKASREADALL = "/v3/users/%s/mark_as_read_all";
    private static final String API_USERS_USERID_PUSH_GCM_TOKEN = "/v3/users/%s/push/gcm/%s";
    private static final String API_USERS_USERID_PUSH_GCM = "/v3/users/%s/push/gcm";
    private static final String API_USERS_USERID_PUSH = "/v3/users/%s/push";
    private static final String API_USERS_USERID_PUSHPREFERENCE_CHANNELURL = "/v3/users/%s/push_preference/%s";
    private static final String API_USERS_USERID_PUSHPREFERENCE = "/v3/users/%s/push_preference/";
    private static final String API_USERS_USERID_BLOCK = "/v3/users/%s/block";
    private static final String API_USERS_USERID_BLOCK_TARGETID = "/v3/users/%s/block/%s";
    private static final String API_OPENCHANNELS = "/v3/open_channels";
    private static final String API_OPENCHANNELS_CHANNELURL = "/v3/open_channels/%s";
    private static final String API_OPENCHANNELS_CHANNELURL_MESSAGES = "/v3/open_channels/%s/messages";
    private static final String API_OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID = "/v3/open_channels/%s/messages/%s";
    private static final String API_OPENCHANNELS_CHANNELURL_PARTICIPANTS = "/v3/open_channels/%s/participants";
    private static final String API_OPENCHANNELS_CHANNELURL_METADATA = "/v3/open_channels/%s/metadata";
    private static final String API_OPENCHANNELS_CHANNELURL_METADATA_KEY = "/v3/open_channels/%s/metadata/%s";
    private static final String API_OPENCHANNELS_CHANNELURL_METACOUNTER = "/v3/open_channels/%s/metacounter";
    private static final String API_OPENCHANNELS_CHANNELURL_METACOUNTER_KEY = "/v3/open_channels/%s/metacounter/%s";
    private static final String API_OPENCHANNELS_CHANNELURL_BAN = "/v3/open_channels/%s/ban";
    private static final String API_OPENCHANNELS_CHANNELURL_BAN_USERID = "/v3/open_channels/%s/ban/%s";
    private static final String API_OPENCHANNELS_CHANNELURL_MUTE = "/v3/open_channels/%s/mute";
    private static final String API_OPENCHANNELS_CHANNELURL_MUTE_USERID = "/v3/open_channels/%s/mute/%s";
    private static final String API_GROUPCHANNELS = "/v3/group_channels";
    private static final String API_GROUPCHANNELS_CHANNELURL = "/v3/group_channels/%s";
    private static final String API_GROUPCHANNELS_CHANNELURL_INVITE = "/v3/group_channels/%s/invite";
    private static final String API_GROUPCHANNELS_CHANNELURL_HIDE = "/v3/group_channels/%s/hide";
    private static final String API_GROUPCHANNELS_CHANNELURL_LEAVE = "/v3/group_channels/%s/leave";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES = "/v3/group_channels/%s/messages";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES_MARKASREAD = "/v3/group_channels/%s/messages/mark_as_read";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES_TOTALCOUNT = "/v3/group_channels/%s/messages/total_count";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES_UNREADCOUNT = "/v3/group_channels/%s/messages/unread_count";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID = "/v3/group_channels/%s/messages/%s";
    private static final String API_GROUPCHANNELS_CHANNELURL_MEMBERS = "/v3/group_channels/%s/members";
    private static final String API_GROUPCHANNELS_CHANNELURL_METADATA = "/v3/group_channels/%s/metadata";
    private static final String API_GROUPCHANNELS_CHANNELURL_METADATA_KEY = "/v3/group_channels/%s/metadata/%s";
    private static final String API_GROUPCHANNELS_CHANNELURL_METACOUNTER = "/v3/group_channels/%s/metacounter";
    private static final String API_GROUPCHANNELS_CHANNELURL_METACOUNTER_KEY = "/v3/group_channels/%s/metacounter/%s";
    private static final String API_STORAGE_FILE = "/v3/storage/file";
    private static final String API_STORAGE_PROFILEIMAGE = "/v3/storage/profile_image";
    private static final MediaType MIME_JSON = MediaType.parse("application/json; charset=utf-8");
    private static APIClient sInstance;
    private String mSessionKey = "";
    private String mAPIHost;
    private String mWSHost;
    private long mRoutingUpdatedAt;
    private OkHttpClient mOkHttpClient = new OkHttpClient();
    private OkHttpClient mOkHttpClientLong = new OkHttpClient.Builder().writeTimeout(60000L, TimeUnit.MILLISECONDS).build();
    public static final int UPDATE_META_COUNTER_MODE_SET = 0;
    public static final int UPDATE_META_COUNTER_MODE_INC = 1;
    public static final int UPDATE_META_COUNTER_MODE_DEC = 2;

    public static synchronized APIClient getInstance() {
        if (sInstance == null) {
            Logger.e("SendBird instance hasn't been initialized. Try SendBird.init().");
            throw new RuntimeException("SendBird instance hasn't been initialized.");
        }
        return sInstance;
    }

    public static synchronized void init() {
        if (sInstance == null) {
            sInstance = new APIClient();
        }
    }

    protected APIClient() {
    }

    public void groupChannelInvite(String channelUrl, List<String> userIds, APIClientHandler handler) {
        String url = String.format(API_GROUPCHANNELS_CHANNELURL_INVITE, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        JsonArray userIdsObj = new JsonArray();
        for (String userId : userIds) {
            userIdsObj.add(userId);
        }
        form.add("user_ids", userIdsObj);
        this.requestPOST(url, form, handler);
    }

    public void groupChannelHide(String channelUrl, String userId, APIClientHandler handler) {
        String url = String.format(API_GROUPCHANNELS_CHANNELURL_HIDE, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", userId);
        this.requestPUT(url, form, handler);
    }

    public void groupChannelLeave(String channelUrl, String userId, APIClientHandler handler) {
        String url = String.format(API_GROUPCHANNELS_CHANNELURL_LEAVE, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", userId);
        this.requestPUT(url, form, handler);
    }

    public void groupChannelMarkAsRead(String channelUrl, String userId, long ts, APIClientHandler handler) {
        String url = String.format(API_GROUPCHANNELS_CHANNELURL_MESSAGES_MARKASREAD, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", userId);
        form.addProperty("ts", ts);
        this.requestPUT(url, form, handler);
    }

    public void groupChannelMarkAsReadAll(String userId, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_MARKASREADALL, UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        this.requestPUT(url, form, handler);
    }

    public void messageList(boolean isOpenChannel, String channelUrl, long messageTimestamp, int prevLimit, int nextLimit, boolean include, boolean reverse, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_MESSAGES, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_MESSAGES, UrlUtil.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("is_sdk", String.valueOf(true));
        params.put("message_ts", String.valueOf(messageTimestamp));
        params.put("prev_limit", String.valueOf(prevLimit));
        params.put("next_limit", String.valueOf(nextLimit));
        params.put("include", String.valueOf(include));
        params.put("reverse", String.valueOf(reverse));
        this.requestGET(url, params, handler);
    }

    public void login(String userId, String accessToken, final APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_LOGIN, UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        form.addProperty("app_id", SendBird.getApplicationId());
        if (accessToken != null) {
            form.addProperty("access_token", accessToken);
        }
        this.requestPOST(url, form, new APIClientHandler(){

            @Override
            public void onResult(JsonElement response, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String sessionKey = response.getAsJsonObject().get("key").getAsString();
                APIClient.this.setSessionKey(sessionKey);
                if (handler != null) {
                    handler.onResult(response, null);
                }
            }
        });
    }

    public void updateUserInfo(String userId, String nickname, String profileUrl, APIClientHandler handler) {
        JsonObject form = this.defaultForm();
        if (nickname != null) {
            form.addProperty("nickname", nickname);
        }
        if (profileUrl != null) {
            form.addProperty("profile_url", profileUrl);
        }
        String url = String.format(API_USERS_USERID, UrlUtil.urlEncodeUTF8(userId));
        this.requestPUT(url, form, handler);
    }

    public void getGroupChannel(String channelUrl, boolean member, boolean readReceipt, APIClientHandler handler) {
        String url = String.format(API_GROUPCHANNELS_CHANNELURL, UrlUtil.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("member", String.valueOf(member));
        params.put("read_receipt", String.valueOf(readReceipt));
        this.requestGET(url, params, handler);
    }

    public void getOpenChannel(String channelUrl, APIClientHandler handler) {
        String url = String.format(API_OPENCHANNELS_CHANNELURL, UrlUtil.urlEncodeUTF8(channelUrl));
        this.requestGET(url, handler);
    }

    public void createGroupChannel(List<String> userIds, boolean isDistinct, String name, String coverUrl, String data, APIClientHandler handler) {
        String url = API_GROUPCHANNELS;
        JsonObject form = this.defaultForm();
        JsonArray userIdsObj = new JsonArray();
        for (String userId : userIds) {
            userIdsObj.add(userId);
        }
        form.add("user_ids", userIdsObj);
        form.addProperty("is_distinct", isDistinct);
        if (name != null) {
            form.addProperty("name", name);
        }
        if (coverUrl != null) {
            form.addProperty("cover_url", coverUrl);
        }
        if (data != null) {
            form.addProperty("data", data);
        }
        this.requestPOST(url, form, handler);
    }

    public void createOpenChannel(String name, String coverUrl, String data, List<String> operatorUserIds, APIClientHandler handler) {
        String url = API_OPENCHANNELS;
        JsonObject form = this.defaultForm();
        if (name != null) {
            form.addProperty("name", name);
        }
        if (coverUrl != null) {
            form.addProperty("cover_url", coverUrl);
        }
        if (data != null) {
            form.addProperty("data", data);
        }
        if (operatorUserIds != null && operatorUserIds.size() > 0) {
            JsonArray operatorUserIdsObj = new JsonArray();
            for (String operatorUserId : operatorUserIds) {
                operatorUserIdsObj.add(operatorUserId);
            }
            form.add("operators", operatorUserIdsObj);
        }
        this.requestPOST(url, form, handler);
    }

    public void createMetaCounters(boolean isOpenChannel, String channelUrl, Map<String, Integer> metaCounterMap, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        JsonObject metas = new JsonObject();
        for (Map.Entry<String, Integer> entry : metaCounterMap.entrySet()) {
            metas.addProperty(entry.getKey(), entry.getValue());
        }
        form.add("metacounter", metas);
        this.requestPOST(url, form, handler);
    }

    public void updateMetaCounters(boolean isOpenChannel, String channelUrl, Map<String, Integer> metaCounterMap, boolean upsert, int mode, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        JsonObject metas = new JsonObject();
        for (Map.Entry<String, Integer> entry : metaCounterMap.entrySet()) {
            metas.addProperty(entry.getKey(), entry.getValue());
        }
        form.add("metacounter", metas);
        form.addProperty("upsert", upsert);
        switch (mode) {
            case 0: {
                form.addProperty("mode", "set");
                break;
            }
            case 1: {
                form.addProperty("mode", "increase");
                break;
            }
            case 2: {
                form.addProperty("mode", "decrease");
            }
        }
        this.requestPUT(url, form, handler);
    }

    public void getAllMetaCounters(boolean isOpenChannel, String channelUrl, APIClientHandler handler) {
        this.getMetaCounters(isOpenChannel, channelUrl, new ArrayList<String>(), handler);
    }

    public void getMetaCounters(boolean isOpenChannel, String channelUrl, Collection<String> keys, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl));
        StringBuilder sb = new StringBuilder();
        String separator = "";
        for (String item : keys) {
            sb.append(separator);
            separator = ",";
            sb.append(UrlUtil.urlEncodeUTF8(item));
        }
        String joinedKeys = sb.toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("keys", joinedKeys);
        this.requestGET(url, params, handler);
    }

    public void deleteMetaCounter(boolean isOpenChannel, String channelUrl, String key, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METACOUNTER_KEY, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(key)) : String.format(API_GROUPCHANNELS_CHANNELURL_METACOUNTER_KEY, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(key));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    public void deleteAllMetaCounters(boolean isOpenChannel, String channelUrl, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    public void createMetaData(boolean isOpenChannel, String channelUrl, Map<String, String> metaDataMap, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        JsonObject metas = new JsonObject();
        for (Map.Entry<String, String> entry : metaDataMap.entrySet()) {
            metas.addProperty(entry.getKey(), entry.getValue());
        }
        form.add("metadata", metas);
        this.requestPOST(url, form, handler);
    }

    public void updateMetaData(boolean isOpenChannel, String channelUrl, Map<String, String> metaDataMap, boolean upsert, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        JsonObject metas = new JsonObject();
        for (Map.Entry<String, String> entry : metaDataMap.entrySet()) {
            metas.addProperty(entry.getKey(), entry.getValue());
        }
        form.add("metadata", metas);
        form.addProperty("upsert", upsert);
        this.requestPUT(url, form, handler);
    }

    public void getAllMetaData(boolean isOpenChannel, String channelUrl, APIClientHandler handler) {
        this.getMetaData(isOpenChannel, channelUrl, new ArrayList<String>(), handler);
    }

    public void getMetaData(boolean isOpenChannel, String channelUrl, Collection<String> keys, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl));
        StringBuilder sb = new StringBuilder();
        String separator = "";
        for (String item : keys) {
            sb.append(separator);
            separator = ",";
            sb.append(UrlUtil.urlEncodeUTF8(item));
        }
        String joinedKeys = sb.toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("keys", joinedKeys);
        this.requestGET(url, params, handler);
    }

    public void deleteMetaData(boolean isOpenChannel, String channelUrl, String key, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METADATA_KEY, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(key)) : String.format(API_GROUPCHANNELS_CHANNELURL_METADATA_KEY, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(key));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    public void deleteAllMetaData(boolean isOpenChannel, String channelUrl, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(API_GROUPCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    public void loadUserList(String token, int limit, List<String> userIds, APIClientHandler handler) {
        String url = API_USERS;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", UrlUtil.urlEncodeUTF8(token));
        params.put("limit", String.valueOf(limit));
        if (userIds != null && userIds.size() > 0) {
            StringBuilder sb = new StringBuilder();
            String separator = "";
            for (String userId : userIds) {
                sb.append(separator);
                separator = ",";
                sb.append(UrlUtil.urlEncodeUTF8(userId));
            }
            params.put("user_ids", sb.toString());
        }
        this.requestGET(url, params, handler);
    }

    public void loadBlockedUserList(String blockerUserId, String token, int limit, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_BLOCK, UrlUtil.urlEncodeUTF8(blockerUserId));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", UrlUtil.urlEncodeUTF8(token));
        params.put("limit", String.valueOf(limit));
        this.requestGET(url, params, handler);
    }

    public void loadOpenChannelList(String token, int limit, String nameKeyword, String urlKeyword, APIClientHandler handler) {
        String url = API_OPENCHANNELS;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", UrlUtil.urlEncodeUTF8(token));
        params.put("limit", String.valueOf(limit));
        if (nameKeyword != null) {
            params.put("name_contains", UrlUtil.urlEncodeUTF8(nameKeyword));
        }
        if (urlKeyword != null) {
            params.put("url_contains", UrlUtil.urlEncodeUTF8(urlKeyword));
        }
        this.requestGET(url, params, handler);
    }

    public void uploadFile(File file, APIClientHandler handler) {
        JsonObject form = this.defaultForm();
        this.requestFILE(API_STORAGE_FILE, form, file, handler);
    }

    public void uploadProfileImage(File file, APIClientHandler handler) {
        JsonObject form = this.defaultForm();
        this.requestFILE(API_STORAGE_PROFILEIMAGE, form, file, handler);
    }

    private JsonObject defaultForm() {
        return new JsonObject();
    }

    public void loadUserGroupChannelList(String userId, String token, int limit, boolean includeEmpty, String order, APIClientHandler handler) {
        String url = API_GROUPCHANNELS;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user_id", UrlUtil.urlEncodeUTF8(userId));
        params.put("token", UrlUtil.urlEncodeUTF8(token));
        params.put("limit", String.valueOf(limit));
        params.put("read_receipt", String.valueOf(true));
        params.put("member", String.valueOf(true));
        params.put("show_empty", String.valueOf(includeEmpty));
        params.put("order", order);
        this.requestGET(url, params, handler);
    }

    public void loadOpenChannelParticipantList(String channelUrl, String token, int limit, APIClientHandler handler) {
        String url = String.format(API_OPENCHANNELS_CHANNELURL_PARTICIPANTS, UrlUtil.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", UrlUtil.urlEncodeUTF8(token));
        params.put("limit", String.valueOf(limit));
        this.requestGET(url, params, handler);
    }

    public void loadOpenChannelMutedList(String channelUrl, String token, int limit, APIClientHandler handler) {
        String url = String.format(API_OPENCHANNELS_CHANNELURL_MUTE, UrlUtil.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", UrlUtil.urlEncodeUTF8(token));
        params.put("limit", String.valueOf(limit));
        this.requestGET(url, params, handler);
    }

    public void loadOpenChannelBanList(String channelUrl, String token, int limit, APIClientHandler handler) {
        String url = String.format(API_OPENCHANNELS_CHANNELURL_BAN, UrlUtil.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", UrlUtil.urlEncodeUTF8(token));
        params.put("limit", String.valueOf(limit));
        this.requestGET(url, params, handler);
    }

    public void registerPushToken(String userId, String gcmRegToken, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_PUSH_GCM, UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        form.addProperty("gcm_reg_token", gcmRegToken);
        this.requestPOST(url, form, handler);
    }

    public void unregisterPushToken(String userId, String gcmRegToken, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_PUSH_GCM_TOKEN, UrlUtil.urlEncodeUTF8(userId), UrlUtil.urlEncodeUTF8(gcmRegToken));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    public void unregisterPushTokenAll(String userId, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_PUSH, UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    public void blockUser(String blockerUserId, String blockeeUserId, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_BLOCK, UrlUtil.urlEncodeUTF8(blockerUserId));
        JsonObject form = this.defaultForm();
        form.addProperty("target_id", blockeeUserId);
        this.requestPOST(url, form, handler);
    }

    public void unblockUser(String blockerUserId, String blockeeUserId, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_BLOCK_TARGETID, UrlUtil.urlEncodeUTF8(blockerUserId), UrlUtil.urlEncodeUTF8(blockeeUserId));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    public void banUser(String channelUrl, String userId, String description, int seconds, APIClientHandler handler) {
        String url = String.format(API_OPENCHANNELS_CHANNELURL_BAN, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", userId);
        if (description != null) {
            form.addProperty("description", description);
        }
        form.addProperty("seconds", String.valueOf(seconds));
        this.requestPOST(url, form, handler);
    }

    public void unbanUser(String channelUrl, String userId, APIClientHandler handler) {
        String url = String.format(API_OPENCHANNELS_CHANNELURL_BAN_USERID, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    public void muteUser(String channelUrl, String userId, APIClientHandler handler) {
        String url = String.format(API_OPENCHANNELS_CHANNELURL_MUTE, UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", userId);
        this.requestPOST(url, form, handler);
    }

    public void unmuteUser(String channelUrl, String userId, APIClientHandler handler) {
        String url = String.format(API_OPENCHANNELS_CHANNELURL_MUTE_USERID, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    public void getTotalUnreadMessageCount(String userId, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_UNREADCOUNT, UrlUtil.urlEncodeUTF8(userId));
        this.requestGET(url, handler);
    }

    public void setDoNotDisturb(String userId, boolean enable, int startHour, int startMin, int endHour, int endMin, String timezone, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_PUSHPREFERENCE, UrlUtil.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        form.addProperty("do_not_disturb", enable);
        form.addProperty("start_hour", startHour);
        form.addProperty("start_min", startMin);
        form.addProperty("end_hour", endHour);
        form.addProperty("end_min", endMin);
        form.addProperty("timezone", timezone);
        this.requestPUT(url, form, handler);
    }

    public void getDoNotDisturb(String userId, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_PUSHPREFERENCE, UrlUtil.urlEncodeUTF8(userId));
        this.requestGET(url, handler);
    }

    public void setPushPreference(String userId, String channelUrl, boolean value, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_PUSHPREFERENCE_CHANNELURL, UrlUtil.urlEncodeUTF8(userId), UrlUtil.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("enable", value);
        this.requestPUT(url, form, handler);
    }

    public void getPushPreference(String userId, String channelUrl, APIClientHandler handler) {
        String url = String.format(API_USERS_USERID_PUSHPREFERENCE_CHANNELURL, UrlUtil.urlEncodeUTF8(userId), UrlUtil.urlEncodeUTF8(channelUrl));
        this.requestGET(url, handler);
    }

    public void deleteMessage(boolean isOpenChannel, String channelUrl, long messageId, APIClientHandler handler) {
        String url = isOpenChannel ? String.format(API_OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID, UrlUtil.urlEncodeUTF8(channelUrl), Long.toString(messageId)) : String.format(API_GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID, UrlUtil.urlEncodeUTF8(channelUrl), Long.toString(messageId));
        JsonObject form = this.defaultForm();
        this.requestDELETE(url, form, handler);
    }

    synchronized void setSessionKey(String sessionKey) {
        if (sessionKey == null) {
            return;
        }
        this.mSessionKey = sessionKey;
    }

    public synchronized String getSessionKey() {
        return this.mSessionKey;
    }

    public void checkRouting(final CheckRoutingHandler handler) {
        if (System.currentTimeMillis() - this.mRoutingUpdatedAt > 300000L) {
            if ((SendBird.getApplicationId() == null || SendBird.getApplicationId().length() == 0) && handler != null) {
                if (this.mRoutingUpdatedAt > 0L) {
                    handler.onResult(this.mAPIHost, this.mWSHost, null);
                } else {
                    handler.onResult(null, null, new SendBirdException("Application ID is not set. Initialize SendBird class.", 800100));
                }
            }
            try {
                Logger.d("Routing: https://api.sendbird.com/routing/%s");
                Request routeRequest = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").url(String.format(API_ROUTING_URL, SendBird.getApplicationId())).build();
                this.mOkHttpClient.newCall(routeRequest).enqueue(new Callback(){

                    @Override
                    public void onFailure(Call call, IOException e) {
                        Logger.d("Routing failed: ");
                        Logger.d(e);
                        if (handler != null) {
                            if (APIClient.this.mRoutingUpdatedAt > 0L) {
                                handler.onResult(APIClient.this.mAPIHost, APIClient.this.mWSHost, null);
                            } else {
                                handler.onResult(null, null, new SendBirdException(e.getMessage(), 800121));
                            }
                        }
                    }

                    @Override
                    public void onResponse(Call call, Response response) throws IOException {
                        block8: {
                            try {
                                JsonElement result = APIClient.this.processResponse(response);
                                APIClient.this.mAPIHost = result.getAsJsonObject().get("api_server").getAsString();
                                APIClient.this.mWSHost = result.getAsJsonObject().get("ws_server").getAsString();
                                APIClient.this.mRoutingUpdatedAt = System.currentTimeMillis();
                                Logger.d("Routing: " + APIClient.this.mAPIHost + " : " + APIClient.this.mWSHost);
                                if (handler != null) {
                                    handler.onResult(APIClient.this.mAPIHost, APIClient.this.mWSHost, null);
                                }
                            }
                            catch (SendBirdException e) {
                                Logger.d(e);
                                if (handler != null) {
                                    if (APIClient.this.mRoutingUpdatedAt > 0L) {
                                        handler.onResult(APIClient.this.mAPIHost, APIClient.this.mWSHost, null);
                                    } else {
                                        handler.onResult(null, null, e);
                                    }
                                }
                            }
                            catch (Exception e) {
                                Logger.d(e);
                                if (handler == null) break block8;
                                if (APIClient.this.mRoutingUpdatedAt > 0L) {
                                    handler.onResult(APIClient.this.mAPIHost, APIClient.this.mWSHost, null);
                                }
                                handler.onResult(null, null, new SendBirdException(e.getMessage(), 800121));
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                if (handler != null) {
                    handler.onResult(null, null, new SendBirdException(e.getMessage(), 800121));
                }
            }
        } else if (handler != null) {
            handler.onResult(this.mAPIHost, this.mWSHost, null);
        }
    }

    private void requestGET(String url, APIClientHandler handler) {
        this.requestGET(url, null, handler);
    }

    private void requestGET(final String url, final HashMap<String, String> params, final APIClientHandler handler) {
        this.checkRouting(new CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block6: {
                    String fullUrl;
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    if (params != null && params.size() > 0) {
                        String query = UrlUtil.urlEncodeUTF8(params);
                        fullUrl = APIClient.this.mAPIHost + url + "?" + query;
                    } else {
                        fullUrl = APIClient.this.mAPIHost + url;
                    }
                    Logger.d("GET: " + fullUrl);
                    try {
                        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Session-Key", APIClient.this.mSessionKey).url(fullUrl).build();
                        APIClient.this.newCall(request, false, handler);
                    }
                    catch (Exception e1) {
                        if (handler == null) break block6;
                        handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                    }
                }
            }
        });
    }

    private void requestPOST(final String url, final JsonElement form, final APIClientHandler handler) {
        this.checkRouting(new CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block4: {
                    Logger.d("POST: " + APIClient.this.mAPIHost + url);
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    try {
                        String formJson = sGson.toJson(form);
                        Logger.d("API request: " + formJson);
                        RequestBody body = RequestBody.create(MIME_JSON, formJson);
                        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Session-Key", APIClient.this.mSessionKey).url(APIClient.this.mAPIHost + url).post(body).build();
                        APIClient.this.newCall(request, false, handler);
                    }
                    catch (Exception e1) {
                        if (handler == null) break block4;
                        handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                    }
                }
            }
        });
    }

    private void requestFILE(final String url, final JsonElement form, final File file, final APIClientHandler handler) {
        this.checkRouting(new CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block7: {
                    String fileMime;
                    block6: {
                        Logger.d("FILE: " + APIClient.this.mAPIHost + url);
                        if (e != null) {
                            if (handler != null) {
                                handler.onResult(null, e);
                            }
                            return;
                        }
                        fileMime = "application/octet-stream";
                        try {
                            fileMime = file.toURI().toURL().openConnection().getContentType();
                        }
                        catch (IOException e1) {
                            if (handler == null) break block6;
                            handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                        }
                    }
                    MediaType MIME_FILE = MediaType.parse(fileMime);
                    Logger.d("File: " + file);
                    Logger.d("Mime: " + fileMime);
                    ArrayList<Headers> partHeaders = new ArrayList<Headers>();
                    ArrayList<RequestBody> partBodies = new ArrayList<RequestBody>();
                    partHeaders.add(Headers.of("Content-Disposition", "form-data; name=\"meta\""));
                    partBodies.add(RequestBody.create(MIME_JSON, sGson.toJson(form)));
                    partHeaders.add(Headers.of("Content-Disposition", "form-data; name=\"file\"; filename=\"" + file.getName() + "\"", "Content-Transfer-Encoding", "binary"));
                    partBodies.add(RequestBody.create(MIME_FILE, file));
                    try {
                        FixedLengthMultipartRequestBody body = new FixedLengthMultipartRequestBody(partHeaders, partBodies);
                        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Session-Key", APIClient.this.mSessionKey).url(APIClient.this.mAPIHost + url).post(body).build();
                        APIClient.this.newCall(request, true, handler);
                    }
                    catch (Exception e1) {
                        if (handler == null) break block7;
                        handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                    }
                }
            }
        });
    }

    private void requestPUT(final String url, final JsonElement form, final APIClientHandler handler) {
        this.checkRouting(new CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block4: {
                    Logger.d("PUT: " + APIClient.this.mAPIHost + url);
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    try {
                        String formJson = sGson.toJson(form);
                        Logger.d("API request: " + formJson);
                        RequestBody body = RequestBody.create(MIME_JSON, formJson);
                        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Session-Key", APIClient.this.mSessionKey).url(APIClient.this.mAPIHost + url).put(body).build();
                        APIClient.this.newCall(request, false, handler);
                    }
                    catch (Exception e1) {
                        if (handler == null) break block4;
                        handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                    }
                }
            }
        });
    }

    private void requestDELETE(final String url, final JsonElement form, final APIClientHandler handler) {
        this.checkRouting(new CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block4: {
                    Logger.d("DELETE: " + APIClient.this.mAPIHost + url);
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    try {
                        String formJson = sGson.toJson(form);
                        Logger.d("API request: " + formJson);
                        RequestBody body = RequestBody.create(MIME_JSON, formJson);
                        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Session-Key", APIClient.this.mSessionKey).url(APIClient.this.mAPIHost + url).delete(body).build();
                        APIClient.this.newCall(request, false, handler);
                    }
                    catch (Exception e1) {
                        if (handler == null) break block4;
                        handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                    }
                }
            }
        });
    }

    private void newCall(Request request, boolean waitLong, final APIClientHandler handler) {
        OkHttpClient client = waitLong ? this.mOkHttpClientLong : this.mOkHttpClient;
        client.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                if (handler != null) {
                    handler.onResult(null, new SendBirdException(e.getMessage(), 800220));
                }
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                block5: {
                    try {
                        JsonElement result = APIClient.this.processResponse(response);
                        if (handler != null) {
                            handler.onResult(result, null);
                        }
                    }
                    catch (SendBirdException e) {
                        Logger.d(e);
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                    }
                    catch (Exception e) {
                        Logger.d(e);
                        if (handler == null) break block5;
                        handler.onResult(null, new SendBirdException(e.getMessage(), 800220));
                    }
                }
            }
        });
    }

    protected JsonElement processResponse(Response response) throws SendBirdException {
        JsonElement json;
        String body;
        try {
            body = response.body().string();
            Logger.d("API response: " + body);
        }
        catch (IOException e) {
            throw new SendBirdException(e.getMessage(), 800130);
        }
        if (body == null || body.length() <= 0) {
            return JsonNull.INSTANCE;
        }
        try {
            json = new JsonParser().parse(body);
        }
        catch (Exception e) {
            throw new SendBirdException(e.getMessage(), 800130);
        }
        if (!response.isSuccessful() && json.isJsonObject() && json.getAsJsonObject().has("error") && json.getAsJsonObject().get("error").isJsonPrimitive() && json.getAsJsonObject().get("error").getAsBoolean()) {
            String message = "";
            int code = 0;
            if (json.getAsJsonObject().has("message") && json.getAsJsonObject().get("message").isJsonPrimitive()) {
                message = json.getAsJsonObject().get("message").getAsString();
            }
            if (json.getAsJsonObject().has("code") && json.getAsJsonObject().get("code").isJsonPrimitive()) {
                code = json.getAsJsonObject().get("code").getAsInt();
            }
            throw new SendBirdException(message, code);
        }
        return json;
    }

    static final class FixedLengthMultipartRequestBody
    extends RequestBody {
        public static final MediaType FORM = MediaType.parse("multipart/form-data");
        private static final byte[] COLONSPACE = new byte[]{58, 32};
        private static final byte[] CRLF = new byte[]{13, 10};
        private static final byte[] DASHDASH = new byte[]{45, 45};
        private final ByteString boundary = ByteString.encodeUtf8(UUID.randomUUID().toString());
        private final MediaType contentType = MediaType.parse(FORM + "; boundary=" + this.boundary.utf8());
        private final List<Headers> partHeaders;
        private final List<RequestBody> partBodies;

        public FixedLengthMultipartRequestBody(List<Headers> partHeaders, List<RequestBody> partBodies) {
            this.partHeaders = Util.immutableList(partHeaders);
            this.partBodies = Util.immutableList(partBodies);
        }

        @Override
        public MediaType contentType() {
            return this.contentType;
        }

        @Override
        public long contentLength() throws IOException {
            int length = 0;
            int partCount = this.partHeaders.size();
            for (int p = 0; p < partCount; ++p) {
                MediaType contentType;
                Headers headers = this.partHeaders.get(p);
                RequestBody body = this.partBodies.get(p);
                long contentLength = body.contentLength();
                if (contentLength == -1L) {
                    return -1L;
                }
                length += DASHDASH.length + this.boundary.size() + CRLF.length;
                if (headers != null) {
                    int headerCount = headers.size();
                    for (int h = 0; h < headerCount; ++h) {
                        length += headers.name(h).getBytes("UTF-8").length + COLONSPACE.length + headers.value(h).getBytes("UTF-8").length + CRLF.length;
                    }
                }
                if ((contentType = body.contentType()) != null) {
                    length += "Content-Type: ".getBytes("UTF-8").length + contentType.toString().getBytes("UTF-8").length + CRLF.length;
                }
                length += "Content-Length: ".getBytes("UTF-8").length + Long.toString(contentLength).getBytes("UTF-8").length + CRLF.length;
                length = (int)((long)length + ((long)CRLF.length + contentLength + (long)CRLF.length));
            }
            return length += DASHDASH.length + this.boundary.size() + DASHDASH.length + CRLF.length;
        }

        @Override
        public void writeTo(BufferedSink sink) throws IOException {
            int partCount = this.partHeaders.size();
            for (int p = 0; p < partCount; ++p) {
                long contentLength;
                MediaType contentType;
                Headers headers = this.partHeaders.get(p);
                RequestBody body = this.partBodies.get(p);
                sink.write(DASHDASH);
                sink.write(this.boundary);
                sink.write(CRLF);
                if (headers != null) {
                    int headerCount = headers.size();
                    for (int h = 0; h < headerCount; ++h) {
                        sink.writeUtf8(headers.name(h)).write(COLONSPACE).writeUtf8(headers.value(h)).write(CRLF);
                    }
                }
                if ((contentType = body.contentType()) != null) {
                    sink.writeUtf8("Content-Type: ").writeUtf8(contentType.toString()).write(CRLF);
                }
                if ((contentLength = body.contentLength()) != -1L) {
                    sink.writeUtf8("Content-Length: ").writeUtf8(Long.toString(contentLength)).write(CRLF);
                }
                sink.write(CRLF);
                this.partBodies.get(p).writeTo(sink);
                sink.write(CRLF);
            }
            sink.write(DASHDASH);
            sink.write(this.boundary);
            sink.write(DASHDASH);
            sink.write(CRLF);
        }
    }

    static class UrlUtil {
        UrlUtil() {
        }

        public static String urlEncodeUTF8(String s) {
            try {
                return URLEncoder.encode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public static String urlEncodeUTF8(Map<?, ?> map) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(String.format("%s=%s", UrlUtil.urlEncodeUTF8(entry.getKey().toString()), entry.getValue().toString()));
            }
            return sb.toString();
        }
    }

    public static interface APIClientHandler {
        public void onResult(JsonElement var1, SendBirdException var2);
    }

    protected static interface CheckRoutingHandler {
        public void onResult(String var1, String var2, SendBirdException var3);
    }
}

