/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android.shadow.okhttp3.internal.ws;

import com.sendbird.android.shadow.okhttp3.MediaType;
import com.sendbird.android.shadow.okhttp3.RequestBody;
import com.sendbird.android.shadow.okhttp3.ResponseBody;
import com.sendbird.android.shadow.okhttp3.internal.NamedRunnable;
import com.sendbird.android.shadow.okhttp3.internal.ws.WebSocketReader;
import com.sendbird.android.shadow.okhttp3.internal.ws.WebSocketWriter;
import com.sendbird.android.shadow.okhttp3.ws.WebSocket;
import com.sendbird.android.shadow.okhttp3.ws.WebSocketListener;
import com.sendbird.android.shadow.okio.Buffer;
import com.sendbird.android.shadow.okio.BufferedSink;
import com.sendbird.android.shadow.okio.BufferedSource;
import com.sendbird.android.shadow.okio.Okio;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class RealWebSocket
implements WebSocket {
    private static final int CLOSE_PROTOCOL_EXCEPTION = 1002;
    private final WebSocketWriter writer;
    private final WebSocketReader reader;
    private final WebSocketListener listener;
    private volatile boolean writerSentClose;
    private boolean writerWantsClose;
    private boolean readerSentClose;
    private final AtomicBoolean connectionClosed = new AtomicBoolean();

    public RealWebSocket(boolean isClient, BufferedSource source, BufferedSink sink, Random random, final Executor replyExecutor, final WebSocketListener listener, final String url) {
        this.listener = listener;
        this.writer = new WebSocketWriter(isClient, sink, random);
        this.reader = new WebSocketReader(isClient, source, new WebSocketReader.FrameCallback(){

            @Override
            public void onMessage(ResponseBody message) throws IOException {
                listener.onMessage(message);
            }

            @Override
            public void onPing(final Buffer buffer) {
                replyExecutor.execute(new NamedRunnable("OkHttp %s WebSocket Pong Reply", new Object[]{url}){

                    @Override
                    protected void execute() {
                        try {
                            RealWebSocket.this.writer.writePong(buffer);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }

            @Override
            public void onPong(Buffer buffer) {
                listener.onPong(buffer);
            }

            @Override
            public void onClose(final int code, final String reason) {
                RealWebSocket.this.readerSentClose = true;
                replyExecutor.execute(new NamedRunnable("OkHttp %s WebSocket Close Reply", new Object[]{url}){

                    @Override
                    protected void execute() {
                        RealWebSocket.this.peerClose(code, reason);
                    }
                });
            }
        });
    }

    public boolean readMessage() {
        try {
            this.reader.processNextFrame();
            return !this.readerSentClose;
        }
        catch (IOException e) {
            this.readerErrorClose(e);
            return false;
        }
    }

    @Override
    public void sendMessage(RequestBody message) throws IOException {
        int formatOpcode;
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        if (this.writerSentClose) {
            throw new IllegalStateException("closed");
        }
        if (this.writerWantsClose) {
            throw new IllegalStateException("must call close()");
        }
        MediaType contentType = message.contentType();
        if (contentType == null) {
            throw new IllegalArgumentException("Message content type was null. Must use WebSocket.TEXT or WebSocket.BINARY.");
        }
        String contentSubtype = contentType.subtype();
        if (WebSocket.TEXT.subtype().equals(contentSubtype)) {
            formatOpcode = 1;
        } else if (WebSocket.BINARY.subtype().equals(contentSubtype)) {
            formatOpcode = 2;
        } else {
            throw new IllegalArgumentException("Unknown message content type: " + contentType.type() + "/" + contentType.subtype() + ". Must use WebSocket.TEXT or WebSocket.BINARY.");
        }
        BufferedSink sink = Okio.buffer(this.writer.newMessageSink(formatOpcode, message.contentLength()));
        try {
            message.writeTo(sink);
            sink.close();
        }
        catch (IOException e) {
            this.writerWantsClose = true;
            throw e;
        }
    }

    @Override
    public void sendPing(Buffer payload) throws IOException {
        if (this.writerSentClose) {
            throw new IllegalStateException("closed");
        }
        if (this.writerWantsClose) {
            throw new IllegalStateException("must call close()");
        }
        try {
            this.writer.writePing(payload);
        }
        catch (IOException e) {
            this.writerWantsClose = true;
            throw e;
        }
    }

    public void sendPong(Buffer payload) throws IOException {
        if (this.writerSentClose) {
            throw new IllegalStateException("closed");
        }
        if (this.writerWantsClose) {
            throw new IllegalStateException("must call close()");
        }
        try {
            this.writer.writePong(payload);
        }
        catch (IOException e) {
            this.writerWantsClose = true;
            throw e;
        }
    }

    @Override
    public void close(int code, String reason) throws IOException {
        if (this.writerSentClose) {
            throw new IllegalStateException("closed");
        }
        this.writerSentClose = true;
        try {
            this.writer.writeClose(code, reason);
        }
        catch (IOException e) {
            if (this.connectionClosed.compareAndSet(false, true)) {
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    private void peerClose(int code, String reason) {
        if (!this.writerSentClose) {
            try {
                this.writer.writeClose(code, reason);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.connectionClosed.compareAndSet(false, true)) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.listener.onClose(code, reason);
    }

    private void readerErrorClose(IOException e) {
        if (!this.writerSentClose && e instanceof ProtocolException) {
            try {
                this.writer.writeClose(1002, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.connectionClosed.compareAndSet(false, true)) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.listener.onFailure(e, null);
    }

    protected abstract void close() throws IOException;
}

