/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class PreviousMessageListQuery {
    private boolean mLoading = false;
    private BaseChannel mChannel;
    private long mMessageTimestamp = Long.MAX_VALUE;
    private boolean mHasMore = true;

    PreviousMessageListQuery(BaseChannel channel) {
        this.mChannel = channel;
    }

    public boolean hasMore() {
        return this.mHasMore;
    }

    public synchronized boolean isLoading() {
        return this.mLoading;
    }

    synchronized void setLoading(boolean tf) {
        this.mLoading = tf;
    }

    public synchronized void load(int limit, boolean reverse, final MessageListQueryResult handler) {
        if (!this.hasMore()) {
            return;
        }
        if (this.isLoading()) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Query in progress.", 800170));
                    }
                });
            }
            return;
        }
        this.setLoading(true);
        APIClient.getInstance().messageList(this.mChannel instanceof OpenChannel, this.mChannel.getUrl(), this.mMessageTimestamp, limit, 0, false, reverse, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                PreviousMessageListQuery.this.setLoading(false);
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                JsonArray objs = result.get("messages").getAsJsonArray();
                final ArrayList<BaseMessage> messages = new ArrayList<BaseMessage>();
                for (int i = 0; i < objs.size(); ++i) {
                    BaseMessage msg = BaseMessage.build(objs.get(i), PreviousMessageListQuery.this.mChannel.getUrl(), PreviousMessageListQuery.this.mChannel.getType());
                    if (msg == null) continue;
                    messages.add(msg);
                    if (msg.getCreatedAt() > PreviousMessageListQuery.this.mMessageTimestamp) continue;
                    PreviousMessageListQuery.this.mMessageTimestamp = msg.getCreatedAt();
                }
                if (messages.size() <= 0) {
                    PreviousMessageListQuery.this.mHasMore = false;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(messages, null);
                        }
                    });
                }
            }
        });
    }

    public static interface MessageListQueryResult {
        public void onResult(List<BaseMessage> var1, SendBirdException var2);
    }
}

