/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import com.sendbird.android.APIClient;
import com.sendbird.android.AdminMessage;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.ChannelEvent;
import com.sendbird.android.Command;
import com.sendbird.android.CountDownTimer;
import com.sendbird.android.FileMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.Logger;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.ReadStatus;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.UserListQuery;
import com.sendbird.android.UserMessage;
import com.sendbird.android.WSClient;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SendBird {
    private static final String VERSION = "3.0.17";
    private static final int CMD_ACK_TIMEOUT = 10000;
    static final BuildConfig BUILD_CONFIG = BuildConfig.RELEASE;
    static final String DEBUG_WS_HOST;
    static final String DEBUG_API_HOST;
    static final String DEBUG_ROUTING_URL;
    private static SendBird sInstance;
    private static final Handler sUIThreadHandler;
    private final String mAppId;
    private final Context mAppContext;
    private String mPushToken;
    private WSClient mWSClient;
    private User mCurrentUser;
    private int mReconnectDelay = 0;
    private int mReconnectCount;
    private static final int INITIAL_DELAY = 0;
    private CountDownTimer mReconnectTimer;
    private CountDownTimer mLoginTimer;
    private CountDownTimer mGlobalTimer;
    private SendBirdException mLoginException;
    private final Object mLoginTimerObject = new Object();
    private final HashMap<String, HashMap<String, Object>> mAckStateMap = new HashMap();
    final ConcurrentHashMap<String, ChannelHandler> mChannelHandlers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConnectionHandler> mConnectionHandlers = new ConcurrentHashMap();
    private ApplicationStateHandler mApplicationStateHandler;
    private boolean mIsTrackingApplicationState = true;
    public static final int LOGGER_NONE = 0;
    public static final int LOGGER_INFO = 1;
    public static final String PUSH_TEMPLATE_DEFAULT = "default";
    public static final String PUSH_TEMPLATE_ALTERNATIVE = "alternative";

    public static String getOSVersion() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    public static String getSDKVersion() {
        return VERSION;
    }

    public static String getApplicationId() {
        return SendBird.getInstance().mAppId;
    }

    public static void setLoggerLevel(int level) {
        Logger.sLevel = level;
    }

    private SendBird(String appId, Context context) {
        this.mAppId = appId;
        this.mAppContext = context;
        if (Build.VERSION.SDK_INT >= 14 && context instanceof Application) {
            ((Application)context).registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                }

                public void onActivityStarted(Activity activity) {
                }

                public void onActivityResumed(Activity activity) {
                    if (SendBird.this.mApplicationStateHandler == null) {
                        return;
                    }
                    Logger.d("onActivityResumed: " + activity.getPackageName() + ":" + activity.getLocalClassName());
                    SendBird.this.mApplicationStateHandler.onActivityResumed();
                }

                public void onActivityPaused(Activity activity) {
                    if (SendBird.this.mApplicationStateHandler == null) {
                        return;
                    }
                    Logger.d("onActivityPaused: " + activity.getPackageName() + ":" + activity.getLocalClassName());
                    SendBird.this.mApplicationStateHandler.onActivityPaused();
                }

                public void onActivityStopped(Activity activity) {
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                }

                public void onActivityDestroyed(Activity activity) {
                }
            });
        }
    }

    private void startGlobalTimer() {
        if (this.mGlobalTimer != null) {
            this.mGlobalTimer.cancel();
            this.mGlobalTimer = null;
        }
        this.mGlobalTimer = new CountDownTimer(1000, 100, true);
        this.mGlobalTimer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){
            long tickCount = 0L;

            @Override
            public void onStart() {
            }

            @Override
            public void onStop() {
            }

            @Override
            public void onCancel() {
            }

            @Override
            public void onTimeout() {
            }

            @Override
            public void onTick(int timeout, int elapsed) {
                ++this.tickCount;
                if (this.tickCount % 10L == 0L && GroupChannel.sCachedChannels != null) {
                    for (final GroupChannel channel : GroupChannel.sCachedChannels.values()) {
                        channel.fireMarkAsRead();
                        if (!channel.invalidateTypingStatus()) continue;
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onTypingStatusUpdated(channel);
                                }
                            }
                        });
                    }
                }
                if (this.tickCount % 20L == 2L) {
                    // empty if block
                }
                if (this.tickCount % 50L == 2L) {
                    // empty if block
                }
            }
        });
        this.mGlobalTimer.start();
    }

    protected static void runOnUIThread(Runnable runnable) {
        if (sUIThreadHandler != null) {
            sUIThreadHandler.post(runnable);
        } else {
            runnable.run();
        }
    }

    protected static synchronized SendBird getInstance() {
        if (sInstance == null) {
            Logger.e("SendBird instance hasn't been initialized. Try SendBird.init().");
            throw new RuntimeException("SendBird instance hasn't been initialized.");
        }
        return sInstance;
    }

    protected static synchronized boolean isInitialized() {
        return sInstance != null;
    }

    public static synchronized void init(String appId, Context context) {
        if (sInstance == null) {
            sInstance = new SendBird(appId, context.getApplicationContext());
            APIClient.init();
        }
        SendBird.disconnect(true, null);
        if (SendBird.sInstance.mApplicationStateHandler != null) {
            SendBird.sInstance.mApplicationStateHandler.stop();
        }
        SendBird.sInstance.mIsTrackingApplicationState = true;
        SendBird.sInstance.mApplicationStateHandler = new ApplicationStateHandler(){
            boolean isBackground;
            boolean tryConnect;
            Handler handler;
            Thread thread = new Thread(){

                @Override
                public void run() {
                    Looper.prepare();
                    handler = new Handler();
                    Looper.loop();
                }
            };
            Runnable reconnectRunnable = new Runnable(){

                @Override
                public void run() {
                    if (isBackground) {
                        Logger.d("Application is on foreground.");
                        isBackground = false;
                        if (SendBird.getConnectionState() == ConnectionState.CLOSED && tryConnect && sInstance.mCurrentUser != null) {
                            boolean callStart = sInstance.mReconnectCount == 0;
                            sInstance.mReconnectDelay = 0;
                            sInstance.mReconnectCount = 0;
                            SendBird.reconnectWS(sInstance.mCurrentUser.getUserId(), callStart);
                        }
                    }
                }
            };
            Runnable disconnectRunnable = new Runnable(){

                @Override
                public void run() {
                    if (!isBackground) {
                        Logger.d("Application is on background.");
                        if (SendBird.getConnectionState() != ConnectionState.CLOSED || sInstance.mReconnectCount > 0) {
                            SendBird.disconnect(false, null);
                            tryConnect = true;
                        } else {
                            tryConnect = false;
                        }
                        isBackground = true;
                    }
                }
            };

            @Override
            void start() {
                this.thread.start();
            }

            @Override
            void stop() {
                if (this.handler != null && this.handler.getLooper() != null) {
                    this.handler.getLooper().quit();
                }
            }

            @Override
            public void onActivityResumed() {
                if (!SendBird.getAutoBackgroundDetection() || this.handler == null) {
                    return;
                }
                this.handler.removeCallbacksAndMessages(null);
                this.handler.post(this.reconnectRunnable);
            }

            @Override
            public void onActivityPaused() {
                if (!SendBird.getAutoBackgroundDetection() || this.handler == null) {
                    return;
                }
                this.handler.removeCallbacksAndMessages(null);
                this.handler.postDelayed(this.disconnectRunnable, 500L);
            }
        };
        SendBird.sInstance.mApplicationStateHandler.start();
    }

    public static void notifyActivityResumedForOldAndroids() {
        if (Build.VERSION.SDK_INT >= 14 || SendBird.getInstance().mApplicationStateHandler == null) {
            return;
        }
        SendBird.getInstance().mApplicationStateHandler.onActivityResumed();
    }

    public static void notifyActivityPausedForOldAndroids() {
        if (Build.VERSION.SDK_INT >= 14 || SendBird.getInstance().mApplicationStateHandler == null) {
            return;
        }
        SendBird.getInstance().mApplicationStateHandler.onActivityPaused();
    }

    public static void setAutoBackgroundDetection(boolean enable) {
        SendBird.getInstance().mIsTrackingApplicationState = enable;
    }

    public static boolean getAutoBackgroundDetection() {
        return SendBird.getInstance().mIsTrackingApplicationState;
    }

    public static ConnectionState getConnectionState() {
        if (!SendBird.isInitialized()) {
            return ConnectionState.CLOSED;
        }
        try {
            if (SendBird.getInstance().mWSClient == null) {
                return ConnectionState.CLOSED;
            }
            return SendBird.getInstance().mWSClient.getConnectionState();
        }
        catch (RuntimeException e) {
            return ConnectionState.CLOSED;
        }
    }

    public static void connect(String userId, ConnectHandler handler) {
        SendBird.connect(userId, null, handler);
    }

    public static void connect(String userId, String accessToken, final ConnectHandler handler) {
        User currentUser;
        if (userId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onConnected(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        if (SendBird.getConnectionState() != ConnectionState.CLOSED) {
            SendBird.disconnect(false, null);
        }
        if ((currentUser = SendBird.getCurrentUser()) == null || !currentUser.getUserId().equals(userId)) {
            if (currentUser != null && !currentUser.getUserId().equals(userId)) {
                SendBird.disconnect(true, null);
            }
            APIClient.getInstance().evictAllConnections();
            SendBird.connectWS(userId, accessToken, handler);
        } else {
            APIClient.getInstance().evictAllConnections();
            SendBird.connectWS(currentUser.getUserId(), null, handler);
        }
    }

    public static boolean reconnect() {
        if (SendBird.getCurrentUser() == null || APIClient.getInstance().getSessionKey() == null) {
            return false;
        }
        boolean callStart = SendBird.getInstance().mReconnectCount == 0;
        SendBird.disconnect(false, null);
        APIClient.getInstance().evictAllConnections();
        SendBird.reconnectWS(SendBird.getCurrentUser().getUserId(), callStart);
        return true;
    }

    public static void addChannelHandler(String identifier, ChannelHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        SendBird.getInstance().mChannelHandlers.put(identifier, handler);
    }

    public static ChannelHandler removeChannelHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return SendBird.getInstance().mChannelHandlers.remove(identifier);
    }

    public static void removeAllChannelHandlers() {
        SendBird.getInstance().mChannelHandlers.clear();
    }

    public static void addConnectionHandler(String identifier, ConnectionHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        SendBird.getInstance().mConnectionHandlers.put(identifier, handler);
    }

    public static ConnectionHandler removeConnectionHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return SendBird.getInstance().mConnectionHandlers.remove(identifier);
    }

    public static void removeAllConnectionHandlers() {
        SendBird.getInstance().mConnectionHandlers.clear();
    }

    private static synchronized void reconnectWS(final String userId, boolean callStart) {
        final SendBird I = SendBird.getInstance();
        I.mReconnectDelay = Math.min(I.mReconnectDelay, 300000);
        ++I.mReconnectCount;
        if (I.mReconnectCount == 1 && callStart) {
            Logger.d("Reconnect Started.");
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    for (ConnectionHandler handler : I.mConnectionHandlers.values()) {
                        handler.onReconnectStarted();
                    }
                }
            });
        }
        if (I.mReconnectCount <= 5) {
            if (I.mReconnectTimer == null) {
                I.mReconnectTimer = new CountDownTimer(I.mReconnectDelay, I.mReconnectDelay == 0 ? 0 : 1000);
                I.mReconnectTimer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){

                    @Override
                    public void onStart() {
                        Logger.d("ReconnectTimer start.");
                    }

                    @Override
                    public void onStop() {
                        I.mReconnectTimer = null;
                        Logger.d("ReconnectTimer stop.");
                    }

                    @Override
                    public void onCancel() {
                        I.mReconnectTimer = null;
                        Logger.d("ReconnectTimer cancel.");
                    }

                    @Override
                    public void onTimeout() {
                        I.mReconnectTimer = null;
                        Logger.d("ReconnectTimer timeout. Try to reconnect...");
                        if (I.mWSClient != null) {
                            I.mWSClient.disconnect();
                            I.mWSClient = null;
                        }
                        I.mWSClient = new WSClient();
                        I.mWSClient.setEventHandler(new WSClient.WSClientHandler(){

                            @Override
                            public void onReady() {
                                Logger.d("WS Ready.");
                                I.mWSClient.connect();
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void onOpen() {
                                Logger.d("WS Open.");
                                Object object = I.mLoginTimerObject;
                                synchronized (object) {
                                    this.startLoginTimer();
                                }
                            }

                            private void startLoginTimer() {
                                I.mLoginTimer = new CountDownTimer(10000, 100);
                                I.mLoginTimer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){
                                    private boolean timeout;

                                    @Override
                                    public void onStart() {
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void onStop() {
                                        if (this.timeout) {
                                            Logger.d("Reconnect login timer failed.");
                                            SendBird.disconnect(false, null);
                                            if (I.mConnectionHandlers.size() > 0) {
                                                SendBird.runOnUIThread(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        for (ConnectionHandler handler : I.mConnectionHandlers.values()) {
                                                            handler.onReconnectFailed();
                                                        }
                                                    }
                                                });
                                            }
                                        } else {
                                            Logger.d("Reconnect login timer succeeded.");
                                            I.mReconnectDelay = 0;
                                            I.mReconnectCount = 0;
                                            Collection<OpenChannel> enteredOpenChannels = OpenChannel.getEnteredChannels();
                                            final AtomicBoolean errorOnEnter = new AtomicBoolean(false);
                                            if (enteredOpenChannels.size() > 0) {
                                                Logger.d("Enter open channels: " + enteredOpenChannels.size());
                                                final CountDownLatch latch = new CountDownLatch(enteredOpenChannels.size());
                                                for (OpenChannel channel : OpenChannel.getEnteredChannels()) {
                                                    channel.enter(new OpenChannel.OpenChannelEnterHandler(){

                                                        @Override
                                                        public void onResult(SendBirdException e) {
                                                            if (e != null) {
                                                                Logger.d(e);
                                                                errorOnEnter.set(true);
                                                            }
                                                            latch.countDown();
                                                        }
                                                    });
                                                }
                                                try {
                                                    latch.await();
                                                }
                                                catch (InterruptedException e) {
                                                    errorOnEnter.set(true);
                                                }
                                                if (errorOnEnter.get()) {
                                                    Logger.d("Error on enter: true");
                                                    SendBird.disconnect(false, null);
                                                } else {
                                                    Logger.d("Error on enter: false");
                                                }
                                                if (I.mConnectionHandlers.size() > 0) {
                                                    SendBird.runOnUIThread(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            for (ConnectionHandler handler : I.mConnectionHandlers.values()) {
                                                                if (errorOnEnter.get()) {
                                                                    handler.onReconnectFailed();
                                                                    continue;
                                                                }
                                                                handler.onReconnectSucceeded();
                                                            }
                                                        }
                                                    });
                                                }
                                            } else {
                                                Logger.d("No open channels to enter.");
                                                if (I.mConnectionHandlers.size() > 0) {
                                                    SendBird.runOnUIThread(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            for (ConnectionHandler handler : I.mConnectionHandlers.values()) {
                                                                handler.onReconnectSucceeded();
                                                            }
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                        Object object = I.mLoginTimerObject;
                                        synchronized (object) {
                                            I.mLoginTimer = null;
                                        }
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void onCancel() {
                                        Logger.d("Reconnect login timer canceled.");
                                        Object object = I.mLoginTimerObject;
                                        synchronized (object) {
                                            I.mLoginTimer = null;
                                        }
                                    }

                                    @Override
                                    public void onTimeout() {
                                        this.timeout = true;
                                    }

                                    @Override
                                    public void onTick(int timeout, int elapsed) {
                                    }
                                });
                                I.mLoginTimer.start();
                            }

                            @Override
                            public void onClose() {
                                Logger.d("WS onClose.");
                            }

                            @Override
                            public void onMessage(String message) {
                                Logger.d("WS onMessage: " + message);
                                I.messageReceived(message);
                            }

                            @Override
                            public void onError(SendBirdException e) {
                                Logger.d("WS onError.");
                                Logger.d(e);
                                APIClient.getInstance().cancelAllRequests();
                                APIClient.getInstance().evictAllConnections();
                                SendBird.reconnectWS(userId, I.mReconnectCount == 0);
                            }
                        });
                        I.mWSClient.initWebSocket(userId, null);
                    }

                    @Override
                    public void onTick(int timeout, int elapsed) {
                        Logger.d("ReconnectTimer Tick: " + (timeout - elapsed));
                    }
                });
                I.mReconnectTimer.start();
            } else {
                Logger.d("Reconnecting is in progress.");
            }
            I.mReconnectDelay = I.mReconnectDelay == 0 ? 3000 : (I.mReconnectDelay *= 2);
        } else {
            Logger.d("Reconnect Failed.");
            SendBird.disconnect(false, null);
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    for (ConnectionHandler handler : I.mConnectionHandlers.values()) {
                        handler.onReconnectFailed();
                    }
                }
            });
        }
    }

    private static void connectWS(final String userId, String accessToken, final ConnectHandler handler) {
        final SendBird I = SendBird.getInstance();
        if (I.mWSClient != null) {
            I.mWSClient.disconnect();
            I.mWSClient = null;
            I.mReconnectDelay = 0;
            I.mReconnectCount = 0;
        }
        I.mWSClient = new WSClient();
        I.mWSClient.setEventHandler(new WSClient.WSClientHandler(){
            private boolean isOpened;

            @Override
            public void onReady() {
                Logger.d("WS Ready.");
                I.mWSClient.connect();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOpen() {
                Logger.d("WS Open.");
                this.isOpened = true;
                Object object = I.mLoginTimerObject;
                synchronized (object) {
                    I.mLoginTimer = new CountDownTimer(10000, 100);
                    I.mLoginTimer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){
                        private boolean timeout;

                        @Override
                        public void onStart() {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onStop() {
                            int errCode;
                            String errMsg;
                            boolean loginException;
                            Object object = I.mLoginTimerObject;
                            synchronized (object) {
                                boolean bl = loginException = I.mLoginException != null;
                                if (loginException) {
                                    errMsg = I.mLoginException.getMessage();
                                    errCode = I.mLoginException.getCode();
                                } else {
                                    errMsg = "";
                                    errCode = 0;
                                }
                            }
                            if (this.timeout) {
                                Logger.d("Connect login timer failed.");
                                SendBird.disconnect(true, null);
                                if (handler != null) {
                                    SendBird.runOnUIThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            handler.onConnected(null, new SendBirdException("Login timeout.", 800190));
                                        }
                                    });
                                }
                            } else if (loginException) {
                                Logger.d("Connect login failed.");
                                SendBird.disconnect(true, null);
                                if (handler != null) {
                                    SendBird.runOnUIThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            handler.onConnected(null, new SendBirdException(errMsg, errCode));
                                        }
                                    });
                                }
                            } else {
                                Logger.d("Connect login timer succeeded.");
                                I.mReconnectDelay = 0;
                                I.mReconnectCount = 0;
                                I.startGlobalTimer();
                                if (handler != null) {
                                    SendBird.runOnUIThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            handler.onConnected(I.mCurrentUser, null);
                                        }
                                    });
                                }
                            }
                            object = I.mLoginTimerObject;
                            synchronized (object) {
                                I.mLoginTimer = null;
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onCancel() {
                            Logger.d("Connect login timer canceled.");
                            Object object = I.mLoginTimerObject;
                            synchronized (object) {
                                I.mLoginTimer = null;
                            }
                        }

                        @Override
                        public void onTimeout() {
                            this.timeout = true;
                        }

                        @Override
                        public void onTick(int timeout, int elapsed) {
                        }
                    });
                    I.mLoginTimer.start();
                    I.mLoginException = null;
                }
            }

            @Override
            public void onClose() {
                Logger.d("WS Close.");
            }

            @Override
            public void onMessage(String message) {
                Logger.d("WS Received: " + message);
                I.messageReceived(message);
            }

            @Override
            public void onError(final SendBirdException e) {
                Logger.d("WS Error.");
                Logger.d(e);
                if (!this.isOpened) {
                    SendBird.disconnect(true, null);
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onConnected(null, e);
                            }
                        });
                    }
                    return;
                }
                APIClient.getInstance().cancelAllRequests();
                APIClient.getInstance().evictAllConnections();
                SendBird.reconnectWS(userId, I.mReconnectCount == 0);
            }
        });
        I.mWSClient.initWebSocket(userId, accessToken);
    }

    public static void disconnect(DisconnectHandler handler) {
        SendBird.disconnect(true, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void disconnect(boolean logout, final DisconnectHandler handler) {
        Logger.d("Disconnect.");
        SendBird I = SendBird.getInstance();
        I.mReconnectDelay = 0;
        I.mReconnectCount = 0;
        Iterator<HashMap<String, Object>> iterator = I.mLoginTimerObject;
        synchronized (iterator) {
            if (I.mLoginTimer != null) {
                I.mLoginTimer.cancel();
                I.mLoginTimer = null;
            }
        }
        if (I.mReconnectTimer != null) {
            I.mReconnectTimer.cancel();
            I.mReconnectTimer = null;
        }
        if (I.mWSClient != null) {
            I.mWSClient.disconnect();
            I.mWSClient = null;
        }
        APIClient.getInstance().cancelAllRequests();
        if (logout) {
            Logger.d("Clear local data.");
            if (I.mGlobalTimer != null) {
                I.mGlobalTimer.cancel();
                I.mGlobalTimer = null;
            }
            for (HashMap<String, Object> map : I.mAckStateMap.values()) {
                CountDownTimer timer = (CountDownTimer)map.get("timer");
                if (timer == null) continue;
                timer.cancel();
            }
            I.mAckStateMap.clear();
            if (I.mCurrentUser != null) {
                I.mCurrentUser = null;
            }
            APIClient.getInstance().setSessionKey("");
            OpenChannel.clearEnteredChannels();
            OpenChannel.clearCache();
            GroupChannel.clearCache();
        }
        if (handler != null) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    handler.onDisconnected();
                }
            });
        }
    }

    public static User getCurrentUser() {
        return SendBird.getInstance().mCurrentUser;
    }

    public static UserListQuery createUserListQuery() {
        return new UserListQuery(UserListQuery.QueryType.ALL_USER);
    }

    public static UserListQuery createUserListQuery(List<String> userIds) {
        return new UserListQuery(UserListQuery.QueryType.FILTERED_USER, userIds);
    }

    public static UserListQuery createBlockedUserListQuery() {
        return new UserListQuery(UserListQuery.QueryType.BLOCKED_USER);
    }

    public static void updateCurrentUserInfoWithProfileImage(String nickname, File profileImage, final UserInfoUpdateHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUpdated(new SendBirdException("Connection must be made before you update user information.", 800101));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().updateUserInfo(SendBird.getCurrentUser().getUserId(), nickname, profileImage, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUpdated(e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                User user = SendBird.getCurrentUser();
                if (obj.has("nickname")) {
                    user.setNickname(obj.get("nickname").getAsString());
                }
                if (obj.has("profile_url")) {
                    user.setProfileUrl(obj.get("profile_url").getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUpdated(null);
                        }
                    });
                }
            }
        });
    }

    public static void updateCurrentUserInfo(String nickname, String profileUrl, final UserInfoUpdateHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUpdated(new SendBirdException("Connection must be made before you update user information.", 800101));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().updateUserInfo(SendBird.getCurrentUser().getUserId(), nickname, profileUrl, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUpdated(e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                User user = SendBird.getCurrentUser();
                if (obj.has("nickname")) {
                    user.setNickname(obj.get("nickname").getAsString());
                }
                if (obj.has("profile_url")) {
                    user.setProfileUrl(obj.get("profile_url").getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUpdated(null);
                        }
                    });
                }
            }
        });
    }

    public static String getPendingPushToken() {
        return SendBird.getInstance().mPushToken;
    }

    @Deprecated
    public static void registerPushTokenForCurrentUser(String gcmRegToken, final RegisterPushTokenHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onRegistered(new SendBirdException("Connection must be made before you register push token.", 800101));
                    }
                });
            }
            return;
        }
        if (gcmRegToken == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onRegistered(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().registerPushToken(SendBird.getCurrentUser().getUserId(), gcmRegToken, false, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onRegistered(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onRegistered(null);
                        }
                    });
                }
            }
        });
    }

    public static void registerPushTokenForCurrentUser(String gcmRegToken, RegisterPushTokenWithStatusHandler handler) {
        SendBird.registerPushTokenForCurrentUser(gcmRegToken, false, handler);
    }

    public static void registerPushTokenForCurrentUser(String gcmRegToken, boolean unique, final RegisterPushTokenWithStatusHandler handler) {
        if (gcmRegToken == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onRegistered(PushTokenRegistrationStatus.ERROR, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        if (SendBird.getCurrentUser() == null) {
            SendBird.getInstance().mPushToken = gcmRegToken;
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onRegistered(PushTokenRegistrationStatus.PENDING, null);
                    }
                });
            }
            return;
        }
        APIClient.getInstance().registerPushToken(SendBird.getCurrentUser().getUserId(), gcmRegToken, unique, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onRegistered(PushTokenRegistrationStatus.ERROR, e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.getInstance().mPushToken = null;
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onRegistered(PushTokenRegistrationStatus.SUCCESS, null);
                        }
                    });
                }
            }
        });
    }

    public static void unregisterPushTokenForCurrentUser(String gcmRegToken, final UnregisterPushTokenHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnregistered(new SendBirdException("Connection must be made before you unregister push token.", 800101));
                    }
                });
            }
            return;
        }
        if (gcmRegToken == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnregistered(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().unregisterPushToken(SendBird.getCurrentUser().getUserId(), gcmRegToken, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUnregistered(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUnregistered(null);
                        }
                    });
                }
            }
        });
    }

    public static void unregisterPushTokenAllForCurrentUser(final UnregisterPushTokenHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnregistered(new SendBirdException("Connection must be made before you unregister all push token.", 800101));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().unregisterPushTokenAll(SendBird.getCurrentUser().getUserId(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUnregistered(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUnregistered(null);
                        }
                    });
                }
            }
        });
    }

    public static void setDoNotDisturb(boolean doNotDisturbOn, int startHour, int startMin, int endHour, int endMin, String timezone, final SetDoNotDisturbHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Connection must be made before you set do-not-disturb.", 800101));
                    }
                });
            }
            return;
        }
        if (startHour < 0 || startHour > 23 || startMin < 0 || startMin > 59 || endHour < 0 || endHour > 23 || endMin < 0 || endMin > 59) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().setDoNotDisturb(SendBird.getCurrentUser().getUserId(), doNotDisturbOn, startHour, startMin, endHour, endMin, timezone, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void getDoNotDisturb(final GetDoNotDisturbHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(false, 0, 0, 0, 0, null, new SendBirdException("Connection must be made before you get do-not-disturb setting.", 800101));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().getDoNotDisturb(SendBird.getCurrentUser().getUserId(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(false, 0, 0, 0, 0, null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                final boolean isDisturbOn = obj.get("do_not_disturb").getAsBoolean();
                final int startHour = obj.get("start_hour").getAsInt();
                final int startMin = obj.get("start_min").getAsInt();
                final int endHour = obj.get("end_hour").getAsInt();
                final int endMin = obj.get("end_min").getAsInt();
                final String timezone = obj.get("timezone").getAsString();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(isDisturbOn, startHour, startMin, endHour, endMin, timezone, null);
                        }
                    });
                }
            }
        });
    }

    public static void setPushTemplate(String templateName, final SetPushTemplateHandler handler) {
        if (templateName == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Connection must be made before you set do-not-disturb.", 800101));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().setPushTemplate(SendBird.getCurrentUser().getUserId(), templateName, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (e != null) {
                                handler.onResult(e);
                            } else {
                                handler.onResult(null);
                            }
                        }
                    });
                }
            }
        });
    }

    public static void getPushTemplate(final GetPushTemplateHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Connection must be made before you set do-not-disturb.", 800101));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().getPushTemplate(SendBird.getCurrentUser().getUserId(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final String name = response.getAsJsonObject().get("name").getAsString();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(name, null);
                        }
                    });
                }
            }
        });
    }

    public static void blockUser(User userToBlock, final UserBlockHandler handler) {
        if (userToBlock == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onBlocked(null, new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.blockUserWithUserId(userToBlock.getUserId(), handler);
    }

    public static void blockUserWithUserId(String userIdToBlock, final UserBlockHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onBlocked(null, new SendBirdException("Connection must be made before you block a user.", 800101));
                    }
                });
            }
            return;
        }
        if (userIdToBlock == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onBlocked(null, new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().blockUser(SendBird.getCurrentUser().getUserId(), userIdToBlock, new APIClient.APIClientHandler(){

            @Override
            public void onResult(final JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onBlocked(null, e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onBlocked(new User(response), null);
                        }
                    });
                }
            }
        });
    }

    public static void unblockUser(User blockedUser, final UserUnblockHandler handler) {
        if (blockedUser == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnblocked(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.unblockUserWithUserId(blockedUser.getUserId(), handler);
    }

    public static void unblockUserWithUserId(String blockedUserId, final UserUnblockHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnblocked(new SendBirdException("Connection must be made before you unblock a user.", 800101));
                    }
                });
            }
            return;
        }
        if (blockedUserId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnblocked(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().unblockUser(SendBird.getCurrentUser().getUserId(), blockedUserId, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUnblocked(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUnblocked(null);
                        }
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageReceived(String message) {
        Command cmd = new Command(message);
        Logger.d(cmd.getRequestId() + ":" + cmd.getCommand() + ":" + cmd.getPayload());
        if (cmd.hasRequestId()) {
            HashMap<String, Object> ackInfo = this.getAckInfo(cmd.getRequestId());
            if (ackInfo == null) {
                return;
            }
            CountDownTimer timer = (CountDownTimer)ackInfo.get("timer");
            Command.SendCommandHandler handler = (Command.SendCommandHandler)ackInfo.get("handler");
            if (timer != null) {
                timer.stop();
            }
            if (handler != null) {
                switch (cmd.getCommand()) {
                    case "EROR": {
                        JsonObject error = cmd.getJsonElement().getAsJsonObject();
                        int errCode = error.get("code").getAsInt();
                        String errMessage = error.get("message").getAsString();
                        handler.onResult(cmd, new SendBirdException(errMessage, errCode));
                        break;
                    }
                    case "MESG": 
                    case "FILE": {
                        final BaseMessage msg = cmd.getCommand().equals("MESG") ? new UserMessage(cmd.getJsonElement()) : new FileMessage(cmd.getJsonElement());
                        if (msg.isGroupChannel()) {
                            GroupChannel.getChannel(msg.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                                @Override
                                public void onResult(final GroupChannel channel, SendBirdException e) {
                                    if (e == null) {
                                        channel.setLastMessage(msg);
                                        SendBird.runOnUIThread(new Runnable(){

                                            @Override
                                            public void run() {
                                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                                    handler.onChannelChanged(channel);
                                                }
                                            }
                                        });
                                    }
                                }
                            });
                        }
                        handler.onResult(cmd, null);
                        break;
                    }
                    default: {
                        handler.onResult(cmd, null);
                    }
                }
            }
            return;
        }
        block26 : switch (cmd.getCommand()) {
            case "LOGI": {
                Object handler = this.mLoginTimerObject;
                synchronized (handler) {
                    if (this.mLoginTimer != null) {
                        JsonObject obj = cmd.getJsonElement().getAsJsonObject();
                        if (obj.getAsJsonObject().has("error") && obj.getAsJsonObject().get("error").isJsonPrimitive() && obj.getAsJsonObject().get("error").getAsBoolean()) {
                            String errMsg = "";
                            int errCode = 0;
                            if (obj.getAsJsonObject().has("message") && obj.getAsJsonObject().get("message").isJsonPrimitive()) {
                                errMsg = obj.getAsJsonObject().get("message").getAsString();
                            }
                            if (obj.getAsJsonObject().has("code") && obj.getAsJsonObject().get("code").isJsonPrimitive()) {
                                errCode = obj.getAsJsonObject().get("code").getAsInt();
                            }
                            this.mLoginException = new SendBirdException(errMsg, errCode);
                        } else {
                            if (obj.has("key")) {
                                APIClient.getInstance().setSessionKey(obj.get("key").getAsString());
                            }
                            if (obj.has("user_id")) {
                                SendBird.getInstance().mCurrentUser = new User(cmd.getJsonElement());
                            }
                            this.mLoginException = null;
                        }
                        this.mLoginTimer.stop();
                    }
                    break;
                }
            }
            case "MESG": 
            case "FILE": 
            case "BRDM": 
            case "ADMM": {
                BaseMessage msg;
                switch (cmd.getCommand()) {
                    case "MESG": {
                        msg = new UserMessage(cmd.getJsonElement());
                        break;
                    }
                    case "FILE": {
                        msg = new FileMessage(cmd.getJsonElement());
                        break;
                    }
                    case "BRDM": 
                    case "ADMM": {
                        msg = new AdminMessage(cmd.getJsonElement());
                        break;
                    }
                    default: {
                        Logger.d("Discard a command: " + cmd.getCommand());
                        return;
                    }
                }
                if (msg.isGroupChannel()) {
                    GroupChannel.getChannel(msg.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                        @Override
                        public void onResult(final GroupChannel channel, SendBirdException e) {
                            boolean callChannelChanged;
                            if (e != null) {
                                Logger.d("Discard a command.");
                                return;
                            }
                            String userId = null;
                            if (msg instanceof UserMessage) {
                                userId = ((UserMessage)msg).getSender().getUserId();
                            } else if (msg instanceof FileMessage) {
                                userId = ((FileMessage)msg).getSender().getUserId();
                            }
                            if (!(msg instanceof AdminMessage) || !((AdminMessage)msg).isSilent()) {
                                channel.setLastMessage(msg);
                                if (userId == null || !userId.equals(SendBird.getCurrentUser().getUserId())) {
                                    channel.setUnreadMessageCount(channel.getUnreadMessageCount() + 1);
                                }
                                callChannelChanged = true;
                            } else {
                                callChannelChanged = false;
                            }
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        handler.onMessageReceived(channel, msg);
                                        if (!callChannelChanged) continue;
                                        handler.onChannelChanged(channel);
                                    }
                                }
                            });
                        }
                    });
                    break;
                }
                OpenChannel.getChannel(msg.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                    @Override
                    public void onResult(final OpenChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command.");
                            return;
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onMessageReceived(channel, msg);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case "READ": {
                final ReadStatus rst = new ReadStatus(cmd.getJsonElement());
                GroupChannel.getChannel(rst.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        boolean callChannelChanged;
                        boolean readFromMyself;
                        if (e != null) {
                            Logger.d("Discard a command. ");
                            return;
                        }
                        channel.updateReadReceipt(rst.getReader().getUserId(), rst.getTimestamp());
                        boolean bl = readFromMyself = SendBird.getCurrentUser() != null && rst.getReader().getUserId().equals(SendBird.getCurrentUser().getUserId());
                        if (readFromMyself && channel.getUnreadMessageCount() > 0) {
                            callChannelChanged = true;
                            channel.setUnreadMessageCount(0);
                        } else {
                            callChannelChanged = false;
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (!readFromMyself) {
                                        handler.onReadReceiptUpdated(channel);
                                    }
                                    if (!callChannelChanged) continue;
                                    handler.onChannelChanged(channel);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case "TPST": 
            case "TPEN": {
                break;
            }
            case "MTIO": {
                break;
            }
            case "SYEV": {
                this.processChannelEvent(cmd);
                break;
            }
            case "DELM": {
                JsonObject obj = cmd.getJsonElement().getAsJsonObject();
                String channelType = obj.get("channel_type").getAsString();
                String channelUrl = obj.get("channel_url").getAsString();
                final long msgId = obj.get("msg_id").getAsLong();
                switch (channelType) {
                    case "open": {
                        OpenChannel.getChannel(channelUrl, new OpenChannel.OpenChannelGetHandler(){

                            @Override
                            public void onResult(final OpenChannel channel, SendBirdException e) {
                                if (e != null) {
                                    Logger.d("Discard a command.");
                                    return;
                                }
                                SendBird.runOnUIThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                            handler.onMessageDeleted(channel, msgId);
                                        }
                                    }
                                });
                            }
                        });
                        break block26;
                    }
                    case "group": {
                        GroupChannel.getChannel(channelUrl, new GroupChannel.GroupChannelGetHandler(){

                            @Override
                            public void onResult(final GroupChannel channel, SendBirdException e) {
                                if (e != null) {
                                    Logger.d("Discard a command.");
                                    return;
                                }
                                SendBird.runOnUIThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                            handler.onMessageDeleted(channel, msgId);
                                        }
                                    }
                                });
                            }
                        });
                        break block26;
                    }
                }
                Logger.d("Discard a command.");
                return;
            }
            case "LEAV": {
                break;
            }
            case "JOIN": {
                break;
            }
            default: {
                Logger.d("Discard a command: " + cmd.getCommand());
            }
        }
    }

    private void processChannelEvent(final Command cmd) {
        final ChannelEvent event = new ChannelEvent(cmd.getJsonElement());
        switch (event.getCategory()) {
            case 10000: 
            case 10001: {
                GroupChannel.getChannel(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        final User user = new User(event.getData());
                        if (event.getCategory() == 10000) {
                            channel.addMember(user);
                        } else {
                            channel.removeMember(user);
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (event.getCategory() == 10000) {
                                        handler.onUserJoined(channel, user);
                                        continue;
                                    }
                                    handler.onUserLeft(channel, user);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10900: 
            case 10901: {
                GroupChannel.getChannel(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        User user = new User(event.getData());
                        if (event.getCategory() == 10900) {
                            channel.updateTypingStatus(user, true);
                        } else {
                            channel.updateTypingStatus(user, false);
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onTypingStatusUpdated(channel);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10102: 
            case 10103: {
                OpenChannel.getChannel(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                    @Override
                    public void onResult(final OpenChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        JsonObject obj = event.getData().getAsJsonObject();
                        if (obj.has("participant_count")) {
                            channel.setParticipantCount(obj.get("participant_count").getAsInt());
                        }
                        final User user = new User(event.getData());
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (event.getCategory() == 10102) {
                                        handler.onUserEntered(channel, user);
                                        continue;
                                    }
                                    handler.onUserExited(channel, user);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10200: 
            case 10201: {
                OpenChannel.getChannel(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                    @Override
                    public void onResult(final OpenChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        final User user = new User(event.getData());
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (event.getCategory() == 10201) {
                                        handler.onUserMuted(channel, user);
                                        continue;
                                    }
                                    handler.onUserUnmuted(channel, user);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10600: 
            case 10601: {
                OpenChannel.getChannel(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                    @Override
                    public void onResult(final OpenChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        final User user = new User(event.getData());
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (event.getCategory() == 10601) {
                                        handler.onUserBanned(channel, user);
                                        continue;
                                    }
                                    handler.onUserUnbanned(channel, user);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10700: 
            case 10701: {
                OpenChannel.getChannel(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                    @Override
                    public void onResult(final OpenChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (event.getCategory() == 10701) {
                                        handler.onChannelFrozen(channel);
                                        continue;
                                    }
                                    handler.onChannelUnfrozen(channel);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 11000: {
                if (event.isOpenChannel()) {
                    OpenChannel.getChannelWithoutCache(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                        @Override
                        public void onResult(final OpenChannel channel, SendBirdException e) {
                            if (e != null) {
                                Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                                return;
                            }
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        handler.onChannelChanged(channel);
                                    }
                                }
                            });
                        }
                    });
                    break;
                }
                GroupChannel.getChannelWithoutCache(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onChannelChanged(channel);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 12000: {
                final String channelUrl = event.getChannelUrl();
                if (event.isOpenChannel()) {
                    OpenChannel.removeChannelFromCache(event.getChannelUrl());
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                handler.onChannelDeleted(channelUrl, BaseChannel.ChannelType.OPEN);
                            }
                        }
                    });
                    break;
                }
                GroupChannel.removeChannelFromCache(event.getChannelUrl());
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                            handler.onChannelDeleted(channelUrl, BaseChannel.ChannelType.GROUP);
                        }
                    }
                });
            }
        }
    }

    void sendCommand(final Command cmd, final Command.SendCommandHandler handler) {
        if (this.mWSClient == null || this.mWSClient.getConnectionState() != ConnectionState.OPEN) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("WS connection closed.", 800200));
            }
            return;
        }
        if (cmd.isAckRequired()) {
            this.startAckTimer(cmd, handler);
            this.mWSClient.send(cmd, new WSClient.WSClientSendHandler(){

                @Override
                public void onResult(SendBirdException e) {
                    if (e != null) {
                        HashMap ackInfo = SendBird.this.getAckInfo(cmd.getRequestId());
                        if (ackInfo != null) {
                            CountDownTimer timer = (CountDownTimer)ackInfo.get("timer");
                            Command.SendCommandHandler handler2 = (Command.SendCommandHandler)ackInfo.get("handler");
                            timer.stop();
                        }
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                }
            });
        } else {
            this.mWSClient.send(cmd, new WSClient.WSClientSendHandler(){

                @Override
                public void onResult(SendBirdException e) {
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    if (handler != null) {
                        handler.onResult(null, null);
                    }
                }
            });
        }
    }

    private void startAckTimer(Command command, final Command.SendCommandHandler handler) {
        final String reqId = command.getRequestId();
        CountDownTimer timer = new CountDownTimer(10000, 100);
        timer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){

            @Override
            public void onStart() {
            }

            @Override
            public void onStop() {
                SendBird.this.mAckStateMap.remove(reqId);
            }

            @Override
            public void onCancel() {
                SendBird.this.mAckStateMap.remove(reqId);
            }

            @Override
            public void onTimeout() {
                handler.onResult(null, new SendBirdException("Command received no ack.", 800180));
            }

            @Override
            public void onTick(int timeout, int elapsed) {
            }
        });
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("handler", handler);
        map.put("timer", timer);
        this.mAckStateMap.put(reqId, map);
        timer.start();
    }

    private HashMap<String, Object> getAckInfo(String requestId) {
        return this.mAckStateMap.get(requestId);
    }

    static {
        if (BUILD_CONFIG == BuildConfig.DEBUG) {
            DEBUG_WS_HOST = "ws://10.0.2.2:9700";
            DEBUG_API_HOST = "http://10.0.2.2:9800/api";
            DEBUG_ROUTING_URL = "http://10.0.2.2:9800/api/routing/%s";
        } else {
            DEBUG_WS_HOST = "ws://ws-intoz.sendbird.com:9700";
            DEBUG_API_HOST = "http://api-intoz.sendbird.com:9800";
            DEBUG_ROUTING_URL = "http://api-intoz.sendbird.com:9800/routing/%s";
        }
        sUIThreadHandler = new Handler(Looper.getMainLooper());
    }

    private static abstract class ApplicationStateHandler {
        private ApplicationStateHandler() {
        }

        abstract void start();

        abstract void stop();

        abstract void onActivityResumed();

        abstract void onActivityPaused();
    }

    public static interface UserUnblockHandler {
        public void onUnblocked(SendBirdException var1);
    }

    public static interface UserBlockHandler {
        public void onBlocked(User var1, SendBirdException var2);
    }

    public static interface UserInfoUpdateHandler {
        public void onUpdated(SendBirdException var1);
    }

    public static interface GetPushTemplateHandler {
        public void onResult(String var1, SendBirdException var2);
    }

    public static interface SetPushTemplateHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetDoNotDisturbHandler {
        public void onResult(boolean var1, int var2, int var3, int var4, int var5, String var6, SendBirdException var7);
    }

    public static interface SetDoNotDisturbHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface UnregisterPushTokenHandler {
        public void onUnregistered(SendBirdException var1);
    }

    public static interface RegisterPushTokenWithStatusHandler {
        public void onRegistered(PushTokenRegistrationStatus var1, SendBirdException var2);
    }

    @Deprecated
    public static interface RegisterPushTokenHandler {
        @Deprecated
        public void onRegistered(SendBirdException var1);
    }

    public static enum PushTokenRegistrationStatus {
        SUCCESS,
        PENDING,
        ERROR;

    }

    public static interface DisconnectHandler {
        public void onDisconnected();
    }

    public static interface ConnectionHandler {
        public void onReconnectStarted();

        public void onReconnectSucceeded();

        public void onReconnectFailed();
    }

    public static abstract class ChannelHandler {
        public abstract void onMessageReceived(BaseChannel var1, BaseMessage var2);

        public void onMessageDeleted(BaseChannel channel, long msgId) {
        }

        public void onChannelChanged(BaseChannel channel) {
        }

        public void onChannelDeleted(String channelUrl, BaseChannel.ChannelType channelType) {
        }

        public void onReadReceiptUpdated(GroupChannel channel) {
        }

        public void onTypingStatusUpdated(GroupChannel channel) {
        }

        public void onUserJoined(GroupChannel channel, User user) {
        }

        public void onUserLeft(GroupChannel channel, User user) {
        }

        public void onUserEntered(OpenChannel channel, User user) {
        }

        public void onUserExited(OpenChannel channel, User user) {
        }

        public void onUserMuted(OpenChannel channel, User user) {
        }

        public void onUserUnmuted(OpenChannel channel, User user) {
        }

        public void onUserBanned(OpenChannel channel, User user) {
        }

        public void onUserUnbanned(OpenChannel channel, User user) {
        }

        public void onChannelFrozen(OpenChannel channel) {
        }

        public void onChannelUnfrozen(OpenChannel channel) {
        }
    }

    public static interface ConnectHandler {
        public void onConnected(User var1, SendBirdException var2);
    }

    static enum BuildConfig {
        DEBUG,
        CI,
        RELEASE;

    }

    public static enum ConnectionState {
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

