/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android.utils;

import com.sendbird.android.log.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class CancelableThreadHolder {
    private ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();
    private CountDownLatch countDownLatch;
    private final AtomicBoolean interrupted = new AtomicBoolean(false);
    private final AtomicBoolean isWaiting = new AtomicBoolean(false);
    private final List<Future<?>> jobList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sleep(long millis) throws InterruptedException {
        if (this.interrupted.getAndSet(false)) {
            throw new InterruptedException("CancelableThreadHolder thread has been interrupted");
        }
        if (this.isWaiting.getAndSet(true)) {
            return;
        }
        try {
            this.countDownLatch = new CountDownLatch(1);
            List<Future<?>> list = this.jobList;
            synchronized (list) {
                this.jobList.add(this.timer.schedule(new Runnable(){

                    @Override
                    public void run() {
                        Logger.d("__ timeout : " + CancelableThreadHolder.this.jobList.size());
                        CancelableThreadHolder.this.interrupted.set(false);
                        if (CancelableThreadHolder.this.countDownLatch != null) {
                            CancelableThreadHolder.this.countDownLatch.countDown();
                        }
                    }
                }, millis, TimeUnit.MILLISECONDS));
            }
            this.countDownLatch.await();
        }
        finally {
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
                this.countDownLatch = null;
            }
            this.isWaiting.set(false);
            this.cancelAll();
        }
        if (this.interrupted.getAndSet(false)) {
            throw new InterruptedException("CancelableThreadHolder thread has been interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAll() {
        Logger.d("__ cancelAll size : " + this.jobList.size());
        List<Future<?>> list = this.jobList;
        synchronized (list) {
            for (Future<?> future : this.jobList) {
                future.cancel(false);
            }
            this.jobList.clear();
        }
    }

    public boolean isInterrupted() {
        return this.interrupted.get();
    }

    public void awake() {
        Logger.d("__ awake()");
        this.cancelAll();
        if (this.countDownLatch != null) {
            this.countDownLatch.countDown();
        }
    }

    public void interrupt() {
        Logger.d(">> CancelableThreadHolder interrupt()");
        this.interrupted.set(true);
        this.awake();
    }
}

