/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.APITaskQueue;
import com.sendbird.android.BannedUserListQuery;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.Command;
import com.sendbird.android.JobResultTask;
import com.sendbird.android.Member;
import com.sendbird.android.MutedUserListQuery;
import com.sendbird.android.OpenChannelListQuery;
import com.sendbird.android.OpenChannelParams;
import com.sendbird.android.ParticipantListQuery;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class OpenChannel
extends BaseChannel {
    private static final ConcurrentHashMap<String, OpenChannel> sCachedChannels = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, OpenChannel> sEnteredChannels = new ConcurrentHashMap();
    protected int mParticipantCount;
    protected List<User> mOperators;
    private final Object operatorLock = new Object();
    private AtomicLong operatorsUpdatedAt;
    private String mCustomType;

    static boolean hasCachedChannel(String channelUrl) {
        return sCachedChannels.containsKey(channelUrl);
    }

    static synchronized void clearCache() {
        sCachedChannels.clear();
    }

    protected static void clearEnteredChannels() {
        sEnteredChannels.clear();
    }

    static synchronized void removeChannelFromCache(String channelUrl) {
        sCachedChannels.remove(channelUrl);
    }

    static synchronized void removeChannelFromEntered(String channelUrl) {
        sEnteredChannels.remove(channelUrl);
    }

    protected static Collection<OpenChannel> getEnteredChannels() {
        return sEnteredChannels.values();
    }

    static boolean isEnteredChannel(String channelUrl) {
        return sEnteredChannels.get(channelUrl) != null;
    }

    public void refresh(final OpenChannelRefreshHandler handler) {
        OpenChannel.getChannelWithoutCache(false, this.getUrl(), new OpenChannelGetHandler(){

            @Override
            public void onResult(OpenChannel channel, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    protected static synchronized OpenChannel upsert(JsonElement el, boolean dirty) {
        String channelUrl = el.getAsJsonObject().get("channel_url").getAsString();
        if (sCachedChannels.containsKey(channelUrl)) {
            OpenChannel channel = sCachedChannels.get(channelUrl);
            if (!dirty || channel.isDirty()) {
                channel.update(el);
                channel.setDirty(dirty);
            }
        } else {
            sCachedChannels.put(channelUrl, new OpenChannel(el));
        }
        return sCachedChannels.get(channelUrl);
    }

    protected static synchronized void setDirtyToAllCachedChannels(boolean dirty) {
        if (sCachedChannels != null) {
            for (OpenChannel channel : sCachedChannels.values()) {
                channel.setDirty(dirty);
            }
        }
    }

    protected OpenChannel(JsonElement el) {
        super(el);
    }

    @Override
    protected void update(JsonElement el) {
        super.update(el);
        this.parse(el);
    }

    private void parse(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        if (obj.has("participant_count")) {
            this.mParticipantCount = obj.get("participant_count").getAsInt();
        }
        if (obj.has("operators") && obj.get("operators").isJsonArray()) {
            this.mOperators = new ArrayList<User>();
            JsonArray ops = obj.get("operators").getAsJsonArray();
            for (int i = 0; i < ops.size(); ++i) {
                this.mOperators.add(new User(ops.get(i)));
            }
        }
        this.operatorsUpdatedAt = new AtomicLong(0L);
        if (obj.has("custom_type")) {
            this.mCustomType = obj.get("custom_type").getAsString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    JsonElement toJson() {
        JsonObject obj = super.toJson().getAsJsonObject();
        obj.addProperty("channel_type", BaseChannel.ChannelType.OPEN.value());
        obj.addProperty("participant_count", (Number)this.mParticipantCount);
        if (this.mCustomType != null) {
            obj.addProperty("custom_type", this.mCustomType);
        }
        JsonArray opsObj = new JsonArray();
        Object object = this.operatorLock;
        synchronized (object) {
            for (User operator : this.mOperators) {
                opsObj.add(operator.toJson());
            }
        }
        obj.add("operators", (JsonElement)opsObj);
        return obj;
    }

    public int getParticipantCount() {
        return this.mParticipantCount;
    }

    protected void setParticipantCount(int count) {
        this.mParticipantCount = count;
    }

    public List<User> getOperators() {
        if (this.mOperators != null) {
            return Collections.unmodifiableList(this.mOperators);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void updateOperators(List<User> operators, long updateTs) {
        if (updateTs <= this.operatorsUpdatedAt.get()) {
            return;
        }
        this.operatorsUpdatedAt.set(updateTs);
        Object object = this.operatorLock;
        synchronized (object) {
            this.mOperators.clear();
            this.mOperators.addAll(operators);
        }
    }

    public String getCustomType() {
        return this.mCustomType;
    }

    public static OpenChannelListQuery createOpenChannelListQuery() {
        return new OpenChannelListQuery();
    }

    public static void createChannel(OpenChannelCreateHandler handler) {
        OpenChannel.createChannelWithOperatorUserIds(null, null, null, null, handler);
    }

    @Deprecated
    public static void createChannel(String name, Object coverUrlOrImage, String data, OpenChannelCreateHandler handler) throws ClassCastException {
        OpenChannel.createChannelWithOperatorUserIds(name, coverUrlOrImage, data, null, handler);
    }

    @Deprecated
    public static void createChannel(String name, Object coverUrlOrImage, String data, List<User> operatorUsers, OpenChannelCreateHandler handler) throws ClassCastException {
        ArrayList<String> operatorUserIds = new ArrayList<String>();
        if (operatorUsers != null) {
            for (User user : operatorUsers) {
                if (user == null) continue;
                operatorUserIds.add(user.getUserId());
            }
        }
        OpenChannel.createChannelWithOperatorUserIds(name, coverUrlOrImage, data, operatorUserIds, handler);
    }

    public static void createChannel(String name, Object coverUrlOrImage, String data, String customType, List<User> operatorUsers, OpenChannelCreateHandler handler) throws ClassCastException {
        ArrayList<String> operatorUserIds = new ArrayList<String>();
        if (operatorUsers != null) {
            for (User user : operatorUsers) {
                if (user == null) continue;
                operatorUserIds.add(user.getUserId());
            }
        }
        OpenChannel.createChannelWithOperatorUserIds(name, coverUrlOrImage, data, customType, operatorUserIds, handler);
    }

    public static void createChannelWithOperatorUserIds(String name, Object coverUrlOrImage, String data, List<String> operatorUserIds, OpenChannelCreateHandler handler) throws ClassCastException {
        OpenChannel.createChannelWithOperatorUserIds(name, coverUrlOrImage, data, null, operatorUserIds, handler);
    }

    public static void createChannelWithOperatorUserIds(String name, Object coverUrlOrImage, String data, String customType, List<String> operatorUserIds, OpenChannelCreateHandler handler) throws ClassCastException {
        OpenChannel.localCreateChannel(name, null, coverUrlOrImage, data, customType, operatorUserIds, handler);
    }

    public static void createChannelWithOperatorUserIds(String name, String channelUrl, Object coverUrlOrImage, String data, String customType, List<String> operatorUserIds, OpenChannelCreateHandler handler) throws ClassCastException {
        OpenChannel.localCreateChannel(name, channelUrl, coverUrlOrImage, data, customType, operatorUserIds, handler);
    }

    public static void createChannel(OpenChannelParams params, final OpenChannelCreateHandler handler) {
        if (params == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        OpenChannel.localCreateChannel(params.name, params.channelUrl, params.coverUrlOrImage, params.data, params.customType, params.operatorUserIds, handler);
    }

    private static void localCreateChannel(final String name, final String channelUrl, final Object coverUrlOrImage, final String data, final String customType, final List<String> operatorUserIds, final OpenChannelCreateHandler handler) throws ClassCastException {
        if (!(coverUrlOrImage instanceof String) && !(coverUrlOrImage instanceof File) && coverUrlOrImage != null) {
            throw new ClassCastException("Expecting File, String, or null for coverUrlOrImage property");
        }
        APITaskQueue.addTask(new JobResultTask<OpenChannel>(){

            @Override
            public OpenChannel call() throws Exception {
                JsonElement response = coverUrlOrImage instanceof String || coverUrlOrImage == null ? APIClient.getInstance().createOpenChannel(name, channelUrl, (String)coverUrlOrImage, data, customType, (List<String>)operatorUserIds) : APIClient.getInstance().createOpenChannel(name, channelUrl, (File)coverUrlOrImage, data, customType, (List<String>)operatorUserIds);
                return OpenChannel.upsert(response, false);
            }

            @Override
            public void onResultForUiThread(OpenChannel result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    protected static void getChannelWithoutCache(String channelUrl, OpenChannelGetHandler handler) {
        OpenChannel.getChannelWithoutCache(false, channelUrl, handler);
    }

    protected static void getChannelWithoutCacheInternal(String channelUrl, OpenChannelGetHandler handler) {
        OpenChannel.getChannelWithoutCache(true, channelUrl, handler);
    }

    public static void getChannel(String channelUrl, OpenChannelGetHandler handler) {
        OpenChannel.getChannel(false, channelUrl, handler);
    }

    static void getChannelInternal(String channelUrl, OpenChannelGetHandler handler) {
        OpenChannel.getChannel(true, channelUrl, handler);
    }

    private static void getChannel(boolean isInternal, final String channelUrl, final OpenChannelGetHandler handler) {
        if (channelUrl == null || channelUrl.length() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        if (sCachedChannels.containsKey(channelUrl) && !sCachedChannels.get(channelUrl).isDirty()) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        OpenChannel channel = (OpenChannel)sCachedChannels.get(channelUrl);
                        if (channel == null) {
                            return;
                        }
                        handler.onResult(channel, null);
                    }
                });
            }
        } else {
            OpenChannel.getChannelWithoutCache(isInternal, channelUrl, new OpenChannelGetHandler(){

                @Override
                public void onResult(final OpenChannel channel, final SendBirdException e) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                if (channel == null && e == null) {
                                    return;
                                }
                                handler.onResult(channel, e);
                            }
                        });
                    }
                }
            });
        }
    }

    private static void getChannelWithoutCache(final boolean isInternal, final String channelUrl, final OpenChannelGetHandler handler) {
        APITaskQueue.addTask(new JobResultTask<OpenChannel>(){

            @Override
            public OpenChannel call() throws Exception {
                JsonElement response = APIClient.getInstance().getOpenChannel(channelUrl, isInternal);
                return OpenChannel.upsert(response, false);
            }

            @Override
            public void onResultForUiThread(OpenChannel channel, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(channel, e);
                }
            }
        });
    }

    static OpenChannel getChannelFromCache(String channelUrl) {
        if (sCachedChannels.containsKey(channelUrl)) {
            return sCachedChannels.get(channelUrl);
        }
        return null;
    }

    public void delete(final OpenChannelDeleteHandler handler) {
        final String channelUrl = this.getUrl();
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                JsonElement response = APIClient.getInstance().deleteChannel(true, channelUrl);
                OpenChannel.removeChannelFromEntered(channelUrl);
                OpenChannel.removeChannelFromCache(channelUrl);
                return response;
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public void updateChannel(String name, Object coverUrlOrImage, String data, OpenChannelUpdateHandler handler) throws ClassCastException {
        this.updateChannelWithOperatorUserIds(name, coverUrlOrImage, data, null, handler);
    }

    @Deprecated
    public void updateChannel(String name, Object coverUrlOrImage, String data, List<User> operatorUsers, OpenChannelUpdateHandler handler) throws ClassCastException {
        ArrayList<String> operatorUserIds = new ArrayList<String>();
        if (operatorUsers != null) {
            for (User user : operatorUsers) {
                if (user == null) continue;
                operatorUserIds.add(user.getUserId());
            }
        }
        this.updateChannelWithOperatorUserIds(name, coverUrlOrImage, data, operatorUserIds, handler);
    }

    public void updateChannel(String name, Object coverUrlOrImage, String data, String customType, List<User> operatorUsers, OpenChannelUpdateHandler handler) throws ClassCastException {
        ArrayList<String> operatorUserIds = new ArrayList<String>();
        if (operatorUsers != null) {
            for (User user : operatorUsers) {
                if (user == null) continue;
                operatorUserIds.add(user.getUserId());
            }
        }
        this.updateChannelWithOperatorUserIds(name, coverUrlOrImage, data, customType, operatorUserIds, handler);
    }

    public void updateChannelWithOperatorUserIds(String name, Object coverUrlOrImage, String data, List<String> operatorUserIds, OpenChannelUpdateHandler handler) throws ClassCastException {
        this.localUpdateChannel(name, coverUrlOrImage, data, null, operatorUserIds, handler);
    }

    public void updateChannelWithOperatorUserIds(String name, Object coverUrlOrImage, String data, String customType, List<String> operatorUserIds, OpenChannelUpdateHandler handler) throws ClassCastException {
        this.localUpdateChannel(name, coverUrlOrImage, data, customType, operatorUserIds, handler);
    }

    public void updateChannel(OpenChannelParams params, final OpenChannelUpdateHandler handler) {
        if (params == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.localUpdateChannel(params.name, params.coverUrlOrImage, params.data, params.customType, params.operatorUserIds, handler);
    }

    private void localUpdateChannel(final String name, final Object coverUrlOrImage, final String data, final String customType, final List<String> operatorUserIds, final OpenChannelUpdateHandler handler) throws ClassCastException {
        if (!(coverUrlOrImage instanceof String) && !(coverUrlOrImage instanceof File) && coverUrlOrImage != null) {
            throw new ClassCastException("Expecting File, String, or null for coverUrlOrImage property");
        }
        APITaskQueue.addTask(new JobResultTask<OpenChannel>(){

            @Override
            public OpenChannel call() throws Exception {
                JsonElement response = coverUrlOrImage instanceof String || coverUrlOrImage == null ? APIClient.getInstance().updateOpenChannel(OpenChannel.this.getUrl(), name, (String)coverUrlOrImage, data, customType, (List<String>)operatorUserIds) : APIClient.getInstance().updateOpenChannel(OpenChannel.this.getUrl(), name, (File)coverUrlOrImage, data, customType, (List<String>)operatorUserIds);
                return OpenChannel.upsert(response, false);
            }

            @Override
            public void onResultForUiThread(OpenChannel result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public void enter(OpenChannelEnterHandler handler) {
        this.enter(true, handler);
    }

    void enter(boolean lazy, final OpenChannelEnterHandler handler) {
        Command cmd = Command.bEnter(this.getUrl());
        SendBird.getInstance().sendCommand(cmd, lazy, new Command.SendCommandHandler(){

            @Override
            public void onResult(Command acked, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                sEnteredChannels.put(OpenChannel.this.getUrl(), OpenChannel.this);
                OpenChannel.this.refresh(new OpenChannelRefreshHandler(){

                    @Override
                    public void onResult(SendBirdException e) {
                        if (handler != null) {
                            handler.onResult(null);
                        }
                    }
                });
            }
        });
    }

    public void exit(final OpenChannelExitHandler handler) {
        Command cmd = Command.bExit(this.getUrl());
        SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

            @Override
            public void onResult(Command acked, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                sEnteredChannels.remove(OpenChannel.this.getUrl());
                JsonObject obj = acked.getJsonElement().getAsJsonObject();
                if (obj.has("participant_count")) {
                    OpenChannel.this.setParticipantCount(obj.get("participant_count").getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public ParticipantListQuery createParticipantListQuery() {
        return new ParticipantListQuery(this);
    }

    public MutedUserListQuery createMutedUserListQuery() {
        return new MutedUserListQuery(this);
    }

    public BannedUserListQuery createBannedUserListQuery() {
        return new BannedUserListQuery(this);
    }

    public void banUser(User user, int seconds, final OpenChannelBanHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.banUserWithUserId(user.getUserId(), seconds, handler);
    }

    public void banUserWithUserId(final String userId, final int seconds, final OpenChannelBanHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (userId == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                return APIClient.getInstance().banUser(true, OpenChannel.this.getUrl(), userId, null, seconds);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public void unbanUser(User user, final OpenChannelUnbanHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.unbanUserWithUserId(user.getUserId(), handler);
    }

    public void unbanUserWithUserId(final String userId, final OpenChannelUnbanHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (userId == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                return APIClient.getInstance().unbanUser(true, OpenChannel.this.getUrl(), userId);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public void muteUser(User user, final OpenChannelMuteHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.localMuteUserWithUserId(user.getUserId(), null, null, handler);
    }

    public void muteUserWithUserId(String userId, OpenChannelMuteHandler handler) {
        this.localMuteUserWithUserId(userId, null, null, handler);
    }

    public void muteUser(User user, String description, int seconds, final OpenChannelMuteHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.localMuteUserWithUserId(user.getUserId(), description, seconds, handler);
    }

    public void muteUserWithUserId(String userId, String description, int seconds, OpenChannelMuteHandler handler) {
        this.localMuteUserWithUserId(userId, description, seconds, handler);
    }

    private void localMuteUserWithUserId(final String userId, final String description, final Integer seconds, final OpenChannelMuteHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (userId == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                return APIClient.getInstance().muteUser(true, OpenChannel.this.getUrl(), userId, description, seconds);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public void unmuteUser(User user, final OpenChannelUnmuteHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.unmuteUserWithUserId(user.getUserId(), handler);
    }

    public void unmuteUserWithUserId(final String userId, final OpenChannelUnmuteHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (userId == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                return APIClient.getInstance().unmuteUser(true, OpenChannel.this.getUrl(), userId);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public boolean isOperator(User user) {
        if (user == null) {
            return false;
        }
        return this.isOperatorWithUserId(user.getUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOperatorWithUserId(String userId) {
        boolean result = false;
        Object object = this.operatorLock;
        synchronized (object) {
            for (User operator : this.mOperators) {
                if (!operator.getUserId().equals(userId)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    Member.Role getCurrentUserRole() {
        List<User> operators = this.getOperators();
        if (operators == null) {
            return Member.Role.NONE;
        }
        User currentUser = SendBird.getCurrentUser();
        if (currentUser == null) {
            return Member.Role.NONE;
        }
        for (User operator : operators) {
            if (!operator.getUserId().equals(currentUser.getUserId())) continue;
            return Member.Role.OPERATOR;
        }
        return Member.Role.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void tryToEnterEnteredOpenChannels() throws Exception {
        Collection<OpenChannel> enteredOpenChannels = OpenChannel.getEnteredChannels();
        Logger.d("Enter open channels: " + enteredOpenChannels.size());
        if (enteredOpenChannels.size() > 0 && SendBird.isActive()) {
            ArrayList<String> openChannelUrlsOnError = new ArrayList<String>();
            String currentChannelUrl = null;
            try {
                for (OpenChannel channel : OpenChannel.getEnteredChannels()) {
                    currentChannelUrl = channel.getUrl();
                    try {
                        OpenChannel.enterChannel(channel);
                    }
                    catch (SendBirdException e) {
                        if (currentChannelUrl == null || currentChannelUrl.length() <= 0) continue;
                        openChannelUrlsOnError.add(currentChannelUrl);
                    }
                }
            }
            finally {
                if (openChannelUrlsOnError.size() > 0) {
                    for (String channelUrl : openChannelUrlsOnError) {
                        OpenChannel.removeChannelFromEntered(channelUrl);
                    }
                }
            }
        }
    }

    private static void enterChannel(OpenChannel channel) throws Exception {
        final AtomicReference error = new AtomicReference();
        final CountDownLatch lock = new CountDownLatch(1);
        channel.enter(false, new OpenChannelEnterHandler(){

            @Override
            public void onResult(SendBirdException e) {
                error.set(e);
                lock.countDown();
            }
        });
        lock.await();
        if (error.get() != null) {
            throw (Exception)error.get();
        }
    }

    @Override
    public String toString() {
        return super.toString() + "\nOpenChannel{mParticipantCount=" + this.mParticipantCount + ", mOperators=" + this.mOperators + ", mCustomType='" + this.mCustomType + '\'' + ", operatorsUpdatedAt='" + this.operatorsUpdatedAt + '\'' + '}';
    }

    public static OpenChannel clone(OpenChannel channel) {
        return new OpenChannel(channel.toJson());
    }

    public static interface OpenChannelDeleteHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelUnmuteHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelMuteHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelUnbanHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelBanHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelUpdateHandler {
        public void onResult(OpenChannel var1, SendBirdException var2);
    }

    public static interface OpenChannelCreateHandler {
        public void onResult(OpenChannel var1, SendBirdException var2);
    }

    public static interface OpenChannelGetHandler {
        public void onResult(OpenChannel var1, SendBirdException var2);
    }

    public static interface OpenChannelExitHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelEnterHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelRefreshHandler {
        public void onResult(SendBirdException var1);
    }
}

