/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.text.TextUtils;
import com.sendbird.android.Authentication;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.CancelableExecutorService;
import com.sendbird.android.ChannelEvent;
import com.sendbird.android.ChannelEventCategory;
import com.sendbird.android.Command;
import com.sendbird.android.CommandType;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.JobResultTask;
import com.sendbird.android.Member;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.ReactionEvent;
import com.sendbird.android.ReadStatus;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.SendBirdPushHelper;
import com.sendbird.android.Sender;
import com.sendbird.android.TaskQueue;
import com.sendbird.android.ThreadInfoUpdateEvent;
import com.sendbird.android.UnReadMessageCount;
import com.sendbird.android.User;
import com.sendbird.android.UserEvent;
import com.sendbird.android.handlers.OnResultHandler;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

class EventController {
    private final TaskQueue eventProcessor = new TaskQueue(CancelableExecutorService.newSingleThreadExecutor());
    private final Map<String, SendBird.ChannelHandler> channelHandlers = new ConcurrentHashMap<String, SendBird.ChannelHandler>();
    private final UnReadMessageCount unReadMessageCount = new UnReadMessageCount();

    private EventController() {
    }

    public static EventController getInstance() {
        return MsgCtlrHolder.INSTANCE;
    }

    UnReadMessageCount getUnReadMessageCount() {
        return this.unReadMessageCount;
    }

    void addChannelHandler(String identifier, SendBird.ChannelHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        this.channelHandlers.put(identifier, handler);
    }

    SendBird.ChannelHandler removeChannelHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return this.channelHandlers.remove(identifier);
    }

    void removeAllChannelHandlers() {
        this.channelHandlers.clear();
    }

    void notifyAllChannelChanged(BaseChannel channel) {
        for (SendBird.ChannelHandler handler : this.channelHandlers.values()) {
            handler.onChannelChanged(channel);
        }
    }

    void notifyTypingStatusUpdated(GroupChannel channel) {
        for (SendBird.ChannelHandler handler : this.channelHandlers.values()) {
            handler.onTypingStatusUpdated(channel);
        }
    }

    Future<Runnable> processResponse(final Command command, final OnResultHandler<Runnable> handler) {
        Logger.d(">> EventController::processResponse[%s]", new Object[]{command.getCommandType()});
        return this.eventProcessor.addTask(new JobResultTask<Runnable>(){

            @Override
            public Runnable call() throws Exception {
                EventController.this.processSubscribedUnreadMessageCount(command);
                CommandType commandType = command.getCommandType();
                if (commandType == CommandType.EROR) {
                    JsonObject errorJson = command.getJsonElement().getAsJsonObject();
                    int errCode = errorJson.get("code").getAsInt();
                    String errMessage = errorJson.get("message").getAsString();
                    throw new SendBirdException(errMessage, errCode);
                }
                BaseChannel channel = null;
                String channelUrl = command.getChannelUrl();
                boolean cacheExisted = GroupChannel.hasCachedChannel(command.getChannelUrl());
                Logger.d("++ process actual response[%s], cacheExisted=%s", new Object[]{commandType, cacheExisted});
                if (!TextUtils.isEmpty((CharSequence)channelUrl) && !command.isChannelDeleted()) {
                    try {
                        channel = BaseChannel.getChannelBlocking(command);
                        Logger.d("++ getChannelBlocking result = %s", channel);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                Runnable runnable = command.hasRequestId() ? EventController.this.processRequestedMessage(command, channel) : EventController.this.processEvent(command, channel, cacheExisted);
                Logger.w("++ result[%s] runnable=%s", new Object[]{commandType, runnable});
                return runnable;
            }

            @Override
            void onResultForUiThread(Runnable result, SendBirdException e) {
                if (e != null) {
                    Logger.d("Discard a command: " + (Object)((Object)command.getCommandType()));
                }
                if (handler != null) {
                    handler.onResult(result, e);
                }
                if (e == null && result != null) {
                    Logger.w("++ delivery[%s] runnable=%s", new Object[]{command.getCommandType(), result});
                    result.run();
                }
            }
        });
    }

    private Runnable processRequestedMessage(Command command, BaseChannel baseChannel) {
        Logger.d("processRequestedMessage() => " + command.getRequestId() + ":" + (Object)((Object)command.getCommandType()) + ":" + command.getPayload());
        CommandType msgType = command.getCommandType();
        Runnable runnable = null;
        if (command.hasRequestId()) {
            switch (msgType) {
                case MESG: 
                case FILE: {
                    BaseMessage msg = BaseMessage.createMessage(command);
                    msg.setSendingStatus(BaseMessage.SendingStatus.SUCCEEDED);
                    Sender sender = msg.mSender;
                    User user = SendBird.getCurrentUser();
                    if (sender != null && user != null && sender.getUserId().equals(user.getUserId())) {
                        user.updatePropertiesByUser(sender);
                    }
                    if (!(baseChannel instanceof GroupChannel)) break;
                    final GroupChannel channel = (GroupChannel)baseChannel;
                    channel.setLastMessageByCreatedAt(msg);
                    runnable = new Runnable(){

                        @Override
                        public void run() {
                            EventController.getInstance().notifyAllChannelChanged(channel);
                        }
                    };
                    break;
                }
            }
        }
        return runnable;
    }

    private Runnable processEvent(Command command, BaseChannel baseChannel, boolean cacheExisted) {
        Logger.d("processMessage() => " + command.getRequestId() + ":" + (Object)((Object)command.getCommandType()) + ":" + command.getPayload());
        if (!SendBird.isActive()) {
            Logger.d("[ignored] messageReceived() => " + command.getRequestId() + ":" + (Object)((Object)command.getCommandType()) + ":" + command.getPayload());
            return null;
        }
        Runnable runnable = null;
        CommandType msgType = command.getCommandType();
        switch (msgType) {
            case MESG: 
            case FILE: 
            case BRDM: 
            case ADMM: {
                runnable = this.processIncomingMessage(command, baseChannel, cacheExisted);
                break;
            }
            case MEDI: 
            case FEDI: 
            case AEDI: {
                runnable = this.processUpdatedMessage(command, baseChannel, cacheExisted);
                break;
            }
            case MRCT: {
                runnable = this.processReaction(command, baseChannel);
                break;
            }
            case READ: {
                runnable = this.processRead(command, baseChannel, cacheExisted);
                break;
            }
            case DLVR: {
                runnable = this.processDeliveryReceipt(command, baseChannel, cacheExisted);
                break;
            }
            case TPST: 
            case TPEN: {
                break;
            }
            case MTIO: {
                break;
            }
            case SYEV: {
                if (baseChannel == null) {
                    runnable = this.processChannelEventWithoutChannel(command);
                    break;
                }
                runnable = this.processChannelEvent(command, baseChannel);
                break;
            }
            case USEV: {
                runnable = this.processUserEvent(command);
                break;
            }
            case DELM: {
                runnable = this.processDeleteMessage(command, baseChannel);
                break;
            }
            case LEAV: {
                break;
            }
            case JOIN: {
                break;
            }
            case MTHD: {
                runnable = this.processThreadInfoUpdateEvent(command, baseChannel);
                break;
            }
            case EXPR: {
                this.processExpirationEvent(command);
                break;
            }
            case MCNT: {
                runnable = this.processMemberCountEvent(command);
                break;
            }
            default: {
                Logger.d("Discard a command: " + (Object)((Object)command.getCommandType()));
            }
        }
        return runnable;
    }

    private void processExpirationEvent(Command command) {
        JsonObject obj = command.getJsonElement().getAsJsonObject();
        Logger.d("EXPR, has expires_in : %s, reason : %s", obj.get("expires_in"), obj.get("reason"));
        int reason = obj.has("reason") ? obj.get("reason").getAsInt() : 400309;
        try {
            Authentication.handleSessionRefresh(new SendBirdException("The connection will expire soon.", reason), System.currentTimeMillis());
        }
        catch (SendBirdException e) {
            Logger.d(e);
        }
    }

    private void processSubscribedUnreadMessageCount(Command cmd) {
        boolean unreadCountChanged = false;
        JsonObject obj = cmd.getJsonElement().getAsJsonObject();
        if (obj != null && obj.has("unread_cnt")) {
            unreadCountChanged = this.unReadMessageCount.update(obj);
        }
        if (unreadCountChanged) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    ArrayList<SendBird.UserEventHandler> userEventHandlers = new ArrayList<SendBird.UserEventHandler>(SendBird.getInstance().mUserEventHandlers.values());
                    for (SendBird.UserEventHandler handler : userEventHandlers) {
                        handler.onTotalUnreadMessageCountChanged(EventController.this.unReadMessageCount.getTotalCount(), EventController.this.unReadMessageCount.getCustomTypeMap());
                    }
                }
            });
        }
    }

    void clearUnreadCount() {
        this.unReadMessageCount.init();
    }

    private Runnable processIncomingMessage(Command command, final BaseChannel channel, boolean cacheExisted) {
        Runnable result;
        final BaseMessage msg = BaseMessage.createMessage(command);
        if (msg == null || channel == null) {
            Logger.d("-- return msg is null");
            return null;
        }
        Logger.d("__ cacheExisted = %s", cacheExisted);
        if (msg.isGroupChannel()) {
            User currentUser = SendBird.getCurrentUser();
            if (BaseMessage.belongsTo(msg, currentUser)) {
                currentUser.updatePropertiesByUser(msg.mSender);
            }
            result = this.processIncomingMessage((GroupChannel)channel, msg, !cacheExisted);
            Command.sendMACK(msg);
        } else {
            result = new Runnable(){

                @Override
                public void run() {
                    for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                        if (OpenChannel.isEnteredChannel(channel.getUrl())) {
                            handler.onMessageReceived(channel, msg);
                        }
                        if (!msg.isMentionedFromSomeoneToMe()) continue;
                        handler.onMentionReceived(channel, msg);
                    }
                }
            };
        }
        return result;
    }

    private Runnable processIncomingMessage(final GroupChannel channel, final BaseMessage msg, boolean withoutCache) {
        Sender sender;
        Logger.d(">> processIncomingMessage() msg=[%s], withoutCache=%s", msg, withoutCache);
        final AtomicBoolean callChannelChanged = new AtomicBoolean();
        if (withoutCache) {
            callChannelChanged.set(!msg.isSilent() || BaseMessage.belongsTo(msg, SendBird.getCurrentUser()));
            if (channel.isEphemeral() && callChannelChanged.get()) {
                channel.setLastMessageByCreatedAt(msg);
                if (!BaseMessage.belongsTo(msg, SendBird.getCurrentUser())) {
                    channel.setUnreadMessageCount(channel.getUnreadMessageCount() + 1);
                }
                if (msg.isMentionedFromSomeoneToMe()) {
                    channel.setUnreadMentionCount(channel.getUnreadMentionCount() + 1);
                }
            }
        } else {
            channel.setHiddenState(GroupChannel.HiddenState.UNHIDDEN);
            callChannelChanged.set(!(msg.isSilent() && !BaseMessage.belongsTo(msg, SendBird.getCurrentUser()) || !channel.mHasBeenUpdated && channel.getLastMessage() != null && channel.getLastMessage().getCreatedAt() >= msg.getCreatedAt()));
            Logger.d("__ msg.isSilent=%s, belongsTo=%s, msg.createdAt=%s, channel.getLastMessage=%s", msg.isSilent(), BaseMessage.belongsTo(msg, SendBird.getCurrentUser()), msg.getCreatedAt(), channel.getLastMessage());
            if (callChannelChanged.get()) {
                channel.setLastMessageByCreatedAt(msg);
                if (!BaseMessage.belongsTo(msg, SendBird.getCurrentUser())) {
                    channel.setUnreadMessageCount(channel.getUnreadMessageCount() + 1);
                }
                if (msg.isMentionedFromSomeoneToMe()) {
                    channel.setUnreadMentionCount(channel.getUnreadMentionCount() + 1);
                }
                channel.mHasBeenUpdated = true;
            }
        }
        if (msg.shouldForceUpdateLastMessage()) {
            callChannelChanged.compareAndSet(false, channel.setLastMessageByCreatedAt(msg));
        }
        if ((sender = msg.mSender) != null && channel.mMemberMap.containsKey(sender.getUserId())) {
            Member member = channel.mMemberMap.get(sender.getUserId());
            member.updatePropertiesBySender(sender);
        }
        SendBirdPushHelper.messageDelivered(msg);
        return new Runnable(){

            @Override
            public void run() {
                for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                    handler.onMessageReceived(channel, msg);
                    Logger.d("__ callChannelChanged = %s", callChannelChanged.get());
                    if (callChannelChanged.get()) {
                        handler.onChannelChanged(channel);
                    }
                    if (!msg.isMentionedFromSomeoneToMe()) continue;
                    handler.onMentionReceived(channel, msg);
                }
            }
        };
    }

    private Runnable processUpdatedMessage(Command command, final BaseChannel baseChannel, boolean cacheExisted) {
        final BaseMessage msg = BaseMessage.createMessage(command);
        if (msg == null || baseChannel == null) {
            return null;
        }
        if (baseChannel instanceof GroupChannel) {
            JsonObject payload;
            final GroupChannel channel = (GroupChannel)baseChannel;
            final AtomicBoolean mentionReceived = new AtomicBoolean();
            AtomicBoolean unreadMentionCountChanged = new AtomicBoolean();
            if (SendBird.getCurrentUser() != null && msg.getCreatedAt() > channel.getMyReadTs() && (payload = command.getJsonElement().getAsJsonObject()).has("old_values")) {
                boolean currentUserWasMentioned;
                BaseMessageParams.MentionType mentionType = msg.getMentionType();
                List<String> mentionedUserIds = msg.getMentionedUserIds();
                BaseMessageParams.MentionType oldMentionType = BaseMessageParams.MentionType.USERS;
                List<String> oldMentionedUserIds = null;
                JsonObject oldValuesObject = payload.get("old_values").getAsJsonObject();
                if (oldValuesObject.has("mention_type")) {
                    String oldMentionTypeString = oldValuesObject.get("mention_type").getAsString();
                    if (oldMentionTypeString.equals("users")) {
                        oldMentionType = BaseMessageParams.MentionType.USERS;
                    } else if (oldMentionTypeString.equals("channel")) {
                        oldMentionType = BaseMessageParams.MentionType.CHANNEL;
                    }
                } else {
                    oldMentionType = mentionType;
                }
                if (oldValuesObject.has("mentioned_user_ids")) {
                    JsonArray array = oldValuesObject.get("mentioned_user_ids").getAsJsonArray();
                    if (array != null) {
                        oldMentionedUserIds = new ArrayList<String>();
                        for (int i = 0; i < array.size(); ++i) {
                            oldMentionedUserIds.add(array.get(i).getAsString());
                        }
                    }
                } else {
                    oldMentionedUserIds = mentionedUserIds;
                }
                boolean bl = currentUserWasMentioned = oldMentionedUserIds != null && oldMentionedUserIds.contains(SendBird.getCurrentUser().getUserId());
                if (oldMentionType == BaseMessageParams.MentionType.USERS && !currentUserWasMentioned && msg.isMentionedFromSomeoneToMe()) {
                    if (cacheExisted && !msg.isSilent()) {
                        channel.setUnreadMentionCount(channel.getUnreadMentionCount() + 1);
                    }
                    unreadMentionCountChanged.set(true);
                    mentionReceived.set(true);
                }
            }
            final AtomicBoolean callChannelChanged = new AtomicBoolean();
            if (!msg.isSilent() || BaseMessage.belongsTo(msg, SendBird.getCurrentUser())) {
                BaseMessage lastMessage = channel.getLastMessage();
                if (unreadMentionCountChanged.get()) {
                    callChannelChanged.set(true);
                } else if (lastMessage == null || lastMessage.getCreatedAt() < msg.getCreatedAt()) {
                    callChannelChanged.set(true);
                } else if (lastMessage.getCreatedAt() == msg.getCreatedAt()) {
                    callChannelChanged.set(lastMessage.getMessageId() == msg.getMessageId() && lastMessage.getUpdatedAt() < msg.getUpdatedAt());
                }
            }
            if (callChannelChanged.get()) {
                channel.setLastMessage(msg);
            }
            return new Runnable(){

                @Override
                public void run() {
                    for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                        handler.onMessageUpdated(channel, msg);
                        if (callChannelChanged.get()) {
                            handler.onChannelChanged(channel);
                        }
                        if (!mentionReceived.get()) continue;
                        handler.onMentionReceived(channel, msg);
                    }
                }
            };
        }
        return new Runnable(){

            @Override
            public void run() {
                for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                    handler.onMessageUpdated(baseChannel, msg);
                }
            }
        };
    }

    private Runnable processReaction(Command command, final BaseChannel channel) {
        if (channel == null) {
            return null;
        }
        final ReactionEvent reactionEvent = new ReactionEvent(command.getJsonElement());
        return new Runnable(){

            @Override
            public void run() {
                for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                    handler.onReactionUpdated(channel, reactionEvent);
                }
            }
        };
    }

    private Runnable processRead(Command command, BaseChannel baseChannel, boolean cacheExisted) {
        boolean callChannelChanged;
        boolean readFromMyself;
        if (baseChannel == null) {
            return null;
        }
        ReadStatus rst = new ReadStatus(command.getJsonElement());
        final GroupChannel channel = (GroupChannel)baseChannel;
        if (cacheExisted) {
            channel.updateReadReceipt(rst.getReader().getUserId(), rst.getTimestamp());
            boolean bl = readFromMyself = SendBird.getCurrentUser() != null && rst.getReader().getUserId().equals(SendBird.getCurrentUser().getUserId());
            if (readFromMyself && (channel.getUnreadMessageCount() > 0 || channel.getUnreadMentionCount() > 0)) {
                channel.setUnreadMessageCount(0);
                channel.setUnreadMentionCount(0);
                callChannelChanged = channel.getUnreadMessageCount() == 0 || channel.getUnreadMentionCount() == 0;
            } else {
                callChannelChanged = false;
            }
        } else {
            readFromMyself = SendBird.getCurrentUser() != null && rst.getReader().getUserId().equals(SendBird.getCurrentUser().getUserId());
            callChannelChanged = readFromMyself && (channel.getUnreadMessageCount() == 0 || channel.getUnreadMentionCount() == 0);
        }
        return new Runnable(){

            @Override
            public void run() {
                for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                    if (!readFromMyself) {
                        handler.onReadReceiptUpdated(channel);
                    }
                    if (!callChannelChanged) continue;
                    handler.onChannelChanged(channel);
                }
            }
        };
    }

    private Runnable processDeliveryReceipt(Command command, BaseChannel baseChannel, boolean cacheExisted) {
        if (baseChannel == null) {
            return null;
        }
        JsonObject obj = command.getJsonElement().getAsJsonObject();
        final GroupChannel channel = (GroupChannel)baseChannel;
        Logger.d("++ hasChannelCached : " + cacheExisted);
        Logger.d("++ channel : " + channel);
        Runnable runnable = null;
        if (obj.has("updated")) {
            boolean isMyReceipt;
            User currentUser;
            JsonObject updatedReceiptObj = obj.get("updated").getAsJsonObject();
            Set updatedReceiptEntrySet = updatedReceiptObj.entrySet();
            if (cacheExisted) {
                for (Map.Entry entry : updatedReceiptEntrySet) {
                    channel.updateDeliveryReceipt((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsLong());
                }
            }
            if (!((currentUser = SendBird.getCurrentUser()) == null || (isMyReceipt = updatedReceiptObj.has(currentUser.getUserId())) && updatedReceiptEntrySet.size() <= 1)) {
                Logger.d("++ isMyReceipt : " + isMyReceipt + ", receipt size : " + updatedReceiptEntrySet.size());
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                            handler.onDeliveryReceiptUpdated(channel);
                        }
                    }
                };
            }
        }
        return runnable;
    }

    private Runnable processChannelEventWithoutChannel(Command cmd) {
        if (cmd == null) {
            return null;
        }
        final ChannelEvent event = new ChannelEvent(cmd.getJsonElement());
        Runnable runnable = null;
        if (event.getCategory() == ChannelEventCategory.CHANNEL_DELETED) {
            if (event.isOpenChannel()) {
                OpenChannel.removeChannelFromCache(event.getChannelUrl());
                OpenChannel.removeChannelFromEntered(event.getChannelUrl());
            } else {
                GroupChannel.removeChannelFromCache(event.getChannelUrl());
            }
            runnable = new Runnable(){

                @Override
                public void run() {
                    for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                        handler.onChannelDeleted(event.getChannelUrl(), event.isOpenChannel() ? BaseChannel.ChannelType.OPEN : BaseChannel.ChannelType.GROUP);
                    }
                }
            };
        }
        return runnable;
    }

    private Runnable processChannelEvent(Command cmd, final BaseChannel baseChannel) {
        if (baseChannel == null || cmd == null) {
            return null;
        }
        final ChannelEvent event = new ChannelEvent(cmd.getJsonElement());
        final User currentUser = SendBird.getCurrentUser();
        Runnable runnable = null;
        switch (event.getCategory()) {
            case CHANNEL_INVITE: {
                final GroupChannel channel = (GroupChannel)baseChannel;
                if (channel.isSuper()) {
                    channel.setMemberCount(event.getData(), event.getTs());
                }
                final User inviter = new User(event.getData().getAsJsonObject().get("inviter"));
                final ArrayList<Member> invitees = new ArrayList<Member>();
                JsonArray inviteesArray = event.getData().getAsJsonObject().get("invitees").getAsJsonArray();
                for (JsonElement inviteeEl : inviteesArray) {
                    JsonObject inviteeObj = inviteeEl.getAsJsonObject();
                    String userId = inviteeObj.get("user_id").getAsString();
                    Member inviteeInCache = channel.mMemberMap.get(userId);
                    if (currentUser != null && currentUser.getUserId().equals(userId)) {
                        channel.setHiddenState(GroupChannel.HiddenState.UNHIDDEN);
                        if (channel.getMyMemberState() != Member.MemberState.JOINED) {
                            channel.setMyMemberState(Member.MemberState.INVITED);
                        }
                        if (event.getData().getAsJsonObject().has("invited_at")) {
                            channel.setInvitedAt(event.getData().getAsJsonObject().get("invited_at").getAsLong());
                        }
                    }
                    if (inviteeInCache == null) {
                        inviteeObj.addProperty("state", "invited");
                        Member invitee = new Member((JsonElement)inviteeObj);
                        if (!channel.isSuper()) {
                            channel.addMember(invitee, event.getTs());
                        }
                        invitees.add(invitee);
                        continue;
                    }
                    invitees.add(inviteeInCache);
                }
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                            handler.onUserReceivedInvitation(channel, inviter, invitees);
                        }
                    }
                };
                break;
            }
            case CHANNEL_DECLINE_INVITE: {
                final GroupChannel channel = (GroupChannel)baseChannel;
                final User inviter = new User(event.getData().getAsJsonObject().get("inviter"));
                JsonElement inviteeEl = event.getData().getAsJsonObject().get("invitee");
                final Member invitee = new Member(inviteeEl);
                if (channel.isSuper()) {
                    channel.setMemberCount(event.getData(), event.getTs());
                } else {
                    channel.removeMember(invitee);
                }
                if (currentUser != null && currentUser.getUserId().equals(invitee.getUserId())) {
                    channel.setMyMemberState(Member.MemberState.NONE);
                    channel.setInvitedAt(0L);
                    if (!channel.isPublic()) {
                        GroupChannel.removeChannelFromCache(channel.getUrl());
                    }
                }
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                            handler.onUserDeclinedInvitation(channel, inviter, invitee);
                        }
                    }
                };
                break;
            }
            case CHANNEL_JOIN: {
                final GroupChannel channel = (GroupChannel)baseChannel;
                final ArrayList<Member> members = new ArrayList<Member>();
                if (event.getData().getAsJsonObject().has("users")) {
                    JsonArray membersArray = event.getData().getAsJsonObject().get("users").getAsJsonArray();
                    for (int i = 0; i < membersArray.size(); ++i) {
                        members.add(new Member(membersArray.get(i)));
                    }
                } else {
                    members.add(new Member(event.getData()));
                }
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < members.size(); ++i) {
                            Member member = (Member)members.get(i);
                            if (channel.isSuper()) {
                                channel.setMemberCount(event.getData(), event.getTs());
                            } else {
                                channel.addMember(member, event.getTs());
                                channel.updateJoinedMemberCount();
                            }
                            if (currentUser != null && currentUser.getUserId().equals(member.getUserId())) {
                                channel.setMyMemberState(Member.MemberState.JOINED);
                            }
                            for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                                handler.onUserJoined(channel, member);
                                if (!channel.isBroadcast()) continue;
                                handler.onChannelMemberCountChanged(Collections.singletonList(channel));
                            }
                        }
                    }
                };
                break;
            }
            case CHANNEL_LEAVE: {
                final GroupChannel channel = (GroupChannel)baseChannel;
                final Member member = new Member(event.getData());
                if (channel.isSuper()) {
                    channel.setMemberCount(event.getData(), event.getTs());
                } else {
                    channel.removeMember(member);
                    channel.updateJoinedMemberCount();
                }
                if (currentUser != null && currentUser.getUserId().equals(member.getUserId())) {
                    channel.setMyMemberState(Member.MemberState.NONE);
                    channel.setUnreadMessageCount(0);
                    channel.setUnreadMentionCount(0);
                    channel.setInvitedAt(0L);
                    if (!channel.isPublic()) {
                        GroupChannel.removeChannelFromCache(channel.getUrl());
                    }
                }
                final boolean isChanged = channel.updateTypingStatus(member, false);
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                            handler.onUserLeft(channel, member);
                            if (channel.isBroadcast()) {
                                handler.onChannelMemberCountChanged(Collections.singletonList(channel));
                            }
                            if (!isChanged) continue;
                            handler.onTypingStatusUpdated(channel);
                        }
                    }
                };
                break;
            }
            case TYPING_START: 
            case TYPING_END: {
                final GroupChannel channel = (GroupChannel)baseChannel;
                User user = new User(event.getData());
                channel.updateTypingStatus(user, event.getCategory() == ChannelEventCategory.TYPING_START);
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                            handler.onTypingStatusUpdated(channel);
                        }
                    }
                };
                break;
            }
            case CHANNEL_ENTER: 
            case CHANNEL_EXIT: {
                final OpenChannel channel = (OpenChannel)baseChannel;
                JsonObject obj = event.getData().getAsJsonObject();
                if (obj.has("participant_count")) {
                    channel.setParticipantCount(obj.get("participant_count").getAsInt());
                }
                final User user = new User(event.getData());
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                            if (event.getCategory() == ChannelEventCategory.CHANNEL_ENTER) {
                                handler.onUserEntered(channel, user);
                                handler.onChannelParticipantCountChanged(Collections.singletonList(channel));
                                continue;
                            }
                            handler.onUserExited(channel, user);
                            handler.onChannelParticipantCountChanged(Collections.singletonList(channel));
                        }
                    }
                };
                break;
            }
            case USER_CHANNEL_MUTE: 
            case USER_CHANNEL_UNMUTE: {
                final User user = new User(event.getData());
                if (baseChannel instanceof GroupChannel) {
                    ((GroupChannel)baseChannel).updateMutedState(user.getUserId(), event.getCategory() == ChannelEventCategory.USER_CHANNEL_MUTE);
                }
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                            if (event.getCategory() == ChannelEventCategory.USER_CHANNEL_MUTE) {
                                handler.onUserMuted(baseChannel, user);
                                continue;
                            }
                            handler.onUserUnmuted(baseChannel, user);
                        }
                    }
                };
                break;
            }
            case USER_CHANNEL_BAN: 
            case USER_CHANNEL_UNBAN: {
                final User user = new User(event.getData());
                if (event.getCategory() == ChannelEventCategory.USER_CHANNEL_BAN) {
                    if (baseChannel instanceof GroupChannel) {
                        GroupChannel channel = (GroupChannel)baseChannel;
                        if (channel.isSuper()) {
                            channel.setMemberCount(event.getData(), event.getTs());
                        } else {
                            channel.removeMember(user);
                            channel.updateJoinedMemberCount();
                        }
                        if (SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(user.getUserId())) {
                            channel.setMyMemberState(Member.MemberState.NONE);
                            channel.setUnreadMessageCount(0);
                            channel.setUnreadMentionCount(0);
                            channel.setInvitedAt(0L);
                            if (!channel.isPublic()) {
                                GroupChannel.removeChannelFromCache(channel.getUrl());
                            }
                        }
                    } else if (currentUser != null && currentUser.getUserId().equals(user.getUserId())) {
                        OpenChannel.removeChannelFromEntered(event.getChannelUrl());
                    }
                }
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                            if (event.getCategory() == ChannelEventCategory.USER_CHANNEL_BAN) {
                                handler.onUserBanned(baseChannel, user);
                                continue;
                            }
                            handler.onUserUnbanned(baseChannel, user);
                        }
                    }
                };
                break;
            }
            case CHANNEL_FREEZE: 
            case CHANNEL_UNFREEZE: {
                JsonObject jsonObject = event.getData().getAsJsonObject();
                if (jsonObject.has("freeze")) {
                    baseChannel.setFreeze(jsonObject.get("freeze").getAsBoolean());
                }
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                            if (event.getCategory() == ChannelEventCategory.CHANNEL_FREEZE) {
                                handler.onChannelFrozen(baseChannel);
                                continue;
                            }
                            handler.onChannelUnfrozen(baseChannel);
                        }
                    }
                };
                break;
            }
            case CHANNEL_PROP_CHANGED: {
                GroupChannel channel;
                if (baseChannel instanceof GroupChannel && !(channel = (GroupChannel)baseChannel).isMyUnreadMentionCountEnabled()) {
                    channel.setUnreadMentionCount(0);
                }
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                            handler.onChannelChanged(baseChannel);
                        }
                    }
                };
                break;
            }
            case CHANNEL_META_DATA_CHANGED: 
            case CHANNEL_META_COUNTERS_CHANGED: {
                runnable = this.processChannelMetaDataAndCountersChangedEvent(baseChannel, event);
                break;
            }
            case CHANNEL_HIDDEN: {
                if (!(baseChannel instanceof GroupChannel)) break;
                final GroupChannel channel = (GroupChannel)baseChannel;
                JsonObject jsonObject = event.getData().getAsJsonObject();
                if (jsonObject.has("hide_previous_messages") && jsonObject.get("hide_previous_messages").getAsBoolean()) {
                    channel.setUnreadMessageCount(0);
                    channel.setUnreadMentionCount(0);
                    channel.parseMessageOffset((JsonElement)event.toJsonObject());
                }
                if (jsonObject.has("allow_auto_unhide")) {
                    boolean allowAutoUnhide = jsonObject.get("allow_auto_unhide").getAsBoolean();
                    if (allowAutoUnhide) {
                        channel.setHiddenState(GroupChannel.HiddenState.HIDDEN_ALLOW_AUTO_UNHIDE);
                    } else {
                        channel.setHiddenState(GroupChannel.HiddenState.HIDDEN_PREVENT_AUTO_UNHIDE);
                    }
                } else {
                    channel.setHiddenState(GroupChannel.HiddenState.HIDDEN_ALLOW_AUTO_UNHIDE);
                }
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                            handler.onChannelHidden(channel);
                        }
                    }
                };
                break;
            }
            case CHANNEL_UNHIDDEN: {
                if (!(baseChannel instanceof GroupChannel)) break;
                final GroupChannel channel = (GroupChannel)baseChannel;
                channel.setHiddenState(GroupChannel.HiddenState.UNHIDDEN);
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                            handler.onChannelChanged(channel);
                        }
                    }
                };
                break;
            }
            case CHANNEL_OPERATOR_CHANGED: {
                runnable = this.handleChannelOperatorsChange(event, baseChannel);
            }
        }
        return runnable;
    }

    private Runnable handleChannelOperatorsChange(ChannelEvent event, final BaseChannel baseChannel) {
        JsonArray operatorsObjs;
        Logger.d(">> handleChannelOperatorsChange");
        JsonObject jsonObject = event.getData().getAsJsonObject();
        ArrayList<User> operators = new ArrayList<User>();
        JsonArray jsonArray = operatorsObjs = jsonObject.has("operators") ? jsonObject.get("operators").getAsJsonArray() : null;
        if (operatorsObjs == null) {
            return null;
        }
        for (int i = 0; i < operatorsObjs.size(); ++i) {
            operators.add(new User(operatorsObjs.get(i)));
        }
        if (event.isGroupChannel()) {
            GroupChannel channel = (GroupChannel)baseChannel;
            User me = SendBird.getCurrentUser();
            if (me != null) {
                channel.setMyRole(operators.contains(me) ? Member.Role.OPERATOR : Member.Role.NONE);
            }
            channel.updateOperators(operators, event.getTs());
        } else {
            OpenChannel channel = (OpenChannel)baseChannel;
            channel.updateOperators(operators, event.getTs());
        }
        return new Runnable(){

            @Override
            public void run() {
                for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                    handler.onOperatorUpdated(baseChannel);
                }
            }
        };
    }

    private Runnable processChannelMetaDataAndCountersChangedEvent(final BaseChannel channel, ChannelEvent event) {
        Runnable runnable = null;
        try {
            final JsonObject jsonObject = event.getData().getAsJsonObject();
            if (event.getCategory() == ChannelEventCategory.CHANNEL_META_DATA_CHANGED) {
                final HashMap<String, String> created = new HashMap<String, String>();
                if (jsonObject.has("created")) {
                    JsonObject obj = jsonObject.getAsJsonObject("created");
                    for (Object entry : obj.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                        created.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    }
                    channel.upsertMetadata(created, event.getTs());
                }
                final HashMap<String, String> updated = new HashMap<String, String>();
                if (jsonObject.has("updated")) {
                    JsonObject obj = jsonObject.getAsJsonObject("updated");
                    for (Map.Entry entry : obj.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                        updated.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    }
                    channel.upsertMetadata(updated, event.getTs());
                }
                final ArrayList<String> deleted = new ArrayList<String>();
                if (jsonObject.has("deleted")) {
                    JsonArray array = jsonObject.getAsJsonArray("deleted");
                    for (int i = 0; i < array.size(); ++i) {
                        if (!array.get(i).isJsonPrimitive()) continue;
                        deleted.add(array.get(i).getAsString());
                    }
                    channel.onMetaDataDeleted(deleted, event.getTs());
                }
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (jsonObject.has("created")) {
                            for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                                handler.onMetaDataCreated(channel, created);
                            }
                        }
                        if (jsonObject.has("updated")) {
                            for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                                handler.onMetaDataUpdated(channel, updated);
                            }
                        }
                        if (jsonObject.has("deleted")) {
                            for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                                handler.onMetaDataDeleted(channel, deleted);
                            }
                        }
                    }
                };
            } else {
                final HashMap created = new HashMap();
                if (jsonObject.has("created")) {
                    JsonObject obj = jsonObject.getAsJsonObject("created");
                    for (Object entry : obj.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                        created.put(entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                    }
                }
                final HashMap updated = new HashMap();
                if (jsonObject.has("updated")) {
                    JsonObject obj = jsonObject.getAsJsonObject("updated");
                    for (Map.Entry entry : obj.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                        updated.put(entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                    }
                }
                final ArrayList deleted = new ArrayList();
                if (jsonObject.has("deleted")) {
                    JsonArray array = jsonObject.getAsJsonArray("deleted");
                    for (int i = 0; i < array.size(); ++i) {
                        if (!array.get(i).isJsonPrimitive()) continue;
                        deleted.add(array.get(i).getAsString());
                    }
                }
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (jsonObject.has("created")) {
                            for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                                handler.onMetaCountersCreated(channel, created);
                            }
                        }
                        if (jsonObject.has("updated")) {
                            for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                                handler.onMetaCountersUpdated(channel, updated);
                            }
                        }
                        if (jsonObject.has("deleted")) {
                            for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                                handler.onMetaCountersDeleted(channel, deleted);
                            }
                        }
                    }
                };
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return runnable;
    }

    private Runnable processUserEvent(Command cmd) {
        UserEvent event = new UserEvent(cmd.getJsonElement());
        User user = SendBird.getCurrentUser();
        switch (event.getCategory()) {
            case USER_UNBLOCK: {
                Member member;
                User blocker = null;
                User blockee = null;
                if (event.getData() != null && event.getData().getAsJsonObject().has("blocker") && event.getData().getAsJsonObject().has("blockee")) {
                    blocker = new User(event.getData().getAsJsonObject().get("blocker"));
                    blockee = new User(event.getData().getAsJsonObject().get("blockee"));
                }
                if (blocker == null || blockee == null) break;
                if (user != null && user.getUserId().equals(blocker.getUserId())) {
                    for (Map.Entry<String, GroupChannel> cachedChannel : GroupChannel.sCachedChannels.entrySet()) {
                        member = cachedChannel.getValue().mMemberMap.get(blockee.getUserId());
                        if (member == null) continue;
                        member.setIsBlockedByMe(false);
                    }
                }
                if (user == null || !user.getUserId().equals(blockee.getUserId())) break;
                for (Map.Entry<String, GroupChannel> cachedChannel : GroupChannel.sCachedChannels.entrySet()) {
                    member = cachedChannel.getValue().mMemberMap.get(blocker.getUserId());
                    if (member == null) continue;
                    member.setIsBlockingMe(false);
                }
                break;
            }
            case USER_BLOCK: {
                Member member;
                User blocker = null;
                User blockee = null;
                if (event.getData() != null && event.getData().getAsJsonObject().has("blocker") && event.getData().getAsJsonObject().has("blockee")) {
                    blocker = new User(event.getData().getAsJsonObject().get("blocker"));
                    blockee = new User(event.getData().getAsJsonObject().get("blockee"));
                }
                if (blocker == null || blockee == null) break;
                if (user != null && user.getUserId().equals(blocker.getUserId())) {
                    for (Map.Entry<String, GroupChannel> cachedChannel : GroupChannel.sCachedChannels.entrySet()) {
                        member = cachedChannel.getValue().mMemberMap.get(blockee.getUserId());
                        if (member == null) continue;
                        member.setIsBlockedByMe(true);
                    }
                }
                if (user == null || !user.getUserId().equals(blockee.getUserId())) break;
                for (Map.Entry<String, GroupChannel> cachedChannel : GroupChannel.sCachedChannels.entrySet()) {
                    member = cachedChannel.getValue().mMemberMap.get(blocker.getUserId());
                    if (member == null) continue;
                    member.setIsBlockingMe(true);
                }
                break;
            }
            case FRIEND_DISCOVERED: {
                if (event.getData() == null || !event.getData().getAsJsonObject().has("friend_discoveries")) break;
                JsonObject result = event.getData().getAsJsonObject();
                JsonArray usersArray = result.get("friend_discoveries").getAsJsonArray();
                final ArrayList<User> users = new ArrayList<User>();
                for (int i = 0; i < usersArray.size(); ++i) {
                    users.add(new User(usersArray.get(i)));
                }
                return new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<SendBird.UserEventHandler> userEventHandlers = new ArrayList<SendBird.UserEventHandler>(SendBird.getInstance().mUserEventHandlers.values());
                        for (SendBird.UserEventHandler handler : userEventHandlers) {
                            handler.onFriendsDiscovered(users);
                        }
                    }
                };
            }
        }
        return null;
    }

    private Runnable processDeleteMessage(Command command, final BaseChannel channel) {
        if (channel == null) {
            return null;
        }
        JsonObject obj = command.getJsonElement().getAsJsonObject();
        final long msgId = obj.get("msg_id").getAsLong();
        return new Runnable(){

            @Override
            public void run() {
                for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                    handler.onMessageDeleted(channel, msgId);
                }
            }
        };
    }

    private Runnable processThreadInfoUpdateEvent(Command cmd, final BaseChannel channel) {
        if (channel == null) {
            return null;
        }
        JsonObject obj = cmd.getJsonElement().getAsJsonObject();
        final ThreadInfoUpdateEvent threadInfoUpdateEvent = new ThreadInfoUpdateEvent((JsonElement)obj);
        return new Runnable(){

            @Override
            public void run() {
                for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                    handler.onThreadInfoUpdated(channel, threadInfoUpdateEvent);
                }
            }
        };
    }

    private Runnable processMemberCountEvent(Command cmd) {
        if (!cmd.getJsonElement().isJsonObject()) {
            return null;
        }
        final ArrayList<GroupChannel> broadcastChannels = new ArrayList<GroupChannel>();
        JsonObject object = cmd.getJsonElement().getAsJsonObject();
        if (object.has("group_channels") && object.get("group_channels").isJsonArray()) {
            JsonArray groupChannelArray = object.get("group_channels").getAsJsonArray();
            for (JsonElement elem : groupChannelArray) {
                long ts;
                boolean changed;
                String channelUrl;
                ConcurrentHashMap<String, GroupChannel> cache;
                GroupChannel groupChannel;
                JsonObject obj;
                if (!elem.isJsonObject() || !(obj = elem.getAsJsonObject()).has("channel_url") || !obj.get("channel_url").isJsonPrimitive() || null == (groupChannel = (GroupChannel)(cache = GroupChannel.sCachedChannels).get(channelUrl = obj.get("channel_url").getAsString())) || !(changed = groupChannel.setMemberCount((JsonElement)obj, ts = obj.get("ts").getAsLong())) || !groupChannel.isBroadcast()) continue;
                broadcastChannels.add(groupChannel);
            }
        }
        final ArrayList<OpenChannel> openChannels = new ArrayList<OpenChannel>();
        if (object.has("open_channels") && object.get("open_channels").isJsonArray()) {
            JsonArray openChannelArray = object.get("open_channels").getAsJsonArray();
            for (JsonElement elem : openChannelArray) {
                String channelUrl;
                OpenChannel openChannel;
                JsonObject obj;
                if (!elem.isJsonObject() || !(obj = elem.getAsJsonObject()).has("channel_url") || !obj.get("channel_url").isJsonPrimitive() || null == (openChannel = OpenChannel.getChannelFromCache(channelUrl = obj.get("channel_url").getAsString())) || !obj.has("participant_count") || !obj.get("participant_count").isJsonPrimitive() || !obj.has("ts") || !obj.get("ts").isJsonPrimitive()) continue;
                int participantCount = obj.get("participant_count").getAsInt();
                openChannel.setParticipantCount(participantCount);
                openChannels.add(openChannel);
            }
        }
        return new Runnable(){

            @Override
            public void run() {
                if (!broadcastChannels.isEmpty()) {
                    for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                        handler.onChannelMemberCountChanged(broadcastChannels);
                    }
                }
                if (!openChannels.isEmpty()) {
                    for (SendBird.ChannelHandler handler : EventController.this.channelHandlers.values()) {
                        handler.onChannelParticipantCountChanged(openChannels);
                    }
                }
            }
        };
    }

    private static class MsgCtlrHolder {
        private static final EventController INSTANCE = new EventController();

        private MsgCtlrHolder() {
        }
    }
}

