/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.content.Context;
import android.text.TextUtils;
import com.sendbird.android.API;
import com.sendbird.android.APIRequest;
import com.sendbird.android.APITaskQueue;
import com.sendbird.android.AppInfo;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.FileMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelChangeLogsParams;
import com.sendbird.android.GroupChannelListQuery;
import com.sendbird.android.GroupChannelMemberListQuery;
import com.sendbird.android.GroupChannelTotalUnreadMessageCountParams;
import com.sendbird.android.JobTask;
import com.sendbird.android.KeyStore;
import com.sendbird.android.LoggerV2;
import com.sendbird.android.MessageMetaArray;
import com.sendbird.android.MessageRetrievalParams;
import com.sendbird.android.PublicGroupChannelListQuery;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.SessionAPIRequest;
import com.sendbird.android.SocketManager;
import com.sendbird.android.TimeoutScheduler;
import com.sendbird.android.User;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.Gson;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import com.sendbird.android.shadow.okhttp3.Headers;
import com.sendbird.android.shadow.okhttp3.MediaType;
import com.sendbird.android.shadow.okhttp3.OkHttpClient;
import com.sendbird.android.shadow.okhttp3.RequestBody;
import com.sendbird.android.shadow.okhttp3.internal.Util;
import com.sendbird.android.shadow.okio.Buffer;
import com.sendbird.android.shadow.okio.BufferedSink;
import com.sendbird.android.shadow.okio.ByteString;
import com.sendbird.android.shadow.okio.ForwardingSink;
import com.sendbird.android.shadow.okio.Okio;
import com.sendbird.android.shadow.okio.Sink;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

class APIClient {
    private static final Gson sGson = new Gson();
    private static final MediaType MIME_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static APIClient sInstance;
    private static final Map<String, APIRequest> onGoingRequestsMap;
    private String mSessionKey = "";
    private OkHttpClient okHttpClient = new OkHttpClient();
    private OkHttpClient okHttpClientLong = new OkHttpClient.Builder().writeTimeout(60000L, TimeUnit.MILLISECONDS).build();
    static final int UPDATE_META_COUNTER_MODE_SET = 0;
    static final int UPDATE_META_COUNTER_MODE_INC = 1;
    static final int UPDATE_META_COUNTER_MODE_DEC = 2;

    private OkHttpClient getClient(boolean waitLong) {
        return waitLong ? this.okHttpClientLong : this.okHttpClient;
    }

    static synchronized APIClient getInstance() {
        if (sInstance == null) {
            Logger.e("SendBird instance hasn't been initialized. Try SendBird.init().");
            LoggerV2.e("SendBird instance hasn't been initialized. Try SendBird.init().");
            throw new RuntimeException("SendBird instance hasn't been initialized.");
        }
        return sInstance;
    }

    static synchronized void init(Context context) {
        if (sInstance == null) {
            sInstance = new APIClient();
            KeyStore.init(context.getApplicationContext());
        }
    }

    void clearKeys() {
        APIClient.getInstance().setSessionKey("");
        KeyStore.clearAll();
    }

    protected APIClient() {
    }

    void evictAllConnections() {
        Logger.d("Evict all connections.");
        LoggerV2.d("Evict all connections.");
        try {
            new Thread(){

                @Override
                public void run() {
                    APIClient.this.okHttpClient.connectionPool().evictAll();
                    APIClient.this.okHttpClientLong.connectionPool().evictAll();
                }
            }.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cancelAllRequests() {
        Logger.d("Cancel all API calls.");
        LoggerV2.d("Cancel all API calls.");
        this.okHttpClient.dispatcher().cancelAll();
        this.okHttpClientLong.dispatcher().cancelAll();
    }

    boolean cancelRequest(String requestId) {
        TimeoutScheduler.await(100L);
        APIRequest request = onGoingRequestsMap.remove(requestId);
        Logger.i("++ request : %s, requestId : %s", request, requestId);
        LoggerV2.i("++ request : %s, requestId : %s", request, requestId);
        if (request != null) {
            request.cancel();
            return true;
        }
        return false;
    }

    JsonElement groupChannelInvite(String channelUrl, List<String> userIds) throws SendBirdException {
        String url = String.format(API.GROUPCHANNELS_CHANNELURL_INVITE.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        JsonArray userIdsObj = new JsonArray();
        for (String userId : userIds) {
            userIdsObj.add(userId);
        }
        form.add("user_ids", (JsonElement)userIdsObj);
        return this.requestPOST(url, (JsonElement)form);
    }

    JsonElement groupChannelJoin(String channelUrl, String accessCode) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.GROUPCHANNELS_CHANNELURL_JOIN.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
        if (accessCode != null) {
            form.addProperty("access_code", accessCode);
        }
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement groupChannelHide(String channelUrl, boolean hidePreviousMessages, boolean allowAutoUnhide) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.GROUPCHANNELS_CHANNELURL_HIDE.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
        form.addProperty("hide_previous_messages", Boolean.valueOf(hidePreviousMessages));
        form.addProperty("allow_auto_unhide", Boolean.valueOf(allowAutoUnhide));
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement groupChannelUnhide(String channelUrl) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.GROUPCHANNELS_CHANNELURL_HIDE.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
        return this.requestDELETE(url, (JsonElement)form);
    }

    JsonElement groupChannelLeave(String channelUrl) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.GROUPCHANNELS_CHANNELURL_LEAVE.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement groupChannelAcceptInvitation(String channelUrl, String accessCode) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.GROUPCHANNELS_CHANNELURL_ACCEPT.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
        if (accessCode != null) {
            form.addProperty("access_code", accessCode);
        }
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement groupChannelDeclineInvitation(String channelUrl) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.GROUPCHANNELS_CHANNELURL_DECLINE.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement groupChannelMarkAsDelivered(String channelUrl, long msgId, long ts, String tempSessionKey) throws SendBirdException {
        String url = String.format(API.GROUPCHANNELS_CHANNELURL_MESSAGES_MARKASDELIVERED.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        if (SendBird.getCurrentUser() != null) {
            form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
        }
        if (msgId > 0L) {
            form.addProperty("message_id", (Number)msgId);
        }
        if (ts > 0L) {
            form.addProperty("ts", (Number)ts);
        }
        Map<String, String> customHeader = null;
        if (!TextUtils.isEmpty((CharSequence)tempSessionKey)) {
            customHeader = Collections.singletonMap("Session-Key", tempSessionKey);
        }
        return this.requestPUT(url, (JsonElement)form, customHeader);
    }

    JsonElement groupChannelMarkAsRead(String channelUrl, long ts) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.GROUPCHANNELS_CHANNELURL_MESSAGES_MARKASREAD.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
        form.addProperty("ts", (Number)ts);
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement groupChannelMarkAsReadAll(List<String> channelUrls) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_MARKASREADALL.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        JsonObject form = this.defaultForm();
        if (channelUrls != null) {
            JsonArray channelUrlsArray = new JsonArray();
            for (String channelUrl : channelUrls) {
                channelUrlsArray.add(channelUrl);
            }
            form.add("channel_urls", (JsonElement)channelUrlsArray);
        }
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement groupChannelResetMyHistory(String channelUrl) throws SendBirdException {
        String url = String.format(API.GROUPCHANNELS_CHANNELURL_RESETUSERHISTORY.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement sendFileMessage(boolean isOpenChannel, long rootMessageId, long parentMessageId, String channelUrl, String fileUrl, String fileName, int fileSize, String fileType, String customType, String data, String thumbnails, boolean requireAuth, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, BaseMessageParams.PushNotificationDeliveryOption pushNotificationDeliveryOption, List<MessageMetaArray> metaArrays) throws SendBirdException {
        JsonArray array;
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_MESSAGES.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL_MESSAGES.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("message_type", BaseChannel.MessageTypeFilter.FILE.value());
        if (parentMessageId > 0L) {
            form.addProperty("root_message_id", (Number)parentMessageId);
            form.addProperty("parent_message_id", (Number)parentMessageId);
        }
        form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
        form.addProperty("url", fileUrl);
        if (fileName != null) {
            form.addProperty("file_name", fileName);
        }
        if (fileSize > 0) {
            form.addProperty("file_size", (Number)fileSize);
        }
        if (fileType != null) {
            form.addProperty("file_type", fileType);
        }
        if (customType != null) {
            form.addProperty("custom_type", customType);
        }
        if (data != null) {
            form.addProperty("custom_field", data);
        }
        if (thumbnails != null) {
            form.add("thumbnails", new JsonParser().parse(thumbnails));
        }
        if (requireAuth) {
            form.addProperty("require_auth", Boolean.valueOf(true));
        }
        if (mentionType == BaseMessageParams.MentionType.USERS) {
            form.addProperty("mention_type", "users");
            if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
                array = new JsonArray();
                for (String mentionedUserId : mentionedUserIds) {
                    array.add(mentionedUserId);
                }
                form.add("mentioned_user_ids", (JsonElement)array);
            }
        } else if (mentionType == BaseMessageParams.MentionType.CHANNEL) {
            form.addProperty("mention_type", "channel");
        }
        if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
            array = new JsonArray();
            for (String mentionedUserId : mentionedUserIds) {
                array.add(mentionedUserId);
            }
            form.add("mentioned_user_ids", (JsonElement)array);
        }
        if (pushNotificationDeliveryOption != null && pushNotificationDeliveryOption == BaseMessageParams.PushNotificationDeliveryOption.SUPPRESS) {
            form.addProperty("push_option", "suppress");
        }
        if (metaArrays != null && metaArrays.size() > 0) {
            JsonObject metaArrayObj = new JsonObject();
            JsonArray metaArrayKeyOrderArray = new JsonArray();
            for (MessageMetaArray metaArray : metaArrays) {
                String key = metaArray.getKey();
                List<String> values = metaArray.getValue();
                if (key == null) continue;
                JsonArray array2 = new JsonArray();
                for (String value : values) {
                    array2.add(value);
                }
                metaArrayObj.add(key, (JsonElement)array2);
                metaArrayKeyOrderArray.add(key);
            }
            form.add("metaarray", (JsonElement)metaArrayObj);
            form.add("metaarray_key_order", (JsonElement)metaArrayKeyOrderArray);
        }
        return this.requestPOST(url, (JsonElement)form);
    }

    JsonElement sendUserMessage(boolean isOpenChannel, long rootMessageId, long parentMessageId, String channelUrl, String message, String data, String customType, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, BaseMessageParams.PushNotificationDeliveryOption pushNotificationDeliveryOption, List<MessageMetaArray> metaArrays, List<String> targetLanguages) throws SendBirdException {
        JsonArray array;
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_MESSAGES.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL_MESSAGES.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("message_type", BaseChannel.MessageTypeFilter.USER.value());
        form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
        if (parentMessageId > 0L) {
            form.addProperty("root_message_id", (Number)parentMessageId);
            form.addProperty("parent_message_id", (Number)parentMessageId);
        }
        form.addProperty("message", message);
        if (data != null) {
            form.addProperty("data", data);
        }
        if (customType != null) {
            form.addProperty("custom_type", customType);
        }
        if (mentionType == BaseMessageParams.MentionType.USERS) {
            form.addProperty("mention_type", "users");
            if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
                array = new JsonArray();
                for (String string : mentionedUserIds) {
                    array.add(string);
                }
                form.add("mentioned_user_ids", (JsonElement)array);
            }
        } else if (mentionType == BaseMessageParams.MentionType.CHANNEL) {
            form.addProperty("mention_type", "channel");
        }
        if (pushNotificationDeliveryOption != null && pushNotificationDeliveryOption == BaseMessageParams.PushNotificationDeliveryOption.SUPPRESS) {
            form.addProperty("push_option", "suppress");
        }
        if (metaArrays != null && metaArrays.size() > 0) {
            JsonObject metaArrayObj = new JsonObject();
            JsonArray metaArrayKeyOrderArray = new JsonArray();
            for (MessageMetaArray metaArray : metaArrays) {
                String key = metaArray.getKey();
                List<String> values = metaArray.getValue();
                if (key == null) continue;
                JsonArray array2 = new JsonArray();
                for (String value : values) {
                    array2.add(value);
                }
                metaArrayObj.add(key, (JsonElement)array2);
                metaArrayKeyOrderArray.add(key);
            }
            form.add("metaarray", (JsonElement)metaArrayObj);
            form.add("metaarray_key_order", (JsonElement)metaArrayKeyOrderArray);
        }
        if (targetLanguages != null && targetLanguages.size() > 0) {
            array = new JsonArray();
            for (String string : targetLanguages) {
                array.add(string);
            }
            form.add("target_langs", (JsonElement)array);
        }
        return this.requestPOST(url, (JsonElement)form);
    }

    JsonElement translateUserMessage(boolean isOpenChannel, String channelUrl, long messageId, List<String> targetLanguages) throws SendBirdException {
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID_TRANSLATION.publicUrl(), API.urlEncodeUTF8(channelUrl), messageId) : String.format(API.GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID_TRANSLATION.publicUrl(), API.urlEncodeUTF8(channelUrl), messageId);
        JsonObject form = this.defaultForm();
        if (targetLanguages != null && targetLanguages.size() > 0) {
            JsonArray array = new JsonArray();
            for (String targetLanguage : targetLanguages) {
                array.add(targetLanguage);
            }
            form.add("target_langs", (JsonElement)array);
        }
        return this.requestPOST(url, (JsonElement)form);
    }

    JsonElement registerScheduledUserMessage(boolean isOpenChannel, String channelUrl, String scheduleDt, String message, String data, String customType, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, BaseMessageParams.PushNotificationDeliveryOption pushNotificationDeliveryOption, List<MessageMetaArray> metaArrays, List<String> targetLanguages) throws SendBirdException {
        JsonArray array;
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_SCHEDULED_MESSAGES.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL_SCHEDULED_MESSAGES.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
        form.addProperty("scheduled_dt", scheduleDt);
        form.addProperty("message", message);
        if (data != null) {
            form.addProperty("data", data);
        }
        if (customType != null) {
            form.addProperty("custom_type", customType);
        }
        if (mentionType == BaseMessageParams.MentionType.USERS) {
            form.addProperty("mention_type", "users");
            if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
                array = new JsonArray();
                for (String string : mentionedUserIds) {
                    array.add(string);
                }
                form.add("mentioned_user_ids", (JsonElement)array);
            }
        } else if (mentionType == BaseMessageParams.MentionType.CHANNEL) {
            form.addProperty("mention_type", "channel");
        }
        if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
            array = new JsonArray();
            for (String string : mentionedUserIds) {
                array.add(string);
            }
            form.add("mentioned_user_ids", (JsonElement)array);
        }
        if (pushNotificationDeliveryOption != null && pushNotificationDeliveryOption == BaseMessageParams.PushNotificationDeliveryOption.SUPPRESS) {
            form.addProperty("push_option", "suppress");
        }
        if (metaArrays != null && metaArrays.size() > 0) {
            JsonObject metaArrayObj = new JsonObject();
            JsonArray metaArrayKeyOrderArray = new JsonArray();
            for (MessageMetaArray metaArray : metaArrays) {
                String key = metaArray.getKey();
                List<String> values = metaArray.getValue();
                if (key == null) continue;
                JsonArray array2 = new JsonArray();
                for (String value : values) {
                    array2.add(value);
                }
                metaArrayObj.add(key, (JsonElement)array2);
                metaArrayKeyOrderArray.add(key);
            }
            form.add("metaarray", (JsonElement)metaArrayObj);
            form.add("metaarray_key_order", (JsonElement)metaArrayKeyOrderArray);
        }
        if (targetLanguages != null && targetLanguages.size() > 0) {
            array = new JsonArray();
            for (String string : targetLanguages) {
                array.add(string);
            }
            form.add("translation_target_langs", (JsonElement)array);
        }
        return this.requestPOST(url, (JsonElement)form);
    }

    JsonElement messageList(boolean isOpenChannel, String channelUrl, long parentMessageId, long messageTimestamp, int prevLimit, int nextLimit, boolean include, boolean reverse, String messageType, Collection<String> customTypes, Collection<String> senderUserIds, boolean includeMetaArray, boolean includeReactions, boolean includeThreadInfo, boolean includeReplies, boolean includeParentMessageText, boolean showSubchannelMessagesOnly) throws SendBirdException {
        String path = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_MESSAGES.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL_MESSAGES.publicUrl(), API.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("is_sdk", String.valueOf(true));
        if (parentMessageId > 0L) {
            params.put("parent_message_id", String.valueOf(parentMessageId));
        }
        params.put("message_ts", String.valueOf(messageTimestamp));
        params.put("prev_limit", String.valueOf(prevLimit));
        params.put("next_limit", String.valueOf(nextLimit));
        params.put("reverse", String.valueOf(reverse));
        boolean isInclusive = prevLimit > 0 && nextLimit > 0 || include;
        params.put("include", String.valueOf(isInclusive));
        if (messageType != null) {
            params.put("message_type", messageType);
        }
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        if (customTypes == null || customTypes.isEmpty()) {
            params.put("custom_types", "*");
        } else {
            paramsWithListValue.put("custom_types", customTypes);
        }
        if (includeMetaArray) {
            params.put("with_sorted_meta_array", String.valueOf(true));
        }
        if (includeReactions) {
            params.put("include_reactions", String.valueOf(true));
        }
        if (includeThreadInfo) {
            params.put("include_thread_info", String.valueOf(true));
        }
        if (includeReplies) {
            params.put("include_replies", String.valueOf(true));
        }
        if (includeParentMessageText) {
            params.put("include_parent_message_text", String.valueOf(true));
        }
        if (showSubchannelMessagesOnly && isOpenChannel) {
            params.put("show_subchannel_messages_only", String.valueOf(true));
        }
        if (senderUserIds != null && senderUserIds.size() > 0) {
            paramsWithListValue.put("sender_ids", senderUserIds);
        }
        return this.requestGET(path, params, paramsWithListValue);
    }

    JsonElement messageListById(boolean isOpenChannel, String channelUrl, long messageId, int prevLimit, int nextLimit, boolean include, boolean reverse, String messageType, Collection<String> customTypes, Collection<String> senderUserIds, boolean includeMetaArray, boolean includeReactions, boolean includeThreadInfo, boolean includeReplies, boolean includeParentMessageText, boolean showSubchannelMessagesOnly) throws SendBirdException {
        String path = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_MESSAGES.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL_MESSAGES.publicUrl(), API.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("is_sdk", String.valueOf(true));
        params.put("message_id", String.valueOf(messageId));
        params.put("prev_limit", String.valueOf(prevLimit));
        params.put("next_limit", String.valueOf(nextLimit));
        params.put("reverse", String.valueOf(reverse));
        boolean isInclusive = prevLimit > 0 && nextLimit > 0 || include;
        params.put("include", String.valueOf(isInclusive));
        if (messageType != null) {
            params.put("message_type", messageType);
        }
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        if (customTypes == null || customTypes.isEmpty()) {
            params.put("custom_types", "*");
        } else {
            paramsWithListValue.put("custom_types", customTypes);
        }
        if (includeMetaArray) {
            params.put("with_sorted_meta_array", String.valueOf(true));
        }
        if (includeReactions) {
            params.put("include_reactions", String.valueOf(true));
        }
        if (includeThreadInfo) {
            params.put("include_thread_info", String.valueOf(true));
        }
        if (includeReplies) {
            params.put("include_replies", String.valueOf(true));
        }
        if (includeParentMessageText) {
            params.put("include_parent_message_text", String.valueOf(true));
        }
        if (showSubchannelMessagesOnly && isOpenChannel) {
            params.put("show_subchannel_messages_only", String.valueOf(true));
        }
        if (senderUserIds != null && senderUserIds.size() > 0) {
            paramsWithListValue.put("sender_ids", senderUserIds);
        }
        return this.requestGET(path, params, paramsWithListValue);
    }

    JsonElement messageChangeLogs(boolean isOpenChannel, String channelUrl, String token, Long ts, boolean includeMetaArray, boolean includeReactions, boolean includeThreadInfo, boolean includeReplies, boolean includeParentMessageText) throws SendBirdException {
        String path = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_MESSAGES_CHANGELOGS.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL_MESSAGES_CHANGELOGS.publicUrl(), API.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        if (token != null) {
            params.put("token", token);
        }
        if (ts != null) {
            params.put("change_ts", String.valueOf(ts));
        }
        if (includeMetaArray) {
            params.put("with_sorted_meta_array", String.valueOf(true));
        }
        if (includeReactions) {
            params.put("include_reactions", String.valueOf(true));
        }
        if (includeThreadInfo) {
            params.put("include_thread_info", String.valueOf(true));
        }
        if (includeReplies) {
            params.put("include_replies", String.valueOf(true));
        }
        if (includeParentMessageText) {
            params.put("include_parent_message_text", String.valueOf(true));
        }
        return this.requestGET(path, params, null);
    }

    JsonElement getMyGroupChannelChangeLogs(String token, Long ts, GroupChannelChangeLogsParams params) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_MYGROUPCHANNELS_CHANGELOGS.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (token != null) {
            queryParams.put("token", token);
        }
        if (ts != null) {
            queryParams.put("change_ts", String.valueOf(ts));
        }
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        List<String> customTypes = params.getCustomTypes();
        if (customTypes != null && customTypes.size() > 0) {
            paramsWithListValue.put("custom_types", customTypes);
        }
        queryParams.put("show_member", String.valueOf(true));
        queryParams.put("show_read_receipt", String.valueOf(true));
        queryParams.put("show_delivery_receipt", String.valueOf(true));
        queryParams.put("show_empty", String.valueOf(params.shouldIncludeEmpty()));
        queryParams.put("show_frozen", String.valueOf(params.shouldIncludeFrozen()));
        return this.requestGET(url, queryParams, paramsWithListValue);
    }

    JsonElement updateUserInfo(String nickname, String profileUrl, List<String> discoveryKeys, List<String> preferredLanguages) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        JsonObject form = this.defaultForm();
        if (nickname != null) {
            form.addProperty("nickname", nickname);
        }
        if (profileUrl != null) {
            form.addProperty("profile_url", profileUrl);
        }
        if (discoveryKeys != null) {
            JsonArray discoveryKeysArray = new JsonArray();
            for (String discoveryKey : discoveryKeys) {
                discoveryKeysArray.add(discoveryKey);
            }
            form.add("discovery_keys", (JsonElement)discoveryKeysArray);
        }
        if (preferredLanguages != null) {
            JsonArray preferredLanguagesArray = new JsonArray();
            for (String preferredLanguage : preferredLanguages) {
                preferredLanguagesArray.add(preferredLanguage);
            }
            form.add("preferred_languages", (JsonElement)preferredLanguagesArray);
        }
        String url = String.format(API.USERS_USERID.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement updateUserInfo(String nickname, File profileFile, List<String> discoveryKeys) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        HashMap<String, String> form = new HashMap<String, String>();
        String filename = null;
        if (nickname != null) {
            form.put("nickname", nickname);
        }
        if (profileFile != null) {
            filename = "profile_file";
        }
        if (discoveryKeys != null) {
            StringBuilder sb = new StringBuilder();
            String separator = "";
            for (String str : discoveryKeys) {
                sb.append(separator);
                separator = ",";
                sb.append(str);
            }
            String result = sb.toString();
            form.put("discovery_keys", result);
        }
        String url = String.format(API.USERS_USERID.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        return this.requestPUT(url, form, filename, profileFile);
    }

    JsonElement getGroupChannel(String channelUrl, boolean isInternal) throws SendBirdException {
        String url = String.format(API.GROUPCHANNELS_CHANNELURL.url(isInternal), API.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("member", String.valueOf(true));
        params.put("show_read_receipt", String.valueOf(true));
        params.put("show_delivery_receipt", String.valueOf(true));
        return this.requestGET(url, params, null);
    }

    JsonElement getOpenChannel(String channelUrl, boolean isInternal) throws SendBirdException {
        return this.requestGET(String.format(API.OPENCHANNELS_CHANNELURL.url(isInternal), API.urlEncodeUTF8(channelUrl)));
    }

    JsonElement createGroupChannel(List<String> userIds, List<String> operatorUserIds, Boolean isSuper, Boolean isPublic, Boolean isEphemeral, Boolean isDistinct, Boolean isDiscoverable, String channelUrl, String name, String coverUrl, String data, String customType, String accessCode, Boolean strict, Boolean isBroadcast, Integer messageSurvivalSeconds) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = API.GROUPCHANNELS.publicUrl();
        JsonObject form = this.defaultForm();
        JsonArray userIdsObj = new JsonArray();
        LinkedHashSet<String> userIdSet = new LinkedHashSet<String>(userIds);
        userIdSet.add(SendBird.getCurrentUser().getUserId());
        for (String userId : userIdSet) {
            userIdsObj.add(userId);
        }
        form.add("user_ids", (JsonElement)userIdsObj);
        if (operatorUserIds != null) {
            JsonArray operatorUserIdsObj = new JsonArray();
            for (String operatorUserId : operatorUserIds) {
                operatorUserIdsObj.add(operatorUserId);
            }
            form.add("operator_ids", (JsonElement)operatorUserIdsObj);
        }
        if (isSuper != null) {
            form.addProperty("is_super", isSuper);
        }
        if (isPublic != null) {
            form.addProperty("is_public", isPublic);
        }
        if (isEphemeral != null) {
            form.addProperty("is_ephemeral", isEphemeral);
        }
        if (isDistinct != null) {
            form.addProperty("is_distinct", isDistinct);
        }
        if (isDiscoverable != null) {
            form.addProperty("is_discoverable", isDiscoverable);
        }
        if (channelUrl != null) {
            form.addProperty("channel_url", channelUrl);
        }
        if (name != null) {
            form.addProperty("name", name);
        }
        if (coverUrl != null) {
            form.addProperty("cover_url", coverUrl);
        }
        if (data != null) {
            form.addProperty("data", data);
        }
        if (customType != null) {
            form.addProperty("custom_type", customType);
        }
        if (accessCode != null) {
            form.addProperty("access_code", accessCode);
        }
        if (strict != null) {
            form.addProperty("strict", strict);
        }
        if (isBroadcast != null) {
            form.addProperty("is_broadcast", isBroadcast);
        }
        if (messageSurvivalSeconds != null) {
            form.addProperty("message_survival_seconds", (Number)messageSurvivalSeconds);
        }
        return this.requestPOST(url, (JsonElement)form);
    }

    JsonElement createGroupChannel(List<String> userIds, List<String> operatorUserIds, Boolean isSuper, Boolean isPublic, Boolean isEphemeral, Boolean isDistinct, Boolean isDiscoverable, String channelUrl, String name, File coverFile, String data, String customType, String accessCode, Boolean strict, Boolean isBroadcast, Integer messageSurvivalSeconds) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = API.GROUPCHANNELS.publicUrl();
        HashMap<String, String> form = new HashMap<String, String>();
        String filename = null;
        LinkedHashSet<String> userIdSet = new LinkedHashSet<String>(userIds);
        userIdSet.add(SendBird.getCurrentUser().getUserId());
        form.put("user_ids", API.urlEncodeUTF8(userIdSet));
        if (operatorUserIds != null) {
            form.put("operator_ids", API.urlEncodeUTF8(operatorUserIds));
        }
        if (isSuper != null) {
            form.put("is_super", isSuper != false ? "true" : "false");
        }
        if (isPublic != null) {
            form.put("is_public", isPublic != false ? "true" : "false");
        }
        if (isEphemeral != null) {
            form.put("is_ephemeral", isEphemeral != false ? "true" : "false");
        }
        if (isDistinct != null) {
            form.put("is_distinct", isDistinct != false ? "true" : "false");
        }
        if (isDiscoverable != null) {
            form.put("is_discoverable", isDiscoverable != false ? "true" : "false");
        }
        if (channelUrl != null) {
            form.put("channel_url", channelUrl);
        }
        if (name != null) {
            form.put("name", name);
        }
        if (coverFile != null) {
            filename = "cover_file";
        }
        if (data != null) {
            form.put("data", data);
        }
        if (customType != null) {
            form.put("custom_type", customType);
        }
        if (accessCode != null) {
            form.put("access_code", accessCode);
        }
        if (strict != null) {
            form.put("strict", strict != false ? "true" : "false");
        }
        if (isBroadcast != null) {
            form.put("is_broadcast", String.valueOf(isBroadcast));
        }
        if (messageSurvivalSeconds != null) {
            form.put("message_survival_seconds", messageSurvivalSeconds.toString());
        }
        return this.requestPOST(url, form, filename, coverFile);
    }

    JsonElement updateGroupChannel(String channelUrl, Boolean isPublic, Boolean isEphemeral, Boolean isDistinct, Boolean isDiscoverable, String name, String coverUrl, String data, String customType, String accessCode, Boolean strict, Integer messageSurvivalSeconds, List<String> operatorUserIds) throws SendBirdException {
        String url = String.format(API.GROUPCHANNELS_CHANNELURL.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        if (isPublic != null) {
            form.addProperty("is_public", isPublic);
        }
        if (isEphemeral != null) {
            form.addProperty("is_ephemeral", isEphemeral);
        }
        if (isDistinct != null) {
            form.addProperty("is_distinct", isDistinct);
        }
        if (isDiscoverable != null) {
            form.addProperty("is_discoverable", isDiscoverable);
        }
        if (name != null) {
            form.addProperty("name", name);
        }
        if (coverUrl != null) {
            form.addProperty("cover_url", coverUrl);
        }
        if (data != null) {
            form.addProperty("data", data);
        }
        if (customType != null) {
            form.addProperty("custom_type", customType);
        }
        if (accessCode != null) {
            form.addProperty("access_code", accessCode);
        }
        if (strict != null) {
            form.addProperty("strict", strict);
        }
        if (messageSurvivalSeconds != null) {
            form.addProperty("message_survival_seconds", (Number)messageSurvivalSeconds);
        }
        if (operatorUserIds != null) {
            JsonArray operatorUserIdsObj = new JsonArray();
            for (String operatorUserId : operatorUserIds) {
                operatorUserIdsObj.add(operatorUserId);
            }
            form.add("operator_ids", (JsonElement)operatorUserIdsObj);
        }
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement updateGroupChannel(String channelUrl, Boolean isPublic, Boolean isEphemeral, Boolean isDistinct, Boolean isDiscoverable, String name, File coverFile, String data, String customType, String accessCode, Boolean strict, Integer messageSurvivalSeconds, List<String> operatorUserIds) throws SendBirdException {
        String url = String.format(API.GROUPCHANNELS_CHANNELURL.publicUrl(), API.urlEncodeUTF8(channelUrl));
        HashMap<String, String> form = new HashMap<String, String>();
        String filename = null;
        if (isPublic != null) {
            form.put("is_public", isPublic != false ? "true" : "false");
        }
        if (isEphemeral != null) {
            form.put("is_ephemeral", isEphemeral != false ? "true" : "false");
        }
        if (isDistinct != null) {
            form.put("is_distinct", isDistinct != false ? "true" : "false");
        }
        if (isDiscoverable != null) {
            form.put("is_discoverable", isDiscoverable != false ? "true" : "false");
        }
        if (name != null) {
            form.put("name", name);
        }
        if (coverFile != null) {
            filename = "cover_file";
        }
        if (data != null) {
            form.put("data", data);
        }
        if (customType != null) {
            form.put("custom_type", customType);
        }
        if (accessCode != null) {
            form.put("access_code", accessCode);
        }
        if (strict != null) {
            form.put("strict", strict != false ? "true" : "false");
        }
        if (messageSurvivalSeconds != null) {
            form.put("message_survival_seconds", messageSurvivalSeconds.toString());
        }
        if (operatorUserIds != null) {
            form.put("operator_ids", API.urlEncodeUTF8(operatorUserIds));
        }
        return this.requestPUT(url, form, filename, coverFile);
    }

    JsonElement createOpenChannel(String name, String channelUrl, String coverUrl, String data, String customType, List<String> operatorUserIds) throws SendBirdException {
        String url = API.OPENCHANNELS.publicUrl();
        JsonObject form = this.defaultForm();
        if (name != null) {
            form.addProperty("name", name);
        }
        if (channelUrl != null) {
            form.addProperty("channel_url", channelUrl);
        }
        if (coverUrl != null) {
            form.addProperty("cover_url", coverUrl);
        }
        if (data != null) {
            form.addProperty("data", data);
        }
        if (customType != null) {
            form.addProperty("custom_type", customType);
        }
        if (operatorUserIds != null) {
            JsonArray operatorUserIdsObj = new JsonArray();
            for (String operatorUserId : operatorUserIds) {
                operatorUserIdsObj.add(operatorUserId);
            }
            form.add("operator_ids", (JsonElement)operatorUserIdsObj);
        }
        return this.requestPOST(url, (JsonElement)form);
    }

    JsonElement createOpenChannel(String name, String channelUrl, File coverFile, String data, String customType, List<String> operatorUserIds) throws SendBirdException {
        String url = API.OPENCHANNELS.publicUrl();
        HashMap<String, String> form = new HashMap<String, String>();
        String filename = null;
        if (name != null) {
            form.put("name", name);
        }
        if (channelUrl != null) {
            form.put("channel_url", channelUrl);
        }
        if (coverFile != null) {
            filename = "cover_file";
        }
        if (data != null) {
            form.put("data", data);
        }
        if (customType != null) {
            form.put("custom_type", customType);
        }
        if (operatorUserIds != null) {
            form.put("operator_ids", API.urlEncodeUTF8(operatorUserIds));
        }
        return this.requestPOST(url, form, filename, coverFile);
    }

    JsonElement updateOpenChannel(String channelUrl, String name, String coverUrl, String data, String customType, List<String> operatorUserIds) throws SendBirdException {
        String url = String.format(API.OPENCHANNELS_CHANNELURL.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        if (name != null) {
            form.addProperty("name", name);
        }
        if (coverUrl != null) {
            form.addProperty("cover_url", coverUrl);
        }
        if (data != null) {
            form.addProperty("data", data);
        }
        if (customType != null) {
            form.addProperty("custom_type", customType);
        }
        if (operatorUserIds != null) {
            JsonArray operatorUserIdsObj = new JsonArray();
            for (String operatorUserId : operatorUserIds) {
                operatorUserIdsObj.add(operatorUserId);
            }
            form.add("operator_ids", (JsonElement)operatorUserIdsObj);
        }
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement updateOpenChannel(String channelUrl, String name, File coverFile, String data, String customType, List<String> operatorUserIds) throws SendBirdException {
        String url = String.format(API.OPENCHANNELS_CHANNELURL.publicUrl(), API.urlEncodeUTF8(channelUrl));
        HashMap<String, String> form = new HashMap<String, String>();
        String filename = null;
        if (name != null) {
            form.put("name", name);
        }
        if (coverFile != null) {
            filename = "cover_file";
        }
        if (data != null) {
            form.put("data", data);
        }
        if (customType != null) {
            form.put("custom_type", customType);
        }
        if (operatorUserIds != null) {
            form.put("operator_ids", API.urlEncodeUTF8(operatorUserIds));
        }
        return this.requestPUT(url, form, filename, coverFile);
    }

    JsonElement createMetaCounters(boolean isOpenChannel, String channelUrl, Map<String, Integer> metaCounterMap) throws SendBirdException {
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_METACOUNTER.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL_METACOUNTER.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        JsonObject metas = new JsonObject();
        for (Map.Entry<String, Integer> entry : metaCounterMap.entrySet()) {
            metas.addProperty(entry.getKey(), (Number)entry.getValue());
        }
        form.add("metacounter", (JsonElement)metas);
        return this.requestPOST(url, (JsonElement)form);
    }

    JsonElement updateMetaCounters(boolean isOpenChannel, String channelUrl, Map<String, Integer> metaCounterMap, boolean upsert, int mode) throws SendBirdException {
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_METACOUNTER.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL_METACOUNTER.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        JsonObject metas = new JsonObject();
        for (Map.Entry<String, Integer> entry : metaCounterMap.entrySet()) {
            metas.addProperty(entry.getKey(), (Number)entry.getValue());
        }
        form.add("metacounter", (JsonElement)metas);
        form.addProperty("upsert", Boolean.valueOf(upsert));
        switch (mode) {
            case 0: {
                form.addProperty("mode", "set");
                break;
            }
            case 1: {
                form.addProperty("mode", "increase");
                break;
            }
            case 2: {
                form.addProperty("mode", "decrease");
            }
        }
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement getAllMetaCounters(boolean isOpenChannel, String channelUrl) throws SendBirdException {
        return this.getMetaCounters(isOpenChannel, channelUrl, new ArrayList<String>());
    }

    JsonElement getMetaCounters(boolean isOpenChannel, String channelUrl, Collection<String> keys) throws SendBirdException {
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_METACOUNTER.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL_METACOUNTER.publicUrl(), API.urlEncodeUTF8(channelUrl));
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        if (keys != null && keys.size() > 0) {
            paramsWithListValue.put("keys", keys);
        }
        return this.requestGET(url, null, paramsWithListValue);
    }

    JsonElement deleteMetaCounter(boolean isOpenChannel, String channelUrl, String key) throws SendBirdException {
        String path = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_METACOUNTER_KEY.publicUrl(), API.urlEncodeUTF8(channelUrl), API.urlEncodeUTF8(key)) : String.format(API.GROUPCHANNELS_CHANNELURL_METACOUNTER_KEY.publicUrl(), API.urlEncodeUTF8(channelUrl), API.urlEncodeUTF8(key));
        JsonObject form = this.defaultForm();
        return this.requestDELETE(path, (JsonElement)form);
    }

    JsonElement deleteAllMetaCounters(boolean isOpenChannel, String channelUrl) throws SendBirdException {
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_METACOUNTER.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL_METACOUNTER.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        return this.requestDELETE(url, (JsonElement)form);
    }

    JsonElement createMetaData(boolean isOpenChannel, String channelUrl, Map<String, String> metaDataMap) throws SendBirdException {
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_METADATA.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL_METADATA.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        JsonObject metas = new JsonObject();
        for (Map.Entry<String, String> entry : metaDataMap.entrySet()) {
            metas.addProperty(entry.getKey(), entry.getValue());
        }
        form.add("metadata", (JsonElement)metas);
        form.addProperty("include_ts", Boolean.valueOf(true));
        return this.requestPOST(url, (JsonElement)form);
    }

    JsonElement updateMetaData(boolean isOpenChannel, String channelUrl, Map<String, String> metaDataMap, boolean upsert) throws SendBirdException {
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_METADATA.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL_METADATA.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        JsonObject metas = new JsonObject();
        for (Map.Entry<String, String> entry : metaDataMap.entrySet()) {
            metas.addProperty(entry.getKey(), entry.getValue());
        }
        form.add("metadata", (JsonElement)metas);
        form.addProperty("upsert", Boolean.valueOf(upsert));
        form.addProperty("include_ts", Boolean.valueOf(true));
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement getAllMetaData(boolean isOpenChannel, String channelUrl) throws SendBirdException {
        return this.getMetaData(isOpenChannel, channelUrl, new ArrayList<String>());
    }

    JsonElement getMetaData(boolean isOpenChannel, String channelUrl, Collection<String> keys) throws SendBirdException {
        String path = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_METADATA.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL_METADATA.publicUrl(), API.urlEncodeUTF8(channelUrl));
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        if (keys != null && keys.size() > 0) {
            paramsWithListValue.put("keys", keys);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("include_ts", String.valueOf(true));
        return this.requestGET(path, params, paramsWithListValue);
    }

    JsonElement deleteMetaData(boolean isOpenChannel, String channelUrl, String key) throws SendBirdException {
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_METADATA_KEY.publicUrl(), API.urlEncodeUTF8(channelUrl), API.urlEncodeUTF8(key)) : String.format(API.GROUPCHANNELS_CHANNELURL_METADATA_KEY.publicUrl(), API.urlEncodeUTF8(channelUrl), API.urlEncodeUTF8(key));
        JsonObject form = this.defaultForm();
        form.addProperty("include_ts", Boolean.valueOf(true));
        return this.requestDELETE(url, (JsonElement)form);
    }

    JsonElement deleteAllMetaData(boolean isOpenChannel, String channelUrl) throws SendBirdException {
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_METADATA.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL_METADATA.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("include_ts", Boolean.valueOf(true));
        return this.requestDELETE(url, (JsonElement)form);
    }

    JsonElement createUserMetaData(String userId, Map<String, String> metaDataMap) throws SendBirdException {
        String url = String.format(API.USERS_USERID_METADATA.publicUrl(), API.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        JsonObject metas = new JsonObject();
        for (Map.Entry<String, String> entry : metaDataMap.entrySet()) {
            metas.addProperty(entry.getKey(), entry.getValue());
        }
        form.add("metadata", (JsonElement)metas);
        return this.requestPOST(url, (JsonElement)form);
    }

    JsonElement updateUserMetaData(String userId, Map<String, String> metaDataMap, boolean upsert) throws SendBirdException {
        String url = String.format(API.USERS_USERID_METADATA.publicUrl(), API.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        JsonObject metas = new JsonObject();
        for (Map.Entry<String, String> entry : metaDataMap.entrySet()) {
            metas.addProperty(entry.getKey(), entry.getValue());
        }
        form.add("metadata", (JsonElement)metas);
        form.addProperty("upsert", Boolean.valueOf(upsert));
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement getAllUserMetaData(String userId) throws SendBirdException {
        return this.getUserMetaData(userId, new ArrayList<String>());
    }

    JsonElement getUserMetaData(String userId, Collection<String> keys) throws SendBirdException {
        String path = String.format(API.USERS_USERID_METADATA.publicUrl(), API.urlEncodeUTF8(userId));
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        if (keys != null && keys.size() > 0) {
            paramsWithListValue.put("keys", keys);
        }
        return this.requestGET(path, null, paramsWithListValue);
    }

    JsonElement deleteUserMetaData(String userId, String key) throws SendBirdException {
        String url = String.format(API.USERS_USERID_METADATA_KEY.publicUrl(), API.urlEncodeUTF8(userId), API.urlEncodeUTF8(key));
        JsonObject form = this.defaultForm();
        return this.requestDELETE(url, (JsonElement)form);
    }

    JsonElement deleteAllUserMetaData(String userId) throws SendBirdException {
        String url = String.format(API.USERS_USERID_METADATA.publicUrl(), API.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        return this.requestDELETE(url, (JsonElement)form);
    }

    private void addMetaDataFilterToParams(Map<String, String> params, Map<String, Collection<String>> paramsWithListValue, Map<String, List<String>> metaDataFilter) {
        String key;
        List<String> values;
        Iterator<String> keys;
        if (metaDataFilter != null && (keys = metaDataFilter.keySet().iterator()).hasNext() && (values = metaDataFilter.get(key = keys.next())) != null && values.size() > 0) {
            params.put("metadatakey", key);
            paramsWithListValue.put("metadatavalues_in", values);
        }
    }

    JsonElement allowFriendDiscovery(String userId, boolean allow) throws SendBirdException {
        JsonObject form = this.defaultForm();
        form.addProperty("allow_friend_discovery", Boolean.valueOf(allow));
        String url = String.format(API.USERS_USERID_ALLOW_FRIEND_DISCOVERY.publicUrl(), userId);
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement getAllowFriendDiscovery(String userId) throws SendBirdException {
        String url = String.format(API.USERS_USERID_ALLOW_FRIEND_DISCOVERY.publicUrl(), userId);
        return this.requestGET(url);
    }

    JsonElement loadUserList(String token, int limit, List<String> userIds, Map<String, List<String>> metaDataFilter) throws SendBirdException {
        String path = API.USERS.publicUrl();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", token);
        params.put("limit", String.valueOf(limit));
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        if (userIds != null && userIds.size() > 0) {
            paramsWithListValue.put("user_ids", userIds);
        }
        this.addMetaDataFilterToParams(params, paramsWithListValue, metaDataFilter);
        return this.requestGET(path, params, paramsWithListValue);
    }

    JsonElement loadBlockedUserList(String token, int limit, List<String> userIds) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String path = String.format(API.USERS_USERID_BLOCK.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", token);
        params.put("limit", String.valueOf(limit));
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        if (userIds != null && userIds.size() > 0) {
            paramsWithListValue.put("user_ids", userIds);
        }
        return this.requestGET(path, params, paramsWithListValue);
    }

    JsonElement loadOpenChannelList(String token, int limit, String nameKeyword, String urlKeyword, String customType, String customTypeStartsWith, ArrayList<String> customTypes, boolean includeFrozen) throws SendBirdException {
        String path = API.OPENCHANNELS.publicUrl();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", token);
        params.put("limit", String.valueOf(limit));
        if (customType != null) {
            params.put("custom_type", customType);
        }
        if (nameKeyword != null) {
            params.put("name_contains", nameKeyword);
        }
        if (urlKeyword != null) {
            params.put("url_contains", urlKeyword);
        }
        if (customTypeStartsWith != null) {
            params.put("custom_type_startswith", customTypeStartsWith);
        }
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        if (customTypes != null && customTypes.size() > 0) {
            paramsWithListValue.put("custom_types", customTypes);
        }
        params.put("show_frozen", String.valueOf(includeFrozen));
        return this.requestGET(path, params, paramsWithListValue);
    }

    JsonElement uploadFile(File file, String mimeType, List<FileMessage.ThumbnailSize> thumbnailSizes, String channelUrl, String requestId, APIClientProgressHandler progressHandler) throws SendBirdException {
        AppInfo appInfo = SendBird.getAppInfo();
        if (null == appInfo) {
            throw SocketManager.createConnectionRequiredException();
        }
        long limit = appInfo.getUploadSizeLimit();
        if (limit < file.length()) {
            throw new SendBirdException("Please check file size before sending using SendBird.getAppInfo().getUploadSizeLimit() ", 800260);
        }
        return this.uploadFILE(API.STORAGE_FILE.publicUrl(), file, mimeType, thumbnailSizes, channelUrl, requestId, progressHandler);
    }

    JsonElement uploadProfileImage(File file) throws SendBirdException {
        return this.uploadFILE(API.STORAGE_PROFILEIMAGE.publicUrl(), file, null, null, null, null, null);
    }

    private JsonObject defaultForm() {
        return new JsonObject();
    }

    JsonElement loadUserGroupChannelList(String token, int limit, boolean includeEmpty, String order) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = API.GROUPCHANNELS.publicUrl();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", token);
        params.put("limit", String.valueOf(limit));
        params.put("show_read_receipt", String.valueOf(true));
        params.put("show_delivery_receipt", String.valueOf(true));
        params.put("member", String.valueOf(true));
        params.put("show_empty", String.valueOf(includeEmpty));
        params.put("order", order);
        return this.requestGET(url, params, null);
    }

    JsonElement loadUserGroupChannelList(String token, int limit, boolean includeEmpty, boolean includeFrozen, String order, String metaDataOrderKey, GroupChannelListQuery.FilterMode mode, List<String> filter, GroupChannelListQuery.QueryType queryType, String searchQuery, List<GroupChannelListQuery.SearchField> searchFields, String customType, String customTypeStartsWith, String memberState, List<String> channelUrls, String nameContains, List<String> customTypes, GroupChannelListQuery.SuperChannelFilter superChannelFilter, GroupChannelListQuery.PublicChannelFilter publicChannelFilter, GroupChannelListQuery.UnreadChannelFilter unreadChannelFilter, GroupChannelListQuery.HiddenChannelFilter hiddenChannelFilter) throws SendBirdException {
        String key;
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_MYGROUPCHANNELS.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", token);
        params.put("limit", String.valueOf(limit));
        params.put("show_read_receipt", String.valueOf(true));
        params.put("show_delivery_receipt", String.valueOf(true));
        params.put("show_member", String.valueOf(true));
        params.put("show_empty", String.valueOf(includeEmpty));
        params.put("show_frozen", String.valueOf(includeFrozen));
        params.put("distinct_mode", "all");
        params.put("order", order);
        if (order.equals("metadata_value_alphabetical") && metaDataOrderKey != null) {
            params.put("metadata_order_key", metaDataOrderKey);
        }
        if (customType != null) {
            params.put("custom_type", customType);
        }
        if (customTypeStartsWith != null) {
            params.put("custom_type_startswith", customTypeStartsWith);
        }
        if (memberState != null) {
            params.put("member_state_filter", memberState);
        }
        if (nameContains != null) {
            params.put("name_contains", nameContains);
        }
        if (mode == GroupChannelListQuery.FilterMode.MEMBERS_EXACTLY_IN) {
            key = "members_exactly_in";
        } else if (mode == GroupChannelListQuery.FilterMode.MEMBERS_NICKNAME_CONTAINS) {
            key = "members_nickname_contains";
        } else if (mode == GroupChannelListQuery.FilterMode.MEMBERS_INCLUDE_IN) {
            String qt;
            key = "members_include_in";
            String string = queryType == GroupChannelListQuery.QueryType.AND ? "AND" : (qt = queryType == GroupChannelListQuery.QueryType.OR ? "OR" : null);
            if (qt != null) {
                params.put("query_type", qt);
            }
        } else {
            key = null;
        }
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        if (key != null && filter != null && filter.size() > 0) {
            paramsWithListValue.put(key, filter);
        }
        if (searchQuery != null && searchFields != null) {
            params.put("search_query", searchQuery);
            boolean hasChannelNameField = false;
            boolean hasMemberNicknameField = false;
            for (GroupChannelListQuery.SearchField searchField : searchFields) {
                if (searchField == GroupChannelListQuery.SearchField.CHANNEL_NAME) {
                    hasChannelNameField = true;
                }
                if (searchField != GroupChannelListQuery.SearchField.MEMBER_NICKNAME) continue;
                hasMemberNicknameField = true;
            }
            String fields = "";
            if (hasChannelNameField) {
                fields = "channel_name";
            }
            if (hasMemberNicknameField) {
                fields = fields + (fields.isEmpty() ? "" : ",");
                fields = fields + "member_nickname";
            }
            if (!fields.isEmpty()) {
                params.put("search_fields", fields);
            }
        }
        if (channelUrls != null && channelUrls.size() > 0) {
            paramsWithListValue.put("channel_urls", channelUrls);
        }
        if (customTypes != null && customTypes.size() > 0) {
            paramsWithListValue.put("custom_types", customTypes);
        }
        if (superChannelFilter == GroupChannelListQuery.SuperChannelFilter.ALL) {
            params.put("super_mode", "all");
        } else if (superChannelFilter == GroupChannelListQuery.SuperChannelFilter.SUPER_CHANNEL_ONLY) {
            params.put("super_mode", "super");
        } else if (superChannelFilter == GroupChannelListQuery.SuperChannelFilter.NONSUPER_CHANNEL_ONLY) {
            params.put("super_mode", "nonsuper");
        }
        if (publicChannelFilter == GroupChannelListQuery.PublicChannelFilter.ALL) {
            params.put("public_mode", "all");
        } else if (publicChannelFilter == GroupChannelListQuery.PublicChannelFilter.PUBLIC) {
            params.put("public_mode", "public");
        } else if (publicChannelFilter == GroupChannelListQuery.PublicChannelFilter.PRIVATE) {
            params.put("public_mode", "private");
        }
        if (unreadChannelFilter == GroupChannelListQuery.UnreadChannelFilter.ALL) {
            params.put("unread_filter", "all");
        } else if (unreadChannelFilter == GroupChannelListQuery.UnreadChannelFilter.UNREAD_MESSAGE) {
            params.put("unread_filter", "unread_message");
        }
        if (hiddenChannelFilter == GroupChannelListQuery.HiddenChannelFilter.UNHIDDEN) {
            params.put("hidden_mode", "unhidden_only");
        } else if (hiddenChannelFilter == GroupChannelListQuery.HiddenChannelFilter.HIDDEN) {
            params.put("hidden_mode", "hidden_only");
        } else if (hiddenChannelFilter == GroupChannelListQuery.HiddenChannelFilter.HIDDEN_ALLOW_AUTO_UNHIDE) {
            params.put("hidden_mode", "hidden_allow_auto_unhide");
        } else if (hiddenChannelFilter == GroupChannelListQuery.HiddenChannelFilter.HIDDEN_PREVENT_AUTO_UNHIDE) {
            params.put("hidden_mode", "hidden_prevent_auto_unhide");
        }
        return this.requestGET(url, params, paramsWithListValue);
    }

    JsonElement loadPublicGroupChannelList(String token, int limit, boolean includeEmpty, boolean includeFrozen, String order, String metaDataOrderKey, String customTypeStartsWith, String memberState, List<String> channelUrls, String nameContains, List<String> customTypes, PublicGroupChannelListQuery.SuperChannelFilter superChannelFilter, PublicGroupChannelListQuery.MembershipFilter membershipFilter) throws SendBirdException {
        String path = API.GROUPCHANNELS.publicUrl();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("public_mode", "public");
        params.put("token", token);
        params.put("limit", String.valueOf(limit));
        params.put("show_read_receipt", String.valueOf(true));
        params.put("show_delivery_receipt", String.valueOf(true));
        params.put("show_member", String.valueOf(true));
        params.put("show_empty", String.valueOf(includeEmpty));
        params.put("show_frozen", String.valueOf(includeFrozen));
        params.put("distinct_mode", "all");
        params.put("order", order);
        if (order.equals("metadata_value_alphabetical") && metaDataOrderKey != null) {
            params.put("metadata_order_key", metaDataOrderKey);
        }
        if (customTypeStartsWith != null) {
            params.put("custom_type_startswith", customTypeStartsWith);
        }
        if (memberState != null) {
            params.put("member_state_filter", memberState);
        }
        if (nameContains != null) {
            params.put("name_contains", nameContains);
        }
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        if (channelUrls != null && channelUrls.size() > 0) {
            paramsWithListValue.put("channel_urls", channelUrls);
        }
        if (customTypes != null && customTypes.size() > 0) {
            paramsWithListValue.put("custom_types", customTypes);
        }
        if (superChannelFilter == PublicGroupChannelListQuery.SuperChannelFilter.ALL) {
            params.put("super_mode", "all");
        } else if (superChannelFilter == PublicGroupChannelListQuery.SuperChannelFilter.SUPER_CHANNEL_ONLY) {
            params.put("super_mode", "super");
        } else if (superChannelFilter == PublicGroupChannelListQuery.SuperChannelFilter.NONSUPER_CHANNEL_ONLY) {
            params.put("super_mode", "nonsuper");
        }
        if (membershipFilter == PublicGroupChannelListQuery.MembershipFilter.ALL) {
            params.put("public_membership_mode", "all");
        } else if (membershipFilter == PublicGroupChannelListQuery.MembershipFilter.JOINED) {
            params.put("public_membership_mode", "joined");
        }
        return this.requestGET(path, params, paramsWithListValue);
    }

    JsonElement loadOpenChannelParticipantList(String channelUrl, String token, int limit) throws SendBirdException {
        String path = String.format(API.OPENCHANNELS_CHANNELURL_PARTICIPANTS.publicUrl(), API.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", token);
        params.put("limit", String.valueOf(limit));
        return this.requestGET(path, params, null);
    }

    JsonElement loadMutedUserList(boolean isOpenChannel, String channelUrl, String token, int limit) throws SendBirdException {
        String path = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_MUTE.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL_MUTE.publicUrl(), API.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", token);
        params.put("limit", String.valueOf(limit));
        return this.requestGET(path, params, null);
    }

    JsonElement loadBannedUserList(boolean isOpenChannel, String channelUrl, String token, int limit) throws SendBirdException {
        String path = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_BAN.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL_BAN.publicUrl(), API.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", token);
        params.put("limit", String.valueOf(limit));
        return this.requestGET(path, params, null);
    }

    JsonElement loadOperatorList(boolean isOpenChannel, String channelUrl, String token, int limit) throws SendBirdException {
        String path = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_OPERATORS.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL_OPERATORS.publicUrl(), API.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", token);
        params.put("limit", String.valueOf(limit));
        return this.requestGET(path, params, null);
    }

    JsonElement registerPushToken(SendBird.PushTokenType type, String token, boolean unique, boolean alwaysPushOn, boolean isInternal) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_PUSH_REGISTER.url(isInternal), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), type.getValue());
        JsonObject form = this.defaultForm();
        switch (type) {
            case HMS: {
                form.addProperty("huawei_device_token", token);
                break;
            }
            case GCM: 
            case APNS: 
            case APNS_VOIP: {
                form.addProperty("gcm_reg_token", token);
                break;
            }
        }
        form.addProperty("is_unique", Boolean.valueOf(unique));
        form.addProperty("always_push", Boolean.valueOf(alwaysPushOn));
        return this.requestPOST(url, (JsonElement)form);
    }

    JsonElement unregisterPushToken(SendBird.PushTokenType type, String token) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_PUSH_UNREGISTER.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), type.getValue(), API.urlEncodeUTF8(token));
        JsonObject form = this.defaultForm();
        return this.requestDELETE(url, (JsonElement)form);
    }

    JsonElement unregisterPushTokenAll() throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_PUSH.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        JsonObject form = this.defaultForm();
        return this.requestDELETE(url, (JsonElement)form);
    }

    JsonElement getMyPushTokens(String token, SendBird.PushTokenType type) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_PUSH_TOKENTYPE_DEVICETOKENS.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), type.getValue());
        HashMap<String, String> params = new HashMap<String, String>();
        if (token != null) {
            params.put("token", token);
        }
        return this.requestGET(url, params, null);
    }

    JsonElement setPushTemplate(String template) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_PUSH_TEMPLATE.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        JsonObject form = this.defaultForm();
        form.addProperty("name", template);
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement getPushTemplate() throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String path = String.format(API.USERS_USERID_PUSH_TEMPLATE.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        return this.requestGET(path);
    }

    JsonElement setPushTriggerOption(SendBird.PushTriggerOption pushTriggerOption) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        JsonObject form = this.defaultForm();
        form.addProperty("push_trigger_option", pushTriggerOption.getValue());
        String url = String.format(API.USERS_USERID_PUSHPREFERENCE.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement getPushTriggerOption() throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_PUSHPREFERENCE.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        return this.requestGET(url);
    }

    JsonElement setAutoAcceptInvitation(boolean autoAccept) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_CHANNELINVITATIONPREFERENCE.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        JsonObject form = this.defaultForm();
        form.addProperty("auto_accept", Boolean.valueOf(autoAccept));
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement getAutoAcceptInvitation() throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_CHANNELINVITATIONPREFERENCE.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        return this.requestGET(url);
    }

    JsonElement blockUser(String blockeeUserId) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_BLOCK.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        JsonObject form = this.defaultForm();
        form.addProperty("target_id", blockeeUserId);
        return this.requestPOST(url, (JsonElement)form);
    }

    JsonElement unblockUser(String blockeeUserId) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_BLOCK_TARGETID.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), API.urlEncodeUTF8(blockeeUserId));
        JsonObject form = this.defaultForm();
        return this.requestDELETE(url, (JsonElement)form);
    }

    JsonElement addFriends(List<String> userIds) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_FRIENDS.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        JsonObject form = this.defaultForm();
        JsonArray userIdsObj = new JsonArray();
        for (String friendUserId : userIds) {
            userIdsObj.add(friendUserId);
        }
        form.add("user_ids", (JsonElement)userIdsObj);
        return this.requestPOST(url, (JsonElement)form);
    }

    JsonElement deleteFriends(List<String> userIds) throws SendBirdException {
        String url = String.format(API.USERS_USERID_FRIENDS.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        paramsWithListValue.put("user_ids", userIds);
        JsonObject form = this.defaultForm();
        return this.requestDELETE(url, null, paramsWithListValue, (JsonElement)form);
    }

    JsonElement deleteFriend(String friendUserId) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_FRIENDS_USERID.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), API.urlEncodeUTF8(friendUserId));
        JsonObject form = this.defaultForm();
        return this.requestDELETE(url, (JsonElement)form);
    }

    JsonElement uploadFriendDiscoveries(Map<String, String> discoveries) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_FRIENDDISCOVERIES.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        JsonObject form = this.defaultForm();
        JsonArray discoveriesArray = new JsonArray();
        for (String key : discoveries.keySet()) {
            if (key == null || key.length() <= 0) continue;
            String value = discoveries.get(key);
            JsonObject discoveryObj = new JsonObject();
            discoveryObj.addProperty("friend_discovery_key", key);
            discoveryObj.addProperty("friend_name", value);
            discoveriesArray.add((JsonElement)discoveryObj);
        }
        form.add("friend_discoveries", (JsonElement)discoveriesArray);
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement deleteFriendDiscoveries(List<String> discoveryKeys) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_FRIENDDISCOVERIES.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        paramsWithListValue.put("friend_discovery_keys", discoveryKeys);
        JsonObject form = this.defaultForm();
        return this.requestDELETE(url, null, paramsWithListValue, (JsonElement)form);
    }

    JsonElement deleteFriendDiscovery(String discoveryKey) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_FRIENDDISCOVERIES_DISCOVERYKEY.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), API.urlEncodeUTF8(discoveryKey));
        JsonObject form = this.defaultForm();
        return this.requestDELETE(url, (JsonElement)form);
    }

    JsonElement getFriendChangeLogsByToken(String token) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_FRIENDS_CHANGELOGS.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        HashMap<String, String> params = new HashMap<String, String>();
        if (token != null) {
            params.put("token", token);
        }
        return this.requestGET(url, params, null);
    }

    JsonElement loadFriendList(String token, int limit) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_FRIENDS.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        HashMap<String, String> params = new HashMap<String, String>();
        if (token != null) {
            params.put("token", token);
        }
        params.put("limit", String.valueOf(limit));
        return this.requestGET(url, params, null);
    }

    JsonElement loadGroupChannelMemberList(String channelUrl, String token, int limit, GroupChannelMemberListQuery.OperatorFilter operatorFilter, GroupChannelMemberListQuery.MutedMemberFilter mutedMemberFilter, String order, String memberState, String nicknameStartsWith) throws SendBirdException {
        String url = String.format(API.GROUPCHANNELS_CHANNELURL_MEMBERS.publicUrl(), API.urlEncodeUTF8(channelUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        if (token != null) {
            params.put("token", token);
        }
        params.put("limit", String.valueOf(limit));
        params.put("order", order);
        params.put("operator_filter", operatorFilter.getValue());
        if (mutedMemberFilter == GroupChannelMemberListQuery.MutedMemberFilter.ALL) {
            params.put("muted_member_filter", "all");
        } else if (mutedMemberFilter == GroupChannelMemberListQuery.MutedMemberFilter.MUTED) {
            params.put("muted_member_filter", "muted");
        } else if (mutedMemberFilter == GroupChannelMemberListQuery.MutedMemberFilter.UNMUTED) {
            params.put("muted_member_filter", "unmuted");
        }
        params.put("member_state_filter", memberState);
        if (nicknameStartsWith != null) {
            params.put("nickname_startswith", nicknameStartsWith);
        }
        params.put("show_read_receipt", String.valueOf(true));
        params.put("show_delivery_receipt", String.valueOf(true));
        params.put("show_member_is_muted", String.valueOf(true));
        return this.requestGET(url, params, null);
    }

    JsonElement banUser(boolean isOpenChannel, String channelUrl, String userId, String description, int seconds) throws SendBirdException {
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_BAN.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL_BAN.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", userId);
        if (description != null) {
            form.addProperty("description", description);
        }
        form.addProperty("seconds", String.valueOf(seconds));
        return this.requestPOST(url, (JsonElement)form);
    }

    JsonElement unbanUser(boolean isOpenChannel, String channelUrl, String userId) throws SendBirdException {
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_BAN_USERID.publicUrl(), API.urlEncodeUTF8(channelUrl), API.urlEncodeUTF8(userId)) : String.format(API.GROUPCHANNELS_CHANNELURL_BAN_USERID.publicUrl(), API.urlEncodeUTF8(channelUrl), API.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        return this.requestDELETE(url, (JsonElement)form);
    }

    JsonElement muteUser(boolean isOpenChannel, String channelUrl, String userId, String description, Integer seconds) throws SendBirdException {
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_MUTE.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL_MUTE.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", userId);
        if (description != null) {
            form.addProperty("description", description);
        }
        if (seconds != null) {
            form.addProperty("seconds", String.valueOf(seconds));
        }
        return this.requestPOST(url, (JsonElement)form);
    }

    JsonElement unmuteUser(boolean isOpenChannel, String channelUrl, String userId) throws SendBirdException {
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_MUTE_USERID.publicUrl(), API.urlEncodeUTF8(channelUrl), API.urlEncodeUTF8(userId)) : String.format(API.GROUPCHANNELS_CHANNELURL_MUTE_USERID.publicUrl(), API.urlEncodeUTF8(channelUrl), API.urlEncodeUTF8(userId));
        JsonObject form = this.defaultForm();
        return this.requestDELETE(url, (JsonElement)form);
    }

    JsonElement freezeGroupChannel(String channelUrl, boolean freeze) throws SendBirdException {
        String url = String.format(API.GROUPCHANNELS_CHANNELURL_FREEZE.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("freeze", Boolean.valueOf(freeze));
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement getTotalUnreadMessageCount(GroupChannelTotalUnreadMessageCountParams.SuperChannelFilter superChannelFilter, List<String> channelCustomTypes) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_UNREADMESSAGECOUNT.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        HashMap<String, String> params = new HashMap<String, String>();
        if (superChannelFilter == GroupChannelTotalUnreadMessageCountParams.SuperChannelFilter.ALL) {
            params.put("super_mode", "all");
        } else if (superChannelFilter == GroupChannelTotalUnreadMessageCountParams.SuperChannelFilter.SUPER_CHANNEL_ONLY) {
            params.put("super_mode", "super");
        } else if (superChannelFilter == GroupChannelTotalUnreadMessageCountParams.SuperChannelFilter.NONSUPER_CHANNEL_ONLY) {
            params.put("super_mode", "nonsuper");
        }
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        if (channelCustomTypes != null && channelCustomTypes.size() > 0) {
            paramsWithListValue.put("custom_types", channelCustomTypes);
        }
        return this.requestGET(url, params, paramsWithListValue);
    }

    JsonElement getUnreadItemCount(Collection<GroupChannel.UnreadItemKey> keys) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_UNREADITEMCOUNT.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        HashMap<String, Collection<String>> paramsWithListValue = new HashMap<String, Collection<String>>();
        LinkedHashSet<String> itemKeys = new LinkedHashSet<String>();
        for (GroupChannel.UnreadItemKey key : keys) {
            if (key == GroupChannel.UnreadItemKey.GROUP_CHANNEL_UNREAD_MESSAGE_COUNT) {
                itemKeys.add("group_channel_unread_message_count");
                continue;
            }
            if (key == GroupChannel.UnreadItemKey.GROUP_CHANNEL_UNREAD_MENTION_COUNT) {
                itemKeys.add("group_channel_unread_mention_count");
                continue;
            }
            if (key == GroupChannel.UnreadItemKey.GROUP_CHANNEL_INVITATION_COUNT) {
                itemKeys.add("group_channel_invitation_count");
                continue;
            }
            if (key == GroupChannel.UnreadItemKey.NONSUPER_UNREAD_MESSAGE_COUNT) {
                itemKeys.add("non_super_group_channel_unread_message_count");
                continue;
            }
            if (key == GroupChannel.UnreadItemKey.SUPER_UNREAD_MESSAGE_COUNT) {
                itemKeys.add("super_group_channel_unread_message_count");
                continue;
            }
            if (key == GroupChannel.UnreadItemKey.NONSUPER_UNREAD_MENTION_COUNT) {
                itemKeys.add("non_super_group_channel_unread_mention_count");
                continue;
            }
            if (key == GroupChannel.UnreadItemKey.SUPER_UNREAD_MENTION_COUNT) {
                itemKeys.add("super_group_channel_unread_mention_count");
                continue;
            }
            if (key == GroupChannel.UnreadItemKey.NONSUPER_INVITATION_COUNT) {
                itemKeys.add("non_super_group_channel_invitation_count");
                continue;
            }
            if (key != GroupChannel.UnreadItemKey.SUPER_INVITATION_COUNT) continue;
            itemKeys.add("super_group_channel_invitation_count");
        }
        if (itemKeys.size() > 0) {
            paramsWithListValue.put("item_keys", itemKeys);
        }
        return this.requestGET(url, null, paramsWithListValue);
    }

    JsonElement getTotalUnreadChannelCount() throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_UNREADCHANNELCOUNT.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        return this.requestGET(url);
    }

    JsonElement getChannelCount(String state) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_GROUPCHANNELCOUNT.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        HashMap<String, String> params = new HashMap<String, String>();
        if (state != null) {
            params.put("state", state);
        }
        return this.requestGET(url, params, null);
    }

    JsonElement setDoNotDisturb(boolean enable, int startHour, int startMin, int endHour, int endMin, String timezone) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_PUSHPREFERENCE.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        JsonObject form = this.defaultForm();
        form.addProperty("do_not_disturb", Boolean.valueOf(enable));
        form.addProperty("start_hour", (Number)startHour);
        form.addProperty("start_min", (Number)startMin);
        form.addProperty("end_hour", (Number)endHour);
        form.addProperty("end_min", (Number)endMin);
        form.addProperty("timezone", timezone);
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement getDoNotDisturb() throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String path = String.format(API.USERS_USERID_PUSHPREFERENCE.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        return this.requestGET(path);
    }

    JsonElement setSnoozePeriod(boolean enable, long startTs, long endTs) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_PUSHPREFERENCE.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        JsonObject form = this.defaultForm();
        form.addProperty("snooze_enabled", Boolean.valueOf(enable));
        form.addProperty("snooze_start_ts", (Number)startTs);
        form.addProperty("snooze_end_ts", (Number)endTs);
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement getSnoozePeriod() throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_PUSHPREFERENCE.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        return this.requestGET(url);
    }

    JsonElement setPushSound(String sound) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_PUSHPREFERENCE.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        JsonObject form = this.defaultForm();
        form.addProperty("push_sound", sound);
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement getPushSound() throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_PUSHPREFERENCE.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        return this.requestGET(url);
    }

    JsonElement setPushPreference(String channelUrl, boolean value) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_PUSHPREFERENCE_CHANNELURL.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        form.addProperty("enable", Boolean.valueOf(value));
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement getPushPreference(String channelUrl) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_PUSHPREFERENCE_CHANNELURL.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), API.urlEncodeUTF8(channelUrl));
        return this.requestGET(url);
    }

    JsonElement setMyPushTriggerOption(String channelUrl, GroupChannel.PushTriggerOption pushTriggerOption) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        JsonObject form = this.defaultForm();
        if (pushTriggerOption == GroupChannel.PushTriggerOption.ALL) {
            form.addProperty("push_trigger_option", "all");
        } else if (pushTriggerOption == GroupChannel.PushTriggerOption.OFF) {
            form.addProperty("push_trigger_option", "off");
        } else if (pushTriggerOption == GroupChannel.PushTriggerOption.MENTION_ONLY) {
            form.addProperty("push_trigger_option", "mention_only");
        } else if (pushTriggerOption == GroupChannel.PushTriggerOption.DEFAULT) {
            form.addProperty("push_trigger_option", "default");
        }
        String url = String.format(API.USERS_USERID_PUSHPREFERENCE_CHANNELURL.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), API.urlEncodeUTF8(channelUrl));
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement getMyPushTriggerOption(String channelUrl) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_PUSHPREFERENCE_CHANNELURL.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), API.urlEncodeUTF8(channelUrl));
        return this.requestGET(url);
    }

    JsonElement setMyCountPreference(String channelUrl, GroupChannel.CountPreference preference) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.USERS_USERID_COUNTPREFERENCE_CHANNELURL.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        if (preference != null) {
            if (preference == GroupChannel.CountPreference.ALL) {
                form.addProperty("count_preference", "all");
            } else if (preference == GroupChannel.CountPreference.UNREAD_MESSAGE_COUNT_ONLY) {
                form.addProperty("count_preference", "unread_message_count_only");
            } else if (preference == GroupChannel.CountPreference.UNREAD_MENTION_COUNT_ONLY) {
                form.addProperty("count_preference", "unread_mention_count_only");
            } else if (preference == GroupChannel.CountPreference.OFF) {
                form.addProperty("count_preference", "off");
            }
        }
        return this.requestPUT(url, (JsonElement)form);
    }

    JsonElement getMessage(MessageRetrievalParams messageRetrievalParams) throws SendBirdException {
        HashMap<String, String> params = new HashMap<String, String>();
        String path = messageRetrievalParams.channelType == BaseChannel.ChannelType.OPEN ? String.format(API.OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID.publicUrl(), API.urlEncodeUTF8(messageRetrievalParams.channelUrl), messageRetrievalParams.messageId) : String.format(API.GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID.publicUrl(), API.urlEncodeUTF8(messageRetrievalParams.channelUrl), messageRetrievalParams.messageId);
        if (messageRetrievalParams.includeMetaArray) {
            params.put("with_sorted_meta_array", String.valueOf(true));
        }
        if (messageRetrievalParams.includeThreadInfo) {
            params.put("include_thread_info", String.valueOf(true));
        }
        if (messageRetrievalParams.includeParentMessageText) {
            params.put("include_parent_message_text", String.valueOf(true));
        }
        return this.requestGET(path, params, null);
    }

    JsonElement deleteMessage(boolean isOpenChannel, String channelUrl, long messageId) throws SendBirdException {
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID.publicUrl(), API.urlEncodeUTF8(channelUrl), messageId) : String.format(API.GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID.publicUrl(), API.urlEncodeUTF8(channelUrl), messageId);
        JsonObject form = this.defaultForm();
        return this.requestDELETE(url, (JsonElement)form);
    }

    JsonElement deleteChannel(boolean isOpenChannel, String channelUrl) throws SendBirdException {
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.GROUPCHANNELS_CHANNELURL.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        return this.requestDELETE(url, (JsonElement)form);
    }

    JsonElement addReaction(boolean isOpenChannel, String channelUrl, long messageId, String key) throws SendBirdException {
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID_REACTIONS.publicUrl(), API.urlEncodeUTF8(channelUrl), messageId) : String.format(API.GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID_REACTIONS.publicUrl(), API.urlEncodeUTF8(channelUrl), messageId);
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
        if (key != null) {
            form.addProperty("reaction", key);
        }
        return this.requestPOST(url, (JsonElement)form);
    }

    JsonElement deleteReaction(boolean isOpenChannel, String channelUrl, long messageId, String key) throws SendBirdException {
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID_REACTIONS.publicUrl(), API.urlEncodeUTF8(channelUrl), messageId) : String.format(API.GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID_REACTIONS.publicUrl(), API.urlEncodeUTF8(channelUrl), messageId);
        JsonObject form = this.defaultForm();
        form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
        form.addProperty("msg_id", (Number)messageId);
        if (key != null) {
            form.addProperty("reaction", key);
        }
        form.addProperty("updated_at", (Number)System.currentTimeMillis());
        return this.requestDELETE(url, (JsonElement)form);
    }

    JsonElement queryFullTextMessageSearch(String query, String channelUrl, String channelCustomType, int limit, Object before, Object after, String token, Long messageTsFrom, Long messageTsTo, String order, boolean reverse, boolean exactMatch) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("query", query);
        if (!TextUtils.isEmpty((CharSequence)channelUrl)) {
            params.put("channel_url", channelUrl);
        }
        if (!TextUtils.isEmpty((CharSequence)channelCustomType)) {
            params.put("custom_type", channelCustomType);
        }
        params.put("limit", String.valueOf(limit));
        if (before != null) {
            params.put("before", String.valueOf(before));
        }
        if (after != null) {
            params.put("after", String.valueOf(after));
        }
        if (!TextUtils.isEmpty((CharSequence)token)) {
            params.put("token", token);
        }
        if (messageTsFrom > 0L) {
            params.put("message_ts_from", String.valueOf(messageTsFrom));
        }
        if (messageTsTo < Long.MAX_VALUE) {
            params.put("message_ts_to", String.valueOf(messageTsTo));
        }
        params.put("sort_field", order);
        params.put("reverse", String.valueOf(reverse));
        params.put("exact_match", String.valueOf(exactMatch));
        return this.requestGET(API.SEARCH_MESSAGES.publicUrl(), params, null);
    }

    JsonElement getMyMutedInfo(boolean isOpenChannel, String channelUrl) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = isOpenChannel ? String.format(API.OPENCHANNELS_CHANNELURL_MUTE_USERID.publicUrl(), API.urlEncodeUTF8(channelUrl), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId())) : String.format(API.GROUPCHANNELS_CHANNELURL_MUTE_USERID.publicUrl(), API.urlEncodeUTF8(channelUrl), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        return this.requestGET(url);
    }

    JsonElement reportChannel(boolean isOpenChannel, String channelUrl, BaseChannel.ReportCategory reportCategory, String reportDescription) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = isOpenChannel ? String.format(API.REPORT_OPENCHANNELS_CHANNELURL.publicUrl(), API.urlEncodeUTF8(channelUrl)) : String.format(API.REPORT_GROUPCHANNELS_CHANNELURL.publicUrl(), API.urlEncodeUTF8(channelUrl));
        JsonObject form = this.defaultForm();
        if (reportCategory != null) {
            switch (reportCategory) {
                case SUSPICIOUS: {
                    form.addProperty("report_category", "suspicious");
                    break;
                }
                case HARASSING: {
                    form.addProperty("report_category", "harassing");
                    break;
                }
                case SPAM: {
                    form.addProperty("report_category", "spam");
                    break;
                }
                case INAPPROPRIATE: {
                    form.addProperty("report_category", "inappropriate");
                }
            }
        }
        if (reportDescription != null) {
            form.addProperty("report_description", reportDescription);
        }
        form.addProperty("reporting_user_id", SendBird.getCurrentUser().getUserId());
        return this.requestPOST(url, (JsonElement)form);
    }

    JsonElement reportUser(boolean isOpenChannel, String channelUrl, String offendingUserId, BaseChannel.ReportCategory reportCategory, String reportDescription) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = String.format(API.REPORT_USERS_OFFENDINGUSERID.publicUrl(), API.urlEncodeUTF8(offendingUserId));
        JsonObject form = this.defaultForm();
        form.addProperty("channel_type", isOpenChannel ? "open_channels" : "group_channels");
        if (channelUrl != null) {
            form.addProperty("channel_url", channelUrl);
        }
        if (reportCategory != null) {
            switch (reportCategory) {
                case SUSPICIOUS: {
                    form.addProperty("report_category", "suspicious");
                    break;
                }
                case HARASSING: {
                    form.addProperty("report_category", "harassing");
                    break;
                }
                case SPAM: {
                    form.addProperty("report_category", "spam");
                    break;
                }
                case INAPPROPRIATE: {
                    form.addProperty("report_category", "inappropriate");
                }
            }
        }
        if (reportDescription != null) {
            form.addProperty("report_description", reportDescription);
        }
        form.addProperty("reporting_user_id", SendBird.getCurrentUser().getUserId());
        return this.requestPOST(url, (JsonElement)form);
    }

    JsonElement reportMessage(boolean isOpenChannel, String channelUrl, String offendingUserId, long messageId, BaseChannel.ReportCategory reportCategory, String reportDescription) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = isOpenChannel ? String.format(API.REPORT_OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID.publicUrl(), API.urlEncodeUTF8(channelUrl), messageId) : String.format(API.REPORT_GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID.publicUrl(), API.urlEncodeUTF8(channelUrl), messageId);
        JsonObject form = this.defaultForm();
        if (offendingUserId != null) {
            form.addProperty("offending_user_id", offendingUserId);
        }
        if (reportCategory != null) {
            switch (reportCategory) {
                case SUSPICIOUS: {
                    form.addProperty("report_category", "suspicious");
                    break;
                }
                case HARASSING: {
                    form.addProperty("report_category", "harassing");
                    break;
                }
                case SPAM: {
                    form.addProperty("report_category", "spam");
                    break;
                }
                case INAPPROPRIATE: {
                    form.addProperty("report_category", "inappropriate");
                }
            }
        }
        if (reportDescription != null) {
            form.addProperty("report_description", reportDescription);
        }
        form.addProperty("reporting_user_id", SendBird.getCurrentUser().getUserId());
        return this.requestPOST(url, (JsonElement)form);
    }

    JsonElement getAllEmoji() throws SendBirdException {
        return this.requestGET(API.EMOJI_CATEGORIES.publicUrl());
    }

    JsonElement getEmojiCategory(long emojiCategoryId) throws SendBirdException {
        String url = String.format(API.EMOJI_CATEGORY.publicUrl(), emojiCategoryId);
        return this.requestGET(url);
    }

    JsonElement getEmoji(String key) throws SendBirdException {
        String url = String.format(API.EMOJI.publicUrl(), API.urlEncodeUTF8(key));
        return this.requestGET(url);
    }

    JsonElement addOperators(BaseChannel channel, Collection<String> userIds) throws SendBirdException {
        return this.operatorOps(channel, true, userIds, false);
    }

    JsonElement removeOperators(BaseChannel channel, Collection<String> userIds) throws SendBirdException {
        return this.operatorOps(channel, false, userIds, false);
    }

    JsonElement removeAllOperators(BaseChannel channel) throws SendBirdException {
        return this.operatorOps(channel, false, null, true);
    }

    private JsonElement operatorOps(BaseChannel channel, boolean isAdd, Collection<String> userIds, boolean isDeleteAll) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        String url = channel.isOpenChannel() ? String.format(API.OPENCHANNELS_CHANNELURL_OPERATORS.publicUrl(), channel.getUrl()) : String.format(API.GROUPCHANNELS_CHANNELURL_OPERATORS.publicUrl(), channel.getUrl());
        JsonObject form = this.defaultForm();
        if (isDeleteAll) {
            form.addProperty("delete_all", Boolean.valueOf(true));
        } else if (userIds != null && !userIds.isEmpty()) {
            JsonArray ids = new JsonArray(userIds.size());
            for (String userId : userIds) {
                ids.add(userId);
            }
            form.add("operator_ids", (JsonElement)ids);
        }
        if (isAdd) {
            return this.requestPOST(url, (JsonElement)form);
        }
        return this.requestDELETE(url, (JsonElement)form);
    }

    JsonElement refreshSessionKey(String token) throws SendBirdException {
        if (SendBird.getCurrentUser() == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        JsonObject form = this.defaultForm();
        String path = String.format(API.USERS_USERID_SESSION_KEY.publicUrl(), API.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
        if (SendBird.getSessionHandler() != null) {
            form.addProperty("expiring_session", Boolean.valueOf(true));
        }
        HashMap<String, String> customHeader = new HashMap<String, String>();
        customHeader.put("App-Id", SendBird.getApplicationId());
        if (!TextUtils.isEmpty((CharSequence)token)) {
            customHeader.put("Access-Token", token);
        }
        String formJson = sGson.toJson((JsonElement)form);
        Logger.d("API request: " + formJson);
        LoggerV2.d("API request: " + formJson);
        RequestBody body = RequestBody.create((MediaType)MIME_JSON, (String)formJson);
        return new SessionAPIRequest(this.getClient(false), customHeader).POST(path, body);
    }

    synchronized boolean setSessionKey(String sessionKey) {
        if (sessionKey == null) {
            return false;
        }
        if (this.mSessionKey == null || !this.mSessionKey.equals(sessionKey)) {
            this.mSessionKey = sessionKey;
            User user = SendBird.getCurrentUser();
            if (user != null) {
                KeyStore.saveSessionKey(user.getUserId(), sessionKey);
            } else {
                KeyStore.clearAll();
            }
            return true;
        }
        return false;
    }

    synchronized String getSessionKey() {
        if (TextUtils.isEmpty((CharSequence)this.mSessionKey)) {
            this.mSessionKey = KeyStore.getSessionKey();
        }
        return this.mSessionKey;
    }

    public void makeDummyCallToKeepConnectionAlive() {
        APITaskQueue.addTask(new JobTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                return new APIRequest(APIClient.this.getClient(false)).GET("");
            }
        });
    }

    private JsonElement requestGET(String path) throws SendBirdException {
        return this.requestGET(path, null, null);
    }

    private JsonElement requestGET(String path, Map<String, String> params, Map<String, Collection<String>> paramsWithListValue) throws SendBirdException {
        path = this.getQueryUrl(path, params, paramsWithListValue);
        return new APIRequest(this.getClient(false)).GET(path);
    }

    private JsonElement requestPOST(String path, JsonElement form) throws SendBirdException {
        String formJson = sGson.toJson(form);
        Logger.d("API request: " + formJson);
        LoggerV2.d("API request: " + formJson);
        RequestBody body = RequestBody.create((MediaType)MIME_JSON, (String)formJson);
        return new APIRequest(this.getClient(false)).POST(path, body);
    }

    private JsonElement requestPOST(String path, Map<String, String> form, String fieldFilename, File file) throws SendBirdException {
        ArrayList<Headers> partHeaders = new ArrayList<Headers>();
        ArrayList<RequestBody> partBodies = new ArrayList<RequestBody>();
        for (Map.Entry<String, String> content : form.entrySet()) {
            partHeaders.add(Headers.of((String[])new String[]{"Content-Disposition", String.format("form-data; name=\"%s\"", content.getKey())}));
            partBodies.add(RequestBody.create(null, (String)content.getValue()));
        }
        if (fieldFilename != null && file != null) {
            String fileMime = APIClient.checkMimeType(file, null);
            MediaType MIME_FILE = MediaType.parse((String)fileMime);
            Logger.d("File: " + file);
            LoggerV2.d("File: " + file);
            Logger.d("Mime: " + fileMime);
            LoggerV2.d("Mime: " + fileMime);
            partHeaders.add(Headers.of((String[])new String[]{"Content-Disposition", String.format("form-data; name=\"%s\"; filename=\"%s\"", fieldFilename, API.urlEncodeUTF8(file.getName())), "Content-Transfer-Encoding", "binary"}));
            partBodies.add(RequestBody.create((MediaType)MIME_FILE, (File)file));
        }
        FixedLengthMultipartRequestBody body = new FixedLengthMultipartRequestBody(partHeaders, partBodies, null, null);
        return new APIRequest(this.getClient(fieldFilename != null && file != null)).POST(path, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonElement uploadFILE(String path, File file, String mimeType, List<FileMessage.ThumbnailSize> thumbnailSizes, String channelUrl, String requestId, APIClientProgressHandler progressHandler) throws SendBirdException {
        Logger.i(">> uploadFILE()", new Object[0]);
        LoggerV2.i(">> uploadFILE()");
        try {
            APIRequest request = new APIRequest(this.getClient(true));
            onGoingRequestsMap.put(requestId, request);
            String fileMime = APIClient.checkMimeType(file, mimeType);
            MediaType MIME_FILE = MediaType.parse((String)fileMime);
            MediaType textMime = MediaType.parse((String)"text/plain");
            Logger.d("File: " + file);
            LoggerV2.d("File: " + file);
            Logger.d("Mime: " + fileMime);
            LoggerV2.d("Mime: " + fileMime);
            ArrayList<Headers> partHeaders = new ArrayList<Headers>();
            ArrayList<RequestBody> partBodies = new ArrayList<RequestBody>();
            partHeaders.add(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"file\"; filename=\"" + API.urlEncodeUTF8(file.getName()) + "\"", "Content-Transfer-Encoding", "binary"}));
            partBodies.add(RequestBody.create((MediaType)MIME_FILE, (File)file));
            if (thumbnailSizes != null) {
                int idx = 1;
                for (FileMessage.ThumbnailSize thumbnailSize : thumbnailSizes) {
                    partHeaders.add(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"thumbnail" + idx + "\""}));
                    partBodies.add(RequestBody.create((MediaType)textMime, (String)(thumbnailSize.getMaxWidth() + "," + thumbnailSize.getMaxHeight())));
                    ++idx;
                }
            }
            if (channelUrl != null) {
                partHeaders.add(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"channel_url\""}));
                partBodies.add(RequestBody.create((MediaType)textMime, (String)channelUrl));
            }
            FixedLengthMultipartRequestBody body = new FixedLengthMultipartRequestBody(partHeaders, partBodies, progressHandler, requestId);
            Logger.i("++ requestId : %s", requestId);
            LoggerV2.i("++ requestId : %s", requestId);
            JsonElement jsonElement = request.POST(path, body);
            return jsonElement;
        }
        finally {
            onGoingRequestsMap.remove(requestId);
        }
    }

    static String checkMimeType(File file, String mimeType) throws SendBirdException {
        String fileMime;
        try {
            fileMime = mimeType != null && mimeType.length() > 0 ? mimeType : file.toURI().toURL().openConnection().getContentType();
        }
        catch (IOException e) {
            throw new SendBirdException(e.getMessage(), 800220);
        }
        catch (StringIndexOutOfBoundsException e2) {
            fileMime = "application/octet-stream";
        }
        return fileMime;
    }

    private JsonElement requestPUT(String path, JsonElement form) throws SendBirdException {
        return this.requestPUT(path, form, null);
    }

    private JsonElement requestPUT(String path, JsonElement form, Map<String, String> customHeader) throws SendBirdException {
        String formJson = sGson.toJson(form);
        RequestBody body = RequestBody.create((MediaType)MIME_JSON, (String)formJson);
        return new APIRequest(this.getClient(false), customHeader).PUT(path, body);
    }

    private JsonElement requestPUT(String path, Map<String, String> form, String fieldFilename, File file) throws SendBirdException {
        ArrayList<Headers> partHeaders = new ArrayList<Headers>();
        ArrayList<RequestBody> partBodies = new ArrayList<RequestBody>();
        for (Map.Entry<String, String> content : form.entrySet()) {
            if (content == null || content.getKey() == null || content.getValue() == null) continue;
            partHeaders.add(Headers.of((String[])new String[]{"Content-Disposition", String.format("form-data; name=\"%s\"", content.getKey())}));
            partBodies.add(RequestBody.create(null, (String)content.getValue()));
        }
        if (fieldFilename != null && file != null) {
            String fileMime = APIClient.checkMimeType(file, null);
            MediaType MIME_FILE = MediaType.parse((String)fileMime);
            Logger.d("File: " + file);
            LoggerV2.d("File: " + file);
            Logger.d("Mime: " + fileMime);
            LoggerV2.d("Mime: " + fileMime);
            partHeaders.add(Headers.of((String[])new String[]{"Content-Disposition", String.format("form-data; name=\"%s\"; filename=\"%s\"", fieldFilename, API.urlEncodeUTF8(file.getName())), "Content-Transfer-Encoding", "binary"}));
            partBodies.add(RequestBody.create((MediaType)MIME_FILE, (File)file));
        }
        FixedLengthMultipartRequestBody body = new FixedLengthMultipartRequestBody(partHeaders, partBodies, null, null);
        return new APIRequest(this.getClient(fieldFilename != null && file != null)).PUT(path, body);
    }

    private JsonElement requestDELETE(String url, JsonElement form) throws SendBirdException {
        return this.requestDELETE(url, null, null, form);
    }

    private JsonElement requestDELETE(String path, Map<String, String> params, Map<String, Collection<String>> paramsWithListValue, JsonElement form) throws SendBirdException {
        String urlPath = this.getQueryUrl(path, params, paramsWithListValue);
        String formJson = sGson.toJson(form);
        Logger.d("API request: " + formJson);
        LoggerV2.d("API request: " + formJson);
        RequestBody body = RequestBody.create((MediaType)MIME_JSON, (String)formJson);
        return new APIRequest(this.getClient(false)).DELETE(urlPath, body);
    }

    private String getQueryUrl(String path, Map<String, String> params, Map<String, Collection<String>> paramsWithListValue) {
        String queryUrl;
        Object value;
        String key;
        HashMap<String, String> paramsAll = new HashMap<String, String>();
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                key = entry.getKey();
                value = (String)entry.getValue();
                paramsAll.put(API.urlEncodeUTF8(key), API.urlEncodeUTF8((String)value));
            }
        }
        if (paramsWithListValue != null && paramsWithListValue.size() > 0) {
            for (Map.Entry<String, Object> entry : paramsWithListValue.entrySet()) {
                key = entry.getKey();
                value = (Collection)entry.getValue();
                paramsAll.put(API.urlEncodeUTF8(key), API.urlEncodeUTF8((Collection<String>)value));
            }
        }
        if (paramsAll.size() > 0) {
            String query = this.getQueryString(paramsAll);
            queryUrl = path + "?" + query;
        } else {
            queryUrl = path;
        }
        return queryUrl;
    }

    private String getQueryString(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        if (map != null && map.size() > 0) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(String.format("%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        return sb.toString();
    }

    static {
        onGoingRequestsMap = new ConcurrentHashMap<String, APIRequest>();
    }

    private static final class FixedLengthMultipartRequestBody
    extends RequestBody {
        private static final MediaType FORM = MediaType.parse((String)"multipart/form-data");
        private static final byte[] COLONSPACE = new byte[]{58, 32};
        private static final byte[] CRLF = new byte[]{13, 10};
        private static final byte[] DASHDASH = new byte[]{45, 45};
        private final ByteString boundary = ByteString.encodeUtf8((String)UUID.randomUUID().toString());
        private final MediaType contentType = MediaType.parse((String)(FORM + "; boundary=" + this.boundary.utf8()));
        private final List<Headers> partHeaders;
        private final List<RequestBody> partBodies;
        private long totalSent;
        private long totalToSend;
        private final APIClientProgressHandler progressHandler;
        private final String requestId;

        FixedLengthMultipartRequestBody(List<Headers> partHeaders, List<RequestBody> partBodies, APIClientProgressHandler progressHandler, String requestId) {
            this.partHeaders = Util.immutableList(partHeaders);
            this.partBodies = Util.immutableList(partBodies);
            this.totalSent = 0L;
            this.totalToSend = 0L;
            this.progressHandler = progressHandler;
            this.requestId = requestId;
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public long contentLength() throws IOException {
            int length = 0;
            int partCount = this.partHeaders.size();
            for (int p = 0; p < partCount; ++p) {
                MediaType contentType;
                Headers headers = this.partHeaders.get(p);
                RequestBody body = this.partBodies.get(p);
                long contentLength = body.contentLength();
                if (contentLength == -1L) {
                    return -1L;
                }
                length += DASHDASH.length + this.boundary.size() + CRLF.length;
                if (headers != null) {
                    int headerCount = headers.size();
                    for (int h = 0; h < headerCount; ++h) {
                        length += headers.name(h).getBytes("UTF-8").length + COLONSPACE.length + headers.value(h).getBytes("UTF-8").length + CRLF.length;
                    }
                }
                if ((contentType = body.contentType()) != null) {
                    length += "Content-Type: ".getBytes("UTF-8").length + contentType.toString().getBytes("UTF-8").length + CRLF.length;
                }
                length += "Content-Length: ".getBytes("UTF-8").length + Long.toString(contentLength).getBytes("UTF-8").length + CRLF.length;
                length = (int)((long)length + ((long)CRLF.length + contentLength + (long)CRLF.length));
            }
            this.totalToSend = length += DASHDASH.length + this.boundary.size() + DASHDASH.length + CRLF.length;
            return length;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            ForwardingSink forwardingSink = new ForwardingSink((Sink)sink){

                public void write(Buffer source, long byteCount) throws IOException {
                    super.write(source, byteCount);
                    FixedLengthMultipartRequestBody.this.totalSent = FixedLengthMultipartRequestBody.this.totalSent + byteCount;
                    if (FixedLengthMultipartRequestBody.this.progressHandler != null) {
                        FixedLengthMultipartRequestBody.this.progressHandler.onProgress(FixedLengthMultipartRequestBody.this.requestId, byteCount, FixedLengthMultipartRequestBody.this.totalSent, FixedLengthMultipartRequestBody.this.totalToSend);
                    }
                }
            };
            BufferedSink bufferedSink = Okio.buffer((Sink)forwardingSink);
            int partCount = this.partHeaders.size();
            for (int p = 0; p < partCount; ++p) {
                long contentLength;
                MediaType contentType;
                Headers headers = this.partHeaders.get(p);
                RequestBody body = this.partBodies.get(p);
                bufferedSink.write(DASHDASH);
                bufferedSink.write(this.boundary);
                bufferedSink.write(CRLF);
                if (headers != null) {
                    int headerCount = headers.size();
                    for (int h = 0; h < headerCount; ++h) {
                        bufferedSink.writeUtf8(headers.name(h)).write(COLONSPACE).writeUtf8(headers.value(h)).write(CRLF);
                    }
                }
                if ((contentType = body.contentType()) != null) {
                    bufferedSink.writeUtf8("Content-Type: ").writeUtf8(contentType.toString()).write(CRLF);
                }
                if ((contentLength = body.contentLength()) != -1L) {
                    bufferedSink.writeUtf8("Content-Length: ").writeUtf8(Long.toString(contentLength)).write(CRLF);
                }
                bufferedSink.write(CRLF);
                body.writeTo(bufferedSink);
                bufferedSink.write(CRLF);
            }
            bufferedSink.write(DASHDASH);
            bufferedSink.write(this.boundary);
            bufferedSink.write(DASHDASH);
            bufferedSink.write(CRLF);
            bufferedSink.flush();
        }
    }

    public static interface APIClientProgressHandler {
        public void onProgress(String var1, long var2, long var4, long var6);
    }
}

