/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.messaging.RemoteMessage;
import com.sendbird.android.AbstractPushHandler;
import com.sendbird.android.OnPushTokenReceiveListener;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.SendBirdPushHelper;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class SendBirdPushHandler
extends AbstractPushHandler<RemoteMessage> {
    @Override
    protected void onNewToken(String newToken) {
    }

    @Override
    void onTokenUpdated(String newToken) {
        SendBirdPushHelper.registerPushToken(newToken, this.isUniquePushToken(), null);
        this.onNewToken(newToken);
    }

    @Override
    protected abstract void onMessageReceived(Context var1, RemoteMessage var2);

    @Override
    protected boolean isUniquePushToken() {
        return false;
    }

    @Override
    protected boolean alwaysReceiveMessage() {
        return false;
    }

    @Override
    void getToken(final OnPushTokenReceiveListener listener) {
        block5: {
            try {
                FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(){
                    private String errorMessage = "FCM token access is failure.";

                    public void onComplete(Task<InstanceIdResult> task) {
                        if (!task.isSuccessful()) {
                            if (listener != null) {
                                Exception e = task.getException();
                                Log.w((String)"FCM", (String)"getInstanceId failed", (Throwable)e);
                                if (e != null && !TextUtils.isEmpty((CharSequence)e.getMessage())) {
                                    this.errorMessage = e.getMessage();
                                }
                                listener.onReceived(this.errorMessage, new SendBirdException(this.errorMessage, 800220));
                            }
                            return;
                        }
                        InstanceIdResult result = (InstanceIdResult)task.getResult();
                        if (result != null) {
                            String token = result.getToken();
                            Log.d((String)"FCM", (String)("FCM token : " + token + " by OnCompleteListener"));
                            if (listener != null) {
                                listener.onReceived(token, null);
                            }
                        } else {
                            listener.onReceived("getting FCM token is failed", new SendBirdException(this.errorMessage, 800220));
                        }
                    }
                });
            }
            catch (Throwable e) {
                Log.w((String)"FCM", (Throwable)e);
                try {
                    String token = FirebaseInstanceId.getInstance().getToken();
                    if (listener != null) {
                        listener.onReceived(token, null);
                    }
                }
                catch (Throwable e1) {
                    Log.w((String)"FCM", (Throwable)e1);
                    if (listener == null) break block5;
                    listener.onReceived(null, new SendBirdException(e1.getMessage()));
                }
            }
        }
    }

    @Override
    JSONObject getPayload(RemoteMessage remoteMessage) throws JSONException {
        if (remoteMessage.getData().containsKey("sendbird")) {
            return new JSONObject((String)remoteMessage.getData().get("sendbird"));
        }
        return null;
    }

    @Override
    boolean isSendBirdMessage(RemoteMessage remoteMessage) {
        return remoteMessage.getData().containsKey("sendbird");
    }

    @Override
    void registerPushToken(String token, boolean unique, SendBird.RegisterPushTokenWithStatusHandler handler) {
        SendBird.registerPushTokenForCurrentUserInternal(SendBird.PushTokenType.GCM, token, unique, true, handler);
    }

    @Override
    void unregisterPushToken(String token, SendBird.UnregisterPushTokenHandler handler) {
        SendBird.unregisterPushTokenForCurrentUser(SendBird.PushTokenType.GCM, token, handler);
    }
}

