/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.UserMessageParams;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ScheduledUserMessageParams
extends UserMessageParams {
    private Integer mYear;
    private Integer mMonth;
    private Integer mDay;
    private Integer mHour;
    private Integer mMin;
    private String mTimezone;

    public ScheduledUserMessageParams(String message, int year, int month, int day, int hour, int min, String timezone) {
        super(message);
        this.setSchedule(year, month, day, hour, min, timezone);
    }

    public void setSchedule(int year, int month, int day, int hour, int min, String timezone) {
        this.mYear = year;
        this.mMonth = month;
        this.mDay = day;
        this.mHour = hour;
        this.mMin = min;
        this.mTimezone = timezone;
    }

    public Date getScheduledDateTime() {
        Date date = null;
        try {
            if (this.mYear != null && this.mMonth != null && this.mDay != null && this.mHour != null && this.mMin != null && this.mTimezone != null) {
                String scheduledDateTimeString = String.format(Locale.US, "%04d-%02d-%02d %02d:%02d", this.mYear, this.mMonth, this.mDay, this.mHour, this.mMin);
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.US);
                dateFormat.setTimeZone(TimeZone.getTimeZone(this.mTimezone));
                date = dateFormat.parse(scheduledDateTimeString);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    public String getScheduledTimezone() {
        return this.mTimezone != null ? this.mTimezone : "UTC";
    }

    String getScheduledString() {
        String result = null;
        if (this.mYear != null && this.mMonth != null && this.mDay != null && this.mHour != null && this.mMin != null && this.mTimezone != null) {
            result = String.format(Locale.US, "%04d-%02d-%02d %02d:%02d %s", this.mYear, this.mMonth, this.mDay, this.mHour, this.mMin, this.mTimezone);
        }
        return result;
    }

    @Override
    public String toString() {
        return "ScheduledUserMessageParams{mYear=" + this.mYear + ", mMonth=" + this.mMonth + ", mDay=" + this.mDay + ", mHour=" + this.mHour + ", mMin=" + this.mMin + ", mTimezone='" + this.mTimezone + '\'' + ", mMessage='" + this.mMessage + '\'' + ", mTargetLanguages=" + this.mTargetLanguages + ", mData='" + this.mData + '\'' + ", mCustomType='" + this.mCustomType + '\'' + ", mMentionType=" + (Object)((Object)this.mMentionType) + ", mMentionedUserIds=" + this.mMentionedUserIds + ", mPushNotificationDeliveryOption=" + (Object)((Object)this.mPushNotificationDeliveryOption) + ", mMetaArrays=" + this.mMetaArrays + '}';
    }
}

