/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.text.TextUtils;
import com.sendbird.android.Authentication;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.ChannelManager;
import com.sendbird.android.Command;
import com.sendbird.android.CommandType;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.Sender;
import com.sendbird.android.User;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.JsonObject;

class EventController {
    private EventController() {
    }

    public static EventController getInstance() {
        return MsgCtlrHolder.INSTANCE;
    }

    void processResponse(final Command command) {
        String channelUrl = command.getChannelUrl();
        final boolean cacheExisted = GroupChannel.hasCachedChannel(command.getChannelUrl());
        if (TextUtils.isEmpty((CharSequence)channelUrl) || command.isChannelDeleted()) {
            if (command.hasRequestId()) {
                this.processRequestedMessage(command, null);
            } else {
                this.processEvent(command, null, cacheExisted);
            }
        } else {
            BaseChannel.getChannel(command, new BaseChannel.OnGetChannelHandler(){

                @Override
                public void onResult(BaseChannel baseChannel, SendBirdException e) {
                    if (e != null) {
                        Logger.d("Discard a command: " + (Object)((Object)command.getCommandType()));
                        return;
                    }
                    if (command.hasRequestId()) {
                        EventController.this.processRequestedMessage(command, baseChannel);
                    } else {
                        EventController.this.processEvent(command, baseChannel, cacheExisted);
                    }
                }
            });
        }
    }

    private void processRequestedMessage(Command command, BaseChannel baseChannel) {
        Logger.d("processRequestedMessage() => " + command.getRequestId() + ":" + (Object)((Object)command.getCommandType()) + ":" + command.getPayload());
        CommandType msgType = command.getCommandType();
        if (command.hasRequestId()) {
            switch (msgType) {
                case MESG: 
                case FILE: {
                    BaseMessage msg = BaseMessage.createMessage(command);
                    msg.setSendingStatus(BaseMessage.SendingStatus.SUCCEEDED);
                    Sender sender = msg.mSender;
                    User user = SendBird.getCurrentUser();
                    if (sender != null && user != null && sender.getUserId().equals(user.getUserId())) {
                        user.updatePropertiesByUser(sender);
                    }
                    if (!(baseChannel instanceof GroupChannel)) break;
                    final GroupChannel channel = (GroupChannel)baseChannel;
                    channel.setLastMessageByCreatedAt(msg);
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ChannelManager.getInstance().notifyAllChannelChanged(channel);
                        }
                    });
                    break;
                }
            }
        }
    }

    private void processExpirationEvent(Command command) {
        JsonObject obj = command.getJsonElement().getAsJsonObject();
        Logger.d("EXPR, has expires_in : %s, reason : %s", obj.get("expires_in"), obj.get("reason"));
        int reason = obj.has("reason") ? obj.get("reason").getAsInt() : 400309;
        try {
            Authentication.handleSessionRefresh(new SendBirdException("The connection will expire soon.", reason), System.currentTimeMillis());
        }
        catch (SendBirdException e) {
            Logger.d(e);
        }
    }

    private void processEvent(Command command, BaseChannel baseChannel, boolean cacheExisted) {
        Logger.d("processMessage() => " + command.getRequestId() + ":" + (Object)((Object)command.getCommandType()) + ":" + command.getPayload());
        if (!SendBird.isActive()) {
            Logger.d("[ignored] messageReceived() => " + command.getRequestId() + ":" + (Object)((Object)command.getCommandType()) + ":" + command.getPayload());
            return;
        }
        CommandType msgType = command.getCommandType();
        switch (msgType) {
            case MESG: 
            case FILE: 
            case BRDM: 
            case ADMM: {
                ChannelManager.getInstance().processIncomingMessage(command, baseChannel, cacheExisted);
                break;
            }
            case MEDI: 
            case FEDI: 
            case AEDI: {
                ChannelManager.getInstance().processUpdatedMessage(command, baseChannel, cacheExisted);
                break;
            }
            case MRCT: {
                ChannelManager.getInstance().processReaction(command, baseChannel);
                break;
            }
            case READ: {
                ChannelManager.getInstance().processRead(command, baseChannel, cacheExisted);
                break;
            }
            case DLVR: {
                ChannelManager.getInstance().processDeliveryReceipt(command, baseChannel, cacheExisted);
                break;
            }
            case TPST: 
            case TPEN: {
                break;
            }
            case MTIO: {
                break;
            }
            case SYEV: {
                if (baseChannel == null) {
                    ChannelManager.getInstance().processChannelEventWithoutChannel(command);
                    break;
                }
                ChannelManager.getInstance().processChannelEvent(command, baseChannel);
                break;
            }
            case USEV: {
                ChannelManager.getInstance().processUserEvent(command);
                break;
            }
            case DELM: {
                ChannelManager.getInstance().processDeleteMessage(command, baseChannel);
                break;
            }
            case LEAV: {
                break;
            }
            case JOIN: {
                break;
            }
            case MTHD: {
                ChannelManager.getInstance().processThreadInfoUpdateEvent(command, baseChannel);
                break;
            }
            case EXPR: {
                this.processExpirationEvent(command);
                break;
            }
            case MCNT: {
                ChannelManager.getInstance().processMemberCountEvent(command);
                break;
            }
            default: {
                Logger.d("Discard a command: " + (Object)((Object)command.getCommandType()));
            }
        }
    }

    private static class MsgCtlrHolder {
        private static final EventController INSTANCE = new EventController();

        private MsgCtlrHolder() {
        }
    }
}

