/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.ChannelEventCategory;
import com.sendbird.android.HashUtils;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class ChannelEvent {
    private final JsonObject obj;
    private final ChannelEventCategory category;
    private final Map<String, JsonElement> data = new ConcurrentHashMap<String, JsonElement>();
    private final String channelUrl;
    private final String channelType;
    private final long ts;

    public ChannelEvent(JsonElement el) {
        JsonObject dataObj;
        this.obj = el.getAsJsonObject();
        this.category = ChannelEventCategory.from(this.obj.has("cat") ? this.obj.get("cat").getAsInt() : 0);
        JsonObject jsonObject = dataObj = this.obj.has("data") ? this.obj.get("data").getAsJsonObject() : null;
        if (dataObj != null) {
            for (Map.Entry entry : dataObj.entrySet()) {
                this.data.put((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        this.channelUrl = this.obj.has("channel_url") ? this.obj.get("channel_url").getAsString() : "";
        this.channelType = this.obj.has("channel_type") ? this.obj.get("channel_type").getAsString() : BaseChannel.ChannelType.GROUP.value();
        this.ts = this.obj.has("ts") ? this.obj.get("ts").getAsLong() : 0L;
    }

    JsonElement getData() {
        return this.obj.has("data") ? this.obj.get("data").getAsJsonObject() : null;
    }

    ChannelEventCategory getCategory() {
        return this.category;
    }

    String getChannelUrl() {
        return this.channelUrl;
    }

    long getTs() {
        return this.ts;
    }

    public JsonObject toJsonObject() {
        return this.obj;
    }

    boolean isGroupChannel() {
        return this.channelType.equals(BaseChannel.ChannelType.GROUP.value());
    }

    boolean isOpenChannel() {
        return this.channelType.equals(BaseChannel.ChannelType.OPEN.value());
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ChannelEvent event = (ChannelEvent)o;
        return this.getCategory() == event.getCategory() && this.getChannelUrl().equals(event.getChannelUrl()) && this.getTs() == event.getTs();
    }

    public int hashCode() {
        return HashUtils.generateHashCode(new Object[]{this.getCategory(), this.getChannelUrl(), this.getTs()});
    }

    public String toString() {
        return "ChannelEvent{obj=" + this.obj + ", category=" + (Object)((Object)this.category) + ", data=" + this.data + ", channelUrl='" + this.channelUrl + '\'' + ", channelType='" + this.channelType + '\'' + ", ts=" + this.ts + '}';
    }
}

