/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

final class VersioningCache<Key, Value> {
    private static final long DEFAULT_REMOVE_DELAY_MS;
    private static final long removeDelayMillis;
    private final Map<Key, DataHolder<Value>> delegate = new HashMap<Key, DataHolder<Value>>();
    private final Object delegateLock = new Object();
    private static final ScheduledExecutorService deleteExecutor;

    VersioningCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value get(Key key) {
        DataHolder<Value> dataHolder;
        Object object = this.delegateLock;
        synchronized (object) {
            dataHolder = this.delegate.get(key);
        }
        if (null == dataHolder || dataHolder.removed) {
            return null;
        }
        return dataHolder.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value remove(final Key key, long updatedAt) {
        boolean updated;
        DataHolder<Value> previous;
        Object object = this.delegateLock;
        synchronized (object) {
            previous = this.delegate.get(key);
            updated = VersioningCache.isUpdate(previous, updatedAt);
            if (null == previous || updated) {
                DataHolder<Object> deleted = new DataHolder<Object>(null, true, updatedAt);
                this.delegate.put(key, deleted);
                deleteExecutor.schedule(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = VersioningCache.this.delegateLock;
                        synchronized (object) {
                            DataHolder toBeRemoved = (DataHolder)VersioningCache.this.delegate.get(key);
                            if (null != toBeRemoved && toBeRemoved.removed) {
                                VersioningCache.this.delegate.remove(key);
                            }
                        }
                    }
                }, removeDelayMillis, TimeUnit.MILLISECONDS);
            }
        }
        if (updated) {
            return previous.getValue();
        }
        return null;
    }

    private static boolean isUpdate(DataHolder<?> previous, long updatedAt) {
        if (null == previous) {
            return false;
        }
        return previous.updatedAt < updatedAt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Key, Value> removeAll(Collection<? extends Key> keys, long updatedAt) {
        HashMap map = new HashMap();
        ArrayList<Key> keysCopy = new ArrayList<Key>(keys);
        Object object = this.delegateLock;
        synchronized (object) {
            for (Object key : keysCopy) {
                boolean mappingExisted = this.delegate.containsKey(key);
                Value value = this.remove(key, updatedAt);
                if (!mappingExisted || null == value) continue;
                map.put(key, value);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Key, Value> removeAll(long updatedAt) {
        HashMap<Key, Value> removedMappings = new HashMap<Key, Value>();
        Object object = this.delegateLock;
        synchronized (object) {
            for (Key key : this.delegate.keySet()) {
                Value removed = this.remove(key, updatedAt);
                if (null == removed) continue;
                removedMappings.put(key, removed);
            }
        }
        return removedMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(Key key, Value value, long updatedAt) {
        Object object = this.delegateLock;
        synchronized (object) {
            boolean changed;
            DataHolder<Value> previous = this.delegate.get(key);
            if (previous == null) {
                this.delegate.put(key, new DataHolder<Value>(value, false, updatedAt));
                changed = value != null;
            } else if (previous.updatedAt < updatedAt) {
                this.delegate.put(key, new DataHolder<Value>(value, false, updatedAt));
                changed = previous.removed || previous.getValue() != value;
            } else {
                return false;
            }
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Key, Value> putAll(Map<? extends Key, ? extends Value> data, long updatedAt) {
        HashMap previousData = new HashMap();
        HashMap<Key, Value> dataCopy = new HashMap<Key, Value>(data);
        Object object = this.delegateLock;
        synchronized (object) {
            for (Map.Entry entry : dataCopy.entrySet()) {
                Value prevValue = this.get(entry.getKey());
                boolean updated = this.put(entry.getKey(), entry.getValue(), updatedAt);
                if (!updated) continue;
                previousData.put(entry.getKey(), prevValue);
            }
        }
        return previousData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Key, Value> asMap() {
        HashMap<Key, Value> mapCopy = new HashMap<Key, Value>();
        Object object = this.delegateLock;
        synchronized (object) {
            for (Map.Entry<Key, DataHolder<Value>> entry : this.delegate.entrySet()) {
                if (entry.getValue().removed) continue;
                mapCopy.put(entry.getKey(), entry.getValue().getValue());
            }
        }
        return mapCopy;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "VersioningLruCache{removeDelayMillis=" + removeDelayMillis + ", delegate=" + this.delegate + '}';
    }

    static {
        removeDelayMillis = DEFAULT_REMOVE_DELAY_MS = TimeUnit.MINUTES.toMillis(5L);
        deleteExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    private static final class DataHolder<ValueType> {
        private final ValueType value;
        final boolean removed;
        final long updatedAt;

        DataHolder(ValueType value, boolean removed, long updatedAt) {
            this.value = value;
            this.removed = removed;
            this.updatedAt = updatedAt;
        }

        ValueType getValue() {
            if (this.removed) {
                // empty if block
            }
            return this.value;
        }

        public String toString() {
            return "DataHolder{value=" + this.value + ", isRemoved=" + this.removed + ", updatedAt=" + this.updatedAt + '}';
        }
    }
}

