/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.util.Base64;
import com.sendbird.android.SendBird;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Plugin {
    private final String vendor;
    private final String type;
    private final Map<String, String> detail = new HashMap<String, String>();

    Plugin(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        this.vendor = obj.has("vendor") ? obj.get("vendor").getAsString() : "";
        String string = this.type = obj.has("type") ? obj.get("type").getAsString() : "";
        if (obj.has("detail")) {
            JsonObject detailObj = obj.get("detail").getAsJsonObject();
            for (Map.Entry entrySet : detailObj.entrySet()) {
                if (entrySet.getValue() == null || ((JsonElement)entrySet.getValue()).isJsonNull()) continue;
                if (((JsonElement)entrySet.getValue()).isJsonPrimitive()) {
                    this.detail.put((String)entrySet.getKey(), ((JsonElement)entrySet.getValue()).getAsString());
                    continue;
                }
                this.detail.put((String)entrySet.getKey(), String.valueOf(entrySet.getValue()));
            }
        }
    }

    JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("vendor", this.vendor);
        obj.addProperty("type", this.type);
        JsonObject detailObj = new JsonObject();
        for (Map.Entry<String, String> entrySet : this.detail.entrySet()) {
            detailObj.addProperty(entrySet.getKey(), entrySet.getValue());
        }
        obj.add("detail", (JsonElement)detailObj);
        return obj;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getDetail() {
        return Collections.unmodifiableMap(this.detail);
    }

    public static Plugin buildFromSerializedData(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] copiedData = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            copiedData[i] = (byte)(data[i] ^ i & 0xFF);
        }
        try {
            String str = new String(Base64.decode((byte[])copiedData, (int)0), "UTF-8");
            return new Plugin(new JsonParser().parse(str));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return "Plugin{vendor='" + this.vendor + '\'' + ", type='" + this.type + '\'' + ", detail=" + this.detail + '}';
    }
}

