/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.text.TextUtils;
import android.util.Base64;
import com.sendbird.android.APIClient;
import com.sendbird.android.APITaskQueue;
import com.sendbird.android.AdminMessage;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.Command;
import com.sendbird.android.EqualsUtil;
import com.sendbird.android.FileMessage;
import com.sendbird.android.FileMessageParams;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.HashUtils;
import com.sendbird.android.JobResultTask;
import com.sendbird.android.JobTask;
import com.sendbird.android.Member;
import com.sendbird.android.MessageChangeLogsParams;
import com.sendbird.android.MessageListParams;
import com.sendbird.android.MessageListQuery;
import com.sendbird.android.MessageMetaArray;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.OperatorListQuery;
import com.sendbird.android.Plugin;
import com.sendbird.android.PreviousMessageListQuery;
import com.sendbird.android.ReactionEvent;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.Sender;
import com.sendbird.android.ThreadInfo;
import com.sendbird.android.User;
import com.sendbird.android.UserMessage;
import com.sendbird.android.UserMessageParams;
import com.sendbird.android.VersioningCache;
import com.sendbird.android.handlers.AddOperatorsHandler;
import com.sendbird.android.handlers.RemoveAllOperatorsHandler;
import com.sendbird.android.handlers.RemoveOperatorsHandler;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class BaseChannel {
    @Deprecated
    protected static final String CHANNEL_TYPE_OPEN = "open";
    @Deprecated
    protected static final String CHANNEL_TYPE_GROUP = "group";
    protected String mUrl;
    protected String mName;
    protected String mCoverUrl;
    protected long mCreatedAt;
    protected String mData;
    protected boolean mFreeze;
    protected boolean mIsEphemeral;
    private boolean mDirty = false;
    private final VersioningCache<String, String> cachedMetadata = new VersioningCache();
    private final ConcurrentLinkedQueue<SendFileMessageData> mSendFileMessageDataList = new ConcurrentLinkedQueue();
    private boolean mIsSendingFileMessage = false;

    protected BaseChannel(JsonElement el) {
        this.update(el);
    }

    protected void update(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        this.mUrl = obj.has("channel_url") && !obj.get("channel_url").isJsonNull() ? obj.get("channel_url").getAsString() : "";
        this.mName = obj.has("name") && !obj.get("name").isJsonNull() ? obj.get("name").getAsString() : "";
        this.mCreatedAt = obj.has("created_at") && !obj.get("created_at").isJsonNull() ? obj.get("created_at").getAsLong() * 1000L : 0L;
        this.mCoverUrl = obj.has("cover_url") && !obj.get("cover_url").isJsonNull() ? obj.get("cover_url").getAsString() : "";
        this.mData = obj.has("data") && !obj.get("data").isJsonNull() ? obj.get("data").getAsString() : "";
        this.mFreeze = obj.has("freeze") && obj.get("freeze").getAsBoolean();
        this.mIsEphemeral = obj.has("is_ephemeral") && obj.get("is_ephemeral").getAsBoolean();
    }

    JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("channel_url", this.mUrl);
        obj.addProperty("name", this.mName);
        obj.addProperty("created_at", (Number)(this.mCreatedAt / 1000L));
        obj.addProperty("cover_url", this.mCoverUrl);
        obj.addProperty("data", this.mData);
        obj.addProperty("freeze", Boolean.valueOf(this.mFreeze));
        obj.addProperty("is_ephemeral", Boolean.valueOf(this.mIsEphemeral));
        return obj;
    }

    protected void setDirty(boolean dirty) {
        this.mDirty = dirty;
    }

    protected boolean isDirty() {
        return this.mDirty;
    }

    public static BaseChannel buildFromSerializedData(byte[] data) {
        BaseChannel channel = null;
        if (data != null) {
            byte[] copiedData = new byte[data.length];
            for (int i = 0; i < data.length; ++i) {
                copiedData[i] = (byte)(data[i] ^ i & 0xFF);
            }
            try {
                String str = new String(Base64.decode((byte[])copiedData, (int)0), "UTF-8");
                JsonObject obj = new JsonParser().parse(str).getAsJsonObject();
                if (obj.get("channel_type").getAsString().equals(ChannelType.OPEN.value())) {
                    channel = OpenChannel.upsert((JsonElement)obj, true);
                } else if (obj.get("channel_type").getAsString().equals(ChannelType.GROUP.value())) {
                    channel = GroupChannel.upsert((JsonElement)obj, true);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return channel;
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    ChannelType getChannelType() {
        return this.isOpenChannel() ? ChannelType.OPEN : ChannelType.GROUP;
    }

    public String getData() {
        return this.mData;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public long getCreatedAt() {
        return this.mCreatedAt;
    }

    public String getName() {
        return this.mName;
    }

    public String getCoverUrl() {
        return this.mCoverUrl;
    }

    public boolean isOpenChannel() {
        return this instanceof OpenChannel;
    }

    public boolean isGroupChannel() {
        return this instanceof GroupChannel;
    }

    public boolean isFrozen() {
        return this.mFreeze;
    }

    void setFreeze(boolean freeze) {
        this.mFreeze = freeze;
    }

    public boolean isEphemeral() {
        return this.mIsEphemeral;
    }

    void setEphemeral(boolean ephemeral) {
        this.mIsEphemeral = ephemeral;
    }

    public PreviousMessageListQuery createPreviousMessageListQuery() {
        return new PreviousMessageListQuery(this);
    }

    @Deprecated
    public MessageListQuery createMessageListQuery() {
        return new MessageListQuery(this);
    }

    public OperatorListQuery createOperatorListQuery() {
        return new OperatorListQuery(this);
    }

    private void getMessagesByTimestamp(final long ts, final boolean isInclusive, final int prevResultSize, final int nextResultSize, final boolean reverse, final MessageTypeFilter messageType, final String customType, final Collection<String> customTypes, final List<String> senderUserIds, final boolean includeMetaArray, final boolean includeReactions, final boolean includeThreadInfo, final boolean includeReplies, final boolean includeParentMessageText, final boolean showSubchannelMessagesOnly, final GetMessagesHandler handler) {
        final boolean isOpenChannel = this instanceof OpenChannel;
        APITaskQueue.addTask(new JobResultTask<List<BaseMessage>>(){

            @Override
            public List<BaseMessage> call() throws Exception {
                String msgType = messageType == null || messageType == MessageTypeFilter.ALL ? null : messageType.value();
                LinkedHashSet<String> senderUserIdsSet = null;
                if (senderUserIds != null) {
                    senderUserIdsSet = new LinkedHashSet<String>(senderUserIds);
                }
                JsonElement response = APIClient.getInstance().messageList(isOpenChannel, BaseChannel.this.getUrl(), 0L, ts, prevResultSize, nextResultSize, isInclusive, reverse, msgType, customType, customTypes, senderUserIdsSet, includeMetaArray, includeReactions, includeThreadInfo, includeReplies, includeParentMessageText, showSubchannelMessagesOnly);
                JsonObject result = response.getAsJsonObject();
                JsonArray objs = result.get("messages").getAsJsonArray();
                ArrayList<BaseMessage> messages = new ArrayList<BaseMessage>();
                for (int i = 0; i < objs.size(); ++i) {
                    BaseMessage msg = BaseMessage.createMessage(objs.get(i), BaseChannel.this.getUrl(), BaseChannel.this.getChannelType());
                    if (msg == null) continue;
                    messages.add(msg);
                }
                return messages;
            }

            @Override
            public void onResultForUiThread(List<BaseMessage> messages, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(messages, e);
                }
            }
        });
    }

    private void getMessagesById(final long msgId, final boolean isInclusive, final int prevResultSize, final int nextResultSize, final boolean reverse, final MessageTypeFilter messageType, final String customType, final Collection<String> customTypes, final List<String> senderUserIds, final boolean includeMetaArray, final boolean includeReactions, final boolean includeThreadInfo, final boolean includeReplies, final boolean includeParentMessageText, final boolean showSubchannelMessagesOnly, final GetMessagesHandler handler) {
        final boolean isOpenChannel = this instanceof OpenChannel;
        APITaskQueue.addTask(new JobResultTask<List<BaseMessage>>(){

            @Override
            public List<BaseMessage> call() throws Exception {
                String msgType = messageType == null || messageType == MessageTypeFilter.ALL ? null : messageType.value();
                LinkedHashSet<String> senderUserIdsSet = null;
                if (senderUserIds != null) {
                    senderUserIdsSet = new LinkedHashSet<String>(senderUserIds);
                }
                JsonElement response = APIClient.getInstance().messageListById(isOpenChannel, BaseChannel.this.getUrl(), msgId, prevResultSize, nextResultSize, isInclusive, reverse, msgType, customType, customTypes, senderUserIdsSet, includeMetaArray, includeReactions, includeThreadInfo, includeReplies, includeParentMessageText, showSubchannelMessagesOnly);
                JsonObject result = response.getAsJsonObject();
                JsonArray objs = result.get("messages").getAsJsonArray();
                ArrayList<BaseMessage> messages = new ArrayList<BaseMessage>();
                for (int i = 0; i < objs.size(); ++i) {
                    BaseMessage msg = BaseMessage.createMessage(objs.get(i), BaseChannel.this.getUrl(), BaseChannel.this.getChannelType());
                    if (msg == null) continue;
                    messages.add(msg);
                }
                return messages;
            }

            @Override
            public void onResultForUiThread(List<BaseMessage> messages, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(messages, e);
                }
            }
        });
    }

    private void getMessageChangeLogs(final String token, final Long ts, final boolean includeMetaArray, final boolean includeReactions, final boolean includeThreadInfo, final boolean includeReplies, final boolean includeParentMessageText, final GetMessageChangeLogsHandler handler) {
        APITaskQueue.addTask(new JobTask<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                block6: {
                    try {
                        if (ts != null && ts < 0L) {
                            throw new SendBirdException("Invalid Arguments.", 800110);
                        }
                        JsonElement response = APIClient.getInstance().messageChangeLogs(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl(), token, ts, includeMetaArray, includeReactions, includeThreadInfo, includeReplies, includeParentMessageText);
                        JsonObject result = response.getAsJsonObject();
                        JsonArray updatedJsonArray = result.get("updated").getAsJsonArray();
                        final ArrayList<BaseMessage> updatedMessages = new ArrayList<BaseMessage>();
                        for (int i = 0; i < updatedJsonArray.size(); ++i) {
                            BaseMessage msg = BaseMessage.createMessage(updatedJsonArray.get(i), BaseChannel.this.getUrl(), BaseChannel.this.getChannelType());
                            if (msg == null) continue;
                            updatedMessages.add(msg);
                        }
                        JsonArray deletedJsonArray = result.get("deleted").getAsJsonArray();
                        final ArrayList<Long> deletedMessageIds = new ArrayList<Long>();
                        for (int i = 0; i < deletedJsonArray.size(); ++i) {
                            deletedMessageIds.add(deletedJsonArray.get(i).getAsJsonObject().get("message_id").getAsLong());
                        }
                        final boolean hasMore = result.get("has_more").getAsBoolean();
                        final String token2 = result.get("next").getAsString();
                        if (handler != null) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    handler.onResult(updatedMessages, deletedMessageIds, hasMore, token2, null);
                                }
                            });
                        }
                    }
                    catch (SendBirdException e) {
                        if (handler == null) break block6;
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, null, false, null, e);
                            }
                        });
                    }
                }
                return true;
            }
        });
    }

    public void getMessagesByMessageId(long messageId, MessageListParams params, final GetMessagesHandler handler) {
        if (params == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.getMessagesById(messageId, params.isInclusive, params.previousResultSize, params.nextResultSize, params.reverse, params.messageType, params.customType, params.customTypes, params.senderUserIds, params.includeMetaArray, params.includeReactions, params.includeThreadInfo, params.includeReplies, params.includeParentMessageText, params.showSubchannelMessagesOnly, handler);
    }

    public void getMessagesByTimestamp(long ts, MessageListParams params, final GetMessagesHandler handler) {
        if (params == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.getMessagesByTimestamp(ts, params.isInclusive, params.previousResultSize, params.nextResultSize, params.reverse, params.messageType, params.customType, params.customTypes, params.senderUserIds, params.includeMetaArray, params.includeReactions, params.includeThreadInfo, params.includeReplies, params.includeParentMessageText, params.showSubchannelMessagesOnly, handler);
    }

    public void getNextMessagesByTimestamp(long ts, boolean isInclusive, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, isInclusive, 0, nextResultSize, reverse, messageType, customType, null, null, false, false, false, false, false, false, handler);
    }

    public void getNextMessagesByTimestamp(long ts, boolean isInclusive, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, isInclusive, 0, nextResultSize, reverse, messageType, customType, null, senderUserIds, false, false, false, false, false, false, handler);
    }

    public void getNextMessagesByTimestamp(long ts, boolean isInclusive, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, isInclusive, 0, nextResultSize, reverse, messageType, customType, null, senderUserIds, includeMetaArray, false, false, false, false, false, handler);
    }

    public void getNextMessagesByTimestamp(long ts, boolean isInclusive, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, boolean includeReactions, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, isInclusive, 0, nextResultSize, reverse, messageType, customType, null, senderUserIds, includeMetaArray, includeReactions, false, false, false, false, handler);
    }

    public void getPreviousMessagesByTimestamp(long ts, boolean isInclusive, int prevResultSize, boolean reverse, MessageTypeFilter messageType, String customType, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, isInclusive, prevResultSize, 0, reverse, messageType, customType, null, null, false, false, false, false, false, false, handler);
    }

    public void getPreviousMessagesByTimestamp(long ts, boolean isInclusive, int prevResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, isInclusive, prevResultSize, 0, reverse, messageType, customType, null, senderUserIds, false, false, false, false, false, false, handler);
    }

    public void getPreviousMessagesByTimestamp(long ts, boolean isInclusive, int prevResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, isInclusive, prevResultSize, 0, reverse, messageType, customType, null, senderUserIds, includeMetaArray, false, false, false, false, false, handler);
    }

    public void getPreviousMessagesByTimestamp(long ts, boolean isInclusive, int prevResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, boolean includeReactions, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, isInclusive, prevResultSize, 0, reverse, messageType, customType, null, senderUserIds, includeMetaArray, includeReactions, false, false, false, false, handler);
    }

    public void getPreviousAndNextMessagesByTimestamp(long ts, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, true, prevResultSize, nextResultSize, reverse, messageType, customType, null, null, false, false, false, false, false, false, handler);
    }

    public void getPreviousAndNextMessagesByTimestamp(long ts, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, true, prevResultSize, nextResultSize, reverse, messageType, customType, null, senderUserIds, false, false, false, false, false, false, handler);
    }

    public void getPreviousAndNextMessagesByTimestamp(long ts, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, true, prevResultSize, nextResultSize, reverse, messageType, customType, null, senderUserIds, includeMetaArray, false, false, false, false, false, handler);
    }

    public void getPreviousAndNextMessagesByTimestamp(long ts, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, boolean includeReactions, GetMessagesHandler handler) {
        this.getMessagesByTimestamp(ts, true, prevResultSize, nextResultSize, reverse, messageType, customType, null, senderUserIds, includeMetaArray, includeReactions, false, false, false, false, handler);
    }

    public void getNextMessagesById(long msgId, boolean isInclusive, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, GetMessagesHandler handler) {
        this.getMessagesById(msgId, isInclusive, 0, nextResultSize, reverse, messageType, customType, null, null, false, false, false, false, false, false, handler);
    }

    public void getNextMessagesById(long msgId, boolean isInclusive, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, GetMessagesHandler handler) {
        this.getMessagesById(msgId, isInclusive, 0, nextResultSize, reverse, messageType, customType, null, senderUserIds, false, false, false, false, false, false, handler);
    }

    public void getNextMessagesById(long msgId, boolean isInclusive, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, GetMessagesHandler handler) {
        this.getMessagesById(msgId, isInclusive, 0, nextResultSize, reverse, messageType, customType, null, senderUserIds, includeMetaArray, false, false, false, false, false, handler);
    }

    public void getNextMessagesById(long msgId, boolean isInclusive, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, boolean includeReactions, GetMessagesHandler handler) {
        this.getMessagesById(msgId, isInclusive, 0, nextResultSize, reverse, messageType, customType, null, senderUserIds, includeMetaArray, includeReactions, false, false, false, false, handler);
    }

    public void getPreviousMessagesById(long msgId, boolean isInclusive, int prevResultSize, boolean reverse, MessageTypeFilter messageType, String customType, GetMessagesHandler handler) {
        this.getMessagesById(msgId, isInclusive, prevResultSize, 0, reverse, messageType, customType, null, null, false, false, false, false, false, false, handler);
    }

    public void getPreviousMessagesById(long msgId, boolean isInclusive, int prevResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, GetMessagesHandler handler) {
        this.getMessagesById(msgId, isInclusive, prevResultSize, 0, reverse, messageType, customType, null, senderUserIds, false, false, false, false, false, false, handler);
    }

    public void getPreviousMessagesById(long msgId, boolean isInclusive, int prevResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, GetMessagesHandler handler) {
        this.getMessagesById(msgId, isInclusive, prevResultSize, 0, reverse, messageType, customType, null, senderUserIds, includeMetaArray, false, false, false, false, false, handler);
    }

    public void getPreviousMessagesById(long msgId, boolean isInclusive, int prevResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, boolean includeReactions, GetMessagesHandler handler) {
        this.getMessagesById(msgId, isInclusive, prevResultSize, 0, reverse, messageType, customType, null, senderUserIds, includeMetaArray, includeReactions, false, false, false, false, handler);
    }

    public void getPreviousAndNextMessagesById(long msgId, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, GetMessagesHandler handler) {
        this.getMessagesById(msgId, true, prevResultSize, nextResultSize, reverse, messageType, customType, null, null, false, false, false, false, false, false, handler);
    }

    public void getPreviousAndNextMessagesById(long msgId, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, GetMessagesHandler handler) {
        this.getMessagesById(msgId, true, prevResultSize, nextResultSize, reverse, messageType, customType, null, senderUserIds, false, false, false, false, false, false, handler);
    }

    public void getPreviousAndNextMessagesById(long msgId, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, GetMessagesHandler handler) {
        this.getMessagesById(msgId, true, prevResultSize, nextResultSize, reverse, messageType, customType, null, senderUserIds, includeMetaArray, false, false, false, false, false, handler);
    }

    public void getPreviousAndNextMessagesById(long msgId, int prevResultSize, int nextResultSize, boolean reverse, MessageTypeFilter messageType, String customType, List<String> senderUserIds, boolean includeMetaArray, boolean includeReactions, GetMessagesHandler handler) {
        this.getMessagesById(msgId, true, prevResultSize, nextResultSize, reverse, messageType, customType, null, senderUserIds, includeMetaArray, includeReactions, false, false, false, false, handler);
    }

    public void getMessageChangeLogsByToken(String token, GetMessageChangeLogsByTokenHandler handler) {
        this.getMessageChangeLogs(token, null, false, false, false, false, false, handler);
    }

    public void getMessageChangeLogsByToken(String token, boolean includeMetaArray, GetMessageChangeLogsByTokenHandler handler) {
        this.getMessageChangeLogs(token, null, includeMetaArray, false, false, false, false, handler);
    }

    public void getMessageChangeLogsByToken(String token, boolean includeMetaArray, boolean includeReactions, GetMessageChangeLogsHandler handler) {
        this.getMessageChangeLogs(token, null, includeMetaArray, includeReactions, false, false, false, handler);
    }

    public void getMessageChangeLogsSinceToken(String token, MessageChangeLogsParams params, final GetMessageChangeLogsHandler handler) {
        if (params == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, null, false, null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.getMessageChangeLogs(token, null, params.includeMetaArray, params.includeReactions, params.includeThreadInfo, params.includeReplies, params.includeParentMessageText, handler);
    }

    public void getMessageChangeLogsByTimestamp(long ts, GetMessageChangeLogsHandler handler) {
        this.getMessageChangeLogs(null, ts, false, false, false, false, false, handler);
    }

    public void getMessageChangeLogsByTimestamp(long ts, boolean includeMetaArray, GetMessageChangeLogsHandler handler) {
        this.getMessageChangeLogs(null, ts, includeMetaArray, false, false, false, false, handler);
    }

    public void getMessageChangeLogsByTimestamp(long ts, boolean includeMetaArray, boolean includeReactions, GetMessageChangeLogsHandler handler) {
        this.getMessageChangeLogs(null, ts, includeMetaArray, includeReactions, false, false, false, handler);
    }

    public void getMessageChangeLogsSinceTimestamp(long ts, MessageChangeLogsParams params, final GetMessageChangeLogsHandler handler) {
        if (params == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, null, false, null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.getMessageChangeLogs(null, ts, params.includeMetaArray, params.includeReactions, params.includeThreadInfo, params.includeReplies, params.includeParentMessageText, handler);
    }

    public FileMessage sendFileMessage(String fileUrl, String name, String type, int size, String data, SendFileMessageHandler handler) {
        return this.sendFileMessage(fileUrl, name, type, size, data, null, handler);
    }

    public FileMessage sendFileMessage(String fileUrl, String name, String type, int size, String data, String customType, SendFileMessageHandler handler) {
        return this.localSendFileMessage(null, 0L, 0L, fileUrl, name, type, size, data, customType, null, null, null, null, null, handler, null, null);
    }

    public FileMessage sendFileMessage(File file, String name, String type, int size, String data, SendFileMessageHandler handler) {
        return this.sendFileMessage(file, name, type, size, data, null, null, handler);
    }

    @Deprecated
    public FileMessage sendFileMessage(File file, String name, String type, int size, String data, String customType, SendFileMessageHandler handler) {
        return this.sendFileMessage(file, name, type, size, data, customType, null, handler);
    }

    public FileMessage sendFileMessage(File file, String name, String type, int size, String data, String customType, List<FileMessage.ThumbnailSize> thumbnailSizes, SendFileMessageHandler handler) {
        return this.localSendFileMessage(null, 0L, 0L, file, name, type, size, data, customType, thumbnailSizes, null, null, null, null, handler, null, null);
    }

    public FileMessage sendFileMessage(File file, String name, String type, int size, String data, SendFileMessageWithProgressHandler handler) {
        return this.sendFileMessage(file, name, type, size, data, null, null, handler);
    }

    @Deprecated
    public FileMessage sendFileMessage(File file, String name, String type, int size, String data, String customType, SendFileMessageWithProgressHandler handler) {
        return this.sendFileMessage(file, name, type, size, data, customType, null, handler);
    }

    public FileMessage sendFileMessage(File file, String name, String type, int size, String data, String customType, List<FileMessage.ThumbnailSize> thumbnailSizes, SendFileMessageWithProgressHandler handler) {
        return this.localSendFileMessage(null, 0L, 0L, file, name, type, size, data, customType, thumbnailSizes, null, null, null, null, null, handler, null);
    }

    public FileMessage sendFileMessage(FileMessageParams params, final SendFileMessageHandler handler) {
        if (params == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        return this.localSendFileMessage(null, params.rootMessageId, params.parentMessageId, params.mFileUrlOrFile, params.mFileName, params.mMimeType, params.mFileSize, params.mData, params.mCustomType, params.mThumbnailSizes, params.mMentionType, params.mMentionedUserIds, params.mPushNotificationDeliveryOption, params.mMetaArrays, handler, null, null);
    }

    public FileMessage sendFileMessage(FileMessageParams params, final SendFileMessageWithProgressHandler handler) {
        if (params == null || !(params.mFileUrlOrFile instanceof File)) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        return this.localSendFileMessage(null, params.rootMessageId, params.parentMessageId, params.mFileUrlOrFile, params.mFileName, params.mMimeType, params.mFileSize, params.mData, params.mCustomType, params.mThumbnailSizes, params.mMentionType, params.mMentionedUserIds, params.mPushNotificationDeliveryOption, params.mMetaArrays, null, handler, null);
    }

    public List<FileMessage> sendFileMessages(List<FileMessageParams> params, final SendFileMessagesHandler handler) {
        if (params == null || params.size() == 0 || params.size() > 20) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        ArrayList<FileMessage> fileMessages = new ArrayList<FileMessage>();
        for (int i = 0; i < params.size(); ++i) {
            FileMessageParams param = params.get(i);
            FileMessage fileMessage = param != null ? this.localCreateFileMessage(null, param.rootMessageId, param.parentMessageId, param.mFileUrlOrFile, param.mFileName, param.mMimeType, param.mFileSize, param.mData, param.mCustomType, param.mThumbnailSizes, param.mMentionType, param.mMentionedUserIds, param.mPushNotificationDeliveryOption, param.mMetaArrays, handler, null) : null;
            fileMessages.add(fileMessage);
        }
        this.localSendFileMessages(params, fileMessages, handler, null);
        return fileMessages;
    }

    public List<FileMessage> sendFileMessages(List<FileMessageParams> params, final SendFileMessagesWithProgressHandler handler) {
        if (params == null || params.size() == 0 || params.size() > 20) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        ArrayList<FileMessage> fileMessages = new ArrayList<FileMessage>();
        for (int i = 0; i < params.size(); ++i) {
            FileMessageParams param = params.get(i);
            FileMessage fileMessage = param != null ? (param.mFileUrlOrFile instanceof File ? this.localCreateFileMessage(null, param.rootMessageId, param.parentMessageId, param.mFileUrlOrFile, param.mFileName, param.mMimeType, param.mFileSize, param.mData, param.mCustomType, param.mThumbnailSizes, param.mMentionType, param.mMentionedUserIds, param.mPushNotificationDeliveryOption, param.mMetaArrays, null, handler) : null) : null;
            fileMessages.add(fileMessage);
        }
        this.localSendFileMessages(params, fileMessages, null, handler);
        return fileMessages;
    }

    private FileMessage localCreateFileMessage(String requestId, long rootMessageId, long parentMessageId, Object fileUrlOrFile, String name, String type, Integer size, String data, String customType, List<FileMessage.ThumbnailSize> thumbnailSizes, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, BaseMessageParams.PushNotificationDeliveryOption pushNotificationDeliveryOption, List<MessageMetaArray> metaArrays, final Object handler, final Object progressHandler) {
        String fileUrl = "";
        if (fileUrlOrFile instanceof String) {
            fileUrl = (String)fileUrlOrFile;
            if (name == null || name.length() == 0) {
                name = "";
            }
            if (type == null || type.length() == 0) {
                type = "";
            }
            if (size == null) {
                size = 0;
            }
        } else if (fileUrlOrFile instanceof File) {
            File file = (File)fileUrlOrFile;
            if (name == null || name.length() == 0) {
                name = file.getName();
            }
            try {
                type = APIClient.checkMimeType(file, type);
            }
            catch (SendBirdException sendBirdException) {
                // empty catch block
            }
            if (type == null || type.length() == 0) {
                type = "";
            }
            if (size == null) {
                size = (int)file.length();
            }
        } else {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (handler instanceof SendFileMessageHandler) {
                            ((SendFileMessageHandler)handler).onSent(null, new SendBirdException("Invalid arguments.", 800110));
                        } else if (handler instanceof SendFileMessagesHandler) {
                            ((SendFileMessagesHandler)handler).onSent(null, new SendBirdException("Invalid arguments.", 800110));
                        }
                    }
                });
            } else if (progressHandler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (progressHandler instanceof SendFileMessageWithProgressHandler) {
                            ((SendFileMessageWithProgressHandler)progressHandler).onSent(null, new SendBirdException("Invalid arguments.", 800110));
                        } else if (progressHandler instanceof SendFileMessagesWithProgressHandler) {
                            ((SendFileMessagesWithProgressHandler)progressHandler).onSent(null, new SendBirdException("Invalid arguments.", 800110));
                        }
                    }
                });
            }
            return null;
        }
        JsonObject obj = new JsonObject();
        JsonArray thumbnails = new JsonArray();
        if (thumbnailSizes != null) {
            for (FileMessage.ThumbnailSize thumbnailSize : thumbnailSizes) {
                JsonObject thumbnail = new JsonObject();
                thumbnail.addProperty("width", (Number)thumbnailSize.getMaxWidth());
                thumbnail.addProperty("height", (Number)thumbnailSize.getMaxHeight());
                thumbnail.addProperty("url", "");
                thumbnails.add((JsonElement)thumbnail);
            }
        }
        obj.add("thumbnails", (JsonElement)thumbnails);
        String sortedMetaArray = null;
        if (metaArrays != null && metaArrays.size() > 0) {
            JsonArray sortedMetaArrayArray = new JsonArray();
            for (MessageMetaArray metaArray : metaArrays) {
                sortedMetaArrayArray.add((JsonElement)metaArray.toJson());
            }
            sortedMetaArray = sortedMetaArrayArray.toString();
        }
        String reqId = requestId != null && requestId.length() > 0 ? requestId : Command.generateRequestId();
        final FileMessage msg = FileMessage.copiedInstance(reqId, rootMessageId, parentMessageId, Sender.toSender(SendBird.getCurrentUser(), this.getCurrentUserRole()), this.getUrl(), this.getChannelType(), fileUrl, name, type, size, data, customType, thumbnails.toString(), false, System.currentTimeMillis(), mentionType, mentionedUserIds, null, sortedMetaArray, new ThreadInfo(), this.getCurrentUserRole() == Member.Role.OPERATOR);
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        FileMessage fileMessage = new FileMessage(msg.toJson());
                        fileMessage.setSendingStatus(BaseMessage.SendingStatus.FAILED);
                        fileMessage.mErrorCode = 800101;
                        if (handler instanceof SendFileMessageHandler) {
                            ((SendFileMessageHandler)handler).onSent(fileMessage, new SendBirdException("Connection must be made before you send message.", 800101));
                        } else if (handler instanceof SendFileMessagesHandler) {
                            ((SendFileMessagesHandler)handler).onSent(fileMessage, new SendBirdException("Connection must be made before you send message.", 800101));
                        }
                    }
                });
            } else if (progressHandler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        FileMessage fileMessage = new FileMessage(msg.toJson());
                        fileMessage.setSendingStatus(BaseMessage.SendingStatus.FAILED);
                        fileMessage.mErrorCode = 800101;
                        if (progressHandler instanceof SendFileMessageWithProgressHandler) {
                            ((SendFileMessageWithProgressHandler)progressHandler).onSent(fileMessage, new SendBirdException("Connection must be made before you send message.", 800101));
                        } else if (progressHandler instanceof SendFileMessagesWithProgressHandler) {
                            ((SendFileMessagesWithProgressHandler)progressHandler).onSent(fileMessage, new SendBirdException("Connection must be made before you send message.", 800101));
                        }
                    }
                });
            }
            msg.setSendingStatus(BaseMessage.SendingStatus.PENDING);
            return msg;
        }
        msg.setSendingStatus(BaseMessage.SendingStatus.PENDING);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileMessage localSendFileMessage(String requestId, long rootMessageId, long parentMessageId, Object fileUrlOrFile, String name, final String type, Integer size, String data, String customType, final List<FileMessage.ThumbnailSize> thumbnailSizes, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, BaseMessageParams.PushNotificationDeliveryOption pushNotificationDeliveryOption, List<MessageMetaArray> metaArrays, final Object handler, final Object progressHandler, FileMessage createdFileMessage) {
        FileMessage msg;
        if (createdFileMessage != null) {
            msg = createdFileMessage;
        } else {
            msg = this.localCreateFileMessage(requestId, rootMessageId, parentMessageId, fileUrlOrFile, name, type, size, data, customType, thumbnailSizes, mentionType, mentionedUserIds, pushNotificationDeliveryOption, metaArrays, handler, progressHandler);
            if (msg == null) {
                return null;
            }
            if (SendBird.getCurrentUser() == null) {
                return msg;
            }
        }
        if (fileUrlOrFile instanceof String) {
            String fileUrl = (String)fileUrlOrFile;
            SendFileMessageData sendFileMessageData = new SendFileMessageData(fileUrl, msg, data, customType, mentionType, mentionedUserIds, pushNotificationDeliveryOption, metaArrays, handler, progressHandler);
            ConcurrentLinkedQueue<SendFileMessageData> concurrentLinkedQueue = this.mSendFileMessageDataList;
            synchronized (concurrentLinkedQueue) {
                this.mSendFileMessageDataList.add(sendFileMessageData);
            }
            this.localDoSendFileMessageWithOrder();
            return msg;
        }
        if (fileUrlOrFile instanceof File) {
            final File file = (File)fileUrlOrFile;
            final SendFileMessageData sendFileMessageData = new SendFileMessageData(msg, data, customType, mentionType, mentionedUserIds, pushNotificationDeliveryOption, metaArrays, handler, progressHandler);
            ConcurrentLinkedQueue<SendFileMessageData> concurrentLinkedQueue = this.mSendFileMessageDataList;
            synchronized (concurrentLinkedQueue) {
                this.mSendFileMessageDataList.add(sendFileMessageData);
            }
            final APIClient.APIClientProgressHandler localProgressHandler = progressHandler != null ? new APIClient.APIClientProgressHandler(){

                @Override
                public void onProgress(final String requestId, final long bytesSent, final long totalBytesSent, final long totalBytesToSend) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (progressHandler instanceof SendFileMessageWithProgressHandler) {
                                ((SendFileMessageWithProgressHandler)progressHandler).onProgress((int)bytesSent, (int)totalBytesSent, (int)totalBytesToSend);
                            } else if (progressHandler instanceof SendFileMessagesWithProgressHandler) {
                                ((SendFileMessagesWithProgressHandler)progressHandler).onProgress(requestId, (int)bytesSent, (int)totalBytesSent, (int)totalBytesToSend);
                            }
                        }
                    });
                }
            } : null;
            APITaskQueue.addTask(new JobResultTask<JsonElement>(){

                @Override
                public JsonElement call() throws SendBirdException {
                    return APIClient.getInstance().uploadFile(file, type, thumbnailSizes, BaseChannel.this.getUrl(), msg.getRequestId(), localProgressHandler);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResultForUiThread(JsonElement response, SendBirdException e) {
                    if (e != null) {
                        BaseMessage.SendingStatus sendingStatus = e.getCode() == 800240 ? BaseMessage.SendingStatus.CANCELED : BaseMessage.SendingStatus.FAILED;
                        FileMessage fileMessage = new FileMessage(msg.toJson());
                        fileMessage.setSendingStatus(sendingStatus);
                        fileMessage.mErrorCode = e.getCode();
                        if (handler != null) {
                            if (handler instanceof SendFileMessageHandler) {
                                ((SendFileMessageHandler)handler).onSent(fileMessage, e);
                            } else if (handler instanceof SendFileMessagesHandler) {
                                ((SendFileMessagesHandler)handler).onSent(fileMessage, e);
                            }
                        } else if (progressHandler != null) {
                            if (progressHandler instanceof SendFileMessageWithProgressHandler) {
                                ((SendFileMessageWithProgressHandler)progressHandler).onSent(fileMessage, e);
                            } else if (progressHandler instanceof SendFileMessagesWithProgressHandler) {
                                ((SendFileMessagesWithProgressHandler)progressHandler).onSent(fileMessage, e);
                            }
                        }
                        ConcurrentLinkedQueue concurrentLinkedQueue = BaseChannel.this.mSendFileMessageDataList;
                        synchronized (concurrentLinkedQueue) {
                            BaseChannel.this.mSendFileMessageDataList.remove(sendFileMessageData);
                        }
                        BaseChannel.this.localDoSendFileMessageWithOrder();
                        return;
                    }
                    JsonObject result = response.getAsJsonObject();
                    String fileUrl = result.get("url").getAsString();
                    String thumbnails = result.has("thumbnails") ? result.get("thumbnails").toString() : null;
                    boolean requireAuth = result.has("require_auth") && result.get("require_auth").getAsBoolean();
                    int fileSize = result.has("file_size") ? result.get("file_size").getAsInt() : -1;
                    sendFileMessageData.setServerSideData(fileUrl, thumbnails, requireAuth, fileSize);
                    BaseChannel.this.localDoSendFileMessageWithOrder();
                }
            });
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localDoSendFileMessageWithOrder() {
        SendFileMessageData data;
        if (this.mIsSendingFileMessage) {
            return;
        }
        this.mIsSendingFileMessage = true;
        ConcurrentLinkedQueue<SendFileMessageData> concurrentLinkedQueue = this.mSendFileMessageDataList;
        synchronized (concurrentLinkedQueue) {
            data = this.mSendFileMessageDataList.peek();
            if (null == data || !data.isReadyToSend()) {
                this.mIsSendingFileMessage = false;
                return;
            }
            this.mSendFileMessageDataList.remove(data);
        }
        this.localDoSendFileMessage(data, new SendFileMessageHandler(){

            @Override
            public void onSent(final FileMessage message, final SendBirdException e) {
                final Object handler = data.getHandler();
                final Object progressHandler = data.getProgressHandler();
                if (e != null) {
                    final FileMessage fileMessage = new FileMessage(data.getTempFileMessage().toJson());
                    fileMessage.setSendingStatus(BaseMessage.SendingStatus.FAILED);
                    fileMessage.mErrorCode = e.getCode();
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (handler != null) {
                                if (handler instanceof SendFileMessageHandler) {
                                    ((SendFileMessageHandler)handler).onSent(fileMessage, e);
                                } else if (handler instanceof SendFileMessagesHandler) {
                                    ((SendFileMessagesHandler)handler).onSent(fileMessage, e);
                                }
                            } else if (progressHandler != null) {
                                if (progressHandler instanceof SendFileMessageWithProgressHandler) {
                                    ((SendFileMessageWithProgressHandler)progressHandler).onSent(fileMessage, e);
                                } else if (progressHandler instanceof SendFileMessagesWithProgressHandler) {
                                    ((SendFileMessagesWithProgressHandler)progressHandler).onSent(fileMessage, e);
                                }
                            }
                        }
                    });
                    BaseChannel.this.mIsSendingFileMessage = false;
                    BaseChannel.this.localDoSendFileMessageWithOrder();
                    return;
                }
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (handler != null) {
                            if (handler instanceof SendFileMessageHandler) {
                                ((SendFileMessageHandler)handler).onSent(message, null);
                            } else if (handler instanceof SendFileMessagesHandler) {
                                ((SendFileMessagesHandler)handler).onSent(message, null);
                            }
                        } else if (progressHandler != null) {
                            if (progressHandler instanceof SendFileMessageWithProgressHandler) {
                                ((SendFileMessageWithProgressHandler)progressHandler).onSent(message, null);
                            } else if (progressHandler instanceof SendFileMessagesWithProgressHandler) {
                                ((SendFileMessagesWithProgressHandler)progressHandler).onSent(message, null);
                            }
                        }
                    }
                });
                BaseChannel.this.mIsSendingFileMessage = false;
                BaseChannel.this.localDoSendFileMessageWithOrder();
            }
        });
    }

    private void localDoSendFileMessage(final SendFileMessageData data, final Object handler) {
        final FileMessage tempFileMessage = data.getTempFileMessage();
        final Object progressHandler = data.getProgressHandler();
        if (SendBird.getConnectionState() == SendBird.ConnectionState.OPEN) {
            Command cmd = Command.bFile(tempFileMessage.getRequestId(), tempFileMessage.getRootMessageId(), tempFileMessage.getParentMessageId(), this.getUrl(), data.getFileUrl(), tempFileMessage.getName(), tempFileMessage.getType(), data.getFileSize() == -1 ? tempFileMessage.getSize() : data.getFileSize(), data.getData(), data.getCustomType(), data.getThumbnails(), data.requireAuth(), data.getMentionType(), data.getMentionedUserIds(), data.getPushNotificationDeliveryOption(), data.getMetaArrays());
            SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

                @Override
                public void onResult(final Command acked, final SendBirdException e) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (e != null) {
                                FileMessage fileMessage = new FileMessage(tempFileMessage.toJson());
                                fileMessage.setSendingStatus(BaseMessage.SendingStatus.FAILED);
                                fileMessage.mErrorCode = e.getCode();
                                if (handler != null) {
                                    if (handler instanceof SendFileMessageHandler) {
                                        ((SendFileMessageHandler)handler).onSent(fileMessage, e);
                                    } else if (handler instanceof SendFileMessagesHandler) {
                                        ((SendFileMessagesHandler)handler).onSent(fileMessage, e);
                                    }
                                } else if (progressHandler != null) {
                                    if (progressHandler instanceof SendFileMessageWithProgressHandler) {
                                        ((SendFileMessageWithProgressHandler)progressHandler).onSent(fileMessage, e);
                                    } else if (progressHandler instanceof SendFileMessagesWithProgressHandler) {
                                        ((SendFileMessagesWithProgressHandler)progressHandler).onSent(fileMessage, e);
                                    }
                                }
                                return;
                            }
                            FileMessage fileMessage = (FileMessage)BaseMessage.createMessage(acked);
                            if (fileMessage != null) {
                                fileMessage.setSendingStatus(BaseMessage.SendingStatus.SUCCEEDED);
                            }
                            if (handler != null) {
                                if (handler instanceof SendFileMessageHandler) {
                                    ((SendFileMessageHandler)handler).onSent(fileMessage, null);
                                } else if (handler instanceof SendFileMessagesHandler) {
                                    ((SendFileMessagesHandler)handler).onSent(fileMessage, null);
                                }
                            } else if (progressHandler != null) {
                                if (progressHandler instanceof SendFileMessageWithProgressHandler) {
                                    ((SendFileMessageWithProgressHandler)progressHandler).onSent(fileMessage, null);
                                } else if (progressHandler instanceof SendFileMessagesWithProgressHandler) {
                                    ((SendFileMessagesWithProgressHandler)progressHandler).onSent(fileMessage, null);
                                }
                            }
                        }
                    });
                }
            });
        } else {
            APITaskQueue.addTask(new JobResultTask<FileMessage>(){

                @Override
                public FileMessage call() throws Exception {
                    JsonElement response = APIClient.getInstance().sendFileMessage(BaseChannel.this.isOpenChannel(), tempFileMessage.getRootMessageId(), tempFileMessage.getParentMessageId(), BaseChannel.this.getUrl(), data.getFileUrl(), tempFileMessage.getName(), data.getFileSize() == -1 ? tempFileMessage.getSize() : data.getFileSize(), tempFileMessage.getType(), data.getCustomType(), data.getData(), data.getThumbnails(), data.requireAuth(), data.getMentionType(), data.getMentionedUserIds(), data.getPushNotificationDeliveryOption(), data.getMetaArrays());
                    JsonObject responseObj = response.getAsJsonObject();
                    responseObj.addProperty("req_id", tempFileMessage.getRequestId());
                    FileMessage fileMessage = (FileMessage)BaseMessage.createMessage((JsonElement)responseObj, BaseChannel.this.getUrl(), BaseChannel.this.getChannelType());
                    if (fileMessage != null) {
                        fileMessage.setSendingStatus(BaseMessage.SendingStatus.SUCCEEDED);
                    }
                    return fileMessage;
                }

                @Override
                public void onResultForUiThread(FileMessage fileMessage, SendBirdException e) {
                    if (e != null) {
                        fileMessage = new FileMessage(tempFileMessage.toJson());
                        fileMessage.setSendingStatus(BaseMessage.SendingStatus.FAILED);
                        fileMessage.mErrorCode = e.getCode();
                    }
                    if (handler != null) {
                        if (handler instanceof SendFileMessageHandler) {
                            ((SendFileMessageHandler)handler).onSent(fileMessage, e);
                        } else if (handler instanceof SendFileMessagesHandler) {
                            ((SendFileMessagesHandler)handler).onSent(fileMessage, e);
                        }
                    } else if (progressHandler != null) {
                        if (progressHandler instanceof SendFileMessageWithProgressHandler) {
                            ((SendFileMessageWithProgressHandler)progressHandler).onSent(fileMessage, e);
                        } else if (progressHandler instanceof SendFileMessagesWithProgressHandler) {
                            ((SendFileMessagesWithProgressHandler)progressHandler).onSent(fileMessage, e);
                        }
                    }
                }
            });
        }
    }

    private void localSendFileMessages(List<FileMessageParams> params, List<FileMessage> fileMessages, final SendFileMessagesHandler handler, final SendFileMessagesWithProgressHandler progressHandler) {
        FileMessage fileMessage;
        FileMessageParams param;
        int i;
        final LinkedList<String> countList = new LinkedList<String>();
        for (i = 0; i < params.size(); ++i) {
            param = params.get(i);
            fileMessage = fileMessages.get(i);
            if (param == null || fileMessage == null) continue;
            countList.add(fileMessage.getRequestId());
        }
        for (i = 0; i < params.size(); ++i) {
            param = params.get(i);
            fileMessage = fileMessages.get(i);
            if (param == null || fileMessage == null) continue;
            this.localSendFileMessage(null, param.rootMessageId, param.parentMessageId, param.mFileUrlOrFile, fileMessage.getName(), fileMessage.getType(), fileMessage.getSize(), param.mData, param.mCustomType, param.mThumbnailSizes, param.mMentionType, param.mMentionedUserIds, param.mPushNotificationDeliveryOption, param.mMetaArrays, null, new SendFileMessagesWithProgressHandler(){

                @Override
                public void onProgress(String reqId, int bytesSent, int totalBytesSent, int totalBytesToSend) {
                    if (progressHandler != null) {
                        progressHandler.onProgress(reqId, bytesSent, totalBytesSent, totalBytesToSend);
                    }
                }

                @Override
                public void onSent(FileMessage message, SendBirdException e) {
                    if (handler != null) {
                        handler.onSent(message, e);
                    } else if (progressHandler != null) {
                        progressHandler.onSent(message, e);
                    }
                    if (message != null && countList.remove(message.getRequestId()) && countList.size() == 0) {
                        if (handler != null) {
                            handler.onResult(null);
                        } else if (progressHandler != null) {
                            progressHandler.onResult(null);
                        }
                    }
                }

                @Override
                public void onResult(SendBirdException e) {
                }
            }, fileMessage);
        }
    }

    public UserMessage sendUserMessage(String message, SendUserMessageHandler handler) {
        return this.sendUserMessage(message, null, null, handler);
    }

    @Deprecated
    public UserMessage sendUserMessage(String message, String data, SendUserMessageHandler handler) {
        return this.sendUserMessage(message, data, null, null, handler);
    }

    @Deprecated
    public UserMessage sendUserMessage(String message, String data, String customType, SendUserMessageHandler handler) {
        return this.sendUserMessage(message, data, customType, null, handler);
    }

    public UserMessage sendUserMessage(String message, String data, String customType, List<String> targetLanguages, SendUserMessageHandler handler) {
        return this.localSendUserMessage(null, 0L, 0L, message, data, customType, targetLanguages, null, null, null, null, handler);
    }

    public UserMessage sendUserMessage(UserMessageParams params, final SendUserMessageHandler handler) {
        if (params == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        return this.localSendUserMessage(null, params.rootMessageId, params.parentMessageId, params.mMessage, params.mData, params.mCustomType, params.mTargetLanguages, params.mMentionType, params.mMentionedUserIds, params.mPushNotificationDeliveryOption, params.mMetaArrays, handler);
    }

    private UserMessage localSendUserMessage(String requestId, long rootMessageId, long parentMessageId, String message, String data, String customType, List<String> targetLanguages, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, BaseMessageParams.PushNotificationDeliveryOption pushNotificationDeliveryOption, List<MessageMetaArray> metaArrays, final SendUserMessageHandler handler) {
        if (message == null) {
            message = "";
        }
        JsonObject obj = new JsonObject();
        JsonObject transObj = new JsonObject();
        if (targetLanguages != null) {
            for (String targetLanguage : targetLanguages) {
                transObj.addProperty(targetLanguage, "");
            }
        }
        obj.add("translations", (JsonElement)transObj);
        String sortedMetaArray = null;
        if (metaArrays != null && metaArrays.size() > 0) {
            JsonArray sortedMetaArrayArray = new JsonArray();
            for (MessageMetaArray metaArray : metaArrays) {
                sortedMetaArrayArray.add((JsonElement)metaArray.toJson());
            }
            sortedMetaArray = sortedMetaArrayArray.toString();
        }
        String reqId = requestId != null && requestId.length() > 0 ? requestId : Command.generateRequestId();
        final UserMessage msg = UserMessage.copiedInstance(reqId, rootMessageId, parentMessageId, Sender.toSender(SendBird.getCurrentUser(), this.getCurrentUserRole()), this.getUrl(), this.getChannelType(), message, data, customType, transObj.toString(), System.currentTimeMillis(), mentionType, mentionedUserIds, null, sortedMetaArray, new ThreadInfo(), null, this.getCurrentUserRole() == Member.Role.OPERATOR, null);
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        UserMessage userMessage = (UserMessage)BaseMessage.clone(msg);
                        if (userMessage != null) {
                            userMessage.setSendingStatus(BaseMessage.SendingStatus.FAILED);
                            userMessage.mErrorCode = 800101;
                        }
                        handler.onSent(userMessage, new SendBirdException("Connection must be made before you send message.", 800101));
                    }
                });
            }
            msg.setSendingStatus(BaseMessage.SendingStatus.PENDING);
            return msg;
        }
        Command cmd = Command.bMessage(msg.getRequestId(), rootMessageId, parentMessageId, this.getUrl(), message, data, customType, mentionType, mentionedUserIds, pushNotificationDeliveryOption, metaArrays, targetLanguages);
        SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

            @Override
            public void onResult(final Command acked, final SendBirdException e) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (e != null) {
                            if (handler != null) {
                                UserMessage userMessage = (UserMessage)BaseMessage.clone(msg);
                                if (userMessage != null) {
                                    userMessage.setSendingStatus(BaseMessage.SendingStatus.FAILED);
                                    userMessage.mErrorCode = e.getCode();
                                }
                                handler.onSent(userMessage, e);
                            }
                            return;
                        }
                        if (handler != null) {
                            UserMessage userMessage = (UserMessage)BaseMessage.createMessage(acked);
                            if (userMessage != null) {
                                userMessage.setSendingStatus(BaseMessage.SendingStatus.SUCCEEDED);
                            }
                            handler.onSent(userMessage, null);
                        }
                    }
                });
            }
        });
        msg.setSendingStatus(BaseMessage.SendingStatus.PENDING);
        return msg;
    }

    public UserMessage resendMessage(UserMessage userMessage, ResendUserMessageHandler handler) {
        return this.localResendUserMessage(userMessage, handler);
    }

    private UserMessage localResendUserMessage(UserMessage userMessage, final ResendUserMessageHandler handler) {
        if (userMessage == null || userMessage.mMessageId > 0L || !userMessage.isResendable()) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return userMessage;
        }
        if (userMessage.getSender() == null) {
            userMessage.mSender = Sender.toSender(SendBird.getCurrentUser(), this.getCurrentUserRole());
            if (userMessage.getSender() != null) {
                userMessage.setIsOperatorMessage(userMessage.getSender().getRole() == Member.Role.OPERATOR);
            }
        }
        if (!this.getUrl().equals(userMessage.getChannelUrl())) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onSent(null, new SendBirdException("The message does not belong to this channel.", 800110));
                    }
                });
            }
            return userMessage;
        }
        ArrayList<String> targetLanguages = null;
        Map<String, String> translations = userMessage.getTranslations();
        if (translations != null && translations.size() > 0) {
            targetLanguages = new ArrayList<String>(translations.keySet());
        }
        ArrayList<String> mentionedUserIds = null;
        if (userMessage.getMentionedUserIds() != null && userMessage.getMentionedUserIds().size() > 0) {
            mentionedUserIds = new ArrayList<String>(userMessage.getMentionedUserIds());
        }
        ArrayList<MessageMetaArray> metaArrays = null;
        if (userMessage.getAllMetaArrays() != null && userMessage.getAllMetaArrays().size() > 0) {
            metaArrays = new ArrayList<MessageMetaArray>(userMessage.getAllMetaArrays());
        }
        return this.localSendUserMessage(userMessage.getRequestId(), userMessage.getRootMessageId(), userMessage.getParentMessageId(), userMessage.getMessage(), userMessage.getData(), userMessage.getCustomType(), targetLanguages, userMessage.getMentionType(), mentionedUserIds, null, metaArrays, new SendUserMessageHandler(){

            @Override
            public void onSent(UserMessage message, SendBirdException e) {
                if (handler != null) {
                    handler.onSent(message, e);
                }
            }
        });
    }

    public FileMessage resendMessage(FileMessage fileMessage, File file, ResendFileMessageHandler handler) {
        return this.localResendFileMessage(fileMessage, file, handler);
    }

    public FileMessage resendMessage(FileMessage fileMessage, File file, ResendFileMessageWithProgressHandler handler) {
        return this.localResendFileMessage(fileMessage, file, handler);
    }

    public void resendFileMessage(FileMessage fileMessage, File file, ResendFileMessageHandler handler) {
        this.localResendFileMessage(fileMessage, file, handler);
    }

    public void resendFileMessage(FileMessage fileMessage, File file, ResendFileMessageWithProgressHandler handler) {
        this.localResendFileMessage(fileMessage, file, handler);
    }

    private FileMessage localResendFileMessage(FileMessage fileMessage, File file, final Object handler) {
        if (fileMessage == null || fileMessage.mMessageId > 0L || !fileMessage.isResendable()) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (handler instanceof ResendFileMessageHandler) {
                            ((ResendFileMessageHandler)handler).onSent(null, new SendBirdException("Invalid arguments.", 800110));
                        } else if (handler instanceof ResendFileMessageWithProgressHandler) {
                            ((ResendFileMessageWithProgressHandler)handler).onSent(null, new SendBirdException("Invalid arguments.", 800110));
                        }
                    }
                });
            }
            return fileMessage;
        }
        if (fileMessage.getSender() == null) {
            fileMessage.mSender = Sender.toSender(SendBird.getCurrentUser(), this.getCurrentUserRole());
            if (fileMessage.getSender() != null) {
                fileMessage.setIsOperatorMessage(fileMessage.getSender().getRole() == Member.Role.OPERATOR);
            }
        }
        if (!this.getUrl().equals(fileMessage.getChannelUrl())) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (handler instanceof ResendFileMessageHandler) {
                            ((ResendFileMessageHandler)handler).onSent(null, new SendBirdException("The message does not belong to this channel.", 800110));
                        } else if (handler instanceof ResendFileMessageWithProgressHandler) {
                            ((ResendFileMessageWithProgressHandler)handler).onSent(null, new SendBirdException("The message does not belong to this channel.", 800110));
                        }
                    }
                });
            }
            return fileMessage;
        }
        Object fileUrlOrFile = null;
        if (fileMessage.getUrl() != null && fileMessage.getUrl().length() > 0) {
            fileUrlOrFile = fileMessage.getUrl();
        } else if (file != null) {
            fileUrlOrFile = file;
        }
        if (fileUrlOrFile == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (handler instanceof ResendFileMessageHandler) {
                            ((ResendFileMessageHandler)handler).onSent(null, new SendBirdException("Invalid arguments.", 800110));
                        } else if (handler instanceof ResendFileMessageWithProgressHandler) {
                            ((ResendFileMessageWithProgressHandler)handler).onSent(null, new SendBirdException("Invalid arguments.", 800110));
                        }
                    }
                });
            }
            return fileMessage;
        }
        SendFileMessageHandler paramHandler = null;
        SendFileMessageWithProgressHandler paramProgressHandler = null;
        if (handler != null) {
            if (handler instanceof ResendFileMessageHandler) {
                paramHandler = new SendFileMessageHandler(){

                    @Override
                    public void onSent(FileMessage message, SendBirdException e) {
                        ((ResendFileMessageHandler)handler).onSent(message, e);
                    }
                };
            } else if (handler instanceof ResendFileMessageWithProgressHandler) {
                paramProgressHandler = new SendFileMessageWithProgressHandler(){

                    @Override
                    public void onProgress(int bytesSent, int totalBytesSent, int totalBytesToSend) {
                        ((ResendFileMessageWithProgressHandler)handler).onProgress(bytesSent, totalBytesSent, totalBytesToSend);
                    }

                    @Override
                    public void onSent(FileMessage message, SendBirdException e) {
                        ((ResendFileMessageWithProgressHandler)handler).onSent(message, e);
                    }
                };
            }
        }
        ArrayList<FileMessage.ThumbnailSize> thumbnailSizes = null;
        List<FileMessage.Thumbnail> thumbnails = fileMessage.getThumbnails();
        if (thumbnails != null) {
            thumbnailSizes = new ArrayList<FileMessage.ThumbnailSize>();
            for (FileMessage.Thumbnail thumbnail : thumbnails) {
                if (thumbnail == null) continue;
                thumbnailSizes.add(new FileMessage.ThumbnailSize(thumbnail.getMaxWidth(), thumbnail.getMaxHeight()));
            }
        }
        ArrayList<String> mentionedUserIds = null;
        if (fileMessage.getMentionedUserIds() != null && fileMessage.getMentionedUserIds().size() > 0) {
            mentionedUserIds = new ArrayList<String>(fileMessage.getMentionedUserIds());
        }
        ArrayList<MessageMetaArray> metaArrays = null;
        if (fileMessage.getAllMetaArrays() != null && fileMessage.getAllMetaArrays().size() > 0) {
            metaArrays = new ArrayList<MessageMetaArray>(fileMessage.getAllMetaArrays());
        }
        return this.localSendFileMessage(fileMessage.getRequestId(), fileMessage.getRootMessageId(), fileMessage.getParentMessageId(), fileUrlOrFile, fileMessage.getName(), fileMessage.getType(), fileMessage.getSize(), fileMessage.getData(), fileMessage.getCustomType(), thumbnailSizes, fileMessage.getMentionType(), mentionedUserIds, null, metaArrays, paramHandler, paramProgressHandler, null);
    }

    public void resendUserMessage(UserMessage userMessage, ResendUserMessageHandler handler) {
        this.localResendUserMessage(userMessage, handler);
    }

    public void translateUserMessage(final UserMessage userMessage, final List<String> targetLanguages, final TranslateUserMessageHandler handler) {
        APITaskQueue.addTask(new JobResultTask<UserMessage>(){

            @Override
            public UserMessage call() throws Exception {
                if (userMessage == null || userMessage.getMessageId() == 0L || userMessage.getSendingStatus() != BaseMessage.SendingStatus.SUCCEEDED || targetLanguages == null || targetLanguages.size() == 0) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                if (!BaseChannel.this.getUrl().equals(userMessage.getChannelUrl())) {
                    throw new SendBirdException("The message does not belong to this channel.", 800110);
                }
                if (SendBird.getCurrentUser() == null) {
                    throw new SendBirdException("Connection must be made.", 800101);
                }
                JsonElement response = APIClient.getInstance().translateUserMessage(BaseChannel.this instanceof OpenChannel, BaseChannel.this.getUrl(), userMessage.getMessageId(), targetLanguages);
                JsonObject responseObj = response.getAsJsonObject();
                responseObj.addProperty("req_id", userMessage.getRequestId());
                UserMessage userMessage2 = (UserMessage)BaseMessage.createMessage((JsonElement)responseObj, BaseChannel.this.getUrl(), BaseChannel.this.getChannelType());
                if (userMessage2 != null) {
                    userMessage2.setSendingStatus(BaseMessage.SendingStatus.SUCCEEDED);
                }
                return userMessage2;
            }

            @Override
            public void onResultForUiThread(UserMessage userMessage2, SendBirdException e) {
                if (handler != null) {
                    handler.onTranslated(userMessage2, e);
                }
            }
        });
    }

    public FileMessage copyFileMessage(final BaseChannel targetChannel, final FileMessage fileMessage, final CopyFileMessageHandler handler) {
        if (targetChannel == null || fileMessage == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCopied(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        if (!this.getUrl().equals(fileMessage.getChannelUrl())) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCopied(null, new SendBirdException("The message does not belong to this channel.", 800110));
                    }
                });
            }
            return null;
        }
        final JsonArray thumbnailsArray = new JsonArray();
        for (FileMessage.Thumbnail thumbnail : fileMessage.getThumbnails()) {
            thumbnailsArray.add(thumbnail.toJson());
        }
        JsonArray mentionedUsersArray = new JsonArray();
        for (User user : fileMessage.getMentionedUsers()) {
            if (user == null) continue;
            JsonObject userObj = user.toJson().getAsJsonObject();
            mentionedUsersArray.add((JsonElement)userObj);
        }
        JsonArray jsonArray = new JsonArray();
        if (fileMessage.getAllMetaArrays() != null && !fileMessage.getAllMetaArrays().isEmpty()) {
            for (MessageMetaArray metaArray : fileMessage.getAllMetaArrays()) {
                jsonArray.add((JsonElement)metaArray.toJson());
            }
        }
        final String string = Command.generateRequestId();
        final FileMessage msg = FileMessage.copiedInstance(string, 0L, 0L, Sender.toSender(SendBird.getCurrentUser(), targetChannel.getCurrentUserRole()), targetChannel.getUrl(), targetChannel.getChannelType(), fileMessage.getPlainUrl(), fileMessage.getName(), fileMessage.getType(), fileMessage.getSize(), fileMessage.getData(), fileMessage.getCustomType(), thumbnailsArray.toString(), fileMessage.requiredAuth(), System.currentTimeMillis(), fileMessage.getMentionType(), fileMessage.getMentionedUserIds(), mentionedUsersArray.toString(), jsonArray.toString(), new ThreadInfo(), targetChannel.getCurrentUserRole() == Member.Role.OPERATOR);
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        FileMessage fileMessage = new FileMessage(msg.toJson());
                        fileMessage.setSendingStatus(BaseMessage.SendingStatus.FAILED);
                        fileMessage.mErrorCode = 800101;
                        handler.onCopied(fileMessage, new SendBirdException("Connection must be made before you forward message.", 800101));
                    }
                });
            }
            msg.setSendingStatus(BaseMessage.SendingStatus.PENDING);
            return msg;
        }
        if (SendBird.getConnectionState() == SendBird.ConnectionState.OPEN) {
            Command cmd = Command.bFile(string, 0L, 0L, targetChannel.getUrl(), fileMessage.getPlainUrl(), fileMessage.getName(), fileMessage.getType(), fileMessage.getSize(), fileMessage.getData(), fileMessage.getCustomType(), thumbnailsArray.toString(), fileMessage.requiredAuth(), fileMessage.getMentionType(), fileMessage.getMentionedUserIds(), null, fileMessage.getAllMetaArrays());
            SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

                @Override
                public void onResult(final Command acked, final SendBirdException e) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (e != null) {
                                if (handler != null) {
                                    FileMessage fileMessage = new FileMessage(msg.toJson());
                                    fileMessage.setSendingStatus(BaseMessage.SendingStatus.FAILED);
                                    fileMessage.mErrorCode = e.getCode();
                                    handler.onCopied(fileMessage, e);
                                }
                                return;
                            }
                            if (handler != null) {
                                FileMessage fileMessage = (FileMessage)BaseMessage.createMessage(acked);
                                if (fileMessage != null) {
                                    fileMessage.setSendingStatus(BaseMessage.SendingStatus.SUCCEEDED);
                                }
                                handler.onCopied(fileMessage, null);
                            }
                        }
                    });
                }
            });
        } else {
            APITaskQueue.addTask(new JobResultTask<FileMessage>(){

                @Override
                public FileMessage call() throws Exception {
                    FileMessage result = null;
                    try {
                        JsonElement response = APIClient.getInstance().sendFileMessage(targetChannel instanceof OpenChannel, 0L, 0L, targetChannel.getUrl(), fileMessage.getPlainUrl(), fileMessage.getName(), fileMessage.getSize(), fileMessage.getType(), fileMessage.getCustomType(), fileMessage.getData(), thumbnailsArray.toString(), fileMessage.requiredAuth(), fileMessage.getMentionType(), fileMessage.getMentionedUserIds(), null, fileMessage.getAllMetaArrays());
                        JsonObject responseObj = response.getAsJsonObject();
                        responseObj.addProperty("req_id", string);
                        result = (FileMessage)BaseMessage.createMessage((JsonElement)responseObj, BaseChannel.this.getUrl(), BaseChannel.this.getChannelType());
                        if (result != null) {
                            result.setSendingStatus(BaseMessage.SendingStatus.SUCCEEDED);
                        }
                    }
                    catch (SendBirdException e) {
                        result = new FileMessage(msg.toJson());
                        result.setSendingStatus(BaseMessage.SendingStatus.FAILED);
                        result.mErrorCode = e.getCode();
                    }
                    return result;
                }

                @Override
                public void onResultForUiThread(FileMessage fileMessage2, SendBirdException e) {
                    if (handler != null) {
                        handler.onCopied(fileMessage2, e);
                    }
                }
            });
        }
        msg.setSendingStatus(BaseMessage.SendingStatus.PENDING);
        return msg;
    }

    public UserMessage copyUserMessage(BaseChannel targetChannel, UserMessage userMessage, final CopyUserMessageHandler handler) {
        if (targetChannel == null || userMessage == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCopied(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return null;
        }
        if (!this.getUrl().equals(userMessage.getChannelUrl())) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCopied(null, new SendBirdException("The message does not belong to this channel.", 800110));
                    }
                });
            }
            return null;
        }
        ArrayList<String> targetLanguages = null;
        if (userMessage.getTranslations().size() > 0) {
            targetLanguages = new ArrayList<String>(userMessage.getTranslations().keySet());
        }
        String reqId = Command.generateRequestId();
        Command cmd = Command.bMessage(reqId, 0L, 0L, targetChannel.getUrl(), userMessage.getMessage(), userMessage.getData(), userMessage.getCustomType(), userMessage.getMentionType(), userMessage.getMentionedUserIds(), null, userMessage.getAllMetaArrays(), targetLanguages);
        JsonObject transObj = new JsonObject();
        if (targetLanguages != null) {
            for (String string : targetLanguages) {
                transObj.addProperty(string, userMessage.getTranslations().get(string));
            }
        }
        JsonArray mentionedUsersArray = new JsonArray();
        for (User user : userMessage.getMentionedUsers()) {
            if (user == null) continue;
            JsonObject jsonObject = user.toJson().getAsJsonObject();
            mentionedUsersArray.add((JsonElement)jsonObject);
        }
        JsonArray jsonArray = new JsonArray();
        if (userMessage.getAllMetaArrays() != null && !userMessage.getAllMetaArrays().isEmpty()) {
            for (MessageMetaArray messageMetaArray : userMessage.getAllMetaArrays()) {
                jsonArray.add((JsonElement)messageMetaArray.toJson());
            }
        }
        JsonArray jsonArray2 = new JsonArray();
        if (userMessage.getPlugins() != null && !userMessage.getPlugins().isEmpty()) {
            for (Plugin plugin : userMessage.getPlugins()) {
                jsonArray2.add(plugin.toJson());
            }
        }
        final UserMessage userMessage2 = UserMessage.copiedInstance(cmd.getRequestId(), 0L, 0L, Sender.toSender(SendBird.getCurrentUser(), targetChannel.getCurrentUserRole()), targetChannel.getUrl(), targetChannel.getChannelType(), userMessage.getMessage(), userMessage.getData(), userMessage.getCustomType(), transObj.toString(), System.currentTimeMillis(), userMessage.getMentionType(), userMessage.getMentionedUserIds(), mentionedUsersArray.toString(), jsonArray.toString(), new ThreadInfo(), userMessage.getOgMetaData(), targetChannel.getCurrentUserRole() == Member.Role.OPERATOR, jsonArray2.toString());
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        UserMessage userMessage = (UserMessage)BaseMessage.clone(userMessage2);
                        if (userMessage != null) {
                            userMessage.setSendingStatus(BaseMessage.SendingStatus.FAILED);
                            userMessage.mErrorCode = 800101;
                        }
                        handler.onCopied(userMessage, new SendBirdException("Connection must be made before you forward message.", 800101));
                    }
                });
            }
            userMessage2.setSendingStatus(BaseMessage.SendingStatus.PENDING);
            return userMessage2;
        }
        SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

            @Override
            public void onResult(final Command acked, final SendBirdException e) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (e != null) {
                            if (handler != null) {
                                UserMessage userMessage = (UserMessage)BaseMessage.clone(userMessage2);
                                if (userMessage != null) {
                                    userMessage.setSendingStatus(BaseMessage.SendingStatus.FAILED);
                                    userMessage.mErrorCode = e.getCode();
                                }
                                handler.onCopied(userMessage, e);
                            }
                            return;
                        }
                        if (handler != null) {
                            UserMessage userMessage = (UserMessage)BaseMessage.createMessage(acked);
                            if (userMessage != null) {
                                userMessage.setSendingStatus(BaseMessage.SendingStatus.SUCCEEDED);
                            }
                            handler.onCopied(userMessage, null);
                        }
                    }
                });
            }
        });
        userMessage2.setSendingStatus(BaseMessage.SendingStatus.PENDING);
        return userMessage2;
    }

    public void createMetaCounters(final Map<String, Integer> metaCounterMap, final MetaCounterHandler handler) {
        APITaskQueue.addTask(new JobResultTask<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                if (metaCounterMap == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                JsonElement response = APIClient.getInstance().createMetaCounters(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl(), metaCounterMap);
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry entry : obj.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    result.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                }
                return result;
            }

            @Override
            public void onResultForUiThread(Map<String, Integer> result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public void updateMetaCounters(final Map<String, Integer> metaCounterMap, final MetaCounterHandler handler) {
        APITaskQueue.addTask(new JobResultTask<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                if (metaCounterMap == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                JsonElement response = APIClient.getInstance().updateMetaCounters(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl(), metaCounterMap, true, 0);
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry entry : obj.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    result.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                }
                return result;
            }

            @Override
            public void onResultForUiThread(Map<String, Integer> result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public void increaseMetaCounters(final Map<String, Integer> metaCounterMap, final MetaCounterHandler handler) {
        APITaskQueue.addTask(new JobResultTask<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                if (metaCounterMap == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                JsonElement response = APIClient.getInstance().updateMetaCounters(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl(), metaCounterMap, false, 1);
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry entry : obj.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    result.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                }
                return result;
            }

            @Override
            public void onResultForUiThread(Map<String, Integer> result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public void decreaseMetaCounters(final Map<String, Integer> metaCounterMap, final MetaCounterHandler handler) {
        APITaskQueue.addTask(new JobResultTask<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                if (metaCounterMap == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                JsonElement response = APIClient.getInstance().updateMetaCounters(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl(), metaCounterMap, false, 2);
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry entry : obj.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    result.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                }
                return result;
            }

            @Override
            public void onResultForUiThread(Map<String, Integer> result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public void getMetaCounters(final Collection<String> keys, final MetaCounterHandler handler) {
        APITaskQueue.addTask(new JobResultTask<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                if (keys == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonElement response = APIClient.getInstance().getMetaCounters(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl(), keys);
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry entry : obj.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    result.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                }
                return result;
            }

            @Override
            public void onResultForUiThread(Map<String, Integer> result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public void getAllMetaCounters(final MetaCounterHandler handler) {
        APITaskQueue.addTask(new JobResultTask<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonElement response = APIClient.getInstance().getAllMetaCounters(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl());
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry entry : obj.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    result.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                }
                return result;
            }

            @Override
            public void onResultForUiThread(Map<String, Integer> result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public void deleteMetaCounter(final String key, final DeleteMetaCounterHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (key == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                JsonElement response = APIClient.getInstance().deleteMetaCounter(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl(), key);
                HashMap result = new HashMap();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry entry : obj.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    result.put(entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                }
                return response;
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public void deleteAllMetaCounters(final DeleteMetaCounterHandler handler) {
        APITaskQueue.addTask(new JobResultTask<HashMap<String, Integer>>(){

            @Override
            public HashMap<String, Integer> call() throws Exception {
                JsonElement response = APIClient.getInstance().deleteAllMetaCounters(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl());
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry entry : obj.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    result.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                }
                return result;
            }

            @Override
            public void onResultForUiThread(HashMap<String, Integer> result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public void createMetaData(final Map<String, String> metaDataMap, final MetaDataHandler handler) {
        APITaskQueue.addTask(new JobResultTask<Map<String, String>>(){

            @Override
            public Map<String, String> call() throws Exception {
                if (metaDataMap == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                HashMap<String, String> result = new HashMap<String, String>();
                JsonElement response = APIClient.getInstance().createMetaData(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl(), metaDataMap);
                JsonObject obj = response.getAsJsonObject();
                if (obj.has("metadata") && obj.get("metadata").isJsonObject()) {
                    JsonObject metaDataObj = (JsonObject)obj.get("metadata");
                    for (Map.Entry entry : metaDataObj.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                        result.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    }
                }
                BaseChannel.this.upsertMetadata(result, obj.get("ts").getAsLong());
                return result;
            }

            @Override
            public void onResultForUiThread(Map<String, String> result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public void updateMetaData(final Map<String, String> metaDataMap, final MetaDataHandler handler) {
        APITaskQueue.addTask(new JobResultTask<Map<String, String>>(){

            @Override
            public Map<String, String> call() throws Exception {
                if (metaDataMap == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                JsonElement response = APIClient.getInstance().updateMetaData(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl(), metaDataMap, true);
                HashMap<String, String> result = new HashMap<String, String>();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry entry : ((JsonObject)obj.get("metadata")).entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    result.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
                BaseChannel.this.upsertMetadata(result, obj.get("ts").getAsLong());
                return result;
            }

            @Override
            public void onResultForUiThread(Map<String, String> result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public void getMetaData(final Collection<String> keys, final MetaDataHandler handler) {
        APITaskQueue.addTask(new JobResultTask<Map<String, String>>(){

            @Override
            public Map<String, String> call() throws Exception {
                if (keys == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                HashMap<String, String> result = new HashMap<String, String>();
                JsonElement response = APIClient.getInstance().getMetaData(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl(), keys);
                JsonObject obj = response.getAsJsonObject();
                Logger.i("++ obj : " + obj, new Object[0]);
                JsonElement metadata = obj.get("metadata");
                if (null == metadata || !metadata.isJsonObject()) {
                    return Collections.emptyMap();
                }
                for (Map.Entry entry : ((JsonObject)obj.get("metadata")).entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    result.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
                BaseChannel.this.upsertMetadata(result, obj.get("ts").getAsLong());
                return result;
            }

            @Override
            public void onResultForUiThread(Map<String, String> result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public void getAllMetaData(final MetaDataHandler handler) {
        APITaskQueue.addTask(new JobResultTask<Map<String, String>>(){

            @Override
            public Map<String, String> call() throws Exception {
                HashMap<String, String> result = new HashMap<String, String>();
                JsonObject obj = APIClient.getInstance().getAllMetaData(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl()).getAsJsonObject();
                for (Map.Entry entry : ((JsonObject)obj.get("metadata")).entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    result.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
                BaseChannel.this.upsertMetadata(result, obj.get("ts").getAsLong());
                return result;
            }

            @Override
            public void onResultForUiThread(Map<String, String> result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public void deleteMetaData(final String key, final DeleteMetaDataHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (key == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                return APIClient.getInstance().deleteMetaData(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl(), key);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public void deleteAllMetaData(final DeleteMetaDataHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                JsonElement result = APIClient.getInstance().deleteAllMetaData(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl());
                if (result.isJsonObject() && result.getAsJsonObject().has("ts")) {
                    JsonElement tsElement = result.getAsJsonObject().get("ts");
                    BaseChannel.this.onAllMetaDataDeleted(tsElement.getAsLong());
                }
                return result;
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public void deleteMessage(final BaseMessage message, final DeleteMessageHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (message == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                return APIClient.getInstance().deleteMessage(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl(), message.getMessageId());
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public void updateUserMessage(long messageId, String body, String data, String customType, UpdateUserMessageHandler handler) {
        this.localUpdateUserMessage(messageId, body, data, customType, null, null, handler);
    }

    public void updateUserMessage(long messageId, UserMessageParams params, UpdateUserMessageHandler handler) {
        this.localUpdateUserMessage(messageId, params.mMessage, params.mData, params.mCustomType, params.mMentionType, params.mMentionedUserIds, handler);
    }

    private void localUpdateUserMessage(long messageId, String body, String data, String customType, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, final UpdateUserMessageHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUpdated(null, new SendBirdException("Connection must be made.", 800101));
                    }
                });
            }
            return;
        }
        Command cmd = Command.bUpdateMessage(this.getUrl(), messageId, body, data, customType, mentionType, mentionedUserIds, null, null, null);
        SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

            @Override
            public void onResult(final Command acked, final SendBirdException e) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (e != null) {
                            if (handler != null) {
                                handler.onUpdated(null, e);
                            }
                            return;
                        }
                        if (handler != null) {
                            UserMessage userMessage = (UserMessage)BaseMessage.createMessage(acked);
                            if (userMessage != null) {
                                userMessage.setSendingStatus(BaseMessage.SendingStatus.SUCCEEDED);
                            }
                            handler.onUpdated(userMessage, null);
                        }
                    }
                });
            }
        });
    }

    public void updateFileMessage(long messageId, String data, String customType, UpdateFileMessageHandler handler) {
        this.localUpdateFileMessage(messageId, data, customType, null, null, handler);
    }

    public void updateFileMessage(long messageId, FileMessageParams params, UpdateFileMessageHandler handler) {
        this.localUpdateFileMessage(messageId, params.mData, params.mCustomType, params.mMentionType, params.mMentionedUserIds, handler);
    }

    private void localUpdateFileMessage(long messageId, String data, String customType, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, final UpdateFileMessageHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUpdated(null, new SendBirdException("Connection must be made.", 800101));
                    }
                });
            }
            return;
        }
        Command cmd = Command.bUpdateFile(this.getUrl(), messageId, data, customType, mentionType, mentionedUserIds, null, null, null);
        SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

            @Override
            public void onResult(final Command acked, final SendBirdException e) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (e != null) {
                            if (handler != null) {
                                handler.onUpdated(null, e);
                            }
                            return;
                        }
                        if (handler != null) {
                            FileMessage fileMessage = (FileMessage)BaseMessage.createMessage(acked);
                            if (fileMessage != null) {
                                fileMessage.setSendingStatus(BaseMessage.SendingStatus.SUCCEEDED);
                            }
                            handler.onUpdated(fileMessage, null);
                        }
                    }
                });
            }
        });
    }

    public boolean cancelFileMessageUpload(String requestId) {
        return APIClient.getInstance().cancelRequest(requestId);
    }

    public void addReaction(final BaseMessage message, final String key, final ReactionHandler handler) {
        APITaskQueue.addTask(new JobResultTask<ReactionEvent>(){

            @Override
            public ReactionEvent call() throws Exception {
                if (message == null || key == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                if (SendBird.getCurrentUser() == null) {
                    throw new SendBirdException("Connection must be made before you send message.", 800101);
                }
                JsonElement respone = APIClient.getInstance().addReaction(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl(), message.getMessageId(), key);
                return new ReactionEvent(respone);
            }

            @Override
            public void onResultForUiThread(ReactionEvent result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public void deleteReaction(final BaseMessage message, final String key, final ReactionHandler handler) {
        APITaskQueue.addTask(new JobResultTask<ReactionEvent>(){

            @Override
            public ReactionEvent call() throws Exception {
                if (message == null || key == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                if (SendBird.getCurrentUser() == null) {
                    throw new SendBirdException("Connection must be made before you send message.", 800101);
                }
                JsonElement respone = APIClient.getInstance().deleteReaction(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl(), message.getMessageId(), key);
                return new ReactionEvent(respone);
            }

            @Override
            public void onResultForUiThread(ReactionEvent result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public void createMessageMetaArrayKeys(final BaseMessage message, List<String> metaArrayKeys, final MessageMetaArrayHandler handler) {
        if (message == null || message instanceof AdminMessage || metaArrayKeys == null || metaArrayKeys.size() <= 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(message, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        ArrayList<String> paramMetaArrayKeys = new ArrayList<String>(new LinkedHashSet<String>(metaArrayKeys));
        ArrayList<MessageMetaArray> metaArrays = new ArrayList<MessageMetaArray>();
        for (String key : paramMetaArrayKeys) {
            metaArrays.add(new MessageMetaArray(key));
        }
        Command cmd = null;
        if (message instanceof UserMessage) {
            cmd = Command.bUpdateMessage(this.getUrl(), message.getMessageId(), null, null, null, null, null, metaArrays, true, true);
        } else if (message instanceof FileMessage) {
            cmd = Command.bUpdateFile(this.getUrl(), message.getMessageId(), null, null, null, null, metaArrays, true, true);
        }
        if (cmd != null) {
            SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

                @Override
                public void onResult(Command acked, final SendBirdException e) {
                    if (e != null) {
                        if (handler != null) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    handler.onResult(message, e);
                                }
                            });
                        }
                        return;
                    }
                    JsonObject obj = acked.getJsonElement().getAsJsonObject();
                    if (obj != null && obj.has("metaarray")) {
                        JsonObject metaArrayObj = obj.getAsJsonObject("metaarray");
                        for (Map.Entry entry : metaArrayObj.entrySet()) {
                            String key = (String)entry.getKey();
                            if (key == null) continue;
                            message.addMetaArray(key);
                        }
                        if (handler != null) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    handler.onResult(message, null);
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    public void deleteMessageMetaArrayKeys(final BaseMessage message, List<String> metaArrayKeys, final MessageMetaArrayHandler handler) {
        if (message == null || message instanceof AdminMessage || metaArrayKeys == null || metaArrayKeys.size() <= 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(message, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        final ArrayList<String> paramMetaArrayKeys = new ArrayList<String>(new LinkedHashSet<String>(metaArrayKeys));
        ArrayList<MessageMetaArray> metaArrays = new ArrayList<MessageMetaArray>();
        for (String key : paramMetaArrayKeys) {
            metaArrays.add(new MessageMetaArray(key));
        }
        Command cmd = null;
        if (message instanceof UserMessage) {
            cmd = Command.bUpdateMessage(this.getUrl(), message.getMessageId(), null, null, null, null, null, metaArrays, false, true);
        } else if (message instanceof FileMessage) {
            cmd = Command.bUpdateFile(this.getUrl(), message.getMessageId(), null, null, null, null, metaArrays, false, true);
        }
        if (cmd != null) {
            SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

                @Override
                public void onResult(Command acked, final SendBirdException e) {
                    if (e != null) {
                        if (handler != null) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    handler.onResult(message, e);
                                }
                            });
                        }
                        return;
                    }
                    for (String key : paramMetaArrayKeys) {
                        if (key == null) continue;
                        message.removeMetaArrayByKey(key);
                    }
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(message, null);
                            }
                        });
                    }
                }
            });
        }
    }

    @Deprecated
    public void addMessageMetaArrayValues(BaseMessage message, Map<String, List<String>> metaArrayMap, MessageMetaArrayHandler handler) {
        ArrayList<MessageMetaArray> metaArrays = new ArrayList<MessageMetaArray>();
        for (String key : metaArrayMap.keySet()) {
            if (key == null) continue;
            metaArrays.add(new MessageMetaArray(key, metaArrayMap.get(key)));
        }
        this.localUpdateMessageMetaArrayValues(message, metaArrays, true, handler);
    }

    public void addMessageMetaArrayValues(BaseMessage message, List<MessageMetaArray> metaArrays, MessageMetaArrayHandler handler) {
        this.localUpdateMessageMetaArrayValues(message, metaArrays, true, handler);
    }

    @Deprecated
    public void removeMessageMetaArrayValues(BaseMessage message, Map<String, List<String>> metaArrayMap, MessageMetaArrayHandler handler) {
        ArrayList<MessageMetaArray> metaArrays = new ArrayList<MessageMetaArray>();
        for (String key : metaArrayMap.keySet()) {
            if (key == null) continue;
            metaArrays.add(new MessageMetaArray(key, metaArrayMap.get(key)));
        }
        this.localUpdateMessageMetaArrayValues(message, metaArrays, false, handler);
    }

    public void removeMessageMetaArrayValues(BaseMessage message, List<MessageMetaArray> metaArrays, MessageMetaArrayHandler handler) {
        this.localUpdateMessageMetaArrayValues(message, metaArrays, false, handler);
    }

    private void localUpdateMessageMetaArrayValues(final BaseMessage message, List<MessageMetaArray> metaArrays, boolean add, final MessageMetaArrayHandler handler) {
        if (message == null || message instanceof AdminMessage || metaArrays == null || metaArrays.size() <= 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(message, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        Command cmd = null;
        if (message instanceof UserMessage) {
            cmd = Command.bUpdateMessage(this.getUrl(), message.getMessageId(), null, null, null, null, null, metaArrays, add, false);
        } else if (message instanceof FileMessage) {
            cmd = Command.bUpdateFile(this.getUrl(), message.getMessageId(), null, null, null, null, metaArrays, add, false);
        }
        if (cmd != null) {
            SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

                @Override
                public void onResult(Command acked, final SendBirdException e) {
                    if (e != null) {
                        if (handler != null) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    handler.onResult(message, e);
                                }
                            });
                        }
                        return;
                    }
                    JsonObject obj = acked.getJsonElement().getAsJsonObject();
                    if (obj != null && obj.has("metaarray")) {
                        JsonObject metaArrayObj = obj.getAsJsonObject("metaarray");
                        for (Map.Entry entry : metaArrayObj.entrySet()) {
                            String key = (String)entry.getKey();
                            if (key == null || !metaArrayObj.get(key).isJsonArray()) continue;
                            ArrayList<String> values = new ArrayList<String>();
                            JsonArray array = metaArrayObj.get(key).getAsJsonArray();
                            if (array != null) {
                                for (int i = 0; i < array.size(); ++i) {
                                    String value = array.get(i).getAsString();
                                    if (value == null) continue;
                                    values.add(value);
                                }
                            }
                            message.setMetaArray(key, values);
                        }
                        if (handler != null) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    handler.onResult(message, null);
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    public void getMyMutedInfo(final GetMyMutedInfoHandler handler) {
        APITaskQueue.addTask(new JobTask<Boolean>(){

            @Override
            public Boolean call() {
                block3: {
                    try {
                        long remainingDuration;
                        JsonObject obj = APIClient.getInstance().getMyMutedInfo(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl()).getAsJsonObject();
                        final boolean isMuted = obj.has("is_muted") && obj.get("is_muted").getAsBoolean();
                        final String description = obj.has("description") ? obj.get("description").getAsString() : null;
                        final long startAt = obj.has("start_at") ? obj.get("start_at").getAsLong() : -1L;
                        final long endAt = obj.has("end_at") ? obj.get("end_at").getAsLong() : -1L;
                        long l = remainingDuration = obj.has("remaining_duration") ? obj.get("remaining_duration").getAsLong() : -1L;
                        if (handler != null) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    handler.onResult(isMuted, description, startAt, endAt, remainingDuration, null);
                                }
                            });
                        }
                    }
                    catch (SendBirdException e) {
                        if (handler == null) break block3;
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(false, null, -1L, -1L, -1L, e);
                            }
                        });
                    }
                }
                return true;
            }
        });
    }

    public void report(final ReportCategory reportCategory, final String reportDescription, final ReportHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (reportCategory == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                return APIClient.getInstance().reportChannel(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl(), reportCategory, reportDescription);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public void reportUser(final User offendingUser, final ReportCategory reportCategory, final String reportDescription, final ReportUserHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (offendingUser == null || reportCategory == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                return APIClient.getInstance().reportUser(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl(), offendingUser.getUserId(), reportCategory, reportDescription);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public void reportMessage(final BaseMessage message, final ReportCategory reportCategory, final String reportDescription, final ReportMessageHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (message == null || message instanceof AdminMessage || reportCategory == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                String offendingUserId = null;
                Sender sender = message.getSender();
                if (sender != null) {
                    offendingUserId = sender.getUserId();
                }
                return APIClient.getInstance().reportMessage(BaseChannel.this.isOpenChannel(), BaseChannel.this.getUrl(), offendingUserId, message.getMessageId(), reportCategory, reportDescription);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public void addOperators(final Collection<String> userIds, final AddOperatorsHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (userIds == null || userIds.isEmpty()) {
                    throw new SendBirdException("userIds is null or empty", 800110);
                }
                return APIClient.getInstance().addOperators(BaseChannel.this, userIds);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public void removeOperators(final Collection<String> userIds, final RemoveOperatorsHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (userIds == null || userIds.isEmpty()) {
                    throw new SendBirdException("userIds is null or empty", 800110);
                }
                return APIClient.getInstance().removeOperators(BaseChannel.this, userIds);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public void removeAllOperators(final RemoveAllOperatorsHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                return APIClient.getInstance().removeAllOperators(BaseChannel.this);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    abstract Member.Role getCurrentUserRole();

    static void getChannel(Command command, final OnGetChannelHandler handler) {
        String channelUrl = command.getChannelUrl();
        ChannelType channelType = command.getChannelType();
        boolean withoutCache = command.useWithoutCache();
        Logger.d("++ channelUrl=%s, channelType = %s, withoutCache=%s", new Object[]{channelUrl, channelType, withoutCache});
        if (TextUtils.isEmpty((CharSequence)channelUrl) || channelType == null) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                }
            });
            return;
        }
        OpenChannel.OpenChannelGetHandler openChannelGetHandler = new OpenChannel.OpenChannelGetHandler(){

            @Override
            public void onResult(OpenChannel channel, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(channel, e);
                }
            }
        };
        GroupChannel.GroupChannelGetHandler groupChannelGetHandler = new GroupChannel.GroupChannelGetHandler(){

            @Override
            public void onResult(GroupChannel channel, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(channel, e);
                }
            }
        };
        if (withoutCache) {
            if (channelType == ChannelType.OPEN) {
                OpenChannel.getChannelWithoutCacheInternal(channelUrl, openChannelGetHandler);
            } else {
                GroupChannel.getChannelWithoutCacheInternal(channelUrl, groupChannelGetHandler);
            }
        } else if (channelType == ChannelType.OPEN) {
            OpenChannel.getChannelInternal(channelUrl, openChannelGetHandler);
        } else {
            GroupChannel.getChannelInternal(channelUrl, groupChannelGetHandler);
        }
    }

    final void upsertMetadata(Map<String, String> metaDataMap, long updatedAt) {
        this.cachedMetadata.putAll(metaDataMap, updatedAt);
    }

    final void onMetaDataDeleted(List<String> keys, long updatedAt) {
        this.cachedMetadata.removeAll(keys, updatedAt);
    }

    final void onAllMetaDataDeleted(long updatedAt) {
        this.cachedMetadata.removeAll(updatedAt);
    }

    public final Map<String, String> getCachedMetaData() {
        return this.cachedMetadata.asMap();
    }

    public String toString() {
        return "BaseChannel{mUrl='" + this.mUrl + '\'' + ", mName='" + this.mName + '\'' + ", mCoverUrl='" + this.mCoverUrl + '\'' + ", mCreatedAt=" + this.mCreatedAt + ", mData='" + this.mData + '\'' + ", mFreeze=" + this.mFreeze + ", mIsEphemeral=" + this.mIsEphemeral + ", mDirty=" + this.mDirty + ", mSendFileMessageDataList=" + this.mSendFileMessageDataList + ", mIsSendingFileMessage=" + this.mIsSendingFileMessage + '}';
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        BaseChannel channel = (BaseChannel)o;
        return this.getUrl().equals(channel.getUrl()) && this.getCreatedAt() == channel.getCreatedAt();
    }

    public int hashCode() {
        return HashUtils.generateHashCode(this.getUrl(), this.getCreatedAt());
    }

    private static final class SendFileMessageData {
        static final int FILE_SIZE_UNSET = -1;
        private final FileMessage mTempFileMessage;
        private final String mData;
        private final String mCustomType;
        private final BaseMessageParams.MentionType mMentionType;
        private final List<String> mMentionedUserIds;
        private final BaseMessageParams.PushNotificationDeliveryOption mPushNotificationDeliveryOption;
        private final List<MessageMetaArray> mMetaArrays;
        private final Object mHandler;
        private final Object mProgressHandler;
        private ServerSideData serverSideData = null;

        SendFileMessageData(String fileUrl, FileMessage tempFileMessage, String data, String customType, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, BaseMessageParams.PushNotificationDeliveryOption pushNotificationDeliveryOption, List<? extends MessageMetaArray> metaArrays, Object handler, Object progressHandler) {
            this(tempFileMessage, data, customType, mentionType, mentionedUserIds, pushNotificationDeliveryOption, metaArrays, handler, progressHandler);
            this.serverSideData = new ServerSideData(fileUrl, null, false, -1);
        }

        SendFileMessageData(FileMessage tempFileMessage, String data, String customType, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, BaseMessageParams.PushNotificationDeliveryOption pushNotificationDeliveryOption, List<? extends MessageMetaArray> metaArrays, Object handler, Object progressHandler) {
            this.mTempFileMessage = tempFileMessage;
            this.mData = data;
            this.mCustomType = customType;
            this.mMentionType = mentionType;
            this.mMentionedUserIds = null == mentionedUserIds ? null : (mentionedUserIds.isEmpty() ? Collections.emptyList() : new ArrayList<String>(mentionedUserIds));
            this.mPushNotificationDeliveryOption = pushNotificationDeliveryOption;
            this.mMetaArrays = null == metaArrays ? null : (metaArrays.isEmpty() ? Collections.emptyList() : new ArrayList<MessageMetaArray>(metaArrays));
            this.mHandler = handler;
            this.mProgressHandler = progressHandler;
        }

        void setServerSideData(String fileUrl, String thumbnails, boolean requireAuth, int fileSize) {
            this.serverSideData = new ServerSideData(fileUrl, thumbnails, requireAuth, fileSize);
        }

        boolean isReadyToSend() {
            return null != this.serverSideData;
        }

        String getFileUrl() {
            return this.serverSideData.getFileUrl();
        }

        FileMessage getTempFileMessage() {
            return this.mTempFileMessage;
        }

        String getData() {
            return this.mData;
        }

        String getCustomType() {
            return this.mCustomType;
        }

        String getThumbnails() {
            return this.serverSideData.getThumbnails();
        }

        boolean requireAuth() {
            return this.serverSideData.requireAuth();
        }

        BaseMessageParams.MentionType getMentionType() {
            return this.mMentionType;
        }

        List<String> getMentionedUserIds() {
            if (null == this.mMentionedUserIds) {
                return null;
            }
            if (this.mMentionedUserIds.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<String>(this.mMentionedUserIds);
        }

        BaseMessageParams.PushNotificationDeliveryOption getPushNotificationDeliveryOption() {
            return this.mPushNotificationDeliveryOption;
        }

        List<MessageMetaArray> getMetaArrays() {
            if (null == this.mMetaArrays) {
                return null;
            }
            if (this.mMetaArrays.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<MessageMetaArray>(this.mMetaArrays);
        }

        Object getHandler() {
            return this.mHandler;
        }

        Object getProgressHandler() {
            return this.mProgressHandler;
        }

        int getFileSize() {
            return this.serverSideData.getFileSize();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SendFileMessageData)) {
                return false;
            }
            SendFileMessageData other = (SendFileMessageData)object;
            return EqualsUtil.equals(this.mTempFileMessage, other.mTempFileMessage) && EqualsUtil.equals(this.mData, other.mData) && EqualsUtil.equals(this.mCustomType, other.mCustomType) && this.mMentionType == other.mMentionType && EqualsUtil.equals(this.mMentionedUserIds, other.mMentionedUserIds) && this.mPushNotificationDeliveryOption == other.mPushNotificationDeliveryOption && EqualsUtil.equals(this.mMetaArrays, other.mMetaArrays) && EqualsUtil.equals(this.mHandler, other.mHandler) && EqualsUtil.equals(this.mProgressHandler, other.mProgressHandler);
        }

        public int hashCode() {
            return HashUtils.generateHashCode(new Object[]{this.mTempFileMessage, this.mData, this.mCustomType, this.mMentionType, this.mMentionedUserIds, this.mPushNotificationDeliveryOption, this.mMetaArrays, this.mHandler, this.mProgressHandler});
        }

        public String toString() {
            return "SendFileMessageData{mTempFileMessage=" + this.mTempFileMessage + ", mData='" + this.mData + '\'' + ", mCustomType='" + this.mCustomType + '\'' + ", mMentionType=" + (Object)((Object)this.mMentionType) + ", mMentionedUserIds=" + this.mMentionedUserIds + ", mPushNotificationDeliveryOption=" + (Object)((Object)this.mPushNotificationDeliveryOption) + ", mMetaArrays=" + this.mMetaArrays + ", mHandler=" + this.mHandler + ", mProgressHandler=" + this.mProgressHandler + ", serverSideData=" + this.serverSideData + '}';
        }

        private static final class ServerSideData {
            private final String mFileUrl;
            private final String mThumbnails;
            private final boolean mRequireAuth;
            private final int fileSize;

            ServerSideData(String mFileUrl, String mThumbnails, boolean mRequireAuth, int fileSize) {
                this.mFileUrl = mFileUrl;
                this.mThumbnails = mThumbnails;
                this.mRequireAuth = mRequireAuth;
                this.fileSize = fileSize;
            }

            String getFileUrl() {
                return this.mFileUrl;
            }

            String getThumbnails() {
                return this.mThumbnails;
            }

            boolean requireAuth() {
                return this.mRequireAuth;
            }

            int getFileSize() {
                return this.fileSize;
            }

            public String toString() {
                return "ServerSideData{, mFileUrl='" + this.mFileUrl + '\'' + ", mThumbnails='" + this.mThumbnails + '\'' + ", mRequireAuth=" + this.mRequireAuth + '\'' + ", fileSize=" + this.fileSize + '}';
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ServerSideData other = (ServerSideData)object;
                return this.mRequireAuth == other.requireAuth() && EqualsUtil.equals(this.mFileUrl, other.getFileUrl()) && EqualsUtil.equals(this.mThumbnails, other.getThumbnails()) && EqualsUtil.equals(this.fileSize, other.fileSize);
            }

            public int hashCode() {
                return HashUtils.generateHashCode(this.mFileUrl, this.mThumbnails, this.mRequireAuth, this.fileSize);
            }
        }
    }

    static interface OnGetChannelHandler {
        public void onResult(BaseChannel var1, SendBirdException var2);
    }

    public static interface ReportMessageHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface ReportUserHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface ReportHandler {
        public void onResult(SendBirdException var1);
    }

    public static enum ReportCategory {
        SUSPICIOUS,
        HARASSING,
        SPAM,
        INAPPROPRIATE;

    }

    public static interface GetMyMutedInfoHandler {
        public void onResult(boolean var1, String var2, long var3, long var5, long var7, SendBirdException var9);
    }

    public static interface MessageMetaArrayHandler {
        public void onResult(BaseMessage var1, SendBirdException var2);
    }

    public static interface ReactionHandler {
        public void onResult(ReactionEvent var1, SendBirdException var2);
    }

    public static interface UpdateFileMessageHandler {
        public void onUpdated(FileMessage var1, SendBirdException var2);
    }

    public static interface UpdateUserMessageHandler {
        public void onUpdated(UserMessage var1, SendBirdException var2);
    }

    public static interface DeleteMessageHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface CopyFileMessageHandler {
        public void onCopied(FileMessage var1, SendBirdException var2);
    }

    public static interface CopyUserMessageHandler {
        public void onCopied(UserMessage var1, SendBirdException var2);
    }

    public static interface SendFileMessagesWithProgressHandler {
        public void onProgress(String var1, int var2, int var3, int var4);

        public void onSent(FileMessage var1, SendBirdException var2);

        public void onResult(SendBirdException var1);
    }

    public static interface SendFileMessagesHandler {
        public void onSent(FileMessage var1, SendBirdException var2);

        public void onResult(SendBirdException var1);
    }

    public static interface ResendFileMessageWithProgressHandler {
        public void onProgress(int var1, int var2, int var3);

        public void onSent(FileMessage var1, SendBirdException var2);
    }

    public static interface ResendFileMessageHandler {
        public void onSent(FileMessage var1, SendBirdException var2);
    }

    public static interface SendFileMessageWithProgressHandler {
        public void onProgress(int var1, int var2, int var3);

        public void onSent(FileMessage var1, SendBirdException var2);
    }

    public static interface SendFileMessageHandler {
        public void onSent(FileMessage var1, SendBirdException var2);
    }

    public static interface TranslateUserMessageHandler {
        public void onTranslated(UserMessage var1, SendBirdException var2);
    }

    public static interface ResendUserMessageHandler {
        public void onSent(UserMessage var1, SendBirdException var2);
    }

    public static interface SendUserMessageHandler {
        public void onSent(UserMessage var1, SendBirdException var2);
    }

    public static interface DeleteMetaDataHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface MetaDataHandler {
        public void onResult(Map<String, String> var1, SendBirdException var2);
    }

    public static interface DeleteMetaCounterHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface MetaCounterHandler {
        public void onResult(Map<String, Integer> var1, SendBirdException var2);
    }

    public static interface GetMessageChangeLogsByTokenHandler
    extends GetMessageChangeLogsHandler {
        @Override
        public void onResult(List<BaseMessage> var1, List<Long> var2, boolean var3, String var4, SendBirdException var5);
    }

    public static interface GetMessageChangeLogsHandler {
        public void onResult(List<BaseMessage> var1, List<Long> var2, boolean var3, String var4, SendBirdException var5);
    }

    public static interface GetMessagesHandler {
        public void onResult(List<BaseMessage> var1, SendBirdException var2);
    }

    public static enum MessageTypeFilter {
        ALL(""),
        USER("MESG"),
        FILE("FILE"),
        ADMIN("ADMM");

        private final String value;

        private MessageTypeFilter(String value) {
            this.value = value;
        }

        public static MessageTypeFilter fromValue(String value) {
            for (MessageTypeFilter type : MessageTypeFilter.values()) {
                if (!type.value.equalsIgnoreCase(value)) continue;
                return type;
            }
            return null;
        }

        public String value() {
            return this.value;
        }
    }

    public static enum ChannelType {
        OPEN("open"),
        GROUP("group");

        private final String value;

        private ChannelType(String value) {
            this.value = value;
        }

        public static ChannelType fromValue(String value) {
            for (ChannelType type : ChannelType.values()) {
                if (!type.value.equalsIgnoreCase(value)) continue;
                return type;
            }
            return GROUP;
        }

        public String value() {
            return this.value;
        }
    }
}

