/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.CancelableExecutorService;
import com.sendbird.android.JobResultTask;
import com.sendbird.android.JobTask;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

class APITaskQueue {
    private static final ExecutorService taskExecutor = Executors.newCachedThreadPool();

    APITaskQueue() {
    }

    static <T> Future<T> addTask(JobTask<T> task) {
        return taskExecutor.submit(task.getCallable());
    }

    static <T> Future<T> addTask(JobResultTask<T> task) {
        return taskExecutor.submit(task.getCallable());
    }

    void shutdown() {
        if (this.isEnable()) {
            taskExecutor.shutdown();
        }
    }

    List<Runnable> shutdownNow() {
        if (this.isEnable()) {
            return taskExecutor.shutdownNow();
        }
        return Collections.emptyList();
    }

    boolean isEnable() {
        return !taskExecutor.isShutdown() && !taskExecutor.isTerminated();
    }

    void cancelAll() {
        this.cancelAll(false);
    }

    void cancelAll(boolean mayInterruptIfRunning) {
        if (taskExecutor instanceof CancelableExecutorService) {
            CancelableExecutorService service = (CancelableExecutorService)taskExecutor;
            service.cancelAll(mayInterruptIfRunning);
        }
    }
}

