/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.APITaskQueue;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.JobResultTask;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserListQuery {
    private QueryType mQueryType;
    private BaseChannel mChannel;
    private String mJsonArrayName;
    private String mToken = "";
    private int mLimit = 20;
    private boolean mHasNext = true;
    private boolean mLoading = false;
    ArrayList<String> mUserIds;
    Map<String, List<String>> mMetaDataFilter;

    UserListQuery(QueryType queryType) {
        this.mQueryType = queryType;
        switch (this.mQueryType) {
            case ALL_USER: 
            case FILTERED_USER: 
            case BLOCKED_USER: {
                this.mJsonArrayName = "users";
                break;
            }
            case PARTICIPANT: {
                this.mJsonArrayName = "participants";
                break;
            }
            case MUTED_USER: {
                this.mJsonArrayName = "muted_list";
                break;
            }
            case BANNED_USER: {
                this.mJsonArrayName = "banned_list";
            }
        }
    }

    UserListQuery(QueryType queryType, BaseChannel channel) {
        this(queryType);
        this.mChannel = channel;
    }

    UserListQuery(QueryType queryType, List<String> userIds) {
        this(queryType);
        if (userIds == null) {
            return;
        }
        this.mUserIds = new ArrayList<String>(userIds);
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public boolean hasNext() {
        return this.mHasNext;
    }

    public synchronized boolean isLoading() {
        return this.mLoading;
    }

    synchronized void setLoading(boolean tf) {
        this.mLoading = tf;
    }

    @Deprecated
    public void setMetaDataFilter(String metaDataKey, List<String> metaDataValues) {
        if (metaDataKey == null || metaDataValues == null) {
            return;
        }
        this.mMetaDataFilter = new HashMap<String, List<String>>();
        this.mMetaDataFilter.put(metaDataKey, metaDataValues);
    }

    public synchronized void next(final UserListQueryResultHandler handler) {
        if (this.isLoading()) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onResult(null, new SendBirdException("Query in progress.", 800170));
                    }
                }
            });
            return;
        }
        if (!this.hasNext()) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onResult(new ArrayList<User>(), null);
                    }
                }
            });
            return;
        }
        this.setLoading(true);
        APITaskQueue.addTask(new JobResultTask<List<User>>(){

            @Override
            public List<User> call() throws Exception {
                JsonElement response = null;
                ArrayList<User> users = new ArrayList<User>();
                switch (UserListQuery.this.mQueryType) {
                    case ALL_USER: {
                        response = APIClient.getInstance().loadUserList(UserListQuery.this.mToken, UserListQuery.this.mLimit, null, UserListQuery.this.mMetaDataFilter);
                        break;
                    }
                    case FILTERED_USER: {
                        response = APIClient.getInstance().loadUserList(UserListQuery.this.mToken, UserListQuery.this.mLimit, UserListQuery.this.mUserIds, UserListQuery.this.mMetaDataFilter);
                        break;
                    }
                    case BLOCKED_USER: {
                        response = APIClient.getInstance().loadBlockedUserList(UserListQuery.this.mToken, UserListQuery.this.mLimit, UserListQuery.this.mUserIds);
                        break;
                    }
                    case PARTICIPANT: {
                        response = APIClient.getInstance().loadOpenChannelParticipantList(UserListQuery.this.mChannel.getUrl(), UserListQuery.this.mToken, UserListQuery.this.mLimit);
                        break;
                    }
                    case MUTED_USER: {
                        response = APIClient.getInstance().loadMutedUserList(UserListQuery.this.mChannel instanceof OpenChannel, UserListQuery.this.mChannel.getUrl(), UserListQuery.this.mToken, UserListQuery.this.mLimit);
                        break;
                    }
                    case BANNED_USER: {
                        response = APIClient.getInstance().loadBannedUserList(UserListQuery.this.mChannel instanceof OpenChannel, UserListQuery.this.mChannel.getUrl(), UserListQuery.this.mToken, UserListQuery.this.mLimit);
                    }
                }
                if (response != null) {
                    JsonObject result = response.getAsJsonObject();
                    UserListQuery.this.mToken = result.get("next").getAsString();
                    if (UserListQuery.this.mToken == null || UserListQuery.this.mToken.length() <= 0) {
                        UserListQuery.this.mHasNext = false;
                    }
                    JsonArray userObjs = result.get(UserListQuery.this.mJsonArrayName).getAsJsonArray();
                    for (int i = 0; i < userObjs.size(); ++i) {
                        if (UserListQuery.this.mQueryType != QueryType.BANNED_USER) {
                            users.add(new User(userObjs.get(i)));
                            continue;
                        }
                        users.add(new User(userObjs.get(i).getAsJsonObject().get("user")));
                    }
                }
                return users;
            }

            @Override
            public void onResultForUiThread(List<User> users, SendBirdException e) {
                UserListQuery.this.setLoading(false);
                if (handler != null) {
                    handler.onResult(users, e);
                }
            }
        });
    }

    public static interface UserListQueryResultHandler {
        public void onResult(List<User> var1, SendBirdException var2);
    }

    static enum QueryType {
        ALL_USER,
        FILTERED_USER,
        BLOCKED_USER,
        PARTICIPANT,
        MUTED_USER,
        BANNED_USER;

    }
}

