/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class BaseMessageListParams {
    protected int previousResultSize;
    protected int nextResultSize;
    protected BaseChannel.MessageTypeFilter messageType;
    protected String customType;
    protected Collection<String> customTypes;
    protected List<String> senderUserIds;
    protected boolean isInclusive;
    protected boolean reverse;
    protected boolean includeMetaArray;
    protected boolean includeReactions;
    protected boolean includeParentMessageText;

    public BaseMessageListParams() {
        this.previousResultSize = 0;
        this.nextResultSize = 0;
        this.messageType = BaseChannel.MessageTypeFilter.ALL;
        this.customType = null;
        this.senderUserIds = null;
        this.isInclusive = false;
        this.reverse = false;
        this.includeMetaArray = false;
        this.includeReactions = false;
        this.includeParentMessageText = false;
    }

    public BaseMessageListParams(int previousResultSize, int nextResultSize, BaseChannel.MessageTypeFilter messageType, String customType, Collection<String> customTypes, List<String> senderUserIds, boolean isInclusive, boolean reverse, boolean includeMetaArray, boolean includeReactions, boolean includeParentMessageText) {
        this.previousResultSize = previousResultSize;
        this.nextResultSize = nextResultSize;
        this.messageType = messageType;
        this.customType = customType;
        this.customTypes = CollectionUtils.copiedListOrNull(customTypes);
        this.senderUserIds = senderUserIds != null ? new ArrayList<String>(senderUserIds) : null;
        this.isInclusive = isInclusive;
        this.reverse = reverse;
        this.includeMetaArray = includeMetaArray;
        this.includeReactions = includeReactions;
        this.includeParentMessageText = includeParentMessageText;
    }

    public void setPreviousResultSize(int previousResultSize) {
        this.previousResultSize = previousResultSize;
    }

    public void setNextResultSize(int nextResultSize) {
        this.nextResultSize = nextResultSize;
    }

    public void setMessageType(BaseChannel.MessageTypeFilter messageType) {
        this.messageType = messageType;
    }

    public void setCustomType(String customType) {
        this.customType = customType;
    }

    public void setCustomTypes(Collection<String> customTypes) {
        this.customTypes = CollectionUtils.copiedListOrNull(customTypes);
    }

    public void setSenderUserIds(List<String> senderUserIds) {
        this.senderUserIds = senderUserIds != null ? new ArrayList<String>(senderUserIds) : null;
    }

    public void setInclusive(boolean inclusive) {
        this.isInclusive = inclusive;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public void setIncludeMetaArray(boolean includeMetaArray) {
        this.includeMetaArray = includeMetaArray;
    }

    public void setIncludeReactions(boolean includeReactions) {
        this.includeReactions = includeReactions;
    }

    public void setIncludeParentMessageText(boolean includeParentMessageText) {
        this.includeParentMessageText = includeParentMessageText;
    }

    public int getPreviousResultSize() {
        return this.previousResultSize;
    }

    public int getNextResultSize() {
        return this.nextResultSize;
    }

    public BaseChannel.MessageTypeFilter getMessageType() {
        return this.messageType;
    }

    public String getCustomType() {
        return this.customType;
    }

    public Collection<String> getCustomTypes() {
        return Collections.unmodifiableCollection(this.customTypes);
    }

    public List<String> getSenderUserIds() {
        return this.senderUserIds;
    }

    public boolean isInclusive() {
        return this.isInclusive;
    }

    public boolean shouldReverse() {
        return this.reverse;
    }

    public boolean shouldIncludeMetaArray() {
        return this.includeMetaArray;
    }

    public boolean shouldIncludeReactions() {
        return this.includeReactions;
    }

    public boolean shouldIncludeParentMessageText() {
        return this.includeParentMessageText;
    }

    public String toString() {
        return "BaseMessageListParams{previousResultSize=" + this.previousResultSize + ", nextResultSize=" + this.nextResultSize + ", messageType=" + (Object)((Object)this.messageType) + ", customType='" + this.customType + '\'' + ", customTypes='" + this.customTypes + '\'' + ", senderUserIds=" + this.senderUserIds + ", inclusive=" + this.isInclusive + ", reverse=" + this.reverse + ", includeMetaArray=" + this.includeMetaArray + ", includeReactions=" + this.includeReactions + ", includeParentMessageText=" + this.includeParentMessageText + '}';
    }
}

