/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.APITaskQueue;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.JobResultTask;
import com.sendbird.android.Member;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public final class GroupChannelMemberListQuery {
    private static final String MEMBER_STATE_ALL = "all";
    private static final String MEMBER_STATE_INVITED_ONLY = "invited_only";
    private static final String MEMBER_STATE_INVITED_BY_FRIEND_ONLY = "invited_by_friend";
    private static final String MEMBER_STATE_INVITED_BY_NON_FRIEND_ONLY = "invited_by_non_friend";
    private static final String MEMBER_STATE_JOINED_ONLY = "joined_only";
    private GroupChannel mGroupChannel;
    private String mToken = "";
    private int mLimit = 20;
    private boolean mHasNext = true;
    private boolean mLoading = false;
    private Order mOrder = Order.MEMBER_NICKNAME_ALPHABETICAL;
    private OperatorFilter mOperatorFilter = OperatorFilter.ALL;
    private MutedMemberFilter mMutedMemberFilter = MutedMemberFilter.ALL;
    private String mMemberState = "all";
    private String mNicknameStartsWith;

    GroupChannelMemberListQuery(GroupChannel groupChannel) {
        this.mGroupChannel = groupChannel;
    }

    public void setOperatorFilter(OperatorFilter operatorFilter) {
        this.mOperatorFilter = operatorFilter;
    }

    public void setMutedMemberFilter(MutedMemberFilter mutedMemberFilter) {
        this.mMutedMemberFilter = mutedMemberFilter;
    }

    public void setMemberStateFilter(MemberStateFilter memberStateFilter) {
        this.mMemberState = memberStateFilter == MemberStateFilter.INVITED ? MEMBER_STATE_INVITED_ONLY : (memberStateFilter == MemberStateFilter.INVITED_BY_FRIEND ? MEMBER_STATE_INVITED_BY_FRIEND_ONLY : (memberStateFilter == MemberStateFilter.INVITED_BY_NON_FRIEND ? MEMBER_STATE_INVITED_BY_NON_FRIEND_ONLY : (memberStateFilter == MemberStateFilter.JOINED ? MEMBER_STATE_JOINED_ONLY : MEMBER_STATE_ALL)));
    }

    public void setNicknameStartsWithFilter(String nickname) {
        this.mNicknameStartsWith = nickname;
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public void setOrder(Order order) {
        this.mOrder = order;
    }

    public boolean hasNext() {
        return this.mHasNext;
    }

    public synchronized boolean isLoading() {
        return this.mLoading;
    }

    synchronized void setLoading(boolean tf) {
        this.mLoading = tf;
    }

    public synchronized void next(final GroupChannelMemberListQueryResultHandler handler) {
        if (this.isLoading()) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onResult(null, new SendBirdException("Query in progress.", 800170));
                    }
                }
            });
            return;
        }
        if (!this.hasNext()) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onResult(new ArrayList<Member>(), null);
                    }
                }
            });
            return;
        }
        this.setLoading(true);
        APITaskQueue.addTask(new JobResultTask<List<Member>>(){

            @Override
            public List<Member> call() throws Exception {
                JsonElement response = APIClient.getInstance().loadGroupChannelMemberList(GroupChannelMemberListQuery.this.mGroupChannel.getUrl(), GroupChannelMemberListQuery.this.mToken, GroupChannelMemberListQuery.this.mLimit, GroupChannelMemberListQuery.this.mOperatorFilter, GroupChannelMemberListQuery.this.mMutedMemberFilter, GroupChannelMemberListQuery.this.mOrder.value, GroupChannelMemberListQuery.this.mMemberState, GroupChannelMemberListQuery.this.mNicknameStartsWith);
                JsonObject result = response.getAsJsonObject();
                GroupChannelMemberListQuery.this.mToken = result.get("next").getAsString();
                if (GroupChannelMemberListQuery.this.mToken == null || GroupChannelMemberListQuery.this.mToken.length() <= 0) {
                    GroupChannelMemberListQuery.this.mHasNext = false;
                }
                JsonArray usersArray = result.get("members").getAsJsonArray();
                ArrayList<Member> members = new ArrayList<Member>();
                for (int i = 0; i < usersArray.size(); ++i) {
                    members.add(new Member(usersArray.get(i)));
                }
                return members;
            }

            @Override
            public void onResultForUiThread(List<Member> result, SendBirdException e) {
                GroupChannelMemberListQuery.this.setLoading(false);
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public static interface GroupChannelMemberListQueryResultHandler {
        public void onResult(List<Member> var1, SendBirdException var2);
    }

    public static enum Order {
        MEMBER_NICKNAME_ALPHABETICAL("member_nickname_alphabetical"),
        OPERATOR_THEN_MEMBER_ALPHABETICAL("operator_then_member_alphabetical");

        private final String value;

        private Order(String value) {
            this.value = value;
        }
    }

    public static enum MemberStateFilter {
        ALL,
        INVITED,
        INVITED_BY_FRIEND,
        INVITED_BY_NON_FRIEND,
        JOINED;

    }

    public static enum MutedMemberFilter {
        ALL,
        MUTED,
        UNMUTED;

    }

    public static enum OperatorFilter {
        ALL("all"),
        OPERATOR("operator"),
        NONOPERATOR("nonoperator");

        private String value;

        private OperatorFilter(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

