/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.ClearableScheduledExecutorService;
import com.sendbird.android.log.Logger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class TimeoutScheduler {
    private long timeout;
    private final long initialDelay;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final AtomicBoolean repeat = new AtomicBoolean(false);
    private final ClearableScheduledExecutorService scheduler = new ClearableScheduledExecutorService();
    private TimeoutEventhandler handler;
    private Object extra;

    TimeoutScheduler(long timeout) {
        this(timeout, timeout, false, null, null);
    }

    TimeoutScheduler(long timeout, TimeoutEventhandler handler) {
        this(timeout, timeout, false, handler, null);
    }

    TimeoutScheduler(long timeout, TimeoutEventhandler handler, Object extra) {
        this(timeout, timeout, false, handler, extra);
    }

    TimeoutScheduler(long timeout, boolean repeat, TimeoutEventhandler handler, Object extra) {
        this(timeout, timeout, repeat, handler, extra);
    }

    TimeoutScheduler(long initialDelay, long timeout, boolean repeat, TimeoutEventhandler handler) {
        this(initialDelay, timeout, repeat, handler, null);
    }

    TimeoutScheduler(long initialDelay, long timeout, boolean repeat, TimeoutEventhandler handler, Object extra) {
        this.initialDelay = initialDelay;
        this.timeout = timeout;
        this.repeat.set(repeat);
        this.handler = handler;
        this.extra = extra;
    }

    public void setEventHandler(TimeoutEventhandler handler) {
        this.handler = handler;
    }

    void setExtra(Object extra) {
        this.extra = extra;
    }

    void restart() {
        this.restart(this.timeout);
    }

    void restart(long newTimeout) {
        this.timeout = newTimeout;
        if (this.isRunning.getAndSet(false)) {
            this.stop();
        }
        this.start();
    }

    void stop() {
        this.stop(false);
    }

    void stop(boolean mayInterruptIfRunning) {
        this.isRunning.set(false);
        this.cancelAll(mayInterruptIfRunning);
    }

    synchronized void once() {
        this.repeat.set(false);
        this.start();
    }

    synchronized void start() {
        if (this.handler == null) {
            throw new NullPointerException("callback must Non null");
        }
        if (this.isRunning.get()) {
            return;
        }
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (TimeoutScheduler.this.handler != null) {
                    TimeoutScheduler.this.handler.onTimeout(TimeoutScheduler.this.extra);
                }
                if (!TimeoutScheduler.this.repeat.get()) {
                    TimeoutScheduler.this.stop();
                }
                TimeoutScheduler.this.isRunning.set(false);
            }
        }, this.initialDelay, this.timeout, TimeUnit.MILLISECONDS);
        this.isRunning.compareAndSet(false, true);
    }

    boolean isRunning() {
        return this.isRunning.get();
    }

    static void await(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void cancelAll() {
        this.cancelAll(false);
    }

    private void cancelAll(boolean mayInterruptIfRunning) {
        Logger.d("__ TimeoutScheduler::cancelAll(%s)", mayInterruptIfRunning);
        this.scheduler.cancelAllJobs(mayInterruptIfRunning);
    }

    public static interface TimeoutEventhandler {
        public void onTimeout(Object var1);
    }
}

