/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.util.Base64;
import com.sendbird.android.Member;
import com.sendbird.android.SendBird;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;

public class Sender
extends User {
    private boolean mIsBlockedByMe;
    private Member.Role role = Member.Role.NONE;

    protected Sender(JsonElement el) {
        super(el);
        if (el.isJsonNull()) {
            return;
        }
        JsonObject obj = el.getAsJsonObject();
        boolean bl = this.mIsBlockedByMe = obj.has("is_blocked_by_me") && obj.get("is_blocked_by_me").getAsBoolean();
        if (obj.has("role")) {
            String myRole = obj.get("role").getAsString();
            this.role = Member.Role.fromValue(myRole);
        }
    }

    @Override
    JsonElement toJson() {
        JsonObject obj = super.toJson().getAsJsonObject();
        obj.addProperty("is_blocked_by_me", Boolean.valueOf(this.mIsBlockedByMe));
        obj.addProperty("role", this.role.getValue());
        return obj;
    }

    static Sender toSender(User user, Member.Role role) {
        if (user == null) {
            return null;
        }
        JsonElement userJson = user.toJson();
        if (role != null && userJson instanceof JsonObject) {
            JsonObject userObject = (JsonObject)userJson;
            userObject.addProperty("role", role.getValue());
        }
        return new Sender(userJson);
    }

    public boolean isBlockedByMe() {
        return this.mIsBlockedByMe;
    }

    public Member.Role getRole() {
        return this.role;
    }

    @Override
    public String toString() {
        return super.toString() + "\nSender{mIsBlockedByMe=" + this.mIsBlockedByMe + "role=" + (Object)((Object)this.role) + '}';
    }

    public static Sender buildFromSerializedData(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] copiedData = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            copiedData[i] = (byte)(data[i] ^ i & 0xFF);
        }
        try {
            String str = new String(Base64.decode((byte[])copiedData, (int)0), "UTF-8");
            return new Sender(new JsonParser().parse(str));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

