/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.annotation.SuppressLint;
import android.util.Log;
import com.sendbird.android.ConsoleLogWriter;
import com.sendbird.android.LogLevel;
import com.sendbird.android.LogWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

@SuppressLint(value={"UnknownNullness"})
final class LoggerV2 {
    private static final ThreadLocal<SimpleDateFormat> dateFormatThreadLocal = new ThreadLocal();
    private static final String defaultTag = "Sendbird";
    private static final Collection<LogWriter> logWriters = new ArrayList<LogWriter>();
    private static LogLevel level = LogLevel.WARN;

    LoggerV2() {
    }

    static void setLogLevel(LogLevel level) {
        LoggerV2.level = level;
    }

    static void v(String msg) {
        LoggerV2.vt(null, null, msg);
    }

    static void v(Throwable throwable) {
        LoggerV2.vt(null, throwable, null);
    }

    static void v(Throwable throwable, String msg) {
        LoggerV2.vt(null, throwable, msg);
    }

    static void v(String format, Object ... args) {
        LoggerV2.vt(null, null, format, args);
    }

    static void v(Throwable throwable, String format, Object ... args) {
        LoggerV2.vt(null, throwable, format, args);
    }

    static void vt(String tag, String msg) {
        LoggerV2.vt(tag, null, msg);
    }

    static void vt(String tag, Throwable throwable, String msg) {
        LoggerV2.printLog(LogLevel.VERBOSE, tag, msg, throwable);
    }

    static void vt(String tag, String format, Object ... args) {
        LoggerV2.vt(tag, null, format, args);
    }

    static void vt(String tag, Throwable throwable, String format, Object ... args) {
        LoggerV2.printLog(LogLevel.VERBOSE, tag, String.format(format, args), throwable);
    }

    static void d(String msg) {
        LoggerV2.dt(null, null, msg);
    }

    static void d(Throwable throwable) {
        LoggerV2.dt(null, throwable, null);
    }

    static void d(Throwable throwable, String msg) {
        LoggerV2.dt(null, throwable, msg);
    }

    static void d(String format, Object ... args) {
        LoggerV2.dt(null, null, format, args);
    }

    static void d(Throwable throwable, String format, Object ... args) {
        LoggerV2.dt(null, throwable, format, args);
    }

    static void dt(String tag, String msg) {
        LoggerV2.dt(tag, null, msg);
    }

    static void dt(String originalTag, Throwable throwable, String originalMsg) {
        LoggerV2.printLog(LogLevel.DEBUG, originalTag, originalMsg, throwable);
    }

    static void dt(String tag, String format, Object ... args) {
        LoggerV2.dt(tag, null, format, args);
    }

    static void dt(String tag, Throwable throwable, String format, Object ... args) {
        LoggerV2.printLog(LogLevel.DEBUG, tag, String.format(format, args), throwable);
    }

    static void i(String msg) {
        LoggerV2.it(null, null, msg);
    }

    static void i(Throwable throwable) {
        LoggerV2.it(null, throwable, null);
    }

    static void i(Throwable throwable, String msg) {
        LoggerV2.it(null, throwable, msg);
    }

    static void i(String format, Object ... args) {
        LoggerV2.it(null, null, format, args);
    }

    static void i(Throwable throwable, String format, Object ... args) {
        LoggerV2.it(null, throwable, format, args);
    }

    static void it(String tag, String msg) {
        LoggerV2.it(tag, null, msg);
    }

    static void it(String originalTag, Throwable throwable, String originalMsg) {
        LoggerV2.printLog(LogLevel.INFO, originalTag, originalMsg, throwable);
    }

    static void it(String tag, String format, Object ... args) {
        LoggerV2.it(tag, null, format, args);
    }

    static void it(String tag, Throwable throwable, String format, Object ... args) {
        LoggerV2.printLog(LogLevel.INFO, tag, String.format(format, args), throwable);
    }

    static void w(String msg) {
        LoggerV2.wt(null, null, msg);
    }

    static void w(Throwable throwable) {
        LoggerV2.wt(null, throwable, null);
    }

    static void w(Throwable throwable, String msg) {
        LoggerV2.wt(null, throwable, msg);
    }

    static void w(String format, Object ... args) {
        LoggerV2.wt(null, null, format, args);
    }

    static void w(Throwable throwable, String format, Object ... args) {
        LoggerV2.wt(null, throwable, format, args);
    }

    static void wt(String tag, String msg) {
        LoggerV2.wt(tag, null, msg);
    }

    static void wt(String originalTag, Throwable throwable, String originalMsg) {
        LoggerV2.printLog(LogLevel.WARN, originalTag, originalMsg, throwable);
    }

    static void wt(String tag, String format, Object ... args) {
        LoggerV2.wt(tag, null, format, args);
    }

    static void wt(String tag, Throwable throwable, String format, Object ... args) {
        LoggerV2.printLog(LogLevel.WARN, tag, String.format(format, args), throwable);
    }

    static void e(String msg) {
        LoggerV2.et(null, null, msg);
    }

    static void e(Throwable throwable) {
        LoggerV2.et(null, throwable, null);
    }

    static void e(Throwable throwable, String msg) {
        LoggerV2.et(null, throwable, msg);
    }

    static void e(String format, Object ... args) {
        LoggerV2.et(null, null, format, args);
    }

    static void e(Throwable throwable, String format, Object ... args) {
        LoggerV2.et(null, throwable, format, args);
    }

    static void et(String tag, String msg) {
        LoggerV2.et(tag, null, msg);
    }

    static void et(String originalTag, Throwable throwable, String originalMsg) {
        LoggerV2.printLog(LogLevel.ERROR, originalTag, originalMsg, throwable);
    }

    static void et(String tag, String format, Object ... args) {
        LoggerV2.et(tag, null, format, args);
    }

    static void et(String tag, Throwable throwable, String format, Object ... args) {
        LoggerV2.printLog(LogLevel.ERROR, tag, String.format(format, args), throwable);
    }

    private static void printLog(LogLevel level, String originalTag, String originalMsg, Throwable throwable) {
        if (LoggerV2.level.order > level.order) {
            return;
        }
        String tag = null == originalTag ? defaultTag : "Sendbird:" + originalTag;
        for (LogWriter logWriter : logWriters) {
            String msg = LoggerV2.getMessageWithStackTrace(originalMsg);
            logWriter.print(level, tag, String.format("%s\n%s", msg, Log.getStackTraceString((Throwable)throwable)));
        }
    }

    private static String getMessageWithStackTrace(String message) {
        String stackTrace = LoggerV2.getStackTrace();
        return String.format("%s %s", stackTrace == null ? "" : stackTrace, message);
    }

    private static String getStackTrace() {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        return LoggerV2.getStackTrace(stacks);
    }

    private static String getStackTrace(StackTraceElement[] stacks) {
        StackTraceElement lastStack = null;
        boolean loggerReached = false;
        for (StackTraceElement stackCursor : stacks) {
            String className = stackCursor.getClassName();
            if (!loggerReached && !className.startsWith(LoggerV2.class.getCanonicalName())) continue;
            loggerReached = true;
            if (className.startsWith(LoggerV2.class.getCanonicalName())) continue;
            lastStack = stackCursor;
            break;
        }
        if (lastStack == null) {
            return null;
        }
        String[] klass = lastStack.getClassName().split("\\.");
        String method = lastStack.getMethodName();
        int line = lastStack.getLineNumber();
        if (null == dateFormatThreadLocal.get()) {
            dateFormatThreadLocal.set(new SimpleDateFormat("HH:mm:ss.SSS", Locale.US));
        }
        return String.format(Locale.US, "[%s %s:%s():%d]", dateFormatThreadLocal.get().format(System.currentTimeMillis()), klass[klass.length - 1], method, line);
    }

    static {
        logWriters.add(new ConsoleLogWriter());
    }
}

