/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.util.Log;
import com.sendbird.android.LogLevel;
import com.sendbird.android.LogWriter;
import java.util.Locale;

final class ConsoleLogWriter
implements LogWriter {
    private static final int LOG_SEGMENT_SIZE = 2000;

    ConsoleLogWriter() {
    }

    @Override
    public int print(LogLevel level, String tag, String msg) {
        int writeLength;
        if (null == level || null == tag || null == msg) {
            throw new NullPointerException(String.format("one of level(%s), tag(%s), msg(%s) is null.", new Object[]{level, tag, msg}));
        }
        int continuedCount = 0;
        int totalPrintLen = 0;
        for (int currentIndex = 0; currentIndex < msg.length(); currentIndex += writeLength) {
            int remainingLength = msg.length() - currentIndex;
            writeLength = Math.min(remainingLength, 2000);
            totalPrintLen += ConsoleLogWriter.printLogPartially(level, tag, msg, currentIndex, writeLength, continuedCount);
            ++continuedCount;
        }
        return totalPrintLen;
    }

    private static int printLogPartially(LogLevel level, String tag, String msg, int from, int length, int continuedCount) {
        StringBuilder builder = new StringBuilder();
        if (continuedCount > 0) {
            builder.append(String.format(Locale.US, "Cont(%d) ", continuedCount));
        }
        builder.append(msg.substring(from, from + length));
        if (LogLevel.VERBOSE == level) {
            return Log.v((String)tag, (String)builder.toString());
        }
        if (LogLevel.DEBUG == level) {
            return Log.d((String)tag, (String)builder.toString());
        }
        if (LogLevel.INFO == level) {
            return Log.i((String)tag, (String)builder.toString());
        }
        if (LogLevel.WARN == level) {
            return Log.w((String)tag, (String)builder.toString());
        }
        if (LogLevel.ERROR == level) {
            return Log.e((String)tag, (String)builder.toString());
        }
        throw new IllegalArgumentException(String.format("unexpected level %s in print.", new Object[]{level}));
    }
}

