/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.ThreadInfo;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;

public class ThreadInfoUpdateEvent {
    private long targetMessageId;
    private final String channelUrl;
    private final BaseChannel.ChannelType channelType;
    private ThreadInfo threadInfo;

    ThreadInfoUpdateEvent(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        this.targetMessageId = obj.has("root_message_id") ? obj.get("root_message_id").getAsLong() : 0L;
        this.channelUrl = obj.has("channel_url") ? obj.get("channel_url").getAsString() : "";
        this.channelType = obj.has("channel_type") ? BaseChannel.ChannelType.fromValue(obj.get("channel_type").getAsString()) : BaseChannel.ChannelType.GROUP;
        this.threadInfo = obj.has("thread_info") ? new ThreadInfo(obj.get("thread_info")) : null;
    }

    JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("root_message_id", (Number)this.targetMessageId);
        obj.addProperty("channel_url", this.channelUrl);
        obj.addProperty("channel_type", this.channelType.value());
        if (this.threadInfo != null) {
            obj.add("thread_info", this.threadInfo.toJson());
        }
        return obj;
    }

    public long getTargetMessageId() {
        return this.targetMessageId;
    }

    public String getChannelUrl() {
        return this.channelUrl;
    }

    public BaseChannel.ChannelType getChannelType() {
        return this.channelType;
    }

    public ThreadInfo getThreadInfo() {
        return this.threadInfo;
    }

    public String toString() {
        return "ThreadInfoUpdateEvent{targetMessageId=" + this.targetMessageId + ", channelUrl='" + this.channelUrl + '\'' + ", channelType=" + (Object)((Object)this.channelType) + ", threadInfo=" + this.threadInfo + '}';
    }
}

