/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.HashUtils;
import com.sendbird.android.SendBird;
import com.sendbird.android.Sender;
import com.sendbird.android.ThreadInfo;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;

public final class FileMessage
extends BaseMessage {
    private String mUrl;
    private String mName;
    private int mSize;
    private String mType;
    private List<Thumbnail> mThumbnails;
    private boolean mRequireAuth;

    static FileMessage copiedInstance(String requestId, long rootMessageId, long parentMessageId, Sender sender, String channelUrl, BaseChannel.ChannelType channelType, String url, String name, String type, int size, String data, String customType, String thumbnails, boolean requireAuth, long createdAt, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, String mentionedUsers, String sortedMetaArray, ThreadInfo threadInfo, boolean isOpMsg) {
        JsonObject obj = BaseMessage.createJson(requestId, rootMessageId, parentMessageId, sender, channelUrl, channelType, data, customType, createdAt, mentionType, mentionedUserIds, mentionedUsers, sortedMetaArray, threadInfo, isOpMsg);
        obj.addProperty("require_auth", Boolean.valueOf(requireAuth));
        JsonObject file = new JsonObject();
        file.addProperty("url", url);
        file.addProperty("name", name);
        file.addProperty("type", type);
        file.addProperty("size", (Number)size);
        obj.add("file", (JsonElement)file);
        if (thumbnails != null) {
            obj.add("thumbnails", new JsonParser().parse(thumbnails));
        }
        return new FileMessage((JsonElement)obj);
    }

    FileMessage(JsonElement el) {
        super(el);
        JsonObject obj = el.getAsJsonObject();
        boolean bl = this.mRequireAuth = obj.has("require_auth") && obj.get("require_auth").getAsBoolean();
        if (obj.has("file")) {
            JsonObject file = obj.get("file").getAsJsonObject();
            this.mUrl = file.has("url") ? file.get("url").getAsString() : "";
            this.mName = file.has("name") ? file.get("name").getAsString() : "File";
            this.mSize = file.has("size") ? file.get("size").getAsInt() : 0;
            this.mType = file.has("type") ? file.get("type").getAsString() : "";
        } else {
            this.mUrl = obj.has("url") ? obj.get("url").getAsString() : "";
            this.mName = obj.has("name") ? obj.get("name").getAsString() : "File";
            this.mSize = obj.has("size") ? obj.get("size").getAsInt() : 0;
            this.mType = obj.has("type") ? obj.get("type").getAsString() : "";
        }
        this.mThumbnails = new ArrayList<Thumbnail>();
        if (obj.has("thumbnails")) {
            JsonArray thumbnailsArray = obj.get("thumbnails").getAsJsonArray();
            for (JsonElement element : thumbnailsArray) {
                this.mThumbnails.add(new Thumbnail(element, this.mRequireAuth));
            }
        }
    }

    @Override
    JsonElement toJson() {
        JsonObject obj = super.toJson().getAsJsonObject();
        obj.addProperty("type", BaseChannel.MessageTypeFilter.FILE.value());
        obj.addProperty("require_auth", Boolean.valueOf(this.mRequireAuth));
        JsonObject fileObj = new JsonObject();
        fileObj.addProperty("url", this.mUrl);
        fileObj.addProperty("name", this.mName);
        fileObj.addProperty("type", this.mType);
        fileObj.addProperty("size", (Number)this.mSize);
        fileObj.addProperty("data", this.mData);
        obj.add("file", (JsonElement)fileObj);
        JsonArray thumbnailObj = new JsonArray();
        for (Thumbnail thumbnail : this.mThumbnails) {
            thumbnailObj.add(thumbnail.toJson());
        }
        obj.add("thumbnails", (JsonElement)thumbnailObj);
        return obj;
    }

    boolean requiredAuth() {
        return this.mRequireAuth;
    }

    @Override
    public String getMessage() {
        return "File Message";
    }

    @Override
    public String getRequestId() {
        return this.mReqId;
    }

    public String getUrl() {
        if (this.mRequireAuth) {
            return String.format("%s?auth=%s", this.mUrl, SendBird.getEkey());
        }
        return this.mUrl;
    }

    public String getPlainUrl() {
        return this.mUrl;
    }

    public String getName() {
        return this.mName;
    }

    public int getSize() {
        return this.mSize;
    }

    public String getType() {
        return this.mType;
    }

    public List<Thumbnail> getThumbnails() {
        return this.mThumbnails;
    }

    @Deprecated
    public RequestState getRequestState() {
        if (this.getSendingStatus() == BaseMessage.SendingStatus.SUCCEEDED) {
            return RequestState.SUCCEEDED;
        }
        if (this.getSendingStatus() == BaseMessage.SendingStatus.FAILED) {
            return RequestState.FAILED;
        }
        if (this.getSendingStatus() == BaseMessage.SendingStatus.PENDING) {
            return RequestState.PENDING;
        }
        if (this.getSendingStatus() == BaseMessage.SendingStatus.CANCELED) {
            return RequestState.FAILED;
        }
        return RequestState.NONE;
    }

    public List<String> getRequestedMentionUserIds() {
        if (this.getSendingStatus() == BaseMessage.SendingStatus.PENDING || this.getSendingStatus() == BaseMessage.SendingStatus.FAILED || this.getSendingStatus() == BaseMessage.SendingStatus.CANCELED) {
            return this.getMentionedUserIds();
        }
        return new ArrayList<String>();
    }

    @Override
    public String toString() {
        return super.toString() + "\nFileMessage{, mUrl='" + this.mUrl + '\'' + ", mName='" + this.mName + '\'' + ", mSize=" + this.mSize + ", mType='" + this.mType + '\'' + ", mThumbnails=" + this.mThumbnails + ", mRequireAuth=" + this.mRequireAuth + '}';
    }

    public static class ThumbnailSize {
        private int mMaxWidth;
        private int mMaxHeight;

        public ThumbnailSize(int maxWidth, int maxHeight) {
            this.mMaxWidth = maxWidth >= 0 ? maxWidth : 0;
            this.mMaxHeight = maxHeight >= 0 ? maxHeight : 0;
        }

        public int getMaxWidth() {
            return this.mMaxWidth;
        }

        public int getMaxHeight() {
            return this.mMaxHeight;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ThumbnailSize size = (ThumbnailSize)o;
            return this.getMaxWidth() == size.getMaxWidth() && this.getMaxHeight() == size.getMaxHeight();
        }

        public int hashCode() {
            return HashUtils.generateHashCode(this.getMaxWidth(), this.getMaxHeight());
        }

        public String toString() {
            return "ThumbnailSize{mMaxWidth=" + this.mMaxWidth + ", mMaxHeight=" + this.mMaxHeight + '}';
        }
    }

    public static class Thumbnail {
        private int mMaxWidth;
        private int mMaxHeight;
        private int mRealWidth;
        private int mRealHeight;
        private String mUrl;
        private boolean mRequireAuth;

        private Thumbnail(JsonElement el, boolean requireAuth) {
            JsonObject obj = el.getAsJsonObject();
            this.mMaxWidth = obj.has("width") ? obj.get("width").getAsInt() : 0;
            this.mMaxHeight = obj.has("height") ? obj.get("height").getAsInt() : 0;
            this.mRealWidth = obj.has("real_width") ? obj.get("real_width").getAsInt() : -1;
            this.mRealHeight = obj.has("real_height") ? obj.get("real_height").getAsInt() : -1;
            this.mUrl = obj.has("url") ? obj.get("url").getAsString() : "";
            this.mRequireAuth = requireAuth;
        }

        public int getMaxWidth() {
            return this.mMaxWidth;
        }

        public int getMaxHeight() {
            return this.mMaxHeight;
        }

        public int getRealWidth() {
            return this.mRealWidth;
        }

        public int getRealHeight() {
            return this.mRealHeight;
        }

        public String getUrl() {
            if (this.mRequireAuth) {
                return String.format("%s?auth=%s", this.mUrl, SendBird.getEkey());
            }
            return this.mUrl;
        }

        public String getPlainUrl() {
            return this.mUrl;
        }

        JsonElement toJson() {
            JsonObject obj = new JsonObject();
            obj.addProperty("width", (Number)this.mMaxWidth);
            obj.addProperty("height", (Number)this.mMaxHeight);
            obj.addProperty("real_width", (Number)this.mRealWidth);
            obj.addProperty("real_height", (Number)this.mRealHeight);
            obj.addProperty("url", this.mUrl);
            return obj;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            Thumbnail other = (Thumbnail)o;
            return this.getMaxWidth() == other.getMaxWidth() && this.getMaxHeight() == other.getMaxHeight() && this.getRealWidth() == other.getRealWidth() && this.getRealHeight() == other.getRealHeight() && this.getUrl().equals(other.getUrl()) && this.mRequireAuth == other.mRequireAuth;
        }

        public int hashCode() {
            return HashUtils.generateHashCode(this.getMaxWidth(), this.getMaxHeight(), this.getRealWidth(), this.getRealHeight(), this.getUrl(), this.mRequireAuth);
        }

        public String toString() {
            return "Thumbnail{mMaxWidth=" + this.mMaxWidth + ", mMaxHeight=" + this.mMaxHeight + ", mRealWidth=" + this.mRealWidth + ", mRealHeight=" + this.mRealHeight + ", mUrl='" + this.mUrl + '\'' + ", mRequireAuth=" + this.mRequireAuth + '}';
        }
    }

    @Deprecated
    public static enum RequestState {
        NONE,
        PENDING,
        FAILED,
        SUCCEEDED;

    }
}

