/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.util.Base64;
import com.sendbird.android.HashUtils;
import com.sendbird.android.SendBird;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;

public class Emoji {
    private final String key;
    private final String url;

    Emoji(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        this.key = obj.has("key") ? obj.get("key").getAsString() : "";
        this.url = obj.has("url") ? obj.get("url").getAsString() : "";
    }

    JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("key", this.key);
        obj.addProperty("url", this.url);
        return obj;
    }

    public static Emoji buildFromSerializedData(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] copiedData = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            copiedData[i] = (byte)(data[i] ^ i & 0xFF);
        }
        try {
            String str = new String(Base64.decode((byte[])copiedData, (int)0), "UTF-8");
            return new Emoji(new JsonParser().parse(str));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Emoji emoji = (Emoji)o;
        return this.getKey().equals(emoji.getKey());
    }

    public int hashCode() {
        return HashUtils.generateHashCode(this.getKey());
    }

    public String toString() {
        return "Emoji{, key='" + this.key + '\'' + ", url='" + this.url + '\'' + '}';
    }
}

