/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.text.TextUtils;
import android.util.Base64;
import android.util.Pair;
import com.sendbird.android.APIClient;
import com.sendbird.android.APITaskQueue;
import com.sendbird.android.AdminMessage;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.Command;
import com.sendbird.android.FileMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.HashUtils;
import com.sendbird.android.JobResultTask;
import com.sendbird.android.MessageMetaArray;
import com.sendbird.android.MessageRetrievalParams;
import com.sendbird.android.OGMetaData;
import com.sendbird.android.Reaction;
import com.sendbird.android.ReactionEvent;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.Sender;
import com.sendbird.android.ThreadInfo;
import com.sendbird.android.ThreadInfoUpdateEvent;
import com.sendbird.android.ThreadMessageListParams;
import com.sendbird.android.User;
import com.sendbird.android.UserMessage;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseMessage {
    static final int NEVER_DELETED_AUTOMATICALLY = -1;
    protected static final Set<Integer> RESENDABLE_ERROR_CODES = new HashSet<Integer>(Arrays.asList(800101, 800120, 800180, 800200, 800210, 800400));
    protected String mReqId;
    protected long mMessageId;
    protected long rootMessageId;
    protected long parentMessageId;
    protected String mChannelUrl;
    protected BaseChannel.ChannelType channelType;
    protected String mMessage = "";
    protected String mData = "";
    protected String mCustomType = "";
    protected long mCreatedAt;
    protected long mUpdatedAt;
    protected BaseMessageParams.MentionType mMentionType = BaseMessageParams.MentionType.USERS;
    protected List<String> mMentionedUserIds;
    protected List<User> mMentionedUsers;
    protected List<MessageMetaArray> mMetaArrays;
    protected boolean mIsGlobalBlocked;
    protected int mErrorCode = 0;
    private boolean mIsSilent = false;
    private boolean forceUpdateLastMessage = false;
    private final List<Reaction> reactionList = new ArrayList<Reaction>();
    private SendingStatus sendingStatus = SendingStatus.NONE;
    private int messageSurvivalSeconds;
    private String parentMessageText;
    private ThreadInfo threadInfo;
    protected Sender mSender;
    private OGMetaData ogMetaData;
    private boolean isOperatorMessage;

    public static void getMessage(final MessageRetrievalParams params, final GetMessageHandler handler) {
        APITaskQueue.addTask(new JobResultTask<BaseMessage>(){

            @Override
            public BaseMessage call() throws Exception {
                if (params == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                JsonElement response = APIClient.getInstance().getMessage(params);
                return BaseMessage.createMessage(response, params.channelUrl, params.channelType);
            }

            @Override
            public void onResultForUiThread(BaseMessage msg, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(msg, e);
                }
            }
        });
    }

    public abstract String getRequestId();

    public String getMessage() {
        return this.mMessage;
    }

    public Sender getSender() {
        if (this.mSender == null) {
            return null;
        }
        if (SendBird.Options.useMemberAsMessageSender && GroupChannel.sCachedChannels.containsKey(this.mChannelUrl)) {
            GroupChannel channel = GroupChannel.sCachedChannels.get(this.mChannelUrl);
            User member = channel.mMemberMap.get(this.mSender.getUserId());
            if (member != null) {
                this.mSender.updatePropertiesByUser(member);
            }
        }
        return this.mSender;
    }

    void setSendingStatus(SendingStatus sendingStatus) {
        this.sendingStatus = sendingStatus;
    }

    public SendingStatus getSendingStatus() {
        return this.sendingStatus;
    }

    public boolean isResendable() {
        return this.sendingStatus == SendingStatus.CANCELED || this.sendingStatus == SendingStatus.FAILED && RESENDABLE_ERROR_CODES.contains(this.mErrorCode);
    }

    public static boolean belongsTo(BaseMessage message, String userId) {
        if (TextUtils.isEmpty((CharSequence)userId) || message == null) {
            return false;
        }
        Sender sender = message.mSender;
        return sender != null && userId.equalsIgnoreCase(sender.getUserId());
    }

    public static boolean belongsTo(BaseMessage message, User user) {
        if (user == null) {
            return false;
        }
        return BaseMessage.belongsTo(message, user.getUserId());
    }

    @Deprecated
    protected static BaseMessage build(JsonElement el, String channelUrl, String channelType) {
        return BaseMessage.createMessage(el, channelUrl, BaseChannel.ChannelType.fromValue(channelType));
    }

    static JsonObject createJson(String requestId, long rootMessageId, long parentMessageId, Sender sender, String channelUrl, BaseChannel.ChannelType channelType, String data, String customType, long createdAt, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, String mentionedUsers, String sortedMetaArray, ThreadInfo threadInfo, boolean isOpMsg) {
        JsonObject obj = new JsonObject();
        obj.addProperty("req_id", requestId);
        obj.addProperty("root_message_id", (Number)rootMessageId);
        obj.addProperty("parent_message_id", (Number)parentMessageId);
        obj.addProperty("channel_url", channelUrl);
        obj.addProperty("created_at", (Number)createdAt);
        obj.add("thread_info", threadInfo.toJson());
        obj.addProperty("is_op_msg", Boolean.valueOf(isOpMsg));
        if (channelType != null) {
            obj.addProperty("channel_type", channelType.value());
        }
        if (data != null) {
            obj.addProperty("data", data);
        }
        if (customType != null) {
            obj.addProperty("custom_type", customType);
        }
        if (sender != null) {
            JsonObject userObj = sender.toJson().getAsJsonObject();
            obj.add("user", (JsonElement)userObj);
        }
        if (mentionType != null) {
            obj.addProperty("mention_type", mentionType.getValue());
        }
        if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
            JsonArray array = new JsonArray();
            for (String mentionedUserId : mentionedUserIds) {
                if (mentionedUserId == null || mentionedUserId.length() <= 0) continue;
                array.add(mentionedUserId);
            }
            obj.add("mentioned_user_ids", (JsonElement)array);
        }
        if (mentionedUsers != null) {
            obj.add("mentioned_users", new JsonParser().parse(mentionedUsers));
        }
        if (sortedMetaArray != null) {
            obj.add("sorted_metaarray", new JsonParser().parse(sortedMetaArray));
        }
        return obj;
    }

    public BaseMessage(String channelUrl, long msgId, long createdAt) {
        this.mChannelUrl = channelUrl;
        this.mMessageId = msgId;
        this.mCreatedAt = createdAt;
    }

    protected BaseMessage(JsonElement el) {
        int i;
        JsonArray array;
        JsonElement user;
        JsonObject userObject;
        JsonObject file;
        JsonObject obj = el.getAsJsonObject();
        this.mChannelUrl = obj.has("channel_url") ? obj.get("channel_url").getAsString() : "";
        this.channelType = obj.has("channel_type") ? BaseChannel.ChannelType.fromValue(obj.get("channel_type").getAsString()) : BaseChannel.ChannelType.GROUP;
        this.mReqId = "";
        if (obj.has("request_id")) {
            this.mReqId = obj.get("request_id").getAsString();
        }
        if (obj.has("req_id")) {
            this.mReqId = obj.get("req_id").getAsString();
        }
        this.mMessageId = 0L;
        if (obj.has("message_id")) {
            this.mMessageId = obj.get("message_id").getAsLong();
        } else if (obj.has("msg_id")) {
            this.mMessageId = obj.get("msg_id").getAsLong();
        }
        this.rootMessageId = obj.has("root_message_id") ? obj.get("root_message_id").getAsLong() : 0L;
        this.parentMessageId = obj.has("parent_message_id") ? obj.get("parent_message_id").getAsLong() : 0L;
        this.parentMessageText = obj.has("parent_message_text") ? obj.get("parent_message_text").getAsString() : null;
        this.mMessage = obj.has("message") ? obj.get("message").getAsString() : "";
        this.mUpdatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
        this.mCustomType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : "";
        this.mIsSilent = obj.has("silent") && obj.get("silent").getAsBoolean();
        this.forceUpdateLastMessage = obj.has("force_update_last_message") && obj.get("force_update_last_message").getAsBoolean();
        this.messageSurvivalSeconds = obj.has("message_survival_seconds") ? obj.get("message_survival_seconds").getAsInt() : -1;
        this.ogMetaData = obj.get("og_tag") instanceof JsonObject ? new OGMetaData(obj.get("og_tag").getAsJsonObject()) : null;
        this.isOperatorMessage = obj.has("is_op_msg") && obj.get("is_op_msg").getAsBoolean();
        this.mIsGlobalBlocked = obj.has("is_global_block") && obj.get("is_global_block").getAsBoolean();
        this.mErrorCode = obj.has("error_code") ? obj.get("error_code").getAsInt() : 0;
        this.mCreatedAt = 0L;
        if (obj.has("ts")) {
            this.mCreatedAt = obj.get("ts").getAsLong();
        } else if (obj.has("created_at")) {
            this.mCreatedAt = obj.get("created_at").getAsLong();
        }
        this.mData = "";
        if (obj.has("data")) {
            this.mData = obj.get("data").getAsString();
        }
        if (obj.has("custom")) {
            this.mData = obj.get("custom").getAsString();
        }
        if (obj.has("file") && (file = obj.get("file").getAsJsonObject()).has("data")) {
            this.mData = file.get("data").getAsString();
        }
        JsonObject jsonObject = userObject = (user = obj.get("user")) != null && !user.isJsonNull() ? user.getAsJsonObject() : null;
        if (userObject != null) {
            Sender sender = this.mSender = userObject.has("user_id") || user.getAsJsonObject().has("guest_id") ? new Sender(user) : null;
        }
        if (obj.has("reactions")) {
            array = obj.getAsJsonArray("reactions");
            for (i = 0; i < array.size(); ++i) {
                Reaction reaction = new Reaction(array.get(i));
                if (reaction.getUserIds().size() <= 0) continue;
                this.addReaction(reaction);
            }
        }
        this.mMentionType = BaseMessageParams.MentionType.from(obj.has("mention_type") ? obj.get("mention_type").getAsString() : "");
        this.mMentionedUserIds = new ArrayList<String>();
        if (obj.has("mentioned_user_ids")) {
            array = obj.getAsJsonArray("mentioned_user_ids");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i) == null) continue;
                this.mMentionedUserIds.add(array.get(i).getAsString());
            }
        }
        this.mMentionedUsers = new ArrayList<User>();
        if (obj.has("mentioned_users")) {
            array = obj.getAsJsonArray("mentioned_users");
            for (i = 0; i < array.size(); ++i) {
                this.mMentionedUsers.add(new User(array.get(i)));
            }
        }
        this.mMetaArrays = new ArrayList<MessageMetaArray>();
        if (obj.has("metaarray")) {
            HashMap<String, MessageMetaArray> metaArrayMap = new HashMap<String, MessageMetaArray>();
            JsonObject metaArrayObj = obj.getAsJsonObject("metaarray");
            for (String key : metaArrayObj.keySet()) {
                if (key == null) continue;
                ArrayList<String> values = new ArrayList<String>();
                JsonArray array2 = metaArrayObj.get(key).getAsJsonArray();
                for (int i2 = 0; i2 < array2.size(); ++i2) {
                    String value = array2.get(i2).getAsString();
                    values.add(value);
                }
                metaArrayMap.put(key, new MessageMetaArray(key, values));
            }
            if (obj.has("metaarray_key_order")) {
                JsonArray metaArrayKeyOrderArray = obj.getAsJsonArray("metaarray_key_order");
                for (int i3 = 0; i3 < metaArrayKeyOrderArray.size(); ++i3) {
                    String orderedKey = metaArrayKeyOrderArray.get(i3).getAsString();
                    if (!metaArrayMap.containsKey(orderedKey)) continue;
                    this.mMetaArrays.add((MessageMetaArray)metaArrayMap.get(orderedKey));
                }
            } else {
                this.mMetaArrays.addAll(metaArrayMap.values());
            }
        } else if (obj.has("sorted_metaarray")) {
            JsonArray sortedMetaArray = obj.get("sorted_metaarray").getAsJsonArray();
            for (i = 0; i < sortedMetaArray.size(); ++i) {
                JsonArray valueArray;
                JsonObject metaArrayObj = sortedMetaArray.get(i).getAsJsonObject();
                String key = metaArrayObj.has("key") ? metaArrayObj.get("key").getAsString() : null;
                JsonArray jsonArray = valueArray = metaArrayObj.has("value") ? metaArrayObj.get("value").getAsJsonArray() : null;
                if (key == null) continue;
                ArrayList<String> value = new ArrayList<String>();
                if (valueArray != null) {
                    for (int j = 0; j < valueArray.size(); ++j) {
                        value.add(valueArray.get(j).getAsString());
                    }
                }
                this.mMetaArrays.add(new MessageMetaArray(key, value));
            }
        }
        this.threadInfo = obj.has("thread_info") ? new ThreadInfo(obj.get("thread_info")) : new ThreadInfo();
        this.sendingStatus = SendingStatus.NONE;
        if (obj.has("request_state")) {
            this.sendingStatus = SendingStatus.fromValue(obj.get("request_state").getAsString());
        }
        if (this.sendingStatus == SendingStatus.NONE && this.mMessageId > 0L) {
            this.sendingStatus = SendingStatus.SUCCEEDED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JsonElement toJson() {
        JsonArray array;
        JsonObject obj = new JsonObject();
        obj.addProperty("channel_url", this.mChannelUrl);
        obj.addProperty("channel_type", this.channelType.value());
        obj.addProperty("req_id", this.mReqId);
        obj.addProperty("message_id", (Number)this.mMessageId);
        obj.addProperty("root_message_id", (Number)this.rootMessageId);
        obj.addProperty("parent_message_id", (Number)this.parentMessageId);
        obj.addProperty("created_at", (Number)this.mCreatedAt);
        obj.addProperty("updated_at", (Number)this.mUpdatedAt);
        obj.addProperty("message", this.mMessage);
        obj.addProperty("data", this.mData);
        obj.addProperty("custom_type", this.mCustomType);
        obj.addProperty("mention_type", this.mMentionType.getValue());
        obj.addProperty("message_survival_seconds", (Number)this.messageSurvivalSeconds);
        obj.addProperty("silent", Boolean.valueOf(this.mIsSilent));
        obj.addProperty("force_update_last_message", Boolean.valueOf(this.forceUpdateLastMessage));
        obj.addProperty("is_global_block", Boolean.valueOf(this.mIsGlobalBlocked));
        obj.addProperty("error_code", (Number)this.mErrorCode);
        obj.add("thread_info", this.threadInfo.toJson());
        obj.addProperty("is_op_msg", Boolean.valueOf(this.isOperatorMessage));
        obj.addProperty("request_state", this.sendingStatus.getValue());
        if (this.parentMessageText != null) {
            obj.addProperty("parent_message_text", this.parentMessageText);
        }
        if (this.mSender != null) {
            obj.add("user", this.mSender.toJson());
        }
        if (this.mMentionedUserIds != null && this.mMentionedUserIds.size() > 0) {
            array = new JsonArray();
            for (String string : this.mMentionedUserIds) {
                if (string == null) continue;
                array.add(string);
            }
            obj.add("mentioned_user_ids", (JsonElement)array);
        }
        if (this.mMentionedUsers != null && this.mMentionedUsers.size() > 0) {
            array = new JsonArray();
            for (User user : this.mMentionedUsers) {
                if (user == null) continue;
                array.add(user.toJson());
            }
            obj.add("mentioned_users", (JsonElement)array);
        }
        if (this.reactionList.size() > 0) {
            array = new JsonArray();
            Iterator<MessageMetaArray> iterator = this.reactionList;
            synchronized (iterator) {
                for (Reaction reaction : this.reactionList) {
                    if (reaction == null) continue;
                    array.add(reaction.toJson());
                }
            }
            obj.add("reactions", (JsonElement)array);
        }
        if (this.mMetaArrays != null && this.mMetaArrays.size() > 0) {
            JsonArray sortedMetaArray = new JsonArray();
            for (MessageMetaArray messageMetaArray : this.mMetaArrays) {
                sortedMetaArray.add((JsonElement)messageMetaArray.toJson());
            }
            obj.add("sorted_metaarray", (JsonElement)sortedMetaArray);
        }
        if (this.ogMetaData != null) {
            obj.add("og_tag", this.ogMetaData.toJson());
        }
        return obj;
    }

    public static BaseMessage buildFromSerializedData(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] copiedData = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            copiedData[i] = (byte)(data[i] ^ i & 0xFF);
        }
        try {
            String str = new String(Base64.decode((byte[])copiedData, (int)0), "UTF-8");
            JsonObject obj = new JsonParser().parse(str).getAsJsonObject();
            return BaseMessage.createMessage((JsonElement)obj, obj.get("channel_url").getAsString(), BaseChannel.ChannelType.fromValue(obj.get("channel_type").getAsString()));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BaseMessage buildFromSerializedData(byte[] data, SendingStatus desiredState) {
        if (data == null) {
            return null;
        }
        byte[] copiedData = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            copiedData[i] = (byte)(data[i] ^ i & 0xFF);
        }
        try {
            String str = new String(Base64.decode((byte[])copiedData, (int)0), "UTF-8");
            JsonObject obj = new JsonParser().parse(str).getAsJsonObject();
            BaseMessage msg = BaseMessage.createMessage((JsonElement)obj, obj.get("channel_url").getAsString(), BaseChannel.ChannelType.fromValue(obj.get("channel_type").getAsString()));
            SendingStatus originalState = msg.getSendingStatus();
            msg.setSendingStatus(desiredState);
            if (SendingStatus.PENDING == desiredState || SendingStatus.SUCCEEDED == desiredState) {
                msg.setErrorCode(0);
            } else if (SendingStatus.FAILED == desiredState && SendingStatus.PENDING == originalState) {
                msg.setErrorCode(800400);
            }
            return msg;
        }
        catch (UnsupportedEncodingException e) {
            Logger.e(e);
            return null;
        }
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getMessageId() {
        return this.mMessageId;
    }

    long getRootMessageId() {
        return this.rootMessageId;
    }

    public long getParentMessageId() {
        return this.parentMessageId;
    }

    public long getCreatedAt() {
        return this.mCreatedAt;
    }

    public long getUpdatedAt() {
        return this.mUpdatedAt;
    }

    public BaseMessageParams.MentionType getMentionType() {
        return this.mMentionType;
    }

    public List<User> getMentionedUsers() {
        return this.mMentionedUsers;
    }

    List<String> getMentionedUserIds() {
        ArrayList<String> mentionedUserIds = null;
        if (this.sendingStatus != SendingStatus.SUCCEEDED && this.mMentionedUserIds != null && this.mMentionedUserIds.size() > 0) {
            mentionedUserIds = new ArrayList<String>(this.mMentionedUserIds);
            return mentionedUserIds;
        }
        if (this.mMentionedUsers != null && this.mMentionedUsers.size() > 0) {
            mentionedUserIds = new ArrayList();
            for (User mentionedUser : this.mMentionedUsers) {
                if (mentionedUser == null || mentionedUser.getUserId() == null || mentionedUser.getUserId().length() <= 0) continue;
                mentionedUserIds.add(mentionedUser.getUserId());
            }
        }
        return mentionedUserIds;
    }

    boolean isMentionedFromSomeoneToMe() {
        String currentUserId;
        boolean result = false;
        String string = currentUserId = SendBird.getCurrentUser() != null ? SendBird.getCurrentUser().getUserId() : null;
        if (!BaseMessage.belongsTo(this, SendBird.getCurrentUser())) {
            if (this.mMentionType == BaseMessageParams.MentionType.CHANNEL) {
                result = true;
            } else if (currentUserId != null && currentUserId.length() > 0 && this.mMentionedUsers != null && this.mMentionedUsers.size() > 0) {
                for (User mentionedUser : this.mMentionedUsers) {
                    if (!mentionedUser.getUserId().equals(currentUserId)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    BaseChannel.ChannelType getChannelType() {
        return this.channelType;
    }

    public String getChannelUrl() {
        return this.mChannelUrl;
    }

    public boolean isOpenChannel() {
        return this.channelType == BaseChannel.ChannelType.OPEN;
    }

    public boolean isGroupChannel() {
        return this.channelType == BaseChannel.ChannelType.GROUP;
    }

    public String getData() {
        return this.mData;
    }

    public String getCustomType() {
        return this.mCustomType;
    }

    public List<Reaction> getReactions() {
        return Collections.unmodifiableList(this.reactionList);
    }

    @Deprecated
    public Map<String, List<String>> getAllMetaArray() {
        HashMap<String, List<String>> metaArrayMap = new HashMap<String, List<String>>();
        for (MessageMetaArray metaArray : this.mMetaArrays) {
            metaArrayMap.put(metaArray.getKey(), metaArray.getValue());
        }
        return metaArrayMap;
    }

    public List<MessageMetaArray> getAllMetaArrays() {
        return new ArrayList<MessageMetaArray>(this.mMetaArrays);
    }

    @Deprecated
    public Map<String, List<String>> getMetaArray(Collection<String> metaArrayKeys) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        List<MessageMetaArray> metaArrays = this.getMetaArrays(metaArrayKeys);
        for (MessageMetaArray metaArray : metaArrays) {
            resultMap.put(metaArray.getKey(), metaArray.getValue());
        }
        return resultMap;
    }

    public List<MessageMetaArray> getMetaArrays(Collection<String> metaArrayKeys) {
        ArrayList<MessageMetaArray> metaArrays = new ArrayList<MessageMetaArray>();
        if (this.mMetaArrays != null && metaArrayKeys != null && metaArrayKeys.size() > 0) {
            for (String key : metaArrayKeys) {
                MessageMetaArray metaArray = this.getMetaArrayByKey(key);
                if (metaArray == null) continue;
                metaArrays.add(metaArray);
            }
        }
        return metaArrays;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    void setErrorCode(int errorCode) {
        this.mErrorCode = errorCode;
    }

    public int getMessageSurvivalSeconds() {
        return this.messageSurvivalSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReaction(Reaction reaction) {
        List<Reaction> list = this.reactionList;
        synchronized (list) {
            this.reactionList.add(reaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReaction(Reaction reaction) {
        List<Reaction> list = this.reactionList;
        synchronized (list) {
            this.reactionList.remove(reaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reaction getReaction(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        List<Reaction> list = this.reactionList;
        synchronized (list) {
            for (Reaction reaction : this.reactionList) {
                if (!key.equals(reaction.getKey())) continue;
                return reaction;
            }
        }
        return null;
    }

    public boolean applyReactionEvent(ReactionEvent reactionEvent) {
        if (reactionEvent == null) {
            return false;
        }
        if (this.mMessageId != reactionEvent.getMessageId()) {
            return false;
        }
        String key = reactionEvent.getKey();
        Reaction reaction = this.getReaction(key);
        if (reaction != null) {
            if (reaction.merge(reactionEvent)) {
                if (reactionEvent.getOperation() == ReactionEvent.ReactionEventAction.DELETE && reaction.getUserIds().size() == 0) {
                    this.removeReaction(reaction);
                }
                return true;
            }
            return false;
        }
        if (reactionEvent.getOperation() == ReactionEvent.ReactionEventAction.ADD) {
            this.addReaction(new Reaction(reactionEvent));
            return true;
        }
        return false;
    }

    public boolean applyThreadInfoUpdateEvent(ThreadInfoUpdateEvent threadInfoUpdateEvent) {
        if (threadInfoUpdateEvent == null || threadInfoUpdateEvent.getTargetMessageId() != this.mMessageId) {
            return false;
        }
        if (threadInfoUpdateEvent.getThreadInfo() != null) {
            return this.threadInfo.merge(threadInfoUpdateEvent.getThreadInfo());
        }
        this.threadInfo = new ThreadInfo();
        return true;
    }

    public void getThreadedMessagesByTimestamp(final long ts, final ThreadMessageListParams params, final GetThreadedMessagesHandler handler) {
        APITaskQueue.addTask(new JobResultTask<Pair<BaseMessage, List<BaseMessage>>>(){

            @Override
            public Pair<BaseMessage, List<BaseMessage>> call() throws Exception {
                if (params == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                String msgType = params.messageType == null || params.messageType == BaseChannel.MessageTypeFilter.ALL ? null : params.messageType.value();
                LinkedHashSet<String> senderUserIdsSet = null;
                if (params.senderUserIds != null) {
                    senderUserIdsSet = new LinkedHashSet<String>(params.senderUserIds);
                }
                JsonElement response = APIClient.getInstance().messageList(BaseMessage.this.isOpenChannel(), BaseMessage.this.mChannelUrl, BaseMessage.this.mMessageId, ts, params.previousResultSize, params.nextResultSize, params.isInclusive, params.reverse, msgType, params.customType, params.customTypes, senderUserIdsSet, params.includeMetaArray, params.includeReactions, true, true, params.includeParentMessageText, false);
                JsonObject result = response.getAsJsonObject();
                JsonArray objs = result.get("messages").getAsJsonArray();
                ArrayList<BaseMessage> messages = new ArrayList<BaseMessage>();
                boolean parentMessageIndex = false;
                BaseMessage parentMessage = BaseMessage.createMessage(objs.get(0), BaseMessage.this.mChannelUrl, BaseMessage.this.channelType);
                for (int i = 1; i < objs.size(); ++i) {
                    BaseMessage msg = BaseMessage.createMessage(objs.get(i), BaseMessage.this.mChannelUrl, BaseMessage.this.channelType);
                    if (msg == null) continue;
                    messages.add(msg);
                }
                return new Pair((Object)parentMessage, messages);
            }

            @Override
            public void onResultForUiThread(Pair<BaseMessage, List<BaseMessage>> result, SendBirdException e) {
                if (handler != null) {
                    BaseMessage message = result == null ? null : (BaseMessage)result.first;
                    List messages = result == null ? null : (List)result.second;
                    handler.onResult(message, messages, e);
                }
            }
        });
    }

    public ThreadInfo getThreadInfo() {
        return this.threadInfo;
    }

    public String getParentMessageText() {
        return this.parentMessageText;
    }

    MessageMetaArray getMetaArrayByKey(String key) {
        if (key == null) {
            return null;
        }
        for (MessageMetaArray metaArray : this.mMetaArrays) {
            if (!key.equals(metaArray.getKey())) continue;
            return metaArray;
        }
        return null;
    }

    void addMetaArray(String key) {
        this.addMetaArray(key, new ArrayList<String>());
    }

    void addMetaArray(String key, List<String> value) {
        if (key == null) {
            return;
        }
        for (MessageMetaArray metaArray : this.mMetaArrays) {
            if (!key.equals(metaArray.getKey())) continue;
            return;
        }
        this.mMetaArrays.add(new MessageMetaArray(key, value));
    }

    void setMetaArray(String key, List<String> value) {
        if (key == null) {
            return;
        }
        for (MessageMetaArray metaArray : this.mMetaArrays) {
            if (!key.equals(metaArray.getKey())) continue;
            metaArray.setValue(value);
            return;
        }
        this.mMetaArrays.add(new MessageMetaArray(key, value));
    }

    void removeMetaArrayByKey(String key) {
        if (key == null) {
            return;
        }
        for (int i = 0; i < this.mMetaArrays.size(); ++i) {
            if (!key.equals(this.mMetaArrays.get(i).getKey())) continue;
            this.mMetaArrays.remove(i);
            break;
        }
    }

    public boolean isSilent() {
        return this.mIsSilent;
    }

    boolean shouldForceUpdateLastMessage() {
        return this.forceUpdateLastMessage;
    }

    public OGMetaData getOgMetaData() {
        return this.ogMetaData;
    }

    public boolean isOperatorMessage() {
        return this.isOperatorMessage;
    }

    void setIsOperatorMessage(boolean isOperatorMessage) {
        this.isOperatorMessage = isOperatorMessage;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        BaseMessage message = (BaseMessage)o;
        if (this.getMessageId() != message.getMessageId() || !this.getChannelUrl().equals(message.getChannelUrl()) || this.getCreatedAt() != message.getCreatedAt()) {
            return false;
        }
        if (this.getMessageId() == 0L && message.getMessageId() == 0L) {
            return this.getRequestId().equals(message.getRequestId());
        }
        return true;
    }

    public int hashCode() {
        return HashUtils.generateHashCode(this.getMessageId(), this.getChannelUrl(), this.getCreatedAt(), this.getRequestId());
    }

    protected static BaseMessage createMessage(JsonElement el, String channelUrl, BaseChannel.ChannelType channelType) {
        JsonObject obj = el.getAsJsonObject();
        obj.addProperty("channel_url", channelUrl);
        obj.addProperty("channel_type", channelType != null ? channelType.value() : BaseChannel.ChannelType.GROUP.value());
        String type = obj.get("type").getAsString();
        return BaseMessage.createMessage(type, (JsonElement)obj);
    }

    static BaseMessage createMessage(Command command) {
        BaseMessage msg = BaseMessage.createMessage(command.getCommandType().name(), command.getJsonElement());
        if (msg != null) {
            msg.setSendingStatus(SendingStatus.SUCCEEDED);
        }
        return msg;
    }

    private static BaseMessage createMessage(String messageType, JsonElement payload) {
        BaseMessage msg = null;
        switch (messageType) {
            case "MESG": 
            case "MEDI": {
                msg = new UserMessage(payload);
                break;
            }
            case "FILE": 
            case "FEDI": {
                msg = new FileMessage(payload);
                break;
            }
            case "BRDM": 
            case "ADMM": 
            case "AEDI": {
                msg = new AdminMessage(payload);
                break;
            }
            default: {
                Logger.d("Discard a command: " + messageType);
            }
        }
        return msg;
    }

    public String toString() {
        return "BaseMessage{mReqId='" + this.mReqId + '\'' + ", mMessageId=" + this.mMessageId + ", parentMessageId='" + this.parentMessageId + '\'' + ", mChannelUrl='" + this.mChannelUrl + '\'' + ", channelType='" + (Object)((Object)this.channelType) + '\'' + ", mMessage='" + this.mMessage + '\'' + ", mData='" + this.mData + '\'' + ", mCustomType='" + this.mCustomType + '\'' + ", mCreatedAt=" + this.mCreatedAt + ", mUpdatedAt=" + this.mUpdatedAt + ", mMentionType=" + (Object)((Object)this.mMentionType) + ", mMentionedUserIds=" + this.mMentionedUserIds + ", mMentionedUsers=" + this.mMentionedUsers + ", mMetaArrays=" + this.mMetaArrays + ", mIsGlobalBlocked=" + this.mIsGlobalBlocked + ", mErrorCode=" + this.mErrorCode + ", mIsSilent=" + this.mIsSilent + ", forceUpdateLastMessage=" + this.forceUpdateLastMessage + ", reactionList=" + this.reactionList + ", sendingStatus=" + (Object)((Object)this.sendingStatus) + ", messageSurvivalSeconds=" + this.messageSurvivalSeconds + ", parentMessageText=" + this.parentMessageText + ", threadInfo=" + this.threadInfo + ", mSender=" + this.mSender + ", ogMetaData=" + this.ogMetaData + ", isOpMsg=" + this.isOperatorMessage + '}';
    }

    public static BaseMessage clone(BaseMessage msg) {
        return BaseMessage.createMessage(msg.toJson(), msg.getChannelUrl(), msg.getChannelType());
    }

    public static interface GetMessageHandler {
        public void onResult(BaseMessage var1, SendBirdException var2);
    }

    public static interface GetThreadedMessagesHandler {
        public void onResult(BaseMessage var1, List<BaseMessage> var2, SendBirdException var3);
    }

    public static enum SendingStatus {
        NONE("none"),
        PENDING("pending"),
        FAILED("failed"),
        SUCCEEDED("succeeded"),
        CANCELED("canceled");

        private String value;

        private SendingStatus(String value) {
            this.value = value;
        }

        public static SendingStatus fromValue(String value) {
            for (SendingStatus status : SendingStatus.values()) {
                if (!status.getValue().equals(value)) continue;
                return status;
            }
            return NONE;
        }

        public String getValue() {
            return this.value;
        }
    }
}

