/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.content.Context;
import android.text.TextUtils;
import com.sendbird.android.APIClient;
import com.sendbird.android.APITaskQueue;
import com.sendbird.android.AbstractPushHandler;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.JobTask;
import com.sendbird.android.OnPushTokenReceiveListener;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.log.Logger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONObject;

public class SendBirdPushHelper {
    private static AbstractPushHandler handler;
    private static final AtomicReference<String> registerdToken;
    private static final AtomicReference<RegisterTokenStatus> tokenStatus;
    private static final Map<Long, Long> delieverdMessageCache;

    static void retryPendingAction() {
        Logger.d(">> SendBirdPushHelper::retryPendingAction() tokenStatus : " + tokenStatus);
        if (tokenStatus.get() == RegisterTokenStatus.NeedToRegisterPushToken) {
            SendBirdPushHelper.registerPushToken();
        }
    }

    private static void registerPushToken() {
        if (handler == null) {
            return;
        }
        handler.getToken(new OnPushTokenReceiveListener(){

            @Override
            public void onReceived(String token, SendBirdException e) {
                SendBirdPushHelper.registerPushToken(token, handler.isUniquePushToken(), null);
            }
        });
    }

    static void registerPushToken(final String token, boolean unique, final OnPushRequestCompleteListener listener) {
        SendBirdPushHelper.changeTokenStatus(RegisterTokenStatus.NeedToRegisterPushToken, token);
        if (!SendBird.isInitialized() || SendBird.getCurrentUser() == null) {
            Logger.d("SendBird is initialized : " + SendBird.isInitialized());
            Logger.d(">> SendBirdPushHelper::registerPushToken(). Connection must be made");
            if (listener != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onError(new SendBirdException("Connection must be made.", 800101));
                        }
                    }
                });
            }
            return;
        }
        Logger.d(">> SendBirdPushHelper::registerPushToken()");
        if (!TextUtils.isEmpty((CharSequence)token) && !token.equals(registerdToken.get())) {
            Logger.d("++ requested token : " + token + ", unique : " + unique);
            if (handler != null) {
                handler.registerPushToken(token, unique, new SendBird.RegisterPushTokenWithStatusHandler(){

                    @Override
                    public void onRegistered(SendBird.PushTokenRegistrationStatus status, SendBirdException e) {
                        if (e != null) {
                            Logger.e(e);
                            if (e.getCode() == 400111) {
                                SendBirdPushHelper.changeTokenStatus(RegisterTokenStatus.Empty, token);
                            }
                            if (listener != null) {
                                listener.onError(e);
                            }
                            return;
                        }
                        SendBirdPushHelper.changeTokenStatus(RegisterTokenStatus.PushTokenRegistered, token);
                        if (listener != null) {
                            listener.onComplete(true, token);
                        }
                    }
                });
            }
        } else {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (listener != null) {
                        if (TextUtils.isEmpty((CharSequence)token)) {
                            listener.onError(new SendBirdException("token is null. you have to fill token value."));
                        } else {
                            listener.onComplete(false, token);
                        }
                    }
                }
            });
        }
    }

    private static void unregisterPushToken(boolean unRegisterAll, final String token, final OnPushRequestCompleteListener listener) {
        Logger.d(">> SendBirdPushHelper::unregisterPushToken(). unregisterAll : " + unRegisterAll + ", token : " + token);
        Logger.d("++ token : " + token);
        if (TextUtils.isEmpty((CharSequence)token)) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (listener != null) {
                        listener.onError(new SendBirdException("token is null. you have to fill token value."));
                    }
                }
            });
            return;
        }
        if (SendBird.getCurrentUser() == null) {
            if (listener != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onError(new SendBirdException("Connection must be made.", 800101));
                        }
                    }
                });
            }
            return;
        }
        if (unRegisterAll) {
            APITaskQueue.addTask(new JobTask<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        APIClient.getInstance().unregisterPushTokenAll();
                    }
                    catch (SendBirdException e) {
                        SendBirdPushHelper.processUnRegisterPushToken(token, listener, e);
                    }
                    return true;
                }
            });
        } else if (handler != null) {
            handler.unregisterPushToken(token, new SendBird.UnregisterPushTokenHandler(){

                @Override
                public void onUnregistered(SendBirdException e) {
                    SendBirdPushHelper.processUnRegisterPushToken(token, listener, e);
                }
            });
        }
    }

    private static void processUnRegisterPushToken(final String token, final OnPushRequestCompleteListener listener, final SendBirdException e) {
        SendBird.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                if (e != null) {
                    Logger.e(e);
                    if (e.getCode() == 400111) {
                        SendBirdPushHelper.changeTokenStatus(RegisterTokenStatus.Empty, token);
                    }
                    if (listener != null) {
                        listener.onError(e);
                    }
                    return;
                }
                SendBirdPushHelper.changeTokenStatus(RegisterTokenStatus.Empty, token);
                if (listener != null) {
                    listener.onComplete(false, null);
                }
            }
        });
    }

    public static <T extends AbstractPushHandler> void registerPushHandler(T handler) {
        Logger.d(">> SendBirdPushHelper::registerPushHandler()");
        SendBirdPushHelper.handler = handler;
        delieverdMessageCache.clear();
        SendBirdPushHelper.registerPushToken();
    }

    public static void unregisterPushHandler(OnPushRequestCompleteListener listener) {
        SendBirdPushHelper.unregisterPushHandler(false, listener);
    }

    public static void unregisterPushHandler(final boolean unRegisterAll, final OnPushRequestCompleteListener listener) {
        Logger.d(">> SendBirdPushHelper::unregisterPushHandler()");
        if (handler == null) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (listener != null) {
                        listener.onError(new SendBirdException("Already unregistered", 800110));
                    }
                }
            });
            return;
        }
        final OnPushRequestCompleteListener callback = new OnPushRequestCompleteListener(){

            @Override
            public void onComplete(boolean isRegistered, String token) {
                handler = null;
                delieverdMessageCache.clear();
                if (listener != null) {
                    listener.onComplete(isRegistered, token);
                }
            }

            @Override
            public void onError(SendBirdException e) {
                if (e.getCode() == 400111) {
                    if (listener != null) {
                        listener.onComplete(false, null);
                    }
                    return;
                }
                if (listener != null) {
                    listener.onError(e);
                }
            }
        };
        String currentPushToken = registerdToken.get();
        if (!TextUtils.isEmpty((CharSequence)currentPushToken)) {
            SendBirdPushHelper.unregisterPushToken(unRegisterAll, currentPushToken, callback);
            return;
        }
        handler.getToken(new OnPushTokenReceiveListener(){

            @Override
            public void onReceived(String token, final SendBirdException e) {
                if (e != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(e);
                        }
                    });
                    return;
                }
                SendBirdPushHelper.unregisterPushToken(unRegisterAll, token, callback);
            }
        });
    }

    public static boolean isDuplicateMessage(Object remoteMessage) {
        try {
            Long msgId;
            JSONObject sendBird;
            if (handler != null && (sendBird = handler.getPayload(remoteMessage)) != null && delieverdMessageCache.get(msgId = Long.valueOf(sendBird.optLong("message_id"))) != null) {
                Logger.d("__duplicated sendbird message. [" + msgId + "]");
                return true;
            }
        }
        catch (Exception e) {
            Logger.e(e);
        }
        return false;
    }

    static void messageDelivered(BaseMessage message) {
        Logger.d(">> SendBirdPushHelper::messageDeleivered()");
        Logger.d("++ MsgId : " + message.getMessageId());
        long msgId = message.getMessageId();
        delieverdMessageCache.put(msgId, msgId);
    }

    static void onNewToken(String token) {
        Logger.d("onNewToken: " + token + ", handler : " + handler);
        if (handler != null) {
            handler.onTokenUpdated(token);
        }
    }

    static void onMessageReceived(Context context, Object remoteMessage) {
        Logger.d(">> SendBirdPushHelper::onMessageReceived(). remoteMessage : " + remoteMessage.getClass().getName());
        if (SendBirdPushHelper.isSendBirdMessage(remoteMessage)) {
            Logger.d("Sendbird message.");
            if (SendBirdPushHelper.isDuplicateMessage(remoteMessage)) {
                Logger.d("duplicate message");
                return;
            }
            Logger.d("SDK init : %s, connectionState : %s, appState : %s", new Object[]{SendBird.isInitialized(), SendBird.getConnectionState(), SendBird.getAppState()});
            if (SendBird.isInitialized() ? SendBird.getConnectionState() == SendBird.ConnectionState.OPEN && SendBird.getAppState() == SendBird.AppState.FOREGROUND : SendBird.getConnectionState() == SendBird.ConnectionState.OPEN) {
                return;
            }
        }
        if (handler != null) {
            handler.onMessageReceived(context, remoteMessage);
        }
    }

    private static boolean isSendBirdMessage(Object remoteMessage) {
        if (handler != null) {
            return handler.isSendBirdMessage(remoteMessage);
        }
        return false;
    }

    public static void getPushToken(OnPushTokenReceiveListener listener) {
        if (handler != null) {
            handler.getToken(listener);
        }
    }

    private static synchronized void changeTokenStatus(RegisterTokenStatus status, String currentToken) {
        Logger.i("changeTokenStatus to : " + (Object)((Object)status) + ", currentToken : " + currentToken, new Object[0]);
        tokenStatus.set(status);
        switch (status) {
            case PushTokenRegistered: {
                registerdToken.set(currentToken);
                break;
            }
            case NeedToRegisterPushToken: 
            case Empty: {
                registerdToken.set(null);
                break;
            }
        }
    }

    static {
        registerdToken = new AtomicReference();
        tokenStatus = new AtomicReference<RegisterTokenStatus>(RegisterTokenStatus.Empty);
        delieverdMessageCache = new ConcurrentHashMap<Long, Long>();
    }

    public static interface OnPushRequestCompleteListener {
        public void onComplete(boolean var1, String var2);

        public void onError(SendBirdException var1);
    }

    private static enum RegisterTokenStatus {
        Empty,
        PushTokenRegistered,
        NeedToRegisterPushToken;

    }
}

